%%
%% This is file `rfmsi.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% rfmsi.dtx  (with options: `master')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2007 by Robert Nyqvist.
%% 
%% Class for typesetting master theses at School of Mathematics and
%% System Engineering, Vxj University.
%% 
%% Any modified version of this file must be renamed
%% with new filename distinct from rfmsi.cls.
%% 
\NeedsTeXFormat{LaTeX2e}[2001/06/01]
\ProvidesClass{rfmsi}
\ProvidesFile{rfmsi.drv}
  [2007/05/29 2.1 Class for Reports from MSI]
\DeclareOption{a5paper}
  {\ClassError{rfmsi}{Option `a5paper' is not supported}}
\DeclareOption{b5paper}
  {\ClassError{rfmsi}{Option `b5paper' is not supported}{}}
\DeclareOption{letterpaper}
  {\ClassError{rfmsi}{Option `letterpaper' is not supported}{}}
\DeclareOption{legalpaper}
  {\ClassError{rfmsi}{Option `legalpaper' is not supported}{}}
\DeclareOption{executivepaper}
  {\ClassError{rfmsi}{Option `executivepaper' is not supported}{}}
\DeclareOption{landscape}
  {\ClassError{rfmsi}{Option `landscape' is not supported}{}}
\DeclareOption{10pt}
  {\ClassError{rfmsi}{Option `10pt' is not supported}{}}
\DeclareOption{11pt}
  {\ClassError{rfmsi}{Option `11pt' is not supported}{}}
\DeclareOption{twocolumn}
  {\ClassError{rfmsi}{Option `twocolumn' is not supported}{}}
\DeclareOption{oneside}
  {\ClassError{rfmsi}{Option `oneside' is not supported}{}}
\DeclareOption{notitlepage}
  {\ClassError{rfmsi}{Option `notitlepage' is not supported}{}}
\DeclareOption{titlepage}
  {\ClassError{rfmsi}{Option `titlepage' is not supported}{}}
\DeclareOption{leqno}
  {\ClassError{rfmsi}{Option `leqno' is not supported}{}}
\DeclareOption{fleqn}
  {\ClassError{rfmsi}{Option `fleqn' is not supported}{}}
\DeclareOption{openbib}
  {\ClassError{rfmsi}{Option `openbib' is not supported}{}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
\LoadClass[12pt,a4paper,onecolumn,twoside]{article}
\RequirePackage{ifpdf}
\ifpdf
  \RequirePackage[pdftex]{graphicx}
  \pdfadjustspacing 1
  \AtBeginDocument{%
    \DeclareGraphicsExtensions{.mps,.pdf,.jpg,.png}%
    \DeclareGraphicsRule{*}{mps}{*}{}%
  }
\else
  \RequirePackage[dvips]{graphicx}
  \AtBeginDocument{%
    \DeclareGraphicsExtensions{.mps,.eps}%
    \DeclareGraphicsRule{*}{eps}{*}{}%
  }
\fi
\RequirePackage{geometry}
\geometry{%
  twoside,
  a4paper,
  left=3cm,
  right=3cm,
  top=2cm,
  bottom=2.5cm,
  hcentering,
  bindingoffset=0pt,
  footskip=10mm,
  nohead
}
\RequirePackage{fancyhdr}
\fancyfoot{}
\fancyhead{}
\fancyfoot[C]{\thepage}
\renewcommand{\headrulewidth}{\z@}
\renewcommand{\footrulewidth}{\z@}
\pagestyle{fancy}
\newcommand\mainmatter{%
  \cleardoublepage
  \pagenumbering{arabic}%
}
\renewcommand*{\title}[2][\opttitle]{%
  \def\opttitle{#2}%
  \gdef\@titlei{#1}%
  \gdef\@titleii{#2}%
}
\newcommand*{\subtitle}[2][\optsubtitle]{%
  \def\optsubtitle{#2}%
  \gdef\@subtitlei{#1}%
  \gdef\@subtitleii{#2}%
}
\let\@subtitlei\@empty
\let\@subtitleii\@empty
\newcommand*{\publmonth}[1]{\gdef\@publmonth{#1}}
\def\@publmonth{????}
\newcommand*{\publyear}[1]{\gdef\@publyear{#1}}
\def\@publyear{????}
\newcommand*{\discipline}[2]{%
  \gdef\@discipline{#1}
  \gdef\@discipline@abbrv{#2}%
}
\def\@discipline{????}
\def\@discipline@abbrv{??}
\newcommand{\reportno}[1]{\gdef\@reportno{#1}}
\def\@reportno{????}
\def\@issn{1650-2647}
\newcommand*{\thesistype}[2]{%
  \gdef\@thesistype{#1}%
  \gdef\@thesistype@abbrv{#2}%
}
\def\@thesistype{Master's Thesis}
\def\@thesistype@abbrv{E}
\newcommand{\frontcover}{%
  \thispagestyle{empty}%
  \setcounter{page}{-1}
  \setlength{\unitlength}{1cm}%
  \noindent
  \begin{picture}(15,25.2)(3,2.5)%
    \usefont{T1}{ptm}{m}{n}%
    \put(5,1.3){\rule{.5mm}{27.5cm}}
    \put(1.4,4.8){\rule{17.8cm}{.5mm}}
    \put(5.5,26.2){\rule{11.7cm}{.5mm}}
    \put(2.75,25.4){\makebox(0,0)[b]{%
      \includegraphics[width=14mm]{vxusymbol.1}}}
    \put(2.75,25.15){\makebox(0,0)[t]{%
      \parbox{3.5cm}{\usefont{T1}{ppl}{m}{n}\LARGE
        \centering
        V\"{a}xj\"{o}\\
        University}}}
    \put(5.5,28){School of Mathematics and
      System Engineering}
    \put(5.5,27){\textbf{Reports from MSI}
      - Rapporter fr{\aa}n MSI}
    \put(11.5,21.9){\makebox(0,0)[t]{%
      \parbox{11cm}{\centering
        \fontsize{18}{23}\selectfont\@titlei\\[\baselineskip]%
        \large\@subtitlei}}}
    \put(11.5,13.1){\makebox(0,0)[t]{%
      \parbox{11cm}{\centering
        \begin{tabular}[t]{c}
          \@author
        \end{tabular}}}}
    \put(2.75,3.7){\makebox(0,0)[t]{%
      \parbox{3.5cm}{\centering\@publmonth\\
        \@publyear}}}
    \put(5.8,3.7){\makebox(0,0)[tl]{%
      \parbox{4cm}{\small
        MSI\\
        V\"{a}xj\"{o} University\\
        \textbf{SE-351 95 V\"{A}XJ\"{O}}}}}
    \put(12,3.7){\makebox(0,0)[tl]{%
      \parbox{8cm}{\small
         Report \@reportno\\
         ISSN \@issn\\
         ISRN VXU/MSI/\@discipline@abbrv/\@thesistype@abbrv/-{}-%
         \@reportno/-{}-SE}}}
  \end{picture}%
  \newpage
  \thispagestyle{empty}
  \mbox{}
  \newpage
}
\renewcommand{\maketitle}{\relax}
\newcommand{\backcover}{%
  \clearpage
  \thispagestyle{empty}
  \mbox{}
  \clearpage
  \ifodd\c@page
    \thispagestyle{empty}
    \mbox{}
    \clearpage
  \fi
  \begin{center}
    \usefont{T1}{ptm}{m}{n}%
    \thispagestyle{empty}%
    \mbox{}%
    \vfill
    \includegraphics[width=15mm]{vxusymbol.1}\\
    {\usefont{T1}{ppl}{m}{n}\huge
     V\"{a}xj\"{o}\\
     universitet}\\[8mm]
    \textbf{Matematiska och systemtekniska institutionen}\\
    SE-351 95 V\"{a}xj\"{o}\\[7mm]
    Tel. +46\,(0)470\,70\,80\,00, fax +46\,(0)470\,840\,04\\
    http://www.vxu.se/msi/
    \vskip1.2cm
    \mbox{}
  \end{center}%
}
\newcommand\frontmatter{%
  \pagenumbering{roman}
  \setcounter{page}{1}
  \thispagestyle{empty}
  \begin{center}
    \mbox{}\\[2\baselineskip]%
    \begin{tabular}[t]{c}
      \large\@author
    \end{tabular}\\[0.75cm]
    \LARGE\@titleii
    \ifx\@empty\@subtitleii
      \\[1.5cm]
    \else
      \\[0.25\baselineskip]
      \Large\@subtitleii\\[1.5cm]
    \fi
    \normalsize
    \@thesistype\\[\baselineskip]
    \@discipline\\[2\baselineskip]
    \@publyear
    \vfill
    \includegraphics[width=9mm]{vxusymbol.1}\kern0.3em\hbox{%
      \raisebox{\depth}{\fontsize{17.28}{20.74}\usefont{T1}{ppl}{m}{n}%
        V\"{a}xj\"{o} University}}
  \end{center}
  \clearpage
  \thispagestyle{empty}
  \mbox{}
  \global\let\title\relax
  \global\let\@titlei\@empty
  \global\let\@titleii\@empty
  \global\let\@subtitlei\@empty
  \global\let\@subtitleii\@empty
  \global\let\author\relax
  \global\let\@author\@empty
  \global\let\publmonth\relax
  \global\let\@publmonth\@empty
  \global\let\publyear\relax
  \global\let\@publyear\@empty
  \global\let\discipline\relax
  \global\let\@discipline\@empty
  \global\let\@issn\@empty
  \clearpage
}
\newenvironment{keywords}[1][Key-words]{%
  \par\vspace{.2\baselineskip}%
  \noindent{\bfseries\slshape #1:}
}{%
}
\renewenvironment{abstract}{%
  \vskip2cm
  \begin{center}
    \large\bfseries\abstractname
  \end{center}
  \par\vspace{.1\baselineskip}\noindent\ignorespaces
}{}
\setcounter{secnumdepth}{3}
\setcounter{tocdepth}{2}
\RequirePackage[nottoc,notlof,notlot,section]{tocbibind}
\renewcommand{\section}{%
  \@startsection
    {section}%
    {1}%
    {0pt}%
    {-3ex plus -1ex minus -.2ex}%
    {1.5ex plus.2ex}%
    {\large\bfseries}%
}
\renewcommand{\subsection}{%
  \@startsection
    {subsection}%
    {2}%
    {0pt}%
    {-2.5ex plus -1ex minus -.2ex}%
    {1.25ex plus .2ex}%
    {\bfseries\normalsize}%
}
\renewcommand{\subsubsection}{%
  \@startsection
    {subsubsection}%
    {3}%
    {0pt}%
    {-2.25ex plus -1ex minus -.2ex}%
    {1ex plus .2ex}%
    {\normalfont\normalsize}%
}
\setlength{\parindent}{.5cm}
\renewenvironment{quotation}{%
  \list{}{%
    \leftmargin    2cm%
    \rightmargin   \leftmargin
    \listparindent 1.5em%
    \itemindent    \listparindent
    \parsep        \z@ \@plus\p@
  }%
\item\relax}{\endlist}
\renewenvironment{quote}{%
  \list{}{%
    \leftmargin  2cm
    \rightmargin \leftmargin}%
\item\relax}{\endlist}
\@addtoreset{figure}{section}
\@addtoreset{table}{section}
\renewcommand{\thefigure}{\thesection.\arabic{figure}}
\renewcommand{\thetable}{\thesection.\arabic{table}}
\endinput
%%
%% End of file `rfmsi.cls'.
