/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DTLandname;
import com.dickimawbooks.texparserlib.latex.datatool.DTLcompare;
import com.dickimawbooks.texparserlib.latex.datatool.DTLfetchlistelement;
import com.dickimawbooks.texparserlib.latex.datatool.DTLformatlist;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifinlist;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifintclosedbetween;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifintopenbetween;
import com.dickimawbooks.texparserlib.latex.datatool.DTLinsertinto;
import com.dickimawbooks.texparserlib.latex.datatool.DTLlistelement;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnewcurrencysymbol;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnumitemsinlist;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetdefaultcurrency;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetnumberchars;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetup;
import com.dickimawbooks.texparserlib.latex.datatool.DataCurrencyElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataIntElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataRealElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataStringElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumMarker;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import com.dickimawbooks.texparserlib.latex.datatool.NumericFormatter;
import com.dickimawbooks.texparserlib.latex.ifthen.IfThenSty;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Vector;

public class DataToolBaseSty
extends LaTeXSty {
    private IfThenSty ifThenSty;
    private Vector<TeXObject> currencySymbolList;
    private TeXObject defaultCurrency;
    private CountRegister sortCountReg;
    private DataToolSty datatoolSty;
    public static final String INDEX_OUT_OF_RANGE = "datatool.index.outofrange";

    public DataToolBaseSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "datatool-base", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        TeXParser teXParser = this.getListener().getParser();
        this.sortCountReg = teXParser.getSettings().newcount(false, "dtl@sortresult");
        NewIf.createConditional(true, teXParser, "ifDTLlistskipempty", true);
        this.registerControlSequence(new DTLnewcurrencysymbol(this));
        this.registerControlSequence(new DTLsetdefaultcurrency(this));
        this.registerControlSequence(new DTLifintopenbetween());
        this.registerControlSequence(new DTLifintclosedbetween());
        this.registerControlSequence(new DTLifinlist());
        this.registerControlSequence(new DTLnumitemsinlist());
        this.registerControlSequence(new DTLlistelement());
        this.registerControlSequence(new DTLfetchlistelement());
        this.registerControlSequence(new DTLformatlist());
        this.registerControlSequence(new AtFirstOfOne("DTLlistformatitem"));
        this.registerControlSequence(new GenericCommand("DTLlistformatoxford"));
        this.registerControlSequence(new GenericCommand("DTLlistformatsep", null, this.getListener().createString(", ")));
        this.registerControlSequence(new GenericCommand(true, "DTLlistformatlastsep", null, new TeXObject[]{new TeXCsRef("space"), new TeXCsRef("DTLandname"), new TeXCsRef("space")}));
        this.registerControlSequence(new DTLandname());
        this.registerControlSequence(new DTLinsertinto(this));
        this.registerControlSequence(new DTLinsertinto("edtlinsertinto", true, this));
        this.registerControlSequence(new DTLcompare());
        this.registerControlSequence(new DTLcompare("dtlicompare", false));
        this.registerControlSequence(new DTLsetnumberchars());
        this.registerControlSequence(new TextualContentCommand("@dtl@numbergroupchar", ","));
        this.registerControlSequence(new TextualContentCommand("@dtl@decimal", "."));
        this.registerControlSequence(new NumericFormatter("__texparser_fmt_integer_value:n", new DecimalFormat("#,##0"), "."));
        this.registerControlSequence(new NumericFormatter("__texparser_fmt_decimal_value:n", new DecimalFormat("#,##0.0#####")));
        this.registerControlSequence(new NumericFormatter("__texparser_fmt_currency_value:n", new DecimalFormat("#,##0.00")));
        this.addCurrencySymbol("$");
        this.addCurrencySymbol("pounds");
        this.addCurrencySymbol("textsterling");
        this.addCurrencySymbol("textdollar");
        this.addCurrencySymbol("textyen");
        this.addCurrencySymbol("texteuro");
        this.addCurrencySymbol("textwon");
        this.addCurrencySymbol("textcurrency");
        this.addCurrencySymbol("euro");
        this.addCurrencySymbol("yen");
        this.registerControlSequence(new DTLsetup(this));
        this.registerControlSequence(new DatumMarker());
        this.registerControlSequence(new IntegerContentCommand("c_datatool_string_int", DatumType.STRING.getValue(), true));
        this.registerControlSequence(new IntegerContentCommand("c_datatool_integer_int", DatumType.INTEGER.getValue(), true));
        this.registerControlSequence(new IntegerContentCommand("c_datatool_decimal_int", DatumType.DECIMAL.getValue(), true));
        this.registerControlSequence(new IntegerContentCommand("c_datatool_currency_int", DatumType.CURRENCY.getValue(), true));
        this.registerControlSequence(new IntegerContentCommand("c_datatool_unknown_int", DatumType.UNKNOWN.getValue(), true));
    }

    @Override
    protected void preOptions(TeXObjectList teXObjectList) throws IOException {
        this.getListener().requirepackage("etoolbox", teXObjectList);
        this.ifThenSty = (IfThenSty)this.getListener().requirepackage("ifthen", teXObjectList);
    }

    public void setDataBaseSty(DataToolSty dataToolSty) {
        this.datatoolSty = dataToolSty;
    }

    public void processSetupOption(String string, TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        if (!(string.equals("verbose") || string.equals("initial-purify") || string.equals("compare") || string.equals("lists") || string.equals("utf8") || string.equals("math") || string.equals("locales") || string.equals("nolocale"))) {
            if (this.datatoolSty != null) {
                this.datatoolSty.processSetupOption(string, teXObject, teXObjectList);
            } else {
                throw new LaTeXSyntaxException(this.getParser(), "latex.unknown.option", string, "datatool-base");
            }
        }
    }

    public void addCurrencySymbol(TeXObject teXObject) {
        if (this.currencySymbolList == null) {
            this.currencySymbolList = new Vector();
            this.defaultCurrency = teXObject;
        }
        if (teXObject == null) {
            throw new NullPointerException();
        }
        this.currencySymbolList.add(teXObject);
    }

    public void addCurrencySymbol(String string) {
        this.addCurrencySymbol(new TeXCsRef(string));
    }

    public boolean isCurrencySymbol(TeXObject teXObject) {
        if (teXObject == null) {
            return false;
        }
        for (TeXObject teXObject2 : this.currencySymbolList) {
            if (teXObject2 instanceof ControlSequence && teXObject instanceof ControlSequence && ((ControlSequence)teXObject2).getName().equals(((ControlSequence)teXObject).getName())) {
                return true;
            }
            if (!teXObject2.equals(teXObject)) continue;
            return true;
        }
        return false;
    }

    public void setDefaultCurrency(TeXObject teXObject) {
        this.defaultCurrency = teXObject;
    }

    public IfThenSty getIfThenSty() {
        return this.ifThenSty;
    }

    public CountRegister getSortCountRegister() {
        return this.sortCountReg;
    }

    public static int parseInt(String string, TeXParser teXParser) throws TeXSyntaxException {
        ControlSequence controlSequence = teXParser.getControlSequence("__texparser_fmt_integer_value:n");
        try {
            if (controlSequence instanceof NumericFormatter) {
                return ((NumericFormatter)controlSequence).parse(string).intValue();
            }
            return Integer.parseInt(string);
        }
        catch (NumberFormatException | ParseException exception) {
            throw new TeXSyntaxException((Throwable)exception, teXParser, "tex.error.number_expected", string);
        }
    }

    public static double parseDecimal(String string, TeXParser teXParser) throws TeXSyntaxException {
        ControlSequence controlSequence = teXParser.getControlSequence("__texparser_fmt_decimal_value:n");
        try {
            if (controlSequence instanceof NumericFormatter) {
                return ((NumericFormatter)controlSequence).parse(string).doubleValue();
            }
            return Double.parseDouble(string);
        }
        catch (NumberFormatException | ParseException exception) {
            throw new TeXSyntaxException((Throwable)exception, teXParser, "tex.error.number_expected", string);
        }
    }

    public static double parseCurrencyDecimal(String string, TeXParser teXParser) throws TeXSyntaxException {
        ControlSequence controlSequence = teXParser.getControlSequence("__texparser_fmt_currency_value:n");
        try {
            if (controlSequence instanceof NumericFormatter) {
                return ((NumericFormatter)controlSequence).parse(string).doubleValue();
            }
            return Double.parseDouble(string);
        }
        catch (NumberFormatException | ParseException exception) {
            throw new TeXSyntaxException((Throwable)exception, teXParser, "tex.error.number_expected", string);
        }
    }

    public DataElement getElement(TeXObject teXObject) throws IOException {
        TeXObject teXObject2;
        Object object;
        TeXParser teXParser = this.getListener().getParser();
        boolean bl = TeXParserUtils.isTrue("l__datatool_db_store_datum_bool", teXParser);
        TeXObject teXObject3 = null;
        if (bl) {
            teXObject3 = (TeXObject)teXObject.clone();
        }
        if (teXObject instanceof TeXObjectList) {
            object = (TeXObjectList)teXObject;
            teXObject2 = ((TeXObjectList)object).peekStack();
            if (teXObject2 == null) {
                return null;
            }
            if (DatumMarker.isDatumMarker(teXObject2)) {
                DataElement dataElement = DatumMarker.popDataElement(bl, teXParser, (TeXObjectList)object);
                ((TeXObjectList)object).trim();
                if (!((Vector)object).isEmpty()) {
                    throw new LaTeXSyntaxException(teXParser, "latex.trailing_content", teXObject2, ((TeXObjectList)object).toString(teXParser));
                }
                return dataElement;
            }
            if (this.isCurrencySymbol(teXObject2)) {
                teXObject2 = ((TeXObjectList)object).popStack(teXParser);
                try {
                    ControlSequence controlSequence = teXParser.getControlSequence("__texparser_fmt_currency_value:n");
                    String string = ((TeXObjectList)object).toString(teXParser).trim();
                    double d = controlSequence instanceof NumericFormatter ? ((NumericFormatter)controlSequence).parse(string).doubleValue() : Double.parseDouble(string);
                    if (bl) {
                        return new DatumElement(teXObject3, new TeXFloatingPoint(d), teXObject2, DatumType.CURRENCY);
                    }
                    return new DataCurrencyElement(teXObject2, d);
                }
                catch (NumberFormatException | ParseException exception) {
                    ((TeXObjectList)object).add(0, teXObject2);
                    return new DataStringElement((TeXObjectList)object);
                }
            }
        }
        object = teXObject.toString(teXParser).trim();
        try {
            teXObject2 = teXParser.getControlSequence("__texparser_fmt_integer_value:n");
            int n = teXObject2 instanceof NumericFormatter ? ((NumericFormatter)teXObject2).parse((String)object).intValue() : Integer.parseInt((String)object);
            if (bl) {
                return new DatumElement(teXObject3, new UserNumber(n), null, DatumType.INTEGER);
            }
            return new DataIntElement(n);
        }
        catch (NumberFormatException | ParseException exception) {
            try {
                ControlSequence controlSequence = teXParser.getControlSequence("__texparser_fmt_decimal_value:n");
                double d = controlSequence instanceof NumericFormatter ? ((NumericFormatter)controlSequence).parse((String)object).doubleValue() : Double.parseDouble((String)object);
                if (bl) {
                    return new DatumElement(teXObject3, new TeXFloatingPoint(d), null, DatumType.DECIMAL);
                }
                return new DataRealElement(d);
            }
            catch (NumberFormatException | ParseException exception2) {
                if (bl) {
                    if (teXObject.isEmpty()) {
                        return new DatumElement();
                    }
                    return new DatumElement(teXObject);
                }
                if (teXObject instanceof TeXObjectList) {
                    return new DataStringElement((TeXObjectList)teXObject);
                }
                DataStringElement dataStringElement = new DataStringElement();
                dataStringElement.add(teXObject);
                return dataStringElement;
            }
        }
    }
}

