# A cover letter template for a journal paper submission in LaTex
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-4-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->

<p align="center">
  <img alt="logo" width="300" src="imgs/logo.png">
</p>

## Description
Paper submission in the journal is usually accompanied by a cover letter. The repository hosts a cover letter template for journal submissions written in LaTex that is minimalistic in one way while pre-defined with several commands that drastically speed up the process of preparing a cover letter for journal submission.

### Main Features of this template:
- Minimalistic design
- Include the custom logo of the affiliation
- Predefined commands for a journal name, author, date, etc.
- Many macros contained in this package speed up the process of preparing the necessary ingredients for the cover letter
- Defined macros for recommending up to 3 reviewers or editor
- ORCID logo and link to the submitting author's ORCID page
- Controls for adding a "Conflict of interest" statement and declaration
- Predefined different valedictions for different types of submissions (e.g., Yours sincerely, Yours faithfully, Best regards, etc.)
- Custom greeting (e.g., "Dear Editor" or "Dear Editor-in-Chief" for regular submission, etc.)
- Option to add custom Signature (i.e. an image of your hand-written signature)

## Disclaimer
This software is provided as-is, and there are no guarantees that it fits your purposes or that it is bug-free. Use it at your own risk!

## License
Material in this folder is licensed under a
[Creative Commons Attribution-ShareAlike 4.0 International License][cc-by-sa].

[![CC BY-SA 4.0][cc-by-sa-image]][cc-by-sa]

[cc-by-sa]: http://creativecommons.org/licenses/by-sa/4.0/
[cc-by-sa-image]: https://licensebuttons.net/l/by-sa/4.0/88x31.png
[cc-by-sa-shield]: https://img.shields.io/badge/License-CC%20BY--SA%204.0-lightgrey.svg

## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center"><a href="https://github.com/KukovecRok"><img src="https://avatars.githubusercontent.com/u/33880044?v=4?s=100" width="100px;" alt="Tatookie"/><br /><sub><b>Tatookie</b></sub></a><br /><a href="https://github.com/firefly-cpp/cover-letter-latex/commits?author=KukovecRok" title="Code">💻</a> <a href="https://github.com/firefly-cpp/cover-letter-latex/issues?q=author%3AKukovecRok" title="Bug reports">🐛</a> <a href="#ideas-KukovecRok" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center"><a href="https://github.com/lucijabrezocnik"><img src="https://avatars.githubusercontent.com/u/36370699?v=4?s=100" width="100px;" alt="Lucija Brezočnik"/><br /><sub><b>Lucija Brezočnik</b></sub></a><br /><a href="https://github.com/firefly-cpp/cover-letter-latex/commits?author=lucijabrezocnik" title="Code">💻</a></td>
      <td align="center"><a href="http://www.iztok-jr-fister.eu/"><img src="https://avatars.githubusercontent.com/u/1633361?v=4?s=100" width="100px;" alt="Iztok Fister Jr."/><br /><sub><b>Iztok Fister Jr.</b></sub></a><br /><a href="https://github.com/firefly-cpp/cover-letter-latex/commits?author=firefly-cpp" title="Code">💻</a> <a href="https://github.com/firefly-cpp/cover-letter-latex/issues?q=author%3Afirefly-cpp" title="Bug reports">🐛</a> <a href="#ideas-firefly-cpp" title="Ideas, Planning, & Feedback">🤔</a> <a href="#mentoring-firefly-cpp" title="Mentoring">🧑‍🏫</a></td>
      <td align="center"><a href="https://github.com/rhododendrom"><img src="https://avatars.githubusercontent.com/u/3198785?v=4?s=100" width="100px;" alt="rhododendrom"/><br /><sub><b>rhododendrom</b></sub></a><br /><a href="#design-rhododendrom" title="Design">🎨</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
