<!-- CTAN readme -->
# ACCESSIBILITY
A LaTeX package to create a tagged and structured PDF file.

By Babett Schalitz (2007).

Maintained by Andy Clifton (2019 - )

## Description
The `accessibility` package  is intended to create tagged, structured PDF documents from LaTeX2e source code.

This package is intended for documents produced using PDFLaTeX.

### Note to version 1.x
`accessibility` was originally programmed in 2007 by Babett Schalitz as part of a Masters project at TU Dresden. `accessibility` was not released through CTAN, but the accessibility.sty file was available through Babett's personal homepage.

### Note to version 2.0.x releases
The maintenance of the accessibility package was taken up in 2019 by Andrew Clifton with Babett Schalitz's agreement. Babett also provided her original .dtx and .ins files, as well as some scripts.

This release is based almost entirely on her original files, but has been recompiled with TexLive 2018. Some changes have been made to the source code to fix package interactions and to make the output files conform to CTAN requirements. Most of the scripts and directory structure have been changed to make it simpler to work with GitHub.

As a result of these changes and the length of time since the package was first written, it is not clear if the package's behaviour is the same as the original version. Therefore the major version number has been incremented to 2.x.x.

See the CHANGELOG.md file for some information about changes.

### Bugs, errors, feedback
Please report all problems to [the accessibility package issue tracker on Github](https://github.com/AndyClifton/accessibility/issues). Also, please note that I cannot enter into detailed discussions about individual documents, but am happy to address anything that might impact all users.

## CTAN File manifest

- README.md: This file
- accessibility.ins, accessibility.dtx:  The accessibility package
- accessibility.pdf:  rudimentary instructions
- accessibility-Anleitung-DE.pdf:  detailed instructions (in German)

## Copyright and License

Copyright (C) 2007 Babett Schalitz

Copyright (C) 2019 Andrew Clifton

This work may be distributed and/or modified under the conditions of the LaTeX Project Public License, either version 1.3c of this license or (at your option) any later version.  The latest version of this license is in http://www.latex-project.org/lppl.txt and version 1.3c or later is part of all distributions of LaTeX version 2008/05/04 or later.
