/* engine.c generated by valac 0.26.1, the Vala compiler
 * generated from engine.vala, do not modify */

/* engine.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "zeitgeist-internal.h"
#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gobject/gvaluecollector.h>


#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
typedef struct _ZeitgeistEnginePrivate ZeitgeistEnginePrivate;

#define ZEITGEIST_TYPE_EXTENSION_STORE (zeitgeist_extension_store_get_type ())
#define ZEITGEIST_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore))
#define ZEITGEIST_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))
#define ZEITGEIST_IS_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_IS_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_EXTENSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))

typedef struct _ZeitgeistExtensionStore ZeitgeistExtensionStore;
typedef struct _ZeitgeistExtensionStoreClass ZeitgeistExtensionStoreClass;

#define ZEITGEIST_TYPE_EXTENSION_COLLECTION (zeitgeist_extension_collection_get_type ())
#define ZEITGEIST_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection))
#define ZEITGEIST_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))
#define ZEITGEIST_IS_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_IS_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_EXTENSION_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))

typedef struct _ZeitgeistExtensionCollection ZeitgeistExtensionCollection;
typedef struct _ZeitgeistExtensionCollectionClass ZeitgeistExtensionCollectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZEITGEIST_ENGINE_TYPE_DATA_INSERTER (zeitgeist_engine_data_inserter_get_type ())
#define ZEITGEIST_ENGINE_DATA_INSERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserter))
#define ZEITGEIST_ENGINE_DATA_INSERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserterClass))
#define ZEITGEIST_ENGINE_IS_DATA_INSERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER))
#define ZEITGEIST_ENGINE_IS_DATA_INSERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER))
#define ZEITGEIST_ENGINE_DATA_INSERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserterClass))

typedef struct _ZeitgeistEngineDataInserter ZeitgeistEngineDataInserter;
typedef struct _ZeitgeistEngineDataInserterClass ZeitgeistEngineDataInserterClass;
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _zeitgeist_engine_data_inserter_unref0(var) ((var == NULL) ? NULL : (var = (zeitgeist_engine_data_inserter_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ZeitgeistEngineDataInserterPrivate ZeitgeistEngineDataInserterPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistEngineParamSpecDataInserter ZeitgeistEngineParamSpecDataInserter;

struct _ZeitgeistEngine {
	ZeitgeistDbReader parent_instance;
	ZeitgeistEnginePrivate * priv;
	ZeitgeistExtensionStore* extension_store;
};

struct _ZeitgeistEngineClass {
	ZeitgeistDbReaderClass parent_class;
};

struct _ZeitgeistEnginePrivate {
	ZeitgeistExtensionCollection* extension_collection;
	guint32 last_id;
};

typedef GType (*ZeitgeistRegisterExtensionFunc) (GTypeModule* module);
struct _ZeitgeistEngineDataInserter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ZeitgeistEngineDataInserterPrivate * priv;
};

struct _ZeitgeistEngineDataInserterClass {
	GTypeClass parent_class;
	void (*finalize) (ZeitgeistEngineDataInserter *self);
};

struct _ZeitgeistEngineDataInserterPrivate {
	ZeitgeistSQLiteDatabase* database;
	gchar* type;
	GPtrArray* data;
};

struct _ZeitgeistEngineParamSpecDataInserter {
	GParamSpec parent_instance;
};


static gpointer zeitgeist_engine_parent_class = NULL;
static gpointer zeitgeist_engine_data_inserter_parent_class = NULL;

GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_store_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_collection_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_ENGINE, ZeitgeistEnginePrivate))
enum  {
	ZEITGEIST_ENGINE_DUMMY_PROPERTY
};
ZeitgeistEngine* zeitgeist_engine_new (GError** error);
ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_new (ZeitgeistEngine* engine, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_construct (GType object_type, ZeitgeistEngine* engine, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1);
ZeitgeistEngine* zeitgeist_engine_new_with_builtins (ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1, GError** error);
ZeitgeistEngine* zeitgeist_engine_construct_with_builtins (GType object_type, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1, GError** error);
gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1);
gchar** zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self, int* result_length1);
guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error);
static void zeitgeist_engine_preprocess_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error);
void zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
static void zeitgeist_engine_insert_event_data (ZeitgeistEngine* self, GPtrArray* events, GError** error);
static guint32 zeitgeist_engine_insert_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error);
void zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
static gpointer zeitgeist_engine_data_inserter_ref (gpointer instance);
static void zeitgeist_engine_data_inserter_unref (gpointer instance);
static GParamSpec* zeitgeist_engine_param_spec_data_inserter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void zeitgeist_engine_value_set_data_inserter (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void zeitgeist_engine_value_take_data_inserter (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer zeitgeist_engine_value_get_data_inserter (const GValue* value) G_GNUC_UNUSED;
static GType zeitgeist_engine_data_inserter_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_new (ZeitgeistSQLiteDatabase* db, const gchar* data_type);
static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_construct (GType object_type, ZeitgeistSQLiteDatabase* db, const gchar* data_type);
static void zeitgeist_engine_data_inserter_add (ZeitgeistEngineDataInserter* self, const gchar* val, GError** error);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
static void zeitgeist_engine_data_inserter_flush (ZeitgeistEngineDataInserter* self, GError** error);
static void zeitgeist_engine_bind_cached_reference (ZeitgeistEngine* self, sqlite3_stmt* stmt, gint position, ZeitgeistSQLiteTableLookup* table, const gchar* value_, GError** error);
static gint64 zeitgeist_engine_store_payload (ZeitgeistEngine* self, ZeitgeistEvent* event);
static void zeitgeist_engine_handle_move_event (ZeitgeistEngine* self, ZeitgeistEvent* event);
ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
guint32* zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender, int* result_length1);
void zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender);
static void zeitgeist_engine_real_close (ZeitgeistDbReader* base);
static GObject * zeitgeist_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
ZeitgeistExtensionStore* zeitgeist_extension_store_new (ZeitgeistEngine* engine);
ZeitgeistExtensionStore* zeitgeist_extension_store_construct (GType object_type, ZeitgeistEngine* engine);
#define ZEITGEIST_ENGINE_DATA_INSERTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserterPrivate))
enum  {
	ZEITGEIST_ENGINE_DATA_INSERTER_DUMMY_PROPERTY
};
#define ZEITGEIST_ENGINE_DATA_INSERTER_MAX_PARAMETERS 500
static void zeitgeist_engine_data_inserter_finalize (ZeitgeistEngineDataInserter* obj);
static void zeitgeist_engine_finalize (GObject* obj);


ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error) {
	ZeitgeistEngine * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp2_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	ZeitgeistSQLiteDatabase* _tmp5_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	ZeitgeistRegisterExtensionFunc* _tmp8_ = NULL;
	ZeitgeistRegisterExtensionFunc* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	ZeitgeistExtensionCollection* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp1_ = zeitgeist_sq_lite_database_new (&_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_tmp3_ = _tmp2_;
	self = (ZeitgeistEngine*) g_object_new (object_type, "database", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp5_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = zeitgeist_sq_lite_database_get_last_id (_tmp6_, &_inner_error_);
	_tmp4_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->last_id = _tmp4_;
	_tmp8_ = g_new0 (ZeitgeistRegisterExtensionFunc, 0);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 0;
	_tmp10_ = zeitgeist_extension_collection_new (self, _tmp9_, 0);
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = _tmp10_;
	_tmp9_ = (g_free (_tmp9_), NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}


ZeitgeistEngine* zeitgeist_engine_new (GError** error) {
	return zeitgeist_engine_construct (ZEITGEIST_TYPE_ENGINE, error);
}


ZeitgeistEngine* zeitgeist_engine_construct_with_builtins (GType object_type, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1, GError** error) {
	ZeitgeistEngine * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp2_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	ZeitgeistSQLiteDatabase* _tmp5_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	ZeitgeistRegisterExtensionFunc* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	ZeitgeistExtensionCollection* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp1_ = zeitgeist_sq_lite_database_new (&_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_tmp3_ = _tmp2_;
	self = (ZeitgeistEngine*) g_object_new (object_type, "database", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp5_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = zeitgeist_sq_lite_database_get_last_id (_tmp6_, &_inner_error_);
	_tmp4_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->last_id = _tmp4_;
	_tmp8_ = builtins;
	_tmp8__length1 = builtins_length1;
	_tmp9_ = zeitgeist_extension_collection_new (self, _tmp8_, _tmp8__length1);
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = _tmp9_;
	_g_object_unref0 (_tmp0_);
	return self;
}


ZeitgeistEngine* zeitgeist_engine_new_with_builtins (ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1, GError** error) {
	return zeitgeist_engine_construct_with_builtins (ZEITGEIST_TYPE_ENGINE, builtins, builtins_length1, error);
}


gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1) {
	gchar** result = NULL;
	ZeitgeistExtensionCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->extension_collection;
	_tmp2_ = zeitgeist_extension_collection_get_extension_names (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error) {
	guint32* result = NULL;
	ZeitgeistExtensionCollection* _tmp9_ = NULL;
	GPtrArray* _tmp10_ = NULL;
	const char* _tmp11_ = NULL;
	guint32* event_ids = NULL;
	GPtrArray* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	guint32* _tmp15_ = NULL;
	gint event_ids_length1 = 0;
	gint _event_ids_size_ = 0;
	GError* err = NULL;
	ZeitgeistSQLiteDatabase* _tmp16_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp17_ = NULL;
	GError* _tmp42_ = NULL;
	ZeitgeistExtensionCollection* _tmp45_ = NULL;
	GPtrArray* _tmp46_ = NULL;
	const char* _tmp47_ = NULL;
	guint32* _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (events != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = events;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = events;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				zeitgeist_engine_preprocess_event (self, (ZeitgeistEvent*) _tmp8_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	_tmp9_ = self->priv->extension_collection;
	_tmp10_ = events;
	_tmp11_ = sender;
	zeitgeist_extension_collection_call_pre_insert_events (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = events;
	_tmp13_ = g_ptr_array_get_length (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_new0 (guint32, _tmp14_);
	event_ids = _tmp15_;
	event_ids_length1 = _tmp14_;
	_event_ids_size_ = event_ids_length1;
	err = NULL;
	_tmp16_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp17_ = _tmp16_;
	zeitgeist_sq_lite_database_begin_transaction (_tmp17_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GPtrArray* _tmp18_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp36_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp37_ = NULL;
		_tmp18_ = events;
		zeitgeist_engine_insert_event_data (self, _tmp18_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp19_ = FALSE;
				_tmp19_ = TRUE;
				while (TRUE) {
					gint _tmp21_ = 0;
					GPtrArray* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
					GPtrArray* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gconstpointer _tmp27_ = NULL;
					if (!_tmp19_) {
						gint _tmp20_ = 0;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp19_ = FALSE;
					_tmp21_ = i;
					_tmp22_ = events;
					_tmp23_ = g_ptr_array_get_length (_tmp22_);
					_tmp24_ = _tmp23_;
					if (!(_tmp21_ < _tmp24_)) {
						break;
					}
					_tmp25_ = events;
					_tmp26_ = i;
					_tmp27_ = g_ptr_array_index (_tmp25_, (guint) _tmp26_);
					if (((ZeitgeistEvent*) _tmp27_) != NULL) {
						guint32 _tmp28_ = 0U;
						GPtrArray* _tmp29_ = NULL;
						gint _tmp30_ = 0;
						gconstpointer _tmp31_ = NULL;
						guint32 _tmp32_ = 0U;
						guint32* _tmp33_ = NULL;
						gint _tmp33__length1 = 0;
						gint _tmp34_ = 0;
						guint32 _tmp35_ = 0U;
						_tmp29_ = events;
						_tmp30_ = i;
						_tmp31_ = g_ptr_array_index (_tmp29_, (guint) _tmp30_);
						_tmp32_ = zeitgeist_engine_insert_event (self, (ZeitgeistEvent*) _tmp31_, &_inner_error_);
						_tmp28_ = _tmp32_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								goto __catch0_zeitgeist_engine_error;
							}
							_g_error_free0 (err);
							event_ids = (g_free (event_ids), NULL);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp33_ = event_ids;
						_tmp33__length1 = event_ids_length1;
						_tmp34_ = i;
						_tmp33_[_tmp34_] = _tmp28_;
						_tmp35_ = _tmp33_[_tmp34_];
					}
				}
			}
		}
		_tmp36_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp37_ = _tmp36_;
		zeitgeist_sq_lite_database_end_transaction (_tmp37_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error:
	{
		GError* e = NULL;
		GError* _tmp38_ = NULL;
		GError* _tmp39_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp40_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp41_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _g_error_copy0 (_tmp38_);
		_g_error_free0 (err);
		err = _tmp39_;
		_tmp40_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp41_ = _tmp40_;
		zeitgeist_sq_lite_database_abort_transaction (_tmp41_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_error_free0 (e);
			goto __finally0;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp42_ = err;
	if (_tmp42_ != NULL) {
		GError* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
		_tmp43_ = err;
		_tmp44_ = _g_error_copy0 (_tmp43_);
		_inner_error_ = _tmp44_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp45_ = self->priv->extension_collection;
	_tmp46_ = events;
	_tmp47_ = sender;
	zeitgeist_extension_collection_call_post_insert_events (_tmp45_, _tmp46_, _tmp47_);
	_tmp48_ = event_ids;
	_tmp48__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp48__length1;
	}
	result = _tmp48_;
	_g_error_free0 (err);
	return result;
}


static void zeitgeist_engine_preprocess_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ZeitgeistEvent* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp2_ = event;
	_tmp3_ = zeitgeist_event_get_interpretation (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_utils_is_empty_string (_tmp4_);
	if (_tmp5_) {
		_tmp1_ = TRUE;
	} else {
		ZeitgeistEvent* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = event;
		_tmp7_ = zeitgeist_event_get_manifestation (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = zeitgeist_utils_is_empty_string (_tmp8_);
		_tmp1_ = _tmp9_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ZeitgeistEvent* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = event;
		_tmp11_ = zeitgeist_event_get_actor (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = zeitgeist_utils_is_empty_string (_tmp12_);
		_tmp0_ = _tmp13_;
	}
	if (_tmp0_) {
		GError* _tmp14_ = NULL;
		_tmp14_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Incomplete event: interpretation, manifestation and actor " "are required");
		_inner_error_ = _tmp14_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_ = 0;
				ZeitgeistEvent* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				ZeitgeistSubject* subject = NULL;
				ZeitgeistEvent* _tmp20_ = NULL;
				GPtrArray* _tmp21_ = NULL;
				GPtrArray* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gconstpointer _tmp24_ = NULL;
				ZeitgeistSubject* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gboolean _tmp28_ = FALSE;
				ZeitgeistSubject* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gboolean _tmp33_ = FALSE;
				ZeitgeistSubject* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				gboolean _tmp41_ = FALSE;
				gboolean _tmp46_ = FALSE;
				ZeitgeistEvent* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				const gchar* _tmp49_ = NULL;
				gboolean _tmp68_ = FALSE;
				ZeitgeistEvent* _tmp69_ = NULL;
				const gchar* _tmp70_ = NULL;
				const gchar* _tmp71_ = NULL;
				ZeitgeistSubject* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				const gchar* _tmp81_ = NULL;
				gboolean _tmp82_ = FALSE;
				ZeitgeistSubject* _tmp90_ = NULL;
				const gchar* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				gboolean _tmp93_ = FALSE;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = event;
				_tmp19_ = zeitgeist_event_num_subjects (_tmp18_);
				if (!(_tmp17_ < _tmp19_)) {
					break;
				}
				_tmp20_ = event;
				_tmp21_ = zeitgeist_event_get_subjects (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = i;
				_tmp24_ = g_ptr_array_index (_tmp22_, (guint) _tmp23_);
				subject = (ZeitgeistSubject*) _tmp24_;
				_tmp25_ = subject;
				_tmp26_ = zeitgeist_subject_get_uri (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = zeitgeist_utils_is_empty_string (_tmp27_);
				if (_tmp28_) {
					GError* _tmp29_ = NULL;
					_tmp29_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Incomplete event: subject without URI");
					_inner_error_ = _tmp29_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp30_ = subject;
				_tmp31_ = zeitgeist_subject_get_current_uri (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = zeitgeist_utils_is_empty_string (_tmp32_);
				if (_tmp33_) {
					ZeitgeistSubject* _tmp34_ = NULL;
					ZeitgeistSubject* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					_tmp34_ = subject;
					_tmp35_ = subject;
					_tmp36_ = zeitgeist_subject_get_uri (_tmp35_);
					_tmp37_ = _tmp36_;
					zeitgeist_subject_set_current_uri (_tmp34_, _tmp37_);
				}
				_tmp38_ = subject;
				_tmp39_ = zeitgeist_subject_get_current_origin (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = zeitgeist_utils_is_empty_string (_tmp40_);
				if (_tmp41_) {
					ZeitgeistSubject* _tmp42_ = NULL;
					ZeitgeistSubject* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					_tmp42_ = subject;
					_tmp43_ = subject;
					_tmp44_ = zeitgeist_subject_get_origin (_tmp43_);
					_tmp45_ = _tmp44_;
					zeitgeist_subject_set_current_origin (_tmp42_, _tmp45_);
				}
				_tmp47_ = event;
				_tmp48_ = zeitgeist_event_get_interpretation (_tmp47_);
				_tmp49_ = _tmp48_;
				if (g_strcmp0 (_tmp49_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
					ZeitgeistSubject* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					const gchar* _tmp52_ = NULL;
					ZeitgeistSubject* _tmp53_ = NULL;
					const gchar* _tmp54_ = NULL;
					const gchar* _tmp55_ = NULL;
					_tmp50_ = subject;
					_tmp51_ = zeitgeist_subject_get_uri (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = subject;
					_tmp54_ = zeitgeist_subject_get_current_uri (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp46_ = g_strcmp0 (_tmp52_, _tmp55_) == 0;
				} else {
					_tmp46_ = FALSE;
				}
				if (_tmp46_) {
					GError* _tmp56_ = NULL;
					_tmp56_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Redundant event: event.interpretation indicates " "the uri has been moved yet the subject.uri and " "subject.current_uri are identical");
					_inner_error_ = _tmp56_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					gboolean _tmp57_ = FALSE;
					ZeitgeistEvent* _tmp58_ = NULL;
					const gchar* _tmp59_ = NULL;
					const gchar* _tmp60_ = NULL;
					_tmp58_ = event;
					_tmp59_ = zeitgeist_event_get_interpretation (_tmp58_);
					_tmp60_ = _tmp59_;
					if (g_strcmp0 (_tmp60_, ZEITGEIST_ZG_MOVE_EVENT) != 0) {
						ZeitgeistSubject* _tmp61_ = NULL;
						const gchar* _tmp62_ = NULL;
						const gchar* _tmp63_ = NULL;
						ZeitgeistSubject* _tmp64_ = NULL;
						const gchar* _tmp65_ = NULL;
						const gchar* _tmp66_ = NULL;
						_tmp61_ = subject;
						_tmp62_ = zeitgeist_subject_get_uri (_tmp61_);
						_tmp63_ = _tmp62_;
						_tmp64_ = subject;
						_tmp65_ = zeitgeist_subject_get_current_uri (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp57_ = g_strcmp0 (_tmp63_, _tmp66_) != 0;
					} else {
						_tmp57_ = FALSE;
					}
					if (_tmp57_) {
						GError* _tmp67_ = NULL;
						_tmp67_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Illegal event: unless event.interpretation is " "'MOVE_EVENT' then subject.uri and " "subject.current_uri have to be the same");
						_inner_error_ = _tmp67_;
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				_tmp69_ = event;
				_tmp70_ = zeitgeist_event_get_interpretation (_tmp69_);
				_tmp71_ = _tmp70_;
				if (g_strcmp0 (_tmp71_, ZEITGEIST_ZG_MOVE_EVENT) != 0) {
					ZeitgeistSubject* _tmp72_ = NULL;
					const gchar* _tmp73_ = NULL;
					const gchar* _tmp74_ = NULL;
					ZeitgeistSubject* _tmp75_ = NULL;
					const gchar* _tmp76_ = NULL;
					const gchar* _tmp77_ = NULL;
					_tmp72_ = subject;
					_tmp73_ = zeitgeist_subject_get_origin (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = subject;
					_tmp76_ = zeitgeist_subject_get_current_origin (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp68_ = g_strcmp0 (_tmp74_, _tmp77_) != 0;
				} else {
					_tmp68_ = FALSE;
				}
				if (_tmp68_) {
					GError* _tmp78_ = NULL;
					_tmp78_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Illegal event: unless event.interpretation is " "'MOVE_EVENT' then subject.origin and " "subject.current_origin have to be the same");
					_inner_error_ = _tmp78_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp79_ = subject;
				_tmp80_ = zeitgeist_subject_get_manifestation (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = zeitgeist_utils_is_empty_string (_tmp81_);
				if (_tmp82_) {
					const gchar* manifestation = NULL;
					ZeitgeistSubject* _tmp83_ = NULL;
					const gchar* _tmp84_ = NULL;
					const gchar* _tmp85_ = NULL;
					const gchar* _tmp86_ = NULL;
					const gchar* _tmp87_ = NULL;
					_tmp83_ = subject;
					_tmp84_ = zeitgeist_subject_get_uri (_tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = zeitgeist_manifestation_for_uri (_tmp85_);
					manifestation = _tmp86_;
					_tmp87_ = manifestation;
					if (_tmp87_ != NULL) {
						ZeitgeistSubject* _tmp88_ = NULL;
						const gchar* _tmp89_ = NULL;
						_tmp88_ = subject;
						_tmp89_ = manifestation;
						zeitgeist_subject_set_manifestation (_tmp88_, _tmp89_);
					}
				}
				_tmp90_ = subject;
				_tmp91_ = zeitgeist_subject_get_interpretation (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = zeitgeist_utils_is_empty_string (_tmp92_);
				if (_tmp93_) {
					const gchar* interpretation = NULL;
					ZeitgeistSubject* _tmp94_ = NULL;
					const gchar* _tmp95_ = NULL;
					const gchar* _tmp96_ = NULL;
					const gchar* _tmp97_ = NULL;
					const gchar* _tmp98_ = NULL;
					_tmp94_ = subject;
					_tmp95_ = zeitgeist_subject_get_mimetype (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = zeitgeist_interpretation_for_mimetype (_tmp96_);
					interpretation = _tmp97_;
					_tmp98_ = interpretation;
					if (_tmp98_ != NULL) {
						ZeitgeistSubject* _tmp99_ = NULL;
						const gchar* _tmp100_ = NULL;
						_tmp99_ = subject;
						_tmp100_ = interpretation;
						zeitgeist_subject_set_interpretation (_tmp99_, _tmp100_);
					}
				}
			}
		}
	}
}


/**
     * Makes sure all the URIs, texts and storage values used
     * by the given events are in the database.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static void zeitgeist_engine_insert_event_data (ZeitgeistEngine* self, GPtrArray* events, GError** error) {
	ZeitgeistEngineDataInserter* uris = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_ = NULL;
	ZeitgeistEngineDataInserter* _tmp2_ = NULL;
	ZeitgeistEngineDataInserter* texts = NULL;
	ZeitgeistSQLiteDatabase* _tmp3_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp4_ = NULL;
	ZeitgeistEngineDataInserter* _tmp5_ = NULL;
	ZeitgeistEngineDataInserter* storages = NULL;
	ZeitgeistSQLiteDatabase* _tmp6_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp7_ = NULL;
	ZeitgeistEngineDataInserter* _tmp8_ = NULL;
	ZeitgeistEngineDataInserter* _tmp99_ = NULL;
	ZeitgeistEngineDataInserter* _tmp100_ = NULL;
	ZeitgeistEngineDataInserter* _tmp101_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = zeitgeist_engine_data_inserter_new (_tmp1_, "uri");
	uris = _tmp2_;
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_engine_data_inserter_new (_tmp4_, "text");
	texts = _tmp5_;
	_tmp6_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = zeitgeist_engine_data_inserter_new (_tmp7_, "storage");
	storages = _tmp8_;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				GPtrArray* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				GPtrArray* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gconstpointer _tmp17_ = NULL;
				ZeitgeistEvent* event = NULL;
				GPtrArray* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gconstpointer _tmp20_ = NULL;
				ZeitgeistEvent* _tmp21_ = NULL;
				GSList* subj_uris = NULL;
				ZeitgeistEvent* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = j;
					j = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = j;
				_tmp12_ = events;
				_tmp13_ = g_ptr_array_get_length (_tmp12_);
				_tmp14_ = _tmp13_;
				if (!(_tmp11_ < _tmp14_)) {
					break;
				}
				_tmp15_ = events;
				_tmp16_ = j;
				_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
				if (((ZeitgeistEvent*) _tmp17_) == NULL) {
					continue;
				}
				_tmp18_ = events;
				_tmp19_ = j;
				_tmp20_ = g_ptr_array_index (_tmp18_, (guint) _tmp19_);
				_tmp21_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp20_);
				event = _tmp21_;
				subj_uris = NULL;
				_tmp22_ = event;
				_tmp23_ = zeitgeist_event_get_origin (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = zeitgeist_utils_is_empty_string (_tmp24_);
				if (!_tmp25_) {
					ZeitgeistEngineDataInserter* _tmp26_ = NULL;
					ZeitgeistEvent* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					_tmp26_ = uris;
					_tmp27_ = event;
					_tmp28_ = zeitgeist_event_get_origin (_tmp27_);
					_tmp29_ = _tmp28_;
					zeitgeist_engine_data_inserter_add (_tmp26_, _tmp29_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							__g_slist_free__g_free0_0 (subj_uris);
							_g_object_unref0 (event);
							_zeitgeist_engine_data_inserter_unref0 (storages);
							_zeitgeist_engine_data_inserter_unref0 (texts);
							_zeitgeist_engine_data_inserter_unref0 (uris);
							return;
						} else {
							__g_slist_free__g_free0_0 (subj_uris);
							_g_object_unref0 (event);
							_zeitgeist_engine_data_inserter_unref0 (storages);
							_zeitgeist_engine_data_inserter_unref0 (texts);
							_zeitgeist_engine_data_inserter_unref0 (uris);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp30_ = FALSE;
						_tmp30_ = TRUE;
						while (TRUE) {
							gint _tmp32_ = 0;
							ZeitgeistEvent* _tmp33_ = NULL;
							gint _tmp34_ = 0;
							ZeitgeistSubject* subject = NULL;
							ZeitgeistEvent* _tmp35_ = NULL;
							GPtrArray* _tmp36_ = NULL;
							GPtrArray* _tmp37_ = NULL;
							gint _tmp38_ = 0;
							gconstpointer _tmp39_ = NULL;
							GSList* _tmp40_ = NULL;
							ZeitgeistSubject* _tmp41_ = NULL;
							const gchar* _tmp42_ = NULL;
							const gchar* _tmp43_ = NULL;
							GCompareFunc _tmp44_ = NULL;
							GSList* _tmp45_ = NULL;
							ZeitgeistSubject* _tmp47_ = NULL;
							const gchar* _tmp48_ = NULL;
							const gchar* _tmp49_ = NULL;
							gchar* _tmp50_ = NULL;
							ZeitgeistEngineDataInserter* _tmp51_ = NULL;
							ZeitgeistSubject* _tmp52_ = NULL;
							const gchar* _tmp53_ = NULL;
							const gchar* _tmp54_ = NULL;
							ZeitgeistSubject* _tmp55_ = NULL;
							const gchar* _tmp56_ = NULL;
							const gchar* _tmp57_ = NULL;
							ZeitgeistSubject* _tmp58_ = NULL;
							const gchar* _tmp59_ = NULL;
							const gchar* _tmp60_ = NULL;
							ZeitgeistSubject* _tmp65_ = NULL;
							const gchar* _tmp66_ = NULL;
							const gchar* _tmp67_ = NULL;
							ZeitgeistSubject* _tmp68_ = NULL;
							const gchar* _tmp69_ = NULL;
							const gchar* _tmp70_ = NULL;
							ZeitgeistSubject* _tmp75_ = NULL;
							const gchar* _tmp76_ = NULL;
							const gchar* _tmp77_ = NULL;
							gboolean _tmp78_ = FALSE;
							ZeitgeistSubject* _tmp83_ = NULL;
							const gchar* _tmp84_ = NULL;
							const gchar* _tmp85_ = NULL;
							gboolean _tmp86_ = FALSE;
							ZeitgeistSubject* _tmp91_ = NULL;
							const gchar* _tmp92_ = NULL;
							const gchar* _tmp93_ = NULL;
							gboolean _tmp94_ = FALSE;
							if (!_tmp30_) {
								gint _tmp31_ = 0;
								_tmp31_ = i;
								i = _tmp31_ + 1;
							}
							_tmp30_ = FALSE;
							_tmp32_ = i;
							_tmp33_ = event;
							_tmp34_ = zeitgeist_event_num_subjects (_tmp33_);
							if (!(_tmp32_ < _tmp34_)) {
								break;
							}
							_tmp35_ = event;
							_tmp36_ = zeitgeist_event_get_subjects (_tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = i;
							_tmp39_ = g_ptr_array_index (_tmp37_, (guint) _tmp38_);
							subject = (ZeitgeistSubject*) _tmp39_;
							_tmp40_ = subj_uris;
							_tmp41_ = subject;
							_tmp42_ = zeitgeist_subject_get_uri (_tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = g_strcmp0;
							_tmp45_ = g_slist_find_custom (_tmp40_, _tmp43_, _tmp44_);
							if (_tmp45_ != NULL) {
								GError* _tmp46_ = NULL;
								_tmp46_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_EVENT, "Events with two subjects with the same URI are not supported");
								_inner_error_ = _tmp46_;
								if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
									g_propagate_error (error, _inner_error_);
									__g_slist_free__g_free0_0 (subj_uris);
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									return;
								} else {
									__g_slist_free__g_free0_0 (subj_uris);
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp47_ = subject;
							_tmp48_ = zeitgeist_subject_get_uri (_tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = g_strdup (_tmp49_);
							subj_uris = g_slist_append (subj_uris, _tmp50_);
							_tmp51_ = uris;
							_tmp52_ = subject;
							_tmp53_ = zeitgeist_subject_get_uri (_tmp52_);
							_tmp54_ = _tmp53_;
							zeitgeist_engine_data_inserter_add (_tmp51_, _tmp54_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
									g_propagate_error (error, _inner_error_);
									__g_slist_free__g_free0_0 (subj_uris);
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									return;
								} else {
									__g_slist_free__g_free0_0 (subj_uris);
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp55_ = subject;
							_tmp56_ = zeitgeist_subject_get_uri (_tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = subject;
							_tmp59_ = zeitgeist_subject_get_current_uri (_tmp58_);
							_tmp60_ = _tmp59_;
							if (g_strcmp0 (_tmp57_, _tmp60_) != 0) {
								ZeitgeistEngineDataInserter* _tmp61_ = NULL;
								ZeitgeistSubject* _tmp62_ = NULL;
								const gchar* _tmp63_ = NULL;
								const gchar* _tmp64_ = NULL;
								_tmp61_ = uris;
								_tmp62_ = subject;
								_tmp63_ = zeitgeist_subject_get_current_uri (_tmp62_);
								_tmp64_ = _tmp63_;
								zeitgeist_engine_data_inserter_add (_tmp61_, _tmp64_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
							_tmp65_ = subject;
							_tmp66_ = zeitgeist_subject_get_origin (_tmp65_);
							_tmp67_ = _tmp66_;
							_tmp68_ = subject;
							_tmp69_ = zeitgeist_subject_get_current_origin (_tmp68_);
							_tmp70_ = _tmp69_;
							if (g_strcmp0 (_tmp67_, _tmp70_) != 0) {
								ZeitgeistEngineDataInserter* _tmp71_ = NULL;
								ZeitgeistSubject* _tmp72_ = NULL;
								const gchar* _tmp73_ = NULL;
								const gchar* _tmp74_ = NULL;
								_tmp71_ = uris;
								_tmp72_ = subject;
								_tmp73_ = zeitgeist_subject_get_current_origin (_tmp72_);
								_tmp74_ = _tmp73_;
								zeitgeist_engine_data_inserter_add (_tmp71_, _tmp74_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
							_tmp75_ = subject;
							_tmp76_ = zeitgeist_subject_get_origin (_tmp75_);
							_tmp77_ = _tmp76_;
							_tmp78_ = zeitgeist_utils_is_empty_string (_tmp77_);
							if (!_tmp78_) {
								ZeitgeistEngineDataInserter* _tmp79_ = NULL;
								ZeitgeistSubject* _tmp80_ = NULL;
								const gchar* _tmp81_ = NULL;
								const gchar* _tmp82_ = NULL;
								_tmp79_ = uris;
								_tmp80_ = subject;
								_tmp81_ = zeitgeist_subject_get_origin (_tmp80_);
								_tmp82_ = _tmp81_;
								zeitgeist_engine_data_inserter_add (_tmp79_, _tmp82_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
							_tmp83_ = subject;
							_tmp84_ = zeitgeist_subject_get_text (_tmp83_);
							_tmp85_ = _tmp84_;
							_tmp86_ = zeitgeist_utils_is_empty_string (_tmp85_);
							if (!_tmp86_) {
								ZeitgeistEngineDataInserter* _tmp87_ = NULL;
								ZeitgeistSubject* _tmp88_ = NULL;
								const gchar* _tmp89_ = NULL;
								const gchar* _tmp90_ = NULL;
								_tmp87_ = texts;
								_tmp88_ = subject;
								_tmp89_ = zeitgeist_subject_get_text (_tmp88_);
								_tmp90_ = _tmp89_;
								zeitgeist_engine_data_inserter_add (_tmp87_, _tmp90_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
							_tmp91_ = subject;
							_tmp92_ = zeitgeist_subject_get_storage (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = zeitgeist_utils_is_empty_string (_tmp93_);
							if (!_tmp94_) {
								ZeitgeistEngineDataInserter* _tmp95_ = NULL;
								ZeitgeistSubject* _tmp96_ = NULL;
								const gchar* _tmp97_ = NULL;
								const gchar* _tmp98_ = NULL;
								_tmp95_ = storages;
								_tmp96_ = subject;
								_tmp97_ = zeitgeist_subject_get_storage (_tmp96_);
								_tmp98_ = _tmp97_;
								zeitgeist_engine_data_inserter_add (_tmp95_, _tmp98_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
				}
				__g_slist_free__g_free0_0 (subj_uris);
				_g_object_unref0 (event);
			}
		}
	}
	_tmp99_ = uris;
	zeitgeist_engine_data_inserter_flush (_tmp99_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			return;
		} else {
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp100_ = texts;
	zeitgeist_engine_data_inserter_flush (_tmp100_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			return;
		} else {
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp101_ = storages;
	zeitgeist_engine_data_inserter_flush (_tmp101_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			return;
		} else {
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_zeitgeist_engine_data_inserter_unref0 (storages);
	_zeitgeist_engine_data_inserter_unref0 (texts);
	_zeitgeist_engine_data_inserter_unref0 (uris);
}


static void zeitgeist_engine_bind_cached_reference (ZeitgeistEngine* self, sqlite3_stmt* stmt, gint position, ZeitgeistSQLiteTableLookup* table, const gchar* value_, GError** error) {
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (table != NULL);
	_tmp0_ = value_;
	if (_tmp0_ != NULL) {
		gint _tmp1_ = 0;
		ZeitgeistSQLiteTableLookup* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		sqlite3_stmt* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp2_ = table;
		_tmp3_ = value_;
		_tmp4_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp2_, _tmp3_, &_inner_error_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp5_ = stmt;
		_tmp6_ = position;
		sqlite3_bind_int64 (_tmp5_, _tmp6_, (gint64) _tmp1_);
	} else {
		sqlite3_stmt* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp7_ = stmt;
		_tmp8_ = position;
		sqlite3_bind_null (_tmp7_, _tmp8_);
	}
}


static guint32 zeitgeist_engine_insert_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error) {
	guint32 result = 0U;
	ZeitgeistEvent* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	guint32 _tmp2_ = 0U;
	ZeitgeistEvent* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	ZeitgeistEvent* _tmp5_ = NULL;
	guint32 _tmp6_ = 0U;
	guint32 _tmp7_ = 0U;
	gint64 payload_id = 0LL;
	ZeitgeistEvent* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint rc = 0;
	sqlite3_stmt* insert_stmt = NULL;
	ZeitgeistSQLiteDatabase* _tmp10_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp11_ = NULL;
	sqlite3_stmt* _tmp12_ = NULL;
	ZeitgeistEvent* _tmp151_ = NULL;
	const gchar* _tmp152_ = NULL;
	const gchar* _tmp153_ = NULL;
	ZeitgeistEvent* _tmp155_ = NULL;
	guint32 _tmp156_ = 0U;
	guint32 _tmp157_ = 0U;
	ZeitgeistEvent* _tmp160_ = NULL;
	guint32 _tmp161_ = 0U;
	guint32 _tmp162_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (event != NULL, 0U);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (_tmp2_ == ((guint32) 0), 0U);
	_tmp3_ = event;
	_tmp4_ = zeitgeist_event_num_subjects (_tmp3_);
	g_return_val_if_fail (_tmp4_ > 0, 0U);
	_tmp5_ = event;
	_tmp6_ = self->priv->last_id;
	self->priv->last_id = _tmp6_ + 1;
	_tmp7_ = self->priv->last_id;
	zeitgeist_event_set_id (_tmp5_, _tmp7_);
	_tmp8_ = event;
	_tmp9_ = zeitgeist_engine_store_payload (self, _tmp8_);
	payload_id = _tmp9_;
	_tmp10_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->event_insertion_stmt;
	insert_stmt = _tmp12_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gint _tmp15_ = 0;
				ZeitgeistEvent* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				sqlite3_stmt* _tmp18_ = NULL;
				sqlite3_stmt* _tmp19_ = NULL;
				ZeitgeistEvent* _tmp20_ = NULL;
				guint32 _tmp21_ = 0U;
				guint32 _tmp22_ = 0U;
				sqlite3_stmt* _tmp23_ = NULL;
				ZeitgeistEvent* _tmp24_ = NULL;
				gint64 _tmp25_ = 0LL;
				gint64 _tmp26_ = 0LL;
				sqlite3_stmt* _tmp27_ = NULL;
				ZeitgeistSQLiteTableLookup* _tmp28_ = NULL;
				ZeitgeistEvent* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				sqlite3_stmt* _tmp32_ = NULL;
				ZeitgeistSQLiteTableLookup* _tmp33_ = NULL;
				ZeitgeistEvent* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				sqlite3_stmt* _tmp37_ = NULL;
				ZeitgeistSQLiteTableLookup* _tmp38_ = NULL;
				ZeitgeistEvent* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				sqlite3_stmt* _tmp42_ = NULL;
				ZeitgeistEvent* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				GDestroyNotify _tmp47_ = NULL;
				sqlite3_stmt* _tmp48_ = NULL;
				gint64 _tmp49_ = 0LL;
				ZeitgeistSubject* subject = NULL;
				ZeitgeistEvent* _tmp50_ = NULL;
				GPtrArray* _tmp51_ = NULL;
				GPtrArray* _tmp52_ = NULL;
				gint _tmp53_ = 0;
				gconstpointer _tmp54_ = NULL;
				sqlite3_stmt* _tmp55_ = NULL;
				ZeitgeistSubject* _tmp56_ = NULL;
				const gchar* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				gchar* _tmp59_ = NULL;
				GDestroyNotify _tmp60_ = NULL;
				sqlite3_stmt* _tmp61_ = NULL;
				ZeitgeistSubject* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
				const gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				GDestroyNotify _tmp66_ = NULL;
				sqlite3_stmt* _tmp67_ = NULL;
				ZeitgeistSQLiteTableLookup* _tmp68_ = NULL;
				ZeitgeistSubject* _tmp69_ = NULL;
				const gchar* _tmp70_ = NULL;
				const gchar* _tmp71_ = NULL;
				sqlite3_stmt* _tmp72_ = NULL;
				ZeitgeistSQLiteTableLookup* _tmp73_ = NULL;
				ZeitgeistSubject* _tmp74_ = NULL;
				const gchar* _tmp75_ = NULL;
				const gchar* _tmp76_ = NULL;
				sqlite3_stmt* _tmp77_ = NULL;
				ZeitgeistSubject* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				GDestroyNotify _tmp82_ = NULL;
				sqlite3_stmt* _tmp83_ = NULL;
				ZeitgeistSubject* _tmp84_ = NULL;
				const gchar* _tmp85_ = NULL;
				const gchar* _tmp86_ = NULL;
				gchar* _tmp87_ = NULL;
				GDestroyNotify _tmp88_ = NULL;
				sqlite3_stmt* _tmp89_ = NULL;
				ZeitgeistSQLiteTableLookup* _tmp90_ = NULL;
				ZeitgeistSubject* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				const gchar* _tmp93_ = NULL;
				sqlite3_stmt* _tmp94_ = NULL;
				ZeitgeistSubject* _tmp95_ = NULL;
				const gchar* _tmp96_ = NULL;
				const gchar* _tmp97_ = NULL;
				gchar* _tmp98_ = NULL;
				GDestroyNotify _tmp99_ = NULL;
				sqlite3_stmt* _tmp100_ = NULL;
				ZeitgeistSubject* _tmp101_ = NULL;
				const gchar* _tmp102_ = NULL;
				const gchar* _tmp103_ = NULL;
				gchar* _tmp104_ = NULL;
				GDestroyNotify _tmp105_ = NULL;
				sqlite3_stmt* _tmp106_ = NULL;
				gint _tmp107_ = 0;
				gint _tmp108_ = 0;
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = i;
				_tmp16_ = event;
				_tmp17_ = zeitgeist_event_num_subjects (_tmp16_);
				if (!(_tmp15_ < _tmp17_)) {
					break;
				}
				_tmp18_ = insert_stmt;
				sqlite3_reset (_tmp18_);
				_tmp19_ = insert_stmt;
				_tmp20_ = event;
				_tmp21_ = zeitgeist_event_get_id (_tmp20_);
				_tmp22_ = _tmp21_;
				sqlite3_bind_int64 (_tmp19_, 1, (gint64) _tmp22_);
				_tmp23_ = insert_stmt;
				_tmp24_ = event;
				_tmp25_ = zeitgeist_event_get_timestamp (_tmp24_);
				_tmp26_ = _tmp25_;
				sqlite3_bind_int64 (_tmp23_, 2, _tmp26_);
				_tmp27_ = insert_stmt;
				_tmp28_ = ((ZeitgeistDbReader*) self)->interpretations_table;
				_tmp29_ = event;
				_tmp30_ = zeitgeist_event_get_interpretation (_tmp29_);
				_tmp31_ = _tmp30_;
				zeitgeist_engine_bind_cached_reference (self, _tmp27_, 3, _tmp28_, _tmp31_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0U;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
				}
				_tmp32_ = insert_stmt;
				_tmp33_ = ((ZeitgeistDbReader*) self)->manifestations_table;
				_tmp34_ = event;
				_tmp35_ = zeitgeist_event_get_manifestation (_tmp34_);
				_tmp36_ = _tmp35_;
				zeitgeist_engine_bind_cached_reference (self, _tmp32_, 4, _tmp33_, _tmp36_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0U;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
				}
				_tmp37_ = insert_stmt;
				_tmp38_ = ((ZeitgeistDbReader*) self)->actors_table;
				_tmp39_ = event;
				_tmp40_ = zeitgeist_event_get_actor (_tmp39_);
				_tmp41_ = _tmp40_;
				zeitgeist_engine_bind_cached_reference (self, _tmp37_, 5, _tmp38_, _tmp41_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0U;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
				}
				_tmp42_ = insert_stmt;
				_tmp43_ = event;
				_tmp44_ = zeitgeist_event_get_origin (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strdup (_tmp45_);
				_tmp47_ = g_free;
				sqlite3_bind_text (_tmp42_, 6, _tmp46_, -1, _tmp47_);
				_tmp48_ = insert_stmt;
				_tmp49_ = payload_id;
				sqlite3_bind_int64 (_tmp48_, 7, _tmp49_);
				_tmp50_ = event;
				_tmp51_ = zeitgeist_event_get_subjects (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = i;
				_tmp54_ = g_ptr_array_index (_tmp52_, (guint) _tmp53_);
				subject = (ZeitgeistSubject*) _tmp54_;
				_tmp55_ = insert_stmt;
				_tmp56_ = subject;
				_tmp57_ = zeitgeist_subject_get_uri (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_strdup (_tmp58_);
				_tmp60_ = g_free;
				sqlite3_bind_text (_tmp55_, 8, _tmp59_, -1, _tmp60_);
				_tmp61_ = insert_stmt;
				_tmp62_ = subject;
				_tmp63_ = zeitgeist_subject_get_current_uri (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strdup (_tmp64_);
				_tmp66_ = g_free;
				sqlite3_bind_text (_tmp61_, 9, _tmp65_, -1, _tmp66_);
				_tmp67_ = insert_stmt;
				_tmp68_ = ((ZeitgeistDbReader*) self)->interpretations_table;
				_tmp69_ = subject;
				_tmp70_ = zeitgeist_subject_get_interpretation (_tmp69_);
				_tmp71_ = _tmp70_;
				zeitgeist_engine_bind_cached_reference (self, _tmp67_, 10, _tmp68_, _tmp71_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0U;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
				}
				_tmp72_ = insert_stmt;
				_tmp73_ = ((ZeitgeistDbReader*) self)->manifestations_table;
				_tmp74_ = subject;
				_tmp75_ = zeitgeist_subject_get_manifestation (_tmp74_);
				_tmp76_ = _tmp75_;
				zeitgeist_engine_bind_cached_reference (self, _tmp72_, 11, _tmp73_, _tmp76_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0U;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
				}
				_tmp77_ = insert_stmt;
				_tmp78_ = subject;
				_tmp79_ = zeitgeist_subject_get_origin (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = g_strdup (_tmp80_);
				_tmp82_ = g_free;
				sqlite3_bind_text (_tmp77_, 12, _tmp81_, -1, _tmp82_);
				_tmp83_ = insert_stmt;
				_tmp84_ = subject;
				_tmp85_ = zeitgeist_subject_get_current_origin (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = g_strdup (_tmp86_);
				_tmp88_ = g_free;
				sqlite3_bind_text (_tmp83_, 13, _tmp87_, -1, _tmp88_);
				_tmp89_ = insert_stmt;
				_tmp90_ = ((ZeitgeistDbReader*) self)->mimetypes_table;
				_tmp91_ = subject;
				_tmp92_ = zeitgeist_subject_get_mimetype (_tmp91_);
				_tmp93_ = _tmp92_;
				zeitgeist_engine_bind_cached_reference (self, _tmp89_, 14, _tmp90_, _tmp93_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0U;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					}
				}
				_tmp94_ = insert_stmt;
				_tmp95_ = subject;
				_tmp96_ = zeitgeist_subject_get_text (_tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = g_strdup (_tmp97_);
				_tmp99_ = g_free;
				sqlite3_bind_text (_tmp94_, 15, _tmp98_, -1, _tmp99_);
				_tmp100_ = insert_stmt;
				_tmp101_ = subject;
				_tmp102_ = zeitgeist_subject_get_storage (_tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = g_strdup (_tmp103_);
				_tmp105_ = g_free;
				sqlite3_bind_text (_tmp100_, 16, _tmp104_, -1, _tmp105_);
				_tmp106_ = insert_stmt;
				_tmp107_ = sqlite3_step (_tmp106_);
				rc = _tmp107_;
				_tmp108_ = rc;
				if (_tmp108_ != SQLITE_DONE) {
					gint _tmp109_ = 0;
					guint32 _tmp116_ = 0U;
					sqlite3_stmt* retrieval_stmt = NULL;
					ZeitgeistSQLiteDatabase* _tmp117_ = NULL;
					ZeitgeistSQLiteDatabase* _tmp118_ = NULL;
					sqlite3_stmt* _tmp119_ = NULL;
					sqlite3_stmt* _tmp120_ = NULL;
					sqlite3_stmt* _tmp121_ = NULL;
					ZeitgeistEvent* _tmp122_ = NULL;
					gint64 _tmp123_ = 0LL;
					gint64 _tmp124_ = 0LL;
					sqlite3_stmt* _tmp125_ = NULL;
					ZeitgeistSQLiteTableLookup* _tmp126_ = NULL;
					ZeitgeistEvent* _tmp127_ = NULL;
					const gchar* _tmp128_ = NULL;
					const gchar* _tmp129_ = NULL;
					sqlite3_stmt* _tmp130_ = NULL;
					ZeitgeistSQLiteTableLookup* _tmp131_ = NULL;
					ZeitgeistEvent* _tmp132_ = NULL;
					const gchar* _tmp133_ = NULL;
					const gchar* _tmp134_ = NULL;
					sqlite3_stmt* _tmp135_ = NULL;
					ZeitgeistSQLiteTableLookup* _tmp136_ = NULL;
					ZeitgeistEvent* _tmp137_ = NULL;
					const gchar* _tmp138_ = NULL;
					const gchar* _tmp139_ = NULL;
					sqlite3_stmt* _tmp140_ = NULL;
					gint _tmp141_ = 0;
					gint _tmp142_ = 0;
					sqlite3_stmt* _tmp149_ = NULL;
					gint _tmp150_ = 0;
					_tmp109_ = rc;
					if (_tmp109_ != SQLITE_CONSTRAINT) {
						ZeitgeistSQLiteDatabase* _tmp110_ = NULL;
						ZeitgeistSQLiteDatabase* _tmp111_ = NULL;
						gint _tmp112_ = 0;
						gint _tmp113_ = 0;
						sqlite3* _tmp114_ = NULL;
						const gchar* _tmp115_ = NULL;
						_tmp110_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
						_tmp111_ = _tmp110_;
						_tmp112_ = rc;
						zeitgeist_sq_lite_database_assert_not_corrupt (_tmp111_, _tmp112_, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0U;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0U;
							}
						}
						_tmp113_ = rc;
						_tmp114_ = ((ZeitgeistDbReader*) self)->db;
						_tmp115_ = sqlite3_errmsg (_tmp114_);
						g_warning ("engine.vala:330: SQL error: %d, %s\n", _tmp113_, _tmp115_);
						result = (guint32) 0;
						return result;
					}
					_tmp116_ = self->priv->last_id;
					self->priv->last_id = _tmp116_ - 1;
					_tmp117_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
					_tmp118_ = _tmp117_;
					_tmp119_ = _tmp118_->id_retrieval_stmt;
					retrieval_stmt = _tmp119_;
					_tmp120_ = retrieval_stmt;
					sqlite3_reset (_tmp120_);
					_tmp121_ = retrieval_stmt;
					_tmp122_ = event;
					_tmp123_ = zeitgeist_event_get_timestamp (_tmp122_);
					_tmp124_ = _tmp123_;
					sqlite3_bind_int64 (_tmp121_, 1, _tmp124_);
					_tmp125_ = retrieval_stmt;
					_tmp126_ = ((ZeitgeistDbReader*) self)->interpretations_table;
					_tmp127_ = event;
					_tmp128_ = zeitgeist_event_get_interpretation (_tmp127_);
					_tmp129_ = _tmp128_;
					zeitgeist_engine_bind_cached_reference (self, _tmp125_, 2, _tmp126_, _tmp129_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0U;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0U;
						}
					}
					_tmp130_ = retrieval_stmt;
					_tmp131_ = ((ZeitgeistDbReader*) self)->manifestations_table;
					_tmp132_ = event;
					_tmp133_ = zeitgeist_event_get_manifestation (_tmp132_);
					_tmp134_ = _tmp133_;
					zeitgeist_engine_bind_cached_reference (self, _tmp130_, 3, _tmp131_, _tmp134_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0U;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0U;
						}
					}
					_tmp135_ = retrieval_stmt;
					_tmp136_ = ((ZeitgeistDbReader*) self)->actors_table;
					_tmp137_ = event;
					_tmp138_ = zeitgeist_event_get_actor (_tmp137_);
					_tmp139_ = _tmp138_;
					zeitgeist_engine_bind_cached_reference (self, _tmp135_, 4, _tmp136_, _tmp139_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0U;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0U;
						}
					}
					_tmp140_ = retrieval_stmt;
					_tmp141_ = sqlite3_step (_tmp140_);
					rc = _tmp141_;
					_tmp142_ = rc;
					if (_tmp142_ != SQLITE_ROW) {
						ZeitgeistSQLiteDatabase* _tmp143_ = NULL;
						ZeitgeistSQLiteDatabase* _tmp144_ = NULL;
						gint _tmp145_ = 0;
						gint _tmp146_ = 0;
						sqlite3* _tmp147_ = NULL;
						const gchar* _tmp148_ = NULL;
						_tmp143_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
						_tmp144_ = _tmp143_;
						_tmp145_ = rc;
						zeitgeist_sq_lite_database_assert_not_corrupt (_tmp144_, _tmp145_, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0U;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0U;
							}
						}
						_tmp146_ = rc;
						_tmp147_ = ((ZeitgeistDbReader*) self)->db;
						_tmp148_ = sqlite3_errmsg (_tmp147_);
						g_warning ("engine.vala:352: SQL error: %d, %s\n", _tmp146_, _tmp148_);
						result = (guint32) 0;
						return result;
					}
					_tmp149_ = retrieval_stmt;
					_tmp150_ = sqlite3_column_int (_tmp149_, 0);
					result = (guint32) _tmp150_;
					return result;
				}
			}
		}
	}
	_tmp151_ = event;
	_tmp152_ = zeitgeist_event_get_interpretation (_tmp151_);
	_tmp153_ = _tmp152_;
	if (g_strcmp0 (_tmp153_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
		ZeitgeistEvent* _tmp154_ = NULL;
		_tmp154_ = event;
		zeitgeist_engine_handle_move_event (self, _tmp154_);
	}
	_tmp155_ = event;
	_tmp156_ = zeitgeist_event_get_id (_tmp155_);
	_tmp157_ = _tmp156_;
	if ((_tmp157_ % 1000) == ((guint32) 0)) {
		ZeitgeistSQLiteDatabase* _tmp158_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp159_ = NULL;
		_tmp158_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp159_ = _tmp158_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, (GSourceFunc) zeitgeist_sq_lite_database_analyze, g_object_ref (_tmp159_), NULL);
	}
	_tmp160_ = event;
	_tmp161_ = zeitgeist_event_get_id (_tmp160_);
	_tmp162_ = _tmp161_;
	result = _tmp162_;
	return result;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3_callback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error) {
	ZeitgeistTimeRange* result = NULL;
	guint32* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	ZeitgeistExtensionCollection* _tmp1_ = NULL;
	guint32* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const char* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	guint32* _tmp5_ = NULL;
	ZeitgeistTimeRange* time_range = NULL;
	ZeitgeistSQLiteDatabase* _tmp6_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp7_ = NULL;
	guint32* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	ZeitgeistTimeRange* _tmp9_ = NULL;
	gchar* sql_event_ids = NULL;
	ZeitgeistSQLiteDatabase* _tmp10_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp11_ = NULL;
	guint32* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gchar* _tmp13_ = NULL;
	ZeitgeistTimeRange* _tmp14_ = NULL;
	gint rc = 0;
	sqlite3* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	ZeitgeistSQLiteDatabase* _tmp24_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	sqlite3* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	guint32* _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	ZeitgeistExtensionCollection* _tmp32_ = NULL;
	guint32* _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	const char* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	g_return_val_if_fail (_tmp0__length1 > 0, NULL);
	_tmp1_ = self->priv->extension_collection;
	_tmp2_ = event_ids;
	_tmp2__length1 = event_ids_length1;
	_tmp3_ = sender;
	_tmp5_ = zeitgeist_extension_collection_call_pre_delete_events (_tmp1_, _tmp2_, _tmp2__length1, _tmp3_, &_tmp4_);
	event_ids = _tmp5_;
	event_ids_length1 = _tmp4_;
	_tmp6_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = event_ids;
	_tmp8__length1 = event_ids_length1;
	_tmp9_ = zeitgeist_sq_lite_database_get_time_range_for_event_ids (_tmp7_, _tmp8_, _tmp8__length1, &_inner_error_);
	time_range = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = event_ids;
	_tmp12__length1 = event_ids_length1;
	_tmp13_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp11_, _tmp12_, _tmp12__length1);
	sql_event_ids = _tmp13_;
	_tmp14_ = time_range;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp15_ = sql_event_ids;
		_tmp16_ = g_strdup_printf ("Tried to delete non-existing event(s): %s", _tmp15_);
		_tmp17_ = _tmp16_;
		g_warning ("engine.vala:385: %s", _tmp17_);
		_g_free0 (_tmp17_);
		result = NULL;
		_g_free0 (sql_event_ids);
		_g_object_unref0 (time_range);
		return result;
	}
	_tmp18_ = ((ZeitgeistDbReader*) self)->db;
	_tmp19_ = sql_event_ids;
	_tmp20_ = g_strdup_printf ("DELETE FROM event WHERE id IN (%s)", _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _sqlite3_exec (_tmp18_, _tmp21_, NULL, NULL, NULL);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	rc = _tmp23_;
	_tmp24_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp25_, _tmp26_, "engine.vala:392: SQL Error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			return NULL;
		} else {
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp27_ = ((ZeitgeistDbReader*) self)->db;
	_tmp28_ = sqlite3_changes (_tmp27_);
	_tmp29_ = event_ids;
	_tmp29__length1 = event_ids_length1;
	_tmp30_ = g_strdup_printf ("Deleted %d (out of %d) events.", _tmp28_, _tmp29__length1);
	_tmp31_ = _tmp30_;
	g_message ("engine.vala:393: %s", _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = self->priv->extension_collection;
	_tmp33_ = event_ids;
	_tmp33__length1 = event_ids_length1;
	_tmp34_ = sender;
	zeitgeist_extension_collection_call_post_delete_events (_tmp32_, _tmp33_, _tmp33__length1, _tmp34_);
	result = time_range;
	_g_free0 (sql_event_ids);
	return result;
}


/**
     * Clear all resources Engine is using (close database connection,
     * unload extensions, etc.).
     *
     * After executing this method on an Engine instance, no other function
     * of said instance may be called.
     */
static void zeitgeist_engine_real_close (ZeitgeistDbReader* base) {
	ZeitgeistEngine * self;
	self = (ZeitgeistEngine*) base;
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = NULL;
	ZEITGEIST_DB_READER_CLASS (zeitgeist_engine_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader));
}


static void zeitgeist_engine_handle_move_event (ZeitgeistEngine* self, ZeitgeistEvent* event) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				ZeitgeistEvent* _tmp3_ = NULL;
				GPtrArray* _tmp4_ = NULL;
				GPtrArray* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				ZeitgeistSubject* subject = NULL;
				ZeitgeistEvent* _tmp8_ = NULL;
				GPtrArray* _tmp9_ = NULL;
				GPtrArray* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gconstpointer _tmp12_ = NULL;
				ZeitgeistSubject* _tmp13_ = NULL;
				gint rc = 0;
				sqlite3_stmt* move_stmt = NULL;
				ZeitgeistSQLiteDatabase* _tmp14_ = NULL;
				ZeitgeistSQLiteDatabase* _tmp15_ = NULL;
				sqlite3_stmt* _tmp16_ = NULL;
				sqlite3_stmt* _tmp17_ = NULL;
				sqlite3_stmt* _tmp18_ = NULL;
				ZeitgeistSubject* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				GDestroyNotify _tmp23_ = NULL;
				sqlite3_stmt* _tmp24_ = NULL;
				ZeitgeistSubject* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				GDestroyNotify _tmp29_ = NULL;
				sqlite3_stmt* _tmp30_ = NULL;
				ZeitgeistSubject* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				GDestroyNotify _tmp35_ = NULL;
				sqlite3_stmt* _tmp36_ = NULL;
				ZeitgeistEvent* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				GDestroyNotify _tmp41_ = NULL;
				sqlite3_stmt* _tmp42_ = NULL;
				ZeitgeistEvent* _tmp43_ = NULL;
				gint64 _tmp44_ = 0LL;
				gint64 _tmp45_ = 0LL;
				sqlite3_stmt* _tmp46_ = NULL;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = event;
				_tmp4_ = zeitgeist_event_get_subjects (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp2_ < _tmp7_)) {
					break;
				}
				_tmp8_ = event;
				_tmp9_ = zeitgeist_event_get_subjects (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				_tmp13_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp12_);
				subject = _tmp13_;
				_tmp14_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_->move_handling_stmt;
				move_stmt = _tmp16_;
				_tmp17_ = move_stmt;
				sqlite3_reset (_tmp17_);
				_tmp18_ = move_stmt;
				_tmp19_ = subject;
				_tmp20_ = zeitgeist_subject_get_current_uri (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup (_tmp21_);
				_tmp23_ = g_free;
				sqlite3_bind_text (_tmp18_, 1, _tmp22_, -1, _tmp23_);
				_tmp24_ = move_stmt;
				_tmp25_ = subject;
				_tmp26_ = zeitgeist_subject_get_current_origin (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strdup (_tmp27_);
				_tmp29_ = g_free;
				sqlite3_bind_text (_tmp24_, 2, _tmp28_, -1, _tmp29_);
				_tmp30_ = move_stmt;
				_tmp31_ = subject;
				_tmp32_ = zeitgeist_subject_get_uri (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strdup (_tmp33_);
				_tmp35_ = g_free;
				sqlite3_bind_text (_tmp30_, 3, _tmp34_, -1, _tmp35_);
				_tmp36_ = move_stmt;
				_tmp37_ = event;
				_tmp38_ = zeitgeist_event_get_interpretation (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strdup (_tmp39_);
				_tmp41_ = g_free;
				sqlite3_bind_text (_tmp36_, 4, _tmp40_, -1, _tmp41_);
				_tmp42_ = move_stmt;
				_tmp43_ = event;
				_tmp44_ = zeitgeist_event_get_timestamp (_tmp43_);
				_tmp45_ = _tmp44_;
				sqlite3_bind_int64 (_tmp42_, 5, _tmp45_);
				_tmp46_ = move_stmt;
				_tmp47_ = sqlite3_step (_tmp46_);
				rc = _tmp47_;
				_tmp48_ = rc;
				if (_tmp48_ != SQLITE_DONE) {
					gint _tmp49_ = 0;
					_tmp49_ = rc;
					if (_tmp49_ != SQLITE_CONSTRAINT) {
						gint _tmp53_ = 0;
						sqlite3* _tmp54_ = NULL;
						const gchar* _tmp55_ = NULL;
						{
							ZeitgeistSQLiteDatabase* _tmp50_ = NULL;
							ZeitgeistSQLiteDatabase* _tmp51_ = NULL;
							gint _tmp52_ = 0;
							_tmp50_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
							_tmp51_ = _tmp50_;
							_tmp52_ = rc;
							zeitgeist_sq_lite_database_assert_not_corrupt (_tmp51_, _tmp52_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
									goto __catch1_zeitgeist_engine_error;
								}
								_g_object_unref0 (subject);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						goto __finally1;
						__catch1_zeitgeist_engine_error:
						{
							GError* err = NULL;
							err = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (err);
						}
						__finally1:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_object_unref0 (subject);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp53_ = rc;
						_tmp54_ = ((ZeitgeistDbReader*) self)->db;
						_tmp55_ = sqlite3_errmsg (_tmp54_);
						g_warning ("engine.vala:439: SQL error: %d, %s\n", _tmp53_, _tmp55_);
					}
				}
				_g_object_unref0 (subject);
			}
		}
	}
}


static gint64 zeitgeist_engine_store_payload (ZeitgeistEngine* self, ZeitgeistEvent* event) {
	gint64 result = 0LL;
	ZeitgeistEvent* _tmp0_ = NULL;
	GByteArray* _tmp1_ = NULL;
	GByteArray* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (event != NULL, 0LL);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_payload (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		gint rc = 0;
		sqlite3_stmt* payload_insertion_stmt = NULL;
		ZeitgeistSQLiteDatabase* _tmp3_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp4_ = NULL;
		sqlite3_stmt* _tmp5_ = NULL;
		sqlite3_stmt* _tmp6_ = NULL;
		sqlite3_stmt* _tmp7_ = NULL;
		ZeitgeistEvent* _tmp8_ = NULL;
		GByteArray* _tmp9_ = NULL;
		GByteArray* _tmp10_ = NULL;
		guint8* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		ZeitgeistEvent* _tmp12_ = NULL;
		GByteArray* _tmp13_ = NULL;
		GByteArray* _tmp14_ = NULL;
		guint8* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		sqlite3_stmt* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		ZeitgeistSQLiteDatabase* _tmp26_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp27_ = NULL;
		sqlite3* _tmp28_ = NULL;
		gint64 _tmp29_ = 0LL;
		_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_->payload_insertion_stmt;
		payload_insertion_stmt = _tmp5_;
		_tmp6_ = payload_insertion_stmt;
		sqlite3_reset (_tmp6_);
		_tmp7_ = payload_insertion_stmt;
		_tmp8_ = event;
		_tmp9_ = zeitgeist_event_get_payload (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->data;
		_tmp11__length1 = (gint) _tmp10_->len;
		_tmp12_ = event;
		_tmp13_ = zeitgeist_event_get_payload (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->data;
		_tmp15__length1 = (gint) _tmp14_->len;
		sqlite3_bind_blob (_tmp7_, 1, _tmp11_, _tmp15__length1, NULL);
		_tmp16_ = payload_insertion_stmt;
		_tmp17_ = sqlite3_step (_tmp16_);
		rc = _tmp17_;
		_tmp18_ = rc;
		if (_tmp18_ != SQLITE_DONE) {
			gint _tmp19_ = 0;
			_tmp19_ = rc;
			if (_tmp19_ != SQLITE_CONSTRAINT) {
				gint _tmp20_ = 0;
				sqlite3* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				_tmp20_ = rc;
				_tmp21_ = ((ZeitgeistDbReader*) self)->db;
				_tmp22_ = sqlite3_errmsg (_tmp21_);
				g_warning ("engine.vala:464: SQL error: %d, %s\n", _tmp20_, _tmp22_);
				{
					ZeitgeistSQLiteDatabase* _tmp23_ = NULL;
					ZeitgeistSQLiteDatabase* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					_tmp23_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
					_tmp24_ = _tmp23_;
					_tmp25_ = rc;
					zeitgeist_sq_lite_database_assert_not_corrupt (_tmp24_, _tmp25_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							goto __catch2_zeitgeist_engine_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0LL;
					}
				}
				goto __finally2;
				__catch2_zeitgeist_engine_error:
				{
					GError* err = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (err);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0LL;
				}
			}
		}
		_tmp26_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_->database;
		_tmp29_ = sqlite3_last_insert_rowid (_tmp28_);
		result = _tmp29_;
		return result;
	}
	result = (gint64) 0;
	return result;
}


static GObject * zeitgeist_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistEngine * self;
	ZeitgeistExtensionStore* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine);
	_tmp0_ = zeitgeist_extension_store_new (self);
	_g_object_unref0 (self->extension_store);
	self->extension_store = _tmp0_;
	_tmp1_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp2_ = _tmp1_;
	zeitgeist_sq_lite_database_set_cache_size (_tmp2_, 24);
	return obj;
}


static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_construct (GType object_type, ZeitgeistSQLiteDatabase* db, const gchar* data_type) {
	ZeitgeistEngineDataInserter* self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	g_return_val_if_fail (db != NULL, NULL);
	g_return_val_if_fail (data_type != NULL, NULL);
	self = (ZeitgeistEngineDataInserter*) g_type_create_instance (object_type);
	_tmp0_ = db;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp1_;
	_tmp2_ = data_type;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->type);
	self->priv->type = _tmp3_;
	_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->data);
	self->priv->data = _tmp4_;
	return self;
}


static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_new (ZeitgeistSQLiteDatabase* db, const gchar* data_type) {
	return zeitgeist_engine_data_inserter_construct (ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, db, data_type);
}


static void zeitgeist_engine_data_inserter_add (ZeitgeistEngineDataInserter* self, const gchar* val, GError** error) {
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GPtrArray* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->data;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ZEITGEIST_ENGINE_DATA_INSERTER_MAX_PARAMETERS) {
		zeitgeist_engine_data_inserter_flush (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp3_ = self->priv->data;
	_tmp4_ = val;
	_tmp5_ = g_strdup (_tmp4_);
	g_ptr_array_add (_tmp3_, _tmp5_);
}


static void zeitgeist_engine_data_inserter_flush (ZeitgeistEngineDataInserter* self, GError** error) {
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->data;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		ZeitgeistSQLiteDatabase* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GPtrArray* _tmp5_ = NULL;
		GPtrArray* _tmp6_ = NULL;
		_tmp3_ = self->priv->database;
		_tmp4_ = self->priv->type;
		_tmp5_ = self->priv->data;
		zeitgeist_sq_lite_database_insert_or_ignore_into_table (_tmp3_, _tmp4_, _tmp5_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp6_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_g_ptr_array_unref0 (self->priv->data);
		self->priv->data = _tmp6_;
	}
}


static void zeitgeist_engine_value_data_inserter_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void zeitgeist_engine_value_data_inserter_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		zeitgeist_engine_data_inserter_unref (value->data[0].v_pointer);
	}
}


static void zeitgeist_engine_value_data_inserter_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = zeitgeist_engine_data_inserter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer zeitgeist_engine_value_data_inserter_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* zeitgeist_engine_value_data_inserter_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ZeitgeistEngineDataInserter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = zeitgeist_engine_data_inserter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* zeitgeist_engine_value_data_inserter_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ZeitgeistEngineDataInserter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = zeitgeist_engine_data_inserter_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* zeitgeist_engine_param_spec_data_inserter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ZeitgeistEngineParamSpecDataInserter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer zeitgeist_engine_value_get_data_inserter (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER), NULL);
	return value->data[0].v_pointer;
}


static void zeitgeist_engine_value_set_data_inserter (GValue* value, gpointer v_object) {
	ZeitgeistEngineDataInserter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		zeitgeist_engine_data_inserter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_engine_data_inserter_unref (old);
	}
}


static void zeitgeist_engine_value_take_data_inserter (GValue* value, gpointer v_object) {
	ZeitgeistEngineDataInserter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_engine_data_inserter_unref (old);
	}
}


static void zeitgeist_engine_data_inserter_class_init (ZeitgeistEngineDataInserterClass * klass) {
	zeitgeist_engine_data_inserter_parent_class = g_type_class_peek_parent (klass);
	((ZeitgeistEngineDataInserterClass *) klass)->finalize = zeitgeist_engine_data_inserter_finalize;
	g_type_class_add_private (klass, sizeof (ZeitgeistEngineDataInserterPrivate));
}


static void zeitgeist_engine_data_inserter_instance_init (ZeitgeistEngineDataInserter * self) {
	self->priv = ZEITGEIST_ENGINE_DATA_INSERTER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void zeitgeist_engine_data_inserter_finalize (ZeitgeistEngineDataInserter* obj) {
	ZeitgeistEngineDataInserter * self;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserter);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->data;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		g_warning ("engine.vala:200: DataInserter: destroyed with unflushed data");
	}
	_g_object_unref0 (self->priv->database);
	_g_free0 (self->priv->type);
	_g_ptr_array_unref0 (self->priv->data);
}


static GType zeitgeist_engine_data_inserter_get_type (void) {
	static volatile gsize zeitgeist_engine_data_inserter_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_engine_data_inserter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { zeitgeist_engine_value_data_inserter_init, zeitgeist_engine_value_data_inserter_free_value, zeitgeist_engine_value_data_inserter_copy_value, zeitgeist_engine_value_data_inserter_peek_pointer, "p", zeitgeist_engine_value_data_inserter_collect_value, "p", zeitgeist_engine_value_data_inserter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEngineDataInserterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_engine_data_inserter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEngineDataInserter), 0, (GInstanceInitFunc) zeitgeist_engine_data_inserter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType zeitgeist_engine_data_inserter_type_id;
		zeitgeist_engine_data_inserter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ZeitgeistEngineDataInserter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&zeitgeist_engine_data_inserter_type_id__volatile, zeitgeist_engine_data_inserter_type_id);
	}
	return zeitgeist_engine_data_inserter_type_id__volatile;
}


static gpointer zeitgeist_engine_data_inserter_ref (gpointer instance) {
	ZeitgeistEngineDataInserter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void zeitgeist_engine_data_inserter_unref (gpointer instance) {
	ZeitgeistEngineDataInserter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ZEITGEIST_ENGINE_DATA_INSERTER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void zeitgeist_engine_class_init (ZeitgeistEngineClass * klass) {
	zeitgeist_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistEnginePrivate));
	((ZeitgeistDbReaderClass *) klass)->close = zeitgeist_engine_real_close;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_engine_finalize;
}


static void zeitgeist_engine_instance_init (ZeitgeistEngine * self) {
	self->priv = ZEITGEIST_ENGINE_GET_PRIVATE (self);
}


static void zeitgeist_engine_finalize (GObject* obj) {
	ZeitgeistEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine);
	_g_object_unref0 (self->extension_store);
	_g_object_unref0 (self->priv->extension_collection);
	G_OBJECT_CLASS (zeitgeist_engine_parent_class)->finalize (obj);
}


GType zeitgeist_engine_get_type (void) {
	static volatile gsize zeitgeist_engine_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEngine), 0, (GInstanceInitFunc) zeitgeist_engine_instance_init, NULL };
		GType zeitgeist_engine_type_id;
		zeitgeist_engine_type_id = g_type_register_static (ZEITGEIST_TYPE_DB_READER, "ZeitgeistEngine", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_engine_type_id__volatile, zeitgeist_engine_type_id);
	}
	return zeitgeist_engine_type_id__volatile;
}



