/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMTextTrackCue.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDocumentFragmentPrivate.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTextTrackCuePrivate.h"
#include "WebKitDOMTextTrackPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_TEXT_TRACK_CUE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_TEXT_TRACK_CUE, WebKitDOMTextTrackCuePrivate)

typedef struct _WebKitDOMTextTrackCuePrivate {
#if ENABLE(VIDEO_TRACK)
    RefPtr<WebCore::TextTrackCue> coreObject;
#endif // ENABLE(VIDEO_TRACK)
} WebKitDOMTextTrackCuePrivate;

#if ENABLE(VIDEO_TRACK)

namespace WebKit {

WebKitDOMTextTrackCue* kit(WebCore::TextTrackCue* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_TEXT_TRACK_CUE(ret);

    return wrapTextTrackCue(obj);
}

WebCore::TextTrackCue* core(WebKitDOMTextTrackCue* request)
{
    return request ? static_cast<WebCore::TextTrackCue*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTextTrackCue* wrapTextTrackCue(WebCore::TextTrackCue* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TEXT_TRACK_CUE(g_object_new(WEBKIT_TYPE_DOM_TEXT_TRACK_CUE, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(VIDEO_TRACK)

static void webkit_dom_text_track_cue_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::TextTrackCue* coreTarget = static_cast<WebCore::TextTrackCue*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    coreTarget->dispatchEvent(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif // ENABLE(VIDEO_TRACK)
}

static gboolean webkit_dom_text_track_cue_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble, gpointer userData)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::TextTrackCue* coreTarget = static_cast<WebCore::TextTrackCue*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble, userData);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return false;
#endif // ENABLE(VIDEO_TRACK)
}

static gboolean webkit_dom_text_track_cue_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::TextTrackCue* coreTarget = static_cast<WebCore::TextTrackCue*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return false;
#endif // ENABLE(VIDEO_TRACK)
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_text_track_cue_dispatch_event;
    iface->add_event_listener = webkit_dom_text_track_cue_add_event_listener;
    iface->remove_event_listener = webkit_dom_text_track_cue_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMTextTrackCue, webkit_dom_text_track_cue, WEBKIT_TYPE_DOM_OBJECT, G_IMPLEMENT_INTERFACE(WEBKIT_TYPE_DOM_EVENT_TARGET, webkit_dom_event_target_init))

enum {
    PROP_0,
    PROP_TRACK,
    PROP_ID,
    PROP_START_TIME,
    PROP_END_TIME,
    PROP_PAUSE_ON_EXIT,
    PROP_VERTICAL,
    PROP_SNAP_TO_LINES,
    PROP_LINE,
    PROP_POSITION,
    PROP_SIZE,
    PROP_ALIGN,
    PROP_TEXT,
};

static void webkit_dom_text_track_cue_finalize(GObject* object)
{
    WebKitDOMTextTrackCuePrivate* priv = WEBKIT_DOM_TEXT_TRACK_CUE_GET_PRIVATE(object);
#if ENABLE(VIDEO_TRACK)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(VIDEO_TRACK)
    priv->~WebKitDOMTextTrackCuePrivate();
    G_OBJECT_CLASS(webkit_dom_text_track_cue_parent_class)->finalize(object);
}

static void webkit_dom_text_track_cue_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrackCue* self = WEBKIT_DOM_TEXT_TRACK_CUE(object);
    WebCore::TextTrackCue* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO_TRACK)
    switch (propertyId) {
    case PROP_ID: {
#if ENABLE(VIDEO_TRACK)
        coreSelf->setId(WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_START_TIME: {
#if ENABLE(VIDEO_TRACK)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setStartTime((g_value_get_double(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_END_TIME: {
#if ENABLE(VIDEO_TRACK)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setEndTime((g_value_get_double(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_PAUSE_ON_EXIT: {
#if ENABLE(VIDEO_TRACK)
        coreSelf->setPauseOnExit((g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_VERTICAL: {
#if ENABLE(VIDEO_TRACK)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setVertical(WTF::String::fromUTF8(g_value_get_string(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_SNAP_TO_LINES: {
#if ENABLE(VIDEO_TRACK)
        coreSelf->setSnapToLines((g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_LINE: {
#if ENABLE(VIDEO_TRACK)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setLine((g_value_get_long(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_POSITION: {
#if ENABLE(VIDEO_TRACK)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setPosition((g_value_get_long(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_SIZE: {
#if ENABLE(VIDEO_TRACK)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setSize((g_value_get_long(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_ALIGN: {
#if ENABLE(VIDEO_TRACK)
        WebCore::ExceptionCode ec = 0;
        coreSelf->setAlign(WTF::String::fromUTF8(g_value_get_string(value)), ec);
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_TEXT: {
#if ENABLE(VIDEO_TRACK)
        coreSelf->setText(WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_text_track_cue_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrackCue* self = WEBKIT_DOM_TEXT_TRACK_CUE(object);
    WebCore::TextTrackCue* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO_TRACK)
    switch (propertyId) {
    case PROP_TRACK: {
#if ENABLE(VIDEO_TRACK)
        RefPtr<WebCore::TextTrack> ptr = coreSelf->track();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_ID: {
#if ENABLE(VIDEO_TRACK)
        g_value_take_string(value, convertToUTF8String(coreSelf->id()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_START_TIME: {
#if ENABLE(VIDEO_TRACK)
        g_value_set_double(value, coreSelf->startTime());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_END_TIME: {
#if ENABLE(VIDEO_TRACK)
        g_value_set_double(value, coreSelf->endTime());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_PAUSE_ON_EXIT: {
#if ENABLE(VIDEO_TRACK)
        g_value_set_boolean(value, coreSelf->pauseOnExit());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_VERTICAL: {
#if ENABLE(VIDEO_TRACK)
        g_value_take_string(value, convertToUTF8String(coreSelf->vertical()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_SNAP_TO_LINES: {
#if ENABLE(VIDEO_TRACK)
        g_value_set_boolean(value, coreSelf->snapToLines());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_LINE: {
#if ENABLE(VIDEO_TRACK)
        g_value_set_long(value, coreSelf->line());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_POSITION: {
#if ENABLE(VIDEO_TRACK)
        g_value_set_long(value, coreSelf->position());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_SIZE: {
#if ENABLE(VIDEO_TRACK)
        g_value_set_long(value, coreSelf->size());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_ALIGN: {
#if ENABLE(VIDEO_TRACK)
        g_value_take_string(value, convertToUTF8String(coreSelf->align()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    case PROP_TEXT: {
#if ENABLE(VIDEO_TRACK)
        g_value_take_string(value, convertToUTF8String(coreSelf->text()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_text_track_cue_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_text_track_cue_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrackCuePrivate* priv = WEBKIT_DOM_TEXT_TRACK_CUE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::TextTrackCue*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(VIDEO_TRACK)
    return object;
}

static void webkit_dom_text_track_cue_class_init(WebKitDOMTextTrackCueClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMTextTrackCuePrivate));
    gobjectClass->constructor = webkit_dom_text_track_cue_constructor;
    gobjectClass->finalize = webkit_dom_text_track_cue_finalize;
    gobjectClass->set_property = webkit_dom_text_track_cue_set_property;
    gobjectClass->get_property = webkit_dom_text_track_cue_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TRACK,
                                    g_param_spec_object("track", /* name */
                                                           "text_track_cue_track", /* short description */
                                                           "read-only  WebKitDOMTextTrack* TextTrackCue.track", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_TEXT_TRACK, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ID,
                                    g_param_spec_string("id", /* name */
                                                           "text_track_cue_id", /* short description */
                                                           "read-write  gchar* TextTrackCue.id", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_START_TIME,
                                    g_param_spec_double("start-time", /* name */
                                                           "text_track_cue_start-time", /* short description */
                                                           "read-write  gdouble TextTrackCue.start-time", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXDOUBLE, /* min */
G_MAXDOUBLE, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_END_TIME,
                                    g_param_spec_double("end-time", /* name */
                                                           "text_track_cue_end-time", /* short description */
                                                           "read-write  gdouble TextTrackCue.end-time", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXDOUBLE, /* min */
G_MAXDOUBLE, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PAUSE_ON_EXIT,
                                    g_param_spec_boolean("pause-on-exit", /* name */
                                                           "text_track_cue_pause-on-exit", /* short description */
                                                           "read-write  gboolean TextTrackCue.pause-on-exit", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VERTICAL,
                                    g_param_spec_string("vertical", /* name */
                                                           "text_track_cue_vertical", /* short description */
                                                           "read-write  gchar* TextTrackCue.vertical", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SNAP_TO_LINES,
                                    g_param_spec_boolean("snap-to-lines", /* name */
                                                           "text_track_cue_snap-to-lines", /* short description */
                                                           "read-write  gboolean TextTrackCue.snap-to-lines", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LINE,
                                    g_param_spec_long("line", /* name */
                                                           "text_track_cue_line", /* short description */
                                                           "read-write  glong TextTrackCue.line", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_POSITION,
                                    g_param_spec_long("position", /* name */
                                                           "text_track_cue_position", /* short description */
                                                           "read-write  glong TextTrackCue.position", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SIZE,
                                    g_param_spec_long("size", /* name */
                                                           "text_track_cue_size", /* short description */
                                                           "read-write  glong TextTrackCue.size", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "text_track_cue_align", /* short description */
                                                           "read-write  gchar* TextTrackCue.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TEXT,
                                    g_param_spec_string("text", /* name */
                                                           "text_track_cue_text", /* short description */
                                                           "read-write  gchar* TextTrackCue.text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_text_track_cue_init(WebKitDOMTextTrackCue* request)
{
    WebKitDOMTextTrackCuePrivate* priv = WEBKIT_DOM_TEXT_TRACK_CUE_GET_PRIVATE(request);
    new (priv) WebKitDOMTextTrackCuePrivate();
}

WebKitDOMDocumentFragment*
webkit_dom_text_track_cue_get_cue_as_html(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    RefPtr<WebCore::DocumentFragment> gobjectResult = WTF::getPtr(item->getCueAsHTML());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

gboolean
webkit_dom_text_track_cue_dispatch_event(WebKitDOMTextTrackCue* self, WebKitDOMEvent* evt, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(evt), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WebCore::Event* convertedEvt = WebKit::core(evt);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->dispatchEvent(convertedEvt, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

WebKitDOMTextTrack*
webkit_dom_text_track_cue_get_track(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    RefPtr<WebCore::TextTrack> gobjectResult = WTF::getPtr(item->track());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

gchar*
webkit_dom_text_track_cue_get_id(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->id());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_id(WebKitDOMTextTrackCue* self, const gchar* value)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    g_return_if_fail(value);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setId(convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

gdouble
webkit_dom_text_track_cue_get_start_time(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    gdouble result = item->startTime();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<gdouble>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_start_time(WebKitDOMTextTrackCue* self, gdouble value, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    g_return_if_fail(!error || !*error);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setStartTime(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

gdouble
webkit_dom_text_track_cue_get_end_time(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    gdouble result = item->endTime();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<gdouble>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_end_time(WebKitDOMTextTrackCue* self, gdouble value, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    g_return_if_fail(!error || !*error);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setEndTime(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

gboolean
webkit_dom_text_track_cue_get_pause_on_exit(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), FALSE);
    WebCore::TextTrackCue* item = WebKit::core(self);
    gboolean result = item->pauseOnExit();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_pause_on_exit(WebKitDOMTextTrackCue* self, gboolean value)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    WebCore::TextTrackCue* item = WebKit::core(self);
    item->setPauseOnExit(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

gchar*
webkit_dom_text_track_cue_get_vertical(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->vertical());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_vertical(WebKitDOMTextTrackCue* self, const gchar* value, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setVertical(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

gboolean
webkit_dom_text_track_cue_get_snap_to_lines(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), FALSE);
    WebCore::TextTrackCue* item = WebKit::core(self);
    gboolean result = item->snapToLines();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_snap_to_lines(WebKitDOMTextTrackCue* self, gboolean value)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    WebCore::TextTrackCue* item = WebKit::core(self);
    item->setSnapToLines(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

glong
webkit_dom_text_track_cue_get_line(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    glong result = item->line();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<glong>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_line(WebKitDOMTextTrackCue* self, glong value, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    g_return_if_fail(!error || !*error);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setLine(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

glong
webkit_dom_text_track_cue_get_position(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    glong result = item->position();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<glong>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_position(WebKitDOMTextTrackCue* self, glong value, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    g_return_if_fail(!error || !*error);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setPosition(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

glong
webkit_dom_text_track_cue_get_size(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    glong result = item->size();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<glong>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_size(WebKitDOMTextTrackCue* self, glong value, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    g_return_if_fail(!error || !*error);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setSize(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

gchar*
webkit_dom_text_track_cue_get_align(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->align());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_align(WebKitDOMTextTrackCue* self, const gchar* value, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setAlign(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

gchar*
webkit_dom_text_track_cue_get_text(WebKitDOMTextTrackCue* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self), 0);
    WebCore::TextTrackCue* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->text());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

void
webkit_dom_text_track_cue_set_text(WebKitDOMTextTrackCue* self, const gchar* value)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE(self));
    g_return_if_fail(value);
    WebCore::TextTrackCue* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setText(convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
}

