/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMStorage.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMStoragePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_STORAGE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_STORAGE, WebKitDOMStoragePrivate)

typedef struct _WebKitDOMStoragePrivate {
    RefPtr<WebCore::Storage> coreObject;
} WebKitDOMStoragePrivate;

namespace WebKit {

WebKitDOMStorage* kit(WebCore::Storage* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_STORAGE(ret);

    return wrapStorage(obj);
}

WebCore::Storage* core(WebKitDOMStorage* request)
{
    return request ? static_cast<WebCore::Storage*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMStorage* wrapStorage(WebCore::Storage* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_STORAGE(g_object_new(WEBKIT_TYPE_DOM_STORAGE, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMStorage, webkit_dom_storage, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_storage_finalize(GObject* object)
{
    WebKitDOMStoragePrivate* priv = WEBKIT_DOM_STORAGE_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMStoragePrivate();
    G_OBJECT_CLASS(webkit_dom_storage_parent_class)->finalize(object);
}

static void webkit_dom_storage_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMStorage* self = WEBKIT_DOM_STORAGE(object);
    WebCore::Storage* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_LENGTH: {
        WebCore::ExceptionCode ec = 0;
        g_value_set_ulong(value, coreSelf->length(ec));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_storage_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_storage_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMStoragePrivate* priv = WEBKIT_DOM_STORAGE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Storage*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_storage_class_init(WebKitDOMStorageClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMStoragePrivate));
    gobjectClass->constructor = webkit_dom_storage_constructor;
    gobjectClass->finalize = webkit_dom_storage_finalize;
    gobjectClass->get_property = webkit_dom_storage_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "storage_length", /* short description */
                                                           "read-only  gulong Storage.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_storage_init(WebKitDOMStorage* request)
{
    WebKitDOMStoragePrivate* priv = WEBKIT_DOM_STORAGE_GET_PRIVATE(request);
    new (priv) WebKitDOMStoragePrivate();
}

gchar*
webkit_dom_storage_key(WebKitDOMStorage* self, gulong index, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STORAGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Storage* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    gchar* result = convertToUTF8String(item->key(index, ec));
    return result;
}

gchar*
webkit_dom_storage_get_item(WebKitDOMStorage* self, const gchar* key, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STORAGE(self), 0);
    g_return_val_if_fail(key, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Storage* item = WebKit::core(self);
    WTF::String convertedKey = WTF::String::fromUTF8(key);
    WebCore::ExceptionCode ec = 0;
    gchar* result = convertToUTF8String(item->getItem(convertedKey, ec));
    return result;
}

void
webkit_dom_storage_set_item(WebKitDOMStorage* self, const gchar* key, const gchar* data, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_STORAGE(self));
    g_return_if_fail(key);
    g_return_if_fail(data);
    g_return_if_fail(!error || !*error);
    WebCore::Storage* item = WebKit::core(self);
    WTF::String convertedKey = WTF::String::fromUTF8(key);
    WTF::String convertedData = WTF::String::fromUTF8(data);
    WebCore::ExceptionCode ec = 0;
    item->setItem(convertedKey, convertedData, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_storage_remove_item(WebKitDOMStorage* self, const gchar* key, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_STORAGE(self));
    g_return_if_fail(key);
    g_return_if_fail(!error || !*error);
    WebCore::Storage* item = WebKit::core(self);
    WTF::String convertedKey = WTF::String::fromUTF8(key);
    WebCore::ExceptionCode ec = 0;
    item->removeItem(convertedKey, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_storage_clear(WebKitDOMStorage* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_STORAGE(self));
    g_return_if_fail(!error || !*error);
    WebCore::Storage* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->clear(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gulong
webkit_dom_storage_get_length(WebKitDOMStorage* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STORAGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Storage* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    gulong result = item->length(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

