/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMScreen.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMScreenPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_SCREEN_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_SCREEN, WebKitDOMScreenPrivate)

typedef struct _WebKitDOMScreenPrivate {
    RefPtr<WebCore::Screen> coreObject;
} WebKitDOMScreenPrivate;

namespace WebKit {

WebKitDOMScreen* kit(WebCore::Screen* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_SCREEN(ret);

    return wrapScreen(obj);
}

WebCore::Screen* core(WebKitDOMScreen* request)
{
    return request ? static_cast<WebCore::Screen*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMScreen* wrapScreen(WebCore::Screen* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_SCREEN(g_object_new(WEBKIT_TYPE_DOM_SCREEN, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMScreen, webkit_dom_screen, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_HEIGHT,
    PROP_WIDTH,
    PROP_COLOR_DEPTH,
    PROP_PIXEL_DEPTH,
    PROP_AVAIL_LEFT,
    PROP_AVAIL_TOP,
    PROP_AVAIL_HEIGHT,
    PROP_AVAIL_WIDTH,
};

static void webkit_dom_screen_finalize(GObject* object)
{
    WebKitDOMScreenPrivate* priv = WEBKIT_DOM_SCREEN_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMScreenPrivate();
    G_OBJECT_CLASS(webkit_dom_screen_parent_class)->finalize(object);
}

static void webkit_dom_screen_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMScreen* self = WEBKIT_DOM_SCREEN(object);
    WebCore::Screen* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_HEIGHT: {
        g_value_set_ulong(value, coreSelf->height());
        break;
    }
    case PROP_WIDTH: {
        g_value_set_ulong(value, coreSelf->width());
        break;
    }
    case PROP_COLOR_DEPTH: {
        g_value_set_ulong(value, coreSelf->colorDepth());
        break;
    }
    case PROP_PIXEL_DEPTH: {
        g_value_set_ulong(value, coreSelf->pixelDepth());
        break;
    }
    case PROP_AVAIL_LEFT: {
        g_value_set_long(value, coreSelf->availLeft());
        break;
    }
    case PROP_AVAIL_TOP: {
        g_value_set_long(value, coreSelf->availTop());
        break;
    }
    case PROP_AVAIL_HEIGHT: {
        g_value_set_ulong(value, coreSelf->availHeight());
        break;
    }
    case PROP_AVAIL_WIDTH: {
        g_value_set_ulong(value, coreSelf->availWidth());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_screen_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_screen_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMScreenPrivate* priv = WEBKIT_DOM_SCREEN_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Screen*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_screen_class_init(WebKitDOMScreenClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMScreenPrivate));
    gobjectClass->constructor = webkit_dom_screen_constructor;
    gobjectClass->finalize = webkit_dom_screen_finalize;
    gobjectClass->get_property = webkit_dom_screen_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_ulong("height", /* name */
                                                           "screen_height", /* short description */
                                                           "read-only  gulong Screen.height", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_ulong("width", /* name */
                                                           "screen_width", /* short description */
                                                           "read-only  gulong Screen.width", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COLOR_DEPTH,
                                    g_param_spec_ulong("color-depth", /* name */
                                                           "screen_color-depth", /* short description */
                                                           "read-only  gulong Screen.color-depth", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PIXEL_DEPTH,
                                    g_param_spec_ulong("pixel-depth", /* name */
                                                           "screen_pixel-depth", /* short description */
                                                           "read-only  gulong Screen.pixel-depth", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_AVAIL_LEFT,
                                    g_param_spec_long("avail-left", /* name */
                                                           "screen_avail-left", /* short description */
                                                           "read-only  glong Screen.avail-left", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_AVAIL_TOP,
                                    g_param_spec_long("avail-top", /* name */
                                                           "screen_avail-top", /* short description */
                                                           "read-only  glong Screen.avail-top", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_AVAIL_HEIGHT,
                                    g_param_spec_ulong("avail-height", /* name */
                                                           "screen_avail-height", /* short description */
                                                           "read-only  gulong Screen.avail-height", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_AVAIL_WIDTH,
                                    g_param_spec_ulong("avail-width", /* name */
                                                           "screen_avail-width", /* short description */
                                                           "read-only  gulong Screen.avail-width", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_screen_init(WebKitDOMScreen* request)
{
    WebKitDOMScreenPrivate* priv = WEBKIT_DOM_SCREEN_GET_PRIVATE(request);
    new (priv) WebKitDOMScreenPrivate();
}

gulong
webkit_dom_screen_get_height(WebKitDOMScreen* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SCREEN(self), 0);
    WebCore::Screen* item = WebKit::core(self);
    gulong result = item->height();
    return result;
}

gulong
webkit_dom_screen_get_width(WebKitDOMScreen* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SCREEN(self), 0);
    WebCore::Screen* item = WebKit::core(self);
    gulong result = item->width();
    return result;
}

gulong
webkit_dom_screen_get_color_depth(WebKitDOMScreen* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SCREEN(self), 0);
    WebCore::Screen* item = WebKit::core(self);
    gulong result = item->colorDepth();
    return result;
}

gulong
webkit_dom_screen_get_pixel_depth(WebKitDOMScreen* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SCREEN(self), 0);
    WebCore::Screen* item = WebKit::core(self);
    gulong result = item->pixelDepth();
    return result;
}

glong
webkit_dom_screen_get_avail_left(WebKitDOMScreen* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SCREEN(self), 0);
    WebCore::Screen* item = WebKit::core(self);
    glong result = item->availLeft();
    return result;
}

glong
webkit_dom_screen_get_avail_top(WebKitDOMScreen* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SCREEN(self), 0);
    WebCore::Screen* item = WebKit::core(self);
    glong result = item->availTop();
    return result;
}

gulong
webkit_dom_screen_get_avail_height(WebKitDOMScreen* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SCREEN(self), 0);
    WebCore::Screen* item = WebKit::core(self);
    gulong result = item->availHeight();
    return result;
}

gulong
webkit_dom_screen_get_avail_width(WebKitDOMScreen* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_SCREEN(self), 0);
    WebCore::Screen* item = WebKit::core(self);
    gulong result = item->availWidth();
    return result;
}

