/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLAnchorElement.h"

#include "ExceptionCode.h"
#include "HTMLAnchorElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLAnchorElementTableValues[] =
{
    { "charset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementCharset), (intptr_t)setJSHTMLAnchorElementCharset, NoIntrinsic },
    { "coords", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementCoords), (intptr_t)setJSHTMLAnchorElementCoords, NoIntrinsic },
#if ENABLE(DOWNLOAD_ATTRIBUTE)
    { "download", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementDownload), (intptr_t)setJSHTMLAnchorElementDownload, NoIntrinsic },
#endif
    { "href", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHref), (intptr_t)setJSHTMLAnchorElementHref, NoIntrinsic },
    { "hreflang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHreflang), (intptr_t)setJSHTMLAnchorElementHreflang, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementName), (intptr_t)setJSHTMLAnchorElementName, NoIntrinsic },
    { "ping", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementPing), (intptr_t)setJSHTMLAnchorElementPing, NoIntrinsic },
    { "rel", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementRel), (intptr_t)setJSHTMLAnchorElementRel, NoIntrinsic },
    { "rev", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementRev), (intptr_t)setJSHTMLAnchorElementRev, NoIntrinsic },
    { "shape", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementShape), (intptr_t)setJSHTMLAnchorElementShape, NoIntrinsic },
    { "target", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementTarget), (intptr_t)setJSHTMLAnchorElementTarget, NoIntrinsic },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementType), (intptr_t)setJSHTMLAnchorElementType, NoIntrinsic },
    { "hash", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHash), (intptr_t)setJSHTMLAnchorElementHash, NoIntrinsic },
    { "host", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHost), (intptr_t)setJSHTMLAnchorElementHost, NoIntrinsic },
    { "hostname", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHostname), (intptr_t)setJSHTMLAnchorElementHostname, NoIntrinsic },
    { "pathname", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementPathname), (intptr_t)setJSHTMLAnchorElementPathname, NoIntrinsic },
    { "port", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementPort), (intptr_t)setJSHTMLAnchorElementPort, NoIntrinsic },
    { "protocol", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementProtocol), (intptr_t)setJSHTMLAnchorElementProtocol, NoIntrinsic },
    { "search", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementSearch), (intptr_t)setJSHTMLAnchorElementSearch, NoIntrinsic },
    { "origin", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementOrigin), (intptr_t)0, NoIntrinsic },
    { "text", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementText), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLAnchorElementTable = { 68, 63, JSHTMLAnchorElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLAnchorElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLAnchorElementConstructorTable = { 1, 0, JSHTMLAnchorElementConstructorTableValues, 0 };
const ClassInfo JSHTMLAnchorElementConstructor::s_info = { "HTMLAnchorElementConstructor", &Base::s_info, &JSHTMLAnchorElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLAnchorElementConstructor) };

JSHTMLAnchorElementConstructor::JSHTMLAnchorElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLAnchorElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLAnchorElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLAnchorElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAnchorElementConstructor, JSDOMWrapper>(exec, &JSHTMLAnchorElementConstructorTable, jsCast<JSHTMLAnchorElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLAnchorElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLAnchorElementConstructor, JSDOMWrapper>(exec, &JSHTMLAnchorElementConstructorTable, jsCast<JSHTMLAnchorElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLAnchorElementPrototypeTableValues[] =
{
    { "toString", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLAnchorElementPrototypeFunctionToString), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLAnchorElementPrototypeTable = { 2, 1, JSHTMLAnchorElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLAnchorElementPrototype::s_info = { "HTMLAnchorElementPrototype", &Base::s_info, &JSHTMLAnchorElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLAnchorElementPrototype) };

JSObject* JSHTMLAnchorElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLAnchorElement>(exec, globalObject);
}

bool JSHTMLAnchorElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLAnchorElementPrototype* thisObject = jsCast<JSHTMLAnchorElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLAnchorElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLAnchorElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLAnchorElementPrototype* thisObject = jsCast<JSHTMLAnchorElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLAnchorElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLAnchorElement::s_info = { "HTMLAnchorElement", &Base::s_info, &JSHTMLAnchorElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLAnchorElement) };

JSHTMLAnchorElement::JSHTMLAnchorElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLAnchorElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLAnchorElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLAnchorElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLAnchorElementPrototype::create(exec->globalData(), globalObject, JSHTMLAnchorElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLAnchorElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLAnchorElement* thisObject = jsCast<JSHTMLAnchorElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLAnchorElement, Base>(exec, &JSHTMLAnchorElementTable, thisObject, propertyName, slot);
}

bool JSHTMLAnchorElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLAnchorElement* thisObject = jsCast<JSHTMLAnchorElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLAnchorElement, Base>(exec, &JSHTMLAnchorElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLAnchorElementCharset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::charsetAttr));
    return result;
}


JSValue jsHTMLAnchorElementCoords(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::coordsAttr));
    return result;
}


#if ENABLE(DOWNLOAD_ATTRIBUTE)
JSValue jsHTMLAnchorElementDownload(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::downloadAttr));
    return result;
}

#endif

JSValue jsHTMLAnchorElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::hrefAttr));
    return result;
}


JSValue jsHTMLAnchorElementHreflang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::hreflangAttr));
    return result;
}


JSValue jsHTMLAnchorElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getNameAttribute());
    return result;
}


JSValue jsHTMLAnchorElementPing(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::pingAttr));
    return result;
}


JSValue jsHTMLAnchorElementRel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::relAttr));
    return result;
}


JSValue jsHTMLAnchorElementRev(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::revAttr));
    return result;
}


JSValue jsHTMLAnchorElementShape(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::shapeAttr));
    return result;
}


JSValue jsHTMLAnchorElementTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::targetAttr));
    return result;
}


JSValue jsHTMLAnchorElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::typeAttr));
    return result;
}


JSValue jsHTMLAnchorElementHash(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->hash());
    return result;
}


JSValue jsHTMLAnchorElementHost(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->host());
    return result;
}


JSValue jsHTMLAnchorElementHostname(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->hostname());
    return result;
}


JSValue jsHTMLAnchorElementPathname(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->pathname());
    return result;
}


JSValue jsHTMLAnchorElementPort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->port());
    return result;
}


JSValue jsHTMLAnchorElementProtocol(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->protocol());
    return result;
}


JSValue jsHTMLAnchorElementSearch(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->search());
    return result;
}


JSValue jsHTMLAnchorElementOrigin(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->origin());
    return result;
}


JSValue jsHTMLAnchorElementText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->text());
    return result;
}


JSValue jsHTMLAnchorElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAnchorElement* domObject = jsCast<JSHTMLAnchorElement*>(asObject(slotBase));
    return JSHTMLAnchorElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLAnchorElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLAnchorElement* thisObject = jsCast<JSHTMLAnchorElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLAnchorElement, Base>(exec, propertyName, value, &JSHTMLAnchorElementTable, thisObject, slot);
}

void setJSHTMLAnchorElementCharset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::charsetAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementCoords(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::coordsAttr, valueToStringWithNullCheck(exec, value));
}


#if ENABLE(DOWNLOAD_ATTRIBUTE)
void setJSHTMLAnchorElementDownload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::downloadAttr, valueToStringWithNullCheck(exec, value));
}

#endif

void setJSHTMLAnchorElementHref(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::hrefAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementHreflang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::hreflangAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementPing(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::pingAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementRel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::relAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementRev(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::revAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementShape(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::shapeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementTarget(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::targetAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::typeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementHash(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setHash(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementHost(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setHost(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementHostname(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setHostname(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementPathname(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setPathname(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementPort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setPort(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementProtocol(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setProtocol(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAnchorElementSearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(thisObject);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());
    impl->setSearch(valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLAnchorElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLAnchorElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLAnchorElementPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLAnchorElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLAnchorElement* castedThis = jsCast<JSHTMLAnchorElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLAnchorElement::s_info);
    HTMLAnchorElement* impl = static_cast<HTMLAnchorElement*>(castedThis->impl());

    JSC::JSValue result = jsStringWithCache(exec, impl->toString());
    return JSValue::encode(result);
}


}
