#include "TelepathyQt/_gen/svc-channel.h"

#include "TelepathyQt/_gen/svc-channel.moc.hpp"

#include <TelepathyQt/Constants>
#include <TelepathyQt/MethodInvocationContext>

namespace Tp
{
namespace Service
{

ChannelAdaptor::ChannelAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(closed()), SIGNAL(Closed()));
}

ChannelAdaptor::~ChannelAdaptor()
{
}

QString ChannelAdaptor::ChannelType() const
{
    return qvariant_cast< QString >(adaptee()->property("channelType"));
}

QStringList ChannelAdaptor::Interfaces() const
{
    return qvariant_cast< QStringList >(adaptee()->property("interfaces"));
}

uint ChannelAdaptor::TargetHandle() const
{
    return qvariant_cast< uint >(adaptee()->property("targetHandle"));
}

QString ChannelAdaptor::TargetID() const
{
    return qvariant_cast< QString >(adaptee()->property("targetID"));
}

uint ChannelAdaptor::TargetHandleType() const
{
    return qvariant_cast< uint >(adaptee()->property("targetHandleType"));
}

bool ChannelAdaptor::Requested() const
{
    return qvariant_cast< bool >(adaptee()->property("requested"));
}

uint ChannelAdaptor::InitiatorHandle() const
{
    return qvariant_cast< uint >(adaptee()->property("initiatorHandle"));
}

QString ChannelAdaptor::InitiatorID() const
{
    return qvariant_cast< QString >(adaptee()->property("initiatorID"));
}

void ChannelAdaptor::Close(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("close(Tp::Service::ChannelAdaptor::CloseContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    CloseContextPtr ctx = CloseContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "close",
        Q_ARG(Tp::Service::ChannelAdaptor::CloseContextPtr, ctx));
}

QString ChannelAdaptor::GetChannelType(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getChannelType(Tp::Service::ChannelAdaptor::GetChannelTypeContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    GetChannelTypeContextPtr ctx = GetChannelTypeContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getChannelType",
        Q_ARG(Tp::Service::ChannelAdaptor::GetChannelTypeContextPtr, ctx));
    return QString();
}

uint ChannelAdaptor::GetHandle(const QDBusMessage& dbusMessage, uint& targetHandle)
{
    if (adaptee()->metaObject()->indexOfMethod("getHandle(Tp::Service::ChannelAdaptor::GetHandleContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetHandleContextPtr ctx = GetHandleContextPtr(
            new Tp::MethodInvocationContext< uint, uint >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getHandle",
        Q_ARG(Tp::Service::ChannelAdaptor::GetHandleContextPtr, ctx));
    return uint();
}

QStringList ChannelAdaptor::GetInterfaces(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getInterfaces(Tp::Service::ChannelAdaptor::GetInterfacesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QStringList();
    }

    GetInterfacesContextPtr ctx = GetInterfacesContextPtr(
            new Tp::MethodInvocationContext< QStringList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getInterfaces",
        Q_ARG(Tp::Service::ChannelAdaptor::GetInterfacesContextPtr, ctx));
    return QStringList();
}

ChannelInterfaceAnonymityAdaptor::ChannelInterfaceAnonymityAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceAnonymityAdaptor::~ChannelInterfaceAnonymityAdaptor()
{
}

uint ChannelInterfaceAnonymityAdaptor::AnonymityModes() const
{
    return qvariant_cast< uint >(adaptee()->property("anonymityModes"));
}

bool ChannelInterfaceAnonymityAdaptor::AnonymityMandatory() const
{
    return qvariant_cast< bool >(adaptee()->property("anonymityMandatory"));
}

QString ChannelInterfaceAnonymityAdaptor::AnonymousID() const
{
    return qvariant_cast< QString >(adaptee()->property("anonymousID"));
}

ChannelInterfaceCallStateAdaptor::ChannelInterfaceCallStateAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(callStateChanged(uint, uint)), SIGNAL(CallStateChanged(uint, uint)));
}

ChannelInterfaceCallStateAdaptor::~ChannelInterfaceCallStateAdaptor()
{
}

Tp::ChannelCallStateMap ChannelInterfaceCallStateAdaptor::GetCallStates(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getCallStates(Tp::Service::ChannelInterfaceCallStateAdaptor::GetCallStatesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::ChannelCallStateMap();
    }

    GetCallStatesContextPtr ctx = GetCallStatesContextPtr(
            new Tp::MethodInvocationContext< Tp::ChannelCallStateMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getCallStates",
        Q_ARG(Tp::Service::ChannelInterfaceCallStateAdaptor::GetCallStatesContextPtr, ctx));
    return Tp::ChannelCallStateMap();
}

ChannelInterfaceCaptchaAuthenticationAdaptor::ChannelInterfaceCaptchaAuthenticationAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceCaptchaAuthenticationAdaptor::~ChannelInterfaceCaptchaAuthenticationAdaptor()
{
}

bool ChannelInterfaceCaptchaAuthenticationAdaptor::CanRetryCaptcha() const
{
    return qvariant_cast< bool >(adaptee()->property("canRetryCaptcha"));
}

uint ChannelInterfaceCaptchaAuthenticationAdaptor::CaptchaStatus() const
{
    return qvariant_cast< uint >(adaptee()->property("captchaStatus"));
}

QString ChannelInterfaceCaptchaAuthenticationAdaptor::CaptchaError() const
{
    return qvariant_cast< QString >(adaptee()->property("captchaError"));
}

QVariantMap ChannelInterfaceCaptchaAuthenticationAdaptor::CaptchaErrorDetails() const
{
    return qvariant_cast< QVariantMap >(adaptee()->property("captchaErrorDetails"));
}

Tp::CaptchaInfoList ChannelInterfaceCaptchaAuthenticationAdaptor::GetCaptchas(const QDBusMessage& dbusMessage, uint& numberRequired, QString& language)
{
    if (adaptee()->metaObject()->indexOfMethod("getCaptchas(Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::GetCaptchasContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::CaptchaInfoList();
    }

    GetCaptchasContextPtr ctx = GetCaptchasContextPtr(
            new Tp::MethodInvocationContext< Tp::CaptchaInfoList, uint, QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getCaptchas",
        Q_ARG(Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::GetCaptchasContextPtr, ctx));
    return Tp::CaptchaInfoList();
}

QByteArray ChannelInterfaceCaptchaAuthenticationAdaptor::GetCaptchaData(uint ID, const QString& mimeType, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getCaptchaData(uint,QString,Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::GetCaptchaDataContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QByteArray();
    }

    GetCaptchaDataContextPtr ctx = GetCaptchaDataContextPtr(
            new Tp::MethodInvocationContext< QByteArray >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getCaptchaData",
        Q_ARG(uint, ID), Q_ARG(QString, mimeType),
        Q_ARG(Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::GetCaptchaDataContextPtr, ctx));
    return QByteArray();
}

void ChannelInterfaceCaptchaAuthenticationAdaptor::AnswerCaptchas(const Tp::CaptchaAnswers& answers, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("answerCaptchas(Tp::CaptchaAnswers,Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::AnswerCaptchasContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    AnswerCaptchasContextPtr ctx = AnswerCaptchasContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "answerCaptchas",
        Q_ARG(Tp::CaptchaAnswers, answers),
        Q_ARG(Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::AnswerCaptchasContextPtr, ctx));
}

void ChannelInterfaceCaptchaAuthenticationAdaptor::CancelCaptcha(uint reason, const QString& debugMessage, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("cancelCaptcha(uint,QString,Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::CancelCaptchaContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    CancelCaptchaContextPtr ctx = CancelCaptchaContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "cancelCaptcha",
        Q_ARG(uint, reason), Q_ARG(QString, debugMessage),
        Q_ARG(Tp::Service::ChannelInterfaceCaptchaAuthenticationAdaptor::CancelCaptchaContextPtr, ctx));
}

ChannelInterfaceChatStateAdaptor::ChannelInterfaceChatStateAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(chatStateChanged(uint, uint)), SIGNAL(ChatStateChanged(uint, uint)));
}

ChannelInterfaceChatStateAdaptor::~ChannelInterfaceChatStateAdaptor()
{
}

Tp::ChatStateMap ChannelInterfaceChatStateAdaptor::ChatStates() const
{
    return qvariant_cast< Tp::ChatStateMap >(adaptee()->property("chatStates"));
}

void ChannelInterfaceChatStateAdaptor::SetChatState(uint state, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setChatState(uint,Tp::Service::ChannelInterfaceChatStateAdaptor::SetChatStateContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetChatStateContextPtr ctx = SetChatStateContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setChatState",
        Q_ARG(uint, state),
        Q_ARG(Tp::Service::ChannelInterfaceChatStateAdaptor::SetChatStateContextPtr, ctx));
}

ChannelInterfaceConferenceAdaptor::ChannelInterfaceConferenceAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(channelMerged(const QDBusObjectPath&, uint, const QVariantMap&)), SIGNAL(ChannelMerged(const QDBusObjectPath&, uint, const QVariantMap&)));
    connect(adaptee, SIGNAL(channelRemoved(const QDBusObjectPath&, const QVariantMap&)), SIGNAL(ChannelRemoved(const QDBusObjectPath&, const QVariantMap&)));
}

ChannelInterfaceConferenceAdaptor::~ChannelInterfaceConferenceAdaptor()
{
}

Tp::ObjectPathList ChannelInterfaceConferenceAdaptor::Channels() const
{
    return qvariant_cast< Tp::ObjectPathList >(adaptee()->property("channels"));
}

Tp::ObjectPathList ChannelInterfaceConferenceAdaptor::InitialChannels() const
{
    return qvariant_cast< Tp::ObjectPathList >(adaptee()->property("initialChannels"));
}

Tp::UIntList ChannelInterfaceConferenceAdaptor::InitialInviteeHandles() const
{
    return qvariant_cast< Tp::UIntList >(adaptee()->property("initialInviteeHandles"));
}

QStringList ChannelInterfaceConferenceAdaptor::InitialInviteeIDs() const
{
    return qvariant_cast< QStringList >(adaptee()->property("initialInviteeIDs"));
}

QString ChannelInterfaceConferenceAdaptor::InvitationMessage() const
{
    return qvariant_cast< QString >(adaptee()->property("invitationMessage"));
}

Tp::ChannelOriginatorMap ChannelInterfaceConferenceAdaptor::OriginalChannels() const
{
    return qvariant_cast< Tp::ChannelOriginatorMap >(adaptee()->property("originalChannels"));
}

ChannelInterfaceDTMFAdaptor::ChannelInterfaceDTMFAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(tonesDeferred(const QString&)), SIGNAL(TonesDeferred(const QString&)));
    connect(adaptee, SIGNAL(sendingTones(const QString&)), SIGNAL(SendingTones(const QString&)));
    connect(adaptee, SIGNAL(stoppedTones(bool)), SIGNAL(StoppedTones(bool)));
}

ChannelInterfaceDTMFAdaptor::~ChannelInterfaceDTMFAdaptor()
{
}

bool ChannelInterfaceDTMFAdaptor::CurrentlySendingTones() const
{
    return qvariant_cast< bool >(adaptee()->property("currentlySendingTones"));
}

QString ChannelInterfaceDTMFAdaptor::InitialTones() const
{
    return qvariant_cast< QString >(adaptee()->property("initialTones"));
}

QString ChannelInterfaceDTMFAdaptor::DeferredTones() const
{
    return qvariant_cast< QString >(adaptee()->property("deferredTones"));
}

void ChannelInterfaceDTMFAdaptor::StartTone(uint streamID, uchar event, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("startTone(uint,uchar,Tp::Service::ChannelInterfaceDTMFAdaptor::StartToneContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    StartToneContextPtr ctx = StartToneContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "startTone",
        Q_ARG(uint, streamID), Q_ARG(uchar, event),
        Q_ARG(Tp::Service::ChannelInterfaceDTMFAdaptor::StartToneContextPtr, ctx));
}

void ChannelInterfaceDTMFAdaptor::StopTone(uint streamID, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("stopTone(uint,Tp::Service::ChannelInterfaceDTMFAdaptor::StopToneContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    StopToneContextPtr ctx = StopToneContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "stopTone",
        Q_ARG(uint, streamID),
        Q_ARG(Tp::Service::ChannelInterfaceDTMFAdaptor::StopToneContextPtr, ctx));
}

void ChannelInterfaceDTMFAdaptor::MultipleTones(const QString& tones, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("multipleTones(QString,Tp::Service::ChannelInterfaceDTMFAdaptor::MultipleTonesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    MultipleTonesContextPtr ctx = MultipleTonesContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "multipleTones",
        Q_ARG(QString, tones),
        Q_ARG(Tp::Service::ChannelInterfaceDTMFAdaptor::MultipleTonesContextPtr, ctx));
}

ChannelInterfaceDestroyableAdaptor::ChannelInterfaceDestroyableAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceDestroyableAdaptor::~ChannelInterfaceDestroyableAdaptor()
{
}

void ChannelInterfaceDestroyableAdaptor::Destroy(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("destroy(Tp::Service::ChannelInterfaceDestroyableAdaptor::DestroyContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    DestroyContextPtr ctx = DestroyContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "destroy",
        Q_ARG(Tp::Service::ChannelInterfaceDestroyableAdaptor::DestroyContextPtr, ctx));
}

ChannelInterfaceFileTransferMetadataAdaptor::ChannelInterfaceFileTransferMetadataAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceFileTransferMetadataAdaptor::~ChannelInterfaceFileTransferMetadataAdaptor()
{
}

QString ChannelInterfaceFileTransferMetadataAdaptor::ServiceName() const
{
    return qvariant_cast< QString >(adaptee()->property("serviceName"));
}

void ChannelInterfaceFileTransferMetadataAdaptor::SetServiceName(const QString &newValue)
{
    adaptee()->setProperty("serviceName", qVariantFromValue(newValue));
}

Tp::Metadata ChannelInterfaceFileTransferMetadataAdaptor::Metadata() const
{
    return qvariant_cast< Tp::Metadata >(adaptee()->property("metadata"));
}

void ChannelInterfaceFileTransferMetadataAdaptor::SetMetadata(const Tp::Metadata &newValue)
{
    adaptee()->setProperty("metadata", qVariantFromValue(newValue));
}

ChannelInterfaceGroupAdaptor::ChannelInterfaceGroupAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(handleOwnersChanged(const Tp::HandleOwnerMap&, const Tp::UIntList&)), SIGNAL(HandleOwnersChanged(const Tp::HandleOwnerMap&, const Tp::UIntList&)));
    connect(adaptee, SIGNAL(handleOwnersChangedDetailed(const Tp::HandleOwnerMap&, const Tp::UIntList&, const Tp::HandleIdentifierMap&)), SIGNAL(HandleOwnersChangedDetailed(const Tp::HandleOwnerMap&, const Tp::UIntList&, const Tp::HandleIdentifierMap&)));
    connect(adaptee, SIGNAL(selfHandleChanged(uint)), SIGNAL(SelfHandleChanged(uint)));
    connect(adaptee, SIGNAL(selfContactChanged(uint, const QString&)), SIGNAL(SelfContactChanged(uint, const QString&)));
    connect(adaptee, SIGNAL(groupFlagsChanged(uint, uint)), SIGNAL(GroupFlagsChanged(uint, uint)));
    connect(adaptee, SIGNAL(membersChanged(const QString&, const Tp::UIntList&, const Tp::UIntList&, const Tp::UIntList&, const Tp::UIntList&, uint, uint)), SIGNAL(MembersChanged(const QString&, const Tp::UIntList&, const Tp::UIntList&, const Tp::UIntList&, const Tp::UIntList&, uint, uint)));
    connect(adaptee, SIGNAL(membersChangedDetailed(const Tp::UIntList&, const Tp::UIntList&, const Tp::UIntList&, const Tp::UIntList&, const QVariantMap&)), SIGNAL(MembersChangedDetailed(const Tp::UIntList&, const Tp::UIntList&, const Tp::UIntList&, const Tp::UIntList&, const QVariantMap&)));
}

ChannelInterfaceGroupAdaptor::~ChannelInterfaceGroupAdaptor()
{
}

uint ChannelInterfaceGroupAdaptor::GroupFlags() const
{
    return qvariant_cast< uint >(adaptee()->property("groupFlags"));
}

Tp::HandleOwnerMap ChannelInterfaceGroupAdaptor::HandleOwners() const
{
    return qvariant_cast< Tp::HandleOwnerMap >(adaptee()->property("handleOwners"));
}

Tp::LocalPendingInfoList ChannelInterfaceGroupAdaptor::LocalPendingMembers() const
{
    return qvariant_cast< Tp::LocalPendingInfoList >(adaptee()->property("localPendingMembers"));
}

Tp::UIntList ChannelInterfaceGroupAdaptor::Members() const
{
    return qvariant_cast< Tp::UIntList >(adaptee()->property("members"));
}

Tp::UIntList ChannelInterfaceGroupAdaptor::RemotePendingMembers() const
{
    return qvariant_cast< Tp::UIntList >(adaptee()->property("remotePendingMembers"));
}

uint ChannelInterfaceGroupAdaptor::SelfHandle() const
{
    return qvariant_cast< uint >(adaptee()->property("selfHandle"));
}

Tp::HandleIdentifierMap ChannelInterfaceGroupAdaptor::MemberIdentifiers() const
{
    return qvariant_cast< Tp::HandleIdentifierMap >(adaptee()->property("memberIdentifiers"));
}

void ChannelInterfaceGroupAdaptor::AddMembers(const Tp::UIntList& contacts, const QString& message, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("addMembers(Tp::UIntList,QString,Tp::Service::ChannelInterfaceGroupAdaptor::AddMembersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    AddMembersContextPtr ctx = AddMembersContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "addMembers",
        Q_ARG(Tp::UIntList, contacts), Q_ARG(QString, message),
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::AddMembersContextPtr, ctx));
}

Tp::UIntList ChannelInterfaceGroupAdaptor::GetAllMembers(const QDBusMessage& dbusMessage, Tp::UIntList& localPending, Tp::UIntList& remotePending)
{
    if (adaptee()->metaObject()->indexOfMethod("getAllMembers(Tp::Service::ChannelInterfaceGroupAdaptor::GetAllMembersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::UIntList();
    }

    GetAllMembersContextPtr ctx = GetAllMembersContextPtr(
            new Tp::MethodInvocationContext< Tp::UIntList, Tp::UIntList, Tp::UIntList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getAllMembers",
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::GetAllMembersContextPtr, ctx));
    return Tp::UIntList();
}

uint ChannelInterfaceGroupAdaptor::GetGroupFlags(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getGroupFlags(Tp::Service::ChannelInterfaceGroupAdaptor::GetGroupFlagsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetGroupFlagsContextPtr ctx = GetGroupFlagsContextPtr(
            new Tp::MethodInvocationContext< uint >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getGroupFlags",
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::GetGroupFlagsContextPtr, ctx));
    return uint();
}

Tp::UIntList ChannelInterfaceGroupAdaptor::GetHandleOwners(const Tp::UIntList& handles, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getHandleOwners(Tp::UIntList,Tp::Service::ChannelInterfaceGroupAdaptor::GetHandleOwnersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::UIntList();
    }

    GetHandleOwnersContextPtr ctx = GetHandleOwnersContextPtr(
            new Tp::MethodInvocationContext< Tp::UIntList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getHandleOwners",
        Q_ARG(Tp::UIntList, handles),
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::GetHandleOwnersContextPtr, ctx));
    return Tp::UIntList();
}

Tp::UIntList ChannelInterfaceGroupAdaptor::GetLocalPendingMembers(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getLocalPendingMembers(Tp::Service::ChannelInterfaceGroupAdaptor::GetLocalPendingMembersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::UIntList();
    }

    GetLocalPendingMembersContextPtr ctx = GetLocalPendingMembersContextPtr(
            new Tp::MethodInvocationContext< Tp::UIntList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getLocalPendingMembers",
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::GetLocalPendingMembersContextPtr, ctx));
    return Tp::UIntList();
}

Tp::LocalPendingInfoList ChannelInterfaceGroupAdaptor::GetLocalPendingMembersWithInfo(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getLocalPendingMembersWithInfo(Tp::Service::ChannelInterfaceGroupAdaptor::GetLocalPendingMembersWithInfoContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::LocalPendingInfoList();
    }

    GetLocalPendingMembersWithInfoContextPtr ctx = GetLocalPendingMembersWithInfoContextPtr(
            new Tp::MethodInvocationContext< Tp::LocalPendingInfoList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getLocalPendingMembersWithInfo",
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::GetLocalPendingMembersWithInfoContextPtr, ctx));
    return Tp::LocalPendingInfoList();
}

Tp::UIntList ChannelInterfaceGroupAdaptor::GetMembers(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getMembers(Tp::Service::ChannelInterfaceGroupAdaptor::GetMembersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::UIntList();
    }

    GetMembersContextPtr ctx = GetMembersContextPtr(
            new Tp::MethodInvocationContext< Tp::UIntList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getMembers",
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::GetMembersContextPtr, ctx));
    return Tp::UIntList();
}

Tp::UIntList ChannelInterfaceGroupAdaptor::GetRemotePendingMembers(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getRemotePendingMembers(Tp::Service::ChannelInterfaceGroupAdaptor::GetRemotePendingMembersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::UIntList();
    }

    GetRemotePendingMembersContextPtr ctx = GetRemotePendingMembersContextPtr(
            new Tp::MethodInvocationContext< Tp::UIntList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getRemotePendingMembers",
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::GetRemotePendingMembersContextPtr, ctx));
    return Tp::UIntList();
}

uint ChannelInterfaceGroupAdaptor::GetSelfHandle(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getSelfHandle(Tp::Service::ChannelInterfaceGroupAdaptor::GetSelfHandleContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetSelfHandleContextPtr ctx = GetSelfHandleContextPtr(
            new Tp::MethodInvocationContext< uint >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getSelfHandle",
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::GetSelfHandleContextPtr, ctx));
    return uint();
}

void ChannelInterfaceGroupAdaptor::RemoveMembers(const Tp::UIntList& contacts, const QString& message, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("removeMembers(Tp::UIntList,QString,Tp::Service::ChannelInterfaceGroupAdaptor::RemoveMembersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RemoveMembersContextPtr ctx = RemoveMembersContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "removeMembers",
        Q_ARG(Tp::UIntList, contacts), Q_ARG(QString, message),
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::RemoveMembersContextPtr, ctx));
}

void ChannelInterfaceGroupAdaptor::RemoveMembersWithReason(const Tp::UIntList& contacts, const QString& message, uint reason, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("removeMembersWithReason(Tp::UIntList,QString,uint,Tp::Service::ChannelInterfaceGroupAdaptor::RemoveMembersWithReasonContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RemoveMembersWithReasonContextPtr ctx = RemoveMembersWithReasonContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "removeMembersWithReason",
        Q_ARG(Tp::UIntList, contacts), Q_ARG(QString, message), Q_ARG(uint, reason),
        Q_ARG(Tp::Service::ChannelInterfaceGroupAdaptor::RemoveMembersWithReasonContextPtr, ctx));
}

ChannelInterfaceHoldAdaptor::ChannelInterfaceHoldAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(holdStateChanged(uint, uint)), SIGNAL(HoldStateChanged(uint, uint)));
}

ChannelInterfaceHoldAdaptor::~ChannelInterfaceHoldAdaptor()
{
}

uint ChannelInterfaceHoldAdaptor::GetHoldState(const QDBusMessage& dbusMessage, uint& reason)
{
    if (adaptee()->metaObject()->indexOfMethod("getHoldState(Tp::Service::ChannelInterfaceHoldAdaptor::GetHoldStateContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetHoldStateContextPtr ctx = GetHoldStateContextPtr(
            new Tp::MethodInvocationContext< uint, uint >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getHoldState",
        Q_ARG(Tp::Service::ChannelInterfaceHoldAdaptor::GetHoldStateContextPtr, ctx));
    return uint();
}

void ChannelInterfaceHoldAdaptor::RequestHold(bool hold, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestHold(bool,Tp::Service::ChannelInterfaceHoldAdaptor::RequestHoldContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RequestHoldContextPtr ctx = RequestHoldContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestHold",
        Q_ARG(bool, hold),
        Q_ARG(Tp::Service::ChannelInterfaceHoldAdaptor::RequestHoldContextPtr, ctx));
}

ChannelInterfaceMediaSignallingAdaptor::ChannelInterfaceMediaSignallingAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(newSessionHandler(const QDBusObjectPath&, const QString&)), SIGNAL(NewSessionHandler(const QDBusObjectPath&, const QString&)));
}

ChannelInterfaceMediaSignallingAdaptor::~ChannelInterfaceMediaSignallingAdaptor()
{
}

Tp::MediaSessionHandlerInfoList ChannelInterfaceMediaSignallingAdaptor::GetSessionHandlers(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getSessionHandlers(Tp::Service::ChannelInterfaceMediaSignallingAdaptor::GetSessionHandlersContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::MediaSessionHandlerInfoList();
    }

    GetSessionHandlersContextPtr ctx = GetSessionHandlersContextPtr(
            new Tp::MethodInvocationContext< Tp::MediaSessionHandlerInfoList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getSessionHandlers",
        Q_ARG(Tp::Service::ChannelInterfaceMediaSignallingAdaptor::GetSessionHandlersContextPtr, ctx));
    return Tp::MediaSessionHandlerInfoList();
}

ChannelInterfaceMergeableConferenceAdaptor::ChannelInterfaceMergeableConferenceAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceMergeableConferenceAdaptor::~ChannelInterfaceMergeableConferenceAdaptor()
{
}

void ChannelInterfaceMergeableConferenceAdaptor::Merge(const QDBusObjectPath& channel, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("merge(QDBusObjectPath,Tp::Service::ChannelInterfaceMergeableConferenceAdaptor::MergeContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    MergeContextPtr ctx = MergeContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "merge",
        Q_ARG(QDBusObjectPath, channel),
        Q_ARG(Tp::Service::ChannelInterfaceMergeableConferenceAdaptor::MergeContextPtr, ctx));
}

ChannelInterfaceMessagesAdaptor::ChannelInterfaceMessagesAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(messageSent(const Tp::MessagePartList&, uint, const QString&)), SIGNAL(MessageSent(const Tp::MessagePartList&, uint, const QString&)));
    connect(adaptee, SIGNAL(pendingMessagesRemoved(const Tp::UIntList&)), SIGNAL(PendingMessagesRemoved(const Tp::UIntList&)));
    connect(adaptee, SIGNAL(messageReceived(const Tp::MessagePartList&)), SIGNAL(MessageReceived(const Tp::MessagePartList&)));
}

ChannelInterfaceMessagesAdaptor::~ChannelInterfaceMessagesAdaptor()
{
}

QStringList ChannelInterfaceMessagesAdaptor::SupportedContentTypes() const
{
    return qvariant_cast< QStringList >(adaptee()->property("supportedContentTypes"));
}

Tp::UIntList ChannelInterfaceMessagesAdaptor::MessageTypes() const
{
    return qvariant_cast< Tp::UIntList >(adaptee()->property("messageTypes"));
}

uint ChannelInterfaceMessagesAdaptor::MessagePartSupportFlags() const
{
    return qvariant_cast< uint >(adaptee()->property("messagePartSupportFlags"));
}

Tp::MessagePartListList ChannelInterfaceMessagesAdaptor::PendingMessages() const
{
    return qvariant_cast< Tp::MessagePartListList >(adaptee()->property("pendingMessages"));
}

uint ChannelInterfaceMessagesAdaptor::DeliveryReportingSupport() const
{
    return qvariant_cast< uint >(adaptee()->property("deliveryReportingSupport"));
}

QString ChannelInterfaceMessagesAdaptor::SendMessage(const Tp::MessagePartList& message, uint flags, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("sendMessage(Tp::MessagePartList,uint,Tp::Service::ChannelInterfaceMessagesAdaptor::SendMessageContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    SendMessageContextPtr ctx = SendMessageContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "sendMessage",
        Q_ARG(Tp::MessagePartList, message), Q_ARG(uint, flags),
        Q_ARG(Tp::Service::ChannelInterfaceMessagesAdaptor::SendMessageContextPtr, ctx));
    return QString();
}

Tp::MessagePartContentMap ChannelInterfaceMessagesAdaptor::GetPendingMessageContent(uint messageID, const Tp::UIntList& parts, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getPendingMessageContent(uint,Tp::UIntList,Tp::Service::ChannelInterfaceMessagesAdaptor::GetPendingMessageContentContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::MessagePartContentMap();
    }

    GetPendingMessageContentContextPtr ctx = GetPendingMessageContentContextPtr(
            new Tp::MethodInvocationContext< Tp::MessagePartContentMap >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getPendingMessageContent",
        Q_ARG(uint, messageID), Q_ARG(Tp::UIntList, parts),
        Q_ARG(Tp::Service::ChannelInterfaceMessagesAdaptor::GetPendingMessageContentContextPtr, ctx));
    return Tp::MessagePartContentMap();
}

ChannelInterfacePasswordAdaptor::ChannelInterfacePasswordAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(passwordFlagsChanged(uint, uint)), SIGNAL(PasswordFlagsChanged(uint, uint)));
}

ChannelInterfacePasswordAdaptor::~ChannelInterfacePasswordAdaptor()
{
}

uint ChannelInterfacePasswordAdaptor::GetPasswordFlags(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getPasswordFlags(Tp::Service::ChannelInterfacePasswordAdaptor::GetPasswordFlagsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetPasswordFlagsContextPtr ctx = GetPasswordFlagsContextPtr(
            new Tp::MethodInvocationContext< uint >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getPasswordFlags",
        Q_ARG(Tp::Service::ChannelInterfacePasswordAdaptor::GetPasswordFlagsContextPtr, ctx));
    return uint();
}

bool ChannelInterfacePasswordAdaptor::ProvidePassword(const QString& password, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("providePassword(QString,Tp::Service::ChannelInterfacePasswordAdaptor::ProvidePasswordContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return bool();
    }

    ProvidePasswordContextPtr ctx = ProvidePasswordContextPtr(
            new Tp::MethodInvocationContext< bool >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "providePassword",
        Q_ARG(QString, password),
        Q_ARG(Tp::Service::ChannelInterfacePasswordAdaptor::ProvidePasswordContextPtr, ctx));
    return bool();
}

ChannelInterfaceRoomAdaptor::ChannelInterfaceRoomAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceRoomAdaptor::~ChannelInterfaceRoomAdaptor()
{
}

QString ChannelInterfaceRoomAdaptor::RoomName() const
{
    return qvariant_cast< QString >(adaptee()->property("roomName"));
}

QString ChannelInterfaceRoomAdaptor::Server() const
{
    return qvariant_cast< QString >(adaptee()->property("server"));
}

QString ChannelInterfaceRoomAdaptor::Creator() const
{
    return qvariant_cast< QString >(adaptee()->property("creator"));
}

uint ChannelInterfaceRoomAdaptor::CreatorHandle() const
{
    return qvariant_cast< uint >(adaptee()->property("creatorHandle"));
}

qlonglong ChannelInterfaceRoomAdaptor::CreationTimestamp() const
{
    return qvariant_cast< qlonglong >(adaptee()->property("creationTimestamp"));
}

ChannelInterfaceRoomConfigAdaptor::ChannelInterfaceRoomConfigAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceRoomConfigAdaptor::~ChannelInterfaceRoomConfigAdaptor()
{
}

bool ChannelInterfaceRoomConfigAdaptor::Anonymous() const
{
    return qvariant_cast< bool >(adaptee()->property("anonymous"));
}

bool ChannelInterfaceRoomConfigAdaptor::InviteOnly() const
{
    return qvariant_cast< bool >(adaptee()->property("inviteonly"));
}

uint ChannelInterfaceRoomConfigAdaptor::Limit() const
{
    return qvariant_cast< uint >(adaptee()->property("limit"));
}

bool ChannelInterfaceRoomConfigAdaptor::Moderated() const
{
    return qvariant_cast< bool >(adaptee()->property("moderated"));
}

QString ChannelInterfaceRoomConfigAdaptor::Title() const
{
    return qvariant_cast< QString >(adaptee()->property("title"));
}

QString ChannelInterfaceRoomConfigAdaptor::Description() const
{
    return qvariant_cast< QString >(adaptee()->property("description"));
}

bool ChannelInterfaceRoomConfigAdaptor::Persistent() const
{
    return qvariant_cast< bool >(adaptee()->property("persistent"));
}

bool ChannelInterfaceRoomConfigAdaptor::Private() const
{
    return qvariant_cast< bool >(adaptee()->property("private"));
}

bool ChannelInterfaceRoomConfigAdaptor::PasswordProtected() const
{
    return qvariant_cast< bool >(adaptee()->property("passwordProtected"));
}

QString ChannelInterfaceRoomConfigAdaptor::Password() const
{
    return qvariant_cast< QString >(adaptee()->property("password"));
}

QString ChannelInterfaceRoomConfigAdaptor::PasswordHint() const
{
    return qvariant_cast< QString >(adaptee()->property("passwordHint"));
}

bool ChannelInterfaceRoomConfigAdaptor::CanUpdateConfiguration() const
{
    return qvariant_cast< bool >(adaptee()->property("canUpdateConfiguration"));
}

QStringList ChannelInterfaceRoomConfigAdaptor::MutableProperties() const
{
    return qvariant_cast< QStringList >(adaptee()->property("mutableProperties"));
}

bool ChannelInterfaceRoomConfigAdaptor::ConfigurationRetrieved() const
{
    return qvariant_cast< bool >(adaptee()->property("configurationRetrieved"));
}

void ChannelInterfaceRoomConfigAdaptor::UpdateConfiguration(const QVariantMap& properties, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("updateConfiguration(QVariantMap,Tp::Service::ChannelInterfaceRoomConfigAdaptor::UpdateConfigurationContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    UpdateConfigurationContextPtr ctx = UpdateConfigurationContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "updateConfiguration",
        Q_ARG(QVariantMap, properties),
        Q_ARG(Tp::Service::ChannelInterfaceRoomConfigAdaptor::UpdateConfigurationContextPtr, ctx));
}

ChannelInterfaceSASLAuthenticationAdaptor::ChannelInterfaceSASLAuthenticationAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(saslStatusChanged(uint, const QString&, const QVariantMap&)), SIGNAL(SASLStatusChanged(uint, const QString&, const QVariantMap&)));
    connect(adaptee, SIGNAL(newChallenge(const QByteArray&)), SIGNAL(NewChallenge(const QByteArray&)));
}

ChannelInterfaceSASLAuthenticationAdaptor::~ChannelInterfaceSASLAuthenticationAdaptor()
{
}

QStringList ChannelInterfaceSASLAuthenticationAdaptor::AvailableMechanisms() const
{
    return qvariant_cast< QStringList >(adaptee()->property("availableMechanisms"));
}

bool ChannelInterfaceSASLAuthenticationAdaptor::HasInitialData() const
{
    return qvariant_cast< bool >(adaptee()->property("hasInitialData"));
}

bool ChannelInterfaceSASLAuthenticationAdaptor::CanTryAgain() const
{
    return qvariant_cast< bool >(adaptee()->property("canTryAgain"));
}

uint ChannelInterfaceSASLAuthenticationAdaptor::SASLStatus() const
{
    return qvariant_cast< uint >(adaptee()->property("saslStatus"));
}

QString ChannelInterfaceSASLAuthenticationAdaptor::SASLError() const
{
    return qvariant_cast< QString >(adaptee()->property("saslError"));
}

QVariantMap ChannelInterfaceSASLAuthenticationAdaptor::SASLErrorDetails() const
{
    return qvariant_cast< QVariantMap >(adaptee()->property("saslErrorDetails"));
}

QString ChannelInterfaceSASLAuthenticationAdaptor::AuthorizationIdentity() const
{
    return qvariant_cast< QString >(adaptee()->property("authorizationIdentity"));
}

QString ChannelInterfaceSASLAuthenticationAdaptor::DefaultUsername() const
{
    return qvariant_cast< QString >(adaptee()->property("defaultUsername"));
}

QString ChannelInterfaceSASLAuthenticationAdaptor::DefaultRealm() const
{
    return qvariant_cast< QString >(adaptee()->property("defaultRealm"));
}

bool ChannelInterfaceSASLAuthenticationAdaptor::MaySaveResponse() const
{
    return qvariant_cast< bool >(adaptee()->property("maySaveResponse"));
}

void ChannelInterfaceSASLAuthenticationAdaptor::StartMechanism(const QString& mechanism, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("startMechanism(QString,Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::StartMechanismContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    StartMechanismContextPtr ctx = StartMechanismContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "startMechanism",
        Q_ARG(QString, mechanism),
        Q_ARG(Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::StartMechanismContextPtr, ctx));
}

void ChannelInterfaceSASLAuthenticationAdaptor::StartMechanismWithData(const QString& mechanism, const QByteArray& initialData, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("startMechanismWithData(QString,QByteArray,Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::StartMechanismWithDataContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    StartMechanismWithDataContextPtr ctx = StartMechanismWithDataContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "startMechanismWithData",
        Q_ARG(QString, mechanism), Q_ARG(QByteArray, initialData),
        Q_ARG(Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::StartMechanismWithDataContextPtr, ctx));
}

void ChannelInterfaceSASLAuthenticationAdaptor::Respond(const QByteArray& responseData, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("respond(QByteArray,Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::RespondContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RespondContextPtr ctx = RespondContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "respond",
        Q_ARG(QByteArray, responseData),
        Q_ARG(Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::RespondContextPtr, ctx));
}

void ChannelInterfaceSASLAuthenticationAdaptor::AcceptSASL(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("acceptSASL(Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::AcceptSASLContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    AcceptSASLContextPtr ctx = AcceptSASLContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "acceptSASL",
        Q_ARG(Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::AcceptSASLContextPtr, ctx));
}

void ChannelInterfaceSASLAuthenticationAdaptor::AbortSASL(uint reason, const QString& debugMessage, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("abortSASL(uint,QString,Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::AbortSASLContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    AbortSASLContextPtr ctx = AbortSASLContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "abortSASL",
        Q_ARG(uint, reason), Q_ARG(QString, debugMessage),
        Q_ARG(Tp::Service::ChannelInterfaceSASLAuthenticationAdaptor::AbortSASLContextPtr, ctx));
}

ChannelInterfaceSMSAdaptor::ChannelInterfaceSMSAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(smsChannelChanged(bool)), SIGNAL(SMSChannelChanged(bool)));
}

ChannelInterfaceSMSAdaptor::~ChannelInterfaceSMSAdaptor()
{
}

bool ChannelInterfaceSMSAdaptor::Flash() const
{
    return qvariant_cast< bool >(adaptee()->property("flash"));
}

bool ChannelInterfaceSMSAdaptor::SMSChannel() const
{
    return qvariant_cast< bool >(adaptee()->property("smsChannel"));
}

uint ChannelInterfaceSMSAdaptor::GetSMSLength(const Tp::MessagePartList& message, const QDBusMessage& dbusMessage, int& remainingCharacters, int& estimatedCost)
{
    if (adaptee()->metaObject()->indexOfMethod("getSMSLength(Tp::MessagePartList,Tp::Service::ChannelInterfaceSMSAdaptor::GetSMSLengthContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return uint();
    }

    GetSMSLengthContextPtr ctx = GetSMSLengthContextPtr(
            new Tp::MethodInvocationContext< uint, int, int >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getSMSLength",
        Q_ARG(Tp::MessagePartList, message),
        Q_ARG(Tp::Service::ChannelInterfaceSMSAdaptor::GetSMSLengthContextPtr, ctx));
    return uint();
}

ChannelInterfaceSecurableAdaptor::ChannelInterfaceSecurableAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceSecurableAdaptor::~ChannelInterfaceSecurableAdaptor()
{
}

bool ChannelInterfaceSecurableAdaptor::Encrypted() const
{
    return qvariant_cast< bool >(adaptee()->property("encrypted"));
}

bool ChannelInterfaceSecurableAdaptor::Verified() const
{
    return qvariant_cast< bool >(adaptee()->property("verified"));
}

ChannelInterfaceServicePointAdaptor::ChannelInterfaceServicePointAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(servicePointChanged(const Tp::ServicePoint&)), SIGNAL(ServicePointChanged(const Tp::ServicePoint&)));
}

ChannelInterfaceServicePointAdaptor::~ChannelInterfaceServicePointAdaptor()
{
}

Tp::ServicePoint ChannelInterfaceServicePointAdaptor::InitialServicePoint() const
{
    return qvariant_cast< Tp::ServicePoint >(adaptee()->property("initialServicePoint"));
}

Tp::ServicePoint ChannelInterfaceServicePointAdaptor::CurrentServicePoint() const
{
    return qvariant_cast< Tp::ServicePoint >(adaptee()->property("currentServicePoint"));
}

ChannelInterfaceSplittableAdaptor::ChannelInterfaceSplittableAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceSplittableAdaptor::~ChannelInterfaceSplittableAdaptor()
{
}

void ChannelInterfaceSplittableAdaptor::Split(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("split(Tp::Service::ChannelInterfaceSplittableAdaptor::SplitContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SplitContextPtr ctx = SplitContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "split",
        Q_ARG(Tp::Service::ChannelInterfaceSplittableAdaptor::SplitContextPtr, ctx));
}

ChannelInterfaceSubjectAdaptor::ChannelInterfaceSubjectAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelInterfaceSubjectAdaptor::~ChannelInterfaceSubjectAdaptor()
{
}

QString ChannelInterfaceSubjectAdaptor::Subject() const
{
    return qvariant_cast< QString >(adaptee()->property("subject"));
}

QString ChannelInterfaceSubjectAdaptor::Actor() const
{
    return qvariant_cast< QString >(adaptee()->property("actor"));
}

uint ChannelInterfaceSubjectAdaptor::ActorHandle() const
{
    return qvariant_cast< uint >(adaptee()->property("actorHandle"));
}

qlonglong ChannelInterfaceSubjectAdaptor::Timestamp() const
{
    return qvariant_cast< qlonglong >(adaptee()->property("timestamp"));
}

bool ChannelInterfaceSubjectAdaptor::CanSet() const
{
    return qvariant_cast< bool >(adaptee()->property("canSet"));
}

void ChannelInterfaceSubjectAdaptor::SetSubject(const QString& subject, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setSubject(QString,Tp::Service::ChannelInterfaceSubjectAdaptor::SetSubjectContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetSubjectContextPtr ctx = SetSubjectContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setSubject",
        Q_ARG(QString, subject),
        Q_ARG(Tp::Service::ChannelInterfaceSubjectAdaptor::SetSubjectContextPtr, ctx));
}

ChannelTypeCallAdaptor::ChannelTypeCallAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(contentAdded(const QDBusObjectPath&)), SIGNAL(ContentAdded(const QDBusObjectPath&)));
    connect(adaptee, SIGNAL(contentRemoved(const QDBusObjectPath&, const Tp::CallStateReason&)), SIGNAL(ContentRemoved(const QDBusObjectPath&, const Tp::CallStateReason&)));
    connect(adaptee, SIGNAL(callStateChanged(uint, uint, const Tp::CallStateReason&, const QVariantMap&)), SIGNAL(CallStateChanged(uint, uint, const Tp::CallStateReason&, const QVariantMap&)));
    connect(adaptee, SIGNAL(callMembersChanged(const Tp::CallMemberMap&, const Tp::HandleIdentifierMap&, const Tp::UIntList&, const Tp::CallStateReason&)), SIGNAL(CallMembersChanged(const Tp::CallMemberMap&, const Tp::HandleIdentifierMap&, const Tp::UIntList&, const Tp::CallStateReason&)));
}

ChannelTypeCallAdaptor::~ChannelTypeCallAdaptor()
{
}

Tp::ObjectPathList ChannelTypeCallAdaptor::Contents() const
{
    return qvariant_cast< Tp::ObjectPathList >(adaptee()->property("contents"));
}

QVariantMap ChannelTypeCallAdaptor::CallStateDetails() const
{
    return qvariant_cast< QVariantMap >(adaptee()->property("callStateDetails"));
}

uint ChannelTypeCallAdaptor::CallState() const
{
    return qvariant_cast< uint >(adaptee()->property("callState"));
}

uint ChannelTypeCallAdaptor::CallFlags() const
{
    return qvariant_cast< uint >(adaptee()->property("callFlags"));
}

Tp::CallStateReason ChannelTypeCallAdaptor::CallStateReason() const
{
    return qvariant_cast< Tp::CallStateReason >(adaptee()->property("callStateReason"));
}

bool ChannelTypeCallAdaptor::HardwareStreaming() const
{
    return qvariant_cast< bool >(adaptee()->property("hardwareStreaming"));
}

Tp::CallMemberMap ChannelTypeCallAdaptor::CallMembers() const
{
    return qvariant_cast< Tp::CallMemberMap >(adaptee()->property("callMembers"));
}

Tp::HandleIdentifierMap ChannelTypeCallAdaptor::MemberIdentifiers() const
{
    return qvariant_cast< Tp::HandleIdentifierMap >(adaptee()->property("memberIdentifiers"));
}

uint ChannelTypeCallAdaptor::InitialTransport() const
{
    return qvariant_cast< uint >(adaptee()->property("initialTransport"));
}

bool ChannelTypeCallAdaptor::InitialAudio() const
{
    return qvariant_cast< bool >(adaptee()->property("initialAudio"));
}

bool ChannelTypeCallAdaptor::InitialVideo() const
{
    return qvariant_cast< bool >(adaptee()->property("initialVideo"));
}

QString ChannelTypeCallAdaptor::InitialAudioName() const
{
    return qvariant_cast< QString >(adaptee()->property("initialAudioName"));
}

QString ChannelTypeCallAdaptor::InitialVideoName() const
{
    return qvariant_cast< QString >(adaptee()->property("initialVideoName"));
}

bool ChannelTypeCallAdaptor::MutableContents() const
{
    return qvariant_cast< bool >(adaptee()->property("mutableContents"));
}

void ChannelTypeCallAdaptor::SetRinging(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setRinging(Tp::Service::ChannelTypeCallAdaptor::SetRingingContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetRingingContextPtr ctx = SetRingingContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setRinging",
        Q_ARG(Tp::Service::ChannelTypeCallAdaptor::SetRingingContextPtr, ctx));
}

void ChannelTypeCallAdaptor::SetQueued(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("setQueued(Tp::Service::ChannelTypeCallAdaptor::SetQueuedContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SetQueuedContextPtr ctx = SetQueuedContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "setQueued",
        Q_ARG(Tp::Service::ChannelTypeCallAdaptor::SetQueuedContextPtr, ctx));
}

void ChannelTypeCallAdaptor::Accept(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("accept(Tp::Service::ChannelTypeCallAdaptor::AcceptContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    AcceptContextPtr ctx = AcceptContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "accept",
        Q_ARG(Tp::Service::ChannelTypeCallAdaptor::AcceptContextPtr, ctx));
}

void ChannelTypeCallAdaptor::Hangup(uint reason, const QString& detailedHangupReason, const QString& message, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("hangup(uint,QString,QString,Tp::Service::ChannelTypeCallAdaptor::HangupContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    HangupContextPtr ctx = HangupContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "hangup",
        Q_ARG(uint, reason), Q_ARG(QString, detailedHangupReason), Q_ARG(QString, message),
        Q_ARG(Tp::Service::ChannelTypeCallAdaptor::HangupContextPtr, ctx));
}

QDBusObjectPath ChannelTypeCallAdaptor::AddContent(const QString& contentName, uint contentType, uint initialDirection, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("addContent(QString,uint,uint,Tp::Service::ChannelTypeCallAdaptor::AddContentContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QDBusObjectPath();
    }

    AddContentContextPtr ctx = AddContentContextPtr(
            new Tp::MethodInvocationContext< QDBusObjectPath >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "addContent",
        Q_ARG(QString, contentName), Q_ARG(uint, contentType), Q_ARG(uint, initialDirection),
        Q_ARG(Tp::Service::ChannelTypeCallAdaptor::AddContentContextPtr, ctx));
    return QDBusObjectPath();
}

ChannelTypeContactSearchAdaptor::ChannelTypeContactSearchAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(searchStateChanged(uint, const QString&, const QVariantMap&)), SIGNAL(SearchStateChanged(uint, const QString&, const QVariantMap&)));
    connect(adaptee, SIGNAL(searchResultReceived(const Tp::ContactSearchResultMap&)), SIGNAL(SearchResultReceived(const Tp::ContactSearchResultMap&)));
}

ChannelTypeContactSearchAdaptor::~ChannelTypeContactSearchAdaptor()
{
}

uint ChannelTypeContactSearchAdaptor::SearchState() const
{
    return qvariant_cast< uint >(adaptee()->property("searchState"));
}

uint ChannelTypeContactSearchAdaptor::Limit() const
{
    return qvariant_cast< uint >(adaptee()->property("limit"));
}

QStringList ChannelTypeContactSearchAdaptor::AvailableSearchKeys() const
{
    return qvariant_cast< QStringList >(adaptee()->property("availableSearchKeys"));
}

QString ChannelTypeContactSearchAdaptor::Server() const
{
    return qvariant_cast< QString >(adaptee()->property("server"));
}

void ChannelTypeContactSearchAdaptor::Search(const Tp::ContactSearchMap& terms, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("search(Tp::ContactSearchMap,Tp::Service::ChannelTypeContactSearchAdaptor::SearchContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SearchContextPtr ctx = SearchContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "search",
        Q_ARG(Tp::ContactSearchMap, terms),
        Q_ARG(Tp::Service::ChannelTypeContactSearchAdaptor::SearchContextPtr, ctx));
}

void ChannelTypeContactSearchAdaptor::More(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("more(Tp::Service::ChannelTypeContactSearchAdaptor::MoreContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    MoreContextPtr ctx = MoreContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "more",
        Q_ARG(Tp::Service::ChannelTypeContactSearchAdaptor::MoreContextPtr, ctx));
}

void ChannelTypeContactSearchAdaptor::Stop(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("stop(Tp::Service::ChannelTypeContactSearchAdaptor::StopContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    StopContextPtr ctx = StopContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "stop",
        Q_ARG(Tp::Service::ChannelTypeContactSearchAdaptor::StopContextPtr, ctx));
}

ChannelTypeDBusTubeAdaptor::ChannelTypeDBusTubeAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(dbusNamesChanged(const Tp::DBusTubeParticipants&, const Tp::UIntList&)), SIGNAL(DBusNamesChanged(const Tp::DBusTubeParticipants&, const Tp::UIntList&)));
}

ChannelTypeDBusTubeAdaptor::~ChannelTypeDBusTubeAdaptor()
{
}

QString ChannelTypeDBusTubeAdaptor::ServiceName() const
{
    return qvariant_cast< QString >(adaptee()->property("serviceName"));
}

Tp::DBusTubeParticipants ChannelTypeDBusTubeAdaptor::DBusNames() const
{
    return qvariant_cast< Tp::DBusTubeParticipants >(adaptee()->property("dbusNames"));
}

Tp::UIntList ChannelTypeDBusTubeAdaptor::SupportedAccessControls() const
{
    return qvariant_cast< Tp::UIntList >(adaptee()->property("supportedAccessControls"));
}

QString ChannelTypeDBusTubeAdaptor::Offer(const QVariantMap& parameters, uint accesscontrol, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("offer(QVariantMap,uint,Tp::Service::ChannelTypeDBusTubeAdaptor::OfferContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    OfferContextPtr ctx = OfferContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "offer",
        Q_ARG(QVariantMap, parameters), Q_ARG(uint, accesscontrol),
        Q_ARG(Tp::Service::ChannelTypeDBusTubeAdaptor::OfferContextPtr, ctx));
    return QString();
}

QString ChannelTypeDBusTubeAdaptor::Accept(uint accesscontrol, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("accept(uint,Tp::Service::ChannelTypeDBusTubeAdaptor::AcceptContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QString();
    }

    AcceptContextPtr ctx = AcceptContextPtr(
            new Tp::MethodInvocationContext< QString >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "accept",
        Q_ARG(uint, accesscontrol),
        Q_ARG(Tp::Service::ChannelTypeDBusTubeAdaptor::AcceptContextPtr, ctx));
    return QString();
}

ChannelTypeFileTransferAdaptor::ChannelTypeFileTransferAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(fileTransferStateChanged(uint, uint)), SIGNAL(FileTransferStateChanged(uint, uint)));
    connect(adaptee, SIGNAL(transferredBytesChanged(qulonglong)), SIGNAL(TransferredBytesChanged(qulonglong)));
    connect(adaptee, SIGNAL(initialOffsetDefined(qulonglong)), SIGNAL(InitialOffsetDefined(qulonglong)));
    connect(adaptee, SIGNAL(uriDefined(const QString&)), SIGNAL(URIDefined(const QString&)));
}

ChannelTypeFileTransferAdaptor::~ChannelTypeFileTransferAdaptor()
{
}

uint ChannelTypeFileTransferAdaptor::State() const
{
    return qvariant_cast< uint >(adaptee()->property("state"));
}

QString ChannelTypeFileTransferAdaptor::ContentType() const
{
    return qvariant_cast< QString >(adaptee()->property("contentType"));
}

QString ChannelTypeFileTransferAdaptor::Filename() const
{
    return qvariant_cast< QString >(adaptee()->property("filename"));
}

qulonglong ChannelTypeFileTransferAdaptor::Size() const
{
    return qvariant_cast< qulonglong >(adaptee()->property("size"));
}

uint ChannelTypeFileTransferAdaptor::ContentHashType() const
{
    return qvariant_cast< uint >(adaptee()->property("contentHashType"));
}

QString ChannelTypeFileTransferAdaptor::ContentHash() const
{
    return qvariant_cast< QString >(adaptee()->property("contentHash"));
}

QString ChannelTypeFileTransferAdaptor::Description() const
{
    return qvariant_cast< QString >(adaptee()->property("description"));
}

qlonglong ChannelTypeFileTransferAdaptor::Date() const
{
    return qvariant_cast< qlonglong >(adaptee()->property("date"));
}

Tp::SupportedSocketMap ChannelTypeFileTransferAdaptor::AvailableSocketTypes() const
{
    return qvariant_cast< Tp::SupportedSocketMap >(adaptee()->property("availableSocketTypes"));
}

qulonglong ChannelTypeFileTransferAdaptor::TransferredBytes() const
{
    return qvariant_cast< qulonglong >(adaptee()->property("transferredBytes"));
}

qulonglong ChannelTypeFileTransferAdaptor::InitialOffset() const
{
    return qvariant_cast< qulonglong >(adaptee()->property("initialOffset"));
}

QString ChannelTypeFileTransferAdaptor::URI() const
{
    return qvariant_cast< QString >(adaptee()->property("uri"));
}

void ChannelTypeFileTransferAdaptor::SetURI(const QString &newValue)
{
    adaptee()->setProperty("uri", qVariantFromValue(newValue));
}

QString ChannelTypeFileTransferAdaptor::FileCollection() const
{
    return qvariant_cast< QString >(adaptee()->property("fileCollection"));
}

QDBusVariant ChannelTypeFileTransferAdaptor::AcceptFile(uint addressType, uint accessControl, const QDBusVariant& accessControlParam, qulonglong offset, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("acceptFile(uint,uint,QDBusVariant,qulonglong,Tp::Service::ChannelTypeFileTransferAdaptor::AcceptFileContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QDBusVariant();
    }

    AcceptFileContextPtr ctx = AcceptFileContextPtr(
            new Tp::MethodInvocationContext< QDBusVariant >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "acceptFile",
        Q_ARG(uint, addressType), Q_ARG(uint, accessControl), Q_ARG(QDBusVariant, accessControlParam), Q_ARG(qulonglong, offset),
        Q_ARG(Tp::Service::ChannelTypeFileTransferAdaptor::AcceptFileContextPtr, ctx));
    return QDBusVariant();
}

QDBusVariant ChannelTypeFileTransferAdaptor::ProvideFile(uint addressType, uint accessControl, const QDBusVariant& accessControlParam, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("provideFile(uint,uint,QDBusVariant,Tp::Service::ChannelTypeFileTransferAdaptor::ProvideFileContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QDBusVariant();
    }

    ProvideFileContextPtr ctx = ProvideFileContextPtr(
            new Tp::MethodInvocationContext< QDBusVariant >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "provideFile",
        Q_ARG(uint, addressType), Q_ARG(uint, accessControl), Q_ARG(QDBusVariant, accessControlParam),
        Q_ARG(Tp::Service::ChannelTypeFileTransferAdaptor::ProvideFileContextPtr, ctx));
    return QDBusVariant();
}

ChannelTypeRoomListAdaptor::ChannelTypeRoomListAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(gotRooms(const Tp::RoomInfoList&)), SIGNAL(GotRooms(const Tp::RoomInfoList&)));
    connect(adaptee, SIGNAL(listingRooms(bool)), SIGNAL(ListingRooms(bool)));
}

ChannelTypeRoomListAdaptor::~ChannelTypeRoomListAdaptor()
{
}

QString ChannelTypeRoomListAdaptor::Server() const
{
    return qvariant_cast< QString >(adaptee()->property("server"));
}

bool ChannelTypeRoomListAdaptor::GetListingRooms(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getListingRooms(Tp::Service::ChannelTypeRoomListAdaptor::GetListingRoomsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return bool();
    }

    GetListingRoomsContextPtr ctx = GetListingRoomsContextPtr(
            new Tp::MethodInvocationContext< bool >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getListingRooms",
        Q_ARG(Tp::Service::ChannelTypeRoomListAdaptor::GetListingRoomsContextPtr, ctx));
    return bool();
}

void ChannelTypeRoomListAdaptor::ListRooms(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("listRooms(Tp::Service::ChannelTypeRoomListAdaptor::ListRoomsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    ListRoomsContextPtr ctx = ListRoomsContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "listRooms",
        Q_ARG(Tp::Service::ChannelTypeRoomListAdaptor::ListRoomsContextPtr, ctx));
}

void ChannelTypeRoomListAdaptor::StopListing(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("stopListing(Tp::Service::ChannelTypeRoomListAdaptor::StopListingContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    StopListingContextPtr ctx = StopListingContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "stopListing",
        Q_ARG(Tp::Service::ChannelTypeRoomListAdaptor::StopListingContextPtr, ctx));
}

ChannelTypeServerAuthenticationAdaptor::ChannelTypeServerAuthenticationAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelTypeServerAuthenticationAdaptor::~ChannelTypeServerAuthenticationAdaptor()
{
}

QString ChannelTypeServerAuthenticationAdaptor::AuthenticationMethod() const
{
    return qvariant_cast< QString >(adaptee()->property("authenticationMethod"));
}

ChannelTypeServerTLSConnectionAdaptor::ChannelTypeServerTLSConnectionAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
}

ChannelTypeServerTLSConnectionAdaptor::~ChannelTypeServerTLSConnectionAdaptor()
{
}

QDBusObjectPath ChannelTypeServerTLSConnectionAdaptor::ServerCertificate() const
{
    return qvariant_cast< QDBusObjectPath >(adaptee()->property("serverCertificate"));
}

QString ChannelTypeServerTLSConnectionAdaptor::Hostname() const
{
    return qvariant_cast< QString >(adaptee()->property("hostname"));
}

QStringList ChannelTypeServerTLSConnectionAdaptor::ReferenceIdentities() const
{
    return qvariant_cast< QStringList >(adaptee()->property("referenceIdentities"));
}

ChannelTypeStreamTubeAdaptor::ChannelTypeStreamTubeAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(newRemoteConnection(uint, const QDBusVariant&, uint)), SIGNAL(NewRemoteConnection(uint, const QDBusVariant&, uint)));
    connect(adaptee, SIGNAL(newLocalConnection(uint)), SIGNAL(NewLocalConnection(uint)));
    connect(adaptee, SIGNAL(connectionClosed(uint, const QString&, const QString&)), SIGNAL(ConnectionClosed(uint, const QString&, const QString&)));
}

ChannelTypeStreamTubeAdaptor::~ChannelTypeStreamTubeAdaptor()
{
}

QString ChannelTypeStreamTubeAdaptor::Service() const
{
    return qvariant_cast< QString >(adaptee()->property("service"));
}

Tp::SupportedSocketMap ChannelTypeStreamTubeAdaptor::SupportedSocketTypes() const
{
    return qvariant_cast< Tp::SupportedSocketMap >(adaptee()->property("supportedSocketTypes"));
}

void ChannelTypeStreamTubeAdaptor::Offer(uint addresstype, const QDBusVariant& address, uint accesscontrol, const QVariantMap& parameters, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("offer(uint,QDBusVariant,uint,QVariantMap,Tp::Service::ChannelTypeStreamTubeAdaptor::OfferContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    OfferContextPtr ctx = OfferContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "offer",
        Q_ARG(uint, addresstype), Q_ARG(QDBusVariant, address), Q_ARG(uint, accesscontrol), Q_ARG(QVariantMap, parameters),
        Q_ARG(Tp::Service::ChannelTypeStreamTubeAdaptor::OfferContextPtr, ctx));
}

QDBusVariant ChannelTypeStreamTubeAdaptor::Accept(uint addresstype, uint accesscontrol, const QDBusVariant& accesscontrolparam, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("accept(uint,uint,QDBusVariant,Tp::Service::ChannelTypeStreamTubeAdaptor::AcceptContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return QDBusVariant();
    }

    AcceptContextPtr ctx = AcceptContextPtr(
            new Tp::MethodInvocationContext< QDBusVariant >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "accept",
        Q_ARG(uint, addresstype), Q_ARG(uint, accesscontrol), Q_ARG(QDBusVariant, accesscontrolparam),
        Q_ARG(Tp::Service::ChannelTypeStreamTubeAdaptor::AcceptContextPtr, ctx));
    return QDBusVariant();
}

ChannelTypeStreamedMediaAdaptor::ChannelTypeStreamedMediaAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(streamAdded(uint, uint, uint)), SIGNAL(StreamAdded(uint, uint, uint)));
    connect(adaptee, SIGNAL(streamDirectionChanged(uint, uint, uint)), SIGNAL(StreamDirectionChanged(uint, uint, uint)));
    connect(adaptee, SIGNAL(streamError(uint, uint, const QString&)), SIGNAL(StreamError(uint, uint, const QString&)));
    connect(adaptee, SIGNAL(streamRemoved(uint)), SIGNAL(StreamRemoved(uint)));
    connect(adaptee, SIGNAL(streamStateChanged(uint, uint)), SIGNAL(StreamStateChanged(uint, uint)));
}

ChannelTypeStreamedMediaAdaptor::~ChannelTypeStreamedMediaAdaptor()
{
}

bool ChannelTypeStreamedMediaAdaptor::InitialAudio() const
{
    return qvariant_cast< bool >(adaptee()->property("initialAudio"));
}

bool ChannelTypeStreamedMediaAdaptor::InitialVideo() const
{
    return qvariant_cast< bool >(adaptee()->property("initialVideo"));
}

bool ChannelTypeStreamedMediaAdaptor::ImmutableStreams() const
{
    return qvariant_cast< bool >(adaptee()->property("immutableStreams"));
}

Tp::MediaStreamInfoList ChannelTypeStreamedMediaAdaptor::ListStreams(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("listStreams(Tp::Service::ChannelTypeStreamedMediaAdaptor::ListStreamsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::MediaStreamInfoList();
    }

    ListStreamsContextPtr ctx = ListStreamsContextPtr(
            new Tp::MethodInvocationContext< Tp::MediaStreamInfoList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "listStreams",
        Q_ARG(Tp::Service::ChannelTypeStreamedMediaAdaptor::ListStreamsContextPtr, ctx));
    return Tp::MediaStreamInfoList();
}

void ChannelTypeStreamedMediaAdaptor::RemoveStreams(const Tp::UIntList& streams, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("removeStreams(Tp::UIntList,Tp::Service::ChannelTypeStreamedMediaAdaptor::RemoveStreamsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RemoveStreamsContextPtr ctx = RemoveStreamsContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "removeStreams",
        Q_ARG(Tp::UIntList, streams),
        Q_ARG(Tp::Service::ChannelTypeStreamedMediaAdaptor::RemoveStreamsContextPtr, ctx));
}

void ChannelTypeStreamedMediaAdaptor::RequestStreamDirection(uint streamID, uint streamDirection, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestStreamDirection(uint,uint,Tp::Service::ChannelTypeStreamedMediaAdaptor::RequestStreamDirectionContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RequestStreamDirectionContextPtr ctx = RequestStreamDirectionContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestStreamDirection",
        Q_ARG(uint, streamID), Q_ARG(uint, streamDirection),
        Q_ARG(Tp::Service::ChannelTypeStreamedMediaAdaptor::RequestStreamDirectionContextPtr, ctx));
}

Tp::MediaStreamInfoList ChannelTypeStreamedMediaAdaptor::RequestStreams(uint contactHandle, const Tp::UIntList& types, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestStreams(uint,Tp::UIntList,Tp::Service::ChannelTypeStreamedMediaAdaptor::RequestStreamsContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::MediaStreamInfoList();
    }

    RequestStreamsContextPtr ctx = RequestStreamsContextPtr(
            new Tp::MethodInvocationContext< Tp::MediaStreamInfoList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestStreams",
        Q_ARG(uint, contactHandle), Q_ARG(Tp::UIntList, types),
        Q_ARG(Tp::Service::ChannelTypeStreamedMediaAdaptor::RequestStreamsContextPtr, ctx));
    return Tp::MediaStreamInfoList();
}

ChannelTypeTextAdaptor::ChannelTypeTextAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(lostMessage()), SIGNAL(LostMessage()));
    connect(adaptee, SIGNAL(received(uint, uint, uint, uint, uint, const QString&)), SIGNAL(Received(uint, uint, uint, uint, uint, const QString&)));
    connect(adaptee, SIGNAL(sendError(uint, uint, uint, const QString&)), SIGNAL(SendError(uint, uint, uint, const QString&)));
    connect(adaptee, SIGNAL(sent(uint, uint, const QString&)), SIGNAL(Sent(uint, uint, const QString&)));
}

ChannelTypeTextAdaptor::~ChannelTypeTextAdaptor()
{
}

void ChannelTypeTextAdaptor::AcknowledgePendingMessages(const Tp::UIntList& IDs, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("acknowledgePendingMessages(Tp::UIntList,Tp::Service::ChannelTypeTextAdaptor::AcknowledgePendingMessagesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    AcknowledgePendingMessagesContextPtr ctx = AcknowledgePendingMessagesContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "acknowledgePendingMessages",
        Q_ARG(Tp::UIntList, IDs),
        Q_ARG(Tp::Service::ChannelTypeTextAdaptor::AcknowledgePendingMessagesContextPtr, ctx));
}

Tp::UIntList ChannelTypeTextAdaptor::GetMessageTypes(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("getMessageTypes(Tp::Service::ChannelTypeTextAdaptor::GetMessageTypesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::UIntList();
    }

    GetMessageTypesContextPtr ctx = GetMessageTypesContextPtr(
            new Tp::MethodInvocationContext< Tp::UIntList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "getMessageTypes",
        Q_ARG(Tp::Service::ChannelTypeTextAdaptor::GetMessageTypesContextPtr, ctx));
    return Tp::UIntList();
}

Tp::PendingTextMessageList ChannelTypeTextAdaptor::ListPendingMessages(bool clear, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("listPendingMessages(bool,Tp::Service::ChannelTypeTextAdaptor::ListPendingMessagesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return Tp::PendingTextMessageList();
    }

    ListPendingMessagesContextPtr ctx = ListPendingMessagesContextPtr(
            new Tp::MethodInvocationContext< Tp::PendingTextMessageList >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "listPendingMessages",
        Q_ARG(bool, clear),
        Q_ARG(Tp::Service::ChannelTypeTextAdaptor::ListPendingMessagesContextPtr, ctx));
    return Tp::PendingTextMessageList();
}

void ChannelTypeTextAdaptor::Send(uint type, const QString& text, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("send(uint,QString,Tp::Service::ChannelTypeTextAdaptor::SendContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    SendContextPtr ctx = SendContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "send",
        Q_ARG(uint, type), Q_ARG(QString, text),
        Q_ARG(Tp::Service::ChannelTypeTextAdaptor::SendContextPtr, ctx));
}

}
}