/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* This module supports reading and parsing input. */

/* Functions. ===============================================================*/

extern void parse_whitespace( string_t *input ); 
/* Read whitespace in *INPUT and update *INPUT. */

extern int_t parse_int( string_t *input );
/* Parse the next integer number from *INPUT and update *INPUT.
 * If there is no integer, an error is reported. */

extern int_t parse_cardinal( string_t *input );
/* Parse the next positive integer number from *INPUT and update *INPUT.
 * If there is no integer, an error is reported. */

extern double parse_double( string_t *input );
/* Parse the next double from *INPUT and update *INPUT.
 * If there is no double, an error is reported. */

extern char_t *parse_word( string_t *input );
/* If there is a word in *INPUT, parse it up to the next space
 * and update *INPUT. Return the word. It must be freed after use.
 * If there is no word, report an error. */

extern char_t *parse_absolute_path( string_t *input, string_t relative_to );
/* Parse the next file name in *INPUT and update *INPUT.
 * Make the file name absolute (relative to RELATIVE_TO).
 * If there is no file name, report an error. */

extern bool_t parse_yes_no( string_t *input );
/* Parse next word in INPUT. It must be "yes" or "no" (or "on" or "off" for
 * compatibility). Return TRUE iff next word is "yes" (or "on"). */

extern void parse_end( string_t *input );
/* Test if there are no more arguments in *INPUT. */

extern char_t *read_line( FILE *stream );
/* Read user input from STREAM until eof or newline is met.
 * Return the result string (without final EOL or EOF). 
 * The string must be freed after use.
 * If EOF is initially met, return NULL. */

extern void cut_comment( char_t *line );
/* Cut a "#"-comment in LINE if there is one. 
 * The char "#" is ignored if it occurs within a double-quoted string. */

extern void init_input( void );
/* Initialise this module. */

extern void terminate_input( void );
/* Terminate this module. */

/* End of file. =============================================================*/
