/*  Lziprecover - Data recovery tool for the lzip format
    Copyright (C) 2009-2017 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INT64_MAX
#define INT64_MAX  0x7FFFFFFFFFFFFFFFLL
#endif


class Block
  {
  long long pos_, size_;		// pos + size <= INT64_MAX

public:
  Block( const long long p, const long long s ) : pos_( p ), size_( s ) {}

  long long pos() const { return pos_; }
  long long size() const { return size_; }
  long long end() const { return pos_ + size_; }

  void pos( const long long p ) { pos_ = p; }
  void size( const long long s ) { size_ = s; }

  bool operator==( const Block & b ) const
    { return pos_ == b.pos_ && size_ == b.size_; }
  bool operator!=( const Block & b ) const
    { return pos_ != b.pos_ || size_ != b.size_; }

  bool operator<( const Block & b ) const { return pos_ < b.pos_; }

  bool includes( const long long pos ) const
    { return ( pos_ <= pos && end() > pos ); }
  bool overlaps( const Block & b ) const
    { return ( pos_ < b.end() && b.pos_ < end() ); }

  void shift( Block & b ) { ++size_; ++b.pos_; --b.size_; }
  Block split( const long long pos );
  };


// defined in range_dec.cc
int range_decompress( const std::string & input_filename,
                      const std::string & default_output_filename,
                      Block range, const int verbosity, const bool force,
                      const bool ignore_errors, const bool ignore_trailing,
                      const bool to_stdout );

// defined in repair.cc
int debug_delay( const std::string & input_filename, Block range,
                 const int verbosity );
