
			#include "util/iir.h"
                        #include "util/buffer.h"
		
#include <math.h>
#include <stdlib.h>
#include "lv2.h"
static LV2_Descriptor *bwxover_iirDescriptor = NULL;

typedef struct _Bwxover_iir {
  float *cutoff;
  float *resonance;
  float *input;
  float *lpoutput;
  float *hpoutput;
iirf_t* iirf;
iir_stage_t* gt;
long sample_rate;
} Bwxover_iir;

static void cleanupBwxover_iir(LV2_Handle instance)
{
Bwxover_iir *plugin_data = (Bwxover_iir *)instance;

                  free_iirf_t(plugin_data->iirf, plugin_data->gt);
                  free_iir_stage(plugin_data->gt);
                
  free(instance);
}

static void connectPortBwxover_iir(LV2_Handle instance, uint32_t port, void *data)
{
  Bwxover_iir *plugin = (Bwxover_iir *)instance;

  switch (port) {
  case 0:
    plugin->cutoff = data;
    break;
  case 1:
    plugin->resonance = data;
    break;
  case 2:
    plugin->input = data;
    break;
  case 3:
    plugin->lpoutput = data;
    break;
  case 4:
    plugin->hpoutput = data;
    break;
  }
}

static LV2_Handle instantiateBwxover_iir(const LV2_Descriptor *descriptor,
            double s_rate, const char *path,
            const LV2_Feature *const *features)
{
  Bwxover_iir *plugin_data = (Bwxover_iir *)malloc(sizeof(Bwxover_iir));
  iirf_t* iirf = plugin_data->iirf;
  iir_stage_t* gt = plugin_data->gt;
  long sample_rate = plugin_data->sample_rate;
  
                  sample_rate = s_rate;
                
  plugin_data->iirf = iirf;
  plugin_data->gt = gt;
  plugin_data->sample_rate = sample_rate;
  
  return (LV2_Handle)plugin_data;
}


static void activateBwxover_iir(LV2_Handle instance)
{
  Bwxover_iir *plugin_data = (Bwxover_iir *)instance;
  iirf_t* iirf __attribute__ ((unused)) = plugin_data->iirf;
  iir_stage_t* gt __attribute__ ((unused)) = plugin_data->gt;
  long sample_rate __attribute__ ((unused)) = plugin_data->sample_rate;
                    
                  gt = init_iir_stage(IIR_STAGE_LOWPASS,1,3,2);
                  iirf = init_iirf_t(gt);
                  butterworth_stage(gt, 0, *(plugin_data->cutoff), 
		  			   *(plugin_data->resonance), 
					   sample_rate);
                
}


static void runBwxover_iir(LV2_Handle instance, uint32_t sample_count)
{
  Bwxover_iir *plugin_data = (Bwxover_iir *)instance;

  const float cutoff = *(plugin_data->cutoff);
  const float resonance = *(plugin_data->resonance);
  const float * const input = plugin_data->input;
  float * const lpoutput = plugin_data->lpoutput;
  float * const hpoutput = plugin_data->hpoutput;
  iirf_t* iirf = plugin_data->iirf;
  iir_stage_t* gt = plugin_data->gt;
  long sample_rate = plugin_data->sample_rate;
  
                  butterworth_stage(gt, 0, cutoff, resonance, sample_rate);
                  iir_process_buffer_1s_5(iirf, gt, input, lpoutput, sample_count);
		  buffer_sub(input, lpoutput, hpoutput, sample_count);
                
}

static void init_bwxover_iir()
{
  bwxover_iirDescriptor = (LV2_Descriptor *)malloc(sizeof(LV2_Descriptor));

  bwxover_iirDescriptor->URI = "http://plugin.org.uk/swh-plugins/bwxover_iir";
  bwxover_iirDescriptor->activate = activateBwxover_iir;
  bwxover_iirDescriptor->cleanup = cleanupBwxover_iir;
  bwxover_iirDescriptor->connect_port = connectPortBwxover_iir;
  bwxover_iirDescriptor->deactivate = NULL;
  bwxover_iirDescriptor->instantiate = instantiateBwxover_iir;
  bwxover_iirDescriptor->run = runBwxover_iir;
}

#include <math.h>
#include <stdlib.h>
#include "lv2.h"
static LV2_Descriptor *buttlow_iirDescriptor = NULL;

typedef struct _Buttlow_iir {
  float *cutoff;
  float *resonance;
  float *input;
  float *output;
iirf_t* iirf;
iir_stage_t* gt;
long sample_rate;
} Buttlow_iir;

static void cleanupButtlow_iir(LV2_Handle instance)
{
Buttlow_iir *plugin_data = (Buttlow_iir *)instance;

                  free_iirf_t(plugin_data->iirf, plugin_data->gt);
                  free_iir_stage(plugin_data->gt);
                
  free(instance);
}

static void connectPortButtlow_iir(LV2_Handle instance, uint32_t port, void *data)
{
  Buttlow_iir *plugin = (Buttlow_iir *)instance;

  switch (port) {
  case 0:
    plugin->cutoff = data;
    break;
  case 1:
    plugin->resonance = data;
    break;
  case 2:
    plugin->input = data;
    break;
  case 3:
    plugin->output = data;
    break;
  }
}

static LV2_Handle instantiateButtlow_iir(const LV2_Descriptor *descriptor,
            double s_rate, const char *path,
            const LV2_Feature *const *features)
{
  Buttlow_iir *plugin_data = (Buttlow_iir *)malloc(sizeof(Buttlow_iir));
  iirf_t* iirf = plugin_data->iirf;
  iir_stage_t* gt = plugin_data->gt;
  long sample_rate = plugin_data->sample_rate;
  
                  sample_rate = s_rate;
                
  plugin_data->iirf = iirf;
  plugin_data->gt = gt;
  plugin_data->sample_rate = sample_rate;
  
  return (LV2_Handle)plugin_data;
}


static void activateButtlow_iir(LV2_Handle instance)
{
  Buttlow_iir *plugin_data = (Buttlow_iir *)instance;
  iirf_t* iirf __attribute__ ((unused)) = plugin_data->iirf;
  iir_stage_t* gt __attribute__ ((unused)) = plugin_data->gt;
  long sample_rate __attribute__ ((unused)) = plugin_data->sample_rate;
                    
                  gt = init_iir_stage(IIR_STAGE_LOWPASS,1,3,2);
                  iirf = init_iirf_t(gt);
                  butterworth_stage(gt, 0, *(plugin_data->cutoff), 
		  			   *(plugin_data->resonance), 
					   sample_rate);
                
}


static void runButtlow_iir(LV2_Handle instance, uint32_t sample_count)
{
  Buttlow_iir *plugin_data = (Buttlow_iir *)instance;

  const float cutoff = *(plugin_data->cutoff);
  const float resonance = *(plugin_data->resonance);
  const float * const input = plugin_data->input;
  float * const output = plugin_data->output;
  iirf_t* iirf = plugin_data->iirf;
  iir_stage_t* gt = plugin_data->gt;
  long sample_rate = plugin_data->sample_rate;
  
                  butterworth_stage(gt, 0, cutoff, resonance, sample_rate);
                  iir_process_buffer_1s_5(iirf, gt, input, output, sample_count);
                
}

static void init_buttlow_iir()
{
  buttlow_iirDescriptor = (LV2_Descriptor *)malloc(sizeof(LV2_Descriptor));

  buttlow_iirDescriptor->URI = "http://plugin.org.uk/swh-plugins/buttlow_iir";
  buttlow_iirDescriptor->activate = activateButtlow_iir;
  buttlow_iirDescriptor->cleanup = cleanupButtlow_iir;
  buttlow_iirDescriptor->connect_port = connectPortButtlow_iir;
  buttlow_iirDescriptor->deactivate = NULL;
  buttlow_iirDescriptor->instantiate = instantiateButtlow_iir;
  buttlow_iirDescriptor->run = runButtlow_iir;
}

#include <math.h>
#include <stdlib.h>
#include "lv2.h"
static LV2_Descriptor *butthigh_iirDescriptor = NULL;

typedef struct _Butthigh_iir {
  float *cutoff;
  float *resonance;
  float *input;
  float *output;
iirf_t* iirf;
iir_stage_t* gt;
long sample_rate;
} Butthigh_iir;

static void cleanupButthigh_iir(LV2_Handle instance)
{
Butthigh_iir *plugin_data = (Butthigh_iir *)instance;

                  free_iirf_t(plugin_data->iirf, plugin_data->gt);
                  free_iir_stage(plugin_data->gt);
                
  free(instance);
}

static void connectPortButthigh_iir(LV2_Handle instance, uint32_t port, void *data)
{
  Butthigh_iir *plugin = (Butthigh_iir *)instance;

  switch (port) {
  case 0:
    plugin->cutoff = data;
    break;
  case 1:
    plugin->resonance = data;
    break;
  case 2:
    plugin->input = data;
    break;
  case 3:
    plugin->output = data;
    break;
  }
}

static LV2_Handle instantiateButthigh_iir(const LV2_Descriptor *descriptor,
            double s_rate, const char *path,
            const LV2_Feature *const *features)
{
  Butthigh_iir *plugin_data = (Butthigh_iir *)malloc(sizeof(Butthigh_iir));
  iirf_t* iirf = plugin_data->iirf;
  iir_stage_t* gt = plugin_data->gt;
  long sample_rate = plugin_data->sample_rate;
  
                  sample_rate = s_rate;
                
  plugin_data->iirf = iirf;
  plugin_data->gt = gt;
  plugin_data->sample_rate = sample_rate;
  
  return (LV2_Handle)plugin_data;
}


static void activateButthigh_iir(LV2_Handle instance)
{
  Butthigh_iir *plugin_data = (Butthigh_iir *)instance;
  iirf_t* iirf __attribute__ ((unused)) = plugin_data->iirf;
  iir_stage_t* gt __attribute__ ((unused)) = plugin_data->gt;
  long sample_rate __attribute__ ((unused)) = plugin_data->sample_rate;
                    
                  gt = init_iir_stage(IIR_STAGE_LOWPASS,1,3,2);
                  iirf = init_iirf_t(gt);
                  butterworth_stage(gt, 1, *(plugin_data->cutoff), 
		  			   *(plugin_data->resonance), 
					   sample_rate);
                
}


static void runButthigh_iir(LV2_Handle instance, uint32_t sample_count)
{
  Butthigh_iir *plugin_data = (Butthigh_iir *)instance;

  const float cutoff = *(plugin_data->cutoff);
  const float resonance = *(plugin_data->resonance);
  const float * const input = plugin_data->input;
  float * const output = plugin_data->output;
  iirf_t* iirf = plugin_data->iirf;
  iir_stage_t* gt = plugin_data->gt;
  long sample_rate = plugin_data->sample_rate;
  
                  butterworth_stage(gt, 1, cutoff, resonance, sample_rate);
                  iir_process_buffer_1s_5(iirf, gt, input, output, sample_count);
                
}

static void init_butthigh_iir()
{
  butthigh_iirDescriptor = (LV2_Descriptor *)malloc(sizeof(LV2_Descriptor));

  butthigh_iirDescriptor->URI = "http://plugin.org.uk/swh-plugins/butthigh_iir";
  butthigh_iirDescriptor->activate = activateButthigh_iir;
  butthigh_iirDescriptor->cleanup = cleanupButthigh_iir;
  butthigh_iirDescriptor->connect_port = connectPortButthigh_iir;
  butthigh_iirDescriptor->deactivate = NULL;
  butthigh_iirDescriptor->instantiate = instantiateButthigh_iir;
  butthigh_iirDescriptor->run = runButthigh_iir;
}


LV2_SYMBOL_EXPORT
const LV2_Descriptor *lv2_descriptor(uint32_t index)
{
  if (!bwxover_iirDescriptor) init_bwxover_iir();
  if (!buttlow_iirDescriptor) init_buttlow_iir();
  if (!butthigh_iirDescriptor) init_butthigh_iir();

  switch (index) {
  case 0:
    return bwxover_iirDescriptor;
  case 1:
    return buttlow_iirDescriptor;
  case 2:
    return butthigh_iirDescriptor;
  default:
    return NULL;
  }
}
