; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes="default<O3>" -S -o - %s | FileCheck %s

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"
target triple = "aarch64"

; for(int i =0; i < 1024; i+=4) {
;   x[i] += y[i];
;   x[i+1] += y[i+1];
;   x[i+2] += y[i+2];
;   x[i+3] += y[i+3];
; }
define void @add4(ptr noalias noundef %x, ptr noalias noundef %y, i32 noundef %n) {
; CHECK-LABEL: @add4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[OFFSET_IDX:%.*]] = shl i64 [[INDEX]], 2
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds nuw i16, ptr [[Y:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC:%.*]] = load <32 x i16>, ptr [[TMP0]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds nuw i16, ptr [[X:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC24:%.*]] = load <32 x i16>, ptr [[TMP1]], align 2
; CHECK-NEXT:    [[INTERLEAVED_VEC:%.*]] = add <32 x i16> [[WIDE_VEC24]], [[WIDE_VEC]]
; CHECK-NEXT:    store <32 x i16> [[INTERLEAVED_VEC]], ptr [[TMP1]], align 2
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq i64 [[INDEX_NEXT]], 256
; CHECK-NEXT:    br i1 [[TMP3]], label [[FOR_END:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %x.addr = alloca ptr, align 8
  %y.addr = alloca ptr, align 8
  %n.addr = alloca i32, align 4
  %i = alloca i32, align 4
  store ptr %x, ptr %x.addr, align 8
  store ptr %y, ptr %y.addr, align 8
  store i32 %n, ptr %n.addr, align 4
  store i32 0, ptr %i, align 4
  br label %for.cond

for.cond:
  %0 = load i32, ptr %i, align 4
  %cmp = icmp slt i32 %0, 1024
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %1 = load ptr, ptr %y.addr, align 8
  %2 = load i32, ptr %i, align 4
  %idxprom = sext i32 %2 to i64
  %arrayidx = getelementptr inbounds i16, ptr %1, i64 %idxprom
  %3 = load i16, ptr %arrayidx, align 2
  %conv = sext i16 %3 to i32
  %4 = load ptr, ptr %x.addr, align 8
  %5 = load i32, ptr %i, align 4
  %idxprom1 = sext i32 %5 to i64
  %arrayidx2 = getelementptr inbounds i16, ptr %4, i64 %idxprom1
  %6 = load i16, ptr %arrayidx2, align 2
  %conv3 = sext i16 %6 to i32
  %add = add nsw i32 %conv3, %conv
  %conv4 = trunc i32 %add to i16
  store i16 %conv4, ptr %arrayidx2, align 2
  %7 = load ptr, ptr %y.addr, align 8
  %8 = load i32, ptr %i, align 4
  %add5 = add nsw i32 %8, 1
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds i16, ptr %7, i64 %idxprom6
  %9 = load i16, ptr %arrayidx7, align 2
  %conv8 = sext i16 %9 to i32
  %10 = load ptr, ptr %x.addr, align 8
  %11 = load i32, ptr %i, align 4
  %add9 = add nsw i32 %11, 1
  %idxprom10 = sext i32 %add9 to i64
  %arrayidx11 = getelementptr inbounds i16, ptr %10, i64 %idxprom10
  %12 = load i16, ptr %arrayidx11, align 2
  %conv12 = sext i16 %12 to i32
  %add13 = add nsw i32 %conv12, %conv8
  %conv14 = trunc i32 %add13 to i16
  store i16 %conv14, ptr %arrayidx11, align 2
  %13 = load ptr, ptr %y.addr, align 8
  %14 = load i32, ptr %i, align 4
  %add15 = add nsw i32 %14, 2
  %idxprom16 = sext i32 %add15 to i64
  %arrayidx17 = getelementptr inbounds i16, ptr %13, i64 %idxprom16
  %15 = load i16, ptr %arrayidx17, align 2
  %conv18 = sext i16 %15 to i32
  %16 = load ptr, ptr %x.addr, align 8
  %17 = load i32, ptr %i, align 4
  %add19 = add nsw i32 %17, 2
  %idxprom20 = sext i32 %add19 to i64
  %arrayidx21 = getelementptr inbounds i16, ptr %16, i64 %idxprom20
  %18 = load i16, ptr %arrayidx21, align 2
  %conv22 = sext i16 %18 to i32
  %add23 = add nsw i32 %conv22, %conv18
  %conv24 = trunc i32 %add23 to i16
  store i16 %conv24, ptr %arrayidx21, align 2
  %19 = load ptr, ptr %y.addr, align 8
  %20 = load i32, ptr %i, align 4
  %add25 = add nsw i32 %20, 3
  %idxprom26 = sext i32 %add25 to i64
  %arrayidx27 = getelementptr inbounds i16, ptr %19, i64 %idxprom26
  %21 = load i16, ptr %arrayidx27, align 2
  %conv28 = sext i16 %21 to i32
  %22 = load ptr, ptr %x.addr, align 8
  %23 = load i32, ptr %i, align 4
  %add29 = add nsw i32 %23, 3
  %idxprom30 = sext i32 %add29 to i64
  %arrayidx31 = getelementptr inbounds i16, ptr %22, i64 %idxprom30
  %24 = load i16, ptr %arrayidx31, align 2
  %conv32 = sext i16 %24 to i32
  %add33 = add nsw i32 %conv32, %conv28
  %conv34 = trunc i32 %add33 to i16
  store i16 %conv34, ptr %arrayidx31, align 2
  br label %for.inc

for.inc:
  %25 = load i32, ptr %i, align 4
  %add35 = add nsw i32 %25, 4
  store i32 %add35, ptr %i, align 4
  br label %for.cond

for.end:
  ret void
}

; for(int i =0; i < 1024; i+=4) {
;   x[i] += y[i];
;   x[i+1] -= y[i+1];
;   x[i+2] += y[i+2];
;   x[i+3] -= y[i+3];
; }
define void @addsubs(ptr noalias noundef %x, ptr noundef %y, i32 noundef %n) {
; CHECK-LABEL: @addsubs(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[OFFSET_IDX:%.*]] = shl i64 [[INDEX]], 2
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds nuw i16, ptr [[Y:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC:%.*]] = load <32 x i16>, ptr [[TMP0]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds nuw i16, ptr [[X:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC24:%.*]] = load <32 x i16>, ptr [[TMP1]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = add <32 x i16> [[WIDE_VEC24]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP3:%.*]] = sub <32 x i16> [[WIDE_VEC24]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP4:%.*]] = add <32 x i16> [[WIDE_VEC24]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP6:%.*]] = sub <32 x i16> [[WIDE_VEC24]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP7:%.*]] = shufflevector <32 x i16> [[TMP2]], <32 x i16> [[TMP3]], <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
; CHECK-NEXT:    [[TMP8:%.*]] = shufflevector <32 x i16> [[TMP4]], <32 x i16> [[TMP6]], <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
; CHECK-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <16 x i16> [[TMP7]], <16 x i16> [[TMP8]], <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; CHECK-NEXT:    store <32 x i16> [[INTERLEAVED_VEC]], ptr [[TMP1]], align 2
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; CHECK-NEXT:    [[TMP9:%.*]] = icmp eq i64 [[INDEX_NEXT]], 256
; CHECK-NEXT:    br i1 [[TMP9]], label [[FOR_END:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP3:![0-9]+]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %x.addr = alloca ptr, align 8
  %y.addr = alloca ptr, align 8
  %n.addr = alloca i32, align 4
  %i = alloca i32, align 4
  store ptr %x, ptr %x.addr, align 8
  store ptr %y, ptr %y.addr, align 8
  store i32 %n, ptr %n.addr, align 4
  store i32 0, ptr %i, align 4
  br label %for.cond

for.cond:
  %0 = load i32, ptr %i, align 4
  %cmp = icmp slt i32 %0, 1024
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %1 = load ptr, ptr %y.addr, align 8
  %2 = load i32, ptr %i, align 4
  %idxprom = sext i32 %2 to i64
  %arrayidx = getelementptr inbounds i16, ptr %1, i64 %idxprom
  %3 = load i16, ptr %arrayidx, align 2
  %conv = sext i16 %3 to i32
  %4 = load ptr, ptr %x.addr, align 8
  %5 = load i32, ptr %i, align 4
  %idxprom1 = sext i32 %5 to i64
  %arrayidx2 = getelementptr inbounds i16, ptr %4, i64 %idxprom1
  %6 = load i16, ptr %arrayidx2, align 2
  %conv3 = sext i16 %6 to i32
  %add = add nsw i32 %conv3, %conv
  %conv4 = trunc i32 %add to i16
  store i16 %conv4, ptr %arrayidx2, align 2
  %7 = load ptr, ptr %y.addr, align 8
  %8 = load i32, ptr %i, align 4
  %add5 = add nsw i32 %8, 1
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds i16, ptr %7, i64 %idxprom6
  %9 = load i16, ptr %arrayidx7, align 2
  %conv8 = sext i16 %9 to i32
  %10 = load ptr, ptr %x.addr, align 8
  %11 = load i32, ptr %i, align 4
  %add9 = add nsw i32 %11, 1
  %idxprom10 = sext i32 %add9 to i64
  %arrayidx11 = getelementptr inbounds i16, ptr %10, i64 %idxprom10
  %12 = load i16, ptr %arrayidx11, align 2
  %conv12 = sext i16 %12 to i32
  %sub = sub nsw i32 %conv12, %conv8
  %conv13 = trunc i32 %sub to i16
  store i16 %conv13, ptr %arrayidx11, align 2
  %13 = load ptr, ptr %y.addr, align 8
  %14 = load i32, ptr %i, align 4
  %add14 = add nsw i32 %14, 2
  %idxprom15 = sext i32 %add14 to i64
  %arrayidx16 = getelementptr inbounds i16, ptr %13, i64 %idxprom15
  %15 = load i16, ptr %arrayidx16, align 2
  %conv17 = sext i16 %15 to i32
  %16 = load ptr, ptr %x.addr, align 8
  %17 = load i32, ptr %i, align 4
  %add18 = add nsw i32 %17, 2
  %idxprom19 = sext i32 %add18 to i64
  %arrayidx20 = getelementptr inbounds i16, ptr %16, i64 %idxprom19
  %18 = load i16, ptr %arrayidx20, align 2
  %conv21 = sext i16 %18 to i32
  %add22 = add nsw i32 %conv21, %conv17
  %conv23 = trunc i32 %add22 to i16
  store i16 %conv23, ptr %arrayidx20, align 2
  %19 = load ptr, ptr %y.addr, align 8
  %20 = load i32, ptr %i, align 4
  %add24 = add nsw i32 %20, 3
  %idxprom25 = sext i32 %add24 to i64
  %arrayidx26 = getelementptr inbounds i16, ptr %19, i64 %idxprom25
  %21 = load i16, ptr %arrayidx26, align 2
  %conv27 = sext i16 %21 to i32
  %22 = load ptr, ptr %x.addr, align 8
  %23 = load i32, ptr %i, align 4
  %add28 = add nsw i32 %23, 3
  %idxprom29 = sext i32 %add28 to i64
  %arrayidx30 = getelementptr inbounds i16, ptr %22, i64 %idxprom29
  %24 = load i16, ptr %arrayidx30, align 2
  %conv31 = sext i16 %24 to i32
  %sub32 = sub nsw i32 %conv31, %conv27
  %conv33 = trunc i32 %sub32 to i16
  store i16 %conv33, ptr %arrayidx30, align 2
  br label %for.inc

for.inc:
  %25 = load i32, ptr %i, align 4
  %add34 = add nsw i32 %25, 4
  store i32 %add34, ptr %i, align 4
  br label %for.cond

for.end:
  ret void
}

; for(int i =0; i < 1024; i+=4) {
;   x[i] += y[i];
;   x[i+1] += y[i+1];
;   x[i+2] -= y[i+2];
;   x[i+3] -= y[i+3];
; }
define void @add2sub2(ptr noalias noundef %x, ptr noundef %y, i32 noundef %n) {
; CHECK-LABEL: @add2sub2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[OFFSET_IDX:%.*]] = shl i64 [[INDEX]], 2
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds nuw i16, ptr [[Y:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC:%.*]] = load <32 x i16>, ptr [[TMP0]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds nuw i16, ptr [[X:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC24:%.*]] = load <32 x i16>, ptr [[TMP1]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = add <32 x i16> [[WIDE_VEC24]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP3:%.*]] = add <32 x i16> [[WIDE_VEC24]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP4:%.*]] = sub <32 x i16> [[WIDE_VEC24]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP6:%.*]] = sub <32 x i16> [[WIDE_VEC24]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP7:%.*]] = shufflevector <32 x i16> [[TMP2]], <32 x i16> [[TMP3]], <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
; CHECK-NEXT:    [[TMP8:%.*]] = shufflevector <32 x i16> [[TMP4]], <32 x i16> [[TMP6]], <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
; CHECK-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <16 x i16> [[TMP7]], <16 x i16> [[TMP8]], <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; CHECK-NEXT:    store <32 x i16> [[INTERLEAVED_VEC]], ptr [[TMP1]], align 2
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; CHECK-NEXT:    [[TMP9:%.*]] = icmp eq i64 [[INDEX_NEXT]], 256
; CHECK-NEXT:    br i1 [[TMP9]], label [[FOR_END:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %x.addr = alloca ptr, align 8
  %y.addr = alloca ptr, align 8
  %n.addr = alloca i32, align 4
  %i = alloca i32, align 4
  store ptr %x, ptr %x.addr, align 8
  store ptr %y, ptr %y.addr, align 8
  store i32 %n, ptr %n.addr, align 4
  store i32 0, ptr %i, align 4
  br label %for.cond

for.cond:
  %0 = load i32, ptr %i, align 4
  %cmp = icmp slt i32 %0, 1024
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %1 = load ptr, ptr %y.addr, align 8
  %2 = load i32, ptr %i, align 4
  %idxprom = sext i32 %2 to i64
  %arrayidx = getelementptr inbounds i16, ptr %1, i64 %idxprom
  %3 = load i16, ptr %arrayidx, align 2
  %conv = sext i16 %3 to i32
  %4 = load ptr, ptr %x.addr, align 8
  %5 = load i32, ptr %i, align 4
  %idxprom1 = sext i32 %5 to i64
  %arrayidx2 = getelementptr inbounds i16, ptr %4, i64 %idxprom1
  %6 = load i16, ptr %arrayidx2, align 2
  %conv3 = sext i16 %6 to i32
  %add = add nsw i32 %conv3, %conv
  %conv4 = trunc i32 %add to i16
  store i16 %conv4, ptr %arrayidx2, align 2
  %7 = load ptr, ptr %y.addr, align 8
  %8 = load i32, ptr %i, align 4
  %add5 = add nsw i32 %8, 1
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds i16, ptr %7, i64 %idxprom6
  %9 = load i16, ptr %arrayidx7, align 2
  %conv8 = sext i16 %9 to i32
  %10 = load ptr, ptr %x.addr, align 8
  %11 = load i32, ptr %i, align 4
  %add9 = add nsw i32 %11, 1
  %idxprom10 = sext i32 %add9 to i64
  %arrayidx11 = getelementptr inbounds i16, ptr %10, i64 %idxprom10
  %12 = load i16, ptr %arrayidx11, align 2
  %conv12 = sext i16 %12 to i32
  %add13 = add nsw i32 %conv12, %conv8
  %conv14 = trunc i32 %add13 to i16
  store i16 %conv14, ptr %arrayidx11, align 2
  %13 = load ptr, ptr %y.addr, align 8
  %14 = load i32, ptr %i, align 4
  %add15 = add nsw i32 %14, 2
  %idxprom16 = sext i32 %add15 to i64
  %arrayidx17 = getelementptr inbounds i16, ptr %13, i64 %idxprom16
  %15 = load i16, ptr %arrayidx17, align 2
  %conv18 = sext i16 %15 to i32
  %16 = load ptr, ptr %x.addr, align 8
  %17 = load i32, ptr %i, align 4
  %add19 = add nsw i32 %17, 2
  %idxprom20 = sext i32 %add19 to i64
  %arrayidx21 = getelementptr inbounds i16, ptr %16, i64 %idxprom20
  %18 = load i16, ptr %arrayidx21, align 2
  %conv22 = sext i16 %18 to i32
  %sub = sub nsw i32 %conv22, %conv18
  %conv23 = trunc i32 %sub to i16
  store i16 %conv23, ptr %arrayidx21, align 2
  %19 = load ptr, ptr %y.addr, align 8
  %20 = load i32, ptr %i, align 4
  %add24 = add nsw i32 %20, 3
  %idxprom25 = sext i32 %add24 to i64
  %arrayidx26 = getelementptr inbounds i16, ptr %19, i64 %idxprom25
  %21 = load i16, ptr %arrayidx26, align 2
  %conv27 = sext i16 %21 to i32
  %22 = load ptr, ptr %x.addr, align 8
  %23 = load i32, ptr %i, align 4
  %add28 = add nsw i32 %23, 3
  %idxprom29 = sext i32 %add28 to i64
  %arrayidx30 = getelementptr inbounds i16, ptr %22, i64 %idxprom29
  %24 = load i16, ptr %arrayidx30, align 2
  %conv31 = sext i16 %24 to i32
  %sub32 = sub nsw i32 %conv31, %conv27
  %conv33 = trunc i32 %sub32 to i16
  store i16 %conv33, ptr %arrayidx30, align 2
  br label %for.inc

for.inc:
  %25 = load i32, ptr %i, align 4
  %add34 = add nsw i32 %25, 4
  store i32 %add34, ptr %i, align 4
  br label %for.cond

for.end:
  ret void
}

; for(int i =0; i < 1024; i+=4) {
;   x[i] += y[i] * z[i];
;   x[i+1] += y[i+1] * z[i+1];
;   x[i+2] += y[i+2] * z[i+2];
;   x[i+3] += y[i+3] * z[i+3];
; }
define void @addmul(ptr noalias noundef %x, ptr noundef %y, ptr noundef %z, i32 noundef %n) {
; CHECK-LABEL: @addmul(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[OFFSET_IDX:%.*]] = shl i64 [[INDEX]], 2
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds nuw i16, ptr [[Y:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC:%.*]] = load <32 x i16>, ptr [[TMP0]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds nuw i16, ptr [[Z:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC31:%.*]] = load <32 x i16>, ptr [[TMP1]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds nuw i16, ptr [[X:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC36:%.*]] = load <32 x i16>, ptr [[TMP2]], align 2
; CHECK-NEXT:    [[TMP4:%.*]] = mul <32 x i16> [[WIDE_VEC31]], [[WIDE_VEC]]
; CHECK-NEXT:    [[INTERLEAVED_VEC:%.*]] = add <32 x i16> [[TMP4]], [[WIDE_VEC36]]
; CHECK-NEXT:    store <32 x i16> [[INTERLEAVED_VEC]], ptr [[TMP2]], align 2
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i64 [[INDEX_NEXT]], 256
; CHECK-NEXT:    br i1 [[TMP5]], label [[FOR_END:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP5:![0-9]+]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %x.addr = alloca ptr, align 8
  %y.addr = alloca ptr, align 8
  %z.addr = alloca ptr, align 8
  %n.addr = alloca i32, align 4
  %i = alloca i32, align 4
  store ptr %x, ptr %x.addr, align 8
  store ptr %y, ptr %y.addr, align 8
  store ptr %z, ptr %z.addr, align 8
  store i32 %n, ptr %n.addr, align 4
  store i32 0, ptr %i, align 4
  br label %for.cond

for.cond:
  %0 = load i32, ptr %i, align 4
  %cmp = icmp slt i32 %0, 1024
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %1 = load ptr, ptr %y.addr, align 8
  %2 = load i32, ptr %i, align 4
  %idxprom = sext i32 %2 to i64
  %arrayidx = getelementptr inbounds i16, ptr %1, i64 %idxprom
  %3 = load i16, ptr %arrayidx, align 2
  %conv = sext i16 %3 to i32
  %4 = load ptr, ptr %z.addr, align 8
  %5 = load i32, ptr %i, align 4
  %idxprom1 = sext i32 %5 to i64
  %arrayidx2 = getelementptr inbounds i16, ptr %4, i64 %idxprom1
  %6 = load i16, ptr %arrayidx2, align 2
  %conv3 = sext i16 %6 to i32
  %mul = mul nsw i32 %conv, %conv3
  %7 = load ptr, ptr %x.addr, align 8
  %8 = load i32, ptr %i, align 4
  %idxprom4 = sext i32 %8 to i64
  %arrayidx5 = getelementptr inbounds i16, ptr %7, i64 %idxprom4
  %9 = load i16, ptr %arrayidx5, align 2
  %conv6 = sext i16 %9 to i32
  %add = add nsw i32 %conv6, %mul
  %conv7 = trunc i32 %add to i16
  store i16 %conv7, ptr %arrayidx5, align 2
  %10 = load ptr, ptr %y.addr, align 8
  %11 = load i32, ptr %i, align 4
  %add8 = add nsw i32 %11, 1
  %idxprom9 = sext i32 %add8 to i64
  %arrayidx10 = getelementptr inbounds i16, ptr %10, i64 %idxprom9
  %12 = load i16, ptr %arrayidx10, align 2
  %conv11 = sext i16 %12 to i32
  %13 = load ptr, ptr %z.addr, align 8
  %14 = load i32, ptr %i, align 4
  %add12 = add nsw i32 %14, 1
  %idxprom13 = sext i32 %add12 to i64
  %arrayidx14 = getelementptr inbounds i16, ptr %13, i64 %idxprom13
  %15 = load i16, ptr %arrayidx14, align 2
  %conv15 = sext i16 %15 to i32
  %mul16 = mul nsw i32 %conv11, %conv15
  %16 = load ptr, ptr %x.addr, align 8
  %17 = load i32, ptr %i, align 4
  %add17 = add nsw i32 %17, 1
  %idxprom18 = sext i32 %add17 to i64
  %arrayidx19 = getelementptr inbounds i16, ptr %16, i64 %idxprom18
  %18 = load i16, ptr %arrayidx19, align 2
  %conv20 = sext i16 %18 to i32
  %add21 = add nsw i32 %conv20, %mul16
  %conv22 = trunc i32 %add21 to i16
  store i16 %conv22, ptr %arrayidx19, align 2
  %19 = load ptr, ptr %y.addr, align 8
  %20 = load i32, ptr %i, align 4
  %add23 = add nsw i32 %20, 2
  %idxprom24 = sext i32 %add23 to i64
  %arrayidx25 = getelementptr inbounds i16, ptr %19, i64 %idxprom24
  %21 = load i16, ptr %arrayidx25, align 2
  %conv26 = sext i16 %21 to i32
  %22 = load ptr, ptr %z.addr, align 8
  %23 = load i32, ptr %i, align 4
  %add27 = add nsw i32 %23, 2
  %idxprom28 = sext i32 %add27 to i64
  %arrayidx29 = getelementptr inbounds i16, ptr %22, i64 %idxprom28
  %24 = load i16, ptr %arrayidx29, align 2
  %conv30 = sext i16 %24 to i32
  %mul31 = mul nsw i32 %conv26, %conv30
  %25 = load ptr, ptr %x.addr, align 8
  %26 = load i32, ptr %i, align 4
  %add32 = add nsw i32 %26, 2
  %idxprom33 = sext i32 %add32 to i64
  %arrayidx34 = getelementptr inbounds i16, ptr %25, i64 %idxprom33
  %27 = load i16, ptr %arrayidx34, align 2
  %conv35 = sext i16 %27 to i32
  %add36 = add nsw i32 %conv35, %mul31
  %conv37 = trunc i32 %add36 to i16
  store i16 %conv37, ptr %arrayidx34, align 2
  %28 = load ptr, ptr %y.addr, align 8
  %29 = load i32, ptr %i, align 4
  %add38 = add nsw i32 %29, 3
  %idxprom39 = sext i32 %add38 to i64
  %arrayidx40 = getelementptr inbounds i16, ptr %28, i64 %idxprom39
  %30 = load i16, ptr %arrayidx40, align 2
  %conv41 = sext i16 %30 to i32
  %31 = load ptr, ptr %z.addr, align 8
  %32 = load i32, ptr %i, align 4
  %add42 = add nsw i32 %32, 3
  %idxprom43 = sext i32 %add42 to i64
  %arrayidx44 = getelementptr inbounds i16, ptr %31, i64 %idxprom43
  %33 = load i16, ptr %arrayidx44, align 2
  %conv45 = sext i16 %33 to i32
  %mul46 = mul nsw i32 %conv41, %conv45
  %34 = load ptr, ptr %x.addr, align 8
  %35 = load i32, ptr %i, align 4
  %add47 = add nsw i32 %35, 3
  %idxprom48 = sext i32 %add47 to i64
  %arrayidx49 = getelementptr inbounds i16, ptr %34, i64 %idxprom48
  %36 = load i16, ptr %arrayidx49, align 2
  %conv50 = sext i16 %36 to i32
  %add51 = add nsw i32 %conv50, %mul46
  %conv52 = trunc i32 %add51 to i16
  store i16 %conv52, ptr %arrayidx49, align 2
  br label %for.inc

for.inc:
  %37 = load i32, ptr %i, align 4
  %add53 = add nsw i32 %37, 4
  store i32 %add53, ptr %i, align 4
  br label %for.cond

for.end:
  ret void
}

; for(int i =0; i < 1024; i+=4) {
;   x[i] += y[i] * z[i];
;   x[i+1] -= y[i+1] * z[i+1];
;   x[i+2] += y[i+2] * z[i+2];
;   x[i+3] -= y[i+3] * z[i+3];
; }
define void @addsubsmul(ptr noalias noundef %x, ptr noundef %y, ptr noundef %z, i32 noundef %n) {
; CHECK-LABEL: @addsubsmul(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[OFFSET_IDX:%.*]] = shl i64 [[INDEX]], 2
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds nuw i16, ptr [[Y:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC:%.*]] = load <32 x i16>, ptr [[TMP0]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds nuw i16, ptr [[Z:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC31:%.*]] = load <32 x i16>, ptr [[TMP1]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = mul <32 x i16> [[WIDE_VEC31]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds nuw i16, ptr [[X:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC36:%.*]] = load <32 x i16>, ptr [[TMP3]], align 2
; CHECK-NEXT:    [[TMP4:%.*]] = add <32 x i16> [[TMP2]], [[WIDE_VEC36]]
; CHECK-NEXT:    [[TMP5:%.*]] = mul <32 x i16> [[WIDE_VEC31]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP6:%.*]] = sub <32 x i16> [[WIDE_VEC36]], [[TMP5]]
; CHECK-NEXT:    [[TMP7:%.*]] = mul <32 x i16> [[WIDE_VEC31]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP8:%.*]] = add <32 x i16> [[TMP7]], [[WIDE_VEC36]]
; CHECK-NEXT:    [[TMP10:%.*]] = mul <32 x i16> [[WIDE_VEC31]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP11:%.*]] = sub <32 x i16> [[WIDE_VEC36]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = shufflevector <32 x i16> [[TMP4]], <32 x i16> [[TMP6]], <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
; CHECK-NEXT:    [[TMP13:%.*]] = shufflevector <32 x i16> [[TMP8]], <32 x i16> [[TMP11]], <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
; CHECK-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <16 x i16> [[TMP12]], <16 x i16> [[TMP13]], <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; CHECK-NEXT:    store <32 x i16> [[INTERLEAVED_VEC]], ptr [[TMP3]], align 2
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[INDEX_NEXT]], 256
; CHECK-NEXT:    br i1 [[TMP14]], label [[FOR_END:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %x.addr = alloca ptr, align 8
  %y.addr = alloca ptr, align 8
  %z.addr = alloca ptr, align 8
  %n.addr = alloca i32, align 4
  %i = alloca i32, align 4
  store ptr %x, ptr %x.addr, align 8
  store ptr %y, ptr %y.addr, align 8
  store ptr %z, ptr %z.addr, align 8
  store i32 %n, ptr %n.addr, align 4
  store i32 0, ptr %i, align 4
  br label %for.cond

for.cond:
  %0 = load i32, ptr %i, align 4
  %cmp = icmp slt i32 %0, 1024
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %1 = load ptr, ptr %y.addr, align 8
  %2 = load i32, ptr %i, align 4
  %idxprom = sext i32 %2 to i64
  %arrayidx = getelementptr inbounds i16, ptr %1, i64 %idxprom
  %3 = load i16, ptr %arrayidx, align 2
  %conv = sext i16 %3 to i32
  %4 = load ptr, ptr %z.addr, align 8
  %5 = load i32, ptr %i, align 4
  %idxprom1 = sext i32 %5 to i64
  %arrayidx2 = getelementptr inbounds i16, ptr %4, i64 %idxprom1
  %6 = load i16, ptr %arrayidx2, align 2
  %conv3 = sext i16 %6 to i32
  %mul = mul nsw i32 %conv, %conv3
  %7 = load ptr, ptr %x.addr, align 8
  %8 = load i32, ptr %i, align 4
  %idxprom4 = sext i32 %8 to i64
  %arrayidx5 = getelementptr inbounds i16, ptr %7, i64 %idxprom4
  %9 = load i16, ptr %arrayidx5, align 2
  %conv6 = sext i16 %9 to i32
  %add = add nsw i32 %conv6, %mul
  %conv7 = trunc i32 %add to i16
  store i16 %conv7, ptr %arrayidx5, align 2
  %10 = load ptr, ptr %y.addr, align 8
  %11 = load i32, ptr %i, align 4
  %add8 = add nsw i32 %11, 1
  %idxprom9 = sext i32 %add8 to i64
  %arrayidx10 = getelementptr inbounds i16, ptr %10, i64 %idxprom9
  %12 = load i16, ptr %arrayidx10, align 2
  %conv11 = sext i16 %12 to i32
  %13 = load ptr, ptr %z.addr, align 8
  %14 = load i32, ptr %i, align 4
  %add12 = add nsw i32 %14, 1
  %idxprom13 = sext i32 %add12 to i64
  %arrayidx14 = getelementptr inbounds i16, ptr %13, i64 %idxprom13
  %15 = load i16, ptr %arrayidx14, align 2
  %conv15 = sext i16 %15 to i32
  %mul16 = mul nsw i32 %conv11, %conv15
  %16 = load ptr, ptr %x.addr, align 8
  %17 = load i32, ptr %i, align 4
  %add17 = add nsw i32 %17, 1
  %idxprom18 = sext i32 %add17 to i64
  %arrayidx19 = getelementptr inbounds i16, ptr %16, i64 %idxprom18
  %18 = load i16, ptr %arrayidx19, align 2
  %conv20 = sext i16 %18 to i32
  %sub = sub nsw i32 %conv20, %mul16
  %conv21 = trunc i32 %sub to i16
  store i16 %conv21, ptr %arrayidx19, align 2
  %19 = load ptr, ptr %y.addr, align 8
  %20 = load i32, ptr %i, align 4
  %add22 = add nsw i32 %20, 2
  %idxprom23 = sext i32 %add22 to i64
  %arrayidx24 = getelementptr inbounds i16, ptr %19, i64 %idxprom23
  %21 = load i16, ptr %arrayidx24, align 2
  %conv25 = sext i16 %21 to i32
  %22 = load ptr, ptr %z.addr, align 8
  %23 = load i32, ptr %i, align 4
  %add26 = add nsw i32 %23, 2
  %idxprom27 = sext i32 %add26 to i64
  %arrayidx28 = getelementptr inbounds i16, ptr %22, i64 %idxprom27
  %24 = load i16, ptr %arrayidx28, align 2
  %conv29 = sext i16 %24 to i32
  %mul30 = mul nsw i32 %conv25, %conv29
  %25 = load ptr, ptr %x.addr, align 8
  %26 = load i32, ptr %i, align 4
  %add31 = add nsw i32 %26, 2
  %idxprom32 = sext i32 %add31 to i64
  %arrayidx33 = getelementptr inbounds i16, ptr %25, i64 %idxprom32
  %27 = load i16, ptr %arrayidx33, align 2
  %conv34 = sext i16 %27 to i32
  %add35 = add nsw i32 %conv34, %mul30
  %conv36 = trunc i32 %add35 to i16
  store i16 %conv36, ptr %arrayidx33, align 2
  %28 = load ptr, ptr %y.addr, align 8
  %29 = load i32, ptr %i, align 4
  %add37 = add nsw i32 %29, 3
  %idxprom38 = sext i32 %add37 to i64
  %arrayidx39 = getelementptr inbounds i16, ptr %28, i64 %idxprom38
  %30 = load i16, ptr %arrayidx39, align 2
  %conv40 = sext i16 %30 to i32
  %31 = load ptr, ptr %z.addr, align 8
  %32 = load i32, ptr %i, align 4
  %add41 = add nsw i32 %32, 3
  %idxprom42 = sext i32 %add41 to i64
  %arrayidx43 = getelementptr inbounds i16, ptr %31, i64 %idxprom42
  %33 = load i16, ptr %arrayidx43, align 2
  %conv44 = sext i16 %33 to i32
  %mul45 = mul nsw i32 %conv40, %conv44
  %34 = load ptr, ptr %x.addr, align 8
  %35 = load i32, ptr %i, align 4
  %add46 = add nsw i32 %35, 3
  %idxprom47 = sext i32 %add46 to i64
  %arrayidx48 = getelementptr inbounds i16, ptr %34, i64 %idxprom47
  %36 = load i16, ptr %arrayidx48, align 2
  %conv49 = sext i16 %36 to i32
  %sub50 = sub nsw i32 %conv49, %mul45
  %conv51 = trunc i32 %sub50 to i16
  store i16 %conv51, ptr %arrayidx48, align 2
  br label %for.inc

for.inc:
  %37 = load i32, ptr %i, align 4
  %add52 = add nsw i32 %37, 4
  store i32 %add52, ptr %i, align 4
  br label %for.cond

for.end:
  ret void
}

; for(int i =0; i < 1024; i+=4) {
;   x[i] += y[i] * z[i];
;   x[i+1] += y[i+1] * z[i+1];
;   x[i+2] -= y[i+2] * z[i+2];
;   x[i+3] -= y[i+3] * z[i+3];
; }
define void @add2sub2mul(ptr noalias noundef %x, ptr noundef %y, ptr noundef %z, i32 noundef %n) {
; CHECK-LABEL: @add2sub2mul(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[OFFSET_IDX:%.*]] = shl i64 [[INDEX]], 2
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds nuw i16, ptr [[Y:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC:%.*]] = load <32 x i16>, ptr [[TMP0]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds nuw i16, ptr [[Z:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC31:%.*]] = load <32 x i16>, ptr [[TMP1]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = mul <32 x i16> [[WIDE_VEC31]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds nuw i16, ptr [[X:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[WIDE_VEC36:%.*]] = load <32 x i16>, ptr [[TMP3]], align 2
; CHECK-NEXT:    [[TMP4:%.*]] = add <32 x i16> [[TMP2]], [[WIDE_VEC36]]
; CHECK-NEXT:    [[TMP5:%.*]] = mul <32 x i16> [[WIDE_VEC31]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP6:%.*]] = add <32 x i16> [[TMP5]], [[WIDE_VEC36]]
; CHECK-NEXT:    [[TMP7:%.*]] = mul <32 x i16> [[WIDE_VEC31]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP8:%.*]] = sub <32 x i16> [[WIDE_VEC36]], [[TMP7]]
; CHECK-NEXT:    [[TMP10:%.*]] = mul <32 x i16> [[WIDE_VEC31]], [[WIDE_VEC]]
; CHECK-NEXT:    [[TMP11:%.*]] = sub <32 x i16> [[WIDE_VEC36]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = shufflevector <32 x i16> [[TMP4]], <32 x i16> [[TMP6]], <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
; CHECK-NEXT:    [[TMP13:%.*]] = shufflevector <32 x i16> [[TMP8]], <32 x i16> [[TMP11]], <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
; CHECK-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <16 x i16> [[TMP12]], <16 x i16> [[TMP13]], <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; CHECK-NEXT:    store <32 x i16> [[INTERLEAVED_VEC]], ptr [[TMP3]], align 2
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[INDEX_NEXT]], 256
; CHECK-NEXT:    br i1 [[TMP14]], label [[FOR_END:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP7:![0-9]+]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %x.addr = alloca ptr, align 8
  %y.addr = alloca ptr, align 8
  %z.addr = alloca ptr, align 8
  %n.addr = alloca i32, align 4
  %i = alloca i32, align 4
  store ptr %x, ptr %x.addr, align 8
  store ptr %y, ptr %y.addr, align 8
  store ptr %z, ptr %z.addr, align 8
  store i32 %n, ptr %n.addr, align 4
  store i32 0, ptr %i, align 4
  br label %for.cond

for.cond:
  %0 = load i32, ptr %i, align 4
  %cmp = icmp slt i32 %0, 1024
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %1 = load ptr, ptr %y.addr, align 8
  %2 = load i32, ptr %i, align 4
  %idxprom = sext i32 %2 to i64
  %arrayidx = getelementptr inbounds i16, ptr %1, i64 %idxprom
  %3 = load i16, ptr %arrayidx, align 2
  %conv = sext i16 %3 to i32
  %4 = load ptr, ptr %z.addr, align 8
  %5 = load i32, ptr %i, align 4
  %idxprom1 = sext i32 %5 to i64
  %arrayidx2 = getelementptr inbounds i16, ptr %4, i64 %idxprom1
  %6 = load i16, ptr %arrayidx2, align 2
  %conv3 = sext i16 %6 to i32
  %mul = mul nsw i32 %conv, %conv3
  %7 = load ptr, ptr %x.addr, align 8
  %8 = load i32, ptr %i, align 4
  %idxprom4 = sext i32 %8 to i64
  %arrayidx5 = getelementptr inbounds i16, ptr %7, i64 %idxprom4
  %9 = load i16, ptr %arrayidx5, align 2
  %conv6 = sext i16 %9 to i32
  %add = add nsw i32 %conv6, %mul
  %conv7 = trunc i32 %add to i16
  store i16 %conv7, ptr %arrayidx5, align 2
  %10 = load ptr, ptr %y.addr, align 8
  %11 = load i32, ptr %i, align 4
  %add8 = add nsw i32 %11, 1
  %idxprom9 = sext i32 %add8 to i64
  %arrayidx10 = getelementptr inbounds i16, ptr %10, i64 %idxprom9
  %12 = load i16, ptr %arrayidx10, align 2
  %conv11 = sext i16 %12 to i32
  %13 = load ptr, ptr %z.addr, align 8
  %14 = load i32, ptr %i, align 4
  %add12 = add nsw i32 %14, 1
  %idxprom13 = sext i32 %add12 to i64
  %arrayidx14 = getelementptr inbounds i16, ptr %13, i64 %idxprom13
  %15 = load i16, ptr %arrayidx14, align 2
  %conv15 = sext i16 %15 to i32
  %mul16 = mul nsw i32 %conv11, %conv15
  %16 = load ptr, ptr %x.addr, align 8
  %17 = load i32, ptr %i, align 4
  %add17 = add nsw i32 %17, 1
  %idxprom18 = sext i32 %add17 to i64
  %arrayidx19 = getelementptr inbounds i16, ptr %16, i64 %idxprom18
  %18 = load i16, ptr %arrayidx19, align 2
  %conv20 = sext i16 %18 to i32
  %add21 = add nsw i32 %conv20, %mul16
  %conv22 = trunc i32 %add21 to i16
  store i16 %conv22, ptr %arrayidx19, align 2
  %19 = load ptr, ptr %y.addr, align 8
  %20 = load i32, ptr %i, align 4
  %add23 = add nsw i32 %20, 2
  %idxprom24 = sext i32 %add23 to i64
  %arrayidx25 = getelementptr inbounds i16, ptr %19, i64 %idxprom24
  %21 = load i16, ptr %arrayidx25, align 2
  %conv26 = sext i16 %21 to i32
  %22 = load ptr, ptr %z.addr, align 8
  %23 = load i32, ptr %i, align 4
  %add27 = add nsw i32 %23, 2
  %idxprom28 = sext i32 %add27 to i64
  %arrayidx29 = getelementptr inbounds i16, ptr %22, i64 %idxprom28
  %24 = load i16, ptr %arrayidx29, align 2
  %conv30 = sext i16 %24 to i32
  %mul31 = mul nsw i32 %conv26, %conv30
  %25 = load ptr, ptr %x.addr, align 8
  %26 = load i32, ptr %i, align 4
  %add32 = add nsw i32 %26, 2
  %idxprom33 = sext i32 %add32 to i64
  %arrayidx34 = getelementptr inbounds i16, ptr %25, i64 %idxprom33
  %27 = load i16, ptr %arrayidx34, align 2
  %conv35 = sext i16 %27 to i32
  %sub = sub nsw i32 %conv35, %mul31
  %conv36 = trunc i32 %sub to i16
  store i16 %conv36, ptr %arrayidx34, align 2
  %28 = load ptr, ptr %y.addr, align 8
  %29 = load i32, ptr %i, align 4
  %add37 = add nsw i32 %29, 3
  %idxprom38 = sext i32 %add37 to i64
  %arrayidx39 = getelementptr inbounds i16, ptr %28, i64 %idxprom38
  %30 = load i16, ptr %arrayidx39, align 2
  %conv40 = sext i16 %30 to i32
  %31 = load ptr, ptr %z.addr, align 8
  %32 = load i32, ptr %i, align 4
  %add41 = add nsw i32 %32, 3
  %idxprom42 = sext i32 %add41 to i64
  %arrayidx43 = getelementptr inbounds i16, ptr %31, i64 %idxprom42
  %33 = load i16, ptr %arrayidx43, align 2
  %conv44 = sext i16 %33 to i32
  %mul45 = mul nsw i32 %conv40, %conv44
  %34 = load ptr, ptr %x.addr, align 8
  %35 = load i32, ptr %i, align 4
  %add46 = add nsw i32 %35, 3
  %idxprom47 = sext i32 %add46 to i64
  %arrayidx48 = getelementptr inbounds i16, ptr %34, i64 %idxprom47
  %36 = load i16, ptr %arrayidx48, align 2
  %conv49 = sext i16 %36 to i32
  %sub50 = sub nsw i32 %conv49, %mul45
  %conv51 = trunc i32 %sub50 to i16
  store i16 %conv51, ptr %arrayidx48, align 2
  br label %for.inc

for.inc:
  %37 = load i32, ptr %i, align 4
  %add52 = add nsw i32 %37, 4
  store i32 %add52, ptr %i, align 4
  br label %for.cond

for.end:
  ret void
}
