; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -global-isel=0 -amdgpu-load-store-vectorizer=0 -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-SDAG %s
; RUN: llc -global-isel=0 -amdgpu-load-store-vectorizer=0 -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-SDAG %s
; RUN: llc -global-isel=0 -amdgpu-load-store-vectorizer=0 -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12-SDAG %s

define void @v_permlane16_p0(ptr addrspace(1) %out, ptr %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_p0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v4
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlane16_p0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v4
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v5
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlane16_p0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v4
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v5
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call ptr @llvm.amdgcn.permlane16.p0(ptr %src0, ptr %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store ptr %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlanex16_p0(ptr addrspace(1) %out, ptr %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_p0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v4
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlanex16_p0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v4
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v5
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlanex16_p0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v4
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v5
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call ptr @llvm.amdgcn.permlanex16.p0(ptr %src0, ptr %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store ptr %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlane16_v3p0(ptr addrspace(1) %out, <3 x ptr> %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_v3p0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v8
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v9
; GFX10-SDAG-NEXT:    v_permlane16_b32 v7, v7, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v6, v6, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v5, v5, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v4, v4, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx2 v[0:1], v[6:7], off offset:16
; GFX10-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[2:5], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlane16_v3p0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v8
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v9
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v7, v7, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v6, v6, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v5, v5, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v4, v4, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    global_store_b64 v[0:1], v[6:7], off offset:16
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlane16_v3p0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v8
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v9
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_b32 v7, v7, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v6, v6, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v5, v5, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v4, v4, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    global_store_b64 v[0:1], v[6:7], off offset:16
; GFX12-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call <3 x ptr> @llvm.amdgcn.permlane16.v3p0(<3 x ptr> %src0, <3 x ptr> %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store <3 x ptr> %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlanex16_v3p0(ptr addrspace(1) %out, <3 x ptr> %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_v3p0:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v8
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v9
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v7, v7, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v6, v6, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v5, v5, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx2 v[0:1], v[6:7], off offset:16
; GFX10-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[2:5], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlanex16_v3p0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v8
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v9
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v7, v7, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v6, v6, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v5, v5, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    global_store_b64 v[0:1], v[6:7], off offset:16
; GFX11-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlanex16_v3p0:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v8
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v9
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v7, v7, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v6, v6, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v5, v5, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    global_store_b64 v[0:1], v[6:7], off offset:16
; GFX12-SDAG-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call <3 x ptr> @llvm.amdgcn.permlanex16.v3p0(<3 x ptr> %src0, <3 x ptr> %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store <3 x ptr> %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlane16_p3(ptr addrspace(1) %out, ptr addrspace(3) %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_p3:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v4
; GFX10-SDAG-NEXT:    v_permlane16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlane16_p3:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlane16_p3:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call ptr addrspace(3) @llvm.amdgcn.permlane16.p3(ptr addrspace(3) %src0, ptr addrspace(3) %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store ptr addrspace(3) %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlanex16_p3(ptr addrspace(1) %out, ptr addrspace(3) %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_p3:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v4
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlanex16_p3:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlanex16_p3:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call ptr addrspace(3) @llvm.amdgcn.permlanex16.p3(ptr addrspace(3) %src0, ptr addrspace(3) %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store ptr addrspace(3) %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlane16_v3p3(ptr addrspace(1) %out, <3 x ptr addrspace(3)> %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_v3p3:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v5
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v6
; GFX10-SDAG-NEXT:    v_permlane16_b32 v4, v4, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx3 v[0:1], v[2:4], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlane16_v3p3:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v4, v4, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlane16_v3p3:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_b32 v4, v4, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call <3 x ptr addrspace(3)> @llvm.amdgcn.permlane16.v3p3(<3 x ptr addrspace(3)> %src0, <3 x ptr addrspace(3)> %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store <3 x ptr addrspace(3)> %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlanex16_v3p3(ptr addrspace(1) %out, <3 x ptr addrspace(3)> %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_v3p3:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v5
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v6
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx3 v[0:1], v[2:4], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlanex16_v3p3:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlanex16_v3p3:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call <3 x ptr addrspace(3)> @llvm.amdgcn.permlanex16.v3p3(<3 x ptr addrspace(3)> %src0, <3 x ptr addrspace(3)> %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store <3 x ptr addrspace(3)> %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlane16_p5(ptr addrspace(1) %out, ptr addrspace(5) %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_p5:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v4
; GFX10-SDAG-NEXT:    v_permlane16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlane16_p5:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlane16_p5:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call ptr addrspace(5) @llvm.amdgcn.permlane16.p5(ptr addrspace(5) %src0, ptr addrspace(5) %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store ptr addrspace(5) %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlanex16_p5(ptr addrspace(1) %out, ptr addrspace(5) %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_p5:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v4
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlanex16_p5:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlanex16_p5:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call ptr addrspace(5) @llvm.amdgcn.permlanex16.p5(ptr addrspace(5) %src0, ptr addrspace(5) %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store ptr addrspace(5) %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlane16_v3p5(ptr addrspace(1) %out, <3 x ptr addrspace(5)> %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_v3p5:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v5
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v6
; GFX10-SDAG-NEXT:    v_permlane16_b32 v4, v4, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx3 v[0:1], v[2:4], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlane16_v3p5:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v4, v4, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlane16_v3p5:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_b32 v4, v4, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call <3 x ptr addrspace(5)> @llvm.amdgcn.permlane16.v3p5(<3 x ptr addrspace(5)> %src0, <3 x ptr addrspace(5)> %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store <3 x ptr addrspace(5)> %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlanex16_v3p5(ptr addrspace(1) %out, <3 x ptr addrspace(5)> %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_v3p5:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v5
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v6
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx3 v[0:1], v[2:4], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlanex16_v3p5:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlanex16_v3p5:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call <3 x ptr addrspace(5)> @llvm.amdgcn.permlanex16.v3p5(<3 x ptr addrspace(5)> %src0, <3 x ptr addrspace(5)> %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store <3 x ptr addrspace(5)> %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlane16_p6(ptr addrspace(1) %out, ptr addrspace(6) %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_p6:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v4
; GFX10-SDAG-NEXT:    v_permlane16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlane16_p6:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlane16_p6:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call ptr addrspace(6) @llvm.amdgcn.permlane16.p6(ptr addrspace(6) %src0, ptr addrspace(6) %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store ptr addrspace(6) %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlanex16_p6(ptr addrspace(1) %out, ptr addrspace(6) %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_p6:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v4
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlanex16_p6:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlanex16_p6:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call ptr addrspace(6) @llvm.amdgcn.permlanex16.p6(ptr addrspace(6) %src0, ptr addrspace(6) %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store ptr addrspace(6) %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlane16_v3p6(ptr addrspace(1) %out, <3 x ptr addrspace(6)> %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_v3p6:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v5
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v6
; GFX10-SDAG-NEXT:    v_permlane16_b32 v4, v4, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlane16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx3 v[0:1], v[2:4], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlane16_v3p6:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v4, v4, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlane16_v3p6:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlane16_b32 v4, v4, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlane16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call <3 x ptr addrspace(6)> @llvm.amdgcn.permlane16.v3p6(<3 x ptr addrspace(6)> %src0, <3 x ptr addrspace(6)> %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store <3 x ptr addrspace(6)> %v, ptr addrspace(1) %out
  ret void
}

define void @v_permlanex16_v3p6(ptr addrspace(1) %out, <3 x ptr addrspace(6)> %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_v3p6:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v5
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s5, v6
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s4, s5
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s4, s5
; GFX10-SDAG-NEXT:    global_store_dwordx3 v[0:1], v[2:4], off
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: v_permlanex16_v3p6:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX11-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: v_permlanex16_v3p6:
; GFX12-SDAG:       ; %bb.0:
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX12-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v4, v4, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v3, v3, s0, s1
; GFX12-SDAG-NEXT:    v_permlanex16_b32 v2, v2, s0, s1
; GFX12-SDAG-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
  %v = call <3 x ptr addrspace(6)> @llvm.amdgcn.permlanex16.v3p6(<3 x ptr addrspace(6)> %src0, <3 x ptr addrspace(6)> %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store <3 x ptr addrspace(6)> %v, ptr addrspace(1) %out
  ret void
}
