; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefix=GCN %s

; Combine on select c, (load x), (load y) -> load (select c, x, y)
; drops MachinePointerInfo, so it can't be relied on for correctness.

define amdgpu_kernel void @select_ptr_crash_i64_flat(i32 %tmp, [8 x i32], ptr %ptr0, [8 x i32], ptr %ptr1, [8 x i32], ptr addrspace(1) %ptr2) {
; GCN-LABEL: select_ptr_crash_i64_flat:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s6, s[8:9], 0x0
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x28
; GCN-NEXT:    s_load_dwordx2 s[2:3], s[8:9], 0x50
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x78
; GCN-NEXT:    s_add_i32 s12, s12, s17
; GCN-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s6, 0
; GCN-NEXT:    s_cselect_b32 s0, s0, s2
; GCN-NEXT:    s_cselect_b32 s1, s1, s3
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    s_add_u32 s0, s0, 4
; GCN-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-NEXT:    s_addc_u32 s1, s1, 0
; GCN-NEXT:    flat_load_dword v0, v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v2, s1
; GCN-NEXT:    v_mov_b32_e32 v1, s0
; GCN-NEXT:    flat_load_dword v1, v[1:2]
; GCN-NEXT:    v_mov_b32_e32 v2, s4
; GCN-NEXT:    v_mov_b32_e32 v3, s5
; GCN-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-NEXT:    s_endpgm
  %tmp2 = icmp eq i32 %tmp, 0
  %tmp3 = load i64, ptr %ptr0, align 8
  %tmp4 = load i64, ptr %ptr1, align 8
  %tmp5 = select i1 %tmp2, i64 %tmp3, i64 %tmp4
  store i64 %tmp5, ptr addrspace(1) %ptr2, align 8
  ret void
}

; The transform currently doesn't happen for non-addrspace 0, but it
; should.

define amdgpu_kernel void @select_ptr_crash_i64_global(i32 %tmp, [8 x i32], ptr addrspace(1) %ptr0, [8 x i32], ptr addrspace(1) %ptr1, [8 x i32], ptr addrspace(1) %ptr2) {
; GCN-LABEL: select_ptr_crash_i64_global:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x28
; GCN-NEXT:    s_load_dwordx2 s[2:3], s[8:9], 0x50
; GCN-NEXT:    s_load_dword s6, s[8:9], 0x0
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x78
; GCN-NEXT:    s_add_i32 s12, s12, s17
; GCN-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GCN-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GCN-NEXT:    s_cmp_eq_u32 s6, 0
; GCN-NEXT:    v_mov_b32_e32 v2, s4
; GCN-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-NEXT:    v_mov_b32_e32 v3, s5
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cselect_b32 s1, s1, s3
; GCN-NEXT:    s_cselect_b32 s0, s0, s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-NEXT:    s_endpgm
  %tmp2 = icmp eq i32 %tmp, 0
  %tmp3 = load i64, ptr addrspace(1) %ptr0, align 8
  %tmp4 = load i64, ptr addrspace(1) %ptr1, align 8
  %tmp5 = select i1 %tmp2, i64 %tmp3, i64 %tmp4
  store i64 %tmp5, ptr addrspace(1) %ptr2, align 8
  ret void
}

define amdgpu_kernel void @select_ptr_crash_i64_local(i32 %tmp, ptr addrspace(3) %ptr0, ptr addrspace(3) %ptr1, ptr addrspace(1) %ptr2) {
; GCN-LABEL: select_ptr_crash_i64_local:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GCN-NEXT:    s_mov_b32 m0, -1
; GCN-NEXT:    s_add_i32 s12, s12, s17
; GCN-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    ds_read_b64 v[0:1], v0
; GCN-NEXT:    ds_read_b64 v[2:3], v2
; GCN-NEXT:    s_cmp_eq_u32 s0, 0
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, s4
; GCN-NEXT:    v_mov_b32_e32 v3, s5
; GCN-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-NEXT:    s_endpgm
  %tmp2 = icmp eq i32 %tmp, 0
  %tmp3 = load i64, ptr addrspace(3) %ptr0, align 8
  %tmp4 = load i64, ptr addrspace(3) %ptr1, align 8
  %tmp5 = select i1 %tmp2, i64 %tmp3, i64 %tmp4
  store i64 %tmp5, ptr addrspace(1) %ptr2, align 8
  ret void
}

; The transform will break addressing mode matching, so unclear it
; would be good to do

define amdgpu_kernel void @select_ptr_crash_i64_local_offsets(i32 %tmp, ptr addrspace(3) %ptr0, ptr addrspace(3) %ptr1, ptr addrspace(1) %ptr2) {
; GCN-LABEL: select_ptr_crash_i64_local_offsets:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GCN-NEXT:    s_mov_b32 m0, -1
; GCN-NEXT:    s_add_i32 s12, s12, s17
; GCN-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    ds_read_b64 v[0:1], v0 offset:128
; GCN-NEXT:    ds_read_b64 v[2:3], v2 offset:512
; GCN-NEXT:    s_cmp_eq_u32 s0, 0
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, s4
; GCN-NEXT:    v_mov_b32_e32 v3, s5
; GCN-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-NEXT:    s_endpgm
  %tmp2 = icmp eq i32 %tmp, 0
  %gep0 = getelementptr inbounds i64, ptr addrspace(3) %ptr0, i64 16
  %gep1 = getelementptr inbounds i64, ptr addrspace(3) %ptr1, i64 64
  %tmp3 = load i64, ptr addrspace(3) %gep0, align 8
  %tmp4 = load i64, ptr addrspace(3) %gep1, align 8
  %tmp5 = select i1 %tmp2, i64 %tmp3, i64 %tmp4
  store i64 %tmp5, ptr addrspace(1) %ptr2, align 8
  ret void
}
