; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdhsad < %s | FileCheck %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa < %s | FileCheck %s

; Check illegal casts are codegened as poison, and not an error.

define amdgpu_kernel void @use_group_to_global_addrspacecast(ptr addrspace(3) %ptr) {
; CHECK-LABEL: use_group_to_global_addrspacecast:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CHECK-NEXT:    s_add_i32 s12, s12, s17
; CHECK-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CHECK-NEXT:    v_mov_b32_e32 v0, 0
; CHECK-NEXT:    flat_store_dword v[0:1], v0
; CHECK-NEXT:    s_waitcnt vmcnt(0)
; CHECK-NEXT:    s_endpgm
  %stof = addrspacecast ptr addrspace(3) %ptr to ptr addrspace(1)
  store volatile i32 0, ptr addrspace(1) %stof
  ret void
}

define amdgpu_kernel void @use_local_to_constant32bit_addrspacecast(ptr addrspace(3) %ptr) {
; CHECK-LABEL: use_local_to_constant32bit_addrspacecast:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_mov_b32 s1, 0
; CHECK-NEXT:    s_load_dword s0, s[0:1], 0x0
; CHECK-NEXT:    s_endpgm
  %stof = addrspacecast ptr addrspace(3) %ptr to ptr addrspace(6)
  %load = load volatile i32, ptr addrspace(6) %stof
  ret void
}

define amdgpu_kernel void @use_constant32bit_to_local_addrspacecast(ptr addrspace(6) %ptr) {
; CHECK-LABEL: use_constant32bit_to_local_addrspacecast:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_mov_b32 m0, -1
; CHECK-NEXT:    ds_read_b32 v0, v0
; CHECK-NEXT:    s_endpgm
  %cast = addrspacecast ptr addrspace(6) %ptr to ptr addrspace(3)
  %load = load volatile i32, ptr addrspace(3) %cast
  ret void
}

define amdgpu_kernel void @use_local_to_42_addrspacecast(ptr addrspace(3) %ptr) {
; SDAG-LABEL: use_local_to_42_addrspacecast:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: use_local_to_42_addrspacecast:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_endpgm
  %cast = addrspacecast ptr addrspace(3) %ptr to ptr addrspace(42)
  store volatile ptr addrspace(42) %cast, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @use_42_to_local_addrspacecast(ptr addrspace(42) %ptr) {
; CHECK-LABEL: use_42_to_local_addrspacecast:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_mov_b32 m0, -1
; CHECK-NEXT:    ds_read_b32 v0, v0
; CHECK-NEXT:    s_endpgm
  %cast = addrspacecast ptr addrspace(42) %ptr to ptr addrspace(3)
  %load = load volatile i32, ptr addrspace(3) %cast
  ret void
}
