/* $Id$
******************************************************************************

   LibGGIMisc implementation for "pseudo_stubs" target -- Initialization.

   Copyright (c) 2004      Peter Ekberg         peda@lysator.liu.se
   Copyright (c) 2001      Brian S. Julin	bri@calyx.com
   Copyright (c) 1998-2000 Marcus Sundberg      marcus@ggi-project.org 
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   The above copyright notice applies to all files in this package, unless 
   explicitly stated otherwise in the file itself or in a file named COPYING 
   in the same directory as the file.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


******************************************************************************
*/

#include "config.h"
#include "pseudostubsggimisc.h"

static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32_t *dlret)
{
	ggiMiscpriv *priv = LIBGGI_GGIMISCEXT(vis);
	void *tmp;

	sscanf(args, "%p", &tmp);
	if(tmp == NULL)
		return GGI_EARGREQ;

	LIBGGI_MISCPRIVATE(priv) = tmp;

	ggiMiscAttach(tmp);

	/*-* Hook in target functions */

	LIBGGI_GGIMISCEXT(vis)->waitraypos   = GGIMISC_pseudo_stubs_WaitRayPos;
	LIBGGI_GGIMISCEXT(vis)->getraypos    = GGIMISC_pseudo_stubs_GetRayPos;
	LIBGGI_GGIMISCEXT(vis)->setsplitline = GGIMISC_pseudo_stubs_SetSplitline;

	/*-* Apply initial values */

	*dlret = GGI_DL_EXTENSION;
	return 0;
}	/* GGIopen */


static int GGIexit(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	ggiMiscpriv *priv = LIBGGI_GGIMISCEXT(vis);

	if (priv != NULL && priv->priv != NULL) {
		ggiMiscDetach(priv->priv);
		priv->priv = NULL;
	}

	return 0;
}	/* GGIclose */


EXPORTFUNC
int GGIMISCdl_pseudo_stubs_ggimisc(int func, void **funcptr);

int GGIMISCdl_pseudo_stubs_ggimisc(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;

	case GGIFUNC_exit:
		*funcptr = GGIexit;
		return 0;

	case GGIFUNC_close:
		*funcptr = NULL;
		return 0;

	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GGIMISCdl_directx_ggimisc */


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
