// -*- c++ -*-
// Generated by gmmproc 2.38.1 -- DO NOT MODIFY!
#ifndef _LIBGDAMM_SQLPARSER_H
#define _LIBGDAMM_SQLPARSER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- C++ -*- //

/* set.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/batch.h>
#include <libgdamm/statement.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaSqlParser GdaSqlParser;
typedef struct _GdaSqlParserClass GdaSqlParserClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class SqlParser_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums libgdamm Enums and Flags */

/** 
 * 
 * @ingroup libgdammEnums
 */
enum SqlParserMode
{
  SQL_PARSER_MODE_PARSE,
  SQL_PARSER_MODE_DELIMIT
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlParserMode> : public Glib::Value_Enum<Gnome::Gda::SqlParserMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

class SqlParserError : public Glib::Error
{
public:
  enum Code
  {
    SQL_PARSER_SYNTAX_ERROR,
    SQL_PARSER_OVERFLOW_ERROR,
    SQL_PARSER_EMPTY_SQL_ERROR
  };

  SqlParserError(Code error_code, const Glib::ustring& error_message);
  explicit SqlParserError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlParserError::Code> : public Glib::Value_Enum<Gnome::Gda::SqlParserError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

		
//TODO: Find out how to escape /* so we can actually show the full syntax at the end of this text.
/** SQL parser.
 *
 * The Gda::SqlParser is an object dedicated to creating Gda::Statement and 
 * Gda::Batch objects from SQL strings. The actual contents of the parsed 
 * statements is represented as Gda::SqlStatement structures (which can be 
 * obtained from any Gda::Statement through the "structure" property).
 *
 * Gda::SqlParser parsers can be created by calling Gda::ServerProvider::create_parser() 
 * for a provider adapted SQL parser, or using create() for a general purpose SQL parser.
 * 
 * The Gda::SqlParser can either work in "parse" mode where it will try to parse
 * the SQL string, or in "delimiter" mode where it will only attempt at delimiting 
 * SQL statements in a string which may contain several SQL statements (usually 
 * separated by a semi column). If operating in "parser" mode, and the parser 
 * can't correctly parse the string, then it will switch to the "delimiter" mode 
 * for the next statement in the string to parse (and create a STATEMENT_UNKNOWN statement).
 * 
 * The Gda::SqlParser object parses and analyses SQL statements and reports the 
 * following statement types:
 *
 * - SELECT (and COMPOUND select), INSERT, UPDATE and DELETE SQL statements should be completely parsed.
 *
 * - Transaction related statements (corresponding to the BEGIN, COMMIT, 
 *   ROLLBACK, SAVEPOINT, ROLLBACK SAVEPOINT and DELETE SAVEPOINT) are parsed and a 
 *   minimalist structure is created to extract some information (that structure is not enough per-se to re-create the complete SQL statement).
 *
 * Any other type of SQL statement (CREATE TABLE, ...) creates a GdaStatement of 
 * type STATEMENT_UNKNOWN, and it only able to locate place holders (variables)
 * and end of statement marks.
 *
 * NOTE: Any SQL of a type which should be parsed which but which creates a Gda::Statement
 * of type GDA_SQL_STATEMENT_UNKNOWN (check with Gda::Statement::get_statement_type()) 
 * should be reported as a bug.
 *
 * The Gda::SqlParser object recognizes place holders (variables), which can later
 * be queried and valued using Gda::Statement::get_parameters(). 
 * See the syntax description for the underlying <a href="http://library.gnome.org/devel/libgda/stable/GdaSqlParser.html#GdaSqlParser.description">GdaSqlParser</a>.
 *
 * @ingroup Connection
 */

class SqlParser : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SqlParser CppObjectType;
  typedef SqlParser_Class CppClassType;
  typedef GdaSqlParser BaseObjectType;
  typedef GdaSqlParserClass BaseClassType;

private:  friend class SqlParser_Class;
  static CppClassType sqlparser_class_;

private:
  // noncopyable
  SqlParser(const SqlParser&);
  SqlParser& operator=(const SqlParser&);

protected:
  explicit SqlParser(const Glib::ConstructParams& construct_params);
  explicit SqlParser(GdaSqlParser* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SqlParser();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaSqlParser*       gobj()       { return reinterpret_cast<GdaSqlParser*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaSqlParser* gobj() const { return reinterpret_cast<GdaSqlParser*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaSqlParser* gobj_copy();

private:

protected:
  SqlParser();
public:
  
  static Glib::RefPtr<SqlParser> create();

  
  //TODO: Should these be const?
  
  /** Parses @a sql and creates a Gda::Statement statement from the first SQL statement contained in @a sql: if @a sql
   * contains more than one statement, then the remaining part of the string is not parsed at all, and @a remain (if
   * not <tt>0</tt>) will point at the first non parsed character.
   * 
   * To include variables in the @a sql string, see the
   * GdaSqlParser's object description.
   * @param sql The SQL string to parse.
   * @param remain Location to store a pointer to remaining part of @a sql in case @a sql has multiple statement, or <tt>0</tt>.
   * @return A new Gda::Statement object, or <tt>0</tt> if an error occurred.
   */

  Glib::RefPtr<Statement> parse_string(const Glib::ustring& sql, Glib::ustring& remain);

  Glib::RefPtr<Statement> parse_string(const Glib::ustring& sql);
    
  
  /** Parse @a sql and creates a Gda::Batch object which contains all the Gda::Statement objects created while parsing (one object
   * per SQL statement). Empty statements (composed of spaces only) do not appear in the resulting object.
   * 
   *  @a sql is parsed and Gda::Statement objects are created as long as no error is found in @a sql. If an error is found
   * at some point, then the parsing stops and @a remain may contain a non <tt>0</tt> pointer, @a error may be set, and <tt>0</tt>
   * is returned.
   * 
   * if @a sql is <tt>0</tt>, then the returned Gda::Batch object will contain no statement.
   * 
   * To include variables in the @a sql string, see the
   * GdaSqlParser's object description.
   * @param sql The SQL string to parse.
   * @param remain Location to store a pointer to remaining part of @a sql in case an error occurred while parsing @a sql, or <tt>0</tt>.
   * @return A new Gda::Batch object, or <tt>0</tt> if an error occurred.
   */

  Glib::RefPtr<Batch> parse_string_as_batch(const Glib::ustring& sql, Glib::ustring& remain);

  Glib::RefPtr<Batch> parse_string_as_batch(const Glib::ustring& sql);
  
  
  /** Parse @a filename's contents and creates a Gda::Batch object which contains all the
   * Gda::Statement objects created while parsing (one object per SQL statement).
   * 
   *  @a filename's contents are parsed and Gda::Statement objects are created as long as no error is found. If an error is found
   * at some point, then the parsing stops, @a error may be set and <tt>0</tt> is returned
   * 
   * if @a sql is <tt>0</tt>, then the returned Gda::Batch object will contain no statement.
   * @param filename Name of the file to parse.
   * @return A new Gda::Batch object, or <tt>0</tt> if an error occurred.
   */
  Glib::RefPtr<Batch> parse_file_as_batch(const std::string& filename);

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_column_error() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_line_error() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_tokenizer_flavour() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_tokenizer_flavour() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::SqlParser
   */
  Glib::RefPtr<Gnome::Gda::SqlParser> wrap(GdaSqlParser* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_SQLPARSER_H */

