; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mcpu=generic -mtriple=i686-linux -verify-machineinstrs | FileCheck %s -check-prefix=X86-Linux
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-linux  -verify-machineinstrs | FileCheck %s -check-prefix=X64-Linux
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-linux -code-model=large -verify-machineinstrs | FileCheck %s -check-prefix=X64-Linux-Large
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-linux-gnux32 -verify-machineinstrs | FileCheck %s -check-prefix=X32ABI
; RUN: llc < %s -mcpu=generic -mtriple=i686-darwin -verify-machineinstrs | FileCheck %s -check-prefix=X86-Darwin
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-darwin -verify-machineinstrs | FileCheck %s -check-prefix=X64-Darwin
; RUN: llc < %s -mcpu=generic -mtriple=i686-mingw32 -verify-machineinstrs | FileCheck %s -check-prefix=X86-MinGW
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-freebsd -verify-machineinstrs | FileCheck %s -check-prefix=X64-FreeBSD
; RUN: llc < %s -mcpu=generic -mtriple=i686-dragonfly -verify-machineinstrs | FileCheck %s -check-prefix=X86-DFlyBSD
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-dragonfly -verify-machineinstrs | FileCheck %s -check-prefix=X64-DFlyBSD
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-mingw32 -verify-machineinstrs | FileCheck %s -check-prefix=X64-MinGW

; We used to crash with filetype=obj
; RUN: llc < %s -mcpu=generic -mtriple=i686-linux -filetype=obj -o /dev/null
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-linux -filetype=obj -o /dev/null
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-linux-gnux32 -filetype=obj -o /dev/null
; RUN: llc < %s -mcpu=generic -mtriple=i686-darwin -filetype=obj -o /dev/null
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-darwin -filetype=obj -o /dev/null
; RUN: llc < %s -mcpu=generic -mtriple=i686-mingw32 -filetype=obj -o /dev/null
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-freebsd -filetype=obj -o /dev/null
; RUN: llc < %s -mcpu=generic -mtriple=i686-dragonfly -filetype=obj -o /dev/null
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-dragonfly -filetype=obj -o /dev/null
; RUN: llc < %s -mcpu=generic -mtriple=x86_64-mingw32 -filetype=obj -o /dev/null

; RUN: not --crash llc < %s -mcpu=generic -mtriple=x86_64-solaris 2> %t.log
; RUN: FileCheck %s -input-file=%t.log -check-prefix=X64-Solaris
; RUN: not --crash llc < %s -mcpu=generic -mtriple=i686-freebsd 2> %t.log
; RUN: FileCheck %s -input-file=%t.log -check-prefix=X86-FreeBSD

; X64-Solaris: Segmented stacks not supported on this platform
; X86-FreeBSD: Segmented stacks not supported on FreeBSD i386

; Just to prevent the alloca from being optimized away
declare void @dummy_use(ptr, i32)

define void @test_basic() #0 {
; X86-Linux-LABEL: test_basic:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    cmpl %gs:48, %esp
; X86-Linux-NEXT:    jbe .LBB0_1
; X86-Linux-NEXT:  .LBB0_2:
; X86-Linux-NEXT:    subl $52, %esp
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 52
; X86-Linux-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Linux-NEXT:    pushl $10
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    pushl %eax
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    calll dummy_use@PLT
; X86-Linux-NEXT:    addl $60, %esp
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset -60
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:  .LBB0_1:
; X86-Linux-NEXT:    pushl $0
; X86-Linux-NEXT:    pushl $44
; X86-Linux-NEXT:    calll __morestack
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:    jmp .LBB0_2
;
; X64-Linux-LABEL: test_basic:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-NEXT:    jbe .LBB0_1
; X64-Linux-NEXT:  .LBB0_2:
; X64-Linux-NEXT:    subq $40, %rsp
; X64-Linux-NEXT:    .cfi_def_cfa_offset 48
; X64-Linux-NEXT:    movq %rsp, %rdi
; X64-Linux-NEXT:    movl $10, %esi
; X64-Linux-NEXT:    callq dummy_use@PLT
; X64-Linux-NEXT:    addq $40, %rsp
; X64-Linux-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:  .LBB0_1:
; X64-Linux-NEXT:    movl $40, %r10d
; X64-Linux-NEXT:    movl $0, %r11d
; X64-Linux-NEXT:    callq __morestack
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:    jmp .LBB0_2
;
; X64-Linux-Large-LABEL: test_basic:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-Large-NEXT:    jbe .LBB0_1
; X64-Linux-Large-NEXT:  .LBB0_2:
; X64-Linux-Large-NEXT:    subq $40, %rsp
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 48
; X64-Linux-Large-NEXT:    movabsq $dummy_use, %rax
; X64-Linux-Large-NEXT:    movq %rsp, %rdi
; X64-Linux-Large-NEXT:    movl $10, %esi
; X64-Linux-Large-NEXT:    callq *%rax
; X64-Linux-Large-NEXT:    addq $40, %rsp
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:  .LBB0_1:
; X64-Linux-Large-NEXT:    movl $40, %r10d
; X64-Linux-Large-NEXT:    movl $0, %r11d
; X64-Linux-Large-NEXT:    callq *__morestack_addr(%rip)
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:    jmp .LBB0_2
;
; X32ABI-LABEL: test_basic:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    cmpl %fs:64, %esp
; X32ABI-NEXT:    jbe .LBB0_1
; X32ABI-NEXT:  .LBB0_2:
; X32ABI-NEXT:    subl $40, %esp
; X32ABI-NEXT:    .cfi_def_cfa_offset 48
; X32ABI-NEXT:    movl %esp, %edi
; X32ABI-NEXT:    movl $10, %esi
; X32ABI-NEXT:    callq dummy_use@PLT
; X32ABI-NEXT:    addl $40, %esp
; X32ABI-NEXT:    .cfi_def_cfa_offset 8
; X32ABI-NEXT:    retq
; X32ABI-NEXT:  .LBB0_1:
; X32ABI-NEXT:    movl $40, %r10d
; X32ABI-NEXT:    movl $0, %r11d
; X32ABI-NEXT:    callq __morestack
; X32ABI-NEXT:    retq
; X32ABI-NEXT:    jmp .LBB0_2
;
; X86-Darwin-LABEL: test_basic:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    movl $432, %ecx ## imm = 0x1B0
; X86-Darwin-NEXT:    cmpl %gs:(%ecx), %esp
; X86-Darwin-NEXT:    jbe LBB0_1
; X86-Darwin-NEXT:  LBB0_2:
; X86-Darwin-NEXT:    subl $60, %esp
; X86-Darwin-NEXT:    .cfi_def_cfa_offset 64
; X86-Darwin-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Darwin-NEXT:    movl %eax, (%esp)
; X86-Darwin-NEXT:    movl $10, {{[0-9]+}}(%esp)
; X86-Darwin-NEXT:    calll _dummy_use
; X86-Darwin-NEXT:    addl $60, %esp
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:  LBB0_1:
; X86-Darwin-NEXT:    pushl $0
; X86-Darwin-NEXT:    pushl $60
; X86-Darwin-NEXT:    calll ___morestack
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:    jmp LBB0_2
;
; X64-Darwin-LABEL: test_basic:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    cmpq %gs:816, %rsp
; X64-Darwin-NEXT:    jbe LBB0_1
; X64-Darwin-NEXT:  LBB0_2:
; X64-Darwin-NEXT:    subq $40, %rsp
; X64-Darwin-NEXT:    .cfi_def_cfa_offset 48
; X64-Darwin-NEXT:    movq %rsp, %rdi
; X64-Darwin-NEXT:    movl $10, %esi
; X64-Darwin-NEXT:    callq _dummy_use
; X64-Darwin-NEXT:    addq $40, %rsp
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:  LBB0_1:
; X64-Darwin-NEXT:    movl $40, %r10d
; X64-Darwin-NEXT:    movl $0, %r11d
; X64-Darwin-NEXT:    callq ___morestack
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:    jmp LBB0_2
;
; X86-MinGW-LABEL: test_basic:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    cmpl %fs:20, %esp
; X86-MinGW-NEXT:    jbe LBB0_1
; X86-MinGW-NEXT:  LBB0_2:
; X86-MinGW-NEXT:    subl $40, %esp
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 44
; X86-MinGW-NEXT:    movl %esp, %eax
; X86-MinGW-NEXT:    pushl $10
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    pushl %eax
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    calll _dummy_use
; X86-MinGW-NEXT:    addl $48, %esp
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset -48
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:  LBB0_1:
; X86-MinGW-NEXT:    pushl $0
; X86-MinGW-NEXT:    pushl $40
; X86-MinGW-NEXT:    calll ___morestack
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:    jmp LBB0_2
;
; X64-FreeBSD-LABEL: test_basic:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    cmpq %fs:24, %rsp
; X64-FreeBSD-NEXT:    jbe .LBB0_1
; X64-FreeBSD-NEXT:  .LBB0_2:
; X64-FreeBSD-NEXT:    subq $40, %rsp
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 48
; X64-FreeBSD-NEXT:    movq %rsp, %rdi
; X64-FreeBSD-NEXT:    movl $10, %esi
; X64-FreeBSD-NEXT:    callq dummy_use@PLT
; X64-FreeBSD-NEXT:    addq $40, %rsp
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:  .LBB0_1:
; X64-FreeBSD-NEXT:    movl $40, %r10d
; X64-FreeBSD-NEXT:    movl $0, %r11d
; X64-FreeBSD-NEXT:    callq __morestack
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:    jmp .LBB0_2
;
; X86-DFlyBSD-LABEL: test_basic:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    cmpl %fs:16, %esp
; X86-DFlyBSD-NEXT:    jbe .LBB0_1
; X86-DFlyBSD-NEXT:  .LBB0_2:
; X86-DFlyBSD-NEXT:    subl $40, %esp
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 44
; X86-DFlyBSD-NEXT:    movl %esp, %eax
; X86-DFlyBSD-NEXT:    pushl $10
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    pushl %eax
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    calll dummy_use@PLT
; X86-DFlyBSD-NEXT:    addl $48, %esp
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset -48
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:  .LBB0_1:
; X86-DFlyBSD-NEXT:    pushl $0
; X86-DFlyBSD-NEXT:    pushl $40
; X86-DFlyBSD-NEXT:    calll __morestack
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:    jmp .LBB0_2
;
; X64-DFlyBSD-LABEL: test_basic:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    cmpq %fs:32, %rsp
; X64-DFlyBSD-NEXT:    jbe .LBB0_1
; X64-DFlyBSD-NEXT:  .LBB0_2:
; X64-DFlyBSD-NEXT:    subq $40, %rsp
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 48
; X64-DFlyBSD-NEXT:    movq %rsp, %rdi
; X64-DFlyBSD-NEXT:    movl $10, %esi
; X64-DFlyBSD-NEXT:    callq dummy_use@PLT
; X64-DFlyBSD-NEXT:    addq $40, %rsp
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:  .LBB0_1:
; X64-DFlyBSD-NEXT:    movl $40, %r10d
; X64-DFlyBSD-NEXT:    movl $0, %r11d
; X64-DFlyBSD-NEXT:    callq __morestack
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:    jmp .LBB0_2
;
; X64-MinGW-LABEL: test_basic:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    cmpq %gs:40, %rsp
; X64-MinGW-NEXT:    jbe .LBB0_1
; X64-MinGW-NEXT:  .LBB0_2:
; X64-MinGW-NEXT:    subq $72, %rsp
; X64-MinGW-NEXT:    .seh_stackalloc 72
; X64-MinGW-NEXT:    .seh_endprologue
; X64-MinGW-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-MinGW-NEXT:    movl $10, %edx
; X64-MinGW-NEXT:    callq dummy_use
; X64-MinGW-NEXT:    nop
; X64-MinGW-NEXT:    .seh_startepilogue
; X64-MinGW-NEXT:    addq $72, %rsp
; X64-MinGW-NEXT:    .seh_endepilogue
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:  .LBB0_1:
; X64-MinGW-NEXT:    movl $72, %r10d
; X64-MinGW-NEXT:    movl $32, %r11d
; X64-MinGW-NEXT:    callq __morestack
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:    jmp .LBB0_2
; X64-MinGW-NEXT:    .seh_endproc
        %mem = alloca i32, i32 10
        call void @dummy_use (ptr %mem, i32 10)
	ret void
}

define i32 @test_nested(ptr nest %closure, i32 %other) #0 {
; X86-Linux-LABEL: test_nested:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    cmpl %gs:48, %esp
; X86-Linux-NEXT:    jbe .LBB1_1
; X86-Linux-NEXT:  .LBB1_2:
; X86-Linux-NEXT:    pushl %esi
; X86-Linux-NEXT:    .cfi_def_cfa_offset 8
; X86-Linux-NEXT:    subl $40, %esp
; X86-Linux-NEXT:    .cfi_def_cfa_offset 48
; X86-Linux-NEXT:    .cfi_offset %esi, -8
; X86-Linux-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-Linux-NEXT:    addl (%ecx), %esi
; X86-Linux-NEXT:    subl $8, %esp
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 8
; X86-Linux-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Linux-NEXT:    pushl $10
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    pushl %eax
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    calll dummy_use@PLT
; X86-Linux-NEXT:    addl $16, %esp
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset -16
; X86-Linux-NEXT:    movl %esi, %eax
; X86-Linux-NEXT:    addl $40, %esp
; X86-Linux-NEXT:    .cfi_def_cfa_offset 8
; X86-Linux-NEXT:    popl %esi
; X86-Linux-NEXT:    .cfi_def_cfa_offset 4
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:  .LBB1_1:
; X86-Linux-NEXT:    .cfi_restore %esi
; X86-Linux-NEXT:    pushl $4
; X86-Linux-NEXT:    pushl $44
; X86-Linux-NEXT:    calll __morestack
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:    jmp .LBB1_2
;
; X64-Linux-LABEL: test_nested:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-NEXT:    jbe .LBB1_1
; X64-Linux-NEXT:  .LBB1_2:
; X64-Linux-NEXT:    pushq %rbx
; X64-Linux-NEXT:    .cfi_def_cfa_offset 16
; X64-Linux-NEXT:    subq $48, %rsp
; X64-Linux-NEXT:    .cfi_def_cfa_offset 64
; X64-Linux-NEXT:    .cfi_offset %rbx, -16
; X64-Linux-NEXT:    movl %edi, %ebx
; X64-Linux-NEXT:    addl (%r10), %ebx
; X64-Linux-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Linux-NEXT:    movl $10, %esi
; X64-Linux-NEXT:    callq dummy_use@PLT
; X64-Linux-NEXT:    movl %ebx, %eax
; X64-Linux-NEXT:    addq $48, %rsp
; X64-Linux-NEXT:    .cfi_def_cfa_offset 16
; X64-Linux-NEXT:    popq %rbx
; X64-Linux-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:  .LBB1_1:
; X64-Linux-NEXT:    .cfi_restore %rbx
; X64-Linux-NEXT:    movq %r10, %rax
; X64-Linux-NEXT:    movl $56, %r10d
; X64-Linux-NEXT:    movl $0, %r11d
; X64-Linux-NEXT:    callq __morestack
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:    movq %rax, %r10
; X64-Linux-NEXT:    jmp .LBB1_2
;
; X64-Linux-Large-LABEL: test_nested:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-Large-NEXT:    jbe .LBB1_1
; X64-Linux-Large-NEXT:  .LBB1_2:
; X64-Linux-Large-NEXT:    pushq %rbx
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 16
; X64-Linux-Large-NEXT:    subq $48, %rsp
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 64
; X64-Linux-Large-NEXT:    .cfi_offset %rbx, -16
; X64-Linux-Large-NEXT:    movl %edi, %ebx
; X64-Linux-Large-NEXT:    addl (%r10), %ebx
; X64-Linux-Large-NEXT:    movabsq $dummy_use, %rax
; X64-Linux-Large-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Linux-Large-NEXT:    movl $10, %esi
; X64-Linux-Large-NEXT:    callq *%rax
; X64-Linux-Large-NEXT:    movl %ebx, %eax
; X64-Linux-Large-NEXT:    addq $48, %rsp
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 16
; X64-Linux-Large-NEXT:    popq %rbx
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:  .LBB1_1:
; X64-Linux-Large-NEXT:    .cfi_restore %rbx
; X64-Linux-Large-NEXT:    movq %r10, %rax
; X64-Linux-Large-NEXT:    movl $56, %r10d
; X64-Linux-Large-NEXT:    movl $0, %r11d
; X64-Linux-Large-NEXT:    callq *__morestack_addr(%rip)
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:    movq %rax, %r10
; X64-Linux-Large-NEXT:    jmp .LBB1_2
;
; X32ABI-LABEL: test_nested:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    cmpl %fs:64, %esp
; X32ABI-NEXT:    jbe .LBB1_1
; X32ABI-NEXT:  .LBB1_2:
; X32ABI-NEXT:    pushq %rbx
; X32ABI-NEXT:    .cfi_def_cfa_offset 16
; X32ABI-NEXT:    subl $48, %esp
; X32ABI-NEXT:    .cfi_def_cfa_offset 64
; X32ABI-NEXT:    .cfi_offset %rbx, -16
; X32ABI-NEXT:    movl %edi, %ebx
; X32ABI-NEXT:    addl (%r10d), %ebx
; X32ABI-NEXT:    leal {{[0-9]+}}(%rsp), %edi
; X32ABI-NEXT:    movl $10, %esi
; X32ABI-NEXT:    callq dummy_use@PLT
; X32ABI-NEXT:    movl %ebx, %eax
; X32ABI-NEXT:    addl $48, %esp
; X32ABI-NEXT:    .cfi_def_cfa_offset 16
; X32ABI-NEXT:    popq %rbx
; X32ABI-NEXT:    .cfi_def_cfa_offset 8
; X32ABI-NEXT:    retq
; X32ABI-NEXT:  .LBB1_1:
; X32ABI-NEXT:    .cfi_restore %rbx
; X32ABI-NEXT:    movl %r10d, %eax
; X32ABI-NEXT:    movl $56, %r10d
; X32ABI-NEXT:    movl $0, %r11d
; X32ABI-NEXT:    callq __morestack
; X32ABI-NEXT:    retq
; X32ABI-NEXT:    movq %rax, %r10
; X32ABI-NEXT:    jmp .LBB1_2
;
; X86-Darwin-LABEL: test_nested:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    movl $432, %edx ## imm = 0x1B0
; X86-Darwin-NEXT:    cmpl %gs:(%edx), %esp
; X86-Darwin-NEXT:    jbe LBB1_1
; X86-Darwin-NEXT:  LBB1_2:
; X86-Darwin-NEXT:    pushl %esi
; X86-Darwin-NEXT:    .cfi_def_cfa_offset 8
; X86-Darwin-NEXT:    subl $56, %esp
; X86-Darwin-NEXT:    .cfi_def_cfa_offset 64
; X86-Darwin-NEXT:    .cfi_offset %esi, -8
; X86-Darwin-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-Darwin-NEXT:    addl (%ecx), %esi
; X86-Darwin-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Darwin-NEXT:    movl %eax, (%esp)
; X86-Darwin-NEXT:    movl $10, {{[0-9]+}}(%esp)
; X86-Darwin-NEXT:    calll _dummy_use
; X86-Darwin-NEXT:    movl %esi, %eax
; X86-Darwin-NEXT:    addl $56, %esp
; X86-Darwin-NEXT:    popl %esi
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:  LBB1_1:
; X86-Darwin-NEXT:    pushl $4
; X86-Darwin-NEXT:    pushl $60
; X86-Darwin-NEXT:    calll ___morestack
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:    jmp LBB1_2
;
; X64-Darwin-LABEL: test_nested:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    cmpq %gs:816, %rsp
; X64-Darwin-NEXT:    jbe LBB1_1
; X64-Darwin-NEXT:  LBB1_2:
; X64-Darwin-NEXT:    pushq %rbx
; X64-Darwin-NEXT:    .cfi_def_cfa_offset 16
; X64-Darwin-NEXT:    subq $48, %rsp
; X64-Darwin-NEXT:    .cfi_def_cfa_offset 64
; X64-Darwin-NEXT:    .cfi_offset %rbx, -16
; X64-Darwin-NEXT:    movl %edi, %ebx
; X64-Darwin-NEXT:    addl (%r10), %ebx
; X64-Darwin-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Darwin-NEXT:    movl $10, %esi
; X64-Darwin-NEXT:    callq _dummy_use
; X64-Darwin-NEXT:    movl %ebx, %eax
; X64-Darwin-NEXT:    addq $48, %rsp
; X64-Darwin-NEXT:    popq %rbx
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:  LBB1_1:
; X64-Darwin-NEXT:    movq %r10, %rax
; X64-Darwin-NEXT:    movl $56, %r10d
; X64-Darwin-NEXT:    movl $0, %r11d
; X64-Darwin-NEXT:    callq ___morestack
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:    movq %rax, %r10
; X64-Darwin-NEXT:    jmp LBB1_2
;
; X86-MinGW-LABEL: test_nested:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    cmpl %fs:20, %esp
; X86-MinGW-NEXT:    jbe LBB1_1
; X86-MinGW-NEXT:  LBB1_2:
; X86-MinGW-NEXT:    pushl %esi
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 8
; X86-MinGW-NEXT:    subl $40, %esp
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 48
; X86-MinGW-NEXT:    .cfi_offset %esi, -8
; X86-MinGW-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-MinGW-NEXT:    addl (%ecx), %esi
; X86-MinGW-NEXT:    movl %esp, %eax
; X86-MinGW-NEXT:    pushl $10
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    pushl %eax
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    calll _dummy_use
; X86-MinGW-NEXT:    addl $8, %esp
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset -8
; X86-MinGW-NEXT:    movl %esi, %eax
; X86-MinGW-NEXT:    addl $40, %esp
; X86-MinGW-NEXT:    popl %esi
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:  LBB1_1:
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 4
; X86-MinGW-NEXT:    .cfi_restore %esi
; X86-MinGW-NEXT:    pushl $4
; X86-MinGW-NEXT:    pushl $44
; X86-MinGW-NEXT:    calll ___morestack
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:    jmp LBB1_2
;
; X64-FreeBSD-LABEL: test_nested:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    cmpq %fs:24, %rsp
; X64-FreeBSD-NEXT:    jbe .LBB1_1
; X64-FreeBSD-NEXT:  .LBB1_2:
; X64-FreeBSD-NEXT:    pushq %rbx
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 16
; X64-FreeBSD-NEXT:    subq $48, %rsp
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 64
; X64-FreeBSD-NEXT:    .cfi_offset %rbx, -16
; X64-FreeBSD-NEXT:    movl %edi, %ebx
; X64-FreeBSD-NEXT:    addl (%r10), %ebx
; X64-FreeBSD-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-FreeBSD-NEXT:    movl $10, %esi
; X64-FreeBSD-NEXT:    callq dummy_use@PLT
; X64-FreeBSD-NEXT:    movl %ebx, %eax
; X64-FreeBSD-NEXT:    addq $48, %rsp
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 16
; X64-FreeBSD-NEXT:    popq %rbx
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:  .LBB1_1:
; X64-FreeBSD-NEXT:    .cfi_restore %rbx
; X64-FreeBSD-NEXT:    movq %r10, %rax
; X64-FreeBSD-NEXT:    movl $56, %r10d
; X64-FreeBSD-NEXT:    movl $0, %r11d
; X64-FreeBSD-NEXT:    callq __morestack
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:    movq %rax, %r10
; X64-FreeBSD-NEXT:    jmp .LBB1_2
;
; X86-DFlyBSD-LABEL: test_nested:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    cmpl %fs:16, %esp
; X86-DFlyBSD-NEXT:    jbe .LBB1_1
; X86-DFlyBSD-NEXT:  .LBB1_2:
; X86-DFlyBSD-NEXT:    pushl %esi
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 8
; X86-DFlyBSD-NEXT:    subl $40, %esp
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 48
; X86-DFlyBSD-NEXT:    .cfi_offset %esi, -8
; X86-DFlyBSD-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-DFlyBSD-NEXT:    addl (%ecx), %esi
; X86-DFlyBSD-NEXT:    movl %esp, %eax
; X86-DFlyBSD-NEXT:    pushl $10
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    pushl %eax
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    calll dummy_use@PLT
; X86-DFlyBSD-NEXT:    addl $8, %esp
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset -8
; X86-DFlyBSD-NEXT:    movl %esi, %eax
; X86-DFlyBSD-NEXT:    addl $40, %esp
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 8
; X86-DFlyBSD-NEXT:    popl %esi
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 4
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:  .LBB1_1:
; X86-DFlyBSD-NEXT:    .cfi_restore %esi
; X86-DFlyBSD-NEXT:    pushl $4
; X86-DFlyBSD-NEXT:    pushl $44
; X86-DFlyBSD-NEXT:    calll __morestack
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:    jmp .LBB1_2
;
; X64-DFlyBSD-LABEL: test_nested:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    cmpq %fs:32, %rsp
; X64-DFlyBSD-NEXT:    jbe .LBB1_1
; X64-DFlyBSD-NEXT:  .LBB1_2:
; X64-DFlyBSD-NEXT:    pushq %rbx
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 16
; X64-DFlyBSD-NEXT:    subq $48, %rsp
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 64
; X64-DFlyBSD-NEXT:    .cfi_offset %rbx, -16
; X64-DFlyBSD-NEXT:    movl %edi, %ebx
; X64-DFlyBSD-NEXT:    addl (%r10), %ebx
; X64-DFlyBSD-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-DFlyBSD-NEXT:    movl $10, %esi
; X64-DFlyBSD-NEXT:    callq dummy_use@PLT
; X64-DFlyBSD-NEXT:    movl %ebx, %eax
; X64-DFlyBSD-NEXT:    addq $48, %rsp
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 16
; X64-DFlyBSD-NEXT:    popq %rbx
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:  .LBB1_1:
; X64-DFlyBSD-NEXT:    .cfi_restore %rbx
; X64-DFlyBSD-NEXT:    movq %r10, %rax
; X64-DFlyBSD-NEXT:    movl $56, %r10d
; X64-DFlyBSD-NEXT:    movl $0, %r11d
; X64-DFlyBSD-NEXT:    callq __morestack
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:    movq %rax, %r10
; X64-DFlyBSD-NEXT:    jmp .LBB1_2
;
; X64-MinGW-LABEL: test_nested:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    cmpq %gs:40, %rsp
; X64-MinGW-NEXT:    jbe .LBB1_1
; X64-MinGW-NEXT:  .LBB1_2:
; X64-MinGW-NEXT:    pushq %rsi
; X64-MinGW-NEXT:    .seh_pushreg %rsi
; X64-MinGW-NEXT:    subq $80, %rsp
; X64-MinGW-NEXT:    .seh_stackalloc 80
; X64-MinGW-NEXT:    .seh_endprologue
; X64-MinGW-NEXT:    movl %ecx, %esi
; X64-MinGW-NEXT:    addl (%r10), %esi
; X64-MinGW-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-MinGW-NEXT:    movl $10, %edx
; X64-MinGW-NEXT:    callq dummy_use
; X64-MinGW-NEXT:    movl %esi, %eax
; X64-MinGW-NEXT:    .seh_startepilogue
; X64-MinGW-NEXT:    addq $80, %rsp
; X64-MinGW-NEXT:    popq %rsi
; X64-MinGW-NEXT:    .seh_endepilogue
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:  .LBB1_1:
; X64-MinGW-NEXT:    movq %r10, %rax
; X64-MinGW-NEXT:    movl $88, %r10d
; X64-MinGW-NEXT:    movl $32, %r11d
; X64-MinGW-NEXT:    callq __morestack
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:    movq %rax, %r10
; X64-MinGW-NEXT:    jmp .LBB1_2
; X64-MinGW-NEXT:    .seh_endproc
       %addend = load i32 , ptr %closure
       %result = add i32 %other, %addend
       %mem = alloca i32, i32 10
       call void @dummy_use (ptr %mem, i32 10)
       ret i32 %result
}

define void @test_large() #0 {
; X86-Linux-LABEL: test_large:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    leal -{{[0-9]+}}(%esp), %ecx
; X86-Linux-NEXT:    cmpl %gs:48, %ecx
; X86-Linux-NEXT:    jbe .LBB2_1
; X86-Linux-NEXT:  .LBB2_2:
; X86-Linux-NEXT:    subl $40020, %esp # imm = 0x9C54
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 40020
; X86-Linux-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Linux-NEXT:    pushl $3
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    pushl %eax
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    calll dummy_use@PLT
; X86-Linux-NEXT:    addl $40028, %esp # imm = 0x9C5C
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset -40028
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:  .LBB2_1:
; X86-Linux-NEXT:    pushl $0
; X86-Linux-NEXT:    pushl $40012 # imm = 0x9C4C
; X86-Linux-NEXT:    calll __morestack
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:    jmp .LBB2_2
;
; X64-Linux-LABEL: test_large:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-Linux-NEXT:    cmpq %fs:112, %r11
; X64-Linux-NEXT:    jbe .LBB2_1
; X64-Linux-NEXT:  .LBB2_2:
; X64-Linux-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-Linux-NEXT:    .cfi_def_cfa_offset 40016
; X64-Linux-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Linux-NEXT:    movl $3, %esi
; X64-Linux-NEXT:    callq dummy_use@PLT
; X64-Linux-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-Linux-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:  .LBB2_1:
; X64-Linux-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-Linux-NEXT:    movl $0, %r11d
; X64-Linux-NEXT:    callq __morestack
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:    jmp .LBB2_2
;
; X64-Linux-Large-LABEL: test_large:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-Linux-Large-NEXT:    cmpq %fs:112, %r11
; X64-Linux-Large-NEXT:    jbe .LBB2_1
; X64-Linux-Large-NEXT:  .LBB2_2:
; X64-Linux-Large-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 40016
; X64-Linux-Large-NEXT:    movabsq $dummy_use, %rax
; X64-Linux-Large-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Linux-Large-NEXT:    movl $3, %esi
; X64-Linux-Large-NEXT:    callq *%rax
; X64-Linux-Large-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:  .LBB2_1:
; X64-Linux-Large-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-Linux-Large-NEXT:    movl $0, %r11d
; X64-Linux-Large-NEXT:    callq *__morestack_addr(%rip)
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:    jmp .LBB2_2
;
; X32ABI-LABEL: test_large:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    leal -{{[0-9]+}}(%rsp), %r11d
; X32ABI-NEXT:    cmpl %fs:64, %r11d
; X32ABI-NEXT:    jbe .LBB2_1
; X32ABI-NEXT:  .LBB2_2:
; X32ABI-NEXT:    subl $40008, %esp # imm = 0x9C48
; X32ABI-NEXT:    .cfi_def_cfa_offset 40016
; X32ABI-NEXT:    leal {{[0-9]+}}(%rsp), %edi
; X32ABI-NEXT:    movl $3, %esi
; X32ABI-NEXT:    callq dummy_use@PLT
; X32ABI-NEXT:    addl $40008, %esp # imm = 0x9C48
; X32ABI-NEXT:    .cfi_def_cfa_offset 8
; X32ABI-NEXT:    retq
; X32ABI-NEXT:  .LBB2_1:
; X32ABI-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X32ABI-NEXT:    movl $0, %r11d
; X32ABI-NEXT:    callq __morestack
; X32ABI-NEXT:    retq
; X32ABI-NEXT:    jmp .LBB2_2
;
; X86-Darwin-LABEL: test_large:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    leal -{{[0-9]+}}(%esp), %ecx
; X86-Darwin-NEXT:    movl $432, %eax ## imm = 0x1B0
; X86-Darwin-NEXT:    cmpl %gs:(%eax), %ecx
; X86-Darwin-NEXT:    jbe LBB2_1
; X86-Darwin-NEXT:  LBB2_2:
; X86-Darwin-NEXT:    subl $40012, %esp ## imm = 0x9C4C
; X86-Darwin-NEXT:    .cfi_def_cfa_offset 40016
; X86-Darwin-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Darwin-NEXT:    movl %eax, (%esp)
; X86-Darwin-NEXT:    movl $3, {{[0-9]+}}(%esp)
; X86-Darwin-NEXT:    calll _dummy_use
; X86-Darwin-NEXT:    addl $40012, %esp ## imm = 0x9C4C
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:  LBB2_1:
; X86-Darwin-NEXT:    pushl $0
; X86-Darwin-NEXT:    pushl $40012 ## imm = 0x9C4C
; X86-Darwin-NEXT:    calll ___morestack
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:    jmp LBB2_2
;
; X64-Darwin-LABEL: test_large:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-Darwin-NEXT:    cmpq %gs:816, %r11
; X64-Darwin-NEXT:    jbe LBB2_1
; X64-Darwin-NEXT:  LBB2_2:
; X64-Darwin-NEXT:    subq $40008, %rsp ## imm = 0x9C48
; X64-Darwin-NEXT:    .cfi_def_cfa_offset 40016
; X64-Darwin-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Darwin-NEXT:    movl $3, %esi
; X64-Darwin-NEXT:    callq _dummy_use
; X64-Darwin-NEXT:    addq $40008, %rsp ## imm = 0x9C48
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:  LBB2_1:
; X64-Darwin-NEXT:    movl $40008, %r10d ## imm = 0x9C48
; X64-Darwin-NEXT:    movl $0, %r11d
; X64-Darwin-NEXT:    callq ___morestack
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:    jmp LBB2_2
;
; X86-MinGW-LABEL: test_large:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    leal -{{[0-9]+}}(%esp), %ecx
; X86-MinGW-NEXT:    cmpl %fs:20, %ecx
; X86-MinGW-NEXT:    jbe LBB2_1
; X86-MinGW-NEXT:  LBB2_2:
; X86-MinGW-NEXT:    movl $40000, %eax # imm = 0x9C40
; X86-MinGW-NEXT:    calll __alloca
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 40004
; X86-MinGW-NEXT:    movl %esp, %eax
; X86-MinGW-NEXT:    pushl $3
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    pushl %eax
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    calll _dummy_use
; X86-MinGW-NEXT:    addl $40008, %esp # imm = 0x9C48
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset -40008
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:  LBB2_1:
; X86-MinGW-NEXT:    pushl $0
; X86-MinGW-NEXT:    pushl $40000 # imm = 0x9C40
; X86-MinGW-NEXT:    calll ___morestack
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:    jmp LBB2_2
;
; X64-FreeBSD-LABEL: test_large:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-FreeBSD-NEXT:    cmpq %fs:24, %r11
; X64-FreeBSD-NEXT:    jbe .LBB2_1
; X64-FreeBSD-NEXT:  .LBB2_2:
; X64-FreeBSD-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 40016
; X64-FreeBSD-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-FreeBSD-NEXT:    movl $3, %esi
; X64-FreeBSD-NEXT:    callq dummy_use@PLT
; X64-FreeBSD-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:  .LBB2_1:
; X64-FreeBSD-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-FreeBSD-NEXT:    movl $0, %r11d
; X64-FreeBSD-NEXT:    callq __morestack
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:    jmp .LBB2_2
;
; X86-DFlyBSD-LABEL: test_large:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    leal -{{[0-9]+}}(%esp), %ecx
; X86-DFlyBSD-NEXT:    cmpl %fs:16, %ecx
; X86-DFlyBSD-NEXT:    jbe .LBB2_1
; X86-DFlyBSD-NEXT:  .LBB2_2:
; X86-DFlyBSD-NEXT:    subl $40000, %esp # imm = 0x9C40
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 40004
; X86-DFlyBSD-NEXT:    movl %esp, %eax
; X86-DFlyBSD-NEXT:    pushl $3
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    pushl %eax
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    calll dummy_use@PLT
; X86-DFlyBSD-NEXT:    addl $40008, %esp # imm = 0x9C48
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset -40008
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:  .LBB2_1:
; X86-DFlyBSD-NEXT:    pushl $0
; X86-DFlyBSD-NEXT:    pushl $40000 # imm = 0x9C40
; X86-DFlyBSD-NEXT:    calll __morestack
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:    jmp .LBB2_2
;
; X64-DFlyBSD-LABEL: test_large:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-DFlyBSD-NEXT:    cmpq %fs:32, %r11
; X64-DFlyBSD-NEXT:    jbe .LBB2_1
; X64-DFlyBSD-NEXT:  .LBB2_2:
; X64-DFlyBSD-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 40016
; X64-DFlyBSD-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-DFlyBSD-NEXT:    movl $3, %esi
; X64-DFlyBSD-NEXT:    callq dummy_use@PLT
; X64-DFlyBSD-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:  .LBB2_1:
; X64-DFlyBSD-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-DFlyBSD-NEXT:    movl $0, %r11d
; X64-DFlyBSD-NEXT:    callq __morestack
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:    jmp .LBB2_2
;
; X64-MinGW-LABEL: test_large:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-MinGW-NEXT:    cmpq %gs:40, %r11
; X64-MinGW-NEXT:    jbe .LBB2_1
; X64-MinGW-NEXT:  .LBB2_2:
; X64-MinGW-NEXT:    movl $40040, %eax # imm = 0x9C68
; X64-MinGW-NEXT:    callq ___chkstk_ms
; X64-MinGW-NEXT:    subq %rax, %rsp
; X64-MinGW-NEXT:    .seh_stackalloc 40040
; X64-MinGW-NEXT:    .seh_endprologue
; X64-MinGW-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-MinGW-NEXT:    movl $3, %edx
; X64-MinGW-NEXT:    callq dummy_use
; X64-MinGW-NEXT:    nop
; X64-MinGW-NEXT:    .seh_startepilogue
; X64-MinGW-NEXT:    addq $40040, %rsp # imm = 0x9C68
; X64-MinGW-NEXT:    .seh_endepilogue
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:  .LBB2_1:
; X64-MinGW-NEXT:    movl $40040, %r10d # imm = 0x9C68
; X64-MinGW-NEXT:    movl $32, %r11d
; X64-MinGW-NEXT:    callq __morestack
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:    jmp .LBB2_2
; X64-MinGW-NEXT:    .seh_endproc
        %mem = alloca i32, i32 10000
        call void @dummy_use (ptr %mem, i32 3)
        ret void
}

define fastcc void @test_fastcc() #0 {
; X86-Linux-LABEL: test_fastcc:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    cmpl %gs:48, %esp
; X86-Linux-NEXT:    jbe .LBB3_1
; X86-Linux-NEXT:  .LBB3_2:
; X86-Linux-NEXT:    subl $52, %esp
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 52
; X86-Linux-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Linux-NEXT:    pushl $10
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    pushl %eax
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    calll dummy_use@PLT
; X86-Linux-NEXT:    addl $60, %esp
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset -60
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:  .LBB3_1:
; X86-Linux-NEXT:    pushl $0
; X86-Linux-NEXT:    pushl $44
; X86-Linux-NEXT:    calll __morestack
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:    jmp .LBB3_2
;
; X64-Linux-LABEL: test_fastcc:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-NEXT:    jbe .LBB3_1
; X64-Linux-NEXT:  .LBB3_2:
; X64-Linux-NEXT:    subq $40, %rsp
; X64-Linux-NEXT:    .cfi_def_cfa_offset 48
; X64-Linux-NEXT:    movq %rsp, %rdi
; X64-Linux-NEXT:    movl $10, %esi
; X64-Linux-NEXT:    callq dummy_use@PLT
; X64-Linux-NEXT:    addq $40, %rsp
; X64-Linux-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:  .LBB3_1:
; X64-Linux-NEXT:    movl $40, %r10d
; X64-Linux-NEXT:    movl $0, %r11d
; X64-Linux-NEXT:    callq __morestack
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:    jmp .LBB3_2
;
; X64-Linux-Large-LABEL: test_fastcc:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-Large-NEXT:    jbe .LBB3_1
; X64-Linux-Large-NEXT:  .LBB3_2:
; X64-Linux-Large-NEXT:    subq $40, %rsp
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 48
; X64-Linux-Large-NEXT:    movabsq $dummy_use, %rax
; X64-Linux-Large-NEXT:    movq %rsp, %rdi
; X64-Linux-Large-NEXT:    movl $10, %esi
; X64-Linux-Large-NEXT:    callq *%rax
; X64-Linux-Large-NEXT:    addq $40, %rsp
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:  .LBB3_1:
; X64-Linux-Large-NEXT:    movl $40, %r10d
; X64-Linux-Large-NEXT:    movl $0, %r11d
; X64-Linux-Large-NEXT:    callq *__morestack_addr(%rip)
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:    jmp .LBB3_2
;
; X32ABI-LABEL: test_fastcc:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    cmpl %fs:64, %esp
; X32ABI-NEXT:    jbe .LBB3_1
; X32ABI-NEXT:  .LBB3_2:
; X32ABI-NEXT:    subl $40, %esp
; X32ABI-NEXT:    .cfi_def_cfa_offset 48
; X32ABI-NEXT:    movl %esp, %edi
; X32ABI-NEXT:    movl $10, %esi
; X32ABI-NEXT:    callq dummy_use@PLT
; X32ABI-NEXT:    addl $40, %esp
; X32ABI-NEXT:    .cfi_def_cfa_offset 8
; X32ABI-NEXT:    retq
; X32ABI-NEXT:  .LBB3_1:
; X32ABI-NEXT:    movl $40, %r10d
; X32ABI-NEXT:    movl $0, %r11d
; X32ABI-NEXT:    callq __morestack
; X32ABI-NEXT:    retq
; X32ABI-NEXT:    jmp .LBB3_2
;
; X86-Darwin-LABEL: test_fastcc:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    movl $432, %eax ## imm = 0x1B0
; X86-Darwin-NEXT:    cmpl %gs:(%eax), %esp
; X86-Darwin-NEXT:    jbe LBB3_1
; X86-Darwin-NEXT:  LBB3_2:
; X86-Darwin-NEXT:    subl $60, %esp
; X86-Darwin-NEXT:    .cfi_def_cfa_offset 64
; X86-Darwin-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Darwin-NEXT:    movl %eax, (%esp)
; X86-Darwin-NEXT:    movl $10, {{[0-9]+}}(%esp)
; X86-Darwin-NEXT:    calll _dummy_use
; X86-Darwin-NEXT:    addl $60, %esp
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:  LBB3_1:
; X86-Darwin-NEXT:    pushl $0
; X86-Darwin-NEXT:    pushl $60
; X86-Darwin-NEXT:    calll ___morestack
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:    jmp LBB3_2
;
; X64-Darwin-LABEL: test_fastcc:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    cmpq %gs:816, %rsp
; X64-Darwin-NEXT:    jbe LBB3_1
; X64-Darwin-NEXT:  LBB3_2:
; X64-Darwin-NEXT:    subq $40, %rsp
; X64-Darwin-NEXT:    .cfi_def_cfa_offset 48
; X64-Darwin-NEXT:    movq %rsp, %rdi
; X64-Darwin-NEXT:    movl $10, %esi
; X64-Darwin-NEXT:    callq _dummy_use
; X64-Darwin-NEXT:    addq $40, %rsp
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:  LBB3_1:
; X64-Darwin-NEXT:    movl $40, %r10d
; X64-Darwin-NEXT:    movl $0, %r11d
; X64-Darwin-NEXT:    callq ___morestack
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:    jmp LBB3_2
;
; X86-MinGW-LABEL: test_fastcc:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    cmpl %fs:20, %esp
; X86-MinGW-NEXT:    jbe LBB3_1
; X86-MinGW-NEXT:  LBB3_2:
; X86-MinGW-NEXT:    subl $40, %esp
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 44
; X86-MinGW-NEXT:    movl %esp, %eax
; X86-MinGW-NEXT:    pushl $10
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    pushl %eax
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    calll _dummy_use
; X86-MinGW-NEXT:    addl $48, %esp
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset -48
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:  LBB3_1:
; X86-MinGW-NEXT:    pushl $0
; X86-MinGW-NEXT:    pushl $40
; X86-MinGW-NEXT:    calll ___morestack
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:    jmp LBB3_2
;
; X64-FreeBSD-LABEL: test_fastcc:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    cmpq %fs:24, %rsp
; X64-FreeBSD-NEXT:    jbe .LBB3_1
; X64-FreeBSD-NEXT:  .LBB3_2:
; X64-FreeBSD-NEXT:    subq $40, %rsp
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 48
; X64-FreeBSD-NEXT:    movq %rsp, %rdi
; X64-FreeBSD-NEXT:    movl $10, %esi
; X64-FreeBSD-NEXT:    callq dummy_use@PLT
; X64-FreeBSD-NEXT:    addq $40, %rsp
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:  .LBB3_1:
; X64-FreeBSD-NEXT:    movl $40, %r10d
; X64-FreeBSD-NEXT:    movl $0, %r11d
; X64-FreeBSD-NEXT:    callq __morestack
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:    jmp .LBB3_2
;
; X86-DFlyBSD-LABEL: test_fastcc:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    cmpl %fs:16, %esp
; X86-DFlyBSD-NEXT:    jbe .LBB3_1
; X86-DFlyBSD-NEXT:  .LBB3_2:
; X86-DFlyBSD-NEXT:    subl $40, %esp
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 44
; X86-DFlyBSD-NEXT:    movl %esp, %eax
; X86-DFlyBSD-NEXT:    pushl $10
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    pushl %eax
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    calll dummy_use@PLT
; X86-DFlyBSD-NEXT:    addl $48, %esp
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset -48
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:  .LBB3_1:
; X86-DFlyBSD-NEXT:    pushl $0
; X86-DFlyBSD-NEXT:    pushl $40
; X86-DFlyBSD-NEXT:    calll __morestack
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:    jmp .LBB3_2
;
; X64-DFlyBSD-LABEL: test_fastcc:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    cmpq %fs:32, %rsp
; X64-DFlyBSD-NEXT:    jbe .LBB3_1
; X64-DFlyBSD-NEXT:  .LBB3_2:
; X64-DFlyBSD-NEXT:    subq $40, %rsp
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 48
; X64-DFlyBSD-NEXT:    movq %rsp, %rdi
; X64-DFlyBSD-NEXT:    movl $10, %esi
; X64-DFlyBSD-NEXT:    callq dummy_use@PLT
; X64-DFlyBSD-NEXT:    addq $40, %rsp
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:  .LBB3_1:
; X64-DFlyBSD-NEXT:    movl $40, %r10d
; X64-DFlyBSD-NEXT:    movl $0, %r11d
; X64-DFlyBSD-NEXT:    callq __morestack
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:    jmp .LBB3_2
;
; X64-MinGW-LABEL: test_fastcc:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    cmpq %gs:40, %rsp
; X64-MinGW-NEXT:    jbe .LBB3_1
; X64-MinGW-NEXT:  .LBB3_2:
; X64-MinGW-NEXT:    subq $72, %rsp
; X64-MinGW-NEXT:    .seh_stackalloc 72
; X64-MinGW-NEXT:    .seh_endprologue
; X64-MinGW-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-MinGW-NEXT:    movl $10, %edx
; X64-MinGW-NEXT:    callq dummy_use
; X64-MinGW-NEXT:    nop
; X64-MinGW-NEXT:    .seh_startepilogue
; X64-MinGW-NEXT:    addq $72, %rsp
; X64-MinGW-NEXT:    .seh_endepilogue
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:  .LBB3_1:
; X64-MinGW-NEXT:    movl $72, %r10d
; X64-MinGW-NEXT:    movl $32, %r11d
; X64-MinGW-NEXT:    callq __morestack
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:    jmp .LBB3_2
; X64-MinGW-NEXT:    .seh_endproc
        %mem = alloca i32, i32 10
        call void @dummy_use (ptr %mem, i32 10)
        ret void
}

define fastcc void @test_fastcc_large() #0 {
; X86-Linux-LABEL: test_fastcc_large:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    leal -{{[0-9]+}}(%esp), %eax
; X86-Linux-NEXT:    cmpl %gs:48, %eax
; X86-Linux-NEXT:    jbe .LBB4_1
; X86-Linux-NEXT:  .LBB4_2:
; X86-Linux-NEXT:    subl $40020, %esp # imm = 0x9C54
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 40020
; X86-Linux-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Linux-NEXT:    pushl $3
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    pushl %eax
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    calll dummy_use@PLT
; X86-Linux-NEXT:    addl $40028, %esp # imm = 0x9C5C
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset -40028
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:  .LBB4_1:
; X86-Linux-NEXT:    pushl $0
; X86-Linux-NEXT:    pushl $40012 # imm = 0x9C4C
; X86-Linux-NEXT:    calll __morestack
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:    jmp .LBB4_2
;
; X64-Linux-LABEL: test_fastcc_large:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-Linux-NEXT:    cmpq %fs:112, %r11
; X64-Linux-NEXT:    jbe .LBB4_1
; X64-Linux-NEXT:  .LBB4_2:
; X64-Linux-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-Linux-NEXT:    .cfi_def_cfa_offset 40016
; X64-Linux-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Linux-NEXT:    movl $3, %esi
; X64-Linux-NEXT:    callq dummy_use@PLT
; X64-Linux-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-Linux-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:  .LBB4_1:
; X64-Linux-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-Linux-NEXT:    movl $0, %r11d
; X64-Linux-NEXT:    callq __morestack
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:    jmp .LBB4_2
;
; X64-Linux-Large-LABEL: test_fastcc_large:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-Linux-Large-NEXT:    cmpq %fs:112, %r11
; X64-Linux-Large-NEXT:    jbe .LBB4_1
; X64-Linux-Large-NEXT:  .LBB4_2:
; X64-Linux-Large-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 40016
; X64-Linux-Large-NEXT:    movabsq $dummy_use, %rax
; X64-Linux-Large-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Linux-Large-NEXT:    movl $3, %esi
; X64-Linux-Large-NEXT:    callq *%rax
; X64-Linux-Large-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:  .LBB4_1:
; X64-Linux-Large-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-Linux-Large-NEXT:    movl $0, %r11d
; X64-Linux-Large-NEXT:    callq *__morestack_addr(%rip)
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:    jmp .LBB4_2
;
; X32ABI-LABEL: test_fastcc_large:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    leal -{{[0-9]+}}(%rsp), %r11d
; X32ABI-NEXT:    cmpl %fs:64, %r11d
; X32ABI-NEXT:    jbe .LBB4_1
; X32ABI-NEXT:  .LBB4_2:
; X32ABI-NEXT:    subl $40008, %esp # imm = 0x9C48
; X32ABI-NEXT:    .cfi_def_cfa_offset 40016
; X32ABI-NEXT:    leal {{[0-9]+}}(%rsp), %edi
; X32ABI-NEXT:    movl $3, %esi
; X32ABI-NEXT:    callq dummy_use@PLT
; X32ABI-NEXT:    addl $40008, %esp # imm = 0x9C48
; X32ABI-NEXT:    .cfi_def_cfa_offset 8
; X32ABI-NEXT:    retq
; X32ABI-NEXT:  .LBB4_1:
; X32ABI-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X32ABI-NEXT:    movl $0, %r11d
; X32ABI-NEXT:    callq __morestack
; X32ABI-NEXT:    retq
; X32ABI-NEXT:    jmp .LBB4_2
;
; X86-Darwin-LABEL: test_fastcc_large:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    leal -{{[0-9]+}}(%esp), %eax
; X86-Darwin-NEXT:    movl $432, %ecx ## imm = 0x1B0
; X86-Darwin-NEXT:    cmpl %gs:(%ecx), %eax
; X86-Darwin-NEXT:    jbe LBB4_1
; X86-Darwin-NEXT:  LBB4_2:
; X86-Darwin-NEXT:    subl $40012, %esp ## imm = 0x9C4C
; X86-Darwin-NEXT:    .cfi_def_cfa_offset 40016
; X86-Darwin-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Darwin-NEXT:    movl %eax, (%esp)
; X86-Darwin-NEXT:    movl $3, {{[0-9]+}}(%esp)
; X86-Darwin-NEXT:    calll _dummy_use
; X86-Darwin-NEXT:    addl $40012, %esp ## imm = 0x9C4C
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:  LBB4_1:
; X86-Darwin-NEXT:    pushl $0
; X86-Darwin-NEXT:    pushl $40012 ## imm = 0x9C4C
; X86-Darwin-NEXT:    calll ___morestack
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:    jmp LBB4_2
;
; X64-Darwin-LABEL: test_fastcc_large:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-Darwin-NEXT:    cmpq %gs:816, %r11
; X64-Darwin-NEXT:    jbe LBB4_1
; X64-Darwin-NEXT:  LBB4_2:
; X64-Darwin-NEXT:    subq $40008, %rsp ## imm = 0x9C48
; X64-Darwin-NEXT:    .cfi_def_cfa_offset 40016
; X64-Darwin-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Darwin-NEXT:    movl $3, %esi
; X64-Darwin-NEXT:    callq _dummy_use
; X64-Darwin-NEXT:    addq $40008, %rsp ## imm = 0x9C48
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:  LBB4_1:
; X64-Darwin-NEXT:    movl $40008, %r10d ## imm = 0x9C48
; X64-Darwin-NEXT:    movl $0, %r11d
; X64-Darwin-NEXT:    callq ___morestack
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:    jmp LBB4_2
;
; X86-MinGW-LABEL: test_fastcc_large:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    leal -{{[0-9]+}}(%esp), %eax
; X86-MinGW-NEXT:    cmpl %fs:20, %eax
; X86-MinGW-NEXT:    jbe LBB4_1
; X86-MinGW-NEXT:  LBB4_2:
; X86-MinGW-NEXT:    movl $40000, %eax # imm = 0x9C40
; X86-MinGW-NEXT:    calll __alloca
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 40004
; X86-MinGW-NEXT:    movl %esp, %eax
; X86-MinGW-NEXT:    pushl $3
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    pushl %eax
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    calll _dummy_use
; X86-MinGW-NEXT:    addl $40008, %esp # imm = 0x9C48
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset -40008
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:  LBB4_1:
; X86-MinGW-NEXT:    pushl $0
; X86-MinGW-NEXT:    pushl $40000 # imm = 0x9C40
; X86-MinGW-NEXT:    calll ___morestack
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:    jmp LBB4_2
;
; X64-FreeBSD-LABEL: test_fastcc_large:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-FreeBSD-NEXT:    cmpq %fs:24, %r11
; X64-FreeBSD-NEXT:    jbe .LBB4_1
; X64-FreeBSD-NEXT:  .LBB4_2:
; X64-FreeBSD-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 40016
; X64-FreeBSD-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-FreeBSD-NEXT:    movl $3, %esi
; X64-FreeBSD-NEXT:    callq dummy_use@PLT
; X64-FreeBSD-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:  .LBB4_1:
; X64-FreeBSD-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-FreeBSD-NEXT:    movl $0, %r11d
; X64-FreeBSD-NEXT:    callq __morestack
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:    jmp .LBB4_2
;
; X86-DFlyBSD-LABEL: test_fastcc_large:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    leal -{{[0-9]+}}(%esp), %eax
; X86-DFlyBSD-NEXT:    cmpl %fs:16, %eax
; X86-DFlyBSD-NEXT:    jbe .LBB4_1
; X86-DFlyBSD-NEXT:  .LBB4_2:
; X86-DFlyBSD-NEXT:    subl $40000, %esp # imm = 0x9C40
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 40004
; X86-DFlyBSD-NEXT:    movl %esp, %eax
; X86-DFlyBSD-NEXT:    pushl $3
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    pushl %eax
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    calll dummy_use@PLT
; X86-DFlyBSD-NEXT:    addl $40008, %esp # imm = 0x9C48
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset -40008
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:  .LBB4_1:
; X86-DFlyBSD-NEXT:    pushl $0
; X86-DFlyBSD-NEXT:    pushl $40000 # imm = 0x9C40
; X86-DFlyBSD-NEXT:    calll __morestack
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:    jmp .LBB4_2
;
; X64-DFlyBSD-LABEL: test_fastcc_large:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-DFlyBSD-NEXT:    cmpq %fs:32, %r11
; X64-DFlyBSD-NEXT:    jbe .LBB4_1
; X64-DFlyBSD-NEXT:  .LBB4_2:
; X64-DFlyBSD-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 40016
; X64-DFlyBSD-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-DFlyBSD-NEXT:    movl $3, %esi
; X64-DFlyBSD-NEXT:    callq dummy_use@PLT
; X64-DFlyBSD-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:  .LBB4_1:
; X64-DFlyBSD-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-DFlyBSD-NEXT:    movl $0, %r11d
; X64-DFlyBSD-NEXT:    callq __morestack
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:    jmp .LBB4_2
;
; X64-MinGW-LABEL: test_fastcc_large:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-MinGW-NEXT:    cmpq %gs:40, %r11
; X64-MinGW-NEXT:    jbe .LBB4_1
; X64-MinGW-NEXT:  .LBB4_2:
; X64-MinGW-NEXT:    movl $40040, %eax # imm = 0x9C68
; X64-MinGW-NEXT:    callq ___chkstk_ms
; X64-MinGW-NEXT:    subq %rax, %rsp
; X64-MinGW-NEXT:    .seh_stackalloc 40040
; X64-MinGW-NEXT:    .seh_endprologue
; X64-MinGW-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-MinGW-NEXT:    movl $3, %edx
; X64-MinGW-NEXT:    callq dummy_use
; X64-MinGW-NEXT:    nop
; X64-MinGW-NEXT:    .seh_startepilogue
; X64-MinGW-NEXT:    addq $40040, %rsp # imm = 0x9C68
; X64-MinGW-NEXT:    .seh_endepilogue
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:  .LBB4_1:
; X64-MinGW-NEXT:    movl $40040, %r10d # imm = 0x9C68
; X64-MinGW-NEXT:    movl $32, %r11d
; X64-MinGW-NEXT:    callq __morestack
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:    jmp .LBB4_2
; X64-MinGW-NEXT:    .seh_endproc
        %mem = alloca i32, i32 10000
        call void @dummy_use (ptr %mem, i32 3)
        ret void
}

; This is testing that the Mac implementation preserves ecx

define fastcc void @test_fastcc_large_with_ecx_arg(i32 %a) #0 {
; X86-Linux-LABEL: test_fastcc_large_with_ecx_arg:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    leal -{{[0-9]+}}(%esp), %eax
; X86-Linux-NEXT:    cmpl %gs:48, %eax
; X86-Linux-NEXT:    jbe .LBB5_1
; X86-Linux-NEXT:  .LBB5_2:
; X86-Linux-NEXT:    subl $40020, %esp # imm = 0x9C54
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 40020
; X86-Linux-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Linux-NEXT:    pushl %ecx
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    pushl %eax
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    calll dummy_use@PLT
; X86-Linux-NEXT:    addl $40028, %esp # imm = 0x9C5C
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset -40028
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:  .LBB5_1:
; X86-Linux-NEXT:    pushl $0
; X86-Linux-NEXT:    pushl $40012 # imm = 0x9C4C
; X86-Linux-NEXT:    calll __morestack
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:    jmp .LBB5_2
;
; X64-Linux-LABEL: test_fastcc_large_with_ecx_arg:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-Linux-NEXT:    cmpq %fs:112, %r11
; X64-Linux-NEXT:    jbe .LBB5_1
; X64-Linux-NEXT:  .LBB5_2:
; X64-Linux-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-Linux-NEXT:    .cfi_def_cfa_offset 40016
; X64-Linux-NEXT:    movl %edi, %esi
; X64-Linux-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Linux-NEXT:    callq dummy_use@PLT
; X64-Linux-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-Linux-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:  .LBB5_1:
; X64-Linux-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-Linux-NEXT:    movl $0, %r11d
; X64-Linux-NEXT:    callq __morestack
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:    jmp .LBB5_2
;
; X64-Linux-Large-LABEL: test_fastcc_large_with_ecx_arg:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-Linux-Large-NEXT:    cmpq %fs:112, %r11
; X64-Linux-Large-NEXT:    jbe .LBB5_1
; X64-Linux-Large-NEXT:  .LBB5_2:
; X64-Linux-Large-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 40016
; X64-Linux-Large-NEXT:    movl %edi, %esi
; X64-Linux-Large-NEXT:    movabsq $dummy_use, %rax
; X64-Linux-Large-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Linux-Large-NEXT:    callq *%rax
; X64-Linux-Large-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:  .LBB5_1:
; X64-Linux-Large-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-Linux-Large-NEXT:    movl $0, %r11d
; X64-Linux-Large-NEXT:    callq *__morestack_addr(%rip)
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:    jmp .LBB5_2
;
; X32ABI-LABEL: test_fastcc_large_with_ecx_arg:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    leal -{{[0-9]+}}(%rsp), %r11d
; X32ABI-NEXT:    cmpl %fs:64, %r11d
; X32ABI-NEXT:    jbe .LBB5_1
; X32ABI-NEXT:  .LBB5_2:
; X32ABI-NEXT:    subl $40008, %esp # imm = 0x9C48
; X32ABI-NEXT:    .cfi_def_cfa_offset 40016
; X32ABI-NEXT:    movl %edi, %esi
; X32ABI-NEXT:    leal {{[0-9]+}}(%rsp), %edi
; X32ABI-NEXT:    callq dummy_use@PLT
; X32ABI-NEXT:    addl $40008, %esp # imm = 0x9C48
; X32ABI-NEXT:    .cfi_def_cfa_offset 8
; X32ABI-NEXT:    retq
; X32ABI-NEXT:  .LBB5_1:
; X32ABI-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X32ABI-NEXT:    movl $0, %r11d
; X32ABI-NEXT:    callq __morestack
; X32ABI-NEXT:    retq
; X32ABI-NEXT:    jmp .LBB5_2
;
; X86-Darwin-LABEL: test_fastcc_large_with_ecx_arg:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    leal -{{[0-9]+}}(%esp), %eax
; X86-Darwin-NEXT:    pushl %ecx
; X86-Darwin-NEXT:    movl $432, %ecx ## imm = 0x1B0
; X86-Darwin-NEXT:    cmpl %gs:(%ecx), %eax
; X86-Darwin-NEXT:    popl %ecx
; X86-Darwin-NEXT:    jbe LBB5_1
; X86-Darwin-NEXT:  LBB5_2:
; X86-Darwin-NEXT:    subl $40012, %esp ## imm = 0x9C4C
; X86-Darwin-NEXT:    .cfi_def_cfa_offset 40016
; X86-Darwin-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-Darwin-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Darwin-NEXT:    movl %eax, (%esp)
; X86-Darwin-NEXT:    calll _dummy_use
; X86-Darwin-NEXT:    addl $40012, %esp ## imm = 0x9C4C
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:  LBB5_1:
; X86-Darwin-NEXT:    pushl $0
; X86-Darwin-NEXT:    pushl $40012 ## imm = 0x9C4C
; X86-Darwin-NEXT:    calll ___morestack
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:    jmp LBB5_2
;
; X64-Darwin-LABEL: test_fastcc_large_with_ecx_arg:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-Darwin-NEXT:    cmpq %gs:816, %r11
; X64-Darwin-NEXT:    jbe LBB5_1
; X64-Darwin-NEXT:  LBB5_2:
; X64-Darwin-NEXT:    subq $40008, %rsp ## imm = 0x9C48
; X64-Darwin-NEXT:    .cfi_def_cfa_offset 40016
; X64-Darwin-NEXT:    movl %edi, %esi
; X64-Darwin-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-Darwin-NEXT:    callq _dummy_use
; X64-Darwin-NEXT:    addq $40008, %rsp ## imm = 0x9C48
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:  LBB5_1:
; X64-Darwin-NEXT:    movl $40008, %r10d ## imm = 0x9C48
; X64-Darwin-NEXT:    movl $0, %r11d
; X64-Darwin-NEXT:    callq ___morestack
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:    jmp LBB5_2
;
; X86-MinGW-LABEL: test_fastcc_large_with_ecx_arg:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    leal -{{[0-9]+}}(%esp), %eax
; X86-MinGW-NEXT:    cmpl %fs:20, %eax
; X86-MinGW-NEXT:    jbe LBB5_1
; X86-MinGW-NEXT:  LBB5_2:
; X86-MinGW-NEXT:    movl $40000, %eax # imm = 0x9C40
; X86-MinGW-NEXT:    calll __alloca
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 40004
; X86-MinGW-NEXT:    movl %esp, %eax
; X86-MinGW-NEXT:    pushl %ecx
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    pushl %eax
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    calll _dummy_use
; X86-MinGW-NEXT:    addl $40008, %esp # imm = 0x9C48
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset -40008
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:  LBB5_1:
; X86-MinGW-NEXT:    pushl $0
; X86-MinGW-NEXT:    pushl $40000 # imm = 0x9C40
; X86-MinGW-NEXT:    calll ___morestack
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:    jmp LBB5_2
;
; X64-FreeBSD-LABEL: test_fastcc_large_with_ecx_arg:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-FreeBSD-NEXT:    cmpq %fs:24, %r11
; X64-FreeBSD-NEXT:    jbe .LBB5_1
; X64-FreeBSD-NEXT:  .LBB5_2:
; X64-FreeBSD-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 40016
; X64-FreeBSD-NEXT:    movl %edi, %esi
; X64-FreeBSD-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-FreeBSD-NEXT:    callq dummy_use@PLT
; X64-FreeBSD-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:  .LBB5_1:
; X64-FreeBSD-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-FreeBSD-NEXT:    movl $0, %r11d
; X64-FreeBSD-NEXT:    callq __morestack
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:    jmp .LBB5_2
;
; X86-DFlyBSD-LABEL: test_fastcc_large_with_ecx_arg:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    leal -{{[0-9]+}}(%esp), %eax
; X86-DFlyBSD-NEXT:    cmpl %fs:16, %eax
; X86-DFlyBSD-NEXT:    jbe .LBB5_1
; X86-DFlyBSD-NEXT:  .LBB5_2:
; X86-DFlyBSD-NEXT:    subl $40000, %esp # imm = 0x9C40
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 40004
; X86-DFlyBSD-NEXT:    movl %esp, %eax
; X86-DFlyBSD-NEXT:    pushl %ecx
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    pushl %eax
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    calll dummy_use@PLT
; X86-DFlyBSD-NEXT:    addl $40008, %esp # imm = 0x9C48
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset -40008
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:  .LBB5_1:
; X86-DFlyBSD-NEXT:    pushl $0
; X86-DFlyBSD-NEXT:    pushl $40000 # imm = 0x9C40
; X86-DFlyBSD-NEXT:    calll __morestack
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:    jmp .LBB5_2
;
; X64-DFlyBSD-LABEL: test_fastcc_large_with_ecx_arg:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-DFlyBSD-NEXT:    cmpq %fs:32, %r11
; X64-DFlyBSD-NEXT:    jbe .LBB5_1
; X64-DFlyBSD-NEXT:  .LBB5_2:
; X64-DFlyBSD-NEXT:    subq $40008, %rsp # imm = 0x9C48
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 40016
; X64-DFlyBSD-NEXT:    movl %edi, %esi
; X64-DFlyBSD-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-DFlyBSD-NEXT:    callq dummy_use@PLT
; X64-DFlyBSD-NEXT:    addq $40008, %rsp # imm = 0x9C48
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:  .LBB5_1:
; X64-DFlyBSD-NEXT:    movl $40008, %r10d # imm = 0x9C48
; X64-DFlyBSD-NEXT:    movl $0, %r11d
; X64-DFlyBSD-NEXT:    callq __morestack
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:    jmp .LBB5_2
;
; X64-MinGW-LABEL: test_fastcc_large_with_ecx_arg:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    leaq -{{[0-9]+}}(%rsp), %r11
; X64-MinGW-NEXT:    cmpq %gs:40, %r11
; X64-MinGW-NEXT:    jbe .LBB5_1
; X64-MinGW-NEXT:  .LBB5_2:
; X64-MinGW-NEXT:    movl $40040, %eax # imm = 0x9C68
; X64-MinGW-NEXT:    callq ___chkstk_ms
; X64-MinGW-NEXT:    subq %rax, %rsp
; X64-MinGW-NEXT:    .seh_stackalloc 40040
; X64-MinGW-NEXT:    .seh_endprologue
; X64-MinGW-NEXT:    movl %ecx, %edx
; X64-MinGW-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-MinGW-NEXT:    callq dummy_use
; X64-MinGW-NEXT:    nop
; X64-MinGW-NEXT:    .seh_startepilogue
; X64-MinGW-NEXT:    addq $40040, %rsp # imm = 0x9C68
; X64-MinGW-NEXT:    .seh_endepilogue
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:  .LBB5_1:
; X64-MinGW-NEXT:    movl $40040, %r10d # imm = 0x9C68
; X64-MinGW-NEXT:    movl $32, %r11d
; X64-MinGW-NEXT:    callq __morestack
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:    jmp .LBB5_2
; X64-MinGW-NEXT:    .seh_endproc
        %mem = alloca i32, i32 10000
        call void @dummy_use (ptr %mem, i32 %a)
        ret void
}

define void @test_nostack() #0 {
; X86-Linux-LABEL: test_nostack:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    retl
;
; X64-Linux-LABEL: test_nostack:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    retq
;
; X64-Linux-Large-LABEL: test_nostack:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    retq
;
; X32ABI-LABEL: test_nostack:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    retq
;
; X86-Darwin-LABEL: test_nostack:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    retl
;
; X64-Darwin-LABEL: test_nostack:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    retq
;
; X86-MinGW-LABEL: test_nostack:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    retl
;
; X64-FreeBSD-LABEL: test_nostack:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    retq
;
; X86-DFlyBSD-LABEL: test_nostack:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    retl
;
; X64-DFlyBSD-LABEL: test_nostack:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    retq
;
; X64-MinGW-LABEL: test_nostack:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    retq
	ret void
}

define void @test_nosplitstck() {
; X86-Linux-LABEL: test_nosplitstck:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    retl
;
; X64-Linux-LABEL: test_nosplitstck:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    retq
;
; X64-Linux-Large-LABEL: test_nosplitstck:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    retq
;
; X32ABI-LABEL: test_nosplitstck:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    retq
;
; X86-Darwin-LABEL: test_nosplitstck:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    retl
;
; X64-Darwin-LABEL: test_nosplitstck:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    retq
;
; X86-MinGW-LABEL: test_nosplitstck:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    retl
;
; X64-FreeBSD-LABEL: test_nosplitstck:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    retq
;
; X86-DFlyBSD-LABEL: test_nosplitstck:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    retl
;
; X64-DFlyBSD-LABEL: test_nosplitstck:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    retq
;
; X64-MinGW-LABEL: test_nosplitstck:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    retq
	ret void
}

; Test to make sure that a morestack call is generated if there is a
; sibling call, even if the function in question has no stack frame
; (PR37807).

declare i32 @callee(i32)

define i32 @test_sibling_call_empty_frame(i32 %x) #0 {
; X86-Linux-LABEL: test_sibling_call_empty_frame:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    cmpl %gs:48, %esp
; X86-Linux-NEXT:    ja callee@PLT # TAILCALL
; X86-Linux-NEXT:  # %bb.1:
; X86-Linux-NEXT:    pushl $4
; X86-Linux-NEXT:    pushl $0
; X86-Linux-NEXT:    calll __morestack
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:    jmp callee@PLT # TAILCALL
;
; X64-Linux-LABEL: test_sibling_call_empty_frame:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-NEXT:    ja callee@PLT # TAILCALL
; X64-Linux-NEXT:  # %bb.1:
; X64-Linux-NEXT:    movl $0, %r10d
; X64-Linux-NEXT:    movl $0, %r11d
; X64-Linux-NEXT:    callq __morestack
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:    jmp callee@PLT # TAILCALL
;
; X64-Linux-Large-LABEL: test_sibling_call_empty_frame:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-Large-NEXT:    jbe .LBB8_1
; X64-Linux-Large-NEXT:  # %bb.2:
; X64-Linux-Large-NEXT:    movabsq $callee, %rax
; X64-Linux-Large-NEXT:    jmpq *%rax # TAILCALL
; X64-Linux-Large-NEXT:  .LBB8_1:
; X64-Linux-Large-NEXT:    movl $0, %r10d
; X64-Linux-Large-NEXT:    movl $0, %r11d
; X64-Linux-Large-NEXT:    callq *__morestack_addr(%rip)
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:    movabsq $callee, %rax
; X64-Linux-Large-NEXT:    jmpq *%rax # TAILCALL
;
; X32ABI-LABEL: test_sibling_call_empty_frame:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    cmpl %fs:64, %esp
; X32ABI-NEXT:    ja callee@PLT # TAILCALL
; X32ABI-NEXT:  # %bb.1:
; X32ABI-NEXT:    movl $0, %r10d
; X32ABI-NEXT:    movl $0, %r11d
; X32ABI-NEXT:    callq __morestack
; X32ABI-NEXT:    retq
; X32ABI-NEXT:    jmp callee@PLT # TAILCALL
;
; X86-Darwin-LABEL: test_sibling_call_empty_frame:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    movl $432, %ecx ## imm = 0x1B0
; X86-Darwin-NEXT:    cmpl %gs:(%ecx), %esp
; X86-Darwin-NEXT:    ja _callee ## TAILCALL
; X86-Darwin-NEXT:  ## %bb.1:
; X86-Darwin-NEXT:    pushl $4
; X86-Darwin-NEXT:    pushl $0
; X86-Darwin-NEXT:    calll ___morestack
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:    jmp _callee ## TAILCALL
;
; X64-Darwin-LABEL: test_sibling_call_empty_frame:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    cmpq %gs:816, %rsp
; X64-Darwin-NEXT:    ja _callee ## TAILCALL
; X64-Darwin-NEXT:  ## %bb.1:
; X64-Darwin-NEXT:    movl $0, %r10d
; X64-Darwin-NEXT:    movl $0, %r11d
; X64-Darwin-NEXT:    callq ___morestack
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:    jmp _callee ## TAILCALL
;
; X86-MinGW-LABEL: test_sibling_call_empty_frame:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    cmpl %fs:20, %esp
; X86-MinGW-NEXT:    ja _callee # TAILCALL
; X86-MinGW-NEXT:  # %bb.1:
; X86-MinGW-NEXT:    pushl $4
; X86-MinGW-NEXT:    pushl $0
; X86-MinGW-NEXT:    calll ___morestack
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:    jmp _callee # TAILCALL
;
; X64-FreeBSD-LABEL: test_sibling_call_empty_frame:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    cmpq %fs:24, %rsp
; X64-FreeBSD-NEXT:    ja callee@PLT # TAILCALL
; X64-FreeBSD-NEXT:  # %bb.1:
; X64-FreeBSD-NEXT:    movl $0, %r10d
; X64-FreeBSD-NEXT:    movl $0, %r11d
; X64-FreeBSD-NEXT:    callq __morestack
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:    jmp callee@PLT # TAILCALL
;
; X86-DFlyBSD-LABEL: test_sibling_call_empty_frame:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    cmpl %fs:16, %esp
; X86-DFlyBSD-NEXT:    ja callee@PLT # TAILCALL
; X86-DFlyBSD-NEXT:  # %bb.1:
; X86-DFlyBSD-NEXT:    pushl $4
; X86-DFlyBSD-NEXT:    pushl $0
; X86-DFlyBSD-NEXT:    calll __morestack
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:    jmp callee@PLT # TAILCALL
;
; X64-DFlyBSD-LABEL: test_sibling_call_empty_frame:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    cmpq %fs:32, %rsp
; X64-DFlyBSD-NEXT:    ja callee@PLT # TAILCALL
; X64-DFlyBSD-NEXT:  # %bb.1:
; X64-DFlyBSD-NEXT:    movl $0, %r10d
; X64-DFlyBSD-NEXT:    movl $0, %r11d
; X64-DFlyBSD-NEXT:    callq __morestack
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:    jmp callee@PLT # TAILCALL
;
; X64-MinGW-LABEL: test_sibling_call_empty_frame:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    cmpq %gs:40, %rsp
; X64-MinGW-NEXT:    ja callee # TAILCALL
; X64-MinGW-NEXT:  # %bb.1:
; X64-MinGW-NEXT:    movl $0, %r10d
; X64-MinGW-NEXT:    movl $32, %r11d
; X64-MinGW-NEXT:    callq __morestack
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:    jmp callee # TAILCALL
  %call = tail call i32 @callee(i32 %x) #0
  ret i32 %call
}

; Test that unused nested argument doesn't need saving/restoring.

define i32 @test_nested_unused(ptr nest %unused) #0 {
; X86-Linux-LABEL: test_nested_unused:
; X86-Linux:       # %bb.0:
; X86-Linux-NEXT:    cmpl %gs:48, %esp
; X86-Linux-NEXT:    jbe .LBB9_1
; X86-Linux-NEXT:  .LBB9_2:
; X86-Linux-NEXT:    subl $52, %esp
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 52
; X86-Linux-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Linux-NEXT:    pushl $10
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    pushl %eax
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset 4
; X86-Linux-NEXT:    calll dummy_use@PLT
; X86-Linux-NEXT:    addl $16, %esp
; X86-Linux-NEXT:    .cfi_adjust_cfa_offset -16
; X86-Linux-NEXT:    movl $123, %eax
; X86-Linux-NEXT:    addl $44, %esp
; X86-Linux-NEXT:    .cfi_def_cfa_offset 4
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:  .LBB9_1:
; X86-Linux-NEXT:    pushl $0
; X86-Linux-NEXT:    pushl $44
; X86-Linux-NEXT:    calll __morestack
; X86-Linux-NEXT:    retl
; X86-Linux-NEXT:    jmp .LBB9_2
;
; X64-Linux-LABEL: test_nested_unused:
; X64-Linux:       # %bb.0:
; X64-Linux-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-NEXT:    jbe .LBB9_1
; X64-Linux-NEXT:  .LBB9_2:
; X64-Linux-NEXT:    subq $40, %rsp
; X64-Linux-NEXT:    .cfi_def_cfa_offset 48
; X64-Linux-NEXT:    movq %rsp, %rdi
; X64-Linux-NEXT:    movl $10, %esi
; X64-Linux-NEXT:    callq dummy_use@PLT
; X64-Linux-NEXT:    movl $123, %eax
; X64-Linux-NEXT:    addq $40, %rsp
; X64-Linux-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:  .LBB9_1:
; X64-Linux-NEXT:    movl $40, %r10d
; X64-Linux-NEXT:    movl $0, %r11d
; X64-Linux-NEXT:    callq __morestack
; X64-Linux-NEXT:    retq
; X64-Linux-NEXT:    jmp .LBB9_2
;
; X64-Linux-Large-LABEL: test_nested_unused:
; X64-Linux-Large:       # %bb.0:
; X64-Linux-Large-NEXT:    cmpq %fs:112, %rsp
; X64-Linux-Large-NEXT:    jbe .LBB9_1
; X64-Linux-Large-NEXT:  .LBB9_2:
; X64-Linux-Large-NEXT:    subq $40, %rsp
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 48
; X64-Linux-Large-NEXT:    movabsq $dummy_use, %rax
; X64-Linux-Large-NEXT:    movq %rsp, %rdi
; X64-Linux-Large-NEXT:    movl $10, %esi
; X64-Linux-Large-NEXT:    callq *%rax
; X64-Linux-Large-NEXT:    movl $123, %eax
; X64-Linux-Large-NEXT:    addq $40, %rsp
; X64-Linux-Large-NEXT:    .cfi_def_cfa_offset 8
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:  .LBB9_1:
; X64-Linux-Large-NEXT:    movl $40, %r10d
; X64-Linux-Large-NEXT:    movl $0, %r11d
; X64-Linux-Large-NEXT:    callq *__morestack_addr(%rip)
; X64-Linux-Large-NEXT:    retq
; X64-Linux-Large-NEXT:    jmp .LBB9_2
;
; X32ABI-LABEL: test_nested_unused:
; X32ABI:       # %bb.0:
; X32ABI-NEXT:    cmpl %fs:64, %esp
; X32ABI-NEXT:    jbe .LBB9_1
; X32ABI-NEXT:  .LBB9_2:
; X32ABI-NEXT:    subl $40, %esp
; X32ABI-NEXT:    .cfi_def_cfa_offset 48
; X32ABI-NEXT:    movl %esp, %edi
; X32ABI-NEXT:    movl $10, %esi
; X32ABI-NEXT:    callq dummy_use@PLT
; X32ABI-NEXT:    movl $123, %eax
; X32ABI-NEXT:    addl $40, %esp
; X32ABI-NEXT:    .cfi_def_cfa_offset 8
; X32ABI-NEXT:    retq
; X32ABI-NEXT:  .LBB9_1:
; X32ABI-NEXT:    movl $40, %r10d
; X32ABI-NEXT:    movl $0, %r11d
; X32ABI-NEXT:    callq __morestack
; X32ABI-NEXT:    retq
; X32ABI-NEXT:    jmp .LBB9_2
;
; X86-Darwin-LABEL: test_nested_unused:
; X86-Darwin:       ## %bb.0:
; X86-Darwin-NEXT:    movl $432, %ecx ## imm = 0x1B0
; X86-Darwin-NEXT:    cmpl %gs:(%ecx), %esp
; X86-Darwin-NEXT:    jbe LBB9_1
; X86-Darwin-NEXT:  LBB9_2:
; X86-Darwin-NEXT:    subl $60, %esp
; X86-Darwin-NEXT:    .cfi_def_cfa_offset 64
; X86-Darwin-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-Darwin-NEXT:    movl %eax, (%esp)
; X86-Darwin-NEXT:    movl $10, {{[0-9]+}}(%esp)
; X86-Darwin-NEXT:    calll _dummy_use
; X86-Darwin-NEXT:    movl $123, %eax
; X86-Darwin-NEXT:    addl $60, %esp
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:  LBB9_1:
; X86-Darwin-NEXT:    pushl $0
; X86-Darwin-NEXT:    pushl $60
; X86-Darwin-NEXT:    calll ___morestack
; X86-Darwin-NEXT:    retl
; X86-Darwin-NEXT:    jmp LBB9_2
;
; X64-Darwin-LABEL: test_nested_unused:
; X64-Darwin:       ## %bb.0:
; X64-Darwin-NEXT:    cmpq %gs:816, %rsp
; X64-Darwin-NEXT:    jbe LBB9_1
; X64-Darwin-NEXT:  LBB9_2:
; X64-Darwin-NEXT:    subq $40, %rsp
; X64-Darwin-NEXT:    .cfi_def_cfa_offset 48
; X64-Darwin-NEXT:    movq %rsp, %rdi
; X64-Darwin-NEXT:    movl $10, %esi
; X64-Darwin-NEXT:    callq _dummy_use
; X64-Darwin-NEXT:    movl $123, %eax
; X64-Darwin-NEXT:    addq $40, %rsp
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:  LBB9_1:
; X64-Darwin-NEXT:    movl $40, %r10d
; X64-Darwin-NEXT:    movl $0, %r11d
; X64-Darwin-NEXT:    callq ___morestack
; X64-Darwin-NEXT:    retq
; X64-Darwin-NEXT:    jmp LBB9_2
;
; X86-MinGW-LABEL: test_nested_unused:
; X86-MinGW:       # %bb.0:
; X86-MinGW-NEXT:    cmpl %fs:20, %esp
; X86-MinGW-NEXT:    jbe LBB9_1
; X86-MinGW-NEXT:  LBB9_2:
; X86-MinGW-NEXT:    subl $40, %esp
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 44
; X86-MinGW-NEXT:    movl %esp, %eax
; X86-MinGW-NEXT:    pushl $10
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    pushl %eax
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset 4
; X86-MinGW-NEXT:    calll _dummy_use
; X86-MinGW-NEXT:    addl $8, %esp
; X86-MinGW-NEXT:    .cfi_adjust_cfa_offset -8
; X86-MinGW-NEXT:    movl $123, %eax
; X86-MinGW-NEXT:    addl $40, %esp
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:  LBB9_1:
; X86-MinGW-NEXT:    .cfi_def_cfa_offset 4
; X86-MinGW-NEXT:    pushl $0
; X86-MinGW-NEXT:    pushl $40
; X86-MinGW-NEXT:    calll ___morestack
; X86-MinGW-NEXT:    retl
; X86-MinGW-NEXT:    jmp LBB9_2
;
; X64-FreeBSD-LABEL: test_nested_unused:
; X64-FreeBSD:       # %bb.0:
; X64-FreeBSD-NEXT:    cmpq %fs:24, %rsp
; X64-FreeBSD-NEXT:    jbe .LBB9_1
; X64-FreeBSD-NEXT:  .LBB9_2:
; X64-FreeBSD-NEXT:    subq $40, %rsp
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 48
; X64-FreeBSD-NEXT:    movq %rsp, %rdi
; X64-FreeBSD-NEXT:    movl $10, %esi
; X64-FreeBSD-NEXT:    callq dummy_use@PLT
; X64-FreeBSD-NEXT:    movl $123, %eax
; X64-FreeBSD-NEXT:    addq $40, %rsp
; X64-FreeBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:  .LBB9_1:
; X64-FreeBSD-NEXT:    movl $40, %r10d
; X64-FreeBSD-NEXT:    movl $0, %r11d
; X64-FreeBSD-NEXT:    callq __morestack
; X64-FreeBSD-NEXT:    retq
; X64-FreeBSD-NEXT:    jmp .LBB9_2
;
; X86-DFlyBSD-LABEL: test_nested_unused:
; X86-DFlyBSD:       # %bb.0:
; X86-DFlyBSD-NEXT:    cmpl %fs:16, %esp
; X86-DFlyBSD-NEXT:    jbe .LBB9_1
; X86-DFlyBSD-NEXT:  .LBB9_2:
; X86-DFlyBSD-NEXT:    subl $40, %esp
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 44
; X86-DFlyBSD-NEXT:    movl %esp, %eax
; X86-DFlyBSD-NEXT:    pushl $10
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    pushl %eax
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset 4
; X86-DFlyBSD-NEXT:    calll dummy_use@PLT
; X86-DFlyBSD-NEXT:    addl $8, %esp
; X86-DFlyBSD-NEXT:    .cfi_adjust_cfa_offset -8
; X86-DFlyBSD-NEXT:    movl $123, %eax
; X86-DFlyBSD-NEXT:    addl $40, %esp
; X86-DFlyBSD-NEXT:    .cfi_def_cfa_offset 4
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:  .LBB9_1:
; X86-DFlyBSD-NEXT:    pushl $0
; X86-DFlyBSD-NEXT:    pushl $40
; X86-DFlyBSD-NEXT:    calll __morestack
; X86-DFlyBSD-NEXT:    retl
; X86-DFlyBSD-NEXT:    jmp .LBB9_2
;
; X64-DFlyBSD-LABEL: test_nested_unused:
; X64-DFlyBSD:       # %bb.0:
; X64-DFlyBSD-NEXT:    cmpq %fs:32, %rsp
; X64-DFlyBSD-NEXT:    jbe .LBB9_1
; X64-DFlyBSD-NEXT:  .LBB9_2:
; X64-DFlyBSD-NEXT:    subq $40, %rsp
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 48
; X64-DFlyBSD-NEXT:    movq %rsp, %rdi
; X64-DFlyBSD-NEXT:    movl $10, %esi
; X64-DFlyBSD-NEXT:    callq dummy_use@PLT
; X64-DFlyBSD-NEXT:    movl $123, %eax
; X64-DFlyBSD-NEXT:    addq $40, %rsp
; X64-DFlyBSD-NEXT:    .cfi_def_cfa_offset 8
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:  .LBB9_1:
; X64-DFlyBSD-NEXT:    movl $40, %r10d
; X64-DFlyBSD-NEXT:    movl $0, %r11d
; X64-DFlyBSD-NEXT:    callq __morestack
; X64-DFlyBSD-NEXT:    retq
; X64-DFlyBSD-NEXT:    jmp .LBB9_2
;
; X64-MinGW-LABEL: test_nested_unused:
; X64-MinGW:       # %bb.0:
; X64-MinGW-NEXT:    cmpq %gs:40, %rsp
; X64-MinGW-NEXT:    jbe .LBB9_1
; X64-MinGW-NEXT:  .LBB9_2:
; X64-MinGW-NEXT:    subq $72, %rsp
; X64-MinGW-NEXT:    .seh_stackalloc 72
; X64-MinGW-NEXT:    .seh_endprologue
; X64-MinGW-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; X64-MinGW-NEXT:    movl $10, %edx
; X64-MinGW-NEXT:    callq dummy_use
; X64-MinGW-NEXT:    movl $123, %eax
; X64-MinGW-NEXT:    .seh_startepilogue
; X64-MinGW-NEXT:    addq $72, %rsp
; X64-MinGW-NEXT:    .seh_endepilogue
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:  .LBB9_1:
; X64-MinGW-NEXT:    movl $72, %r10d
; X64-MinGW-NEXT:    movl $32, %r11d
; X64-MinGW-NEXT:    callq __morestack
; X64-MinGW-NEXT:    retq
; X64-MinGW-NEXT:    jmp .LBB9_2
; X64-MinGW-NEXT:    .seh_endproc
       %mem = alloca i32, i32 10
       call void @dummy_use (ptr %mem, i32 10)
       ret i32 123
}

attributes #0 = { "split-stack" }

; X64-Linux-Large: .section ".note.GNU-split-stack","",@progbits
; X64-Linux-Large-NEXT: .section ".note.GNU-no-split-stack","",@progbits
; X64-Linux-Large-NEXT: .section	".note.GNU-stack","",@progbits
; X64-Linux-Large-NEXT: .rodata
; X64-Linux-Large-NEXT: __morestack_addr:
; X64-Linux-Large-NEXT: .quad	__morestack

; X86-Linux: .section ".note.GNU-split-stack","",@progbits
; X86-Linux: .section ".note.GNU-no-split-stack","",@progbits

; X64-Linux: .section ".note.GNU-split-stack","",@progbits
; X64-Linux: .section ".note.GNU-no-split-stack","",@progbits

; X64-FreeBSD: .section ".note.GNU-split-stack","",@progbits
; X64-FreeBSD: .section ".note.GNU-no-split-stack","",@progbits

; X86-DFlyBSD: .section ".note.GNU-split-stack","",@progbits
; X86-DFlyBSD: .section ".note.GNU-no-split-stack","",@progbits

; X64-DFlyBSD: .section ".note.GNU-split-stack","",@progbits
; X64-DFlyBSD: .section ".note.GNU-no-split-stack","",@progbits
