; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2-SSSE3,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSE2-SSSE3,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefix=AVX512 --check-prefix=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BWVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BWVL

define <8 x i32> @trunc8i64_8i32_nsw(<8 x i64> %a) {
; SSE-LABEL: trunc8i64_8i32_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc8i64_8i32_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i64_8i32_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc8i64_8i32_nsw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    retq
entry:
  %0 = trunc nsw <8 x i64> %a to <8 x i32>
  ret <8 x i32> %0
}

define <8 x i32> @trunc8i64_8i32_nuw(<8 x i64> %a) {
; SSE-LABEL: trunc8i64_8i32_nuw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc8i64_8i32_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i64_8i32_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc8i64_8i32_nuw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <8 x i64> %a to <8 x i32>
  ret <8 x i32> %0
}

define <8 x i16> @trunc8i64_8i16_nsw(<8 x i64> %a) {
; SSE-LABEL: trunc8i64_8i16_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packssdw %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc8i64_8i16_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i64_8i16_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc8i64_8i16_nsw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %0 = trunc nsw <8 x i64> %a to <8 x i16>
  ret <8 x i16> %0
}

define <8 x i16> @trunc8i64_8i16_nuw(<8 x i64> %a) {
; SSE2-SSSE3-LABEL: trunc8i64_8i16_nuw:
; SSE2-SSSE3:       # %bb.0: # %entry
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE2-SSSE3-NEXT:    pslld $16, %xmm2
; SSE2-SSSE3-NEXT:    psrad $16, %xmm2
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE2-SSSE3-NEXT:    pslld $16, %xmm0
; SSE2-SSSE3-NEXT:    psrad $16, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc8i64_8i16_nuw:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    packusdw %xmm3, %xmm2
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    packusdw %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc8i64_8i16_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i64_8i16_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc8i64_8i16_nuw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <8 x i64> %a to <8 x i16>
  ret <8 x i16> %0
}

define void @trunc8i64_8i8_nsw(<8 x i64> %a) {
; SSE-LABEL: trunc8i64_8i8_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packssdw %xmm2, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    movq %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc8i64_8i8_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i64_8i8_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc8i64_8i8_nsw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovqb %zmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %0 = trunc nsw <8 x i64> %a to <8 x i8>
  store <8 x i8> %0, ptr undef, align 4
  ret void
}

define void @trunc8i64_8i8_nuw(<8 x i64> %a) {
; SSE2-SSSE3-LABEL: trunc8i64_8i8_nuw:
; SSE2-SSSE3:       # %bb.0: # %entry
; SSE2-SSSE3-NEXT:    packuswb %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    packuswb %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    movq %xmm0, (%rax)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc8i64_8i8_nuw:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    packusdw %xmm3, %xmm2
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    packusdw %xmm2, %xmm0
; SSE41-NEXT:    packuswb %xmm0, %xmm0
; SSE41-NEXT:    movq %xmm0, (%rax)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc8i64_8i8_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i64_8i8_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc8i64_8i8_nuw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovqb %zmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <8 x i64> %a to <8 x i8>
  store <8 x i8> %0, ptr undef, align 4
  ret void
}

define <8 x i16> @trunc8i32_8i16_nsw(<8 x i32> %a) {
; SSE-LABEL: trunc8i32_8i16_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc8i32_8i16_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i32_8i16_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc8i32_8i16_nsw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc8i32_8i16_nsw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc8i32_8i16_nsw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc8i32_8i16_nsw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nsw <8 x i32> %a to <8 x i16>
  ret <8 x i16> %0
}

define <8 x i16> @trunc8i32_8i16_nuw(<8 x i32> %a) {
; SSE2-LABEL: trunc8i32_8i16_nuw:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    pslld $16, %xmm1
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    packssdw %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc8i32_8i16_nuw:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm1
; SSSE3-NEXT:    pshufb %xmm2, %xmm0
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc8i32_8i16_nuw:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc8i32_8i16_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i32_8i16_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc8i32_8i16_nuw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc8i32_8i16_nuw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc8i32_8i16_nuw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc8i32_8i16_nuw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nuw <8 x i32> %a to <8 x i16>
  ret <8 x i16> %0
}

define void @trunc8i32_8i8_nsw(<8 x i32> %a) {
; SSE-LABEL: trunc8i32_8i8_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    movq %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc8i32_8i8_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i32_8i8_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc8i32_8i8_nsw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc8i32_8i8_nsw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovdb %ymm0, (%rax)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc8i32_8i8_nsw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc8i32_8i8_nsw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovdb %ymm0, (%rax)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nsw <8 x i32> %a to <8 x i8>
  store <8 x i8> %0, ptr undef, align 4
  ret void
}

define void @trunc8i32_8i8_nuw(<8 x i32> %a) {
; SSE2-SSSE3-LABEL: trunc8i32_8i8_nuw:
; SSE2-SSSE3:       # %bb.0: # %entry
; SSE2-SSSE3-NEXT:    packuswb %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    movq %xmm0, (%rax)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc8i32_8i8_nuw:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    packuswb %xmm0, %xmm0
; SSE41-NEXT:    movq %xmm0, (%rax)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc8i32_8i8_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc8i32_8i8_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc8i32_8i8_nuw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc8i32_8i8_nuw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovdb %ymm0, (%rax)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc8i32_8i8_nuw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc8i32_8i8_nuw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovdb %ymm0, (%rax)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nuw <8 x i32> %a to <8 x i8>
  store <8 x i8> %0, ptr undef, align 4
  ret void
}

define void @trunc16i32_16i16_nsw(<16 x i32> %a) {
; SSE-LABEL: trunc16i32_16i16_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    movdqu %xmm2, (%rax)
; SSE-NEXT:    movdqu %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc16i32_16i16_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqu %xmm1, (%rax)
; AVX1-NEXT:    vmovdqu %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc16i32_16i16_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovdqu %ymm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc16i32_16i16_nsw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovdw %zmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %0 = trunc nsw <16 x i32> %a to <16 x i16>
  store <16 x i16> %0, ptr undef, align 4
  ret void
}

define void @trunc16i32_16i16_nuw(<16 x i32> %a) {
; SSE2-LABEL: trunc16i32_16i16_nuw:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    pslld $16, %xmm1
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    packssdw %xmm1, %xmm0
; SSE2-NEXT:    pslld $16, %xmm3
; SSE2-NEXT:    psrad $16, %xmm3
; SSE2-NEXT:    pslld $16, %xmm2
; SSE2-NEXT:    psrad $16, %xmm2
; SSE2-NEXT:    packssdw %xmm3, %xmm2
; SSE2-NEXT:    movdqu %xmm2, (%rax)
; SSE2-NEXT:    movdqu %xmm0, (%rax)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc16i32_16i16_nuw:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm4, %xmm1
; SSSE3-NEXT:    pshufb %xmm4, %xmm0
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSSE3-NEXT:    pshufb %xmm4, %xmm3
; SSSE3-NEXT:    pshufb %xmm4, %xmm2
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSSE3-NEXT:    movdqu %xmm2, (%rax)
; SSSE3-NEXT:    movdqu %xmm0, (%rax)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc16i32_16i16_nuw:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    packusdw %xmm3, %xmm2
; SSE41-NEXT:    movdqu %xmm2, (%rax)
; SSE41-NEXT:    movdqu %xmm0, (%rax)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc16i32_16i16_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqu %xmm1, (%rax)
; AVX1-NEXT:    vmovdqu %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc16i32_16i16_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovdqu %ymm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc16i32_16i16_nuw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovdw %zmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <16 x i32> %a to <16 x i16>
  store <16 x i16> %0, ptr undef, align 4
  ret void
}

define void @trunc16i32_16i8_nsw(<16 x i32> %a) {
; SSE2-SSSE3-LABEL: trunc16i32_16i8_nsw:
; SSE2-SSSE3:       # %bb.0: # %entry
; SSE2-SSSE3-NEXT:    packuswb %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    packuswb %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    movdqu %xmm0, (%rax)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc16i32_16i8_nsw:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    packusdw %xmm3, %xmm2
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    packuswb %xmm2, %xmm0
; SSE41-NEXT:    movdqu %xmm0, (%rax)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc16i32_16i8_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqu %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc16i32_16i8_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vmovdqu %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc16i32_16i8_nsw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <16 x i32> %a to <16 x i8>
  store <16 x i8> %0, ptr undef, align 4
  ret void
}

define void @trunc16i32_16i8_nuw(<16 x i32> %a) {
; SSE2-SSSE3-LABEL: trunc16i32_16i8_nuw:
; SSE2-SSSE3:       # %bb.0: # %entry
; SSE2-SSSE3-NEXT:    packuswb %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    packuswb %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    packuswb %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    movdqu %xmm0, (%rax)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc16i32_16i8_nuw:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    packusdw %xmm3, %xmm2
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    packuswb %xmm2, %xmm0
; SSE41-NEXT:    movdqu %xmm0, (%rax)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc16i32_16i8_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqu %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc16i32_16i8_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vmovdqu %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc16i32_16i8_nuw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <16 x i32> %a to <16 x i8>
  store <16 x i8> %0, ptr undef, align 4
  ret void
}

define void @trunc16i16_16i8_nsw(<16 x i16> %a) {
; SSE-LABEL: trunc16i16_16i8_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    movdqu %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc16i16_16i8_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqu %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc16i16_16i8_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqu %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc16i16_16i8_nsw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc16i16_16i8_nsw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc16i16_16i8_nsw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vmovdqu %xmm0, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc16i16_16i8_nsw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovwb %ymm0, (%rax)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nsw <16 x i16> %a to <16 x i8>
  store <16 x i8> %0, ptr undef, align 4
  ret void
}

define void @trunc16i16_16i8_nuw(<16 x i16> %a) {
; SSE-LABEL: trunc16i16_16i8_nuw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqu %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc16i16_16i8_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqu %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc16i16_16i8_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqu %xmm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc16i16_16i8_nuw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc16i16_16i8_nuw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc16i16_16i8_nuw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vmovdqu %xmm0, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc16i16_16i8_nuw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovwb %ymm0, (%rax)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nuw <16 x i16> %a to <16 x i8>
  store <16 x i8> %0, ptr undef, align 4
  ret void
}

define void @trunc32i16_32i8_nsw(<32 x i16> %a) {
; SSE-LABEL: trunc32i16_32i8_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm3, %xmm2
; SSE-NEXT:    movdqu %xmm2, (%rax)
; SSE-NEXT:    movdqu %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc32i16_32i8_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpacksswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpacksswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqu %xmm1, (%rax)
; AVX1-NEXT:    vmovdqu %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc32i16_32i8_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovdqu %ymm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc32i16_32i8_nsw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpmovdb %zmm1, (%rax)
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc32i16_32i8_nsw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm1, (%rax)
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc32i16_32i8_nsw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    vpmovwb %zmm0, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc32i16_32i8_nsw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovwb %zmm0, (%rax)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nsw <32 x i16> %a to <32 x i8>
  store <32 x i8> %0, ptr undef, align 4
  ret void
}

define void @trunc32i16_32i8_nuw(<32 x i16> %a) {
; SSE-LABEL: trunc32i16_32i8_nuw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm3, %xmm2
; SSE-NEXT:    movdqu %xmm2, (%rax)
; SSE-NEXT:    movdqu %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc32i16_32i8_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpacksswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpacksswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqu %xmm1, (%rax)
; AVX1-NEXT:    vmovdqu %xmm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc32i16_32i8_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovdqu %ymm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc32i16_32i8_nuw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpmovdb %zmm1, (%rax)
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc32i16_32i8_nuw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm1, (%rax)
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm0, (%rax)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc32i16_32i8_nuw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    vpmovwb %zmm0, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc32i16_32i8_nuw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovwb %zmm0, (%rax)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nsw <32 x i16> %a to <32 x i8>
  store <32 x i8> %0, ptr undef, align 4
  ret void
}

define <8 x i32> @trunc2x4i64_8i32_nsw(<4 x i64> %a, <4 x i64> %b) {
; SSE-LABEL: trunc2x4i64_8i32_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc2x4i64_8i32_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc2x4i64_8i32_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc2x4i64_8i32_nsw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    retq
entry:
  %0 = trunc nsw <4 x i64> %a to <4 x i32>
  %1 = trunc nsw <4 x i64> %b to <4 x i32>
  %2 = shufflevector <4 x i32> %0, <4 x i32> %1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %2
}

define <8 x i32> @trunc2x4i64_8i32_nuw(<4 x i64> %a, <4 x i64> %b) {
; SSE-LABEL: trunc2x4i64_8i32_nuw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc2x4i64_8i32_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc2x4i64_8i32_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc2x4i64_8i32_nuw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <4 x i64> %a to <4 x i32>
  %1 = trunc nuw <4 x i64> %b to <4 x i32>
  %2 = shufflevector <4 x i32> %0, <4 x i32> %1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %2
}

define <8 x i16> @trunc2x4i64_8i16_nsw(<4 x i64> %a, <4 x i64> %b) {
; SSE-LABEL: trunc2x4i64_8i16_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    packssdw %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc2x4i64_8i16_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc2x4i64_8i16_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc2x4i64_8i16_nsw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512F-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc2x4i64_8i16_nsw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovqw %ymm0, %xmm0
; AVX512VL-NEXT:    vpmovqw %ymm1, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc2x4i64_8i16_nsw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512BW-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc2x4i64_8i16_nsw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovqw %ymm0, %xmm0
; AVX512BWVL-NEXT:    vpmovqw %ymm1, %xmm1
; AVX512BWVL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nsw <4 x i64> %a to <4 x i16>
  %1 = trunc nsw <4 x i64> %b to <4 x i16>
  %2 = shufflevector <4 x i16> %0, <4 x i16> %1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %2
}

define <8 x i16> @trunc2x4i64_8i16_nuw(<4 x i64> %a, <4 x i64> %b) {
; SSE2-SSSE3-LABEL: trunc2x4i64_8i16_nuw:
; SSE2-SSSE3:       # %bb.0: # %entry
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE2-SSSE3-NEXT:    pslld $16, %xmm0
; SSE2-SSSE3-NEXT:    psrad $16, %xmm0
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE2-SSSE3-NEXT:    pslld $16, %xmm2
; SSE2-SSSE3-NEXT:    psrad $16, %xmm2
; SSE2-SSSE3-NEXT:    packssdw %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc2x4i64_8i16_nuw:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    packusdw %xmm3, %xmm2
; SSE41-NEXT:    packusdw %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc2x4i64_8i16_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc2x4i64_8i16_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc2x4i64_8i16_nuw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512F-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc2x4i64_8i16_nuw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovqw %ymm0, %xmm0
; AVX512VL-NEXT:    vpmovqw %ymm1, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc2x4i64_8i16_nuw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512BW-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc2x4i64_8i16_nuw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovqw %ymm0, %xmm0
; AVX512BWVL-NEXT:    vpmovqw %ymm1, %xmm1
; AVX512BWVL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nuw <4 x i64> %a to <4 x i16>
  %1 = trunc nuw <4 x i64> %b to <4 x i16>
  %2 = shufflevector <4 x i16> %0, <4 x i16> %1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %2
}

define <4 x i32> @trunc2x2i64_4i32_nsw(<2 x i64> %a, <2 x i64> %b) {
; SSE-LABEL: trunc2x2i64_4i32_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc2x2i64_4i32_nsw:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc2x2i64_4i32_nsw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc2x2i64_4i32_nsw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovqd %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc2x2i64_4i32_nsw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc2x2i64_4i32_nsw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512BWVL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovqd %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nsw <2 x i64> %a to <2 x i32>
  %1 = trunc nsw <2 x i64> %b to <2 x i32>
  %2 = shufflevector <2 x i32> %0, <2 x i32> %1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @trunc2x2i64_4i32_nuw(<2 x i64> %a, <2 x i64> %b) {
; SSE-LABEL: trunc2x2i64_4i32_nuw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc2x2i64_4i32_nuw:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc2x2i64_4i32_nuw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc2x2i64_4i32_nuw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovqd %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc2x2i64_4i32_nuw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc2x2i64_4i32_nuw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512BWVL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovqd %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nuw <2 x i64> %a to <2 x i32>
  %1 = trunc nuw <2 x i64> %b to <2 x i32>
  %2 = shufflevector <2 x i32> %0, <2 x i32> %1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %2
}

define <8 x i16> @trunc2x4i32_8i16_nsw(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: trunc2x4i32_8i16_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc2x4i32_8i16_nsw:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc2x4i32_8i16_nsw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %0 = trunc nsw <4 x i32> %a to <4 x i16>
  %1 = trunc nsw <4 x i32> %b to <4 x i16>
  %2 = shufflevector <4 x i16> %0, <4 x i16> %1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %2
}

define <8 x i16> @trunc2x4i32_8i16_nuw(<4 x i32> %a, <4 x i32> %b) {
; SSE2-LABEL: trunc2x4i32_8i16_nuw:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    pslld $16, %xmm1
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    packssdw %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc2x4i32_8i16_nuw:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm1
; SSSE3-NEXT:    pshufb %xmm2, %xmm0
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc2x4i32_8i16_nuw:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: trunc2x4i32_8i16_nuw:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc2x4i32_8i16_nuw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <4 x i32> %a to <4 x i16>
  %1 = trunc nuw <4 x i32> %b to <4 x i16>
  %2 = shufflevector <4 x i16> %0, <4 x i16> %1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %2
}

define <32 x i8> @trunc2x16i16_32i8_nsw(<16 x i16> %a, <16 x i16> %b) {
; SSE-LABEL: trunc2x16i16_32i8_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc2x16i16_32i8_nsw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpacksswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpacksswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc2x16i16_32i8_nsw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc2x16i16_32i8_nsw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc2x16i16_32i8_nsw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc2x16i16_32i8_nsw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc2x16i16_32i8_nsw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BWVL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nsw <16 x i16> %a to <16 x i8>
  %1 = trunc nsw <16 x i16> %b to <16 x i8>
  %2 = shufflevector <16 x i8> %0, <16 x i8> %1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x i8> %2
}

define <32 x i8> @trunc2x16i16_32i8_nuw(<16 x i16> %a, <16 x i16> %b) {
; SSE-LABEL: trunc2x16i16_32i8_nuw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc2x16i16_32i8_nuw:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc2x16i16_32i8_nuw:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc2x16i16_32i8_nuw:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc2x16i16_32i8_nuw:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc2x16i16_32i8_nuw:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc2x16i16_32i8_nuw:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BWVL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
entry:
  %0 = trunc nuw <16 x i16> %a to <16 x i8>
  %1 = trunc nuw <16 x i16> %b to <16 x i8>
  %2 = shufflevector <16 x i8> %0, <16 x i8> %1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x i8> %2
}

define <16 x i8> @trunc2x8i16_16i8_nsw(<8 x i16> %a, <8 x i16> %b) {
; SSE-LABEL: trunc2x8i16_16i8_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc2x8i16_16i8_nsw:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc2x8i16_16i8_nsw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %0 = trunc nsw <8 x i16> %a to <8 x i8>
  %1 = trunc nsw <8 x i16> %b to <8 x i8>
  %2 = shufflevector <8 x i8> %0, <8 x i8> %1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %2
}

define <16 x i8> @trunc2x8i16_16i8_nuw(<8 x i16> %a, <8 x i16> %b) {
; SSE-LABEL: trunc2x8i16_16i8_nuw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc2x8i16_16i8_nuw:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc2x8i16_16i8_nuw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <8 x i16> %a to <8 x i8>
  %1 = trunc nuw <8 x i16> %b to <8 x i8>
  %2 = shufflevector <8 x i8> %0, <8 x i8> %1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %2
}

define i64 @trunc8i16_i64_nsw(<8 x i16> %inval) {
; SSE-LABEL: trunc8i16_i64_nsw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc8i16_i64_nsw:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, %rax
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc8i16_i64_nsw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovq %xmm0, %rax
; AVX512-NEXT:    retq
entry:
  %0 = trunc nsw <8 x i16> %inval to <8 x i8>
  %1 = bitcast <8 x i8> %0 to i64
  ret i64 %1
}

define i64 @trunc8i16_i64_nuw(<8 x i16> %inval) {
; SSE-LABEL: trunc8i16_i64_nuw:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc8i16_i64_nuw:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, %rax
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc8i16_i64_nuw:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovq %xmm0, %rax
; AVX512-NEXT:    retq
entry:
  %0 = trunc nuw <8 x i16> %inval to <8 x i8>
  %1 = bitcast <8 x i8> %0 to i64
  ret i64 %1
}

define void @foo(<4 x i64> %a, <4 x i64> %b, ptr %p) "min-legal-vector-width"="256" "prefer-vector-width"="256" {
; SSE-LABEL: foo:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE-NEXT:    movaps %xmm2, 16(%rdi)
; SSE-NEXT:    movaps %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: foo:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX1-NEXT:    vmovups %ymm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: foo:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovups %ymm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: foo:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovqd %zmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: foo:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vpmovqd %ymm1, 16(%rdi)
; AVX512VL-NEXT:    vpmovqd %ymm0, (%rdi)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: foo:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovqd %zmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: foo:
; AVX512BWVL:       # %bb.0: # %entry
; AVX512BWVL-NEXT:    vpmovqd %ymm1, 16(%rdi)
; AVX512BWVL-NEXT:    vpmovqd %ymm0, (%rdi)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
entry:
  %0 = shufflevector <4 x i64> %a, <4 x i64> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %1 = trunc nsw <8 x i64> %0 to <8 x i32>
  store <8 x i32> %1, ptr %p, align 16
  ret void
}
