; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,GFX11,GFX11-FAKE16 %s

; Make sure we don't crash or assert on spir_kernel calling convention.

define spir_kernel void @kernel(ptr addrspace(1) %out) {
; SI-LABEL: kernel:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: kernel:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v2, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: kernel:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v0, s[0:1]
; GFX11-NEXT:    s_endpgm
entry:
  store i32 0, ptr addrspace(1) %out
  ret void
}

; FIXME: This is treated like a kernel
; XGCN-LABEL: {{^}}func:
; XGCN: s_endpgm
; define spir_func void @func(ptr addrspace(1) %out) {
; entry:
;   store i32 0, ptr addrspace(1) %out
;   ret void
; }

define amdgpu_ps half @ps_ret_cc_f16(half %arg0) {
; SI-LABEL: ps_ret_cc_f16:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: ps_ret_cc_f16:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-TRUE16-LABEL: ps_ret_cc_f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_add_f16_e32 v0.l, 1.0, v0.l
; GFX11-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-FAKE16-LABEL: ps_ret_cc_f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    ; return to shader part epilog
  %add = fadd half %arg0, 1.0
  ret half %add
}

define amdgpu_ps half @ps_ret_cc_inreg_f16(half inreg %arg0) {
; SI-LABEL: ps_ret_cc_inreg_f16:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, s0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: ps_ret_cc_inreg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e64 v0, s0, 1.0
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-TRUE16-LABEL: ps_ret_cc_inreg_f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_add_f16_e64 v0.l, s0, 1.0
; GFX11-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-FAKE16-LABEL: ps_ret_cc_inreg_f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_add_f16_e64 v0, s0, 1.0
; GFX11-FAKE16-NEXT:    ; return to shader part epilog
  %add = fadd half %arg0, 1.0
  ret half %add
}

define fastcc float @fastcc(float %arg0) #0 {
; GCN-LABEL: fastcc:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f32_e32 v0, 4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd float %arg0, 4.0
  ret float %add
}

define coldcc float @coldcc(float %arg0) #0 {
; GCN-LABEL: coldcc:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f32_e32 v0, 4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
 %add = fadd float %arg0, 4.0
 ret float %add
}

define amdgpu_kernel void @call_coldcc() #0 {
; SI-LABEL: call_coldcc:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s32, 0
; SI-NEXT:    s_mov_b32 s20, SCRATCH_RSRC_DWORD0
; SI-NEXT:    s_mov_b32 s21, SCRATCH_RSRC_DWORD1
; SI-NEXT:    s_mov_b32 s22, -1
; SI-NEXT:    s_mov_b32 s23, 0xe8f000
; SI-NEXT:    s_add_u32 s20, s20, s11
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s13, s9
; SI-NEXT:    s_mov_b32 s12, s8
; SI-NEXT:    s_mov_b64 s[10:11], s[6:7]
; SI-NEXT:    s_add_u32 s8, s4, 36
; SI-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; SI-NEXT:    s_addc_u32 s9, s5, 0
; SI-NEXT:    s_getpc_b64 s[4:5]
; SI-NEXT:    s_add_u32 s4, s4, coldcc@gotpcrel32@lo+4
; SI-NEXT:    s_addc_u32 s5, s5, coldcc@gotpcrel32@hi+12
; SI-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v31, v0, v2
; SI-NEXT:    v_mov_b32_e32 v0, 1.0
; SI-NEXT:    s_mov_b64 s[4:5], s[0:1]
; SI-NEXT:    s_mov_b64 s[6:7], s[2:3]
; SI-NEXT:    s_mov_b64 s[0:1], s[20:21]
; SI-NEXT:    s_mov_b64 s[2:3], s[22:23]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: call_coldcc:
; VI:       ; %bb.0:
; VI-NEXT:    s_mov_b32 s88, SCRATCH_RSRC_DWORD0
; VI-NEXT:    s_mov_b32 s89, SCRATCH_RSRC_DWORD1
; VI-NEXT:    s_mov_b32 s90, -1
; VI-NEXT:    s_mov_b32 s91, 0xe80000
; VI-NEXT:    s_add_u32 s88, s88, s11
; VI-NEXT:    s_addc_u32 s89, s89, 0
; VI-NEXT:    s_mov_b32 s12, s8
; VI-NEXT:    s_add_u32 s8, s4, 36
; VI-NEXT:    s_mov_b32 s13, s9
; VI-NEXT:    s_addc_u32 s9, s5, 0
; VI-NEXT:    s_getpc_b64 s[4:5]
; VI-NEXT:    s_add_u32 s4, s4, coldcc@gotpcrel32@lo+4
; VI-NEXT:    s_addc_u32 s5, s5, coldcc@gotpcrel32@hi+12
; VI-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; VI-NEXT:    s_mov_b32 s14, s10
; VI-NEXT:    s_mov_b64 s[10:11], s[6:7]
; VI-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_mov_b64 s[4:5], s[0:1]
; VI-NEXT:    s_mov_b64 s[6:7], s[2:3]
; VI-NEXT:    s_mov_b64 s[0:1], s[88:89]
; VI-NEXT:    v_or_b32_e32 v31, v0, v2
; VI-NEXT:    s_mov_b64 s[2:3], s[90:91]
; VI-NEXT:    v_mov_b32_e32 v0, 1.0
; VI-NEXT:    s_mov_b32 s32, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: call_coldcc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_add_u32 s8, s4, 36
; GFX11-NEXT:    s_addc_u32 s9, s5, 0
; GFX11-NEXT:    s_getpc_b64 s[4:5]
; GFX11-NEXT:    s_add_u32 s4, s4, coldcc@gotpcrel32@lo+4
; GFX11-NEXT:    s_addc_u32 s5, s5, coldcc@gotpcrel32@hi+12
; GFX11-NEXT:    v_dual_mov_b32 v31, v0 :: v_dual_mov_b32 v0, 1.0
; GFX11-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX11-NEXT:    s_mov_b32 s12, s13
; GFX11-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX11-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX11-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX11-NEXT:    s_mov_b32 s13, s14
; GFX11-NEXT:    s_mov_b32 s14, s15
; GFX11-NEXT:    s_mov_b32 s32, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  %val = call coldcc float @coldcc(float 1.0)
  store float %val, ptr addrspace(1) poison
  ret void
}

define amdgpu_kernel void @call_fastcc() #0 {
; SI-LABEL: call_fastcc:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s32, 0
; SI-NEXT:    s_mov_b32 s20, SCRATCH_RSRC_DWORD0
; SI-NEXT:    s_mov_b32 s21, SCRATCH_RSRC_DWORD1
; SI-NEXT:    s_mov_b32 s22, -1
; SI-NEXT:    s_mov_b32 s23, 0xe8f000
; SI-NEXT:    s_add_u32 s20, s20, s11
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s13, s9
; SI-NEXT:    s_mov_b32 s12, s8
; SI-NEXT:    s_mov_b64 s[10:11], s[6:7]
; SI-NEXT:    s_add_u32 s8, s4, 36
; SI-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; SI-NEXT:    s_addc_u32 s9, s5, 0
; SI-NEXT:    s_getpc_b64 s[4:5]
; SI-NEXT:    s_add_u32 s4, s4, fastcc@gotpcrel32@lo+4
; SI-NEXT:    s_addc_u32 s5, s5, fastcc@gotpcrel32@hi+12
; SI-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v31, v0, v2
; SI-NEXT:    v_mov_b32_e32 v0, 1.0
; SI-NEXT:    s_mov_b64 s[4:5], s[0:1]
; SI-NEXT:    s_mov_b64 s[6:7], s[2:3]
; SI-NEXT:    s_mov_b64 s[0:1], s[20:21]
; SI-NEXT:    s_mov_b64 s[2:3], s[22:23]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: call_fastcc:
; VI:       ; %bb.0:
; VI-NEXT:    s_mov_b32 s88, SCRATCH_RSRC_DWORD0
; VI-NEXT:    s_mov_b32 s89, SCRATCH_RSRC_DWORD1
; VI-NEXT:    s_mov_b32 s90, -1
; VI-NEXT:    s_mov_b32 s91, 0xe80000
; VI-NEXT:    s_add_u32 s88, s88, s11
; VI-NEXT:    s_addc_u32 s89, s89, 0
; VI-NEXT:    s_mov_b32 s12, s8
; VI-NEXT:    s_add_u32 s8, s4, 36
; VI-NEXT:    s_mov_b32 s13, s9
; VI-NEXT:    s_addc_u32 s9, s5, 0
; VI-NEXT:    s_getpc_b64 s[4:5]
; VI-NEXT:    s_add_u32 s4, s4, fastcc@gotpcrel32@lo+4
; VI-NEXT:    s_addc_u32 s5, s5, fastcc@gotpcrel32@hi+12
; VI-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; VI-NEXT:    s_mov_b32 s14, s10
; VI-NEXT:    s_mov_b64 s[10:11], s[6:7]
; VI-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_mov_b64 s[4:5], s[0:1]
; VI-NEXT:    s_mov_b64 s[6:7], s[2:3]
; VI-NEXT:    s_mov_b64 s[0:1], s[88:89]
; VI-NEXT:    v_or_b32_e32 v31, v0, v2
; VI-NEXT:    s_mov_b64 s[2:3], s[90:91]
; VI-NEXT:    v_mov_b32_e32 v0, 1.0
; VI-NEXT:    s_mov_b32 s32, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: call_fastcc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_add_u32 s8, s4, 36
; GFX11-NEXT:    s_addc_u32 s9, s5, 0
; GFX11-NEXT:    s_getpc_b64 s[4:5]
; GFX11-NEXT:    s_add_u32 s4, s4, fastcc@gotpcrel32@lo+4
; GFX11-NEXT:    s_addc_u32 s5, s5, fastcc@gotpcrel32@hi+12
; GFX11-NEXT:    v_dual_mov_b32 v31, v0 :: v_dual_mov_b32 v0, 1.0
; GFX11-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX11-NEXT:    s_mov_b32 s12, s13
; GFX11-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX11-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX11-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX11-NEXT:    s_mov_b32 s13, s14
; GFX11-NEXT:    s_mov_b32 s14, s15
; GFX11-NEXT:    s_mov_b32 s32, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  %val = call fastcc float @fastcc(float 1.0)
  store float %val, ptr addrspace(1) poison
  ret void
}

; Mesa compute shader: check for 47176 (COMPUTE_PGM_RSRC1) in .AMDGPU.config
define amdgpu_cs half @cs_mesa(half %arg0) {
; SI-LABEL: cs_mesa:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: cs_mesa:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-TRUE16-LABEL: cs_mesa:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_add_f16_e32 v0.l, 1.0, v0.l
; GFX11-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-FAKE16-LABEL: cs_mesa:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    ; return to shader part epilog
  %add = fadd half %arg0, 1.0
  ret half %add
}

; Mesa pixel shader: check for 45096 (SPI_SHADER_PGM_RSRC1_PS) in .AMDGPU.config
define amdgpu_ps half @ps_mesa_f16(half %arg0) {
; SI-LABEL: ps_mesa_f16:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: ps_mesa_f16:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-TRUE16-LABEL: ps_mesa_f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_add_f16_e32 v0.l, 1.0, v0.l
; GFX11-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-FAKE16-LABEL: ps_mesa_f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    ; return to shader part epilog
  %add = fadd half %arg0, 1.0
  ret half %add
}

; Mesa vertex shader: check for 45352 (SPI_SHADER_PGM_RSRC1_VS) in .AMDGPU.config
define amdgpu_vs half @vs_mesa(half %arg0) {
; SI-LABEL: vs_mesa:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: vs_mesa:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-TRUE16-LABEL: vs_mesa:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_add_f16_e32 v0.l, 1.0, v0.l
; GFX11-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-FAKE16-LABEL: vs_mesa:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    ; return to shader part epilog
  %add = fadd half %arg0, 1.0
  ret half %add
}

; Mesa geometry shader: check for 45608 (SPI_SHADER_PGM_RSRC1_GS) in .AMDGPU.config
define amdgpu_gs half @gs_mesa(half %arg0) {
; SI-LABEL: gs_mesa:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: gs_mesa:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-TRUE16-LABEL: gs_mesa:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_add_f16_e32 v0.l, 1.0, v0.l
; GFX11-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-FAKE16-LABEL: gs_mesa:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    ; return to shader part epilog
  %add = fadd half %arg0, 1.0
  ret half %add
}

; Mesa hull shader: check for 46120 (SPI_SHADER_PGM_RSRC1_HS) in .AMDGPU.config
define amdgpu_hs half @hs_mesa(half %arg0) {
; SI-LABEL: hs_mesa:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: hs_mesa:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-TRUE16-LABEL: hs_mesa:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_add_f16_e32 v0.l, 1.0, v0.l
; GFX11-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX11-FAKE16-LABEL: hs_mesa:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    ; return to shader part epilog
  %add = fadd half %arg0, 1.0
  ret half %add
}

; FIXME: Inconsistent ABI between targets

define amdgpu_ps <2 x half> @ps_mesa_v2f16(<2 x half> %arg0) {
; SI-LABEL: ps_mesa_v2f16:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: ps_mesa_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    v_mov_b32_e32 v1, 0x3c00
; VI-NEXT:    v_add_f16_sdwa v1, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: ps_mesa_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_pk_add_f16 v0, v0, 1.0 op_sel_hi:[1,0]
; GFX11-NEXT:    ; return to shader part epilog
  %add = fadd <2 x half> %arg0, <half 1.0, half 1.0>
  ret <2 x half> %add
}

define amdgpu_ps <2 x half> @ps_mesa_inreg_v2f16(<2 x half> inreg %arg0) {
; SI-LABEL: ps_mesa_inreg_v2f16:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, s1
; SI-NEXT:    v_cvt_f16_f32_e32 v1, s0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v2
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: ps_mesa_inreg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_lshr_b32 s1, s0, 16
; VI-NEXT:    v_mov_b32_e32 v0, s1
; VI-NEXT:    v_mov_b32_e32 v1, 0x3c00
; VI-NEXT:    v_add_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e64 v1, s0, 1.0
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: ps_mesa_inreg_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_pk_add_f16 v0, s0, 1.0 op_sel_hi:[1,0]
; GFX11-NEXT:    ; return to shader part epilog
  %add = fadd <2 x half> %arg0, <half 1.0, half 1.0>
  ret <2 x half> %add
}

define amdgpu_ps void @ps_mesa_v2i16(<2 x i16> %arg0) {
; SI-LABEL: ps_mesa_v2i16:
; SI:       ; %bb.0:
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x10000, v0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    v_mov_b32_e32 v2, 1
; VI-NEXT:    v_add_u16_e32 v1, 1, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_v2i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 1 op_sel_hi:[1,0]
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  %add = add <2 x i16> %arg0, <i16 1, i16 1>
  store <2 x i16> %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_inreg_v2i16(<2 x i16> inreg %arg0) {
; SI-LABEL: ps_mesa_inreg_v2i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_lshl_b32 s1, s1, 16
; SI-NEXT:    s_add_i32 s0, s0, 1
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_and_b32 s0, s0, 0xffff
; SI-NEXT:    s_or_b32 s0, s1, s0
; SI-NEXT:    s_add_i32 s0, s0, 0x10000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_inreg_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_and_b32 s1, s0, 0xffff0000
; VI-NEXT:    s_add_i32 s0, s0, 1
; VI-NEXT:    s_and_b32 s0, s0, 0xffff
; VI-NEXT:    s_or_b32 s0, s1, s0
; VI-NEXT:    s_add_i32 s0, s0, 0x10000
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_inreg_v2i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 1 op_sel_hi:[1,0]
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  %add = add <2 x i16> %arg0, <i16 1, i16 1>
  store <2 x i16> %add, ptr addrspace(1) poison
  ret void
}

; FIXME: Differenet ABI for VI+

define amdgpu_ps <4 x half> @ps_mesa_v4f16(<4 x half> %arg0) {
; SI-LABEL: ps_mesa_v4f16:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: ps_mesa_v4f16:
; VI:       ; %bb.0:
; VI-NEXT:    v_mov_b32_e32 v3, 0x3c00
; VI-NEXT:    v_add_f16_e32 v2, 1.0, v1
; VI-NEXT:    v_add_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 1.0, v0
; VI-NEXT:    v_add_f16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v4, v0
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: ps_mesa_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_pk_add_f16 v0, v0, 1.0 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_f16 v1, v1, 1.0 op_sel_hi:[1,0]
; GFX11-NEXT:    ; return to shader part epilog
  %add = fadd <4 x half> %arg0, <half 1.0, half 1.0, half 1.0, half 1.0>
  ret <4 x half> %add
}

define amdgpu_ps <4 x half> @ps_mesa_inreg_v4f16(<4 x half> inreg %arg0) {
; SI-LABEL: ps_mesa_inreg_v4f16:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, s3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, s2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, s1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v3
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v4
; SI-NEXT:    ; return to shader part epilog
;
; VI-LABEL: ps_mesa_inreg_v4f16:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e64 v1, s1, 1.0
; VI-NEXT:    s_lshr_b32 s1, s1, 16
; VI-NEXT:    v_mov_b32_e32 v0, s1
; VI-NEXT:    v_mov_b32_e32 v2, 0x3c00
; VI-NEXT:    v_add_f16_sdwa v3, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e64 v0, s0, 1.0
; VI-NEXT:    s_lshr_b32 s0, s0, 16
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    v_add_f16_sdwa v2, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: ps_mesa_inreg_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_pk_add_f16 v0, s0, 1.0 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_f16 v1, s1, 1.0 op_sel_hi:[1,0]
; GFX11-NEXT:    ; return to shader part epilog
  %add = fadd <4 x half> %arg0, <half 1.0, half 1.0, half 1.0, half 1.0>
  ret <4 x half> %add
}

define amdgpu_ps void @ps_mesa_inreg_v3i32(<3 x i32> inreg %arg0) {
; SI-LABEL: ps_mesa_inreg_v3i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_add_i32 s1, s1, 2
; SI-NEXT:    s_add_i32 s0, s0, 1
; SI-NEXT:    s_add_i32 s4, s2, 3
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_inreg_v3i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_add_i32 s2, s2, 3
; VI-NEXT:    s_add_i32 s1, s1, 2
; VI-NEXT:    s_add_i32 s0, s0, 1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dwordx3 v[0:1], v[0:2]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_inreg_v3i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 1
; GFX11-NEXT:    s_add_i32 s1, s1, 2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    global_store_b96 v[0:1], v[0:2], off
; GFX11-NEXT:    s_endpgm
  %add = add <3 x i32> %arg0, <i32 1, i32 2, i32 3>
  store <3 x i32> %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_inreg_v3f32(<3 x float> inreg %arg0) {
; SI-LABEL: ps_mesa_inreg_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v1, s1, 2.0
; SI-NEXT:    v_add_f32_e64 v0, s0, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s2, 4.0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_inreg_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v2, s2, 4.0
; VI-NEXT:    v_add_f32_e64 v1, s1, 2.0
; VI-NEXT:    v_add_f32_e64 v0, s0, 1.0
; VI-NEXT:    flat_store_dwordx3 v[0:1], v[0:2]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_inreg_v3f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 4.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 2.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    global_store_b96 v[0:1], v[0:2], off
; GFX11-NEXT:    s_endpgm
  %add = fadd <3 x float> %arg0, <float 1.0, float 2.0, float 4.0>
  store <3 x float> %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_inreg_v5i32(<5 x i32> inreg %arg0) {
; SI-LABEL: ps_mesa_inreg_v5i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_add_i32 s5, s3, 4
; SI-NEXT:    s_add_i32 s6, s2, 3
; SI-NEXT:    s_add_i32 s1, s1, 2
; SI-NEXT:    s_add_i32 s0, s0, 1
; SI-NEXT:    s_add_i32 s4, s4, 5
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s5
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_inreg_v5i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_add_i32 s4, s4, 5
; VI-NEXT:    s_add_i32 s3, s3, 4
; VI-NEXT:    s_add_i32 s2, s2, 3
; VI-NEXT:    s_add_i32 s1, s1, 2
; VI-NEXT:    s_add_i32 s0, s0, 1
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_inreg_v5i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_add_i32 s3, s3, 4
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 2
; GFX11-NEXT:    s_add_i32 s4, s4, 5
; GFX11-NEXT:    s_add_i32 s0, s0, 1
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b32 v[0:1], v4, off
; GFX11-NEXT:    global_store_b128 v[0:1], v[0:3], off
; GFX11-NEXT:    s_endpgm
  %add = add <5 x i32> %arg0, <i32 1, i32 2, i32 3, i32 4, i32 5>
  store <5 x i32> %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_inreg_v5f32(<5 x float> inreg %arg0) {
; SI-LABEL: ps_mesa_inreg_v5f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v3, s3, -1.0
; SI-NEXT:    v_add_f32_e64 v2, s2, 4.0
; SI-NEXT:    v_add_f32_e64 v1, s1, 2.0
; SI-NEXT:    v_add_f32_e64 v0, s0, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s4, 0.5
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_inreg_v5f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v3, s3, -1.0
; VI-NEXT:    v_add_f32_e64 v2, s2, 4.0
; VI-NEXT:    v_add_f32_e64 v1, s1, 2.0
; VI-NEXT:    v_add_f32_e64 v0, s0, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s4, 0.5
; VI-NEXT:    flat_store_dword v[0:1], v4
; VI-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_inreg_v5f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v3, s3, -1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 4.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 2.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 0.5
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b32 v[0:1], v4, off
; GFX11-NEXT:    global_store_b128 v[0:1], v[0:3], off
; GFX11-NEXT:    s_endpgm
  %add = fadd <5 x float> %arg0, <float 1.0, float 2.0, float 4.0, float -1.0, float 0.5>
  store <5 x float> %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_v3i32(<3 x i32> %arg0) {
; SI-LABEL: ps_mesa_v3i32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_i32_e32 v1, vcc, 2, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_v3i32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 2, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; VI-NEXT:    flat_store_dwordx3 v[0:1], v[0:2]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_v3i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 2, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX11-NEXT:    global_store_b96 v[0:1], v[0:2], off
; GFX11-NEXT:    s_endpgm
  %add = add <3 x i32> %arg0, <i32 1, i32 2, i32 3>
  store <3 x i32> %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_v3f32(<3 x float> %arg0) {
; SI-LABEL: ps_mesa_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v1, 2.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v2, 4.0, v2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v2, 4.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 2.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    flat_store_dwordx3 v[0:1], v[0:2]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_v3f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_dual_add_f32 v2, 4.0, v2 :: v_dual_add_f32 v1, 2.0, v1
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    global_store_b96 v[0:1], v[0:2], off
; GFX11-NEXT:    s_endpgm
  %add = fadd <3 x float> %arg0, <float 1.0, float 2.0, float 4.0>
  store <3 x float> %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_v5i32(<5 x i32> %arg0) {
; SI-LABEL: ps_mesa_v5i32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_i32_e32 v3, vcc, 4, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 2, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 1, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, 5, v4
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_v5i32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_u32_e32 v3, vcc, 4, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 2, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 1, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 5, v4
; VI-NEXT:    flat_store_dword v[0:1], v4
; VI-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_v5i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 4, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 2, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 5, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 1, v0
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b32 v[0:1], v4, off
; GFX11-NEXT:    global_store_b128 v[0:1], v[0:3], off
; GFX11-NEXT:    s_endpgm
  %add = add <5 x i32> %arg0, <i32 1, i32 2, i32 3, i32 4, i32 5>
  store <5 x i32> %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_v5f32(<5 x float> %arg0) {
; SI-LABEL: ps_mesa_v5f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v3, -1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 4.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 2.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v4, 0.5, v4
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v4, off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_v5f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v3, -1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 4.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 2.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e32 v4, 0.5, v4
; VI-NEXT:    flat_store_dword v[0:1], v4
; VI-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_v5f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_dual_add_f32 v3, -1.0, v3 :: v_dual_add_f32 v2, 4.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 2.0, v1 :: v_dual_add_f32 v4, 0.5, v4
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b32 v[0:1], v4, off
; GFX11-NEXT:    global_store_b128 v[0:1], v[0:3], off
; GFX11-NEXT:    s_endpgm
  %add = fadd <5 x float> %arg0, <float 1.0, float 2.0, float 4.0, float -1.0, float 0.5>
  store <5 x float> %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_i16(i16 %arg0) {
; SI-LABEL: ps_mesa_i16:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_i32_e32 v0, vcc, v0, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_i16:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_u16_e32 v0, v0, v0
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: ps_mesa_i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v0.l
; GFX11-TRUE16-NEXT:    global_store_b16 v[0:1], v0, off
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: ps_mesa_i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v0
; GFX11-FAKE16-NEXT:    global_store_b16 v[0:1], v0, off
; GFX11-FAKE16-NEXT:    s_endpgm
  %add = add i16 %arg0, %arg0
  store i16 %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps void @ps_mesa_inreg_i16(i16 inreg %arg0) {
; SI-LABEL: ps_mesa_inreg_i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_add_i32 s0, s0, s0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: ps_mesa_inreg_i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_add_i32 s0, s0, s0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: ps_mesa_inreg_i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_add_i32 s0, s0, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    global_store_b16 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  %add = add i16 %arg0, %arg0
  store i16 %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_ps i16 @ret_ps_mesa_i16() {
; GCN-LABEL: ret_ps_mesa_i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_movk_i32 s0, 0x7b
; GCN-NEXT:    ; return to shader part epilog
  ret i16 123
}

define amdgpu_kernel void @amd_kernel_i8(i8 %arg0) {
; SI-LABEL: amd_kernel_i8:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s0, s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_add_i32 s0, s0, s0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amd_kernel_i8:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s0, s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_add_i32 s0, s0, s0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    flat_store_byte v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amd_kernel_i8:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s0, s0, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    global_store_b8 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
entry:
  %add = add i8 %arg0, %arg0
  store i8 %add, ptr addrspace(1) poison
  ret void
}

define amdgpu_kernel void @amd_kernel_v2i8(<2 x i8> %arg0) {
; SI-LABEL: amd_kernel_v2i8:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s2, s[4:5], 0x9
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bfe_u32 s4, s2, 0x80008
; SI-NEXT:    s_add_i32 s2, s2, s2
; SI-NEXT:    s_and_b32 s2, s2, 0xff
; SI-NEXT:    s_add_i32 s4, s4, s4
; SI-NEXT:    s_lshl_b32 s4, s4, 8
; SI-NEXT:    s_or_b32 s4, s2, s4
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amd_kernel_v2i8:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s0, s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v0, 0
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bfe_u32 s1, s0, 0x80008
; VI-NEXT:    s_add_i32 s0, s0, s0
; VI-NEXT:    s_add_i32 s1, s1, s1
; VI-NEXT:    s_and_b32 s0, s0, 0xff
; VI-NEXT:    s_lshl_b32 s1, s1, 8
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amd_kernel_v2i8:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_bfe_u32 s1, s0, 0x80008
; GFX11-NEXT:    s_add_i32 s0, s0, s0
; GFX11-NEXT:    s_add_i32 s1, s1, s1
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX11-NEXT:    global_store_b16 v[0:1], v2, off
; GFX11-NEXT:    s_endpgm
entry:
  %add = add <2 x i8> %arg0, %arg0
  store <2 x i8> %add, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @amd_kernel_v4i8(<4 x i8> %arg0) {
; SI-LABEL: amd_kernel_v4i8:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s2, s[4:5], 0x9
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s4, s2, 16
; SI-NEXT:    s_lshr_b32 s5, s2, 24
; SI-NEXT:    s_bfe_u32 s6, s2, 0x80008
; SI-NEXT:    s_add_i32 s2, s2, s2
; SI-NEXT:    s_add_i32 s5, s5, s5
; SI-NEXT:    s_add_i32 s4, s4, s4
; SI-NEXT:    s_and_b32 s2, s2, 0xff
; SI-NEXT:    s_add_i32 s6, s6, s6
; SI-NEXT:    s_lshl_b32 s5, s5, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 8
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_or_b32 s2, s2, s6
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s2, s2, 0xffff
; SI-NEXT:    s_or_b32 s4, s2, s4
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amd_kernel_v4i8:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s0, s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v0, 0
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s1, s0, 16
; VI-NEXT:    s_lshr_b32 s2, s0, 24
; VI-NEXT:    s_bfe_u32 s3, s0, 0x80008
; VI-NEXT:    s_add_i32 s2, s2, s2
; VI-NEXT:    s_add_i32 s1, s1, s1
; VI-NEXT:    s_lshl_b32 s2, s2, 8
; VI-NEXT:    s_and_b32 s1, s1, 0xff
; VI-NEXT:    s_add_i32 s0, s0, s0
; VI-NEXT:    s_add_i32 s3, s3, s3
; VI-NEXT:    s_or_b32 s1, s1, s2
; VI-NEXT:    s_and_b32 s0, s0, 0xff
; VI-NEXT:    s_lshl_b32 s2, s3, 8
; VI-NEXT:    s_or_b32 s0, s0, s2
; VI-NEXT:    s_lshl_b32 s1, s1, 16
; VI-NEXT:    s_and_b32 s0, s0, 0xffff
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amd_kernel_v4i8:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s1, s0, 16
; GFX11-NEXT:    s_lshr_b32 s2, s0, 24
; GFX11-NEXT:    s_add_i32 s3, s0, s0
; GFX11-NEXT:    s_bfe_u32 s0, s0, 0x80008
; GFX11-NEXT:    s_add_i32 s2, s2, s2
; GFX11-NEXT:    s_add_i32 s0, s0, s0
; GFX11-NEXT:    s_add_i32 s1, s1, s1
; GFX11-NEXT:    s_and_b32 s3, s3, 0xff
; GFX11-NEXT:    s_lshl_b32 s0, s0, 8
; GFX11-NEXT:    s_lshl_b32 s2, s2, 8
; GFX11-NEXT:    s_and_b32 s1, s1, 0xff
; GFX11-NEXT:    s_or_b32 s0, s3, s0
; GFX11-NEXT:    s_or_b32 s1, s1, s2
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s0
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_endpgm
entry:
  %add = add <4 x i8> %arg0, %arg0
  store <4 x i8> %add, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @amd_kernel_v3i8(<3 x i8> %arg0) {
; SI-LABEL: amd_kernel_v3i8:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s4, s[4:5], 0x9
; SI-NEXT:    s_mov_b64 s[0:1], 2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s5, s4, 16
; SI-NEXT:    s_bfe_u32 s6, s4, 0x80008
; SI-NEXT:    s_add_i32 s4, s4, s4
; SI-NEXT:    s_and_b32 s4, s4, 0xff
; SI-NEXT:    s_add_i32 s6, s6, s6
; SI-NEXT:    s_add_i32 s5, s5, s5
; SI-NEXT:    s_lshl_b32 s6, s6, 8
; SI-NEXT:    v_mov_b32_e32 v0, s5
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_or_b32 s4, s4, s6
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amd_kernel_v3i8:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s0, s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v0, 2
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s1, s0, 16
; VI-NEXT:    s_bfe_u32 s2, s0, 0x80008
; VI-NEXT:    s_add_i32 s0, s0, s0
; VI-NEXT:    s_add_i32 s2, s2, s2
; VI-NEXT:    s_add_i32 s1, s1, s1
; VI-NEXT:    s_and_b32 s0, s0, 0xff
; VI-NEXT:    s_lshl_b32 s2, s2, 8
; VI-NEXT:    v_mov_b32_e32 v2, s1
; VI-NEXT:    s_or_b32 s0, s0, s2
; VI-NEXT:    flat_store_byte v[0:1], v2
; VI-NEXT:    v_mov_b32_e32 v0, 0
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amd_kernel_v3i8:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX11-NEXT:    s_lshr_b32 s1, s0, 16
; GFX11-NEXT:    s_add_i32 s0, s0, s0
; GFX11-NEXT:    s_add_i32 s2, s2, s2
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 8
; GFX11-NEXT:    s_add_i32 s1, s1, s1
; GFX11-NEXT:    s_or_b32 s0, s0, s2
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v4, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v5, s0
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b8 v[0:1], v4, off
; GFX11-NEXT:    global_store_b16 v[2:3], v5, off
; GFX11-NEXT:    s_endpgm
entry:
  %add = add <3 x i8> %arg0, %arg0
  store <3 x i8> %add, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @amd_kernel_v5i8(<5 x i8> %arg0) {
; SI-LABEL: amd_kernel_v5i8:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x9
; SI-NEXT:    s_mov_b64 s[0:1], 4
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s6, s4, 16
; SI-NEXT:    s_lshr_b32 s7, s4, 24
; SI-NEXT:    s_bfe_u32 s8, s4, 0x80008
; SI-NEXT:    s_add_i32 s4, s4, s4
; SI-NEXT:    s_add_i32 s5, s5, s5
; SI-NEXT:    s_add_i32 s7, s7, s7
; SI-NEXT:    s_add_i32 s6, s6, s6
; SI-NEXT:    s_and_b32 s4, s4, 0xff
; SI-NEXT:    s_add_i32 s8, s8, s8
; SI-NEXT:    v_mov_b32_e32 v0, s5
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_lshl_b32 s0, s7, 24
; SI-NEXT:    s_and_b32 s1, s6, 0xff
; SI-NEXT:    s_lshl_b32 s5, s8, 8
; SI-NEXT:    s_lshl_b32 s1, s1, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_or_b32 s0, s0, s1
; SI-NEXT:    s_and_b32 s1, s4, 0xffff
; SI-NEXT:    s_or_b32 s4, s1, s0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amd_kernel_v5i8:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v0, 4
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s2, s0, 16
; VI-NEXT:    s_lshr_b32 s3, s0, 24
; VI-NEXT:    s_bfe_u32 s4, s0, 0x80008
; VI-NEXT:    s_add_i32 s3, s3, s3
; VI-NEXT:    s_add_i32 s2, s2, s2
; VI-NEXT:    s_lshl_b32 s3, s3, 8
; VI-NEXT:    s_and_b32 s2, s2, 0xff
; VI-NEXT:    s_add_i32 s0, s0, s0
; VI-NEXT:    s_add_i32 s4, s4, s4
; VI-NEXT:    s_or_b32 s2, s2, s3
; VI-NEXT:    s_and_b32 s0, s0, 0xff
; VI-NEXT:    s_lshl_b32 s3, s4, 8
; VI-NEXT:    s_or_b32 s0, s0, s3
; VI-NEXT:    s_add_i32 s1, s1, s1
; VI-NEXT:    s_lshl_b32 s2, s2, 16
; VI-NEXT:    s_and_b32 s0, s0, 0xffff
; VI-NEXT:    v_mov_b32_e32 v2, s1
; VI-NEXT:    s_or_b32 s0, s0, s2
; VI-NEXT:    flat_store_byte v[0:1], v2
; VI-NEXT:    v_mov_b32_e32 v0, 0
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amd_kernel_v5i8:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 4
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s2, s0, 16
; GFX11-NEXT:    s_lshr_b32 s3, s0, 24
; GFX11-NEXT:    s_add_i32 s4, s0, s0
; GFX11-NEXT:    s_bfe_u32 s0, s0, 0x80008
; GFX11-NEXT:    s_add_i32 s3, s3, s3
; GFX11-NEXT:    s_add_i32 s0, s0, s0
; GFX11-NEXT:    s_add_i32 s2, s2, s2
; GFX11-NEXT:    s_and_b32 s4, s4, 0xff
; GFX11-NEXT:    s_lshl_b32 s0, s0, 8
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_or_b32 s0, s4, s0
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    s_add_i32 s1, s1, s1
; GFX11-NEXT:    s_or_b32 s0, s0, s2
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v4, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v5, s0
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b8 v[0:1], v4, off
; GFX11-NEXT:    global_store_b32 v[2:3], v5, off
; GFX11-NEXT:    s_endpgm
entry:
  %add = add <5 x i8> %arg0, %arg0
  store <5 x i8> %add, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @amd_kernel_v8i8(<8 x i8> %arg0) {
; SI-LABEL: amd_kernel_v8i8:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x9
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s2, s4, 16
; SI-NEXT:    s_lshr_b32 s6, s4, 24
; SI-NEXT:    s_lshr_b32 s7, s5, 16
; SI-NEXT:    s_lshr_b32 s8, s5, 24
; SI-NEXT:    s_bfe_u32 s9, s4, 0x80008
; SI-NEXT:    s_bfe_u32 s10, s5, 0x80008
; SI-NEXT:    s_add_i32 s5, s5, s5
; SI-NEXT:    s_add_i32 s4, s4, s4
; SI-NEXT:    s_add_i32 s8, s8, s8
; SI-NEXT:    s_add_i32 s7, s7, s7
; SI-NEXT:    s_and_b32 s5, s5, 0xff
; SI-NEXT:    s_add_i32 s10, s10, s10
; SI-NEXT:    s_add_i32 s6, s6, s6
; SI-NEXT:    s_add_i32 s2, s2, s2
; SI-NEXT:    s_and_b32 s4, s4, 0xff
; SI-NEXT:    s_add_i32 s9, s9, s9
; SI-NEXT:    s_lshl_b32 s8, s8, 24
; SI-NEXT:    s_and_b32 s7, s7, 0xff
; SI-NEXT:    s_lshl_b32 s10, s10, 8
; SI-NEXT:    s_lshl_b32 s6, s6, 24
; SI-NEXT:    s_and_b32 s2, s2, 0xff
; SI-NEXT:    s_lshl_b32 s9, s9, 8
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_or_b32 s5, s5, s10
; SI-NEXT:    s_lshl_b32 s2, s2, 16
; SI-NEXT:    s_or_b32 s4, s4, s9
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s2, s6, s2
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s7
; SI-NEXT:    s_or_b32 s4, s4, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amd_kernel_v8i8:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v2, 0
; VI-NEXT:    v_mov_b32_e32 v3, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s2, s0, 16
; VI-NEXT:    s_lshr_b32 s3, s0, 24
; VI-NEXT:    s_lshr_b32 s4, s1, 16
; VI-NEXT:    s_lshr_b32 s5, s1, 24
; VI-NEXT:    s_bfe_u32 s6, s0, 0x80008
; VI-NEXT:    s_bfe_u32 s7, s1, 0x80008
; VI-NEXT:    s_add_i32 s5, s5, s5
; VI-NEXT:    s_add_i32 s4, s4, s4
; VI-NEXT:    s_add_i32 s3, s3, s3
; VI-NEXT:    s_add_i32 s2, s2, s2
; VI-NEXT:    s_lshl_b32 s5, s5, 8
; VI-NEXT:    s_and_b32 s4, s4, 0xff
; VI-NEXT:    s_add_i32 s1, s1, s1
; VI-NEXT:    s_add_i32 s7, s7, s7
; VI-NEXT:    s_lshl_b32 s3, s3, 8
; VI-NEXT:    s_and_b32 s2, s2, 0xff
; VI-NEXT:    s_add_i32 s0, s0, s0
; VI-NEXT:    s_add_i32 s6, s6, s6
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s1, s1, 0xff
; VI-NEXT:    s_lshl_b32 s5, s7, 8
; VI-NEXT:    s_or_b32 s2, s2, s3
; VI-NEXT:    s_and_b32 s0, s0, 0xff
; VI-NEXT:    s_lshl_b32 s3, s6, 8
; VI-NEXT:    s_or_b32 s1, s1, s5
; VI-NEXT:    s_or_b32 s0, s0, s3
; VI-NEXT:    s_lshl_b32 s4, s4, 16
; VI-NEXT:    s_and_b32 s1, s1, 0xffff
; VI-NEXT:    s_lshl_b32 s2, s2, 16
; VI-NEXT:    s_and_b32 s0, s0, 0xffff
; VI-NEXT:    s_or_b32 s1, s1, s4
; VI-NEXT:    s_or_b32 s0, s0, s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amd_kernel_v8i8:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s2, s0, 16
; GFX11-NEXT:    s_lshr_b32 s3, s0, 24
; GFX11-NEXT:    s_lshr_b32 s4, s1, 16
; GFX11-NEXT:    s_lshr_b32 s5, s1, 24
; GFX11-NEXT:    s_bfe_u32 s6, s0, 0x80008
; GFX11-NEXT:    s_bfe_u32 s7, s1, 0x80008
; GFX11-NEXT:    s_add_i32 s1, s1, s1
; GFX11-NEXT:    s_add_i32 s0, s0, s0
; GFX11-NEXT:    s_add_i32 s7, s7, s7
; GFX11-NEXT:    s_add_i32 s5, s5, s5
; GFX11-NEXT:    s_add_i32 s4, s4, s4
; GFX11-NEXT:    s_add_i32 s6, s6, s6
; GFX11-NEXT:    s_add_i32 s3, s3, s3
; GFX11-NEXT:    s_add_i32 s2, s2, s2
; GFX11-NEXT:    s_and_b32 s1, s1, 0xff
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s7, 8
; GFX11-NEXT:    s_lshl_b32 s5, s5, 8
; GFX11-NEXT:    s_and_b32 s4, s4, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 8
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_or_b32 s1, s1, s7
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s0, s0, s6
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    s_lshl_b32 s3, s4, 16
; GFX11-NEXT:    s_or_b32 s0, s0, s2
; GFX11-NEXT:    s_or_b32 s1, s1, s3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, 0
; GFX11-NEXT:    global_store_b64 v[2:3], v[0:1], off
; GFX11-NEXT:    s_endpgm
entry:
  %add = add <8 x i8> %arg0, %arg0
  store <8 x i8> %add, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @amd_kernel_v16i8(<16 x i8> %arg0) {
; SI-LABEL: amd_kernel_v16i8:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s6, s0, 16
; SI-NEXT:    s_lshr_b32 s8, s0, 24
; SI-NEXT:    s_lshr_b32 s9, s1, 16
; SI-NEXT:    s_lshr_b32 s10, s1, 24
; SI-NEXT:    s_lshr_b32 s11, s2, 16
; SI-NEXT:    s_lshr_b32 s12, s2, 24
; SI-NEXT:    s_lshr_b32 s13, s3, 16
; SI-NEXT:    s_lshr_b32 s14, s3, 24
; SI-NEXT:    s_bfe_u32 s15, s0, 0x80008
; SI-NEXT:    s_bfe_u32 s16, s1, 0x80008
; SI-NEXT:    s_bfe_u32 s17, s2, 0x80008
; SI-NEXT:    s_bfe_u32 s18, s3, 0x80008
; SI-NEXT:    s_add_i32 s3, s3, s3
; SI-NEXT:    s_add_i32 s2, s2, s2
; SI-NEXT:    s_add_i32 s1, s1, s1
; SI-NEXT:    s_add_i32 s0, s0, s0
; SI-NEXT:    s_add_i32 s14, s14, s14
; SI-NEXT:    s_add_i32 s13, s13, s13
; SI-NEXT:    s_and_b32 s3, s3, 0xff
; SI-NEXT:    s_add_i32 s18, s18, s18
; SI-NEXT:    s_add_i32 s12, s12, s12
; SI-NEXT:    s_add_i32 s11, s11, s11
; SI-NEXT:    s_and_b32 s2, s2, 0xff
; SI-NEXT:    s_add_i32 s17, s17, s17
; SI-NEXT:    s_add_i32 s10, s10, s10
; SI-NEXT:    s_add_i32 s9, s9, s9
; SI-NEXT:    s_and_b32 s1, s1, 0xff
; SI-NEXT:    s_add_i32 s16, s16, s16
; SI-NEXT:    s_add_i32 s8, s8, s8
; SI-NEXT:    s_add_i32 s6, s6, s6
; SI-NEXT:    s_and_b32 s0, s0, 0xff
; SI-NEXT:    s_add_i32 s15, s15, s15
; SI-NEXT:    s_lshl_b32 s14, s14, 24
; SI-NEXT:    s_and_b32 s13, s13, 0xff
; SI-NEXT:    s_lshl_b32 s18, s18, 8
; SI-NEXT:    s_lshl_b32 s12, s12, 24
; SI-NEXT:    s_and_b32 s11, s11, 0xff
; SI-NEXT:    s_lshl_b32 s17, s17, 8
; SI-NEXT:    s_lshl_b32 s10, s10, 24
; SI-NEXT:    s_and_b32 s9, s9, 0xff
; SI-NEXT:    s_lshl_b32 s16, s16, 8
; SI-NEXT:    s_lshl_b32 s8, s8, 24
; SI-NEXT:    s_and_b32 s6, s6, 0xff
; SI-NEXT:    s_lshl_b32 s15, s15, 8
; SI-NEXT:    s_lshl_b32 s13, s13, 16
; SI-NEXT:    s_or_b32 s3, s3, s18
; SI-NEXT:    s_lshl_b32 s11, s11, 16
; SI-NEXT:    s_or_b32 s2, s2, s17
; SI-NEXT:    s_lshl_b32 s9, s9, 16
; SI-NEXT:    s_or_b32 s1, s1, s16
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_or_b32 s0, s0, s15
; SI-NEXT:    s_or_b32 s13, s14, s13
; SI-NEXT:    s_and_b32 s3, s3, 0xffff
; SI-NEXT:    s_or_b32 s11, s12, s11
; SI-NEXT:    s_and_b32 s2, s2, 0xffff
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s1, s1, 0xffff
; SI-NEXT:    s_or_b32 s6, s8, s6
; SI-NEXT:    s_and_b32 s0, s0, 0xffff
; SI-NEXT:    s_or_b32 s3, s3, s13
; SI-NEXT:    s_or_b32 s2, s2, s11
; SI-NEXT:    s_or_b32 s1, s1, s9
; SI-NEXT:    s_or_b32 s0, s0, s6
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amd_kernel_v16i8:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v4, 0
; VI-NEXT:    v_mov_b32_e32 v5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s4, s0, 16
; VI-NEXT:    s_lshr_b32 s5, s0, 24
; VI-NEXT:    s_lshr_b32 s6, s1, 16
; VI-NEXT:    s_lshr_b32 s7, s1, 24
; VI-NEXT:    s_lshr_b32 s8, s2, 16
; VI-NEXT:    s_lshr_b32 s9, s2, 24
; VI-NEXT:    s_lshr_b32 s10, s3, 16
; VI-NEXT:    s_lshr_b32 s11, s3, 24
; VI-NEXT:    s_bfe_u32 s12, s0, 0x80008
; VI-NEXT:    s_bfe_u32 s13, s1, 0x80008
; VI-NEXT:    s_bfe_u32 s14, s2, 0x80008
; VI-NEXT:    s_bfe_u32 s15, s3, 0x80008
; VI-NEXT:    s_add_i32 s11, s11, s11
; VI-NEXT:    s_add_i32 s10, s10, s10
; VI-NEXT:    s_add_i32 s9, s9, s9
; VI-NEXT:    s_add_i32 s8, s8, s8
; VI-NEXT:    s_add_i32 s7, s7, s7
; VI-NEXT:    s_add_i32 s6, s6, s6
; VI-NEXT:    s_add_i32 s5, s5, s5
; VI-NEXT:    s_add_i32 s4, s4, s4
; VI-NEXT:    s_lshl_b32 s11, s11, 8
; VI-NEXT:    s_and_b32 s10, s10, 0xff
; VI-NEXT:    s_add_i32 s3, s3, s3
; VI-NEXT:    s_add_i32 s15, s15, s15
; VI-NEXT:    s_lshl_b32 s9, s9, 8
; VI-NEXT:    s_and_b32 s8, s8, 0xff
; VI-NEXT:    s_add_i32 s2, s2, s2
; VI-NEXT:    s_add_i32 s14, s14, s14
; VI-NEXT:    s_lshl_b32 s7, s7, 8
; VI-NEXT:    s_and_b32 s6, s6, 0xff
; VI-NEXT:    s_add_i32 s1, s1, s1
; VI-NEXT:    s_add_i32 s13, s13, s13
; VI-NEXT:    s_lshl_b32 s5, s5, 8
; VI-NEXT:    s_and_b32 s4, s4, 0xff
; VI-NEXT:    s_add_i32 s0, s0, s0
; VI-NEXT:    s_add_i32 s12, s12, s12
; VI-NEXT:    s_or_b32 s10, s10, s11
; VI-NEXT:    s_and_b32 s3, s3, 0xff
; VI-NEXT:    s_lshl_b32 s11, s15, 8
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    s_and_b32 s2, s2, 0xff
; VI-NEXT:    s_lshl_b32 s9, s14, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s1, s1, 0xff
; VI-NEXT:    s_lshl_b32 s7, s13, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s0, s0, 0xff
; VI-NEXT:    s_lshl_b32 s5, s12, 8
; VI-NEXT:    s_or_b32 s3, s3, s11
; VI-NEXT:    s_or_b32 s2, s2, s9
; VI-NEXT:    s_or_b32 s1, s1, s7
; VI-NEXT:    s_or_b32 s0, s0, s5
; VI-NEXT:    s_lshl_b32 s10, s10, 16
; VI-NEXT:    s_and_b32 s3, s3, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_and_b32 s2, s2, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_and_b32 s1, s1, 0xffff
; VI-NEXT:    s_lshl_b32 s4, s4, 16
; VI-NEXT:    s_and_b32 s0, s0, 0xffff
; VI-NEXT:    s_or_b32 s3, s3, s10
; VI-NEXT:    s_or_b32 s2, s2, s8
; VI-NEXT:    s_or_b32 s1, s1, s6
; VI-NEXT:    s_or_b32 s0, s0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amd_kernel_v16i8:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s6, s1, 16
; GFX11-NEXT:    s_lshr_b32 s7, s1, 24
; GFX11-NEXT:    s_lshr_b32 s8, s2, 16
; GFX11-NEXT:    s_lshr_b32 s9, s2, 24
; GFX11-NEXT:    s_lshr_b32 s10, s3, 16
; GFX11-NEXT:    s_lshr_b32 s11, s3, 24
; GFX11-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-NEXT:    s_lshr_b32 s5, s0, 24
; GFX11-NEXT:    s_bfe_u32 s12, s0, 0x80008
; GFX11-NEXT:    s_bfe_u32 s13, s1, 0x80008
; GFX11-NEXT:    s_bfe_u32 s14, s2, 0x80008
; GFX11-NEXT:    s_bfe_u32 s15, s3, 0x80008
; GFX11-NEXT:    s_add_i32 s11, s11, s11
; GFX11-NEXT:    s_add_i32 s10, s10, s10
; GFX11-NEXT:    s_add_i32 s9, s9, s9
; GFX11-NEXT:    s_add_i32 s8, s8, s8
; GFX11-NEXT:    s_add_i32 s7, s7, s7
; GFX11-NEXT:    s_add_i32 s6, s6, s6
; GFX11-NEXT:    s_add_i32 s3, s3, s3
; GFX11-NEXT:    s_add_i32 s2, s2, s2
; GFX11-NEXT:    s_add_i32 s15, s15, s15
; GFX11-NEXT:    s_add_i32 s14, s14, s14
; GFX11-NEXT:    s_lshl_b32 s11, s11, 8
; GFX11-NEXT:    s_and_b32 s10, s10, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 8
; GFX11-NEXT:    s_and_b32 s8, s8, 0xff
; GFX11-NEXT:    s_add_i32 s1, s1, s1
; GFX11-NEXT:    s_add_i32 s13, s13, s13
; GFX11-NEXT:    s_lshl_b32 s7, s7, 8
; GFX11-NEXT:    s_and_b32 s6, s6, 0xff
; GFX11-NEXT:    s_add_i32 s0, s0, s0
; GFX11-NEXT:    s_add_i32 s12, s12, s12
; GFX11-NEXT:    s_add_i32 s5, s5, s5
; GFX11-NEXT:    s_add_i32 s4, s4, s4
; GFX11-NEXT:    s_and_b32 s3, s3, 0xff
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s15, s15, 8
; GFX11-NEXT:    s_or_b32 s10, s10, s11
; GFX11-NEXT:    s_lshl_b32 s11, s14, 8
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_and_b32 s1, s1, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s13, 8
; GFX11-NEXT:    s_or_b32 s6, s6, s7
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s7, s12, 8
; GFX11-NEXT:    s_lshl_b32 s5, s5, 8
; GFX11-NEXT:    s_and_b32 s4, s4, 0xff
; GFX11-NEXT:    s_or_b32 s3, s3, s15
; GFX11-NEXT:    s_or_b32 s2, s2, s11
; GFX11-NEXT:    s_or_b32 s1, s1, s9
; GFX11-NEXT:    s_or_b32 s0, s0, s7
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX11-NEXT:    s_lshl_b32 s10, s10, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s4, s4, 16
; GFX11-NEXT:    s_lshl_b32 s5, s6, 16
; GFX11-NEXT:    s_or_b32 s3, s3, s10
; GFX11-NEXT:    s_or_b32 s2, s2, s8
; GFX11-NEXT:    s_or_b32 s0, s0, s4
; GFX11-NEXT:    s_or_b32 s1, s1, s5
; GFX11-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, 0
; GFX11-NEXT:    global_store_b128 v[4:5], v[0:3], off
; GFX11-NEXT:    s_endpgm
entry:
  %add = add <16 x i8> %arg0, %arg0
  store <16 x i8> %add, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @amd_kernel_v32i8(<32 x i8> %arg0) {
; SI-LABEL: amd_kernel_v32i8:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; SI-NEXT:    s_mov_b64 s[8:9], 16
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s12, s4, 16
; SI-NEXT:    s_lshr_b32 s13, s4, 24
; SI-NEXT:    s_lshr_b32 s14, s5, 16
; SI-NEXT:    s_lshr_b32 s15, s5, 24
; SI-NEXT:    s_lshr_b32 s16, s6, 16
; SI-NEXT:    s_lshr_b32 s17, s6, 24
; SI-NEXT:    s_lshr_b32 s18, s7, 16
; SI-NEXT:    s_lshr_b32 s19, s7, 24
; SI-NEXT:    s_lshr_b32 s20, s0, 16
; SI-NEXT:    s_lshr_b32 s21, s0, 24
; SI-NEXT:    s_lshr_b32 s22, s1, 16
; SI-NEXT:    s_lshr_b32 s23, s1, 24
; SI-NEXT:    s_lshr_b32 s24, s2, 16
; SI-NEXT:    s_lshr_b32 s25, s2, 24
; SI-NEXT:    s_lshr_b32 s26, s3, 16
; SI-NEXT:    s_lshr_b32 s27, s3, 24
; SI-NEXT:    s_bfe_u32 s28, s4, 0x80008
; SI-NEXT:    s_bfe_u32 s29, s5, 0x80008
; SI-NEXT:    s_bfe_u32 s30, s6, 0x80008
; SI-NEXT:    s_bfe_u32 s31, s7, 0x80008
; SI-NEXT:    s_bfe_u32 s33, s0, 0x80008
; SI-NEXT:    s_bfe_u32 s34, s1, 0x80008
; SI-NEXT:    s_bfe_u32 s35, s2, 0x80008
; SI-NEXT:    s_bfe_u32 s36, s3, 0x80008
; SI-NEXT:    s_add_i32 s3, s3, s3
; SI-NEXT:    s_add_i32 s2, s2, s2
; SI-NEXT:    s_add_i32 s1, s1, s1
; SI-NEXT:    s_add_i32 s0, s0, s0
; SI-NEXT:    s_add_i32 s7, s7, s7
; SI-NEXT:    s_add_i32 s6, s6, s6
; SI-NEXT:    s_add_i32 s5, s5, s5
; SI-NEXT:    s_add_i32 s4, s4, s4
; SI-NEXT:    s_add_i32 s27, s27, s27
; SI-NEXT:    s_add_i32 s26, s26, s26
; SI-NEXT:    s_and_b32 s3, s3, 0xff
; SI-NEXT:    s_add_i32 s36, s36, s36
; SI-NEXT:    s_add_i32 s25, s25, s25
; SI-NEXT:    s_add_i32 s24, s24, s24
; SI-NEXT:    s_and_b32 s2, s2, 0xff
; SI-NEXT:    s_add_i32 s35, s35, s35
; SI-NEXT:    s_add_i32 s23, s23, s23
; SI-NEXT:    s_add_i32 s22, s22, s22
; SI-NEXT:    s_and_b32 s1, s1, 0xff
; SI-NEXT:    s_add_i32 s34, s34, s34
; SI-NEXT:    s_add_i32 s21, s21, s21
; SI-NEXT:    s_add_i32 s20, s20, s20
; SI-NEXT:    s_and_b32 s0, s0, 0xff
; SI-NEXT:    s_add_i32 s33, s33, s33
; SI-NEXT:    s_add_i32 s19, s19, s19
; SI-NEXT:    s_add_i32 s18, s18, s18
; SI-NEXT:    s_and_b32 s7, s7, 0xff
; SI-NEXT:    s_add_i32 s31, s31, s31
; SI-NEXT:    s_add_i32 s17, s17, s17
; SI-NEXT:    s_add_i32 s16, s16, s16
; SI-NEXT:    s_and_b32 s6, s6, 0xff
; SI-NEXT:    s_add_i32 s30, s30, s30
; SI-NEXT:    s_add_i32 s15, s15, s15
; SI-NEXT:    s_add_i32 s14, s14, s14
; SI-NEXT:    s_and_b32 s5, s5, 0xff
; SI-NEXT:    s_add_i32 s29, s29, s29
; SI-NEXT:    s_add_i32 s13, s13, s13
; SI-NEXT:    s_add_i32 s12, s12, s12
; SI-NEXT:    s_and_b32 s4, s4, 0xff
; SI-NEXT:    s_add_i32 s28, s28, s28
; SI-NEXT:    s_lshl_b32 s27, s27, 24
; SI-NEXT:    s_and_b32 s26, s26, 0xff
; SI-NEXT:    s_lshl_b32 s36, s36, 8
; SI-NEXT:    s_lshl_b32 s25, s25, 24
; SI-NEXT:    s_and_b32 s24, s24, 0xff
; SI-NEXT:    s_lshl_b32 s35, s35, 8
; SI-NEXT:    s_lshl_b32 s23, s23, 24
; SI-NEXT:    s_and_b32 s22, s22, 0xff
; SI-NEXT:    s_lshl_b32 s34, s34, 8
; SI-NEXT:    s_lshl_b32 s21, s21, 24
; SI-NEXT:    s_and_b32 s20, s20, 0xff
; SI-NEXT:    s_lshl_b32 s33, s33, 8
; SI-NEXT:    s_lshl_b32 s19, s19, 24
; SI-NEXT:    s_and_b32 s18, s18, 0xff
; SI-NEXT:    s_lshl_b32 s31, s31, 8
; SI-NEXT:    s_lshl_b32 s17, s17, 24
; SI-NEXT:    s_and_b32 s16, s16, 0xff
; SI-NEXT:    s_lshl_b32 s30, s30, 8
; SI-NEXT:    s_lshl_b32 s15, s15, 24
; SI-NEXT:    s_and_b32 s14, s14, 0xff
; SI-NEXT:    s_lshl_b32 s29, s29, 8
; SI-NEXT:    s_lshl_b32 s13, s13, 24
; SI-NEXT:    s_and_b32 s12, s12, 0xff
; SI-NEXT:    s_lshl_b32 s28, s28, 8
; SI-NEXT:    s_lshl_b32 s26, s26, 16
; SI-NEXT:    s_or_b32 s3, s3, s36
; SI-NEXT:    s_lshl_b32 s24, s24, 16
; SI-NEXT:    s_or_b32 s2, s2, s35
; SI-NEXT:    s_lshl_b32 s22, s22, 16
; SI-NEXT:    s_or_b32 s1, s1, s34
; SI-NEXT:    s_lshl_b32 s20, s20, 16
; SI-NEXT:    s_or_b32 s0, s0, s33
; SI-NEXT:    s_lshl_b32 s18, s18, 16
; SI-NEXT:    s_or_b32 s7, s7, s31
; SI-NEXT:    s_lshl_b32 s16, s16, 16
; SI-NEXT:    s_or_b32 s6, s6, s30
; SI-NEXT:    s_lshl_b32 s14, s14, 16
; SI-NEXT:    s_or_b32 s5, s5, s29
; SI-NEXT:    s_lshl_b32 s12, s12, 16
; SI-NEXT:    s_or_b32 s4, s4, s28
; SI-NEXT:    s_or_b32 s26, s27, s26
; SI-NEXT:    s_and_b32 s3, s3, 0xffff
; SI-NEXT:    s_or_b32 s24, s25, s24
; SI-NEXT:    s_and_b32 s2, s2, 0xffff
; SI-NEXT:    s_or_b32 s22, s23, s22
; SI-NEXT:    s_and_b32 s1, s1, 0xffff
; SI-NEXT:    s_or_b32 s20, s21, s20
; SI-NEXT:    s_and_b32 s0, s0, 0xffff
; SI-NEXT:    s_or_b32 s18, s19, s18
; SI-NEXT:    s_and_b32 s7, s7, 0xffff
; SI-NEXT:    s_or_b32 s16, s17, s16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s14, s15, s14
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s12, s13, s12
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s3, s3, s26
; SI-NEXT:    s_or_b32 s2, s2, s24
; SI-NEXT:    s_or_b32 s1, s1, s22
; SI-NEXT:    s_or_b32 s7, s7, s18
; SI-NEXT:    s_or_b32 s6, s6, s16
; SI-NEXT:    s_or_b32 s5, s5, s14
; SI-NEXT:    s_or_b32 s4, s4, s12
; SI-NEXT:    s_or_b32 s0, s0, s20
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amd_kernel_v32i8:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; VI-NEXT:    v_mov_b32_e32 v4, 16
; VI-NEXT:    v_mov_b32_e32 v5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s8, s4, 16
; VI-NEXT:    s_lshr_b32 s9, s4, 24
; VI-NEXT:    s_lshr_b32 s10, s5, 16
; VI-NEXT:    s_lshr_b32 s11, s5, 24
; VI-NEXT:    s_lshr_b32 s12, s6, 16
; VI-NEXT:    s_lshr_b32 s13, s6, 24
; VI-NEXT:    s_lshr_b32 s14, s7, 16
; VI-NEXT:    s_lshr_b32 s15, s7, 24
; VI-NEXT:    s_bfe_u32 s24, s4, 0x80008
; VI-NEXT:    s_bfe_u32 s25, s5, 0x80008
; VI-NEXT:    s_bfe_u32 s26, s6, 0x80008
; VI-NEXT:    s_bfe_u32 s27, s7, 0x80008
; VI-NEXT:    s_add_i32 s15, s15, s15
; VI-NEXT:    s_add_i32 s14, s14, s14
; VI-NEXT:    s_add_i32 s13, s13, s13
; VI-NEXT:    s_add_i32 s12, s12, s12
; VI-NEXT:    s_add_i32 s11, s11, s11
; VI-NEXT:    s_add_i32 s10, s10, s10
; VI-NEXT:    s_add_i32 s9, s9, s9
; VI-NEXT:    s_add_i32 s8, s8, s8
; VI-NEXT:    s_lshr_b32 s16, s0, 16
; VI-NEXT:    s_lshr_b32 s17, s0, 24
; VI-NEXT:    s_lshr_b32 s18, s1, 16
; VI-NEXT:    s_lshr_b32 s19, s1, 24
; VI-NEXT:    s_lshr_b32 s20, s2, 16
; VI-NEXT:    s_lshr_b32 s21, s2, 24
; VI-NEXT:    s_lshr_b32 s22, s3, 16
; VI-NEXT:    s_lshr_b32 s23, s3, 24
; VI-NEXT:    s_lshl_b32 s15, s15, 8
; VI-NEXT:    s_and_b32 s14, s14, 0xff
; VI-NEXT:    s_add_i32 s7, s7, s7
; VI-NEXT:    s_add_i32 s27, s27, s27
; VI-NEXT:    s_lshl_b32 s13, s13, 8
; VI-NEXT:    s_and_b32 s12, s12, 0xff
; VI-NEXT:    s_add_i32 s6, s6, s6
; VI-NEXT:    s_add_i32 s26, s26, s26
; VI-NEXT:    s_lshl_b32 s11, s11, 8
; VI-NEXT:    s_and_b32 s10, s10, 0xff
; VI-NEXT:    s_add_i32 s5, s5, s5
; VI-NEXT:    s_add_i32 s25, s25, s25
; VI-NEXT:    s_lshl_b32 s9, s9, 8
; VI-NEXT:    s_and_b32 s8, s8, 0xff
; VI-NEXT:    s_add_i32 s4, s4, s4
; VI-NEXT:    s_add_i32 s24, s24, s24
; VI-NEXT:    s_bfe_u32 s28, s0, 0x80008
; VI-NEXT:    s_bfe_u32 s29, s1, 0x80008
; VI-NEXT:    s_bfe_u32 s30, s2, 0x80008
; VI-NEXT:    s_bfe_u32 s31, s3, 0x80008
; VI-NEXT:    s_add_i32 s23, s23, s23
; VI-NEXT:    s_add_i32 s22, s22, s22
; VI-NEXT:    s_add_i32 s21, s21, s21
; VI-NEXT:    s_add_i32 s20, s20, s20
; VI-NEXT:    s_add_i32 s19, s19, s19
; VI-NEXT:    s_add_i32 s18, s18, s18
; VI-NEXT:    s_add_i32 s17, s17, s17
; VI-NEXT:    s_add_i32 s16, s16, s16
; VI-NEXT:    s_or_b32 s14, s14, s15
; VI-NEXT:    s_and_b32 s7, s7, 0xff
; VI-NEXT:    s_lshl_b32 s15, s27, 8
; VI-NEXT:    s_or_b32 s12, s12, s13
; VI-NEXT:    s_and_b32 s6, s6, 0xff
; VI-NEXT:    s_lshl_b32 s13, s26, 8
; VI-NEXT:    s_or_b32 s10, s10, s11
; VI-NEXT:    s_and_b32 s5, s5, 0xff
; VI-NEXT:    s_lshl_b32 s11, s25, 8
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    s_and_b32 s4, s4, 0xff
; VI-NEXT:    s_lshl_b32 s9, s24, 8
; VI-NEXT:    s_lshl_b32 s23, s23, 8
; VI-NEXT:    s_and_b32 s22, s22, 0xff
; VI-NEXT:    s_add_i32 s3, s3, s3
; VI-NEXT:    s_add_i32 s31, s31, s31
; VI-NEXT:    s_lshl_b32 s21, s21, 8
; VI-NEXT:    s_and_b32 s20, s20, 0xff
; VI-NEXT:    s_add_i32 s2, s2, s2
; VI-NEXT:    s_add_i32 s30, s30, s30
; VI-NEXT:    s_lshl_b32 s19, s19, 8
; VI-NEXT:    s_and_b32 s18, s18, 0xff
; VI-NEXT:    s_add_i32 s1, s1, s1
; VI-NEXT:    s_add_i32 s29, s29, s29
; VI-NEXT:    s_lshl_b32 s17, s17, 8
; VI-NEXT:    s_and_b32 s16, s16, 0xff
; VI-NEXT:    s_add_i32 s0, s0, s0
; VI-NEXT:    s_add_i32 s28, s28, s28
; VI-NEXT:    s_or_b32 s7, s7, s15
; VI-NEXT:    s_or_b32 s6, s6, s13
; VI-NEXT:    s_or_b32 s5, s5, s11
; VI-NEXT:    s_or_b32 s4, s4, s9
; VI-NEXT:    s_or_b32 s22, s22, s23
; VI-NEXT:    s_and_b32 s3, s3, 0xff
; VI-NEXT:    s_lshl_b32 s23, s31, 8
; VI-NEXT:    s_or_b32 s20, s20, s21
; VI-NEXT:    s_and_b32 s2, s2, 0xff
; VI-NEXT:    s_lshl_b32 s21, s30, 8
; VI-NEXT:    s_or_b32 s18, s18, s19
; VI-NEXT:    s_and_b32 s1, s1, 0xff
; VI-NEXT:    s_lshl_b32 s19, s29, 8
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s0, s0, 0xff
; VI-NEXT:    s_lshl_b32 s17, s28, 8
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s10, s10, 16
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_or_b32 s3, s3, s23
; VI-NEXT:    s_or_b32 s2, s2, s21
; VI-NEXT:    s_or_b32 s1, s1, s19
; VI-NEXT:    s_or_b32 s0, s0, s17
; VI-NEXT:    s_or_b32 s7, s7, s14
; VI-NEXT:    s_or_b32 s6, s6, s12
; VI-NEXT:    s_or_b32 s5, s5, s10
; VI-NEXT:    s_or_b32 s4, s4, s8
; VI-NEXT:    s_lshl_b32 s22, s22, 16
; VI-NEXT:    s_and_b32 s3, s3, 0xffff
; VI-NEXT:    s_lshl_b32 s20, s20, 16
; VI-NEXT:    s_and_b32 s2, s2, 0xffff
; VI-NEXT:    s_lshl_b32 s18, s18, 16
; VI-NEXT:    s_and_b32 s1, s1, 0xffff
; VI-NEXT:    s_lshl_b32 s16, s16, 16
; VI-NEXT:    s_and_b32 s0, s0, 0xffff
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    s_or_b32 s3, s3, s22
; VI-NEXT:    s_or_b32 s2, s2, s20
; VI-NEXT:    s_or_b32 s1, s1, s18
; VI-NEXT:    s_or_b32 s0, s0, s16
; VI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; VI-NEXT:    v_mov_b32_e32 v4, 0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v5, 0
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amd_kernel_v32i8:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s16, s0, 16
; GFX11-NEXT:    s_lshr_b32 s17, s0, 24
; GFX11-NEXT:    s_lshr_b32 s20, s2, 16
; GFX11-NEXT:    s_lshr_b32 s21, s2, 24
; GFX11-NEXT:    s_lshr_b32 s14, s7, 16
; GFX11-NEXT:    s_lshr_b32 s15, s7, 24
; GFX11-NEXT:    s_bfe_u32 s27, s7, 0x80008
; GFX11-NEXT:    s_add_i32 s17, s17, s17
; GFX11-NEXT:    s_add_i32 s16, s16, s16
; GFX11-NEXT:    s_lshr_b32 s18, s1, 16
; GFX11-NEXT:    s_lshr_b32 s19, s1, 24
; GFX11-NEXT:    s_lshr_b32 s22, s3, 16
; GFX11-NEXT:    s_lshr_b32 s23, s3, 24
; GFX11-NEXT:    s_bfe_u32 s29, s1, 0x80008
; GFX11-NEXT:    s_bfe_u32 s30, s3, 0x80008
; GFX11-NEXT:    s_add_i32 s21, s21, s21
; GFX11-NEXT:    s_add_i32 s20, s20, s20
; GFX11-NEXT:    s_lshl_b32 s17, s17, 8
; GFX11-NEXT:    s_and_b32 s16, s16, 0xff
; GFX11-NEXT:    s_add_i32 s7, s7, s7
; GFX11-NEXT:    s_add_i32 s27, s27, s27
; GFX11-NEXT:    s_add_i32 s15, s15, s15
; GFX11-NEXT:    s_add_i32 s14, s14, s14
; GFX11-NEXT:    s_add_i32 s3, s3, s3
; GFX11-NEXT:    s_add_i32 s30, s30, s30
; GFX11-NEXT:    s_add_i32 s23, s23, s23
; GFX11-NEXT:    s_add_i32 s22, s22, s22
; GFX11-NEXT:    s_lshl_b32 s21, s21, 8
; GFX11-NEXT:    s_and_b32 s20, s20, 0xff
; GFX11-NEXT:    s_add_i32 s1, s1, s1
; GFX11-NEXT:    s_add_i32 s29, s29, s29
; GFX11-NEXT:    s_add_i32 s19, s19, s19
; GFX11-NEXT:    s_add_i32 s18, s18, s18
; GFX11-NEXT:    s_lshr_b32 s10, s5, 16
; GFX11-NEXT:    s_lshr_b32 s11, s5, 24
; GFX11-NEXT:    s_lshr_b32 s12, s6, 16
; GFX11-NEXT:    s_lshr_b32 s13, s6, 24
; GFX11-NEXT:    s_or_b32 s16, s16, s17
; GFX11-NEXT:    s_and_b32 s7, s7, 0xff
; GFX11-NEXT:    s_lshl_b32 s17, s27, 8
; GFX11-NEXT:    s_lshl_b32 s15, s15, 8
; GFX11-NEXT:    s_and_b32 s14, s14, 0xff
; GFX11-NEXT:    s_and_b32 s3, s3, 0xff
; GFX11-NEXT:    s_lshl_b32 s30, s30, 8
; GFX11-NEXT:    s_lshl_b32 s23, s23, 8
; GFX11-NEXT:    s_and_b32 s22, s22, 0xff
; GFX11-NEXT:    s_or_b32 s20, s20, s21
; GFX11-NEXT:    s_and_b32 s1, s1, 0xff
; GFX11-NEXT:    s_lshl_b32 s21, s29, 8
; GFX11-NEXT:    s_lshl_b32 s19, s19, 8
; GFX11-NEXT:    s_and_b32 s18, s18, 0xff
; GFX11-NEXT:    s_lshr_b32 s8, s4, 16
; GFX11-NEXT:    s_lshr_b32 s9, s4, 24
; GFX11-NEXT:    s_bfe_u32 s24, s4, 0x80008
; GFX11-NEXT:    s_bfe_u32 s25, s5, 0x80008
; GFX11-NEXT:    s_bfe_u32 s26, s6, 0x80008
; GFX11-NEXT:    s_or_b32 s7, s7, s17
; GFX11-NEXT:    s_or_b32 s14, s14, s15
; GFX11-NEXT:    s_add_i32 s13, s13, s13
; GFX11-NEXT:    s_add_i32 s12, s12, s12
; GFX11-NEXT:    s_add_i32 s11, s11, s11
; GFX11-NEXT:    s_add_i32 s10, s10, s10
; GFX11-NEXT:    s_bfe_u32 s28, s0, 0x80008
; GFX11-NEXT:    s_or_b32 s3, s3, s30
; GFX11-NEXT:    s_or_b32 s22, s22, s23
; GFX11-NEXT:    s_bfe_u32 s23, s2, 0x80008
; GFX11-NEXT:    s_or_b32 s1, s1, s21
; GFX11-NEXT:    s_or_b32 s18, s18, s19
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s14, s14, 16
; GFX11-NEXT:    s_add_i32 s6, s6, s6
; GFX11-NEXT:    s_add_i32 s26, s26, s26
; GFX11-NEXT:    s_lshl_b32 s13, s13, 8
; GFX11-NEXT:    s_and_b32 s12, s12, 0xff
; GFX11-NEXT:    s_add_i32 s5, s5, s5
; GFX11-NEXT:    s_add_i32 s25, s25, s25
; GFX11-NEXT:    s_lshl_b32 s11, s11, 8
; GFX11-NEXT:    s_and_b32 s10, s10, 0xff
; GFX11-NEXT:    s_add_i32 s4, s4, s4
; GFX11-NEXT:    s_add_i32 s24, s24, s24
; GFX11-NEXT:    s_add_i32 s9, s9, s9
; GFX11-NEXT:    s_add_i32 s8, s8, s8
; GFX11-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX11-NEXT:    s_lshl_b32 s22, s22, 16
; GFX11-NEXT:    s_add_i32 s2, s2, s2
; GFX11-NEXT:    s_add_i32 s23, s23, s23
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    s_lshl_b32 s18, s18, 16
; GFX11-NEXT:    s_add_i32 s0, s0, s0
; GFX11-NEXT:    s_add_i32 s28, s28, s28
; GFX11-NEXT:    s_or_b32 s7, s7, s14
; GFX11-NEXT:    s_and_b32 s6, s6, 0xff
; GFX11-NEXT:    s_lshl_b32 s14, s26, 8
; GFX11-NEXT:    s_or_b32 s12, s12, s13
; GFX11-NEXT:    s_and_b32 s5, s5, 0xff
; GFX11-NEXT:    s_lshl_b32 s13, s25, 8
; GFX11-NEXT:    s_or_b32 s10, s10, s11
; GFX11-NEXT:    s_and_b32 s4, s4, 0xff
; GFX11-NEXT:    s_lshl_b32 s11, s24, 8
; GFX11-NEXT:    s_lshl_b32 s9, s9, 8
; GFX11-NEXT:    s_and_b32 s8, s8, 0xff
; GFX11-NEXT:    s_or_b32 s3, s3, s22
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s22, s23, 8
; GFX11-NEXT:    s_or_b32 s1, s1, s18
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s18, s28, 8
; GFX11-NEXT:    s_or_b32 s6, s6, s14
; GFX11-NEXT:    s_or_b32 s5, s5, s13
; GFX11-NEXT:    s_or_b32 s4, s4, s11
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_or_b32 s2, s2, s22
; GFX11-NEXT:    s_or_b32 s0, s0, s18
; GFX11-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX11-NEXT:    s_lshl_b32 s12, s12, 16
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_lshl_b32 s9, s10, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s20, s20, 16
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s16, s16, 16
; GFX11-NEXT:    s_or_b32 s6, s6, s12
; GFX11-NEXT:    s_or_b32 s4, s4, s8
; GFX11-NEXT:    s_or_b32 s5, s5, s9
; GFX11-NEXT:    s_or_b32 s2, s2, s20
; GFX11-NEXT:    s_or_b32 s0, s0, s16
; GFX11-NEXT:    v_dual_mov_b32 v8, 16 :: v_dual_mov_b32 v5, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX11-NEXT:    v_dual_mov_b32 v9, 0 :: v_dual_mov_b32 v4, s0
; GFX11-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_mov_b32 v7, s3
; GFX11-NEXT:    v_dual_mov_b32 v6, s2 :: v_dual_mov_b32 v11, 0
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b128 v[8:9], v[0:3], off
; GFX11-NEXT:    global_store_b128 v[10:11], v[4:7], off
; GFX11-NEXT:    s_endpgm
entry:
  %add = add <32 x i8> %arg0, %arg0
  store <32 x i8> %add, ptr addrspace(1) null
  ret void
}

define amdgpu_cs void @amdgpu_cs_i1(i1 %arg0) {
; SI-LABEL: amdgpu_cs_i1:
; SI:       ; %bb.0:
; SI-NEXT:    v_and_b32_e32 v0, 1, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_i1:
; VI:       ; %bb.0:
; VI-NEXT:    v_and_b32_e32 v0, 1, v0
; VI-NEXT:    flat_store_byte v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amdgpu_cs_i1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    global_store_b8 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  store i1 %arg0, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs void @amdgpu_cs_v8i1(<8 x i1> %arg0) {
; SI-LABEL: amdgpu_cs_v8i1:
; SI:       ; %bb.0:
; SI-NEXT:    v_lshlrev_b32_e32 v7, 3, v7
; SI-NEXT:    v_and_b32_e32 v6, 1, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 1, v5
; SI-NEXT:    v_and_b32_e32 v4, 1, v4
; SI-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; SI-NEXT:    v_and_b32_e32 v2, 1, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 1, v1
; SI-NEXT:    v_and_b32_e32 v0, 1, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    v_lshlrev_b32_e32 v6, 2, v6
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 2, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v1, v7, v6
; SI-NEXT:    v_and_b32_e32 v4, 3, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v0, 3, v0
; SI-NEXT:    v_or_b32_e32 v1, v4, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; SI-NEXT:    v_and_b32_e32 v0, 15, v0
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_v8i1:
; VI:       ; %bb.0:
; VI-NEXT:    v_and_b32_e32 v6, 1, v6
; VI-NEXT:    v_lshlrev_b16_e32 v5, 1, v5
; VI-NEXT:    v_and_b32_e32 v4, 1, v4
; VI-NEXT:    v_and_b32_e32 v2, 1, v2
; VI-NEXT:    v_lshlrev_b16_e32 v1, 1, v1
; VI-NEXT:    v_and_b32_e32 v0, 1, v0
; VI-NEXT:    v_lshlrev_b16_e32 v7, 3, v7
; VI-NEXT:    v_lshlrev_b16_e32 v6, 2, v6
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 3, v3
; VI-NEXT:    v_lshlrev_b16_e32 v2, 2, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_or_b32_e32 v6, v7, v6
; VI-NEXT:    v_and_b32_e32 v4, 3, v4
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_and_b32_e32 v0, 3, v0
; VI-NEXT:    v_or_b32_e32 v4, v4, v6
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    v_lshlrev_b16_e32 v4, 4, v4
; VI-NEXT:    v_and_b32_e32 v0, 15, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v4
; VI-NEXT:    flat_store_byte v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: amdgpu_cs_v8i1:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, v6.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 1, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, v4.l, 1
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, v2.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.l, 1, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 3, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 2, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v0.h, v4.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 3, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.h, 2, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v5.h, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, v0.h, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v2.h, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v0.h, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v0.h, 4, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 15
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v0.h
; GFX11-TRUE16-NEXT:    global_store_b8 v[0:1], v0, off
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: amdgpu_cs_v8i1:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 1, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v1, 1, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v6, 2, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 3, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v2, 2, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v7, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v1, 4, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    global_store_b8 v[0:1], v0, off
; GFX11-FAKE16-NEXT:    s_endpgm
  store <8 x i1> %arg0, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs void @amdgpu_cs_v16i1(<16 x i1> %arg0) {
; SI-LABEL: amdgpu_cs_v16i1:
; SI:       ; %bb.0:
; SI-NEXT:    v_lshlrev_b32_e32 v15, 3, v15
; SI-NEXT:    v_and_b32_e32 v14, 1, v14
; SI-NEXT:    v_lshlrev_b32_e32 v13, 1, v13
; SI-NEXT:    v_and_b32_e32 v12, 1, v12
; SI-NEXT:    v_lshlrev_b32_e32 v11, 3, v11
; SI-NEXT:    v_and_b32_e32 v10, 1, v10
; SI-NEXT:    v_lshlrev_b32_e32 v9, 1, v9
; SI-NEXT:    v_and_b32_e32 v8, 1, v8
; SI-NEXT:    v_lshlrev_b32_e32 v7, 3, v7
; SI-NEXT:    v_and_b32_e32 v6, 1, v6
; SI-NEXT:    v_lshlrev_b32_e32 v5, 1, v5
; SI-NEXT:    v_and_b32_e32 v4, 1, v4
; SI-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; SI-NEXT:    v_and_b32_e32 v2, 1, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 1, v1
; SI-NEXT:    v_and_b32_e32 v0, 1, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    v_lshlrev_b32_e32 v14, 2, v14
; SI-NEXT:    v_or_b32_e32 v12, v12, v13
; SI-NEXT:    v_lshlrev_b32_e32 v10, 2, v10
; SI-NEXT:    v_or_b32_e32 v8, v8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v6, 2, v6
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 2, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v1, v15, v14
; SI-NEXT:    v_and_b32_e32 v5, 3, v12
; SI-NEXT:    v_or_b32_e32 v9, v11, v10
; SI-NEXT:    v_and_b32_e32 v8, 3, v8
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_and_b32_e32 v4, 3, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v0, 3, v0
; SI-NEXT:    v_or_b32_e32 v1, v5, v1
; SI-NEXT:    v_or_b32_e32 v3, v8, v9
; SI-NEXT:    v_or_b32_e32 v4, v4, v6
; SI-NEXT:    v_or_b32_e32 v0, v0, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 12, v1
; SI-NEXT:    v_and_b32_e32 v2, 15, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 4, v4
; SI-NEXT:    v_and_b32_e32 v0, 15, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v3
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_v16i1:
; VI:       ; %bb.0:
; VI-NEXT:    v_and_b32_e32 v14, 1, v14
; VI-NEXT:    v_lshlrev_b16_e32 v13, 1, v13
; VI-NEXT:    v_and_b32_e32 v12, 1, v12
; VI-NEXT:    v_and_b32_e32 v10, 1, v10
; VI-NEXT:    v_lshlrev_b16_e32 v9, 1, v9
; VI-NEXT:    v_and_b32_e32 v8, 1, v8
; VI-NEXT:    v_and_b32_e32 v6, 1, v6
; VI-NEXT:    v_lshlrev_b16_e32 v5, 1, v5
; VI-NEXT:    v_and_b32_e32 v4, 1, v4
; VI-NEXT:    v_and_b32_e32 v2, 1, v2
; VI-NEXT:    v_lshlrev_b16_e32 v1, 1, v1
; VI-NEXT:    v_and_b32_e32 v0, 1, v0
; VI-NEXT:    v_lshlrev_b16_e32 v15, 3, v15
; VI-NEXT:    v_lshlrev_b16_e32 v14, 2, v14
; VI-NEXT:    v_or_b32_e32 v12, v12, v13
; VI-NEXT:    v_lshlrev_b16_e32 v11, 3, v11
; VI-NEXT:    v_lshlrev_b16_e32 v10, 2, v10
; VI-NEXT:    v_or_b32_e32 v8, v8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v7, 3, v7
; VI-NEXT:    v_lshlrev_b16_e32 v6, 2, v6
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 3, v3
; VI-NEXT:    v_lshlrev_b16_e32 v2, 2, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_or_b32_e32 v14, v15, v14
; VI-NEXT:    v_and_b32_e32 v12, 3, v12
; VI-NEXT:    v_or_b32_e32 v10, v11, v10
; VI-NEXT:    v_and_b32_e32 v8, 3, v8
; VI-NEXT:    v_or_b32_e32 v6, v7, v6
; VI-NEXT:    v_and_b32_e32 v4, 3, v4
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_and_b32_e32 v0, 3, v0
; VI-NEXT:    v_or_b32_e32 v12, v12, v14
; VI-NEXT:    v_or_b32_e32 v8, v8, v10
; VI-NEXT:    v_mov_b32_e32 v9, 15
; VI-NEXT:    v_or_b32_e32 v4, v4, v6
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    v_lshlrev_b16_e32 v12, 12, v12
; VI-NEXT:    v_and_b32_sdwa v8, v8, v9 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b16_e32 v4, 4, v4
; VI-NEXT:    v_and_b32_e32 v0, 15, v0
; VI-NEXT:    v_or_b32_e32 v8, v12, v8
; VI-NEXT:    v_or_b32_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: amdgpu_cs_v16i1:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_and_b16 v10.l, v10.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.l, 1, v9.l
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, v8.l, 1
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, v6.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 1, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, v4.l, 1
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, v2.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.l, 1, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 1
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, v14.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v13.l, 1, v13.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, v12.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 3, v11.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.l, 2, v10.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.h, v8.l, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v7.l, 3, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 2, v6.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v0.h, v4.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 3, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.h, 2, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.h, 3, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.h, 2, v14.l
; GFX11-TRUE16-NEXT:    v_or_b16 v8.h, v12.l, v13.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.h, v9.h, v10.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, v5.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v7.l, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, v0.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v2.h, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v12.h, v10.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, v8.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v6.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v0.h, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v3.l, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, 15
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v0.h, 4, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 15
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.h, 12, v1.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.l, 8, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v1.h, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v0.h
; GFX11-TRUE16-NEXT:    global_store_b16 v[0:1], v0, off
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: amdgpu_cs_v16i1:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 1, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v9, 1, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 1, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v1, 1, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 1, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v13, 1, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 1, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v11, 3, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v10, 2, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v6, 2, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 3, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v2, 2, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 3, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v14, 2, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v11, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 3, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v15, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 3, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v6, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 15, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 4, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v2, 12, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    global_store_b16 v[0:1], v0, off
; GFX11-FAKE16-NEXT:    s_endpgm
  store <16 x i1> %arg0, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs void @amdgpu_cs_v32i1(<32 x i1> %arg0) {
; SI-LABEL: amdgpu_cs_v32i1:
; SI:       ; %bb.0:
; SI-NEXT:    v_lshlrev_b32_e32 v29, 1, v29
; SI-NEXT:    v_and_b32_e32 v28, 1, v28
; SI-NEXT:    v_lshlrev_b32_e32 v25, 1, v25
; SI-NEXT:    v_and_b32_e32 v24, 1, v24
; SI-NEXT:    v_lshlrev_b32_e32 v21, 1, v21
; SI-NEXT:    v_and_b32_e32 v20, 1, v20
; SI-NEXT:    v_lshlrev_b32_e32 v17, 1, v17
; SI-NEXT:    v_and_b32_e32 v16, 1, v16
; SI-NEXT:    v_lshlrev_b32_e32 v13, 1, v13
; SI-NEXT:    v_and_b32_e32 v12, 1, v12
; SI-NEXT:    v_lshlrev_b32_e32 v9, 1, v9
; SI-NEXT:    v_and_b32_e32 v8, 1, v8
; SI-NEXT:    v_lshlrev_b32_e32 v5, 1, v5
; SI-NEXT:    v_and_b32_e32 v4, 1, v4
; SI-NEXT:    v_lshlrev_b32_e32 v1, 1, v1
; SI-NEXT:    v_and_b32_e32 v0, 1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v31, 3, v31
; SI-NEXT:    v_and_b32_e32 v30, 1, v30
; SI-NEXT:    v_lshlrev_b32_e32 v27, 3, v27
; SI-NEXT:    v_and_b32_e32 v26, 1, v26
; SI-NEXT:    v_lshlrev_b32_e32 v23, 3, v23
; SI-NEXT:    v_and_b32_e32 v22, 1, v22
; SI-NEXT:    v_lshlrev_b32_e32 v19, 3, v19
; SI-NEXT:    v_and_b32_e32 v18, 1, v18
; SI-NEXT:    v_lshlrev_b32_e32 v15, 3, v15
; SI-NEXT:    v_and_b32_e32 v14, 1, v14
; SI-NEXT:    v_lshlrev_b32_e32 v11, 3, v11
; SI-NEXT:    v_and_b32_e32 v10, 1, v10
; SI-NEXT:    v_lshlrev_b32_e32 v7, 3, v7
; SI-NEXT:    v_and_b32_e32 v6, 1, v6
; SI-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; SI-NEXT:    v_and_b32_e32 v2, 1, v2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    v_or_b32_e32 v28, v28, v29
; SI-NEXT:    v_or_b32_e32 v24, v24, v25
; SI-NEXT:    v_or_b32_e32 v20, v20, v21
; SI-NEXT:    v_or_b32_e32 v16, v16, v17
; SI-NEXT:    v_or_b32_e32 v12, v12, v13
; SI-NEXT:    v_or_b32_e32 v8, v8, v9
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_lshlrev_b32_e32 v1, 2, v30
; SI-NEXT:    v_lshlrev_b32_e32 v5, 2, v26
; SI-NEXT:    v_lshlrev_b32_e32 v9, 2, v22
; SI-NEXT:    v_lshlrev_b32_e32 v13, 2, v18
; SI-NEXT:    v_lshlrev_b32_e32 v14, 2, v14
; SI-NEXT:    v_lshlrev_b32_e32 v10, 2, v10
; SI-NEXT:    v_lshlrev_b32_e32 v6, 2, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 2, v2
; SI-NEXT:    v_or_b32_e32 v1, v31, v1
; SI-NEXT:    v_or_b32_e32 v5, v27, v5
; SI-NEXT:    v_or_b32_e32 v9, v23, v9
; SI-NEXT:    v_or_b32_e32 v13, v19, v13
; SI-NEXT:    v_and_b32_e32 v17, 3, v28
; SI-NEXT:    v_and_b32_e32 v18, 3, v24
; SI-NEXT:    v_and_b32_e32 v19, 3, v20
; SI-NEXT:    v_and_b32_e32 v16, 3, v16
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    v_and_b32_e32 v12, 3, v12
; SI-NEXT:    v_or_b32_e32 v10, v11, v10
; SI-NEXT:    v_and_b32_e32 v8, 3, v8
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_and_b32_e32 v4, 3, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_and_b32_e32 v0, 3, v0
; SI-NEXT:    v_or_b32_e32 v1, v17, v1
; SI-NEXT:    v_or_b32_e32 v3, v18, v5
; SI-NEXT:    v_or_b32_e32 v5, v19, v9
; SI-NEXT:    v_or_b32_e32 v7, v16, v13
; SI-NEXT:    v_or_b32_e32 v9, v12, v14
; SI-NEXT:    v_or_b32_e32 v8, v8, v10
; SI-NEXT:    v_or_b32_e32 v4, v4, v6
; SI-NEXT:    v_or_b32_e32 v0, v0, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 12, v1
; SI-NEXT:    v_and_b32_e32 v2, 15, v3
; SI-NEXT:    v_lshlrev_b32_e32 v3, 4, v5
; SI-NEXT:    v_and_b32_e32 v5, 15, v7
; SI-NEXT:    v_lshlrev_b32_e32 v6, 12, v9
; SI-NEXT:    v_and_b32_e32 v7, 15, v8
; SI-NEXT:    v_lshlrev_b32_e32 v4, 4, v4
; SI-NEXT:    v_and_b32_e32 v0, 15, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_or_b32_e32 v3, v5, v3
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v7
; SI-NEXT:    v_or_b32_e32 v0, v0, v4
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v3
; SI-NEXT:    v_or_b32_e32 v3, v6, v5
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_v32i1:
; VI:       ; %bb.0:
; VI-NEXT:    v_and_b32_e32 v6, 1, v6
; VI-NEXT:    v_lshlrev_b16_e32 v5, 1, v5
; VI-NEXT:    v_and_b32_e32 v4, 1, v4
; VI-NEXT:    v_and_b32_e32 v2, 1, v2
; VI-NEXT:    v_lshlrev_b16_e32 v1, 1, v1
; VI-NEXT:    v_and_b32_e32 v0, 1, v0
; VI-NEXT:    v_lshlrev_b16_e32 v7, 3, v7
; VI-NEXT:    v_lshlrev_b16_e32 v6, 2, v6
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 3, v3
; VI-NEXT:    v_lshlrev_b16_e32 v2, 2, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_or_b32_e32 v6, v7, v6
; VI-NEXT:    v_and_b32_e32 v4, 3, v4
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_and_b32_e32 v0, 3, v0
; VI-NEXT:    v_or_b32_e32 v4, v4, v6
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    v_lshlrev_b16_e32 v1, 4, v4
; VI-NEXT:    v_and_b32_e32 v0, 15, v0
; VI-NEXT:    v_and_b32_e32 v2, 1, v30
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_lshlrev_b16_e32 v1, 3, v31
; VI-NEXT:    v_lshlrev_b16_e32 v2, 2, v2
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_lshlrev_b16_e32 v2, 1, v29
; VI-NEXT:    v_and_b32_e32 v3, 1, v28
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_and_b32_e32 v2, 3, v2
; VI-NEXT:    v_and_b32_e32 v3, 1, v26
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_lshlrev_b16_e32 v2, 3, v27
; VI-NEXT:    v_lshlrev_b16_e32 v3, 2, v3
; VI-NEXT:    v_and_b32_e32 v10, 1, v10
; VI-NEXT:    v_lshlrev_b16_e32 v9, 1, v9
; VI-NEXT:    v_and_b32_e32 v8, 1, v8
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_lshlrev_b16_e32 v3, 1, v25
; VI-NEXT:    v_and_b32_e32 v4, 1, v24
; VI-NEXT:    v_lshlrev_b16_e32 v11, 3, v11
; VI-NEXT:    v_lshlrev_b16_e32 v10, 2, v10
; VI-NEXT:    v_or_b32_e32 v8, v8, v9
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_or_b32_e32 v10, v11, v10
; VI-NEXT:    v_and_b32_e32 v8, 3, v8
; VI-NEXT:    v_and_b32_e32 v3, 3, v3
; VI-NEXT:    v_or_b32_e32 v8, v8, v10
; VI-NEXT:    v_mov_b32_e32 v10, 15
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_lshlrev_b16_e32 v1, 12, v1
; VI-NEXT:    v_and_b32_sdwa v2, v2, v10 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_and_b32_e32 v3, 1, v22
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_lshlrev_b16_e32 v2, 3, v23
; VI-NEXT:    v_lshlrev_b16_e32 v3, 2, v3
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_lshlrev_b16_e32 v3, 1, v21
; VI-NEXT:    v_and_b32_e32 v4, 1, v20
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_and_b32_e32 v3, 3, v3
; VI-NEXT:    v_and_b32_e32 v4, 1, v18
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_lshlrev_b16_e32 v3, 3, v19
; VI-NEXT:    v_lshlrev_b16_e32 v4, 2, v4
; VI-NEXT:    v_and_b32_e32 v14, 1, v14
; VI-NEXT:    v_lshlrev_b16_e32 v13, 1, v13
; VI-NEXT:    v_and_b32_e32 v12, 1, v12
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    v_lshlrev_b16_e32 v4, 1, v17
; VI-NEXT:    v_and_b32_e32 v5, 1, v16
; VI-NEXT:    v_lshlrev_b16_e32 v15, 3, v15
; VI-NEXT:    v_lshlrev_b16_e32 v14, 2, v14
; VI-NEXT:    v_or_b32_e32 v12, v12, v13
; VI-NEXT:    v_or_b32_e32 v4, v5, v4
; VI-NEXT:    v_or_b32_e32 v14, v15, v14
; VI-NEXT:    v_and_b32_e32 v12, 3, v12
; VI-NEXT:    v_and_b32_e32 v4, 3, v4
; VI-NEXT:    v_or_b32_e32 v12, v12, v14
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_lshlrev_b16_e32 v9, 12, v12
; VI-NEXT:    v_and_b32_sdwa v8, v8, v10 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b16_e32 v2, 4, v2
; VI-NEXT:    v_and_b32_e32 v3, 15, v3
; VI-NEXT:    v_or_b32_e32 v8, v9, v8
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_or_b32_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: amdgpu_cs_v32i1:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    v_and_b16 v10.l, v10.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.l, 1, v9.l
; GFX11-TRUE16-NEXT:    v_and_b16 v8.l, v8.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 3, v11.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, v6.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.l, 2, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.l, 1, v5.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.h, v8.l, v9.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, v4.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.l, 3, v7.l
; GFX11-TRUE16-NEXT:    v_or_b16 v9.h, v9.h, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 2, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v5.h, v6.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v4.l, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, v2.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 3, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v6.l, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v5.h, v9.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, v0.h, 3
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.l, 1, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 1
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, v28.l, 1
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, v26.l, 1
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v0.h, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, v3.l, 15
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 1, v29.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.h, 2, v1.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.l, 2, v4.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 1, v25.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.h, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 3, v27.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, v24.l, 1
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v2.h, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 3
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.h, 1, v21.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v3.h, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v5.l, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, v22.l, 1
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, v20.l, 1
; GFX11-TRUE16-NEXT:    v_and_b16 v6.h, v18.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v7.l, 1, v17.l
; GFX11-TRUE16-NEXT:    v_and_b16 v7.h, v16.l, 1
; GFX11-TRUE16-NEXT:    v_and_b16 v14.l, v14.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v13.l, 1, v13.l
; GFX11-TRUE16-NEXT:    v_and_b16 v12.l, v12.l, 1
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, v30.l, 1
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v4.h, 3, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v5.l, 2, v5.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.h, v6.l, v5.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.l, 3, v19.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v6.h, 2, v6.h
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v7.h, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.h, 3, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v13.h, 2, v14.l
; GFX11-TRUE16-NEXT:    v_or_b16 v12.l, v12.l, v13.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 3, v31.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.h, 2, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, v4.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v4.h, v4.h, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, v5.h, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v5.h, v6.l, v6.h
; GFX11-TRUE16-NEXT:    v_and_b16 v6.l, v7.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v10.h, v12.h, v13.h
; GFX11-TRUE16-NEXT:    v_and_b16 v8.h, v12.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v2.h, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, v3.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v4.l, v3.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v5.l, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v6.l, v5.h
; GFX11-TRUE16-NEXT:    v_or_b16 v8.h, v8.h, v10.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v0.h, 4, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 15
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v2.h, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, v3.l, 15
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 4, v3.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, v4.l, 15
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.l, 12, v8.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v0.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v0.h, 12, v1.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v1.h, 8, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v3.h, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v0.h, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.h, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-TRUE16-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: amdgpu_cs_v32i1:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 1, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v9, 1, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v11, 3, v11
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v10, 2, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v1, 1, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 1, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v13, 1, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 1, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 1, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v11, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 3, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v6, 2, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 3, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v2, 2, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 3, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v14, 2, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v8, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, v15, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 3, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 15, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v6, 1, v29
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 1, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 1, v28
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v9, 1, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 1, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v12, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 3, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v2, 2, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v7, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v10, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 1, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v10, 1, v21
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 1, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 1, v18
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v14, 1, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 1, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 1, v30
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v8, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 3, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v9, 2, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v12, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v12, 3, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v13, 2, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, v15, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v11, 3, v31
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 2, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 3, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v12, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 3, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v11, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 3, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v9, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v12, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v4, 4, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v6, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v6, 4, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 15, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v1, 12, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v4, 12, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v2, 8, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v3, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-FAKE16-NEXT:    s_endpgm
  store <32 x i1> %arg0, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs void @amdgpu_cs_inreg_i1(i1 inreg %arg0) {
; SI-LABEL: amdgpu_cs_inreg_i1:
; SI:       ; %bb.0:
; SI-NEXT:    s_and_b32 s0, s0, 1
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_inreg_i1:
; VI:       ; %bb.0:
; VI-NEXT:    s_and_b32 s0, s0, 1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    flat_store_byte v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amdgpu_cs_inreg_i1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_and_b32 s0, s0, 1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    global_store_b8 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  store i1 %arg0, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs void @amdgpu_cs_inreg_v8i1(<8 x i1> inreg %arg0) {
; SI-LABEL: amdgpu_cs_inreg_v8i1:
; SI:       ; %bb.0:
; SI-NEXT:    s_lshl_b32 s7, s7, 3
; SI-NEXT:    s_and_b32 s6, s6, 1
; SI-NEXT:    s_lshl_b32 s5, s5, 1
; SI-NEXT:    s_and_b32 s4, s4, 1
; SI-NEXT:    s_lshl_b32 s8, s3, 3
; SI-NEXT:    s_and_b32 s2, s2, 1
; SI-NEXT:    s_lshl_b32 s1, s1, 1
; SI-NEXT:    s_and_b32 s0, s0, 1
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_lshl_b32 s6, s6, 2
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_lshl_b32 s2, s2, 2
; SI-NEXT:    s_or_b32 s0, s0, s1
; SI-NEXT:    s_or_b32 s1, s7, s6
; SI-NEXT:    s_and_b32 s4, s4, 3
; SI-NEXT:    s_or_b32 s2, s8, s2
; SI-NEXT:    s_and_b32 s0, s0, 3
; SI-NEXT:    s_or_b32 s1, s4, s1
; SI-NEXT:    s_or_b32 s0, s0, s2
; SI-NEXT:    s_lshl_b32 s1, s1, 4
; SI-NEXT:    s_and_b32 s0, s0, 15
; SI-NEXT:    s_or_b32 s0, s0, s1
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_inreg_v8i1:
; VI:       ; %bb.0:
; VI-NEXT:    s_and_b32 s6, s6, 1
; VI-NEXT:    s_lshl_b32 s5, s5, 1
; VI-NEXT:    s_and_b32 s4, s4, 1
; VI-NEXT:    s_and_b32 s2, s2, 1
; VI-NEXT:    s_lshl_b32 s1, s1, 1
; VI-NEXT:    s_and_b32 s0, s0, 1
; VI-NEXT:    s_lshl_b32 s7, s7, 3
; VI-NEXT:    s_lshl_b32 s6, s6, 2
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_lshl_b32 s3, s3, 3
; VI-NEXT:    s_lshl_b32 s2, s2, 2
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s4, s4, 3
; VI-NEXT:    s_or_b32 s2, s3, s2
; VI-NEXT:    s_and_b32 s0, s0, 3
; VI-NEXT:    s_or_b32 s4, s4, s6
; VI-NEXT:    s_or_b32 s0, s0, s2
; VI-NEXT:    s_lshl_b32 s4, s4, 4
; VI-NEXT:    s_and_b32 s0, s0, 15
; VI-NEXT:    s_or_b32 s0, s0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    flat_store_byte v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amdgpu_cs_inreg_v8i1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_and_b32 s6, s6, 1
; GFX11-NEXT:    s_lshl_b32 s5, s5, 1
; GFX11-NEXT:    s_and_b32 s4, s4, 1
; GFX11-NEXT:    s_and_b32 s2, s2, 1
; GFX11-NEXT:    s_lshl_b32 s1, s1, 1
; GFX11-NEXT:    s_and_b32 s0, s0, 1
; GFX11-NEXT:    s_lshl_b32 s7, s7, 3
; GFX11-NEXT:    s_lshl_b32 s6, s6, 2
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_lshl_b32 s3, s3, 3
; GFX11-NEXT:    s_lshl_b32 s2, s2, 2
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s5, s7, s6
; GFX11-NEXT:    s_and_b32 s4, s4, 3
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_and_b32 s0, s0, 3
; GFX11-NEXT:    s_or_b32 s2, s4, s5
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_lshl_b32 s1, s2, 4
; GFX11-NEXT:    s_and_b32 s0, s0, 15
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    global_store_b8 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  store <8 x i1> %arg0, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs void @amdgpu_cs_inreg_v16i1(<16 x i1> inreg %arg0) {
; SI-LABEL: amdgpu_cs_inreg_v16i1:
; SI:       ; %bb.0:
; SI-NEXT:    s_lshl_b32 s15, s15, 3
; SI-NEXT:    s_and_b32 s14, s14, 1
; SI-NEXT:    s_lshl_b32 s13, s13, 1
; SI-NEXT:    s_and_b32 s12, s12, 1
; SI-NEXT:    s_lshl_b32 s11, s11, 3
; SI-NEXT:    s_and_b32 s10, s10, 1
; SI-NEXT:    s_lshl_b32 s9, s9, 1
; SI-NEXT:    s_and_b32 s8, s8, 1
; SI-NEXT:    s_lshl_b32 s7, s7, 3
; SI-NEXT:    s_and_b32 s6, s6, 1
; SI-NEXT:    s_lshl_b32 s5, s5, 1
; SI-NEXT:    s_and_b32 s4, s4, 1
; SI-NEXT:    s_lshl_b32 s16, s3, 3
; SI-NEXT:    s_and_b32 s2, s2, 1
; SI-NEXT:    s_lshl_b32 s1, s1, 1
; SI-NEXT:    s_and_b32 s0, s0, 1
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_lshl_b32 s14, s14, 2
; SI-NEXT:    s_or_b32 s12, s12, s13
; SI-NEXT:    s_lshl_b32 s10, s10, 2
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_lshl_b32 s6, s6, 2
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_lshl_b32 s2, s2, 2
; SI-NEXT:    s_or_b32 s0, s0, s1
; SI-NEXT:    s_or_b32 s1, s15, s14
; SI-NEXT:    s_and_b32 s5, s12, 3
; SI-NEXT:    s_or_b32 s9, s11, s10
; SI-NEXT:    s_and_b32 s8, s8, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s4, s4, 3
; SI-NEXT:    s_or_b32 s2, s16, s2
; SI-NEXT:    s_and_b32 s0, s0, 3
; SI-NEXT:    s_or_b32 s1, s5, s1
; SI-NEXT:    s_or_b32 s5, s8, s9
; SI-NEXT:    s_or_b32 s4, s4, s6
; SI-NEXT:    s_or_b32 s0, s0, s2
; SI-NEXT:    s_lshl_b32 s1, s1, 12
; SI-NEXT:    s_and_b32 s2, s5, 15
; SI-NEXT:    s_lshl_b32 s4, s4, 4
; SI-NEXT:    s_and_b32 s0, s0, 15
; SI-NEXT:    s_lshl_b32 s2, s2, 8
; SI-NEXT:    s_or_b32 s0, s0, s4
; SI-NEXT:    s_or_b32 s1, s1, s2
; SI-NEXT:    s_and_b32 s0, s0, 0xff
; SI-NEXT:    s_or_b32 s0, s0, s1
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_inreg_v16i1:
; VI:       ; %bb.0:
; VI-NEXT:    s_and_b32 s10, s10, 1
; VI-NEXT:    s_lshl_b32 s9, s9, 1
; VI-NEXT:    s_and_b32 s8, s8, 1
; VI-NEXT:    s_and_b32 s6, s6, 1
; VI-NEXT:    s_lshl_b32 s5, s5, 1
; VI-NEXT:    s_and_b32 s4, s4, 1
; VI-NEXT:    s_and_b32 s2, s2, 1
; VI-NEXT:    s_lshl_b32 s1, s1, 1
; VI-NEXT:    s_and_b32 s0, s0, 1
; VI-NEXT:    s_and_b32 s14, s14, 1
; VI-NEXT:    s_lshl_b32 s13, s13, 1
; VI-NEXT:    s_and_b32 s12, s12, 1
; VI-NEXT:    s_lshl_b32 s11, s11, 3
; VI-NEXT:    s_lshl_b32 s10, s10, 2
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    s_lshl_b32 s7, s7, 3
; VI-NEXT:    s_lshl_b32 s6, s6, 2
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_lshl_b32 s3, s3, 3
; VI-NEXT:    s_lshl_b32 s2, s2, 2
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    s_lshl_b32 s15, s15, 3
; VI-NEXT:    s_lshl_b32 s14, s14, 2
; VI-NEXT:    s_or_b32 s12, s12, s13
; VI-NEXT:    s_or_b32 s10, s11, s10
; VI-NEXT:    s_and_b32 s8, s8, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s4, s4, 3
; VI-NEXT:    s_or_b32 s2, s3, s2
; VI-NEXT:    s_and_b32 s0, s0, 3
; VI-NEXT:    s_or_b32 s14, s15, s14
; VI-NEXT:    s_and_b32 s12, s12, 3
; VI-NEXT:    s_or_b32 s8, s8, s10
; VI-NEXT:    s_or_b32 s4, s4, s6
; VI-NEXT:    s_or_b32 s0, s0, s2
; VI-NEXT:    s_or_b32 s12, s12, s14
; VI-NEXT:    s_and_b32 s8, s8, 15
; VI-NEXT:    s_lshl_b32 s4, s4, 4
; VI-NEXT:    s_and_b32 s0, s0, 15
; VI-NEXT:    s_lshl_b32 s12, s12, 12
; VI-NEXT:    s_lshl_b32 s8, s8, 8
; VI-NEXT:    s_or_b32 s0, s0, s4
; VI-NEXT:    s_or_b32 s8, s12, s8
; VI-NEXT:    s_and_b32 s0, s0, 0xff
; VI-NEXT:    s_or_b32 s0, s0, s8
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amdgpu_cs_inreg_v16i1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_and_b32 s10, s10, 1
; GFX11-NEXT:    s_lshl_b32 s9, s9, 1
; GFX11-NEXT:    s_and_b32 s8, s8, 1
; GFX11-NEXT:    s_and_b32 s6, s6, 1
; GFX11-NEXT:    s_lshl_b32 s5, s5, 1
; GFX11-NEXT:    s_and_b32 s4, s4, 1
; GFX11-NEXT:    s_and_b32 s2, s2, 1
; GFX11-NEXT:    s_lshl_b32 s1, s1, 1
; GFX11-NEXT:    s_and_b32 s0, s0, 1
; GFX11-NEXT:    s_and_b32 s14, s14, 1
; GFX11-NEXT:    s_lshl_b32 s13, s13, 1
; GFX11-NEXT:    s_and_b32 s12, s12, 1
; GFX11-NEXT:    s_lshl_b32 s11, s11, 3
; GFX11-NEXT:    s_lshl_b32 s10, s10, 2
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_lshl_b32 s7, s7, 3
; GFX11-NEXT:    s_lshl_b32 s6, s6, 2
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_lshl_b32 s3, s3, 3
; GFX11-NEXT:    s_lshl_b32 s2, s2, 2
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_lshl_b32 s15, s15, 3
; GFX11-NEXT:    s_lshl_b32 s14, s14, 2
; GFX11-NEXT:    s_or_b32 s12, s12, s13
; GFX11-NEXT:    s_or_b32 s9, s11, s10
; GFX11-NEXT:    s_and_b32 s8, s8, 3
; GFX11-NEXT:    s_or_b32 s5, s7, s6
; GFX11-NEXT:    s_and_b32 s4, s4, 3
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_and_b32 s0, s0, 3
; GFX11-NEXT:    s_or_b32 s13, s15, s14
; GFX11-NEXT:    s_and_b32 s12, s12, 3
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_or_b32 s2, s4, s5
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s10, s12, s13
; GFX11-NEXT:    s_and_b32 s8, s8, 15
; GFX11-NEXT:    s_lshl_b32 s1, s2, 4
; GFX11-NEXT:    s_and_b32 s0, s0, 15
; GFX11-NEXT:    s_lshl_b32 s9, s10, 12
; GFX11-NEXT:    s_lshl_b32 s2, s8, 8
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s9, s2
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    global_store_b16 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  store <16 x i1> %arg0, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs void @amdgpu_cs_inreg_v32i1(<32 x i1> inreg %arg0) {
; SI-LABEL: amdgpu_cs_inreg_v32i1:
; SI:       ; %bb.0:
; SI-NEXT:    s_lshl_b32 s31, s31, 3
; SI-NEXT:    s_and_b32 s30, s30, 1
; SI-NEXT:    s_lshl_b32 s29, s29, 1
; SI-NEXT:    s_and_b32 s28, s28, 1
; SI-NEXT:    s_lshl_b32 s27, s27, 3
; SI-NEXT:    s_and_b32 s26, s26, 1
; SI-NEXT:    s_lshl_b32 s25, s25, 1
; SI-NEXT:    s_and_b32 s24, s24, 1
; SI-NEXT:    s_lshl_b32 s23, s23, 3
; SI-NEXT:    s_and_b32 s22, s22, 1
; SI-NEXT:    s_lshl_b32 s21, s21, 1
; SI-NEXT:    s_and_b32 s20, s20, 1
; SI-NEXT:    s_lshl_b32 s19, s19, 3
; SI-NEXT:    s_and_b32 s18, s18, 1
; SI-NEXT:    s_lshl_b32 s17, s17, 1
; SI-NEXT:    s_and_b32 s16, s16, 1
; SI-NEXT:    s_lshl_b32 s15, s15, 3
; SI-NEXT:    s_and_b32 s14, s14, 1
; SI-NEXT:    s_lshl_b32 s13, s13, 1
; SI-NEXT:    s_and_b32 s12, s12, 1
; SI-NEXT:    s_lshl_b32 s11, s11, 3
; SI-NEXT:    s_and_b32 s10, s10, 1
; SI-NEXT:    s_lshl_b32 s9, s9, 1
; SI-NEXT:    s_and_b32 s8, s8, 1
; SI-NEXT:    s_lshl_b32 s7, s7, 3
; SI-NEXT:    s_and_b32 s6, s6, 1
; SI-NEXT:    s_lshl_b32 s5, s5, 1
; SI-NEXT:    s_and_b32 s4, s4, 1
; SI-NEXT:    s_lshl_b32 s33, s3, 3
; SI-NEXT:    s_and_b32 s2, s2, 1
; SI-NEXT:    s_lshl_b32 s1, s1, 1
; SI-NEXT:    s_and_b32 s0, s0, 1
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_lshl_b32 s30, s30, 2
; SI-NEXT:    s_or_b32 s28, s28, s29
; SI-NEXT:    s_lshl_b32 s26, s26, 2
; SI-NEXT:    s_or_b32 s24, s24, s25
; SI-NEXT:    s_lshl_b32 s22, s22, 2
; SI-NEXT:    s_or_b32 s20, s20, s21
; SI-NEXT:    s_lshl_b32 s18, s18, 2
; SI-NEXT:    s_or_b32 s16, s16, s17
; SI-NEXT:    s_lshl_b32 s14, s14, 2
; SI-NEXT:    s_or_b32 s12, s12, s13
; SI-NEXT:    s_lshl_b32 s10, s10, 2
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_lshl_b32 s6, s6, 2
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_lshl_b32 s2, s2, 2
; SI-NEXT:    s_or_b32 s0, s0, s1
; SI-NEXT:    s_or_b32 s1, s31, s30
; SI-NEXT:    s_and_b32 s5, s28, 3
; SI-NEXT:    s_or_b32 s9, s27, s26
; SI-NEXT:    s_and_b32 s13, s24, 3
; SI-NEXT:    s_or_b32 s17, s23, s22
; SI-NEXT:    s_and_b32 s20, s20, 3
; SI-NEXT:    s_or_b32 s18, s19, s18
; SI-NEXT:    s_and_b32 s16, s16, 3
; SI-NEXT:    s_or_b32 s14, s15, s14
; SI-NEXT:    s_and_b32 s12, s12, 3
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    s_and_b32 s8, s8, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s4, s4, 3
; SI-NEXT:    s_or_b32 s2, s33, s2
; SI-NEXT:    s_and_b32 s0, s0, 3
; SI-NEXT:    s_or_b32 s1, s5, s1
; SI-NEXT:    s_or_b32 s5, s13, s9
; SI-NEXT:    s_or_b32 s7, s20, s17
; SI-NEXT:    s_or_b32 s9, s16, s18
; SI-NEXT:    s_or_b32 s11, s12, s14
; SI-NEXT:    s_or_b32 s8, s8, s10
; SI-NEXT:    s_or_b32 s4, s4, s6
; SI-NEXT:    s_or_b32 s0, s0, s2
; SI-NEXT:    s_lshl_b32 s1, s1, 12
; SI-NEXT:    s_and_b32 s2, s5, 15
; SI-NEXT:    s_lshl_b32 s5, s7, 4
; SI-NEXT:    s_and_b32 s6, s9, 15
; SI-NEXT:    s_lshl_b32 s7, s11, 12
; SI-NEXT:    s_and_b32 s8, s8, 15
; SI-NEXT:    s_lshl_b32 s4, s4, 4
; SI-NEXT:    s_and_b32 s0, s0, 15
; SI-NEXT:    s_lshl_b32 s2, s2, 8
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_lshl_b32 s6, s8, 8
; SI-NEXT:    s_or_b32 s0, s0, s4
; SI-NEXT:    s_or_b32 s1, s1, s2
; SI-NEXT:    s_and_b32 s2, s5, 0xff
; SI-NEXT:    s_or_b32 s4, s7, s6
; SI-NEXT:    s_and_b32 s0, s0, 0xff
; SI-NEXT:    s_or_b32 s1, s2, s1
; SI-NEXT:    s_or_b32 s0, s0, s4
; SI-NEXT:    s_lshl_b32 s1, s1, 16
; SI-NEXT:    s_and_b32 s0, s0, 0xffff
; SI-NEXT:    s_or_b32 s0, s0, s1
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_inreg_v32i1:
; VI:       ; %bb.0:
; VI-NEXT:    s_and_b32 s26, s26, 1
; VI-NEXT:    s_lshl_b32 s25, s25, 1
; VI-NEXT:    s_and_b32 s24, s24, 1
; VI-NEXT:    s_and_b32 s22, s22, 1
; VI-NEXT:    s_lshl_b32 s21, s21, 1
; VI-NEXT:    s_and_b32 s20, s20, 1
; VI-NEXT:    s_and_b32 s18, s18, 1
; VI-NEXT:    s_lshl_b32 s17, s17, 1
; VI-NEXT:    s_and_b32 s16, s16, 1
; VI-NEXT:    s_and_b32 s10, s10, 1
; VI-NEXT:    s_lshl_b32 s9, s9, 1
; VI-NEXT:    s_and_b32 s8, s8, 1
; VI-NEXT:    s_and_b32 s6, s6, 1
; VI-NEXT:    s_lshl_b32 s5, s5, 1
; VI-NEXT:    s_and_b32 s4, s4, 1
; VI-NEXT:    s_and_b32 s2, s2, 1
; VI-NEXT:    s_lshl_b32 s1, s1, 1
; VI-NEXT:    s_and_b32 s0, s0, 1
; VI-NEXT:    s_and_b32 s30, s30, 1
; VI-NEXT:    s_lshl_b32 s29, s29, 1
; VI-NEXT:    s_and_b32 s28, s28, 1
; VI-NEXT:    s_lshl_b32 s27, s27, 3
; VI-NEXT:    s_lshl_b32 s26, s26, 2
; VI-NEXT:    s_or_b32 s24, s24, s25
; VI-NEXT:    s_lshl_b32 s23, s23, 3
; VI-NEXT:    s_lshl_b32 s22, s22, 2
; VI-NEXT:    s_or_b32 s20, s20, s21
; VI-NEXT:    s_lshl_b32 s19, s19, 3
; VI-NEXT:    s_lshl_b32 s18, s18, 2
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s14, s14, 1
; VI-NEXT:    s_lshl_b32 s13, s13, 1
; VI-NEXT:    s_and_b32 s12, s12, 1
; VI-NEXT:    s_lshl_b32 s11, s11, 3
; VI-NEXT:    s_lshl_b32 s10, s10, 2
; VI-NEXT:    s_or_b32 s8, s8, s9
; VI-NEXT:    s_lshl_b32 s7, s7, 3
; VI-NEXT:    s_lshl_b32 s6, s6, 2
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_lshl_b32 s3, s3, 3
; VI-NEXT:    s_lshl_b32 s2, s2, 2
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    s_lshl_b32 s31, s31, 3
; VI-NEXT:    s_lshl_b32 s30, s30, 2
; VI-NEXT:    s_or_b32 s28, s28, s29
; VI-NEXT:    s_or_b32 s26, s27, s26
; VI-NEXT:    s_and_b32 s24, s24, 3
; VI-NEXT:    s_or_b32 s22, s23, s22
; VI-NEXT:    s_and_b32 s20, s20, 3
; VI-NEXT:    s_or_b32 s18, s19, s18
; VI-NEXT:    s_and_b32 s16, s16, 3
; VI-NEXT:    s_lshl_b32 s15, s15, 3
; VI-NEXT:    s_lshl_b32 s14, s14, 2
; VI-NEXT:    s_or_b32 s12, s12, s13
; VI-NEXT:    s_or_b32 s10, s11, s10
; VI-NEXT:    s_and_b32 s8, s8, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s4, s4, 3
; VI-NEXT:    s_or_b32 s2, s3, s2
; VI-NEXT:    s_and_b32 s0, s0, 3
; VI-NEXT:    s_or_b32 s30, s31, s30
; VI-NEXT:    s_and_b32 s28, s28, 3
; VI-NEXT:    s_or_b32 s24, s24, s26
; VI-NEXT:    s_or_b32 s20, s20, s22
; VI-NEXT:    s_or_b32 s16, s16, s18
; VI-NEXT:    s_or_b32 s14, s15, s14
; VI-NEXT:    s_and_b32 s12, s12, 3
; VI-NEXT:    s_or_b32 s8, s8, s10
; VI-NEXT:    s_or_b32 s4, s4, s6
; VI-NEXT:    s_or_b32 s0, s0, s2
; VI-NEXT:    s_or_b32 s28, s28, s30
; VI-NEXT:    s_and_b32 s24, s24, 15
; VI-NEXT:    s_lshl_b32 s20, s20, 4
; VI-NEXT:    s_and_b32 s16, s16, 15
; VI-NEXT:    s_or_b32 s12, s12, s14
; VI-NEXT:    s_and_b32 s8, s8, 15
; VI-NEXT:    s_lshl_b32 s4, s4, 4
; VI-NEXT:    s_and_b32 s0, s0, 15
; VI-NEXT:    s_lshl_b32 s28, s28, 12
; VI-NEXT:    s_lshl_b32 s24, s24, 8
; VI-NEXT:    s_or_b32 s16, s16, s20
; VI-NEXT:    s_lshl_b32 s12, s12, 12
; VI-NEXT:    s_lshl_b32 s8, s8, 8
; VI-NEXT:    s_or_b32 s0, s0, s4
; VI-NEXT:    s_or_b32 s24, s28, s24
; VI-NEXT:    s_and_b32 s16, s16, 0xff
; VI-NEXT:    s_or_b32 s8, s12, s8
; VI-NEXT:    s_and_b32 s0, s0, 0xff
; VI-NEXT:    s_or_b32 s16, s16, s24
; VI-NEXT:    s_or_b32 s0, s0, s8
; VI-NEXT:    s_lshl_b32 s16, s16, 16
; VI-NEXT:    s_and_b32 s0, s0, 0xffff
; VI-NEXT:    s_or_b32 s0, s0, s16
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amdgpu_cs_inreg_v32i1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_and_b32 s10, s10, 1
; GFX11-NEXT:    s_lshl_b32 s9, s9, 1
; GFX11-NEXT:    s_and_b32 s8, s8, 1
; GFX11-NEXT:    s_and_b32 s14, s14, 1
; GFX11-NEXT:    s_lshl_b32 s13, s13, 1
; GFX11-NEXT:    s_and_b32 s12, s12, 1
; GFX11-NEXT:    s_lshl_b32 s11, s11, 3
; GFX11-NEXT:    s_lshl_b32 s10, s10, 2
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_and_b32 s6, s6, 1
; GFX11-NEXT:    s_lshl_b32 s5, s5, 1
; GFX11-NEXT:    s_and_b32 s4, s4, 1
; GFX11-NEXT:    s_and_b32 s2, s2, 1
; GFX11-NEXT:    s_lshl_b32 s1, s1, 1
; GFX11-NEXT:    s_and_b32 s0, s0, 1
; GFX11-NEXT:    s_lshl_b32 s15, s15, 3
; GFX11-NEXT:    s_lshl_b32 s14, s14, 2
; GFX11-NEXT:    s_or_b32 s12, s12, s13
; GFX11-NEXT:    s_or_b32 s9, s11, s10
; GFX11-NEXT:    s_and_b32 s8, s8, 3
; GFX11-NEXT:    s_lshl_b32 s7, s7, 3
; GFX11-NEXT:    s_lshl_b32 s6, s6, 2
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_lshl_b32 s3, s3, 3
; GFX11-NEXT:    s_lshl_b32 s2, s2, 2
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s13, s15, s14
; GFX11-NEXT:    s_and_b32 s12, s12, 3
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_or_b32 s5, s7, s6
; GFX11-NEXT:    s_and_b32 s4, s4, 3
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_and_b32 s0, s0, 3
; GFX11-NEXT:    s_or_b32 s10, s12, s13
; GFX11-NEXT:    s_and_b32 s8, s8, 15
; GFX11-NEXT:    s_or_b32 s2, s4, s5
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_lshl_b32 s9, s10, 12
; GFX11-NEXT:    s_lshl_b32 s1, s2, 4
; GFX11-NEXT:    s_and_b32 s0, s0, 15
; GFX11-NEXT:    s_lshl_b32 s2, s8, 8
; GFX11-NEXT:    s_and_b32 s3, s30, 1
; GFX11-NEXT:    s_lshl_b32 s4, s29, 1
; GFX11-NEXT:    s_and_b32 s5, s28, 1
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s9, s2
; GFX11-NEXT:    s_lshl_b32 s2, s31, 3
; GFX11-NEXT:    s_lshl_b32 s3, s3, 2
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    s_and_b32 s5, s26, 1
; GFX11-NEXT:    s_lshl_b32 s6, s25, 1
; GFX11-NEXT:    s_and_b32 s7, s24, 1
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_and_b32 s3, s4, 3
; GFX11-NEXT:    s_lshl_b32 s4, s27, 3
; GFX11-NEXT:    s_lshl_b32 s5, s5, 2
; GFX11-NEXT:    s_or_b32 s6, s7, s6
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_and_b32 s5, s6, 3
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s5, s4
; GFX11-NEXT:    s_and_b32 s5, s22, 1
; GFX11-NEXT:    s_lshl_b32 s6, s21, 1
; GFX11-NEXT:    s_and_b32 s7, s20, 1
; GFX11-NEXT:    s_lshl_b32 s4, s23, 3
; GFX11-NEXT:    s_lshl_b32 s5, s5, 2
; GFX11-NEXT:    s_or_b32 s6, s7, s6
; GFX11-NEXT:    s_and_b32 s7, s18, 1
; GFX11-NEXT:    s_lshl_b32 s8, s17, 1
; GFX11-NEXT:    s_and_b32 s9, s16, 1
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_and_b32 s5, s6, 3
; GFX11-NEXT:    s_lshl_b32 s6, s19, 3
; GFX11-NEXT:    s_lshl_b32 s7, s7, 2
; GFX11-NEXT:    s_or_b32 s8, s9, s8
; GFX11-NEXT:    s_or_b32 s6, s6, s7
; GFX11-NEXT:    s_and_b32 s7, s8, 3
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    s_or_b32 s5, s7, s6
; GFX11-NEXT:    s_and_b32 s3, s3, 15
; GFX11-NEXT:    s_lshl_b32 s4, s4, 4
; GFX11-NEXT:    s_and_b32 s5, s5, 15
; GFX11-NEXT:    s_lshl_b32 s2, s2, 12
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    s_and_b32 s3, s4, 0xff
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  store <32 x i1> %arg0, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs void @amdgpu_cs_i1_sext(i1 signext %arg0) {
; SI-LABEL: amdgpu_cs_i1_sext:
; SI:       ; %bb.0:
; SI-NEXT:    v_and_b32_e32 v0, 1, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_i1_sext:
; VI:       ; %bb.0:
; VI-NEXT:    v_and_b32_e32 v0, 1, v0
; VI-NEXT:    flat_store_byte v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amdgpu_cs_i1_sext:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    global_store_b8 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  store i1 %arg0, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs void @amdgpu_cs_i1_zext(i1 zeroext %arg0) {
; SI-LABEL: amdgpu_cs_i1_zext:
; SI:       ; %bb.0:
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: amdgpu_cs_i1_zext:
; VI:       ; %bb.0:
; VI-NEXT:    flat_store_byte v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: amdgpu_cs_i1_zext:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_store_b8 v[0:1], v0, off
; GFX11-NEXT:    s_endpgm
  store i1 %arg0, ptr addrspace(1) poison
  ret void
}

attributes #0 = { nounwind noinline }
