; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-attributes --check-globals all --version 5
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-attributor %s | FileCheck %s

; External call to avoid inferring argument attributes. This makes the
; final attribute groups easier to read
declare void @dummy()

define void @extern_callee() {
; CHECK-LABEL: define void @extern_callee(
; CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @dummy()
  ret void
}

define internal void @callee_1_2_3() {
; CHECK-LABEL: define internal void @callee_1_2_3(
; CHECK-SAME: ) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @dummy()
  ret void
}

define amdgpu_kernel void @kernel_1_2_3() #0 {
; CHECK-LABEL: define amdgpu_kernel void @kernel_1_2_3(
; CHECK-SAME: ) #[[ATTR1]] {
; CHECK-NEXT:    call void @callee_1_2_3()
; CHECK-NEXT:    call void @extern_callee()
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @callee_1_2_3()
  call void @extern_callee()
  call void @dummy()
  ret void
}

attributes #0 = {"amdgpu-max-num-workgroups"="1,2,3"}

; -> 100,10,99
define internal void @callee_merge_100_8_32__16_10_99() {
; CHECK-LABEL: define internal void @callee_merge_100_8_32__16_10_99(
; CHECK-SAME: ) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @dummy()
  ret void
}

define amdgpu_kernel void @kernel_100_8_32() #1 {
; CHECK-LABEL: define amdgpu_kernel void @kernel_100_8_32(
; CHECK-SAME: ) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    call void @callee_merge_100_8_32__16_10_99()
; CHECK-NEXT:    ret void
;
  call void @callee_merge_100_8_32__16_10_99()
  ret void
}

define amdgpu_cs void @amdgpu_cs_100_8_32() #1 {
; CHECK-LABEL: define amdgpu_cs void @amdgpu_cs_100_8_32(
; CHECK-SAME: ) #[[ATTR3]] {
; CHECK-NEXT:    call void @callee_merge_100_8_32__16_10_99()
; CHECK-NEXT:    ret void
;
  call void @callee_merge_100_8_32__16_10_99()
  ret void
}

attributes #1 = {"amdgpu-max-num-workgroups"="100,8,32"}

define amdgpu_kernel void @kernel_16_10_99() #2 {
; CHECK-LABEL: define amdgpu_kernel void @kernel_16_10_99(
; CHECK-SAME: ) #[[ATTR4:[0-9]+]] {
; CHECK-NEXT:    call void @callee_merge_100_8_32__16_10_99()
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @callee_merge_100_8_32__16_10_99()
  call void @dummy()
  ret void
}

attributes #2 = {"amdgpu-max-num-workgroups"="16,10,99"}

define internal void @merge_to_worst_case() {
; CHECK-LABEL: define internal void @merge_to_worst_case(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @dummy()
  ret void
}

define internal void @callee_x_worst_case() {
; CHECK-LABEL: define internal void @callee_x_worst_case(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @dummy()
  ret void
}

define amdgpu_kernel void @kernel_x_maximum() #3 {
; CHECK-LABEL: define amdgpu_kernel void @kernel_x_maximum(
; CHECK-SAME: ) #[[ATTR5:[0-9]+]] {
; CHECK-NEXT:    call void @merge_to_worst_case()
; CHECK-NEXT:    call void @callee_x_worst_case()
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @merge_to_worst_case()
  call void @callee_x_worst_case()
  call void @dummy()
  ret void
}

attributes #3 = {"amdgpu-max-num-workgroups"="4294967295,1,1"}

define amdgpu_kernel void @kernel_y_maximum() #4 {
; CHECK-LABEL: define amdgpu_kernel void @kernel_y_maximum(
; CHECK-SAME: ) #[[ATTR6:[0-9]+]] {
; CHECK-NEXT:    call void @merge_to_worst_case()
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @merge_to_worst_case()
  call void @dummy()
  ret void
}

attributes #4 = {"amdgpu-max-num-workgroups"="1,4294967295,1"}

define amdgpu_kernel void @kernel_z_maximum() #5 {
; CHECK-LABEL: define amdgpu_kernel void @kernel_z_maximum(
; CHECK-SAME: ) #[[ATTR7:[0-9]+]] {
; CHECK-NEXT:    call void @merge_to_worst_case()
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @merge_to_worst_case()
  call void @dummy()
  ret void
}

attributes #5 = {"amdgpu-max-num-workgroups"="1,1,4294967295"}

; Make sure the attribute isn't lost from the callee.
define internal void @annotated_callee_from_unannotated_kernel() #6 {
; CHECK-LABEL: define internal void @annotated_callee_from_unannotated_kernel(
; CHECK-SAME: ) #[[ATTR8:[0-9]+]] {
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @dummy()
  ret void
}

attributes #6 = {"amdgpu-max-num-workgroups"="42,99,123"}

define amdgpu_kernel void @unannotated_kernel_calls_annotated_callee()  {
; CHECK-LABEL: define amdgpu_kernel void @unannotated_kernel_calls_annotated_callee(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:    call void @annotated_callee_from_unannotated_kernel()
; CHECK-NEXT:    ret void
;
  call void @annotated_callee_from_unannotated_kernel()
  ret void
}


define internal void @annotated_callee_merge_caller() #7 {
; CHECK-LABEL: define internal void @annotated_callee_merge_caller(
; CHECK-SAME: ) #[[ATTR9:[0-9]+]] {
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @dummy()
  ret void
}

attributes #7 = {"amdgpu-max-num-workgroups"="512,256,1024"}

define amdgpu_kernel void @call_annotated_callee_merge_caller() #8 {
; CHECK-LABEL: define amdgpu_kernel void @call_annotated_callee_merge_caller(
; CHECK-SAME: ) #[[ATTR10:[0-9]+]] {
; CHECK-NEXT:    call void @annotated_callee_merge_caller()
; CHECK-NEXT:    ret void
;
  call void @annotated_callee_merge_caller()
  ret void
}

attributes #8 = {"amdgpu-max-num-workgroups"="256,128,2048"}

define internal void @called_by_explicit_worst_case() {
; CHECK-LABEL: define internal void @called_by_explicit_worst_case(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    ret void
;
  call void @dummy()
  ret void
}

define amdgpu_kernel void @kernel_explicit_worst_case() #9 {
; CHECK-LABEL: define amdgpu_kernel void @kernel_explicit_worst_case(
; CHECK-SAME: ) #[[ATTR11:[0-9]+]] {
; CHECK-NEXT:    call void @called_by_explicit_worst_case()
; CHECK-NEXT:    ret void
;
  call void @called_by_explicit_worst_case()
  ret void
}

attributes #9 = {"amdgpu-max-num-workgroups"="4294967295,4294967295,4294967295"}

;.
; CHECK: attributes #[[ATTR0]] = { "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR1]] = { "amdgpu-max-num-workgroups"="1,2,3" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR2]] = { "amdgpu-max-num-workgroups"="100,10,99" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR3]] = { "amdgpu-max-num-workgroups"="100,8,32" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR4]] = { "amdgpu-max-num-workgroups"="16,10,99" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR5]] = { "amdgpu-max-num-workgroups"="4294967295,1,1" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR6]] = { "amdgpu-max-num-workgroups"="1,4294967295,1" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR7]] = { "amdgpu-max-num-workgroups"="1,1,4294967295" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR8]] = { "amdgpu-max-num-workgroups"="42,99,123" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR9]] = { "amdgpu-max-num-workgroups"="256,128,1024" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR10]] = { "amdgpu-max-num-workgroups"="256,128,2048" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR11]] = { "amdgpu-max-num-workgroups"="4294967295,4294967295,4294967295" "amdgpu-waves-per-eu"="4,10" "uniform-work-group-size"="false" }
;.
