; Test skipping inlining when the callsite is unreachable (for both mandatory
; and non-mandatory cases)
; REQUIRES: llvm_inliner_model_autogenerated
; RUN: opt -passes=inliner-ml-advisor-release -S < %s | FileCheck %s --check-prefix=CHECK

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-grtev4-linux-gnu"

; Mandatory case
define i32 @f1() {
entry:
  br label %exit
some_bb:  ; unreachable - has no predecessors
  %r = call i32 @f2()
  br label %exit
exit:
  ret i32 1
}

define i32 @f2() #0 {
  ret i32 2
}

; Non-mandatory case
define i32 @f3() {
entry:
  br label %exit
some_bb:  ; unreachable - has no predecessors
  %r = call i32 @f4()
  br label %exit
exit:
  ret i32 1
}

define i32 @f4() {
  ret i32 2
}

attributes #0 = { alwaysinline }

; CHECK-LABEL: @f1
; CHECK-LABEL: some_bb
; CHECK-NEXT: call i32 @f2
; CHECK-LABEL: @f3
; CHECK-LABEL: some_bb
; CHECK-NEXT: call i32 @f4
