/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * rhbz_599924.c
 * Copyright (C) 2008-2012 Red Hat, Inc. All rights reserved.
 * 
 * Authors:
 *   Akira TAGOH  <tagoh@redhat.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301  USA
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <unistd.h>
#include <glib.h>
#include "imsettings-info.h"
#include "main.h"

#define N_(s)	s

/************************************************************/
/* common functions                                         */
/************************************************************/
void
setup(void)
{
}

void
teardown(void)
{
}

static gpointer
_thread(gpointer data)
{
	IMSettingsInfo **info = (IMSettingsInfo **)data;
	GVariant *v;
	gchar *xinputrc;
	static gboolean first = FALSE;
	static gint i = 0;
	gint j;

	if (!first) {
		first = TRUE;
		xinputrc = g_build_filename(IMSETTINGS_SRCDIR, "testcases", "rhbz_599924", "xinput.d", "xim2.conf", NULL);
	} else {
		xinputrc = g_build_filename(IMSETTINGS_SRCDIR, "testcases", "rhbz_599924", "xinput.d", "xim.conf", NULL);
	}
	g_print("creating...%d\n", ++i);
	j = i;
	v = imsettings_info_variant_new(xinputrc, NULL);
	if (v == NULL)
		g_print("failing %d\n", j);
	*info = imsettings_info_new(v);
	g_variant_unref(v);

	g_free(xinputrc);

	return NULL;
}

/************************************************************/
/* Test cases                                               */
/************************************************************/
TDEF (issue) {
#define N	512
	GThread *th[N];
	IMSettingsInfo *i[N];
	int x;

	for (x = 0; x < N; x++) {
		i[x] = NULL;
		th[x] = g_thread_new("foo", &_thread, (gpointer)&i[x]);
	}
	for (x = 0; x < N; x++) {
		g_thread_join(th[x]);
		fail_unless(i[x] != NULL, "Unable to create the instance.");
		fail_unless(imsettings_info_get_short_desc(i[x]) != NULL, "Unable to obtain the short description: %d", x);
		if (x > 0) {
			fail_unless(imsettings_info_compare(i[x - 1], i[x]), "Obtaining different information: %d vs %d", x - 1, x);
		}
	}
} TEND

/************************************************************/
Suite *
imsettings_suite(void)
{
	Suite *s = suite_create("Red Hat Bugzilla");
	TCase *tc = tcase_create("Bug#599924: https://bugzilla.redhat.com/show_bug.cgi?id=599924");

	tcase_add_checked_fixture(tc, setup, teardown);
	tcase_set_timeout(tc, 600);

	T (issue);

	suite_add_tcase(s, tc);

	return s;
}
