/* application.c generated by valac 0.38.7, the Vala compiler
 * generated from application.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include "config.h"
#include <libgweather/gweather.h>


#define CLOCKS_TYPE_APPLICATION (clocks_application_get_type ())
#define CLOCKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplication))
#define CLOCKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))
#define CLOCKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))

typedef struct _ClocksApplication ClocksApplication;
typedef struct _ClocksApplicationClass ClocksApplicationClass;
typedef struct _ClocksApplicationPrivate ClocksApplicationPrivate;

#define CLOCKS_TYPE_SEARCH_PROVIDER (clocks_search_provider_get_type ())
#define CLOCKS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProvider))
#define CLOCKS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProviderClass))
#define CLOCKS_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_SEARCH_PROVIDER))
#define CLOCKS_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_SEARCH_PROVIDER))
#define CLOCKS_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProviderClass))

typedef struct _ClocksSearchProvider ClocksSearchProvider;
typedef struct _ClocksSearchProviderClass ClocksSearchProviderClass;

#define CLOCKS_TYPE_WINDOW (clocks_window_get_type ())
#define CLOCKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_WINDOW, ClocksWindow))
#define CLOCKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_WINDOW, ClocksWindowClass))
#define CLOCKS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_WINDOW))
#define CLOCKS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_WINDOW))
#define CLOCKS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_WINDOW, ClocksWindowClass))

typedef struct _ClocksWindow ClocksWindow;
typedef struct _ClocksWindowClass ClocksWindowClass;
enum  {
	CLOCKS_APPLICATION_0_PROPERTY,
	CLOCKS_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* clocks_application_properties[CLOCKS_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gweather_location_unref0(var) ((var == NULL) ? NULL : (var = (gweather_location_unref (var), NULL)))

struct _ClocksApplication {
	GtkApplication parent_instance;
	ClocksApplicationPrivate * priv;
};

struct _ClocksApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ClocksApplicationPrivate {
	ClocksSearchProvider* search_provider;
	guint search_provider_id;
	ClocksWindow* window;
	GList* system_notifications;
};

struct _Block4Data {
	int _ref_count_;
	ClocksApplication* self;
	GtkSettings* settings;
};


static gpointer clocks_application_parent_class = NULL;

GType clocks_application_get_type (void) G_GNUC_CONST;
GType clocks_search_provider_get_type (void) G_GNUC_CONST;
guint clocks_search_provider_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType clocks_window_get_type (void) G_GNUC_CONST;
#define CLOCKS_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TYPE_APPLICATION, ClocksApplicationPrivate))
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void clocks_application_on_quit_activate (ClocksApplication* self);
static void _clocks_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void clocks_application_on_add_location_activate (ClocksApplication* self, GSimpleAction* action, GVariant* parameter);
static void _clocks_application_on_add_location_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void clocks_application_ensure_window (ClocksApplication* self);
ClocksWindow* clocks_window_new (ClocksApplication* app);
ClocksWindow* clocks_window_construct (GType object_type, ClocksApplication* app);
static void ___lambda55_ (ClocksApplication* self);
static void ____lambda55__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
ClocksApplication* clocks_application_new (void);
ClocksApplication* clocks_application_construct (GType object_type);
ClocksSearchProvider* clocks_search_provider_new (void);
ClocksSearchProvider* clocks_search_provider_construct (GType object_type);
static void __lambda56_ (ClocksApplication* self, guint32 timestamp);
void clocks_window_show_world (ClocksWindow* self);
static void ___lambda56__clocks_search_provider_activate (ClocksSearchProvider* _sender, guint32 timestamp, gpointer self);
static gboolean clocks_application_real_dbus_register (GApplication* base, GDBusConnection* connection, const gchar* object_path, GError** error);
static void clocks_application_real_dbus_unregister (GApplication* base, GDBusConnection* connection, const gchar* object_path);
static void clocks_application_real_activate (GApplication* base);
static gboolean __lambda57_ (ClocksApplication* self);
static void clocks_application_withdraw_notifications (ClocksApplication* self);
static gboolean ___lambda57__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void clocks_application_update_theme (ClocksApplication* self, GtkSettings* settings);
void clocks_utils_load_theme_css (const gchar* theme_name);
static void clocks_application_real_startup (GApplication* base);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
void clocks_utils_load_main_css (void);
static void __lambda58_ (Block4Data* _data4_);
static void ___lambda58__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gint clocks_application_real_handle_local_options (GApplication* base, GVariantDict* options);
void clocks_window_add_world_location (ClocksWindow* self, GWeatherLocation* location);
void clocks_application_send_notification (ClocksApplication* self, const gchar* notification_id, GNotification* notification);
static void clocks_application_real_shutdown (GApplication* base);
static void clocks_application_finalize (GObject * obj);

static const GOptionEntry CLOCKS_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Print version information and exit"), NULL}, {NULL}};
static const GActionEntry CLOCKS_APPLICATION_action_entries[4] = {{"stop-alarm", NULL, "s"}, {"snooze-alarm", NULL, "s"}, {"quit", _clocks_application_on_quit_activate_gsimple_action_activate_callback}, {"add-location", _clocks_application_on_add_location_activate_gsimple_action_activate_callback, "v"}};

static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static inline void _g_list_free__g_free0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}


static void _clocks_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	clocks_application_on_quit_activate ((ClocksApplication*) self);
}


static void _clocks_application_on_add_location_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	clocks_application_on_add_location_activate ((ClocksApplication*) self, action, parameter);
}


static void ___lambda55_ (ClocksApplication* self) {
	_g_object_unref0 (self->priv->window);
	self->priv->window = NULL;
}


static void ____lambda55__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	___lambda55_ ((ClocksApplication*) self);
}


static void clocks_application_ensure_window (ClocksApplication* self) {
	ClocksWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		ClocksWindow* _tmp1_;
		ClocksWindow* _tmp2_;
		_tmp1_ = clocks_window_new (self);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->window);
		self->priv->window = _tmp1_;
		_tmp2_ = self->priv->window;
		g_signal_connect_object ((GtkWidget*) _tmp2_, "destroy", (GCallback) ____lambda55__gtk_widget_destroy, self, 0);
	}
}


static void __lambda56_ (ClocksApplication* self, guint32 timestamp) {
	ClocksWindow* _tmp0_;
	ClocksWindow* _tmp1_;
	guint32 _tmp2_;
	clocks_application_ensure_window (self);
	_tmp0_ = self->priv->window;
	clocks_window_show_world (_tmp0_);
	_tmp1_ = self->priv->window;
	_tmp2_ = timestamp;
	gtk_window_present_with_time ((GtkWindow*) _tmp1_, _tmp2_);
}


static void ___lambda56__clocks_search_provider_activate (ClocksSearchProvider* _sender, guint32 timestamp, gpointer self) {
	__lambda56_ ((ClocksApplication*) self, timestamp);
}


ClocksApplication* clocks_application_construct (GType object_type) {
	ClocksApplication * self = NULL;
	ClocksSearchProvider* _tmp0_;
	ClocksSearchProvider* _tmp1_;
	self = (ClocksApplication*) g_object_new (object_type, "application-id", "org.gnome.clocks", NULL);
	gtk_window_set_default_icon_name ("org.gnome.clocks");
	g_application_add_main_option_entries ((GApplication*) self, CLOCKS_APPLICATION_option_entries);
	g_action_map_add_action_entries ((GActionMap*) self, CLOCKS_APPLICATION_action_entries, G_N_ELEMENTS (CLOCKS_APPLICATION_action_entries), self);
	_tmp0_ = clocks_search_provider_new ();
	_g_object_unref0 (self->priv->search_provider);
	self->priv->search_provider = _tmp0_;
	_tmp1_ = self->priv->search_provider;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) ___lambda56__clocks_search_provider_activate, self, 0);
	__g_list_free__g_free0_0 (self->priv->system_notifications);
	self->priv->system_notifications = NULL;
	return self;
}


ClocksApplication* clocks_application_new (void) {
	return clocks_application_construct (CLOCKS_TYPE_APPLICATION);
}


static gboolean clocks_application_real_dbus_register (GApplication* base, GDBusConnection* connection, const gchar* object_path, GError** error) {
	ClocksApplication * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (ClocksApplication*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	{
		guint _tmp0_ = 0U;
		GDBusConnection* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ClocksSearchProvider* _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		_tmp1_ = connection;
		_tmp2_ = object_path;
		_tmp3_ = g_strconcat (_tmp2_, "/SearchProvider", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->search_provider;
		_tmp6_ = clocks_search_provider_register_object (_tmp5_, _tmp1_, _tmp4_, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp4_);
		_tmp0_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp8_ = FALSE;
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
		self->priv->search_provider_id = _tmp0_;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = _error_;
		_tmp10_ = _tmp9_->message;
		g_printerr ("Could not register search provider service: %s\n", _tmp10_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp11_;
	}
	result = TRUE;
	return result;
}


static void clocks_application_real_dbus_unregister (GApplication* base, GDBusConnection* connection, const gchar* object_path) {
	ClocksApplication * self;
	guint _tmp0_;
	self = (ClocksApplication*) base;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	_tmp0_ = self->priv->search_provider_id;
	if (_tmp0_ != ((guint) 0)) {
		GDBusConnection* _tmp1_;
		guint _tmp2_;
		_tmp1_ = connection;
		_tmp2_ = self->priv->search_provider_id;
		g_dbus_connection_unregister_object (_tmp1_, _tmp2_);
		self->priv->search_provider_id = (guint) 0;
	}
}


static gboolean __lambda57_ (ClocksApplication* self) {
	gboolean result = FALSE;
	clocks_application_withdraw_notifications (self);
	result = FALSE;
	return result;
}


static gboolean ___lambda57__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda57_ ((ClocksApplication*) self);
	return result;
}


static void clocks_application_real_activate (GApplication* base) {
	ClocksApplication * self;
	ClocksWindow* _tmp0_;
	ClocksWindow* _tmp1_;
	self = (ClocksApplication*) base;
	G_APPLICATION_CLASS (clocks_application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	clocks_application_ensure_window (self);
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	_tmp1_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "focus-in-event", (GCallback) ___lambda57__gtk_widget_focus_in_event, self, 0);
}


static void clocks_application_update_theme (ClocksApplication* self, GtkSettings* settings) {
	gchar* theme_name = NULL;
	GtkSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = settings;
	g_object_get ((GObject*) _tmp0_, "gtk-theme-name", &theme_name, NULL);
	clocks_utils_load_theme_css (theme_name);
	_g_free0 (theme_name);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ClocksApplication* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->settings);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda58_ (Block4Data* _data4_) {
	ClocksApplication* self;
	self = _data4_->self;
	clocks_application_update_theme (self, _data4_->settings);
}


static void ___lambda58__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda58_ (self);
}


static void clocks_application_real_startup (GApplication* base) {
	ClocksApplication * self;
	Block4Data* _data4_;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	self = (ClocksApplication*) base;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	G_APPLICATION_CLASS (clocks_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	clocks_utils_load_main_css ();
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data4_->settings = _tmp1_;
	g_signal_connect_data ((GObject*) _data4_->settings, "notify::gtk-theme-name", (GCallback) ___lambda58__g_object_notify, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	clocks_application_update_theme (self, _data4_->settings);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>n", "win.new", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>a", "win.select-all", NULL);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static gint clocks_application_real_handle_local_options (GApplication* base, GVariantDict* options) {
	ClocksApplication * self;
	gint result = 0;
	GVariantDict* _tmp0_;
	gboolean _tmp1_;
	self = (ClocksApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		const gchar* _tmp2_;
		_tmp2_ = g_get_application_name ();
		g_print ("%s %s\n", _tmp2_, VERSION);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}


static gpointer _gweather_location_ref0 (gpointer self) {
	return self ? gweather_location_ref (self) : NULL;
}


void clocks_application_on_add_location_activate (ClocksApplication* self, GSimpleAction* action, GVariant* parameter) {
	GVariant* _tmp0_;
	ClocksWindow* _tmp1_;
	ClocksWindow* _tmp2_;
	GWeatherLocation* world = NULL;
	GWeatherLocation* _tmp3_;
	GWeatherLocation* _tmp4_;
	GWeatherLocation* location = NULL;
	GWeatherLocation* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GWeatherLocation* _tmp9_;
	GWeatherLocation* _tmp10_;
	GWeatherLocation* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = parameter;
	if (_tmp0_ == NULL) {
		return;
	}
	clocks_application_ensure_window (self);
	_tmp1_ = self->priv->window;
	clocks_window_show_world (_tmp1_);
	_tmp2_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp2_);
	_tmp3_ = gweather_location_get_world ();
	_tmp4_ = _gweather_location_ref0 (_tmp3_);
	world = _tmp4_;
	_tmp5_ = world;
	_tmp6_ = parameter;
	_tmp7_ = g_variant_get_child_value (_tmp6_, (gsize) 0);
	_tmp8_ = _tmp7_;
	_tmp9_ = gweather_location_deserialize (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_variant_unref0 (_tmp8_);
	location = _tmp10_;
	_tmp11_ = location;
	if (_tmp11_ != NULL) {
		ClocksWindow* _tmp12_;
		GWeatherLocation* _tmp13_;
		_tmp12_ = self->priv->window;
		_tmp13_ = location;
		clocks_window_add_world_location (_tmp12_, _tmp13_);
	}
	_gweather_location_unref0 (location);
	_gweather_location_unref0 (world);
}


void clocks_application_send_notification (ClocksApplication* self, const gchar* notification_id, GNotification* notification) {
	const gchar* _tmp0_;
	GNotification* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification_id != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = notification_id;
	_tmp1_ = notification;
	g_application_send_notification ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp0_, _tmp1_);
	_tmp2_ = notification_id;
	_tmp3_ = g_strdup (_tmp2_);
	self->priv->system_notifications = g_list_append (self->priv->system_notifications, _tmp3_);
}


static void clocks_application_withdraw_notifications (ClocksApplication* self) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->system_notifications;
	{
		GList* notification_collection = NULL;
		GList* notification_it = NULL;
		notification_collection = _tmp0_;
		for (notification_it = notification_collection; notification_it != NULL; notification_it = notification_it->next) {
			gchar* _tmp1_;
			gchar* notification = NULL;
			_tmp1_ = g_strdup ((const gchar*) notification_it->data);
			notification = _tmp1_;
			{
				const gchar* _tmp2_;
				_tmp2_ = notification;
				g_application_withdraw_notification ((GApplication*) self, _tmp2_);
				_g_free0 (notification);
			}
		}
	}
}


static void clocks_application_real_shutdown (GApplication* base) {
	ClocksApplication * self;
	self = (ClocksApplication*) base;
	G_APPLICATION_CLASS (clocks_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	clocks_application_withdraw_notifications (self);
}


static void clocks_application_on_quit_activate (ClocksApplication* self) {
	g_return_if_fail (self != NULL);
	g_application_quit ((GApplication*) self);
}


static void clocks_application_class_init (ClocksApplicationClass * klass) {
	clocks_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksApplicationPrivate));
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication *, GDBusConnection*, const gchar*, GError**)) clocks_application_real_dbus_register;
	((GApplicationClass *) klass)->dbus_unregister = (void (*) (GApplication *, GDBusConnection*, const gchar*)) clocks_application_real_dbus_unregister;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) clocks_application_real_activate;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) clocks_application_real_startup;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) clocks_application_real_handle_local_options;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) clocks_application_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = clocks_application_finalize;
}


static void clocks_application_instance_init (ClocksApplication * self) {
	self->priv = CLOCKS_APPLICATION_GET_PRIVATE (self);
	self->priv->search_provider_id = (guint) 0;
}


static void clocks_application_finalize (GObject * obj) {
	ClocksApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_APPLICATION, ClocksApplication);
	_g_object_unref0 (self->priv->search_provider);
	_g_object_unref0 (self->priv->window);
	__g_list_free__g_free0_0 (self->priv->system_notifications);
	G_OBJECT_CLASS (clocks_application_parent_class)->finalize (obj);
}


GType clocks_application_get_type (void) {
	static volatile gsize clocks_application_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksApplication), 0, (GInstanceInitFunc) clocks_application_instance_init, NULL };
		GType clocks_application_type_id;
		clocks_application_type_id = g_type_register_static (gtk_application_get_type (), "ClocksApplication", &g_define_type_info, 0);
		g_once_init_leave (&clocks_application_type_id__volatile, clocks_application_type_id);
	}
	return clocks_application_type_id__volatile;
}



