/* MainWindow.c generated by valac 0.38.7, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbBundle.h"
#include <float.h>
#include <math.h>
#include <cairo.h>
#include "CbTweet.h"
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;
enum  {
	MAIN_WINDOW_0_PROPERTY,
	MAIN_WINDOW_CUR_PAGE_ID_PROPERTY,
	MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* main_window_properties[MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ADD_LIST_ENTRY (add_list_entry_get_type ())
#define ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_LIST_ENTRY, AddListEntry))
#define ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_LIST_ENTRY, AddListEntryClass))
#define IS_ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_LIST_ENTRY))
#define IS_ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_LIST_ENTRY))
#define ADD_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_LIST_ENTRY, AddListEntryClass))

typedef struct _AddListEntry AddListEntry;
typedef struct _AddListEntryClass AddListEntryClass;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define TYPE_USER_LIST_ENTRY (user_list_entry_get_type ())
#define USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_ENTRY, UserListEntry))
#define USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_ENTRY, UserListEntryClass))
#define IS_USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_ENTRY))
#define IS_USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_ENTRY))
#define USER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_ENTRY, UserListEntryClass))

typedef struct _UserListEntry UserListEntry;
typedef struct _UserListEntryClass UserListEntryClass;

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_PAGE (page_get_type ())

#define TYPE_ACCOUNT_CREATE_WIDGET (account_create_widget_get_type ())
#define ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidget))
#define ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))
#define IS_ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_CREATE_WIDGET))
#define IS_ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_CREATE_WIDGET))
#define ACCOUNT_CREATE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))

typedef struct _AccountCreateWidget AccountCreateWidget;
typedef struct _AccountCreateWidgetClass AccountCreateWidgetClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_ACCOUNT_DIALOG (account_dialog_get_type ())
#define ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_DIALOG, AccountDialog))
#define ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_DIALOG, AccountDialogClass))
#define IS_ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_DIALOG))
#define IS_ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_DIALOG))
#define ACCOUNT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_DIALOG, AccountDialogClass))

typedef struct _AccountDialog AccountDialog;
typedef struct _AccountDialogClass AccountDialogClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MainWindowPrivate {
	GtkHeaderBar* headerbar;
	AvatarWidget* avatar_image;
	GtkListBox* account_list;
	GtkPopover* account_popover;
	GtkBox* header_box;
	GtkToggleButton* account_button;
	GtkLabel* title_label;
	GtkLabel* last_page_label;
	GtkStack* title_stack;
	GtkMenuButton* app_menu_button;
	ComposeTweetWindow* compose_tweet_window;
	GtkGestureMultiPress* thumb_button_gesture;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	MainWindow* main_window;
	TweetListBox* tweet_list;
	Account* account;
	BadgeRadioButton* radio_button;
	guint tweet_remove_timeout;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, CbBundle* args);
	void (*on_leave) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_radio_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};


static gpointer main_window_parent_class = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
GType main_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
static void main_window_show_hide_compose_window (MainWindow* self);
static void _main_window_show_hide_compose_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void settings_toggle_topbar_visible (void);
static void _settings_toggle_topbar_visible_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_simple_switch_page (MainWindow* self, GSimpleAction* a, GVariant* param);
static void _main_window_simple_switch_page_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_show_account_dialog (MainWindow* self);
static void _main_window_show_account_dialog_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_show_account_list (MainWindow* self);
static void _main_window_show_account_list_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_previous (MainWindow* self, GSimpleAction* a, GVariant* param);
static void _main_window_previous_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_next (MainWindow* self, GSimpleAction* a, GVariant* param);
static void _main_window_next_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
MainWindow* main_window_new (GtkApplication* app, Account* account);
MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account);
static gboolean main_window_window_delete_cb (MainWindow* self, GdkEventAny* evt);
static gboolean _main_window_window_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void main_window_account_button_clicked_cb (MainWindow* self);
static void _main_window_account_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
AvatarWidget* avatar_widget_new (void);
AvatarWidget* avatar_widget_construct (GType object_type);
void avatar_widget_set_size (AvatarWidget* self, gint value);
static void main_window_back_button_clicked_cb (MainWindow* self);
static void _main_window_back_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void main_window_account_popover_closed_cb (MainWindow* self);
static void _main_window_account_popover_closed_cb_gtk_popover_closed (GtkPopover* _sender, gpointer self);
static void main_window_account_row_activated_cb (MainWindow* self, GtkListBoxRow* row);
static void _main_window_account_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
void main_window_change_account (MainWindow* self, Account* account);
static gint main_window_account_sort_func (MainWindow* self, GtkListBoxRow* a, GtkListBoxRow* b);
static gint _main_window_account_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
GType add_list_entry_get_type (void) G_GNUC_CONST;
AddListEntry* add_list_entry_new (const gchar* label);
AddListEntry* add_list_entry_construct (GType object_type, const gchar* label);
guint account_get_n (void);
Account* account_get_nth (guint index);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
#define ACCOUNT_DUMMY "screen_name"
GType user_list_entry_get_type (void) G_GNUC_CONST;
UserListEntry* user_list_entry_new_from_account (Account* acc);
UserListEntry* user_list_entry_construct_from_account (GType object_type, Account* acc);
void user_list_entry_set_show_settings (UserListEntry* self, gboolean value);
static void _____lambda179_ (MainWindow* self);
static void ______lambda179__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self);
GType corebird_get_type (void) G_GNUC_CONST;
static void __lambda180_ (MainWindow* self, Account* new_acc);
gchar* user_list_entry_get_screen_name (UserListEntry* self);
static void __lambda181_ (MainWindow* self);
static void ___lambda181__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self);
static void ___lambda180__corebird_account_added (Corebird* _sender, Account* acc, gpointer self);
static void __lambda182_ (MainWindow* self, Account* acc);
static void ___lambda182__corebird_account_removed (Corebird* _sender, Account* acc, gpointer self);
static gboolean __lambda183_ (MainWindow* self, GdkEventKey* evt);
GType ipage_get_type (void) G_GNUC_CONST;
IPage* main_widget_get_page (MainWidget* self, gint page_id);
gint main_widget_get_cur_page_id (MainWidget* self);
static gboolean ___lambda183__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void main_window_thumb_button_pressed_cb (MainWindow* self, GtkGestureMultiPress* gesture, gint n_press, gdouble x, gdouble y);
static void _main_window_thumb_button_pressed_cb_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self);
static void main_window_load_geometry (MainWindow* self);
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
static gint64* _int64_dup (gint64* self);
static void main_window_account_info_changed (MainWindow* self, const gchar* screen_name, const gchar* name, cairo_surface_t* small_avatar, cairo_surface_t* avatar);
static void _main_window_account_info_changed_account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, cairo_surface_t* avatar_small, cairo_surface_t* avatar, gpointer self);
void main_widget_stop (MainWidget* self);
MainWidget* main_widget_new (Account* account, MainWindow* parent, Corebird* app);
MainWidget* main_widget_construct (GType object_type, Account* account, MainWindow* parent, Corebird* app);
void main_window_set_window_title (MainWindow* self, const gchar* title, GtkStackTransitionType transition_type);
gchar* ipage_get_title (IPage* self);
cairo_surface_t* account_get_avatar_small (Account* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void ___lambda139_ (MainWindow* self);
static void ____lambda139__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
Account* account_new (gint64 id, const gchar* screen_name, const gchar* name);
Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name);
void account_add_account (Account* acc);
GType account_create_widget_get_type (void) G_GNUC_CONST;
AccountCreateWidget* account_create_widget_new (Account* acc, Corebird* corebird, MainWindow* main_window);
AccountCreateWidget* account_create_widget_construct (GType object_type, Account* acc, Corebird* corebird, MainWindow* main_window);
static void ___lambda142_ (MainWindow* self, gboolean _result_, Account* acc);
static void ____lambda142__account_create_widget_result_received (AccountCreateWidget* _sender, gboolean _result_, Account* acc, gpointer self);
gint64 user_list_entry_get_user_id (UserListEntry* self);
gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow* * window);
Account* account_query_account_by_id (gint64 id);
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
static void ___lambda177_ (MainWindow* self);
static void ____lambda177__gtk_widget_hide (GtkWidget* _sender, gpointer self);
static void ___lambda178_ (MainWindow* self);
static void ____lambda178__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
GType account_dialog_get_type (void) G_GNUC_CONST;
AccountDialog* account_dialog_new (Account* account);
AccountDialog* account_dialog_construct (GType object_type, Account* account);
IPage* main_window_get_page (MainWindow* self, gint page_id);
GSettings* settings_get (void);
void main_window_save_geometry (MainWindow* self);
void main_window_rerun_filters (MainWindow* self);
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
void default_timeline_rerun_filters (DefaultTimeline* self);
void main_window_reply_to_tweet (MainWindow* self, gint64 tweet_id);
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
void main_window_mark_tweet_as_read (MainWindow* self, gint64 tweet_id);
gint default_timeline_get_unread_count (DefaultTimeline* self);
void default_timeline_set_unread_count (DefaultTimeline* self, gint value);
gint main_window_get_cur_page_id (MainWindow* self);
static void main_window_finalize (GObject * obj);
static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry MAIN_WINDOW_win_entries[7] = {{"compose-tweet", _main_window_show_hide_compose_window_gsimple_action_activate_callback}, {"toggle-topbar", _settings_toggle_topbar_visible_gsimple_action_activate_callback}, {"switch-page", _main_window_simple_switch_page_gsimple_action_activate_callback, "i"}, {"show-account-dialog", _main_window_show_account_dialog_gsimple_action_activate_callback}, {"show-account-list", _main_window_show_account_list_gsimple_action_activate_callback}, {"previous", _main_window_previous_gsimple_action_activate_callback}, {"next", _main_window_next_gsimple_action_activate_callback}};

static void _main_window_show_hide_compose_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_show_hide_compose_window ((MainWindow*) self);
}


static void _settings_toggle_topbar_visible_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	settings_toggle_topbar_visible ();
}


static void _main_window_simple_switch_page_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_simple_switch_page ((MainWindow*) self, action, parameter);
}


static void _main_window_show_account_dialog_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_show_account_dialog ((MainWindow*) self);
}


static void _main_window_show_account_list_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_show_account_list ((MainWindow*) self);
}


static void _main_window_previous_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_previous ((MainWindow*) self, action, parameter);
}


static void _main_window_next_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_next ((MainWindow*) self, action, parameter);
}


static gboolean _main_window_window_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = main_window_window_delete_cb ((MainWindow*) self, event);
	return result;
}


static void _main_window_account_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	main_window_account_button_clicked_cb ((MainWindow*) self);
}


static void _main_window_back_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	main_window_back_button_clicked_cb ((MainWindow*) self);
}


static void _main_window_account_popover_closed_cb_gtk_popover_closed (GtkPopover* _sender, gpointer self) {
	main_window_account_popover_closed_cb ((MainWindow*) self);
}


static void _main_window_account_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	main_window_account_row_activated_cb ((MainWindow*) self, row);
}


static gint _main_window_account_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = main_window_account_sort_func ((MainWindow*) self, row1, row2);
	return result;
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static void _____lambda179_ (MainWindow* self) {
	GtkPopover* _tmp0_;
	_tmp0_ = self->priv->account_popover;
	gtk_popover_popdown (_tmp0_);
}


static void ______lambda179__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self) {
	_____lambda179_ ((MainWindow*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda181_ (MainWindow* self) {
	GtkPopover* _tmp0_;
	_tmp0_ = self->priv->account_popover;
	gtk_popover_popdown (_tmp0_);
}


static void ___lambda181__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self) {
	__lambda181_ ((MainWindow*) self);
}


static void __lambda180_ (MainWindow* self, Account* new_acc) {
	GList* entries = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	UserListEntry* ule = NULL;
	Account* _tmp12_;
	UserListEntry* _tmp13_;
	UserListEntry* _tmp14_;
	UserListEntry* _tmp15_;
	GtkListBox* _tmp16_;
	UserListEntry* _tmp17_;
	UserListEntry* _tmp18_;
	g_return_if_fail (IS_ACCOUNT (new_acc));
	_tmp0_ = self->priv->account_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	entries = _tmp1_;
	_tmp2_ = entries;
	{
		GList* ule_collection = NULL;
		GList* ule_it = NULL;
		ule_collection = _tmp2_;
		for (ule_it = ule_collection; ule_it != NULL; ule_it = ule_it->next) {
			GtkWidget* _tmp3_;
			GtkWidget* ule = NULL;
			_tmp3_ = _g_object_ref0 ((GtkWidget*) ule_it->data);
			ule = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				GtkWidget* _tmp5_;
				_tmp5_ = ule;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_USER_LIST_ENTRY)) {
					Account* _tmp6_;
					const gchar* _tmp7_;
					GtkWidget* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp6_ = new_acc;
					_tmp7_ = _tmp6_->screen_name;
					_tmp8_ = ule;
					_tmp9_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_USER_LIST_ENTRY, UserListEntry));
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_;
					_tmp4_ = g_strcmp0 (_tmp7_, _tmp11_) == 0;
					_g_free0 (_tmp11_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					_g_object_unref0 (ule);
					_g_list_free0 (entries);
					return;
				}
				_g_object_unref0 (ule);
			}
		}
	}
	_tmp12_ = new_acc;
	_tmp13_ = user_list_entry_new_from_account (_tmp12_);
	g_object_ref_sink (_tmp13_);
	ule = _tmp13_;
	_tmp14_ = ule;
	user_list_entry_set_show_settings (_tmp14_, TRUE);
	_tmp15_ = ule;
	g_signal_connect_object (_tmp15_, "action-clicked", (GCallback) ___lambda181__user_list_entry_action_clicked, self, 0);
	_tmp16_ = self->priv->account_list;
	_tmp17_ = ule;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = ule;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ule);
	_g_list_free0 (entries);
}


static void ___lambda180__corebird_account_added (Corebird* _sender, Account* acc, gpointer self) {
	__lambda180_ ((MainWindow*) self, acc);
}


static void __lambda182_ (MainWindow* self, Account* acc) {
	GList* entries = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (IS_ACCOUNT (acc));
	_tmp0_ = self->priv->account_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	entries = _tmp1_;
	_tmp2_ = entries;
	{
		GList* ule_collection = NULL;
		GList* ule_it = NULL;
		ule_collection = _tmp2_;
		for (ule_it = ule_collection; ule_it != NULL; ule_it = ule_it->next) {
			GtkWidget* _tmp3_;
			GtkWidget* ule = NULL;
			_tmp3_ = _g_object_ref0 ((GtkWidget*) ule_it->data);
			ule = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				GtkWidget* _tmp5_;
				_tmp5_ = ule;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_USER_LIST_ENTRY)) {
					Account* _tmp6_;
					const gchar* _tmp7_;
					GtkWidget* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp6_ = acc;
					_tmp7_ = _tmp6_->screen_name;
					_tmp8_ = ule;
					_tmp9_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_USER_LIST_ENTRY, UserListEntry));
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_;
					_tmp4_ = g_strcmp0 (_tmp7_, _tmp11_) == 0;
					_g_free0 (_tmp11_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GtkListBox* _tmp12_;
					GtkWidget* _tmp13_;
					_tmp12_ = self->priv->account_list;
					_tmp13_ = ule;
					gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_container_get_type (), GtkContainer), _tmp13_);
					_g_object_unref0 (ule);
					break;
				}
				_g_object_unref0 (ule);
			}
		}
	}
	_g_list_free0 (entries);
}


static void ___lambda182__corebird_account_removed (Corebird* _sender, Account* acc, gpointer self) {
	__lambda182_ ((MainWindow*) self, acc);
}


static gboolean __lambda183_ (MainWindow* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Down)) {
		MainWidget* _tmp3_;
		_tmp3_ = self->main_widget;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MainWidget* _tmp4_;
		MainWidget* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		IPage* _tmp8_;
		IPage* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp4_ = self->main_widget;
		_tmp5_ = self->main_widget;
		_tmp6_ = main_widget_get_cur_page_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = main_widget_get_page (_tmp4_, _tmp7_);
		_tmp9_ = _tmp8_;
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), "focus", GTK_DIR_RIGHT, &_tmp10_);
		_g_object_unref0 (_tmp9_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda183__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = __lambda183_ ((MainWindow*) self, event);
	return result;
}


static void _main_window_thumb_button_pressed_cb_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self) {
	main_window_thumb_button_pressed_cb ((MainWindow*) self, _sender, p0, p1, p2);
}


MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account) {
	MainWindow * self = NULL;
	GtkWindowGroup* group = NULL;
	GtkWindowGroup* _tmp0_;
	GtkWindowGroup* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkHeaderBar* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GtkStack* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkStack* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkStack* _tmp16_;
	GtkLabel* _tmp17_;
	GtkHeaderBar* _tmp18_;
	GtkStack* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GtkToggleButton* _tmp22_;
	GtkToggleButton* _tmp23_;
	GtkToggleButton* _tmp24_;
	GtkToggleButton* _tmp25_;
	GtkStyleContext* _tmp26_;
	AvatarWidget* _tmp27_;
	AvatarWidget* _tmp28_;
	AvatarWidget* _tmp29_;
	GtkToggleButton* _tmp30_;
	AvatarWidget* _tmp31_;
	GtkToggleButton* _tmp32_;
	GtkBox* _tmp33_;
	GtkToggleButton* _tmp34_;
	GtkToggleButton* _tmp35_;
	GtkToggleButton* _tmp36_;
	GtkImage* _tmp37_;
	GtkImage* _tmp38_;
	GtkToggleButton* _tmp39_;
	GtkToggleButton* _tmp40_;
	GtkToggleButton* _tmp41_;
	GtkStyleContext* _tmp42_;
	GtkToggleButton* _tmp43_;
	GtkBox* _tmp44_;
	GtkToggleButton* _tmp45_;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* _tmp48_;
	GtkBox* _tmp49_;
	GtkButton* _tmp50_;
	GtkBox* _tmp51_;
	GtkHeaderBar* _tmp52_;
	GtkBox* _tmp53_;
	GtkHeaderBar* _tmp54_;
	GtkHeaderBar* _tmp55_;
	GtkToggleButton* _tmp56_;
	GtkPopover* _tmp57_;
	GtkPopover* _tmp58_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp59_;
	GtkFrame* _tmp60_;
	GtkFrame* _tmp61_;
	GtkFrame* _tmp62_;
	GtkFrame* _tmp63_;
	GtkListBox* _tmp64_;
	GtkListBox* _tmp65_;
	GtkListBox* _tmp66_;
	GtkFrame* _tmp67_;
	GtkListBox* _tmp68_;
	GtkPopover* _tmp69_;
	GtkFrame* _tmp70_;
	GtkPopover* _tmp71_;
	Account* _tmp72_;
	GtkListBox* _tmp73_;
	GtkListBox* _tmp74_;
	AddListEntry* add_entry = NULL;
	AddListEntry* _tmp75_;
	AddListEntry* _tmp76_;
	GtkListBox* _tmp77_;
	AddListEntry* _tmp78_;
	GtkApplication* _tmp93_;
	GtkApplication* _tmp94_;
	GtkHeaderBar* _tmp95_;
	GtkGestureMultiPress* _tmp96_;
	GtkGestureMultiPress* _tmp97_;
	GtkGestureMultiPress* _tmp98_;
	GtkGestureMultiPress* _tmp99_;
	g_return_val_if_fail (GTK_IS_APPLICATION (app), NULL);
	g_return_val_if_fail ((account == NULL) || IS_ACCOUNT (account), NULL);
	self = (MainWindow*) g_object_new (object_type, NULL);
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 530, 700);
	_tmp0_ = gtk_window_group_new ();
	group = _tmp0_;
	_tmp1_ = group;
	gtk_window_group_add_window (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	gtk_application_window_set_show_menubar (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), FALSE);
	gtk_window_set_icon_name (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), "corebird");
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) _main_window_window_delete_cb_gtk_widget_delete_event, self, 0);
	_tmp2_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp2_;
	_tmp3_ = self->priv->headerbar;
	gtk_header_bar_set_title (_tmp3_, "Corebird");
	_tmp4_ = self->priv->headerbar;
	gtk_header_bar_set_show_close_button (_tmp4_, TRUE);
	_tmp5_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->title_stack);
	self->priv->title_stack = _tmp5_;
	_tmp6_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp6_;
	_tmp7_ = self->priv->title_label;
	gtk_label_set_ellipsize (_tmp7_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp8_ = self->priv->title_label;
	_tmp9_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp9_, "title");
	_tmp10_ = self->priv->title_stack;
	_tmp11_ = self->priv->title_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_tmp12_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->last_page_label);
	self->priv->last_page_label = _tmp12_;
	_tmp13_ = self->priv->last_page_label;
	gtk_label_set_ellipsize (_tmp13_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp14_ = self->priv->last_page_label;
	_tmp15_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp15_, "title");
	_tmp16_ = self->priv->title_stack;
	_tmp17_ = self->priv->last_page_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = self->priv->headerbar;
	_tmp19_ = self->priv->title_stack;
	gtk_header_bar_set_custom_title (_tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->header_box);
	self->priv->header_box = _tmp20_;
	_tmp21_ = self->priv->header_box;
	gtk_widget_set_no_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp22_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->account_button);
	self->priv->account_button = _tmp22_;
	_tmp23_ = self->priv->account_button;
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), _ ("Show configured accounts"));
	_tmp24_ = self->priv->account_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _main_window_account_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp25_ = self->priv->account_button;
	_tmp26_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp26_, "account-button");
	_tmp27_ = avatar_widget_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->avatar_image);
	self->priv->avatar_image = _tmp27_;
	_tmp28_ = self->priv->avatar_image;
	avatar_widget_set_size (_tmp28_, 24);
	_tmp29_ = self->priv->avatar_image;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp30_ = self->priv->account_button;
	_tmp31_ = self->priv->avatar_image;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget));
	_tmp32_ = self->priv->account_button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget));
	_tmp33_ = self->priv->header_box;
	_tmp34_ = self->priv->account_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
	_tmp35_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->compose_tweet_button);
	self->compose_tweet_button = _tmp35_;
	_tmp36_ = self->compose_tweet_button;
	_tmp37_ = (GtkImage*) gtk_image_new_from_icon_name ("corebird-compose-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp37_);
	_tmp38_ = _tmp37_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp38_);
	_tmp39_ = self->compose_tweet_button;
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget), _ ("Compose Tweet"));
	_tmp40_ = self->compose_tweet_button;
	gtk_actionable_set_action_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GTK_TYPE_ACTIONABLE, GtkActionable), "win.compose-tweet");
	_tmp41_ = self->compose_tweet_button;
	_tmp42_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp42_, "image-button");
	_tmp43_ = self->compose_tweet_button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget));
	_tmp44_ = self->priv->header_box;
	_tmp45_ = self->compose_tweet_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget));
	_tmp46_ = (GtkButton*) gtk_button_new_from_icon_name ("go-previous-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->back_button);
	self->back_button = _tmp46_;
	_tmp47_ = self->back_button;
	g_signal_connect_object (_tmp47_, "clicked", (GCallback) _main_window_back_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp48_ = self->back_button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget));
	_tmp49_ = self->priv->header_box;
	_tmp50_ = self->back_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_widget_get_type (), GtkWidget));
	_tmp51_ = self->priv->header_box;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_widget_get_type (), GtkWidget));
	_tmp52_ = self->priv->headerbar;
	_tmp53_ = self->priv->header_box;
	gtk_header_bar_pack_start (_tmp52_, G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget));
	_tmp54_ = self->priv->headerbar;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget));
	_tmp55_ = self->priv->headerbar;
	gtk_window_set_titlebar (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_widget_get_type (), GtkWidget));
	_tmp56_ = self->priv->account_button;
	_tmp57_ = (GtkPopover*) gtk_popover_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_widget_get_type (), GtkWidget));
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->account_popover);
	self->priv->account_popover = _tmp57_;
	_tmp58_ = self->priv->account_popover;
	g_signal_connect_object (_tmp58_, "closed", (GCallback) _main_window_account_popover_closed_cb_gtk_popover_closed, self, 0);
	_tmp59_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp59_);
	frame = _tmp59_;
	_tmp60_ = frame;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp61_ = frame;
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp62_ = frame;
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp63_ = frame;
	gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp64_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (self->priv->account_list);
	self->priv->account_list = _tmp64_;
	_tmp65_ = self->priv->account_list;
	gtk_list_box_set_selection_mode (_tmp65_, GTK_SELECTION_NONE);
	_tmp66_ = self->priv->account_list;
	g_signal_connect_object (_tmp66_, "row-activated", (GCallback) _main_window_account_row_activated_cb_gtk_list_box_row_activated, self, 0);
	_tmp67_ = frame;
	_tmp68_ = self->priv->account_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_widget_get_type (), GtkWidget));
	_tmp69_ = self->priv->account_popover;
	_tmp70_ = frame;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, gtk_widget_get_type (), GtkWidget));
	_tmp71_ = self->priv->account_popover;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_widget_get_type (), GtkWidget));
	_tmp72_ = account;
	main_window_change_account (self, _tmp72_);
	_tmp73_ = self->priv->account_list;
	gtk_list_box_set_sort_func (_tmp73_, _main_window_account_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp74_ = self->priv->account_list;
	gtk_list_box_set_header_func (_tmp74_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp75_ = add_list_entry_new (_ ("Add new Account"));
	g_object_ref_sink (_tmp75_);
	add_entry = _tmp75_;
	_tmp76_ = add_entry;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, gtk_widget_get_type (), GtkWidget));
	_tmp77_ = self->priv->account_list;
	_tmp78_ = add_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_widget_get_type (), GtkWidget));
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp79_ = FALSE;
			_tmp79_ = TRUE;
			while (TRUE) {
				guint _tmp81_;
				guint _tmp82_;
				Account* acc = NULL;
				guint _tmp83_;
				Account* _tmp84_;
				Account* _tmp85_;
				const gchar* _tmp86_;
				UserListEntry* e = NULL;
				Account* _tmp87_;
				UserListEntry* _tmp88_;
				UserListEntry* _tmp89_;
				UserListEntry* _tmp90_;
				GtkListBox* _tmp91_;
				UserListEntry* _tmp92_;
				if (!_tmp79_) {
					guint _tmp80_;
					_tmp80_ = i;
					i = _tmp80_ + 1;
				}
				_tmp79_ = FALSE;
				_tmp81_ = i;
				_tmp82_ = account_get_n ();
				if (!(_tmp81_ < _tmp82_)) {
					break;
				}
				_tmp83_ = i;
				_tmp84_ = account_get_nth (_tmp83_);
				acc = _tmp84_;
				_tmp85_ = acc;
				_tmp86_ = _tmp85_->screen_name;
				if (g_strcmp0 (_tmp86_, ACCOUNT_DUMMY) == 0) {
					_g_object_unref0 (acc);
					continue;
				}
				_tmp87_ = acc;
				_tmp88_ = user_list_entry_new_from_account (_tmp87_);
				g_object_ref_sink (_tmp88_);
				e = _tmp88_;
				_tmp89_ = e;
				user_list_entry_set_show_settings (_tmp89_, TRUE);
				_tmp90_ = e;
				g_signal_connect_object (_tmp90_, "action-clicked", (GCallback) ______lambda179__user_list_entry_action_clicked, self, 0);
				_tmp91_ = self->priv->account_list;
				_tmp92_ = e;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (e);
				_g_object_unref0 (acc);
			}
		}
	}
	_tmp93_ = app;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, TYPE_COREBIRD, Corebird), "account-added", (GCallback) ___lambda180__corebird_account_added, self, 0);
	_tmp94_ = app;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, TYPE_COREBIRD, Corebird), "account-removed", (GCallback) ___lambda182__corebird_account_removed, self, 0);
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), MAIN_WINDOW_win_entries, G_N_ELEMENTS (MAIN_WINDOW_win_entries), self);
	_tmp95_ = self->priv->headerbar;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) ___lambda183__gtk_widget_key_press_event, self, 0);
	_tmp96_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->thumb_button_gesture);
	self->priv->thumb_button_gesture = _tmp96_;
	_tmp97_ = self->priv->thumb_button_gesture;
	gtk_gesture_single_set_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, gtk_gesture_single_get_type (), GtkGestureSingle), (guint) 0);
	_tmp98_ = self->priv->thumb_button_gesture;
	gtk_event_controller_set_propagation_phase (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, gtk_event_controller_get_type (), GtkEventController), GTK_PHASE_CAPTURE);
	_tmp99_ = self->priv->thumb_button_gesture;
	g_signal_connect_object (_tmp99_, "pressed", (GCallback) _main_window_thumb_button_pressed_cb_gtk_gesture_multi_press_pressed, self, 0);
	main_window_load_geometry (self);
	_g_object_unref0 (add_entry);
	_g_object_unref0 (frame);
	_g_object_unref0 (group);
	return self;
}


MainWindow* main_window_new (GtkApplication* app, Account* account) {
	return main_window_construct (TYPE_MAIN_WINDOW, app, account);
}


static void main_window_back_button_clicked_cb (MainWindow* self) {
	MainWidget* _tmp0_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->main_widget;
	main_widget_switch_page (_tmp0_, (gint) PAGE_PREVIOUS, NULL);
}


static gint64* _int64_dup (gint64* self) {
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}


static gpointer __int64_dup0 (gpointer self) {
	return self ? _int64_dup (self) : NULL;
}


static void _main_window_account_info_changed_account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, cairo_surface_t* avatar_small, cairo_surface_t* avatar, gpointer self) {
	main_window_account_info_changed ((MainWindow*) self, screen_name, name, avatar_small, avatar);
}


static void ___lambda139_ (MainWindow* self) {
	AvatarWidget* _tmp0_;
	Account* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = self->account;
	_tmp2_ = account_get_avatar_small (_tmp1_);
	_tmp3_ = _tmp2_;
	avatar_widget_set_surface (_tmp0_, _tmp3_);
}


static void ____lambda139__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda139_ ((MainWindow*) self);
}


static void ___lambda142_ (MainWindow* self, gboolean _result_, Account* acc) {
	gboolean _tmp0_;
	g_return_if_fail (IS_ACCOUNT (acc));
	_tmp0_ = _result_;
	if (_tmp0_) {
		Account* _tmp1_;
		_tmp1_ = acc;
		main_window_change_account (self, _tmp1_);
	} else {
	}
}


static void ____lambda142__account_create_widget_result_received (AccountCreateWidget* _sender, gboolean _result_, Account* acc, gpointer self) {
	___lambda142_ ((MainWindow*) self, _result_, acc);
}


void main_window_change_account (MainWindow* self, Account* account) {
	gint64* old_user_id = NULL;
	Account* _tmp0_;
	Account* _tmp6_;
	MainWidget* _tmp7_;
	GtkWidget* _tmp9_;
	Corebird* cb = NULL;
	GApplication* _tmp11_;
	Corebird* _tmp12_;
	gboolean _tmp13_ = FALSE;
	Account* _tmp14_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail ((account == NULL) || IS_ACCOUNT (account));
	old_user_id = NULL;
	_tmp0_ = self->account;
	if (_tmp0_ != NULL) {
		Account* _tmp1_;
		gint64 _tmp2_;
		gint64* _tmp3_;
		Account* _tmp4_;
		guint _tmp5_;
		_tmp1_ = self->account;
		_tmp2_ = _tmp1_->id;
		_tmp3_ = __int64_dup0 (&_tmp2_);
		_g_free0 (old_user_id);
		old_user_id = _tmp3_;
		_tmp4_ = self->account;
		g_signal_parse_name ("info-changed", TYPE_ACCOUNT, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _main_window_account_info_changed_account_info_changed, self);
	}
	_tmp6_ = account;
	self->account = _tmp6_;
	_tmp7_ = self->main_widget;
	if (_tmp7_ != NULL) {
		MainWidget* _tmp8_;
		_tmp8_ = self->main_widget;
		main_widget_stop (_tmp8_);
	}
	_tmp9_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin));
	if (_tmp9_ != NULL) {
		GtkWidget* _tmp10_;
		_tmp10_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin));
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp10_);
	}
	_tmp11_ = g_application_get_default ();
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_COREBIRD, Corebird));
	cb = _tmp12_;
	_tmp14_ = account;
	if (_tmp14_ != NULL) {
		Account* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = account;
		_tmp16_ = _tmp15_->screen_name;
		_tmp13_ = g_strcmp0 (_tmp16_, ACCOUNT_DUMMY) != 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GtkBox* _tmp17_;
		Account* _tmp18_;
		Corebird* _tmp19_;
		MainWidget* _tmp20_;
		MainWidget* _tmp21_;
		MainWidget* _tmp22_;
		MainWidget* _tmp23_;
		MainWidget* _tmp24_;
		IPage* _tmp25_;
		IPage* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		AvatarWidget* _tmp29_;
		Account* _tmp30_;
		cairo_surface_t* _tmp31_;
		cairo_surface_t* _tmp32_;
		Account* _tmp33_;
		Account* _tmp34_;
		Account* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		Corebird* _tmp39_;
		gint64* _tmp40_;
		Account* _tmp41_;
		gint64 _tmp42_;
		GtkSettings* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp17_ = self->priv->header_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
		_tmp18_ = account;
		_tmp19_ = cb;
		_tmp20_ = main_widget_new (_tmp18_, self, _tmp19_);
		g_object_ref_sink (_tmp20_);
		_g_object_unref0 (self->main_widget);
		self->main_widget = _tmp20_;
		_tmp21_ = self->main_widget;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
		_tmp22_ = self->main_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
		_tmp23_ = self->main_widget;
		main_widget_switch_page (_tmp23_, 0, NULL);
		_tmp24_ = self->main_widget;
		_tmp25_ = main_widget_get_page (_tmp24_, 0);
		_tmp26_ = _tmp25_;
		_tmp27_ = ipage_get_title (_tmp26_);
		_tmp28_ = _tmp27_;
		main_window_set_window_title (self, _tmp28_, GTK_STACK_TRANSITION_TYPE_NONE);
		_g_free0 (_tmp28_);
		_g_object_unref0 (_tmp26_);
		_tmp29_ = self->priv->avatar_image;
		_tmp30_ = account;
		_tmp31_ = account_get_avatar_small (_tmp30_);
		_tmp32_ = _tmp31_;
		avatar_widget_set_surface (_tmp29_, _tmp32_);
		_tmp33_ = account;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, G_TYPE_OBJECT, GObject), "notify::avatar-small", (GCallback) ____lambda139__g_object_notify, self, 0);
		_tmp34_ = account;
		g_signal_connect_object (_tmp34_, "info-changed", (GCallback) _main_window_account_info_changed_account_info_changed, self, 0);
		_tmp35_ = account;
		_tmp36_ = _tmp35_->screen_name;
		_tmp37_ = g_strdup_printf ("Corebird - @%s", _tmp36_);
		_tmp38_ = _tmp37_;
		gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp38_);
		_g_free0 (_tmp38_);
		_tmp39_ = cb;
		_tmp40_ = old_user_id;
		_tmp41_ = account;
		_tmp42_ = _tmp41_->id;
		g_signal_emit_by_name (_tmp39_, "account-window-changed", _tmp40_, _tmp42_);
		_tmp43_ = gtk_settings_get_default ();
		g_object_get (_tmp43_, "gtk-shell-shows-app-menu", &_tmp44_, NULL);
		_tmp45_ = _tmp44_;
		if (!_tmp45_) {
			GtkMenuButton* _tmp46_;
			_tmp46_ = self->priv->app_menu_button;
			if (_tmp46_ == NULL) {
				GtkMenuButton* _tmp47_;
				GtkMenuButton* _tmp48_;
				GtkImage* _tmp49_;
				GtkImage* _tmp50_;
				GtkMenuButton* _tmp51_;
				GtkStyleContext* _tmp52_;
				GtkMenuButton* _tmp53_;
				Corebird* _tmp54_;
				GMenuModel* _tmp55_;
				GMenuModel* _tmp56_;
				GtkMenuButton* _tmp57_;
				GtkHeaderBar* _tmp58_;
				GtkMenuButton* _tmp59_;
				_tmp47_ = (GtkMenuButton*) gtk_menu_button_new ();
				g_object_ref_sink (_tmp47_);
				_g_object_unref0 (self->priv->app_menu_button);
				self->priv->app_menu_button = _tmp47_;
				_tmp48_ = self->priv->app_menu_button;
				_tmp49_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-system-symbolic", GTK_ICON_SIZE_MENU);
				g_object_ref_sink (_tmp49_);
				_tmp50_ = _tmp49_;
				gtk_button_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_button_get_type (), GtkButton), G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (_tmp50_);
				_tmp51_ = self->priv->app_menu_button;
				_tmp52_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_widget_get_type (), GtkWidget));
				gtk_style_context_add_class (_tmp52_, "image-button");
				_tmp53_ = self->priv->app_menu_button;
				_tmp54_ = cb;
				_tmp55_ = gtk_application_get_app_menu (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_application_get_type (), GtkApplication));
				_tmp56_ = _tmp55_;
				gtk_menu_button_set_menu_model (_tmp53_, _tmp56_);
				_tmp57_ = self->priv->app_menu_button;
				gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget));
				_tmp58_ = self->priv->headerbar;
				_tmp59_ = self->priv->app_menu_button;
				gtk_header_bar_pack_end (_tmp58_, G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget));
			} else {
				GtkMenuButton* _tmp60_;
				_tmp60_ = self->priv->app_menu_button;
				gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget));
			}
		}
	} else {
		GtkBox* _tmp61_;
		GtkMenuButton* _tmp62_;
		Account* acc_ = NULL;
		Account* _tmp64_;
		Account* _tmp68_;
		GtkLabel* _tmp69_;
		Account* _tmp70_;
		AccountCreateWidget* create_widget = NULL;
		Account* _tmp71_;
		Corebird* _tmp72_;
		AccountCreateWidget* _tmp73_;
		AccountCreateWidget* _tmp74_;
		AccountCreateWidget* _tmp75_;
		_tmp61_ = self->priv->header_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_widget_get_type (), GtkWidget));
		_tmp62_ = self->priv->app_menu_button;
		if (_tmp62_ != NULL) {
			GtkMenuButton* _tmp63_;
			_tmp63_ = self->priv->app_menu_button;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget));
		}
		_tmp64_ = account;
		if (_tmp64_ == NULL) {
			Account* _tmp65_;
			_tmp65_ = account_new ((gint64) 0, ACCOUNT_DUMMY, "name");
			_g_object_unref0 (acc_);
			acc_ = _tmp65_;
		} else {
			Account* _tmp66_;
			Account* _tmp67_;
			_tmp66_ = account;
			_tmp67_ = _g_object_ref0 (_tmp66_);
			_g_object_unref0 (acc_);
			acc_ = _tmp67_;
		}
		_tmp68_ = acc_;
		self->account = _tmp68_;
		_tmp69_ = self->priv->title_label;
		gtk_label_set_label (_tmp69_, "Corebird");
		gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), "Corebird");
		_tmp70_ = acc_;
		account_add_account (_tmp70_);
		_tmp71_ = acc_;
		_tmp72_ = cb;
		_tmp73_ = account_create_widget_new (_tmp71_, _tmp72_, self);
		g_object_ref_sink (_tmp73_);
		create_widget = _tmp73_;
		_tmp74_ = create_widget;
		g_signal_connect_object (_tmp74_, "result-received", (GCallback) ____lambda142__account_create_widget_result_received, self, 0);
		_tmp75_ = create_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (create_widget);
		_g_object_unref0 (acc_);
	}
	_g_object_unref0 (cb);
	_g_free0 (old_user_id);
}


static void main_window_account_row_activated_cb (MainWindow* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_;
	UserListEntry* e = NULL;
	GtkListBoxRow* _tmp10_;
	UserListEntry* _tmp11_;
	gint64 user_id = 0LL;
	UserListEntry* _tmp12_;
	gint64 _tmp13_;
	gint64 _tmp14_;
	Corebird* cb = NULL;
	GtkApplication* _tmp15_;
	Corebird* _tmp16_;
	MainWindow* account_window = NULL;
	gboolean _tmp17_ = FALSE;
	gint64 _tmp18_;
	Account* _tmp19_;
	gint64 _tmp20_;
	Account* acc = NULL;
	gint64 _tmp28_;
	Account* _tmp29_;
	Account* _tmp30_;
	Account* _tmp31_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_ADD_LIST_ENTRY)) {
		GtkPopover* _tmp1_;
		Account* dummy_acc = NULL;
		Account* _tmp2_;
		MainWindow* window = NULL;
		GtkApplication* _tmp3_;
		GtkApplication* _tmp4_;
		Account* _tmp5_;
		MainWindow* _tmp6_;
		GtkApplication* _tmp7_;
		MainWindow* _tmp8_;
		MainWindow* _tmp9_;
		_tmp1_ = self->priv->account_popover;
		gtk_popover_popdown (_tmp1_);
		_tmp2_ = account_new ((gint64) 0, ACCOUNT_DUMMY, "name");
		dummy_acc = _tmp2_;
		_tmp3_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_tmp4_ = _tmp3_;
		_tmp5_ = dummy_acc;
		_tmp6_ = main_window_new (_tmp4_, _tmp5_);
		g_object_ref_sink (_tmp6_);
		window = _tmp6_;
		_tmp7_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_tmp8_ = window;
		gtk_application_add_window (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow));
		_tmp9_ = window;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (window);
		_g_object_unref0 (dummy_acc);
		return;
	}
	_tmp10_ = row;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_USER_LIST_ENTRY, UserListEntry));
	e = _tmp11_;
	_tmp12_ = e;
	_tmp13_ = user_list_entry_get_user_id (_tmp12_);
	_tmp14_ = _tmp13_;
	user_id = _tmp14_;
	_tmp15_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_COREBIRD, Corebird));
	cb = _tmp16_;
	account_window = NULL;
	_tmp18_ = user_id;
	_tmp19_ = self->account;
	_tmp20_ = _tmp19_->id;
	if (_tmp18_ == _tmp20_) {
		_tmp17_ = TRUE;
	} else {
		Corebird* _tmp21_;
		gint64 _tmp22_;
		MainWindow* _tmp23_ = NULL;
		gboolean _tmp24_;
		_tmp21_ = cb;
		_tmp22_ = user_id;
		_tmp24_ = corebird_is_window_open_for_user_id (_tmp21_, _tmp22_, &_tmp23_);
		_g_object_unref0 (account_window);
		account_window = _tmp23_;
		_tmp17_ = _tmp24_;
	}
	if (_tmp17_) {
		GtkPopover* _tmp25_;
		MainWindow* _tmp26_;
		_tmp25_ = self->priv->account_popover;
		gtk_popover_popdown (_tmp25_);
		_tmp26_ = account_window;
		if (_tmp26_ != NULL) {
			MainWindow* _tmp27_;
			_tmp27_ = account_window;
			gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_window_get_type (), GtkWindow));
		}
		_g_object_unref0 (account_window);
		_g_object_unref0 (cb);
		_g_object_unref0 (e);
		return;
	}
	_tmp28_ = user_id;
	_tmp29_ = account_query_account_by_id (_tmp28_);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	acc = _tmp30_;
	_tmp31_ = acc;
	if (_tmp31_ != NULL) {
		Account* _tmp32_;
		GtkPopover* _tmp33_;
		_tmp32_ = acc;
		main_window_change_account (self, _tmp32_);
		_tmp33_ = self->priv->account_popover;
		gtk_popover_popdown (_tmp33_);
	} else {
		g_warning ("MainWindow.vala:323: account == null");
	}
	_g_object_unref0 (acc);
	_g_object_unref0 (account_window);
	_g_object_unref0 (cb);
	_g_object_unref0 (e);
}


static void main_window_thumb_button_pressed_cb (MainWindow* self, GtkGestureMultiPress* gesture, gint n_press, gdouble x, gdouble y) {
	guint button = 0U;
	GtkGestureMultiPress* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (GTK_IS_GESTURE_MULTI_PRESS (gesture));
	_tmp0_ = gesture;
	_tmp1_ = gtk_gesture_single_get_current_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_gesture_single_get_type (), GtkGestureSingle));
	button = _tmp1_;
	_tmp2_ = button;
	if (_tmp2_ == ((guint) 9)) {
		MainWidget* _tmp3_;
		GtkGestureMultiPress* _tmp4_;
		_tmp3_ = self->main_widget;
		main_widget_switch_page (_tmp3_, (gint) PAGE_NEXT, NULL);
		_tmp4_ = gesture;
		gtk_gesture_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_gesture_get_type (), GtkGesture), GTK_EVENT_SEQUENCE_CLAIMED);
	} else {
		guint _tmp5_;
		_tmp5_ = button;
		if (_tmp5_ == ((guint) 8)) {
			MainWidget* _tmp6_;
			GtkGestureMultiPress* _tmp7_;
			_tmp6_ = self->main_widget;
			main_widget_switch_page (_tmp6_, (gint) PAGE_PREVIOUS, NULL);
			_tmp7_ = gesture;
			gtk_gesture_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_gesture_get_type (), GtkGesture), GTK_EVENT_SEQUENCE_CLAIMED);
		}
	}
}


static void ___lambda177_ (MainWindow* self) {
	GtkToggleButton* _tmp0_;
	_tmp0_ = self->compose_tweet_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
}


static void ____lambda177__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	___lambda177_ ((MainWindow*) self);
}


static void ___lambda178_ (MainWindow* self) {
	_g_object_unref0 (self->priv->compose_tweet_window);
	self->priv->compose_tweet_window = NULL;
}


static void ____lambda178__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	___lambda178_ ((MainWindow*) self);
}


static void main_window_show_hide_compose_window (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_;
	ComposeTweetWindow* _tmp4_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->account;
		_tmp3_ = _tmp2_->screen_name;
		_tmp0_ = g_strcmp0 (_tmp3_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->compose_tweet_window;
	if (_tmp4_ == NULL) {
		Account* _tmp5_;
		ComposeTweetWindow* _tmp6_;
		ComposeTweetWindow* _tmp7_;
		ComposeTweetWindow* _tmp8_;
		ComposeTweetWindow* _tmp9_;
		_tmp5_ = self->account;
		_tmp6_ = compose_tweet_window_new (self, _tmp5_, NULL, COMPOSE_TWEET_WINDOW_MODE_NORMAL);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->compose_tweet_window);
		self->priv->compose_tweet_window = _tmp6_;
		_tmp7_ = self->priv->compose_tweet_window;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_tmp8_ = self->priv->compose_tweet_window;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), "hide", (GCallback) ____lambda177__gtk_widget_hide, self, 0);
		_tmp9_ = self->priv->compose_tweet_window;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), "destroy", (GCallback) ____lambda178__gtk_widget_destroy, self, 0);
	} else {
		ComposeTweetWindow* _tmp10_;
		ComposeTweetWindow* _tmp11_;
		_tmp10_ = self->priv->compose_tweet_window;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_tmp11_ = self->priv->compose_tweet_window;
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	}
}


/**
   * GSimpleActionActivateCallback version of switch_page, used
   * for keyboard accelerators.
   */
static void main_window_simple_switch_page (MainWindow* self, GSimpleAction* a, GVariant* param) {
	MainWidget* _tmp0_;
	GVariant* _tmp1_;
	gint32 _tmp2_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = self->main_widget;
	_tmp1_ = param;
	_tmp2_ = g_variant_get_int32 (_tmp1_);
	main_widget_switch_page (_tmp0_, (gint) _tmp2_, NULL);
}


static void main_window_previous (MainWindow* self, GSimpleAction* a, GVariant* param) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_;
	MainWidget* _tmp4_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->account;
		_tmp3_ = _tmp2_->screen_name;
		_tmp0_ = g_strcmp0 (_tmp3_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->main_widget;
	main_widget_switch_page (_tmp4_, (gint) PAGE_PREVIOUS, NULL);
}


static void main_window_next (MainWindow* self, GSimpleAction* a, GVariant* param) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_;
	MainWidget* _tmp4_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->account;
		_tmp3_ = _tmp2_->screen_name;
		_tmp0_ = g_strcmp0 (_tmp3_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->main_widget;
	main_widget_switch_page (_tmp4_, (gint) PAGE_NEXT, NULL);
}


static void main_window_show_account_dialog (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_;
	AccountDialog* dialog = NULL;
	Account* _tmp4_;
	AccountDialog* _tmp5_;
	AccountDialog* _tmp6_;
	AccountDialog* _tmp7_;
	AccountDialog* _tmp8_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->account;
		_tmp3_ = _tmp2_->screen_name;
		_tmp0_ = g_strcmp0 (_tmp3_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->account;
	_tmp5_ = account_dialog_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	dialog = _tmp5_;
	_tmp6_ = dialog;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp7_ = dialog;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow), TRUE);
	_tmp8_ = dialog;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
}


static void main_window_show_account_list (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ != NULL) {
		Account* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->account;
		_tmp3_ = _tmp2_->screen_name;
		_tmp0_ = g_strcmp0 (_tmp3_, ACCOUNT_DUMMY) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkPopover* _tmp4_;
		_tmp4_ = self->priv->account_popover;
		gtk_popover_popup (_tmp4_);
	}
}


IPage* main_window_get_page (MainWindow* self, gint page_id) {
	IPage* result = NULL;
	MainWidget* _tmp0_;
	gint _tmp1_;
	IPage* _tmp2_;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->main_widget;
	_tmp1_ = page_id;
	_tmp2_ = main_widget_get_page (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void main_window_account_button_clicked_cb (MainWindow* self) {
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->account_popover;
	_tmp1_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkPopover* _tmp3_;
		_tmp3_ = self->priv->account_popover;
		gtk_popover_popdown (_tmp3_);
	} else {
		GtkPopover* _tmp4_;
		_tmp4_ = self->priv->account_popover;
		gtk_popover_popup (_tmp4_);
	}
}


static void main_window_account_popover_closed_cb (MainWindow* self) {
	GtkToggleButton* _tmp0_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->account_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
}


static gboolean main_window_window_delete_cb (MainWindow* self, GdkEventAny* evt) {
	gboolean result = FALSE;
	MainWidget* _tmp0_;
	Account* _tmp2_;
	GList* ws = NULL;
	GtkApplication* _tmp3_;
	GtkApplication* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	guint _tmp7_;
	gchar** startup_accounts = NULL;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint startup_accounts_length1;
	gint _startup_accounts_size_;
	gboolean _tmp13_ = FALSE;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gint n_main_windows = 0;
	GList* _tmp19_;
	gint _tmp30_;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = self->main_widget;
	if (_tmp0_ != NULL) {
		MainWidget* _tmp1_;
		_tmp1_ = self->main_widget;
		main_widget_stop (_tmp1_);
	}
	_tmp2_ = self->account;
	if (_tmp2_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp3_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_application_get_windows (_tmp4_);
	ws = _tmp5_;
	_tmp6_ = ws;
	_tmp7_ = g_list_length (_tmp6_);
	g_debug ("MainWindow.vala:439: Windows: %u", _tmp7_);
	_tmp8_ = settings_get ();
	_tmp9_ = _tmp8_;
	_tmp11_ = _tmp10_ = g_settings_get_strv (_tmp9_, "startup-accounts");
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _vala_array_length (_tmp10_);
	_g_object_unref0 (_tmp9_);
	startup_accounts = _tmp12_;
	startup_accounts_length1 = _tmp12__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp14_ = startup_accounts;
	_tmp14__length1 = startup_accounts_length1;
	if (_tmp14__length1 == 1) {
		gchar** _tmp15_;
		gint _tmp15__length1;
		const gchar* _tmp16_;
		_tmp15_ = startup_accounts;
		_tmp15__length1 = startup_accounts_length1;
		_tmp16_ = _tmp15_[0];
		_tmp13_ = g_strcmp0 (_tmp16_, "") == 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint _tmp17_;
		_tmp17_ = 0;
		startup_accounts = g_renew (gchar*, startup_accounts, 0);
		(_tmp17_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp17_ - startup_accounts_length1)) : NULL;
		startup_accounts_length1 = _tmp17_;
		_startup_accounts_size_ = _tmp17_;
	}
	main_window_save_geometry (self);
	_tmp18_ = startup_accounts;
	_tmp18__length1 = startup_accounts_length1;
	if (_tmp18__length1 > 0) {
		result = GDK_EVENT_PROPAGATE;
		startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	n_main_windows = 0;
	_tmp19_ = ws;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp19_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp20_;
			GtkWindow* win = NULL;
			_tmp20_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp20_;
			{
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				GtkWindow* _tmp23_;
				_tmp23_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp24_;
					Account* _tmp25_;
					_tmp24_ = win;
					_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp22_ = _tmp25_ != NULL;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					GtkWindow* _tmp26_;
					Account* _tmp27_;
					const gchar* _tmp28_;
					_tmp26_ = win;
					_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp28_ = _tmp27_->screen_name;
					_tmp21_ = g_strcmp0 (_tmp28_, ACCOUNT_DUMMY) != 0;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					gint _tmp29_;
					_tmp29_ = n_main_windows;
					n_main_windows = _tmp29_ + 1;
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp30_ = n_main_windows;
	if (_tmp30_ == 1) {
		gchar** new_startup_accounts = NULL;
		gchar** _tmp31_;
		gint new_startup_accounts_length1;
		gint _new_startup_accounts_size_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		GList* _tmp33_;
		gconstpointer _tmp34_;
		Account* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		GSettings* _tmp39_;
		GSettings* _tmp40_;
		gchar** _tmp41_;
		gint _tmp41__length1;
		GList* _tmp42_;
		gconstpointer _tmp43_;
		Account* _tmp44_;
		const gchar* _tmp45_;
		_tmp31_ = g_new0 (gchar*, 1 + 1);
		new_startup_accounts = _tmp31_;
		new_startup_accounts_length1 = 1;
		_new_startup_accounts_size_ = new_startup_accounts_length1;
		_tmp32_ = new_startup_accounts;
		_tmp32__length1 = new_startup_accounts_length1;
		_tmp33_ = ws;
		_tmp34_ = g_list_nth_data (_tmp33_, (guint) 0);
		_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp34_, TYPE_MAIN_WINDOW, MainWindow)->account;
		_tmp36_ = _tmp35_->screen_name;
		_tmp37_ = g_strdup (_tmp36_);
		_g_free0 (_tmp32_[0]);
		_tmp32_[0] = _tmp37_;
		_tmp38_ = _tmp32_[0];
		_tmp39_ = settings_get ();
		_tmp40_ = _tmp39_;
		_tmp41_ = new_startup_accounts;
		_tmp41__length1 = new_startup_accounts_length1;
		g_settings_set_strv (_tmp40_, "startup-accounts", _tmp41_);
		_g_object_unref0 (_tmp40_);
		_tmp42_ = ws;
		_tmp43_ = g_list_nth_data (_tmp42_, (guint) 0);
		_tmp44_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp43_, TYPE_MAIN_WINDOW, MainWindow)->account;
		_tmp45_ = _tmp44_->screen_name;
		g_debug ("MainWindow.vala:463: Saving the account %s", _tmp45_);
		new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	}
	result = GDK_EVENT_PROPAGATE;
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void main_window_account_info_changed (MainWindow* self, const gchar* screen_name, const gchar* name, cairo_surface_t* small_avatar, cairo_surface_t* avatar) {
	MainWidget* _tmp0_;
	MainWidget* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	IPage* _tmp4_;
	IPage* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (small_avatar != NULL);
	g_return_if_fail (avatar != NULL);
	_tmp0_ = self->main_widget;
	_tmp1_ = self->main_widget;
	_tmp2_ = main_widget_get_cur_page_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = main_widget_get_page (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = ipage_get_title (_tmp5_);
	_tmp7_ = _tmp6_;
	main_window_set_window_title (self, _tmp7_, GTK_STACK_TRANSITION_TYPE_NONE);
	_g_free0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_tmp8_ = screen_name;
	_tmp9_ = g_strdup_printf ("Corebird - @%s", _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp10_);
	_g_free0 (_tmp10_);
}


/**
   *
   */
static void main_window_load_geometry (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_;
	GVariant* win_geom = NULL;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	GVariant* _tmp8_;
	Account* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->account;
		_tmp3_ = _tmp2_->screen_name;
		_tmp0_ = g_strcmp0 (_tmp3_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		g_debug ("MainWindow.vala:482: Could not load geometry, account == null");
		return;
	}
	_tmp4_ = settings_get ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_settings_get_value (_tmp5_, "window-geometry");
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	win_geom = _tmp7_;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	_tmp8_ = win_geom;
	_tmp9_ = self->account;
	_tmp10_ = _tmp9_->screen_name;
	_tmp11_ = g_variant_lookup (_tmp8_, _tmp10_, "(iiii)", &x, &y, &w, &h, NULL);
	if (!_tmp11_) {
		Account* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = self->account;
		_tmp13_ = _tmp12_->screen_name;
		g_warning ("MainWindow.vala:492: Couldn't load window geometry for screen_name `%s" \
"'", _tmp13_);
		_g_variant_unref0 (win_geom);
		return;
	}
	_tmp15_ = w;
	if (_tmp15_ == 0) {
		_tmp14_ = TRUE;
	} else {
		gint _tmp16_;
		_tmp16_ = h;
		_tmp14_ = _tmp16_ == 0;
	}
	if (_tmp14_) {
		_g_variant_unref0 (win_geom);
		return;
	}
	_tmp17_ = x;
	_tmp18_ = y;
	gtk_window_move (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp17_, _tmp18_);
	_tmp19_ = w;
	_tmp20_ = h;
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp19_, _tmp20_);
	_g_variant_unref0 (win_geom);
}


/**
   * Saves this window's geometry in the window-geometry gsettings key.
   */
void main_window_save_geometry (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_;
	GVariant* win_geom = NULL;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* new_geom = NULL;
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariantBuilder* _tmp10_;
	GVariantBuilder* _tmp11_;
	GVariantIter* iter = NULL;
	GVariant* _tmp12_;
	GVariantIter* _tmp13_;
	gchar* key = NULL;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GVariantBuilder* _tmp29_;
	Account* _tmp30_;
	const gchar* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GVariantBuilder* _tmp36_;
	GVariant* _tmp37_;
	Account* _tmp38_;
	const gchar* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	GSettings* _tmp44_;
	GSettings* _tmp45_;
	GVariant* _tmp46_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->account;
		_tmp3_ = _tmp2_->screen_name;
		_tmp0_ = g_strcmp0 (_tmp3_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = settings_get ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_settings_get_value (_tmp5_, "window-geometry");
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	win_geom = _tmp7_;
	_tmp8_ = g_variant_type_new ("a{s(iiii)}");
	_tmp9_ = _tmp8_;
	_tmp10_ = g_variant_builder_new (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_variant_type_free0 (_tmp9_);
	builder = _tmp11_;
	_tmp12_ = win_geom;
	_tmp13_ = g_variant_iter_new (_tmp12_);
	iter = _tmp13_;
	key = NULL;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	while (TRUE) {
		GVariantIter* _tmp14_;
		gboolean _tmp15_;
		const gchar* _tmp16_;
		Account* _tmp17_;
		const gchar* _tmp18_;
		_tmp14_ = iter;
		_tmp15_ = g_variant_iter_next (_tmp14_, "{s(iiii)}", &key, &x, &y, &w, &h, NULL);
		if (!_tmp15_) {
			break;
		}
		_tmp16_ = key;
		_tmp17_ = self->account;
		_tmp18_ = _tmp17_->screen_name;
		if (g_strcmp0 (_tmp16_, _tmp18_) != 0) {
			GVariantBuilder* _tmp19_;
			const gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			_tmp19_ = builder;
			_tmp20_ = key;
			_tmp21_ = x;
			_tmp22_ = y;
			_tmp23_ = w;
			_tmp24_ = h;
			g_variant_builder_add (_tmp19_, "{s(iiii)}", _tmp20_, _tmp21_, _tmp22_, _tmp23_, _tmp24_, NULL);
		}
		_g_free0 (key);
		key = NULL;
	}
	gtk_window_get_position (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp25_, &_tmp26_);
	x = _tmp25_;
	y = _tmp26_;
	gtk_window_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp27_, &_tmp28_);
	w = _tmp27_;
	h = _tmp28_;
	_tmp29_ = builder;
	_tmp30_ = self->account;
	_tmp31_ = _tmp30_->screen_name;
	_tmp32_ = x;
	_tmp33_ = y;
	_tmp34_ = w;
	_tmp35_ = h;
	g_variant_builder_add (_tmp29_, "{s(iiii)}", _tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, NULL);
	_tmp36_ = builder;
	_tmp37_ = g_variant_builder_end (_tmp36_);
	g_variant_ref_sink (_tmp37_);
	_g_variant_unref0 (new_geom);
	new_geom = _tmp37_;
	_tmp38_ = self->account;
	_tmp39_ = _tmp38_->screen_name;
	_tmp40_ = x;
	_tmp41_ = y;
	_tmp42_ = w;
	_tmp43_ = h;
	g_debug ("MainWindow.vala:530: Saving geomentry for %s: %d,%d,%d,%d", _tmp39_, _tmp40_, _tmp41_, _tmp42_, _tmp43_);
	_tmp44_ = settings_get ();
	_tmp45_ = _tmp44_;
	_tmp46_ = new_geom;
	g_settings_set_value (_tmp45_, "window-geometry", _tmp46_);
	_g_object_unref0 (_tmp45_);
	_g_free0 (key);
	_g_variant_iter_free0 (iter);
	_g_variant_builder_unref0 (builder);
	_g_variant_unref0 (new_geom);
	_g_variant_unref0 (win_geom);
}


static gint main_window_account_sort_func (MainWindow* self, GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkListBoxRow* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), 0);
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (a), 0);
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (b), 0);
	_tmp0_ = a;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_ADD_LIST_ENTRY)) {
		result = 1;
		return result;
	}
	_tmp1_ = a;
	_tmp2_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = b;
	_tmp6_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = g_ascii_strcasecmp (_tmp4_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp4_);
	result = _tmp10_;
	return result;
}


void main_window_rerun_filters (MainWindow* self) {
	IPage* _tmp0_;
	DefaultTimeline* _tmp1_;
	IPage* _tmp2_;
	DefaultTimeline* _tmp3_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = main_window_get_page (self, (gint) PAGE_STREAM);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	default_timeline_rerun_filters (_tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = main_window_get_page (self, (gint) PAGE_MENTIONS);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	default_timeline_rerun_filters (_tmp3_);
	_g_object_unref0 (_tmp3_);
}


void main_window_set_window_title (MainWindow* self, const gchar* title, GtkStackTransitionType transition_type) {
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkStack* _tmp4_;
	GtkStack* _tmp5_;
	GtkLabel* _tmp6_;
	GtkStack* _tmp7_;
	GtkStackTransitionType _tmp8_;
	GtkLabel* _tmp9_;
	const gchar* _tmp10_;
	GtkStack* _tmp11_;
	GtkLabel* _tmp12_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->last_page_label;
	_tmp1_ = self->priv->title_label;
	_tmp2_ = gtk_label_get_label (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->title_stack;
	gtk_stack_set_transition_type (_tmp4_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp5_ = self->priv->title_stack;
	_tmp6_ = self->priv->last_page_label;
	gtk_stack_set_visible_child (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->title_stack;
	_tmp8_ = transition_type;
	gtk_stack_set_transition_type (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->title_label;
	_tmp10_ = title;
	gtk_label_set_label (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->title_stack;
	_tmp12_ = self->priv->title_label;
	gtk_stack_set_visible_child (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
}


void main_window_reply_to_tweet (MainWindow* self, gint64 tweet_id) {
	CbTweet* tweet = NULL;
	MainWidget* _tmp0_;
	IPage* _tmp1_;
	DefaultTimeline* _tmp2_;
	TweetListBox* _tmp3_;
	CbTweetModel* _tmp4_;
	gint64 _tmp5_;
	CbTweet* _tmp6_;
	CbTweet* _tmp7_;
	CbTweet* _tmp8_;
	ComposeTweetWindow* ctw = NULL;
	Account* _tmp12_;
	CbTweet* _tmp13_;
	ComposeTweetWindow* _tmp14_;
	ComposeTweetWindow* _tmp15_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	tweet = NULL;
	_tmp0_ = self->main_widget;
	_tmp1_ = main_widget_get_page (_tmp0_, (gint) PAGE_STREAM);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp3_ = _tmp2_->tweet_list;
	_tmp4_ = _tmp3_->model;
	_tmp5_ = tweet_id;
	_tmp6_ = cb_tweet_model_get_for_id (_tmp4_, _tmp5_, 0);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (tweet);
	tweet = _tmp7_;
	_g_object_unref0 (_tmp2_);
	_tmp8_ = tweet;
	if (_tmp8_ == NULL) {
		gint64 _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = tweet_id;
		_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp9_);
		_tmp11_ = _tmp10_;
		g_warning ("MainWindow.vala:565: tweet with id %s could not be found", _tmp11_);
		_g_free0 (_tmp11_);
		_g_object_unref0 (tweet);
		return;
	}
	_tmp12_ = self->account;
	_tmp13_ = tweet;
	_tmp14_ = compose_tweet_window_new (self, _tmp12_, _tmp13_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp14_);
	ctw = _tmp14_;
	_tmp15_ = ctw;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
	_g_object_unref0 (tweet);
}


void main_window_mark_tweet_as_read (MainWindow* self, gint64 tweet_id) {
	DefaultTimeline* home_timeline = NULL;
	MainWidget* _tmp0_;
	IPage* _tmp1_;
	DefaultTimeline* mentions_timeline = NULL;
	MainWidget* _tmp2_;
	IPage* _tmp3_;
	CbTweet* tweet = NULL;
	DefaultTimeline* _tmp4_;
	TweetListBox* _tmp5_;
	CbTweetModel* _tmp6_;
	gint64 _tmp7_;
	CbTweet* _tmp8_;
	CbTweet* _tmp9_;
	CbTweet* _tmp10_;
	DefaultTimeline* _tmp15_;
	TweetListBox* _tmp16_;
	CbTweetModel* _tmp17_;
	gint64 _tmp18_;
	CbTweet* _tmp19_;
	CbTweet* _tmp20_;
	CbTweet* _tmp21_;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->main_widget;
	_tmp1_ = main_widget_get_page (_tmp0_, (gint) PAGE_STREAM);
	home_timeline = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp2_ = self->main_widget;
	_tmp3_ = main_widget_get_page (_tmp2_, (gint) PAGE_MENTIONS);
	mentions_timeline = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	tweet = NULL;
	_tmp4_ = home_timeline;
	_tmp5_ = _tmp4_->tweet_list;
	_tmp6_ = _tmp5_->model;
	_tmp7_ = tweet_id;
	_tmp8_ = cb_tweet_model_get_for_id (_tmp6_, _tmp7_, 0);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (tweet);
	tweet = _tmp9_;
	_tmp10_ = tweet;
	if (_tmp10_ != NULL) {
		CbTweet* _tmp11_;
		DefaultTimeline* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp11_ = tweet;
		cb_tweet_set_seen (_tmp11_, TRUE);
		_tmp12_ = home_timeline;
		_tmp13_ = default_timeline_get_unread_count (_tmp12_);
		_tmp14_ = _tmp13_;
		default_timeline_set_unread_count (_tmp12_, _tmp14_ - 1);
	}
	_tmp15_ = mentions_timeline;
	_tmp16_ = _tmp15_->tweet_list;
	_tmp17_ = _tmp16_->model;
	_tmp18_ = tweet_id;
	_tmp19_ = cb_tweet_model_get_for_id (_tmp17_, _tmp18_, 0);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (tweet);
	tweet = _tmp20_;
	_tmp21_ = tweet;
	if (_tmp21_ != NULL) {
		CbTweet* _tmp22_;
		DefaultTimeline* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp22_ = tweet;
		cb_tweet_set_seen (_tmp22_, TRUE);
		_tmp23_ = mentions_timeline;
		_tmp24_ = default_timeline_get_unread_count (_tmp23_);
		_tmp25_ = _tmp24_;
		default_timeline_set_unread_count (_tmp23_, _tmp25_ - 1);
	}
	_g_object_unref0 (tweet);
	_g_object_unref0 (mentions_timeline);
	_g_object_unref0 (home_timeline);
}


gint main_window_get_cur_page_id (MainWindow* self) {
	gint result;
	MainWidget* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), 0);
	_tmp0_ = self->main_widget;
	_tmp1_ = main_widget_get_cur_page_id (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void main_window_class_init (MainWindowClass * klass) {
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_main_window_get_property;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_CUR_PAGE_ID_PROPERTY, main_window_properties[MAIN_WINDOW_CUR_PAGE_ID_PROPERTY] = g_param_spec_int ("cur-page-id", "cur-page-id", "cur-page-id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void main_window_instance_init (MainWindow * self) {
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->app_menu_button = NULL;
	self->priv->compose_tweet_window = NULL;
}


static void main_window_finalize (GObject * obj) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->account_list);
	_g_object_unref0 (self->priv->account_popover);
	_g_object_unref0 (self->priv->header_box);
	_g_object_unref0 (self->priv->account_button);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->last_page_label);
	_g_object_unref0 (self->priv->title_stack);
	_g_object_unref0 (self->back_button);
	_g_object_unref0 (self->compose_tweet_button);
	_g_object_unref0 (self->priv->app_menu_button);
	_g_object_unref0 (self->main_widget);
	_g_object_unref0 (self->priv->compose_tweet_window);
	_g_object_unref0 (self->priv->thumb_button_gesture);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}


static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
	switch (property_id) {
		case MAIN_WINDOW_CUR_PAGE_ID_PROPERTY:
		g_value_set_int (value, main_window_get_cur_page_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



