/* ReplyIndicator.c generated by valac 0.36.4, the Vala compiler
 * generated from ReplyIndicator.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define TYPE_REPLY_INDICATOR (reply_indicator_get_type ())
#define REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPLY_INDICATOR, ReplyIndicator))
#define REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))
#define IS_REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPLY_INDICATOR))
#define IS_REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPLY_INDICATOR))
#define REPLY_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))

typedef struct _ReplyIndicator ReplyIndicator;
typedef struct _ReplyIndicatorClass ReplyIndicatorClass;
typedef struct _ReplyIndicatorPrivate ReplyIndicatorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ReplyIndicator {
	GtkWidget parent_instance;
	ReplyIndicatorPrivate * priv;
};

struct _ReplyIndicatorClass {
	GtkWidgetClass parent_class;
};

struct _ReplyIndicatorPrivate {
	gboolean replies;
	gint64 start_time;
	gdouble show_factor;
};


static gpointer reply_indicator_parent_class = NULL;

GType reply_indicator_get_type (void) G_GNUC_CONST;
#define REPLY_INDICATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_REPLY_INDICATOR, ReplyIndicatorPrivate))
enum  {
	REPLY_INDICATOR_DUMMY_PROPERTY,
	REPLY_INDICATOR_REPLIES_AVAILABLE
};
#define REPLY_INDICATOR_FINAL_HEIGHT 5
static GtkSizeRequestMode reply_indicator_real_get_request_mode (GtkWidget* base);
static void reply_indicator_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min_height, gint* nat_height);
static void reply_indicator_on_replies_available (ReplyIndicator* self);
static gboolean reply_indicator_tick_callback (ReplyIndicator* self, GtkWidget* widget, GdkFrameClock* frame_clock);
static gboolean _reply_indicator_tick_callback_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
#define TRANSITION_DURATION (200 * 1000)
gdouble ease_out_cubic (gdouble t);
static gboolean reply_indicator_real_draw (GtkWidget* base, cairo_t* ct);
ReplyIndicator* reply_indicator_new (void);
ReplyIndicator* reply_indicator_construct (GType object_type);
gboolean reply_indicator_get_replies_available (ReplyIndicator* self);
void reply_indicator_set_replies_available (ReplyIndicator* self, gboolean value);
static GObject * reply_indicator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void reply_indicator_finalize (GObject * obj);
static void _vala_reply_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_reply_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static GtkSizeRequestMode reply_indicator_real_get_request_mode (GtkWidget* base) {
	ReplyIndicator * self;
	GtkSizeRequestMode result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_REPLY_INDICATOR, ReplyIndicator);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static void reply_indicator_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min_height, gint* nat_height) {
	ReplyIndicator * self;
	gint _vala_min_height = 0;
	gint _vala_nat_height = 0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_REPLY_INDICATOR, ReplyIndicator);
	_tmp0_ = self->priv->show_factor;
	_vala_min_height = (gint) (REPLY_INDICATOR_FINAL_HEIGHT * _tmp0_);
	_tmp1_ = self->priv->show_factor;
	_vala_nat_height = (gint) (REPLY_INDICATOR_FINAL_HEIGHT * _tmp1_);
	if (min_height) {
		*min_height = _vala_min_height;
	}
	if (nat_height) {
		*nat_height = _vala_nat_height;
	}
}


static gboolean _reply_indicator_tick_callback_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = reply_indicator_tick_callback ((ReplyIndicator*) self, widget, frame_clock);
	return result;
}


static void reply_indicator_on_replies_available (ReplyIndicator* self) {
	gboolean _tmp0_;
	GdkFrameClock* _tmp1_;
	gint64 _tmp2_;
	g_return_if_fail (IS_REPLY_INDICATOR (self));
	_tmp0_ = self->priv->replies;
	if (!_tmp0_) {
		self->priv->show_factor = 0.0;
		gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		return;
	}
	_tmp1_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = gdk_frame_clock_get_frame_time (_tmp1_);
	self->priv->start_time = _tmp2_;
	gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _reply_indicator_tick_callback_gtk_tick_callback, g_object_ref (self), g_object_unref);
}


static gboolean reply_indicator_tick_callback (ReplyIndicator* self, GtkWidget* widget, GdkFrameClock* frame_clock) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gint64 now = 0LL;
	GdkFrameClock* _tmp1_;
	gint64 _tmp2_;
	gint64 end_time = 0LL;
	gint64 _tmp3_;
	gdouble t = 0.0;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	g_return_val_if_fail (IS_REPLY_INDICATOR (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	g_return_val_if_fail (GDK_IS_FRAME_CLOCK (frame_clock), FALSE);
	_tmp0_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp1_ = frame_clock;
	_tmp2_ = gdk_frame_clock_get_frame_time (_tmp1_);
	now = _tmp2_;
	_tmp3_ = self->priv->start_time;
	end_time = _tmp3_ + TRANSITION_DURATION;
	t = 1.0;
	_tmp4_ = now;
	_tmp5_ = end_time;
	if (_tmp4_ < _tmp5_) {
		gint64 _tmp6_;
		gint64 _tmp7_;
		gint64 _tmp8_;
		gint64 _tmp9_;
		_tmp6_ = now;
		_tmp7_ = self->priv->start_time;
		_tmp8_ = end_time;
		_tmp9_ = self->priv->start_time;
		t = (_tmp6_ - _tmp7_) / ((gdouble) (_tmp8_ - _tmp9_));
	}
	_tmp10_ = t;
	_tmp11_ = ease_out_cubic (_tmp10_);
	t = _tmp11_;
	_tmp12_ = t;
	self->priv->show_factor = _tmp12_;
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp13_ = t;
	if (_tmp13_ >= 1.0) {
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean reply_indicator_real_draw (GtkWidget* base, cairo_t* ct) {
	ReplyIndicator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	cairo_t* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_REPLY_INDICATOR, ReplyIndicator);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = self->priv->replies;
	if (!_tmp0_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _g_object_ref0 (_tmp1_);
	style_context = _tmp2_;
	_tmp3_ = style_context;
	_tmp4_ = ct;
	_tmp5_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_render_background (_tmp3_, _tmp4_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp5_, (gdouble) _tmp6_);
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (style_context);
	return result;
}


ReplyIndicator* reply_indicator_construct (GType object_type) {
	ReplyIndicator * self = NULL;
	self = (ReplyIndicator*) gtk_widget_new (object_type, NULL);
	return self;
}


ReplyIndicator* reply_indicator_new (void) {
	return reply_indicator_construct (TYPE_REPLY_INDICATOR);
}


gboolean reply_indicator_get_replies_available (ReplyIndicator* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (IS_REPLY_INDICATOR (self), FALSE);
	_tmp0_ = self->priv->replies;
	result = _tmp0_;
	return result;
}


void reply_indicator_set_replies_available (ReplyIndicator* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (IS_REPLY_INDICATOR (self));
	_tmp0_ = value;
	self->priv->replies = _tmp0_;
	reply_indicator_on_replies_available (self);
	g_object_notify ((GObject *) self, "replies-available");
}


static GObject * reply_indicator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ReplyIndicator * self;
	parent_class = G_OBJECT_CLASS (reply_indicator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REPLY_INDICATOR, ReplyIndicator);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	return obj;
}


static void reply_indicator_class_init (ReplyIndicatorClass * klass) {
	reply_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ReplyIndicatorPrivate));
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget *)) reply_indicator_real_get_request_mode;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget *, gint, gint*, gint*)) reply_indicator_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) reply_indicator_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_reply_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_reply_indicator_set_property;
	G_OBJECT_CLASS (klass)->constructor = reply_indicator_constructor;
	G_OBJECT_CLASS (klass)->finalize = reply_indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), REPLY_INDICATOR_REPLIES_AVAILABLE, g_param_spec_boolean ("replies-available", "replies-available", "replies-available", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "replyindicator");
}


static void reply_indicator_instance_init (ReplyIndicator * self) {
	self->priv = REPLY_INDICATOR_GET_PRIVATE (self);
	self->priv->replies = FALSE;
	self->priv->show_factor = 0.0;
}


static void reply_indicator_finalize (GObject * obj) {
	ReplyIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REPLY_INDICATOR, ReplyIndicator);
	G_OBJECT_CLASS (reply_indicator_parent_class)->finalize (obj);
}


GType reply_indicator_get_type (void) {
	static volatile gsize reply_indicator_type_id__volatile = 0;
	if (g_once_init_enter (&reply_indicator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ReplyIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) reply_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ReplyIndicator), 0, (GInstanceInitFunc) reply_indicator_instance_init, NULL };
		GType reply_indicator_type_id;
		reply_indicator_type_id = g_type_register_static (gtk_widget_get_type (), "ReplyIndicator", &g_define_type_info, 0);
		g_once_init_leave (&reply_indicator_type_id__volatile, reply_indicator_type_id);
	}
	return reply_indicator_type_id__volatile;
}


static void _vala_reply_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ReplyIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_REPLY_INDICATOR, ReplyIndicator);
	switch (property_id) {
		case REPLY_INDICATOR_REPLIES_AVAILABLE:
		g_value_set_boolean (value, reply_indicator_get_replies_available (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_reply_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ReplyIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_REPLY_INDICATOR, ReplyIndicator);
	switch (property_id) {
		case REPLY_INDICATOR_REPLIES_AVAILABLE:
		reply_indicator_set_replies_available (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



