/* Corebird.c generated by valac 0.36.4, the Vala compiler
 * generated from Corebird.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "CbSnippetManager.h"
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include "config.h"
#include <gst/gst.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include "CbMediaDownloader.h"
#include "CbTweet.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbBundle.h"


#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;
typedef struct _CorebirdPrivate CorebirdPrivate;

#define TYPE_SETTINGS_DIALOG (settings_dialog_get_type ())
#define SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_DIALOG, SettingsDialog))
#define SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_DIALOG, SettingsDialogClass))
#define IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_DIALOG))
#define IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_DIALOG))
#define SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_DIALOG, SettingsDialogClass))

typedef struct _SettingsDialog SettingsDialog;
typedef struct _SettingsDialogClass SettingsDialogClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_ABOUT_DIALOG (about_dialog_get_type ())
#define ABOUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABOUT_DIALOG, AboutDialog))
#define ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABOUT_DIALOG, AboutDialogClass))
#define IS_ABOUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABOUT_DIALOG))
#define IS_ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABOUT_DIALOG))
#define ABOUT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABOUT_DIALOG, AboutDialogClass))

typedef struct _AboutDialog AboutDialog;
typedef struct _AboutDialogClass AboutDialogClass;

#define TYPE_LAZY_MENU_BUTTON (lazy_menu_button_get_type ())
#define LAZY_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAZY_MENU_BUTTON, LazyMenuButton))
#define LAZY_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAZY_MENU_BUTTON, LazyMenuButtonClass))
#define IS_LAZY_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAZY_MENU_BUTTON))
#define IS_LAZY_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAZY_MENU_BUTTON))
#define LAZY_MENU_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAZY_MENU_BUTTON, LazyMenuButtonClass))

typedef struct _LazyMenuButton LazyMenuButton;
typedef struct _LazyMenuButtonClass LazyMenuButtonClass;

#define TYPE_FAV_IMAGE_VIEW (fav_image_view_get_type ())
#define FAV_IMAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FAV_IMAGE_VIEW, FavImageView))
#define FAV_IMAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FAV_IMAGE_VIEW, FavImageViewClass))
#define IS_FAV_IMAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FAV_IMAGE_VIEW))
#define IS_FAV_IMAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FAV_IMAGE_VIEW))
#define FAV_IMAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FAV_IMAGE_VIEW, FavImageViewClass))

typedef struct _FavImageView FavImageView;
typedef struct _FavImageViewClass FavImageViewClass;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _AccountPrivate AccountPrivate;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_PAGE (page_get_type ())
enum  {
	COREBIRD_ACCOUNT_ADDED_SIGNAL,
	COREBIRD_ACCOUNT_REMOVED_SIGNAL,
	COREBIRD_ACCOUNT_WINDOW_CHANGED_SIGNAL,
	COREBIRD_LAST_SIGNAL
};
static guint corebird_signals[COREBIRD_LAST_SIGNAL] = {0};

struct _Corebird {
	GtkApplication parent_instance;
	CorebirdPrivate * priv;
};

struct _CorebirdClass {
	GtkApplicationClass parent_class;
};

struct _CorebirdPrivate {
	SettingsDialog* settings_dialog;
	GPtrArray* active_accounts;
	gboolean started_as_service;
};

struct _Block1Data {
	int _ref_count_;
	Corebird* self;
	GSimpleAction* action;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;


extern gboolean STRESSTEST;
gboolean STRESSTEST = FALSE;
static gpointer corebird_parent_class = NULL;
extern SqlDatabase* corebird_db;
SqlDatabase* corebird_db = NULL;
extern CbSnippetManager* corebird_snippet_manager;
CbSnippetManager* corebird_snippet_manager = NULL;

GType corebird_get_type (void) G_GNUC_CONST;
GType settings_dialog_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define COREBIRD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COREBIRD, CorebirdPrivate))
enum  {
	COREBIRD_DUMMY_PROPERTY
};
GType sql_database_get_type (void) G_GNUC_CONST;
static void corebird_show_settings_activated (Corebird* self);
static void _corebird_show_settings_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_show_shortcuts_activated (Corebird* self);
static void _corebird_show_shortcuts_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_quit_application (Corebird* self);
static void _corebird_quit_application_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_about_activated (Corebird* self);
static void _corebird_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_show_dm_thread (Corebird* self, GSimpleAction* a, GVariant* value);
static void _corebird_show_dm_thread_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_show_window (Corebird* self, GSimpleAction* a, GVariant* value);
static void _corebird_show_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_mark_read_activated (Corebird* self, GSimpleAction* a, GVariant* v);
static void _corebird_mark_read_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_reply_to_tweet_activated (Corebird* self, GSimpleAction* a, GVariant* v);
static void _corebird_reply_to_tweet_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Corebird* corebird_new (void);
Corebird* corebird_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
void dirs_create_dirs (void);
gchar* dirs_config (const gchar* path);
#define SQL_COREBIRD_INIT_FILE "/org/baedert/corebird/sql/init/Create.%d.sql"
#define SQL_COREBIRD_SQL_VERSION 2
SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file, gint max_version);
SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file, gint max_version);
sqlite3* sql_database_get_sqlite_db (SqlDatabase* self);
static gint corebird_real_command_line (GApplication* base, GApplicationCommandLine* cmd);
GSettings* settings_get (void);
static void corebird_open_startup_windows (Corebird* self, const gchar* compose_screen_name, const gchar* account_name);
static void corebird_real_activate (GApplication* base);
guint account_get_n (void);
Account* account_query_account (const gchar* screen_name);
void corebird_start_account (Corebird* self, Account* acc);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
SettingsDialog* settings_dialog_new (Corebird* application);
SettingsDialog* settings_dialog_construct (GType object_type, Corebird* application);
static gboolean __lambda194_ (Block1Data* _data1_);
static gboolean ___lambda194__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
GType about_dialog_get_type (void) G_GNUC_CONST;
AboutDialog* about_dialog_new (void);
AboutDialog* about_dialog_construct (GType object_type);
static void corebird_real_startup (GApplication* base);
GType lazy_menu_button_get_type (void) G_GNUC_CONST;
GType fav_image_view_get_type (void) G_GNUC_CONST;
void utils_load_custom_css (void);
void utils_load_custom_icons (void);
void utils_init_soup_session (void);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_init (Twitter* self);
gchar* settings_get_accel (const gchar* accel_name);
gboolean settings_use_dark_theme (void);
static void corebird_real_shutdown (GApplication* base);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
void corebird_add_window_for_account (Corebird* self, Account* account);
gboolean corebird_add_window_for_screen_name (Corebird* self, const gchar* screen_name);
Account* account_get_nth (guint index);
GType notification_manager_get_type (void) G_GNUC_CONST;
MainWindow* main_window_new (GtkApplication* app, Account* account);
MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account);
gboolean corebird_is_window_open_for_screen_name (Corebird* self, const gchar* screen_name, MainWindow* * window);
gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow* * window);
GType main_widget_get_type (void) G_GNUC_CONST;
#define ACCOUNT_DUMMY "screen_name"
void main_window_save_geometry (MainWindow* self);
void account_init_information (Account* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_init_information_finish (Account* self, GAsyncResult* _res_);
void corebird_stop_account (Corebird* self, Account* acc);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
void account_uninit (Account* self);
#define DM_PAGE_KEY_SENDER_ID 0
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
Account* account_query_account_by_id (gint64 id);
void main_window_mark_tweet_as_read (MainWindow* self, gint64 tweet_id);
void main_window_reply_to_tweet (MainWindow* self, gint64 tweet_id);
static void g_cclosure_user_marshal_VOID__POINTER_INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void corebird_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry COREBIRD_app_entries[8] = {{"show-settings", _corebird_show_settings_activated_gsimple_action_activate_callback}, {"show-shortcuts", _corebird_show_shortcuts_activated_gsimple_action_activate_callback}, {"quit", _corebird_quit_application_gsimple_action_activate_callback}, {"show-about-dialog", _corebird_about_activated_gsimple_action_activate_callback}, {"show-dm-thread", _corebird_show_dm_thread_gsimple_action_activate_callback, "(xx)"}, {"show-window", _corebird_show_window_gsimple_action_activate_callback, "x"}, {"mark-read", _corebird_mark_read_activated_gsimple_action_activate_callback, "(xx)"}, {"reply-to-tweet", _corebird_reply_to_tweet_activated_gsimple_action_activate_callback, "(xx)"}};

static void _corebird_show_settings_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_settings_activated ((Corebird*) self);
}


static void _corebird_show_shortcuts_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_shortcuts_activated ((Corebird*) self);
}


static void _corebird_quit_application_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_quit_application ((Corebird*) self);
}


static void _corebird_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_about_activated ((Corebird*) self);
}


static void _corebird_show_dm_thread_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_dm_thread ((Corebird*) self, action, parameter);
}


static void _corebird_show_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_window ((Corebird*) self, action, parameter);
}


static void _corebird_mark_read_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_mark_read_activated ((Corebird*) self, action, parameter);
}


static void _corebird_reply_to_tweet_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_reply_to_tweet_activated ((Corebird*) self, action, parameter);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


Corebird* corebird_construct (GType object_type) {
	Corebird * self = NULL;
	GPtrArray* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SqlDatabase* _tmp3_;
	SqlDatabase* _tmp4_;
	sqlite3* _tmp5_;
	CbSnippetManager* _tmp6_;
	self = (Corebird*) g_object_new (object_type, "application-id", "org.baedert.corebird", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->active_accounts);
	self->priv->active_accounts = _tmp0_;
	dirs_create_dirs ();
	_tmp1_ = dirs_config ("Corebird.db");
	_tmp2_ = _tmp1_;
	_tmp3_ = sql_database_new (_tmp2_, SQL_COREBIRD_INIT_FILE, SQL_COREBIRD_SQL_VERSION);
	_g_object_unref0 (corebird_db);
	corebird_db = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = corebird_db;
	_tmp5_ = sql_database_get_sqlite_db (_tmp4_);
	_tmp6_ = cb_snippet_manager_new (_tmp5_);
	_g_object_unref0 (corebird_snippet_manager);
	corebird_snippet_manager = _tmp6_;
	return self;
}


Corebird* corebird_new (void) {
	return corebird_construct (TYPE_COREBIRD);
}


static gint corebird_real_command_line (GApplication* base, GApplicationCommandLine* cmd) {
	Corebird * self;
	gint result = 0;
	gchar* compose_screen_name = NULL;
	gboolean start_service = FALSE;
	gboolean stop_service = FALSE;
	gboolean print_startup_accounts = FALSE;
	gboolean stresstest = FALSE;
	gchar* account_name = NULL;
	GOptionEntry* options = NULL;
	GOptionEntry* _tmp0_;
	gint options_length1;
	gint _options_size_;
	GOptionEntry* _tmp1_;
	gint _tmp1__length1;
	GOptionEntry _tmp2_ = {0};
	GOptionEntry _tmp3_;
	GOptionEntry* _tmp4_;
	gint _tmp4__length1;
	GOptionEntry _tmp5_ = {0};
	GOptionEntry _tmp6_;
	GOptionEntry* _tmp7_;
	gint _tmp7__length1;
	GOptionEntry _tmp8_ = {0};
	GOptionEntry _tmp9_;
	GOptionEntry* _tmp10_;
	gint _tmp10__length1;
	GOptionEntry _tmp11_ = {0};
	GOptionEntry _tmp12_;
	GOptionEntry* _tmp13_;
	gint _tmp13__length1;
	GOptionEntry _tmp14_ = {0};
	GOptionEntry _tmp15_;
	GOptionEntry* _tmp16_;
	gint _tmp16__length1;
	GOptionEntry _tmp17_ = {0};
	GOptionEntry _tmp18_;
	GOptionEntry* _tmp19_;
	gint _tmp19__length1;
	GOptionEntry _tmp20_ = {0};
	GOptionEntry _tmp21_;
	gchar** args = NULL;
	GApplicationCommandLine* _tmp22_;
	gint _tmp23_;
	gchar** _tmp24_;
	gint args_length1;
	gint _args_size_;
	const gchar** _args = NULL;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar** _tmp26_;
	gint _args_length1;
	gint __args_size_;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_;
	gboolean _tmp53_;
	gboolean _tmp54_;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	g_return_val_if_fail (G_IS_APPLICATION_COMMAND_LINE (cmd), 0);
	compose_screen_name = NULL;
	start_service = FALSE;
	stop_service = FALSE;
	print_startup_accounts = FALSE;
	stresstest = FALSE;
	account_name = NULL;
	_tmp0_ = g_new0 (GOptionEntry, 7);
	options = _tmp0_;
	options_length1 = 7;
	_options_size_ = options_length1;
	_tmp1_ = options;
	_tmp1__length1 = options_length1;
	_tmp2_.long_name = "tweet";
	_tmp2_.short_name = 't';
	_tmp2_.flags = 0;
	_tmp2_.arg = G_OPTION_ARG_STRING;
	_tmp2_.arg_data = &compose_screen_name;
	_tmp2_.description = "Shows only the 'compose tweet' window for the given account, nothing e" \
"lse.";
	_tmp2_.arg_description = "account name";
	_tmp1_[0] = _tmp2_;
	_tmp3_ = _tmp1_[0];
	_tmp4_ = options;
	_tmp4__length1 = options_length1;
	_tmp5_.long_name = "start-service";
	_tmp5_.short_name = 's';
	_tmp5_.flags = 0;
	_tmp5_.arg = G_OPTION_ARG_NONE;
	_tmp5_.arg_data = &start_service;
	_tmp5_.description = "Start service";
	_tmp5_.arg_description = NULL;
	_tmp4_[1] = _tmp5_;
	_tmp6_ = _tmp4_[1];
	_tmp7_ = options;
	_tmp7__length1 = options_length1;
	_tmp8_.long_name = "stop-service";
	_tmp8_.short_name = 'p';
	_tmp8_.flags = 0;
	_tmp8_.arg = G_OPTION_ARG_NONE;
	_tmp8_.arg_data = &stop_service;
	_tmp8_.description = "Stop service, if it has been started as a service";
	_tmp8_.arg_description = NULL;
	_tmp7_[2] = _tmp8_;
	_tmp9_ = _tmp7_[2];
	_tmp10_ = options;
	_tmp10__length1 = options_length1;
	_tmp11_.long_name = "print-startup-accounts";
	_tmp11_.short_name = 'a';
	_tmp11_.flags = 0;
	_tmp11_.arg = G_OPTION_ARG_NONE;
	_tmp11_.arg_data = &print_startup_accounts;
	_tmp11_.description = "Print configured startup accounts";
	_tmp11_.arg_description = NULL;
	_tmp10_[3] = _tmp11_;
	_tmp12_ = _tmp10_[3];
	_tmp13_ = options;
	_tmp13__length1 = options_length1;
	_tmp14_.long_name = "account";
	_tmp14_.short_name = 'c';
	_tmp14_.flags = 0;
	_tmp14_.arg = G_OPTION_ARG_STRING;
	_tmp14_.arg_data = &account_name;
	_tmp14_.description = "Open the window for the given account";
	_tmp14_.arg_description = "account name";
	_tmp13_[4] = _tmp14_;
	_tmp15_ = _tmp13_[4];
	_tmp16_ = options;
	_tmp16__length1 = options_length1;
	_tmp17_.long_name = "stresstest";
	_tmp17_.short_name = 'r';
	_tmp17_.flags = (gint) G_OPTION_FLAG_HIDDEN;
	_tmp17_.arg = G_OPTION_ARG_NONE;
	_tmp17_.arg_data = &stresstest;
	_tmp17_.description = "Debugging only.";
	_tmp17_.arg_description = NULL;
	_tmp16_[5] = _tmp17_;
	_tmp18_ = _tmp16_[5];
	_tmp19_ = options;
	_tmp19__length1 = options_length1;
	_tmp20_.long_name = NULL;
	_tmp19_[6] = _tmp20_;
	_tmp21_ = _tmp19_[6];
	_tmp22_ = cmd;
	_tmp24_ = g_application_command_line_get_arguments (_tmp22_, &_tmp23_);
	args = _tmp24_;
	args_length1 = _tmp23_;
	_args_size_ = args_length1;
	_tmp25_ = args;
	_tmp25__length1 = args_length1;
	_tmp26_ = g_new0 (gchar*, _tmp25__length1 + 1);
	_args = _tmp26_;
	_args_length1 = _tmp25__length1;
	__args_size_ = _args_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				gint _tmp29_;
				gchar** _tmp30_;
				gint _tmp30__length1;
				const gchar** _tmp31_;
				gint _tmp31__length1;
				gint _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				gint _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				if (!_tmp27_) {
					gint _tmp28_;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				_tmp29_ = i;
				_tmp30_ = args;
				_tmp30__length1 = args_length1;
				if (!(_tmp29_ < _tmp30__length1)) {
					break;
				}
				_tmp31_ = _args;
				_tmp31__length1 = _args_length1;
				_tmp32_ = i;
				_tmp33_ = args;
				_tmp33__length1 = args_length1;
				_tmp34_ = i;
				_tmp35_ = _tmp33_[_tmp34_];
				_tmp31_[_tmp32_] = _tmp35_;
				_tmp36_ = _tmp31_[_tmp32_];
			}
		}
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp37_;
		GOptionContext* _tmp38_;
		GOptionContext* _tmp39_;
		GOptionEntry* _tmp40_;
		gint _tmp40__length1;
		GOptionContext* _tmp41_;
		GOptionGroup* _tmp42_;
		GOptionContext* _tmp43_;
		GOptionGroup* _tmp44_;
		gchar** tmp = NULL;
		const gchar** _tmp45_;
		gint _tmp45__length1;
		gint tmp_length1;
		gint _tmp_size_;
		GOptionContext* _tmp46_;
		_tmp37_ = g_option_context_new ("");
		opt_context = _tmp37_;
		_tmp38_ = opt_context;
		g_option_context_set_help_enabled (_tmp38_, TRUE);
		_tmp39_ = opt_context;
		_tmp40_ = options;
		_tmp40__length1 = options_length1;
		g_option_context_add_main_entries (_tmp39_, _tmp40_, GETTEXT_PACKAGE);
		_tmp41_ = opt_context;
		_tmp42_ = gtk_get_option_group (FALSE);
		g_option_context_add_group (_tmp41_, _tmp42_);
		_tmp43_ = opt_context;
		_tmp44_ = gst_init_get_option_group ();
		g_option_context_add_group (_tmp43_, _tmp44_);
		_tmp45_ = _args;
		_tmp45__length1 = _args_length1;
		tmp = _tmp45_;
		tmp_length1 = _tmp45__length1;
		_tmp_size_ = tmp_length1;
		_tmp46_ = opt_context;
		g_option_context_parse (_tmp46_, &tmp_length1, &tmp, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp47_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_args = (g_free (_args), NULL);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			options = (g_free (options), NULL);
			_g_free0 (account_name);
			_g_free0 (compose_screen_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp47_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GApplicationCommandLine* _tmp48_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp48_ = cmd;
		g_application_command_line_print (_tmp48_, "Use --help to see available options\n");
		g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
		result = -1;
		_g_error_free0 (e);
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		options = (g_free (options), NULL);
		_g_free0 (account_name);
		_g_free0 (compose_screen_name);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp49_ = 0;
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		options = (g_free (options), NULL);
		_g_free0 (account_name);
		_g_free0 (compose_screen_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp49_;
	}
	_tmp51_ = stop_service;
	if (_tmp51_) {
		gboolean _tmp52_;
		_tmp52_ = start_service;
		_tmp50_ = _tmp52_;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		g_error ("Corebird.vala:109: Can't stop and start service at the same time.");
	}
	_tmp53_ = stresstest;
	if (_tmp53_) {
		STRESSTEST = TRUE;
	}
	_tmp54_ = stop_service;
	if (_tmp54_) {
		gboolean _tmp55_;
		_tmp55_ = self->priv->started_as_service;
		if (_tmp55_) {
			g_debug ("Corebird.vala:118: Stopping service");
			g_application_release (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
		} else {
			g_warning ("Corebird.vala:122: --stop-service passed, but corebird has not been st" \
"arted as a service");
		}
	} else {
		gboolean _tmp56_;
		_tmp56_ = print_startup_accounts;
		if (_tmp56_) {
			gchar** startup_accounts = NULL;
			GSettings* _tmp57_;
			GSettings* _tmp58_;
			gchar** _tmp59_;
			gchar** _tmp60_;
			gchar** _tmp61_;
			gint _tmp61__length1;
			gint startup_accounts_length1;
			gint _startup_accounts_size_;
			gchar** _tmp62_;
			gint _tmp62__length1;
			_tmp57_ = settings_get ();
			_tmp58_ = _tmp57_;
			_tmp60_ = _tmp59_ = g_settings_get_strv (_tmp58_, "startup-accounts");
			_tmp61_ = _tmp60_;
			_tmp61__length1 = _vala_array_length (_tmp59_);
			_g_object_unref0 (_tmp58_);
			startup_accounts = _tmp61_;
			startup_accounts_length1 = _tmp61__length1;
			_startup_accounts_size_ = startup_accounts_length1;
			_tmp62_ = startup_accounts;
			_tmp62__length1 = startup_accounts_length1;
			{
				gchar** acc_collection = NULL;
				gint acc_collection_length1 = 0;
				gint _acc_collection_size_ = 0;
				gint acc_it = 0;
				acc_collection = _tmp62_;
				acc_collection_length1 = _tmp62__length1;
				for (acc_it = 0; acc_it < _tmp62__length1; acc_it = acc_it + 1) {
					const gchar* acc = NULL;
					acc = acc_collection[acc_it];
					{
						FILE* _tmp63_;
						const gchar* _tmp64_;
						_tmp63_ = stdout;
						_tmp64_ = acc;
						fprintf (_tmp63_, "%s\n", _tmp64_);
					}
				}
			}
			startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
		} else {
			gboolean _tmp65_ = FALSE;
			gboolean _tmp66_;
			_tmp66_ = start_service;
			if (_tmp66_) {
				gboolean _tmp67_;
				_tmp67_ = self->priv->started_as_service;
				_tmp65_ = !_tmp67_;
			} else {
				_tmp65_ = FALSE;
			}
			if (_tmp65_) {
				self->priv->started_as_service = TRUE;
				g_application_activate (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
			} else {
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				_tmp68_ = compose_screen_name;
				_tmp69_ = account_name;
				corebird_open_startup_windows (self, _tmp68_, _tmp69_);
			}
		}
	}
	result = 0;
	_args = (g_free (_args), NULL);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	options = (g_free (options), NULL);
	_g_free0 (account_name);
	_g_free0 (compose_screen_name);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void corebird_real_activate (GApplication* base) {
	Corebird * self;
	gboolean _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	_tmp0_ = self->priv->started_as_service;
	if (_tmp0_) {
		gchar** startup_accounts = NULL;
		GSettings* _tmp1_;
		GSettings* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gint startup_accounts_length1;
		gint _startup_accounts_size_;
		gboolean _tmp6_ = FALSE;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar** _tmp11_;
		gint _tmp11__length1;
		guint n_accounts = 0U;
		guint _tmp12_;
		guint _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		g_application_hold (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
		_tmp1_ = settings_get ();
		_tmp2_ = _tmp1_;
		_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "startup-accounts");
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _vala_array_length (_tmp3_);
		_g_object_unref0 (_tmp2_);
		startup_accounts = _tmp5_;
		startup_accounts_length1 = _tmp5__length1;
		_startup_accounts_size_ = startup_accounts_length1;
		_tmp7_ = startup_accounts;
		_tmp7__length1 = startup_accounts_length1;
		if (_tmp7__length1 == 1) {
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			_tmp8_ = startup_accounts;
			_tmp8__length1 = startup_accounts_length1;
			_tmp9_ = _tmp8_[0];
			_tmp6_ = g_strcmp0 (_tmp9_, "") == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gint _tmp10_;
			_tmp10_ = 0;
			startup_accounts = g_renew (gchar*, startup_accounts, 0);
			(_tmp10_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp10_ - startup_accounts_length1)) : NULL;
			startup_accounts_length1 = _tmp10_;
			_startup_accounts_size_ = _tmp10_;
		}
		_tmp11_ = startup_accounts;
		_tmp11__length1 = startup_accounts_length1;
		g_debug ("Corebird.vala:147: Configured startup accounts: %d", _tmp11__length1);
		_tmp12_ = account_get_n ();
		n_accounts = _tmp12_;
		_tmp13_ = n_accounts;
		g_debug ("Corebird.vala:149: Configured accounts: %u", _tmp13_);
		_tmp14_ = startup_accounts;
		_tmp14__length1 = startup_accounts_length1;
		{
			gchar** screen_name_collection = NULL;
			gint screen_name_collection_length1 = 0;
			gint _screen_name_collection_size_ = 0;
			gint screen_name_it = 0;
			screen_name_collection = _tmp14_;
			screen_name_collection_length1 = _tmp14__length1;
			for (screen_name_it = 0; screen_name_it < _tmp14__length1; screen_name_it = screen_name_it + 1) {
				const gchar* screen_name = NULL;
				screen_name = screen_name_collection[screen_name_it];
				{
					Account* acc = NULL;
					const gchar* _tmp15_;
					Account* _tmp16_;
					Account* _tmp17_;
					Account* _tmp18_;
					_tmp15_ = screen_name;
					_tmp16_ = account_query_account (_tmp15_);
					_tmp17_ = _g_object_ref0 (_tmp16_);
					acc = _tmp17_;
					_tmp18_ = acc;
					if (_tmp18_ != NULL) {
						const gchar* _tmp19_;
						Account* _tmp20_;
						_tmp19_ = screen_name;
						g_debug ("Corebird.vala:154: Service: Starting account %s...", _tmp19_);
						_tmp20_ = acc;
						corebird_start_account (self, _tmp20_);
					} else {
						const gchar* _tmp21_;
						_tmp21_ = screen_name;
						g_warning ("Corebird.vala:157: Invalid startup account: '%s'", _tmp21_);
					}
					_g_object_unref0 (acc);
				}
			}
		}
		startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	} else {
		corebird_open_startup_windows (self, NULL, NULL);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Corebird* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->action);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda194_ (Block1Data* _data1_) {
	Corebird* self;
	gboolean result = FALSE;
	GSimpleAction* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_g_object_unref0 (self->priv->settings_dialog);
	self->priv->settings_dialog = NULL;
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean ___lambda194__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda194_ (self);
	return result;
}


static void corebird_show_settings_activated (Corebird* self) {
	Block1Data* _data1_;
	SettingsDialog* _tmp0_;
	SettingsDialog* dialog = NULL;
	SettingsDialog* _tmp1_;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	SettingsDialog* _tmp5_;
	SettingsDialog* _tmp6_;
	g_return_if_fail (IS_COREBIRD (self));
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->settings_dialog;
	if (_tmp0_ != NULL) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp1_ = settings_dialog_new (self);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	_tmp2_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), "show-settings");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction));
	_data1_->action = _tmp3_;
	_tmp4_ = _data1_->action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	_tmp5_ = dialog;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) ___lambda194__gtk_widget_delete_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp6_ = dialog;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void corebird_about_activated (Corebird* self) {
	GtkWindow* active_window = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	AboutDialog* ad = NULL;
	AboutDialog* _tmp2_;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	active_window = _tmp1_;
	_tmp2_ = about_dialog_new ();
	g_object_ref_sink (_tmp2_);
	ad = _tmp2_;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (ad, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (ad, gtk_window_get_type (), GtkWindow), active_window);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (ad, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ad);
	_g_object_unref0 (active_window);
}


static void corebird_show_shortcuts_activated (Corebird* self) {
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkWindow* shortcuts_window = NULL;
	GObject* _tmp1_;
	GtkWindow* _tmp2_;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = gtk_builder_new_from_resource ("/org/baedert/corebird/ui/shortcuts-window.ui");
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "shortcuts_window");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	shortcuts_window = _tmp2_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (shortcuts_window, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (shortcuts_window);
	_g_object_unref0 (builder);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void corebird_real_startup (GApplication* base) {
	Corebird * self;
	Twitter* _tmp0_;
	Twitter* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	gchar* _tmp39_;
	gchar** _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar* _tmp42_;
	gchar** _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar** _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	gchar* _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	GtkSettings* gtk_s = NULL;
	GtkSettings* _tmp59_;
	GtkSettings* _tmp60_;
	gboolean _tmp61_;
	GtkSettings* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gboolean _tmp67_;
	gboolean _tmp68_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	G_APPLICATION_CLASS (corebird_parent_class)->startup (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	g_application_set_resource_base_path (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication), "/org/baedert/corebird");
	g_type_ensure (TYPE_LAZY_MENU_BUTTON);
	g_type_ensure (TYPE_FAV_IMAGE_VIEW);
	g_debug ("Corebird.vala:207: startup");
	setlocale (LC_ALL, DATADIR "/locale");
	bindtextdomain (GETTEXT_PACKAGE, NULL);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	utils_load_custom_css ();
	utils_load_custom_icons ();
	utils_init_soup_session ();
	_tmp0_ = twitter_get ();
	_tmp1_ = _tmp0_;
	twitter_init (_tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = settings_get_accel ("compose-tweet");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.compose-tweet", _tmp4_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = settings_get_accel ("toggle-sidebar");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.toggle-topbar", _tmp7_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = g_strdup ("<Alt>1");
	_tmp9_ = g_new0 (gchar*, 1 + 1);
	_tmp9_[0] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(0)", _tmp10_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = g_strdup ("<Alt>2");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(1)", _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = g_strdup ("<Alt>3");
	_tmp15_ = g_new0 (gchar*, 1 + 1);
	_tmp15_[0] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(2)", _tmp16_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = g_strdup ("<Alt>4");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(3)", _tmp19_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = g_strdup ("<Alt>5");
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(4)", _tmp22_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = g_strdup ("<Alt>6");
	_tmp24_ = g_new0 (gchar*, 1 + 1);
	_tmp24_[0] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(5)", _tmp25_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = g_strdup ("<Alt>7");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(6)", _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = settings_get_accel ("show-settings");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "app.show-settings", _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_strdup ("<Primary>Q");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "app.quit", _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = g_strdup ("<Primary>question");
	_tmp36_ = g_strdup ("<Primary>F1");
	_tmp37_ = g_new0 (gchar*, 2 + 1);
	_tmp37_[0] = _tmp35_;
	_tmp37_[1] = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp38__length1 = 2;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "app.show-shortcuts", _tmp38_);
	_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
	_tmp39_ = settings_get_accel ("show-account-dialog");
	_tmp40_ = g_new0 (gchar*, 1 + 1);
	_tmp40_[0] = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp41__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.show-account-dialog", _tmp41_);
	_tmp41_ = (_vala_array_free (_tmp41_, _tmp41__length1, (GDestroyNotify) g_free), NULL);
	_tmp42_ = settings_get_accel ("show-account-list");
	_tmp43_ = g_new0 (gchar*, 1 + 1);
	_tmp43_[0] = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp44__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.show-account-list", _tmp44_);
	_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
	_tmp45_ = g_strdup ("<Alt>Left");
	_tmp46_ = g_strdup ("Back");
	_tmp47_ = g_new0 (gchar*, 2 + 1);
	_tmp47_[0] = _tmp45_;
	_tmp47_[1] = _tmp46_;
	_tmp48_ = _tmp47_;
	_tmp48__length1 = 2;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.previous", _tmp48_);
	_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
	_tmp49_ = g_strdup ("<Alt>Right");
	_tmp50_ = g_strdup ("Forward");
	_tmp51_ = g_new0 (gchar*, 2 + 1);
	_tmp51_[0] = _tmp49_;
	_tmp51_[1] = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp52__length1 = 2;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.next", _tmp52_);
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = g_strdup ("r");
	_tmp54_ = g_new0 (gchar*, 1 + 1);
	_tmp54_[0] = _tmp53_;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "tweet.reply", _tmp55_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	_tmp56_ = g_strdup ("f");
	_tmp57_ = g_new0 (gchar*, 1 + 1);
	_tmp57_[0] = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "tweet.favorite", _tmp58_);
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), COREBIRD_app_entries, G_N_ELEMENTS (COREBIRD_app_entries), self);
	_tmp59_ = gtk_settings_get_default ();
	_tmp60_ = _g_object_ref0 (_tmp59_);
	gtk_s = _tmp60_;
	_tmp61_ = settings_use_dark_theme ();
	if (_tmp61_) {
		GtkSettings* _tmp62_;
		_tmp62_ = gtk_s;
		g_object_set (_tmp62_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	}
	_tmp63_ = gtk_s;
	g_object_get (_tmp63_, "gtk-decoration-layout", &_tmp64_, NULL);
	_tmp65_ = _tmp64_;
	_tmp66_ = _tmp65_;
	_tmp67_ = string_contains (_tmp66_, "menu");
	_tmp68_ = _tmp67_;
	_g_free0 (_tmp66_);
	if (_tmp68_) {
		GtkSettings* _tmp69_;
		GtkSettings* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		_tmp69_ = gtk_s;
		_tmp70_ = gtk_s;
		g_object_get (_tmp70_, "gtk-decoration-layout", &_tmp71_, NULL);
		_tmp72_ = _tmp71_;
		_tmp73_ = _tmp72_;
		_tmp74_ = string_replace (_tmp73_, "menu", "");
		_tmp75_ = _tmp74_;
		g_object_set (_tmp69_, "gtk-decoration-layout", _tmp75_, NULL);
		_g_free0 (_tmp75_);
		_g_free0 (_tmp73_);
	}
	_g_object_unref0 (gtk_s);
}


static void corebird_real_shutdown (GApplication* base) {
	Corebird * self;
	CbMediaDownloader* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	_tmp0_ = cb_media_downloader_get_default ();
	cb_media_downloader_shutdown (_tmp0_);
	G_APPLICATION_CLASS (corebird_parent_class)->shutdown (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
}


/**
   * Open startup windows.
   * Semantics: Open a window for every account in the startup-accounts array.
   * If that array is empty, look at all the account and if there is one, open that one.
   * If there is none, open a MainWindow with a null account.
   */
static void corebird_open_startup_windows (Corebird* self, const gchar* compose_screen_name, const gchar* account_name) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp15_;
	gchar** startup_accounts = NULL;
	GSettings* _tmp24_;
	GSettings* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gint startup_accounts_length1;
	gint _startup_accounts_size_;
	gboolean _tmp29_ = FALSE;
	gchar** _tmp30_;
	gint _tmp30__length1;
	guint n_accounts = 0U;
	guint _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp1_ = compose_screen_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = account_name;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		account_name = NULL;
	}
	_tmp3_ = compose_screen_name;
	if (_tmp3_ != NULL) {
		Account* acc = NULL;
		const gchar* _tmp4_;
		Account* _tmp5_;
		Account* _tmp6_;
		Account* _tmp7_;
		Account* _tmp9_;
		Account* _tmp10_;
		ComposeTweetWindow* cw = NULL;
		Account* _tmp11_;
		ComposeTweetWindow* _tmp12_;
		ComposeTweetWindow* _tmp13_;
		ComposeTweetWindow* _tmp14_;
		_tmp4_ = compose_screen_name;
		_tmp5_ = account_query_account (_tmp4_);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		acc = _tmp6_;
		_tmp7_ = acc;
		if (_tmp7_ == NULL) {
			const gchar* _tmp8_;
			_tmp8_ = account_name;
			g_critical ("Corebird.vala:276: No account named `%s` is configured. Exiting.", _tmp8_);
			_g_object_unref0 (acc);
			return;
		}
		_tmp9_ = acc;
		account_init_proxy (_tmp9_, TRUE, FALSE);
		_tmp10_ = acc;
		account_query_user_info_by_screen_name (_tmp10_, NULL, NULL, NULL);
		_tmp11_ = acc;
		_tmp12_ = compose_tweet_window_new (NULL, _tmp11_, NULL, COMPOSE_TWEET_WINDOW_MODE_NORMAL);
		g_object_ref_sink (_tmp12_);
		cw = _tmp12_;
		_tmp13_ = cw;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
		_tmp14_ = cw;
		gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_window_get_type (), GtkWindow));
		_g_object_unref0 (cw);
		_g_object_unref0 (acc);
		return;
	}
	_tmp15_ = account_name;
	if (_tmp15_ != NULL) {
		Account* acc = NULL;
		const gchar* _tmp16_;
		Account* _tmp17_;
		Account* _tmp18_;
		Account* _tmp19_;
		Account* _tmp21_;
		Account* _tmp22_;
		Account* _tmp23_;
		_tmp16_ = account_name;
		_tmp17_ = account_query_account (_tmp16_);
		_tmp18_ = _g_object_ref0 (_tmp17_);
		acc = _tmp18_;
		_tmp19_ = acc;
		if (_tmp19_ == NULL) {
			const gchar* _tmp20_;
			_tmp20_ = account_name;
			g_critical ("Corebird.vala:292: No account named `%s` is configured. Exiting.", _tmp20_);
			_g_object_unref0 (acc);
			return;
		}
		_tmp21_ = acc;
		account_init_proxy (_tmp21_, TRUE, FALSE);
		_tmp22_ = acc;
		account_query_user_info_by_screen_name (_tmp22_, NULL, NULL, NULL);
		_tmp23_ = acc;
		corebird_add_window_for_account (self, _tmp23_);
		_g_object_unref0 (acc);
		return;
	}
	_tmp24_ = settings_get ();
	_tmp25_ = _tmp24_;
	_tmp27_ = _tmp26_ = g_settings_get_strv (_tmp25_, "startup-accounts");
	_tmp28_ = _tmp27_;
	_tmp28__length1 = _vala_array_length (_tmp26_);
	_g_object_unref0 (_tmp25_);
	startup_accounts = _tmp28_;
	startup_accounts_length1 = _tmp28__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp30_ = startup_accounts;
	_tmp30__length1 = startup_accounts_length1;
	if (_tmp30__length1 == 1) {
		gchar** _tmp31_;
		gint _tmp31__length1;
		const gchar* _tmp32_;
		_tmp31_ = startup_accounts;
		_tmp31__length1 = startup_accounts_length1;
		_tmp32_ = _tmp31_[0];
		_tmp29_ = g_strcmp0 (_tmp32_, "") == 0;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		gint _tmp33_;
		_tmp33_ = 0;
		startup_accounts = g_renew (gchar*, startup_accounts, 0);
		(_tmp33_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp33_ - startup_accounts_length1)) : NULL;
		startup_accounts_length1 = _tmp33_;
		_startup_accounts_size_ = _tmp33_;
	}
	_tmp34_ = account_get_n ();
	n_accounts = _tmp34_;
	_tmp35_ = startup_accounts;
	_tmp35__length1 = startup_accounts_length1;
	if (_tmp35__length1 == 0) {
		guint _tmp36_;
		_tmp36_ = n_accounts;
		if (_tmp36_ == ((guint) 1)) {
			Account* _tmp37_;
			Account* _tmp38_;
			const gchar* _tmp39_;
			_tmp37_ = account_get_nth ((guint) 0);
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp38_->screen_name;
			corebird_add_window_for_screen_name (self, _tmp39_);
			_g_object_unref0 (_tmp38_);
		} else {
			guint _tmp40_;
			_tmp40_ = n_accounts;
			if (_tmp40_ == ((guint) 0)) {
				MainWindow* window = NULL;
				MainWindow* _tmp41_;
				MainWindow* _tmp42_;
				MainWindow* _tmp43_;
				_tmp41_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), NULL);
				g_object_ref_sink (_tmp41_);
				window = _tmp41_;
				_tmp42_ = window;
				gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_window_get_type (), GtkWindow));
				_tmp43_ = window;
				gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (window);
			} else {
				Account* _tmp44_;
				Account* _tmp45_;
				const gchar* _tmp46_;
				_tmp44_ = account_get_nth ((guint) 0);
				_tmp45_ = _tmp44_;
				_tmp46_ = _tmp45_->screen_name;
				corebird_add_window_for_screen_name (self, _tmp46_);
				_g_object_unref0 (_tmp45_);
			}
		}
	} else {
		gboolean opened_window = FALSE;
		gchar** _tmp47_;
		gint _tmp47__length1;
		gboolean _tmp52_;
		opened_window = FALSE;
		_tmp47_ = startup_accounts;
		_tmp47__length1 = startup_accounts_length1;
		{
			gchar** account_collection = NULL;
			gint account_collection_length1 = 0;
			gint _account_collection_size_ = 0;
			gint account_it = 0;
			account_collection = _tmp47_;
			account_collection_length1 = _tmp47__length1;
			for (account_it = 0; account_it < _tmp47__length1; account_it = account_it + 1) {
				const gchar* account = NULL;
				account = account_collection[account_it];
				{
					const gchar* _tmp48_;
					gboolean _tmp49_;
					_tmp48_ = account;
					_tmp49_ = corebird_is_window_open_for_screen_name (self, _tmp48_, NULL);
					if (!_tmp49_) {
						const gchar* _tmp50_;
						gboolean _tmp51_;
						_tmp50_ = account;
						_tmp51_ = corebird_add_window_for_screen_name (self, _tmp50_);
						if (_tmp51_) {
							opened_window = TRUE;
						}
					}
				}
			}
		}
		_tmp52_ = opened_window;
		if (!_tmp52_) {
			guint _tmp53_;
			GList* _tmp64_;
			MainWindow* m = NULL;
			MainWindow* _tmp69_;
			MainWindow* _tmp70_;
			MainWindow* _tmp71_;
			_tmp53_ = n_accounts;
			if (_tmp53_ > ((guint) 0)) {
				{
					guint i = 0U;
					i = (guint) 0;
					{
						gboolean _tmp54_ = FALSE;
						_tmp54_ = TRUE;
						while (TRUE) {
							guint _tmp56_;
							guint _tmp57_;
							Account* account = NULL;
							guint _tmp58_;
							Account* _tmp59_;
							Account* _tmp60_;
							gint64 _tmp61_;
							gboolean _tmp62_;
							if (!_tmp54_) {
								guint _tmp55_;
								_tmp55_ = i;
								i = _tmp55_ + 1;
							}
							_tmp54_ = FALSE;
							_tmp56_ = i;
							_tmp57_ = account_get_n ();
							if (!(_tmp56_ < _tmp57_)) {
								break;
							}
							_tmp58_ = i;
							_tmp59_ = account_get_nth (_tmp58_);
							account = _tmp59_;
							_tmp60_ = account;
							_tmp61_ = _tmp60_->id;
							_tmp62_ = corebird_is_window_open_for_user_id (self, _tmp61_, NULL);
							if (!_tmp62_) {
								Account* _tmp63_;
								_tmp63_ = account;
								corebird_add_window_for_account (self, _tmp63_);
								_g_object_unref0 (account);
								startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
								return;
							}
							_g_object_unref0 (account);
						}
					}
				}
			}
			_tmp64_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
			{
				GList* w_collection = NULL;
				GList* w_it = NULL;
				w_collection = _tmp64_;
				for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
					GtkWindow* _tmp65_;
					GtkWindow* w = NULL;
					_tmp65_ = _g_object_ref0 ((GtkWindow*) w_it->data);
					w = _tmp65_;
					{
						GtkWindow* _tmp66_;
						Account* _tmp67_;
						const gchar* _tmp68_;
						_tmp66_ = w;
						_tmp67_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, TYPE_MAIN_WINDOW, MainWindow)->account;
						_tmp68_ = _tmp67_->screen_name;
						if (g_strcmp0 (_tmp68_, ACCOUNT_DUMMY) == 0) {
							_g_object_unref0 (w);
							startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
							return;
						}
						_g_object_unref0 (w);
					}
				}
			}
			_tmp69_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), NULL);
			g_object_ref_sink (_tmp69_);
			m = _tmp69_;
			_tmp70_ = m;
			gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, gtk_window_get_type (), GtkWindow));
			_tmp71_ = m;
			gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (m);
		}
	}
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


/**
   * Adds a new MainWindow instance with the account that
   * has the given screen name.
   * Note that this only works if the account is already properly
   * set up and won't warn or fail if if isn't.
   *
   * @param screen_name The screen name of the account to add a
   *                    MainWindow for.
   *
   * @return true if a window has been opened, false otherwise
   */
gboolean corebird_add_window_for_screen_name (Corebird* self, const gchar* screen_name) {
	gboolean result = FALSE;
	Account* acc = NULL;
	const gchar* _tmp0_;
	Account* _tmp1_;
	Account* _tmp2_;
	Account* _tmp3_;
	const gchar* _tmp5_;
	g_return_val_if_fail (IS_COREBIRD (self), FALSE);
	g_return_val_if_fail (screen_name != NULL, FALSE);
	_tmp0_ = screen_name;
	_tmp1_ = account_query_account (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	acc = _tmp2_;
	_tmp3_ = acc;
	if (_tmp3_ != NULL) {
		Account* _tmp4_;
		_tmp4_ = acc;
		corebird_add_window_for_account (self, _tmp4_);
		result = TRUE;
		_g_object_unref0 (acc);
		return result;
	}
	_tmp5_ = screen_name;
	g_warning ("Corebird.vala:376: Could not add window for account '%s'", _tmp5_);
	result = FALSE;
	_g_object_unref0 (acc);
	return result;
}


void corebird_add_window_for_account (Corebird* self, Account* account) {
	MainWindow* window = NULL;
	Account* _tmp0_;
	MainWindow* _tmp1_;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	_tmp1_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp0_);
	g_object_ref_sink (_tmp1_);
	window = _tmp1_;
	gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (window, gtk_window_get_type (), GtkWindow));
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (window, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (window);
}


/**
   * Checks if there's currently a MainWindow instance open that has a
   * reference to the account with the given screen name.
   * (This makes a linear search over all open windows, with a text comparison
   * in each iteration)
   *
   * @param screen_name The screen name to search for
   * @return TRUE if a window with the account associated to the given
   *         screen name is open, FALSE otherwise.
   */
gboolean corebird_is_window_open_for_screen_name (Corebird* self, const gchar* screen_name, MainWindow* * window) {
	MainWindow* _vala_window = NULL;
	gboolean result = FALSE;
	GList* windows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_val_if_fail (IS_COREBIRD (self), FALSE);
	g_return_val_if_fail (screen_name != NULL, FALSE);
	_tmp0_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	windows = _tmp0_;
	_tmp1_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp1_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp2_;
			GtkWindow* win = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp2_;
			{
				GtkWindow* _tmp3_;
				_tmp3_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp4_;
					Account* _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					_tmp4_ = win;
					_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp6_ = _tmp5_->screen_name;
					_tmp7_ = screen_name;
					if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
						GtkWindow* _tmp8_;
						MainWindow* _tmp9_;
						_tmp8_ = win;
						_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MAIN_WINDOW, MainWindow));
						_g_object_unref0 (_vala_window);
						_vala_window = _tmp9_;
						result = TRUE;
						_g_object_unref0 (win);
						if (window) {
							*window = _vala_window;
						} else {
							_g_object_unref0 (_vala_window);
						}
						return result;
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
	_g_object_unref0 (_vala_window);
	_vala_window = NULL;
	result = FALSE;
	if (window) {
		*window = _vala_window;
	} else {
		_g_object_unref0 (_vala_window);
	}
	return result;
}


gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow* * window) {
	MainWindow* _vala_window = NULL;
	gboolean result = FALSE;
	GList* windows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_val_if_fail (IS_COREBIRD (self), FALSE);
	_tmp0_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	windows = _tmp0_;
	_tmp1_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp1_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp2_;
			GtkWindow* win = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp2_;
			{
				GtkWindow* _tmp3_;
				_tmp3_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp4_;
					Account* _tmp5_;
					gint64 _tmp6_;
					gint64 _tmp7_;
					_tmp4_ = win;
					_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp6_ = _tmp5_->id;
					_tmp7_ = user_id;
					if (_tmp6_ == _tmp7_) {
						GtkWindow* _tmp8_;
						MainWindow* _tmp9_;
						_tmp8_ = win;
						_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MAIN_WINDOW, MainWindow));
						_g_object_unref0 (_vala_window);
						_vala_window = _tmp9_;
						result = TRUE;
						_g_object_unref0 (win);
						if (window) {
							*window = _vala_window;
						} else {
							_g_object_unref0 (_vala_window);
						}
						return result;
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
	_g_object_unref0 (_vala_window);
	_vala_window = NULL;
	result = FALSE;
	if (window) {
		*window = _vala_window;
	} else {
		_g_object_unref0 (_vala_window);
	}
	return result;
}


/**
   * Quits the application, saving all open windows and their geometries.
   */
static void corebird_quit_application (Corebird* self) {
	GList* windows = NULL;
	GList* _tmp0_;
	gchar** startup_accounts = NULL;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint startup_accounts_length1;
	gint _startup_accounts_size_;
	gboolean _tmp6_ = FALSE;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** account_names = NULL;
	GList* _tmp12_;
	guint _tmp13_;
	gchar** _tmp14_;
	gint account_names_length1;
	gint _account_names_size_;
	gint index = 0;
	GList* _tmp15_;
	gint _tmp30_;
	gint _tmp31_;
	GSettings* _tmp32_;
	GSettings* _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	windows = _tmp0_;
	_tmp1_ = settings_get ();
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "startup-accounts");
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_object_unref0 (_tmp2_);
	startup_accounts = _tmp5_;
	startup_accounts_length1 = _tmp5__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp7_ = startup_accounts;
	_tmp7__length1 = startup_accounts_length1;
	if (_tmp7__length1 == 1) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp8_ = startup_accounts;
		_tmp8__length1 = startup_accounts_length1;
		_tmp9_ = _tmp8_[0];
		_tmp6_ = g_strcmp0 (_tmp9_, "") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp10_;
		_tmp10_ = 0;
		startup_accounts = g_renew (gchar*, startup_accounts, 0);
		(_tmp10_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp10_ - startup_accounts_length1)) : NULL;
		startup_accounts_length1 = _tmp10_;
		_startup_accounts_size_ = _tmp10_;
	}
	_tmp11_ = startup_accounts;
	_tmp11__length1 = startup_accounts_length1;
	if (_tmp11__length1 != 0) {
		g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
		startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp12_ = windows;
	_tmp13_ = g_list_length (_tmp12_);
	_tmp14_ = g_new0 (gchar*, _tmp13_ + 1);
	account_names = _tmp14_;
	account_names_length1 = _tmp13_;
	_account_names_size_ = account_names_length1;
	index = 0;
	_tmp15_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp15_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* win = NULL;
			win = (GtkWindow*) win_it->data;
			{
				GtkWindow* _tmp16_;
				MainWindow* mw = NULL;
				GtkWindow* _tmp17_;
				MainWindow* _tmp18_;
				gchar* screen_name = NULL;
				MainWindow* _tmp19_;
				Account* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				MainWindow* _tmp23_;
				gchar** _tmp24_;
				gint _tmp24__length1;
				gint _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gint _tmp29_;
				_tmp16_ = win;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_MAIN_WINDOW)) {
					continue;
				}
				_tmp17_ = win;
				_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MAIN_WINDOW, MainWindow));
				mw = _tmp18_;
				_tmp19_ = mw;
				_tmp20_ = _tmp19_->account;
				_tmp21_ = _tmp20_->screen_name;
				_tmp22_ = g_strdup (_tmp21_);
				screen_name = _tmp22_;
				_tmp23_ = mw;
				main_window_save_geometry (_tmp23_);
				_tmp24_ = account_names;
				_tmp24__length1 = account_names_length1;
				_tmp25_ = index;
				_tmp26_ = screen_name;
				_tmp27_ = g_strdup (_tmp26_);
				_g_free0 (_tmp24_[_tmp25_]);
				_tmp24_[_tmp25_] = _tmp27_;
				_tmp28_ = _tmp24_[_tmp25_];
				_tmp29_ = index;
				index = _tmp29_ + 1;
				_g_free0 (screen_name);
				_g_object_unref0 (mw);
			}
		}
	}
	_tmp30_ = index;
	_tmp31_ = _tmp30_ + 1;
	account_names = g_renew (gchar*, account_names, _tmp30_ + 1);
	(_tmp31_ > account_names_length1) ? memset (account_names + account_names_length1, 0, sizeof (gchar*) * (_tmp31_ - account_names_length1)) : NULL;
	account_names_length1 = _tmp31_;
	_account_names_size_ = _tmp31_;
	_tmp32_ = settings_get ();
	_tmp33_ = _tmp32_;
	_tmp34_ = account_names;
	_tmp34__length1 = account_names_length1;
	g_settings_set_strv (_tmp33_, "startup-accounts", _tmp34_);
	_g_object_unref0 (_tmp33_);
	g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	account_names = (_vala_array_free (account_names, account_names_length1, (GDestroyNotify) g_free), NULL);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


void corebird_start_account (Corebird* self, Account* acc) {
	Account* _tmp14_;
	Account* _tmp15_;
	CbUserStream* _tmp16_;
	Account* _tmp17_;
	GPtrArray* _tmp18_;
	Account* _tmp19_;
	Account* _tmp20_;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (IS_ACCOUNT (acc));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				Account* account = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				Account* _tmp9_;
				Account* _tmp10_;
				Account* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->active_accounts;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->active_accounts;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((Account*) _tmp8_);
				account = _tmp9_;
				_tmp10_ = acc;
				_tmp11_ = account;
				if (_tmp10_ == _tmp11_) {
					Account* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = acc;
					_tmp13_ = _tmp12_->screen_name;
					g_debug ("Corebird.vala:462: Account %s is already active", _tmp13_);
					_g_object_unref0 (account);
					return;
				}
				_g_object_unref0 (account);
			}
		}
	}
	_tmp14_ = acc;
	account_init_proxy (_tmp14_, TRUE, FALSE);
	_tmp15_ = acc;
	_tmp16_ = _tmp15_->user_stream;
	cb_user_stream_start (_tmp16_);
	_tmp17_ = acc;
	account_init_information (_tmp17_, NULL, NULL);
	_tmp18_ = self->priv->active_accounts;
	_tmp19_ = acc;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	g_ptr_array_add (_tmp18_, _tmp20_);
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


void corebird_stop_account (Corebird* self, Account* acc) {
	gboolean found = FALSE;
	gboolean _tmp12_;
	gchar** startup_accounts = NULL;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gint startup_accounts_length1;
	gint _startup_accounts_size_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (IS_ACCOUNT (acc));
	found = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				Account* account = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				Account* _tmp9_;
				Account* _tmp10_;
				Account* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->active_accounts;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->active_accounts;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((Account*) _tmp8_);
				account = _tmp9_;
				_tmp10_ = account;
				_tmp11_ = acc;
				if (_tmp10_ == _tmp11_) {
					found = TRUE;
					_g_object_unref0 (account);
					break;
				}
				_g_object_unref0 (account);
			}
		}
	}
	_tmp12_ = found;
	if (!_tmp12_) {
		Account* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = acc;
		_tmp14_ = _tmp13_->screen_name;
		g_warning ("Corebird.vala:485: Can't stop account %s since it's not in the list of" \
" active accounts", _tmp14_);
		return;
	}
	_tmp15_ = settings_get ();
	_tmp16_ = _tmp15_;
	_tmp18_ = _tmp17_ = g_settings_get_strv (_tmp16_, "startup-accounts");
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _vala_array_length (_tmp17_);
	_g_object_unref0 (_tmp16_);
	startup_accounts = _tmp19_;
	startup_accounts_length1 = _tmp19__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp21_ = self->priv->started_as_service;
	if (_tmp21_) {
		Account* _tmp22_;
		const gchar* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		_tmp22_ = acc;
		_tmp23_ = _tmp22_->screen_name;
		_tmp24_ = startup_accounts;
		_tmp24__length1 = startup_accounts_length1;
		_tmp20_ = _vala_string_array_contains (_tmp24_, _tmp24__length1, _tmp23_);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
	} else {
		Account* _tmp25_;
		GPtrArray* _tmp26_;
		Account* _tmp27_;
		_tmp25_ = acc;
		account_uninit (_tmp25_);
		_tmp26_ = self->priv->active_accounts;
		_tmp27_ = acc;
		g_ptr_array_remove (_tmp26_, _tmp27_);
	}
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


/********************************************************/
static void corebird_show_dm_thread (Corebird* self, GSimpleAction* a, GVariant* value) {
	gint64 account_id = 0LL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 sender_id = 0LL;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	MainWindow* main_window = NULL;
	gint64 _tmp10_;
	MainWindow* _tmp11_ = NULL;
	gboolean _tmp12_;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = value;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_int64 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	account_id = _tmp4_;
	_tmp5_ = value;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_int64 (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	sender_id = _tmp9_;
	_tmp10_ = account_id;
	_tmp12_ = corebird_is_window_open_for_user_id (self, _tmp10_, &_tmp11_);
	_g_object_unref0 (main_window);
	main_window = _tmp11_;
	if (_tmp12_) {
		CbBundle* bundle = NULL;
		CbBundle* _tmp13_;
		CbBundle* _tmp14_;
		gint64 _tmp15_;
		MainWindow* _tmp16_;
		MainWidget* _tmp17_;
		CbBundle* _tmp18_;
		MainWindow* _tmp19_;
		_tmp13_ = cb_bundle_new ();
		bundle = _tmp13_;
		_tmp14_ = bundle;
		_tmp15_ = sender_id;
		cb_bundle_put_int64 (_tmp14_, DM_PAGE_KEY_SENDER_ID, _tmp15_);
		_tmp16_ = main_window;
		_tmp17_ = _tmp16_->main_widget;
		_tmp18_ = bundle;
		main_widget_switch_page (_tmp17_, (gint) PAGE_DM, _tmp18_);
		_tmp19_ = main_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_window_get_type (), GtkWindow));
		_g_object_unref0 (bundle);
	} else {
		Account* account = NULL;
		gint64 _tmp20_;
		Account* _tmp21_;
		Account* _tmp22_;
		Account* _tmp23_;
		Account* _tmp27_;
		MainWindow* _tmp28_;
		MainWindow* _tmp29_;
		CbBundle* bundle = NULL;
		CbBundle* _tmp30_;
		CbBundle* _tmp31_;
		gint64 _tmp32_;
		MainWindow* _tmp33_;
		MainWidget* _tmp34_;
		CbBundle* _tmp35_;
		MainWindow* _tmp36_;
		_tmp20_ = account_id;
		_tmp21_ = account_query_account_by_id (_tmp20_);
		_tmp22_ = _g_object_ref0 (_tmp21_);
		account = _tmp22_;
		_tmp23_ = account;
		if (_tmp23_ == NULL) {
			gint64 _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp24_ = account_id;
			_tmp25_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp24_);
			_tmp26_ = _tmp25_;
			g_critical ("Corebird.vala:517: No account with id %s found", _tmp26_);
			_g_free0 (_tmp26_);
			_g_object_unref0 (account);
			_g_object_unref0 (main_window);
			return;
		}
		_tmp27_ = account;
		_tmp28_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp27_);
		g_object_ref_sink (_tmp28_);
		_g_object_unref0 (main_window);
		main_window = _tmp28_;
		_tmp29_ = main_window;
		gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_window_get_type (), GtkWindow));
		_tmp30_ = cb_bundle_new ();
		bundle = _tmp30_;
		_tmp31_ = bundle;
		_tmp32_ = sender_id;
		cb_bundle_put_int64 (_tmp31_, DM_PAGE_KEY_SENDER_ID, _tmp32_);
		_tmp33_ = main_window;
		_tmp34_ = _tmp33_->main_widget;
		_tmp35_ = bundle;
		main_widget_switch_page (_tmp34_, (gint) PAGE_DM, _tmp35_);
		_tmp36_ = main_window;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (bundle);
		_g_object_unref0 (account);
	}
	_g_object_unref0 (main_window);
}


static void corebird_show_window (Corebird* self, GSimpleAction* a, GVariant* value) {
	gint64 user_id = 0LL;
	GVariant* _tmp0_;
	gint64 _tmp1_;
	MainWindow* main_window = NULL;
	gint64 _tmp2_;
	MainWindow* _tmp3_ = NULL;
	gboolean _tmp4_;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = value;
	_tmp1_ = g_variant_get_int64 (_tmp0_);
	user_id = _tmp1_;
	_tmp2_ = user_id;
	_tmp4_ = corebird_is_window_open_for_user_id (self, _tmp2_, &_tmp3_);
	_g_object_unref0 (main_window);
	main_window = _tmp3_;
	if (_tmp4_) {
		MainWindow* _tmp5_;
		_tmp5_ = main_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow));
	} else {
		Account* account = NULL;
		gint64 _tmp6_;
		Account* _tmp7_;
		Account* _tmp8_;
		Account* _tmp9_;
		Account* _tmp13_;
		MainWindow* _tmp14_;
		MainWindow* _tmp15_;
		MainWindow* _tmp16_;
		_tmp6_ = user_id;
		_tmp7_ = account_query_account_by_id (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		account = _tmp8_;
		_tmp9_ = account;
		if (_tmp9_ == NULL) {
			gint64 _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = user_id;
			_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_);
			_tmp12_ = _tmp11_;
			g_critical ("Corebird.vala:539: No account with id %s found", _tmp12_);
			_g_free0 (_tmp12_);
			_g_object_unref0 (account);
			_g_object_unref0 (main_window);
			return;
		}
		_tmp13_ = account;
		_tmp14_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp13_);
		g_object_ref_sink (_tmp14_);
		_g_object_unref0 (main_window);
		main_window = _tmp14_;
		_tmp15_ = main_window;
		gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_window_get_type (), GtkWindow));
		_tmp16_ = main_window;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (account);
	}
	_g_object_unref0 (main_window);
}


static void corebird_mark_read_activated (Corebird* self, GSimpleAction* a, GVariant* v) {
	gint64 account_id = 0LL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 tweet_id = 0LL;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	MainWindow* main_window = NULL;
	gint64 _tmp10_;
	MainWindow* _tmp11_ = NULL;
	gboolean _tmp12_;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = v;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_int64 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	account_id = _tmp4_;
	_tmp5_ = v;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_int64 (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	tweet_id = _tmp9_;
	_tmp10_ = account_id;
	_tmp12_ = corebird_is_window_open_for_user_id (self, _tmp10_, &_tmp11_);
	_g_object_unref0 (main_window);
	main_window = _tmp11_;
	if (_tmp12_) {
		MainWindow* _tmp13_;
		gint64 _tmp14_;
		_tmp13_ = main_window;
		_tmp14_ = tweet_id;
		main_window_mark_tweet_as_read (_tmp13_, _tmp14_);
	}
	_g_object_unref0 (main_window);
}


static void corebird_reply_to_tweet_activated (Corebird* self, GSimpleAction* a, GVariant* v) {
	gint64 account_id = 0LL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 tweet_id = 0LL;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	MainWindow* main_window = NULL;
	gint64 _tmp10_;
	MainWindow* _tmp11_ = NULL;
	gboolean _tmp12_;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = v;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_int64 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	account_id = _tmp4_;
	_tmp5_ = v;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_int64 (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	tweet_id = _tmp9_;
	_tmp10_ = account_id;
	_tmp12_ = corebird_is_window_open_for_user_id (self, _tmp10_, &_tmp11_);
	_g_object_unref0 (main_window);
	main_window = _tmp11_;
	if (_tmp12_) {
		MainWindow* _tmp13_;
		gint64 _tmp14_;
		MainWindow* _tmp15_;
		_tmp13_ = main_window;
		_tmp14_ = tweet_id;
		main_window_reply_to_tweet (_tmp13_, _tmp14_);
		_tmp15_ = main_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_window_get_type (), GtkWindow));
	}
	_g_object_unref0 (main_window);
}


static void g_cclosure_user_marshal_VOID__POINTER_INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT64) (gpointer data1, gpointer arg_1, gint64 arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int64 (param_values + 2), data2);
}


static void corebird_class_init (CorebirdClass * klass) {
	corebird_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CorebirdPrivate));
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication *, GApplicationCommandLine*)) corebird_real_command_line;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) corebird_real_activate;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) corebird_real_startup;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) corebird_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = corebird_finalize;
	corebird_signals[COREBIRD_ACCOUNT_ADDED_SIGNAL] = g_signal_new ("account_added", TYPE_COREBIRD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_ACCOUNT);
	corebird_signals[COREBIRD_ACCOUNT_REMOVED_SIGNAL] = g_signal_new ("account_removed", TYPE_COREBIRD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_ACCOUNT);
	corebird_signals[COREBIRD_ACCOUNT_WINDOW_CHANGED_SIGNAL] = g_signal_new ("account_window_changed", TYPE_COREBIRD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT64, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_INT64);
}


static void corebird_instance_init (Corebird * self) {
	self->priv = COREBIRD_GET_PRIVATE (self);
	self->priv->settings_dialog = NULL;
	self->priv->started_as_service = FALSE;
}


static void corebird_finalize (GObject * obj) {
	Corebird * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COREBIRD, Corebird);
	_g_object_unref0 (self->priv->settings_dialog);
	_g_ptr_array_unref0 (self->priv->active_accounts);
	G_OBJECT_CLASS (corebird_parent_class)->finalize (obj);
}


GType corebird_get_type (void) {
	static volatile gsize corebird_type_id__volatile = 0;
	if (g_once_init_enter (&corebird_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CorebirdClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) corebird_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Corebird), 0, (GInstanceInitFunc) corebird_instance_init, NULL };
		GType corebird_type_id;
		corebird_type_id = g_type_register_static (gtk_application_get_type (), "Corebird", &g_define_type_info, 0);
		g_once_init_leave (&corebird_type_id__volatile, corebird_type_id);
	}
	return corebird_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



