/* AspectImage.c generated by valac 0.36.4, the Vala compiler
 * generated from AspectImage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_ASPECT_IMAGE (aspect_image_get_type ())
#define ASPECT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASPECT_IMAGE, AspectImage))
#define ASPECT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASPECT_IMAGE, AspectImageClass))
#define IS_ASPECT_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASPECT_IMAGE))
#define IS_ASPECT_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASPECT_IMAGE))
#define ASPECT_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASPECT_IMAGE, AspectImageClass))

typedef struct _AspectImage AspectImage;
typedef struct _AspectImageClass AspectImageClass;
typedef struct _AspectImagePrivate AspectImagePrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _AspectImage {
	GtkWidget parent_instance;
	AspectImagePrivate * priv;
};

struct _AspectImageClass {
	GtkWidgetClass parent_class;
};

struct _AspectImagePrivate {
	GdkRGBA bg_color;
	cairo_surface_t* old_surface;
	cairo_surface_t* pixbuf_surface;
	gdouble alpha;
	gint64 start_time;
	gboolean in_transition;
};


static gpointer aspect_image_parent_class = NULL;
extern GdkPixbuf* twitter_no_banner;

GType aspect_image_get_type (void) G_GNUC_CONST;
#define ASPECT_IMAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASPECT_IMAGE, AspectImagePrivate))
enum  {
	ASPECT_IMAGE_DUMMY_PROPERTY,
	ASPECT_IMAGE_PIXBUF,
	ASPECT_IMAGE_COLOR_STRING
};
AspectImage* aspect_image_new (void);
AspectImage* aspect_image_construct (GType object_type);
static void aspect_image_start_animation (AspectImage* self);
static gboolean aspect_image_fade_in_cb (AspectImage* self, GtkWidget* widget, GdkFrameClock* frame_clock);
static gboolean _aspect_image_fade_in_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
#define TRANSITION_DURATION (200 * 1000)
gdouble ease_out_cubic (gdouble t);
static void aspect_image_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min_height, gint* nat_height);
static GtkSizeRequestMode aspect_image_real_get_request_mode (GtkWidget* base);
static gboolean aspect_image_real_draw (GtkWidget* base, cairo_t* ct);
void aspect_image_set_pixbuf (AspectImage* self, GdkPixbuf* value);
void aspect_image_set_color_string (AspectImage* self, const gchar* value);
static GObject * aspect_image_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void aspect_image_finalize (GObject * obj);
static void _vala_aspect_image_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


AspectImage* aspect_image_construct (GType object_type) {
	AspectImage * self = NULL;
	self = (AspectImage*) gtk_widget_new (object_type, NULL);
	return self;
}


AspectImage* aspect_image_new (void) {
	return aspect_image_construct (TYPE_ASPECT_IMAGE);
}


static gboolean _aspect_image_fade_in_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = aspect_image_fade_in_cb ((AspectImage*) self, widget, frame_clock);
	return result;
}


static void aspect_image_start_animation (AspectImage* self) {
	gboolean _tmp0_;
	GdkFrameClock* _tmp1_;
	gint64 _tmp2_;
	g_return_if_fail (IS_ASPECT_IMAGE (self));
	_tmp0_ = gtk_widget_get_realized (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		return;
	}
	self->priv->alpha = 0.0;
	self->priv->in_transition = TRUE;
	_tmp1_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = gdk_frame_clock_get_frame_time (_tmp1_);
	self->priv->start_time = _tmp2_;
	gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _aspect_image_fade_in_cb_gtk_tick_callback, g_object_ref (self), g_object_unref);
}


static gboolean aspect_image_fade_in_cb (AspectImage* self, GtkWidget* widget, GdkFrameClock* frame_clock) {
	gboolean result = FALSE;
	gint64 now = 0LL;
	GdkFrameClock* _tmp0_;
	gint64 _tmp1_;
	gdouble t = 0.0;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_val_if_fail (IS_ASPECT_IMAGE (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	g_return_val_if_fail (GDK_IS_FRAME_CLOCK (frame_clock), FALSE);
	_tmp0_ = frame_clock;
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = self->priv->start_time;
	t = ((gdouble) (_tmp2_ - _tmp3_)) / TRANSITION_DURATION;
	_tmp4_ = t;
	if (_tmp4_ >= 1.0) {
		t = 1.0;
		self->priv->in_transition = FALSE;
	}
	_tmp5_ = t;
	_tmp6_ = ease_out_cubic (_tmp5_);
	self->priv->alpha = _tmp6_;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = t;
	result = _tmp7_ < 1.0;
	return result;
}


static void aspect_image_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min_height, gint* nat_height) {
	AspectImage * self;
	gint _vala_min_height = 0;
	gint _vala_nat_height = 0;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	gint _tmp2_;
	cairo_surface_t* _tmp3_;
	gint _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ASPECT_IMAGE, AspectImage);
	_tmp0_ = self->priv->pixbuf_surface;
	if (_tmp0_ == NULL) {
		_vala_min_height = 0;
		_vala_nat_height = 1;
		if (min_height) {
			*min_height = _vala_min_height;
		}
		if (nat_height) {
			*nat_height = _vala_nat_height;
		}
		return;
	}
	_tmp1_ = self->priv->pixbuf_surface;
	_tmp2_ = cairo_image_surface_get_height (_tmp1_);
	_vala_min_height = _tmp2_;
	_tmp3_ = self->priv->pixbuf_surface;
	_tmp4_ = cairo_image_surface_get_height (_tmp3_);
	_vala_nat_height = _tmp4_;
	if (min_height) {
		*min_height = _vala_min_height;
	}
	if (nat_height) {
		*nat_height = _vala_nat_height;
	}
}


static GtkSizeRequestMode aspect_image_real_get_request_mode (GtkWidget* base) {
	AspectImage * self;
	GtkSizeRequestMode result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ASPECT_IMAGE, AspectImage);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static gboolean aspect_image_real_draw (GtkWidget* base, cairo_t* ct) {
	AspectImage * self;
	gboolean result = FALSE;
	gint width = 0;
	gint _tmp0_;
	gint height = 0;
	gint _tmp1_;
	gdouble scale_x = 0.0;
	GdkRGBA _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	cairo_t* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	cairo_t* _tmp12_;
	gdouble _tmp13_;
	cairo_t* _tmp14_;
	cairo_surface_t* _tmp15_;
	GdkRGBA _tmp31_;
	gdouble _tmp32_;
	gboolean _tmp49_;
	cairo_t* _tmp53_;
	cairo_t* _tmp54_;
	cairo_t* _tmp55_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ASPECT_IMAGE, AspectImage);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	height = _tmp1_;
	scale_x = 1.0;
	_tmp2_ = self->priv->bg_color;
	_tmp3_ = _tmp2_.alpha;
	if (_tmp3_ == 0.0) {
		gint _tmp4_;
		cairo_surface_t* _tmp5_;
		gint _tmp6_;
		_tmp4_ = width;
		_tmp5_ = self->priv->pixbuf_surface;
		_tmp6_ = cairo_image_surface_get_width (_tmp5_);
		scale_x = _tmp4_ / ((gdouble) _tmp6_);
	}
	_tmp7_ = scale_x;
	_tmp8_ = MAX (_tmp7_, 1.0);
	scale_x = _tmp8_;
	_tmp9_ = ct;
	_tmp10_ = width;
	_tmp11_ = height;
	cairo_rectangle (_tmp9_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp10_, (gdouble) _tmp11_);
	_tmp12_ = ct;
	_tmp13_ = scale_x;
	cairo_scale (_tmp12_, _tmp13_, 1.0);
	_tmp14_ = ct;
	cairo_push_group (_tmp14_);
	_tmp15_ = self->priv->old_surface;
	if (_tmp15_ != NULL) {
		cairo_t* _tmp16_;
		cairo_surface_t* _tmp17_;
		cairo_t* _tmp18_;
		_tmp16_ = ct;
		_tmp17_ = self->priv->old_surface;
		cairo_set_source_surface (_tmp16_, _tmp17_, (gdouble) 0, (gdouble) 0);
		_tmp18_ = ct;
		cairo_paint (_tmp18_);
	} else {
		GdkRGBA _tmp19_;
		gdouble _tmp20_;
		_tmp19_ = self->priv->bg_color;
		_tmp20_ = _tmp19_.alpha;
		if (_tmp20_ > 0.0) {
			cairo_t* _tmp21_;
			GdkRGBA _tmp22_;
			gdouble _tmp23_;
			GdkRGBA _tmp24_;
			gdouble _tmp25_;
			GdkRGBA _tmp26_;
			gdouble _tmp27_;
			GdkRGBA _tmp28_;
			gdouble _tmp29_;
			cairo_t* _tmp30_;
			_tmp21_ = ct;
			_tmp22_ = self->priv->bg_color;
			_tmp23_ = _tmp22_.red;
			_tmp24_ = self->priv->bg_color;
			_tmp25_ = _tmp24_.green;
			_tmp26_ = self->priv->bg_color;
			_tmp27_ = _tmp26_.blue;
			_tmp28_ = self->priv->bg_color;
			_tmp29_ = _tmp28_.alpha;
			cairo_set_source_rgba (_tmp21_, _tmp23_, _tmp25_, _tmp27_, _tmp29_);
			_tmp30_ = ct;
			cairo_fill (_tmp30_);
		} else {
			self->priv->alpha = 1.0;
		}
	}
	_tmp31_ = self->priv->bg_color;
	_tmp32_ = _tmp31_.alpha;
	if (_tmp32_ == 0.0) {
		gint x = 0;
		gint _tmp33_;
		cairo_surface_t* _tmp34_;
		gint _tmp35_;
		gdouble _tmp36_;
		cairo_t* _tmp37_;
		cairo_surface_t* _tmp38_;
		gint _tmp39_;
		_tmp33_ = width;
		_tmp34_ = self->priv->pixbuf_surface;
		_tmp35_ = cairo_image_surface_get_width (_tmp34_);
		_tmp36_ = scale_x;
		x = ((gint) (_tmp33_ - (_tmp35_ * _tmp36_))) / 2;
		_tmp37_ = ct;
		_tmp38_ = self->priv->pixbuf_surface;
		_tmp39_ = x;
		cairo_set_source_surface (_tmp37_, _tmp38_, (gdouble) _tmp39_, (gdouble) 0);
	} else {
		cairo_t* _tmp40_;
		GdkRGBA _tmp41_;
		gdouble _tmp42_;
		GdkRGBA _tmp43_;
		gdouble _tmp44_;
		GdkRGBA _tmp45_;
		gdouble _tmp46_;
		GdkRGBA _tmp47_;
		gdouble _tmp48_;
		_tmp40_ = ct;
		_tmp41_ = self->priv->bg_color;
		_tmp42_ = _tmp41_.red;
		_tmp43_ = self->priv->bg_color;
		_tmp44_ = _tmp43_.green;
		_tmp45_ = self->priv->bg_color;
		_tmp46_ = _tmp45_.blue;
		_tmp47_ = self->priv->bg_color;
		_tmp48_ = _tmp47_.alpha;
		cairo_set_source_rgba (_tmp40_, _tmp42_, _tmp44_, _tmp46_, _tmp48_);
	}
	_tmp49_ = self->priv->in_transition;
	if (_tmp49_) {
		cairo_t* _tmp50_;
		gdouble _tmp51_;
		_tmp50_ = ct;
		_tmp51_ = self->priv->alpha;
		cairo_paint_with_alpha (_tmp50_, _tmp51_);
	} else {
		cairo_t* _tmp52_;
		_tmp52_ = ct;
		cairo_paint (_tmp52_);
	}
	_tmp53_ = ct;
	cairo_pop_group_to_source (_tmp53_);
	_tmp54_ = ct;
	cairo_set_operator (_tmp54_, CAIRO_OPERATOR_OVER);
	_tmp55_ = ct;
	cairo_paint (_tmp55_);
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


void aspect_image_set_pixbuf (AspectImage* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (IS_ASPECT_IMAGE (self));
	_tmp0_ = value;
	if (_tmp0_ != NULL) {
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		cairo_surface_t* _tmp3_;
		GdkPixbuf* _tmp6_;
		GdkWindow* _tmp7_;
		cairo_surface_t* _tmp8_;
		_tmp1_ = value;
		_tmp2_ = twitter_no_banner;
		if (_tmp1_ != _tmp2_) {
			aspect_image_start_animation (self);
		}
		_tmp3_ = self->priv->pixbuf_surface;
		if (_tmp3_ != NULL) {
			cairo_surface_t* _tmp4_;
			cairo_surface_t* _tmp5_;
			_tmp4_ = self->priv->pixbuf_surface;
			_tmp5_ = _cairo_surface_reference0 (_tmp4_);
			_cairo_surface_destroy0 (self->priv->old_surface);
			self->priv->old_surface = _tmp5_;
		}
		_tmp6_ = value;
		_tmp7_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp8_ = gdk_cairo_surface_create_from_pixbuf (_tmp6_, 1, _tmp7_);
		_cairo_surface_destroy0 (self->priv->pixbuf_surface);
		self->priv->pixbuf_surface = (cairo_surface_t*) _tmp8_;
		self->priv->bg_color.alpha = 0.0;
	}
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_object_notify ((GObject *) self, "pixbuf");
}


void aspect_image_set_color_string (AspectImage* self, const gchar* value) {
	const gchar* _tmp0_;
	g_return_if_fail (IS_ASPECT_IMAGE (self));
	_tmp0_ = value;
	gdk_rgba_parse (&self->priv->bg_color, _tmp0_);
	g_object_notify ((GObject *) self, "color-string");
}


static GObject * aspect_image_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AspectImage * self;
	parent_class = G_OBJECT_CLASS (aspect_image_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASPECT_IMAGE, AspectImage);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	return obj;
}


static void aspect_image_class_init (AspectImageClass * klass) {
	aspect_image_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AspectImagePrivate));
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget *, gint, gint*, gint*)) aspect_image_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget *)) aspect_image_real_get_request_mode;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) aspect_image_real_draw;
	G_OBJECT_CLASS (klass)->set_property = _vala_aspect_image_set_property;
	G_OBJECT_CLASS (klass)->constructor = aspect_image_constructor;
	G_OBJECT_CLASS (klass)->finalize = aspect_image_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASPECT_IMAGE_PIXBUF, g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASPECT_IMAGE_COLOR_STRING, g_param_spec_string ("color-string", "color-string", "color-string", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void aspect_image_instance_init (AspectImage * self) {
	self->priv = ASPECT_IMAGE_GET_PRIVATE (self);
	self->priv->pixbuf_surface = NULL;
	self->priv->alpha = 0.0;
	self->priv->in_transition = FALSE;
}


static void aspect_image_finalize (GObject * obj) {
	AspectImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASPECT_IMAGE, AspectImage);
	_cairo_surface_destroy0 (self->priv->old_surface);
	_cairo_surface_destroy0 (self->priv->pixbuf_surface);
	G_OBJECT_CLASS (aspect_image_parent_class)->finalize (obj);
}


GType aspect_image_get_type (void) {
	static volatile gsize aspect_image_type_id__volatile = 0;
	if (g_once_init_enter (&aspect_image_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AspectImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aspect_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AspectImage), 0, (GInstanceInitFunc) aspect_image_instance_init, NULL };
		GType aspect_image_type_id;
		aspect_image_type_id = g_type_register_static (gtk_widget_get_type (), "AspectImage", &g_define_type_info, 0);
		g_once_init_leave (&aspect_image_type_id__volatile, aspect_image_type_id);
	}
	return aspect_image_type_id__volatile;
}


static void _vala_aspect_image_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AspectImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASPECT_IMAGE, AspectImage);
	switch (property_id) {
		case ASPECT_IMAGE_PIXBUF:
		aspect_image_set_pixbuf (self, g_value_get_object (value));
		break;
		case ASPECT_IMAGE_COLOR_STRING:
		aspect_image_set_color_string (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



