/* MainWidget.c generated by valac 0.36.4, the Vala compiler
 * generated from MainWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbBundleHistory.h"
#include "CbMessageReceiver.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <gio/gio.h>


#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;
typedef struct _MainWidgetPrivate MainWidgetPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_IMPOSTOR_WIDGET (impostor_widget_get_type ())
#define IMPOSTOR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPOSTOR_WIDGET, ImpostorWidget))
#define IMPOSTOR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPOSTOR_WIDGET, ImpostorWidgetClass))
#define IS_IMPOSTOR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPOSTOR_WIDGET))
#define IS_IMPOSTOR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPOSTOR_WIDGET))
#define IMPOSTOR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPOSTOR_WIDGET, ImpostorWidgetClass))

typedef struct _ImpostorWidget ImpostorWidget;
typedef struct _ImpostorWidgetClass ImpostorWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;

#define TYPE_MENTIONS_TIMELINE (mentions_timeline_get_type ())
#define MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimeline))
#define MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))
#define IS_MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENTIONS_TIMELINE))
#define IS_MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENTIONS_TIMELINE))
#define MENTIONS_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))

typedef struct _MentionsTimeline MentionsTimeline;
typedef struct _MentionsTimelineClass MentionsTimelineClass;

#define TYPE_FAVORITES_TIMELINE (favorites_timeline_get_type ())
#define FAVORITES_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FAVORITES_TIMELINE, FavoritesTimeline))
#define FAVORITES_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FAVORITES_TIMELINE, FavoritesTimelineClass))
#define IS_FAVORITES_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FAVORITES_TIMELINE))
#define IS_FAVORITES_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FAVORITES_TIMELINE))
#define FAVORITES_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FAVORITES_TIMELINE, FavoritesTimelineClass))

typedef struct _FavoritesTimeline FavoritesTimeline;
typedef struct _FavoritesTimelineClass FavoritesTimelineClass;

#define TYPE_DM_THREADS_PAGE (dm_threads_page_get_type ())
#define DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPage))
#define DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))
#define IS_DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_PAGE))
#define IS_DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_PAGE))
#define DM_THREADS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))

typedef struct _DMThreadsPage DMThreadsPage;
typedef struct _DMThreadsPageClass DMThreadsPageClass;

#define TYPE_LISTS_PAGE (lists_page_get_type ())
#define LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISTS_PAGE, ListsPage))
#define LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISTS_PAGE, ListsPageClass))
#define IS_LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISTS_PAGE))
#define IS_LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISTS_PAGE))
#define LISTS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISTS_PAGE, ListsPageClass))

typedef struct _ListsPage ListsPage;
typedef struct _ListsPageClass ListsPageClass;

#define TYPE_FILTER_PAGE (filter_page_get_type ())
#define FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_PAGE, FilterPage))
#define FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_PAGE, FilterPageClass))
#define IS_FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_PAGE))
#define IS_FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_PAGE))
#define FILTER_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_PAGE, FilterPageClass))

typedef struct _FilterPage FilterPage;
typedef struct _FilterPageClass FilterPageClass;

#define TYPE_SEARCH_PAGE (search_page_get_type ())
#define SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_PAGE, SearchPage))
#define SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_PAGE, SearchPageClass))
#define IS_SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_PAGE))
#define IS_SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_PAGE))
#define SEARCH_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_PAGE, SearchPageClass))

typedef struct _SearchPage SearchPage;
typedef struct _SearchPageClass SearchPageClass;

#define TYPE_PROFILE_PAGE (profile_page_get_type ())
#define PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE_PAGE, ProfilePage))
#define PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE_PAGE, ProfilePageClass))
#define IS_PROFILE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE_PAGE))
#define IS_PROFILE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE_PAGE))
#define PROFILE_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE_PAGE, ProfilePageClass))

typedef struct _ProfilePage ProfilePage;
typedef struct _ProfilePageClass ProfilePageClass;

#define TYPE_TWEET_INFO_PAGE (tweet_info_page_get_type ())
#define TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPage))
#define TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))
#define IS_TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_INFO_PAGE))
#define IS_TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_INFO_PAGE))
#define TWEET_INFO_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))

typedef struct _TweetInfoPage TweetInfoPage;
typedef struct _TweetInfoPageClass TweetInfoPageClass;

#define TYPE_DM_PAGE (dm_page_get_type ())
#define DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PAGE, DMPage))
#define DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PAGE, DMPageClass))
#define IS_DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PAGE))
#define IS_DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PAGE))
#define DM_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PAGE, DMPageClass))

typedef struct _DMPage DMPage;
typedef struct _DMPageClass DMPageClass;

#define TYPE_LIST_STATUSES_PAGE (list_statuses_page_get_type ())
#define LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPage))
#define LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))
#define IS_LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_STATUSES_PAGE))
#define IS_LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_STATUSES_PAGE))
#define LIST_STATUSES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))

typedef struct _ListStatusesPage ListStatusesPage;
typedef struct _ListStatusesPageClass ListStatusesPageClass;
typedef struct _Block2Data Block2Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MainWindowPrivate MainWindowPrivate;

struct _MainWidget {
	GtkBox parent_instance;
	MainWidgetPrivate * priv;
};

struct _MainWidgetClass {
	GtkBoxClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _MainWidgetPrivate {
	Account* account;
	GtkRadioButton* dummy_button;
	IPage** pages;
	gint pages_length1;
	gint _pages_size_;
	CbBundleHistory* history;
	gboolean page_switch_lock;
	ImpostorWidget* stack_impostor;
	GtkBox* top_box;
	GtkStack* stack;
	GtkRevealer* topbar_revealer;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block2Data {
	int _ref_count_;
	MainWidget* self;
	IPage* page;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer main_widget_parent_class = NULL;

GType main_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType impostor_widget_get_type (void) G_GNUC_CONST;
#define MAIN_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WIDGET, MainWidgetPrivate))
enum  {
	MAIN_WIDGET_DUMMY_PROPERTY,
	MAIN_WIDGET_CUR_PAGE_ID
};
ImpostorWidget* impostor_widget_new (void);
ImpostorWidget* impostor_widget_construct (GType object_type);
GType corebird_get_type (void) G_GNUC_CONST;
MainWidget* main_widget_new (Account* account, MainWindow* parent, Corebird* app);
MainWidget* main_widget_construct (GType object_type, Account* account, MainWindow* parent, Corebird* app);
void corebird_start_account (Corebird* self, Account* acc);
GType page_get_type (void) G_GNUC_CONST;
HomeTimeline* home_timeline_new (gint id, Account* account);
HomeTimeline* home_timeline_construct (GType object_type, gint id, Account* account);
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
MentionsTimeline* mentions_timeline_new (gint id, Account* account);
MentionsTimeline* mentions_timeline_construct (GType object_type, gint id, Account* account);
GType mentions_timeline_get_type (void) G_GNUC_CONST;
FavoritesTimeline* favorites_timeline_new (gint id, Account* account);
FavoritesTimeline* favorites_timeline_construct (GType object_type, gint id, Account* account);
GType favorites_timeline_get_type (void) G_GNUC_CONST;
DMThreadsPage* dm_threads_page_new (gint id, Account* account);
DMThreadsPage* dm_threads_page_construct (GType object_type, gint id, Account* account);
GType dm_threads_page_get_type (void) G_GNUC_CONST;
ListsPage* lists_page_new (gint id, Account* account);
ListsPage* lists_page_construct (GType object_type, gint id, Account* account);
GType lists_page_get_type (void) G_GNUC_CONST;
FilterPage* filter_page_new (gint id, Account* account);
FilterPage* filter_page_construct (GType object_type, gint id, Account* account);
GType filter_page_get_type (void) G_GNUC_CONST;
SearchPage* search_page_new (gint id, Account* account);
SearchPage* search_page_construct (GType object_type, gint id, Account* account);
GType search_page_get_type (void) G_GNUC_CONST;
ProfilePage* profile_page_new (gint id, Account* account);
ProfilePage* profile_page_construct (GType object_type, gint id, Account* account);
GType profile_page_get_type (void) G_GNUC_CONST;
TweetInfoPage* tweet_info_page_new (gint id, Account* account);
TweetInfoPage* tweet_info_page_construct (GType object_type, gint id, Account* account);
GType tweet_info_page_get_type (void) G_GNUC_CONST;
DMPage* dm_page_new (gint id, Account* account);
DMPage* dm_page_construct (GType object_type, gint id, Account* account);
GType dm_page_get_type (void) G_GNUC_CONST;
ListStatusesPage* list_statuses_page_new (gint id, Account* account);
ListStatusesPage* list_statuses_page_construct (GType object_type, gint id, Account* account);
GType list_statuses_page_get_type (void) G_GNUC_CONST;
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
void ipage_set_window (IPage* self, MainWindow* value);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void ipage_create_radio_button (IPage* self, GtkRadioButton* group);
GtkRadioButton* ipage_get_radio_button (IPage* self);
static void ______lambda172_ (Block2Data* _data2_);
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
gint ipage_get_id (IPage* self);
static void _______lambda172__gtk_button_clicked (GtkButton* _sender, gpointer self);
GSettings* settings_get (void);
gboolean ipage_handles_double_open (IPage* self);
void ipage_double_open (IPage* self);
void impostor_widget_clone (ImpostorWidget* self, GtkWidget* widget);
void ipage_on_leave (IPage* self);
void ipage_on_join (IPage* self, gint page_id, CbBundle* args);
void main_window_set_window_title (MainWindow* self, const gchar* title, GtkStackTransitionType transition_type);
gchar* ipage_get_title (IPage* self);
void main_widget_remove_current_page (MainWidget* self);
IPage* main_widget_get_page (MainWidget* self, gint page_id);
void main_widget_stop (MainWidget* self);
void corebird_stop_account (Corebird* self, Account* acc);
gint main_widget_get_cur_page_id (MainWidget* self);
static void main_widget_finalize (GObject * obj);
static void _vala_main_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MainWidget* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->page);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ______lambda172_ (Block2Data* _data2_) {
	MainWidget* self;
	gboolean _tmp0_ = FALSE;
	IPage* _tmp1_;
	GtkRadioButton* _tmp2_;
	GtkRadioButton* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	self = _data2_->self;
	_tmp1_ = _data2_->page;
	_tmp2_ = ipage_get_radio_button (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	if (_tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = self->priv->page_switch_lock;
		_tmp0_ = !_tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		IPage* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = _data2_->page;
		_tmp9_ = ipage_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		main_widget_switch_page (self, _tmp10_, NULL);
	}
}


static void _______lambda172__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda172_ (self);
}


MainWidget* main_widget_construct (GType object_type, Account* account, MainWindow* parent, Corebird* app) {
	MainWidget * self = NULL;
	Account* _tmp0_;
	Corebird* _tmp1_;
	Account* _tmp2_;
	GtkRevealer* _tmp3_;
	GtkRevealer* _tmp4_;
	GtkRevealer* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkRevealer* _tmp11_;
	GtkBox* _tmp12_;
	GtkRevealer* _tmp13_;
	GtkStack* _tmp14_;
	GtkStack* _tmp15_;
	GtkStack* _tmp16_;
	GtkStack* _tmp17_;
	GtkStack* _tmp18_;
	ImpostorWidget* _tmp19_;
	IPage** _tmp20_;
	IPage** _tmp21_;
	gint _tmp21__length1;
	Account* _tmp22_;
	HomeTimeline* _tmp23_;
	IPage* _tmp24_;
	IPage** _tmp25_;
	gint _tmp25__length1;
	Account* _tmp26_;
	MentionsTimeline* _tmp27_;
	IPage* _tmp28_;
	IPage** _tmp29_;
	gint _tmp29__length1;
	Account* _tmp30_;
	FavoritesTimeline* _tmp31_;
	IPage* _tmp32_;
	IPage** _tmp33_;
	gint _tmp33__length1;
	Account* _tmp34_;
	DMThreadsPage* _tmp35_;
	IPage* _tmp36_;
	IPage** _tmp37_;
	gint _tmp37__length1;
	Account* _tmp38_;
	ListsPage* _tmp39_;
	IPage* _tmp40_;
	IPage** _tmp41_;
	gint _tmp41__length1;
	Account* _tmp42_;
	FilterPage* _tmp43_;
	IPage* _tmp44_;
	IPage** _tmp45_;
	gint _tmp45__length1;
	Account* _tmp46_;
	SearchPage* _tmp47_;
	IPage* _tmp48_;
	IPage** _tmp49_;
	gint _tmp49__length1;
	Account* _tmp50_;
	ProfilePage* _tmp51_;
	IPage* _tmp52_;
	IPage** _tmp53_;
	gint _tmp53__length1;
	Account* _tmp54_;
	TweetInfoPage* _tmp55_;
	IPage* _tmp56_;
	IPage** _tmp57_;
	gint _tmp57__length1;
	Account* _tmp58_;
	DMPage* _tmp59_;
	IPage* _tmp60_;
	IPage** _tmp61_;
	gint _tmp61__length1;
	Account* _tmp62_;
	ListStatusesPage* _tmp63_;
	IPage* _tmp64_;
	GSettings* _tmp94_;
	GSettings* _tmp95_;
	GtkRevealer* _tmp96_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	g_return_val_if_fail (IS_MAIN_WINDOW (parent), NULL);
	g_return_val_if_fail (IS_COREBIRD (app), NULL);
	self = (MainWidget*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = app;
	_tmp2_ = account;
	corebird_start_account (_tmp1_, _tmp2_);
	gtk_orientable_set_orientation (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_ORIENTABLE, GtkOrientable), GTK_ORIENTATION_VERTICAL);
	_tmp3_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->topbar_revealer);
	self->priv->topbar_revealer = _tmp3_;
	_tmp4_ = self->priv->topbar_revealer;
	gtk_revealer_set_reveal_child (_tmp4_, TRUE);
	_tmp5_ = self->priv->topbar_revealer;
	gtk_revealer_set_transition_type (_tmp5_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->top_box);
	self->priv->top_box = _tmp6_;
	_tmp7_ = self->priv->top_box;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp8_ = self->priv->top_box;
	gtk_box_set_homogeneous (_tmp8_, TRUE);
	_tmp9_ = self->priv->top_box;
	_tmp10_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp10_, "topbar");
	_tmp11_ = self->priv->topbar_revealer;
	_tmp12_ = self->priv->top_box;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	_tmp13_ = self->priv->topbar_revealer;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	_tmp14_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp14_;
	_tmp15_ = self->priv->stack;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp16_ = self->priv->stack;
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp17_ = self->priv->stack;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = self->priv->stack;
	_tmp19_ = self->priv->stack_impostor;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = g_new0 (IPage*, 11 + 1);
	self->priv->pages = (_vala_array_free (self->priv->pages, self->priv->pages_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->pages = _tmp20_;
	self->priv->pages_length1 = 11;
	self->priv->_pages_size_ = self->priv->pages_length1;
	_tmp21_ = self->priv->pages;
	_tmp21__length1 = self->priv->pages_length1;
	_tmp22_ = account;
	_tmp23_ = home_timeline_new ((gint) PAGE_STREAM, _tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (_tmp21_[0]);
	_tmp21_[0] = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_IPAGE, IPage);
	_tmp24_ = _tmp21_[0];
	_tmp25_ = self->priv->pages;
	_tmp25__length1 = self->priv->pages_length1;
	_tmp26_ = account;
	_tmp27_ = mentions_timeline_new ((gint) PAGE_MENTIONS, _tmp26_);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (_tmp25_[1]);
	_tmp25_[1] = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_IPAGE, IPage);
	_tmp28_ = _tmp25_[1];
	_tmp29_ = self->priv->pages;
	_tmp29__length1 = self->priv->pages_length1;
	_tmp30_ = account;
	_tmp31_ = favorites_timeline_new ((gint) PAGE_FAVORITES, _tmp30_);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (_tmp29_[2]);
	_tmp29_[2] = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_IPAGE, IPage);
	_tmp32_ = _tmp29_[2];
	_tmp33_ = self->priv->pages;
	_tmp33__length1 = self->priv->pages_length1;
	_tmp34_ = account;
	_tmp35_ = dm_threads_page_new ((gint) PAGE_DM_THREADS, _tmp34_);
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (_tmp33_[3]);
	_tmp33_[3] = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_IPAGE, IPage);
	_tmp36_ = _tmp33_[3];
	_tmp37_ = self->priv->pages;
	_tmp37__length1 = self->priv->pages_length1;
	_tmp38_ = account;
	_tmp39_ = lists_page_new ((gint) PAGE_LISTS, _tmp38_);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (_tmp37_[4]);
	_tmp37_[4] = G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_IPAGE, IPage);
	_tmp40_ = _tmp37_[4];
	_tmp41_ = self->priv->pages;
	_tmp41__length1 = self->priv->pages_length1;
	_tmp42_ = account;
	_tmp43_ = filter_page_new ((gint) PAGE_FILTERS, _tmp42_);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (_tmp41_[5]);
	_tmp41_[5] = G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_IPAGE, IPage);
	_tmp44_ = _tmp41_[5];
	_tmp45_ = self->priv->pages;
	_tmp45__length1 = self->priv->pages_length1;
	_tmp46_ = account;
	_tmp47_ = search_page_new ((gint) PAGE_SEARCH, _tmp46_);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (_tmp45_[6]);
	_tmp45_[6] = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_IPAGE, IPage);
	_tmp48_ = _tmp45_[6];
	_tmp49_ = self->priv->pages;
	_tmp49__length1 = self->priv->pages_length1;
	_tmp50_ = account;
	_tmp51_ = profile_page_new ((gint) PAGE_PROFILE, _tmp50_);
	g_object_ref_sink (_tmp51_);
	_g_object_unref0 (_tmp49_[7]);
	_tmp49_[7] = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_IPAGE, IPage);
	_tmp52_ = _tmp49_[7];
	_tmp53_ = self->priv->pages;
	_tmp53__length1 = self->priv->pages_length1;
	_tmp54_ = account;
	_tmp55_ = tweet_info_page_new ((gint) PAGE_TWEET_INFO, _tmp54_);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (_tmp53_[8]);
	_tmp53_[8] = G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, TYPE_IPAGE, IPage);
	_tmp56_ = _tmp53_[8];
	_tmp57_ = self->priv->pages;
	_tmp57__length1 = self->priv->pages_length1;
	_tmp58_ = account;
	_tmp59_ = dm_page_new ((gint) PAGE_DM, _tmp58_);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (_tmp57_[9]);
	_tmp57_[9] = G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, TYPE_IPAGE, IPage);
	_tmp60_ = _tmp57_[9];
	_tmp61_ = self->priv->pages;
	_tmp61__length1 = self->priv->pages_length1;
	_tmp62_ = account;
	_tmp63_ = list_statuses_page_new ((gint) PAGE_LIST_STATUSES, _tmp62_);
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (_tmp61_[10]);
	_tmp61_[10] = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, TYPE_IPAGE, IPage);
	_tmp64_ = _tmp61_[10];
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp65_ = FALSE;
			_tmp65_ = TRUE;
			while (TRUE) {
				Block2Data* _data2_;
				gint _tmp67_;
				IPage** _tmp68_;
				gint _tmp68__length1;
				IPage** _tmp69_;
				gint _tmp69__length1;
				gint _tmp70_;
				IPage* _tmp71_;
				IPage* _tmp72_;
				IPage* _tmp73_;
				MainWindow* _tmp74_;
				IPage* _tmp75_;
				IPage* _tmp79_;
				GtkRadioButton* _tmp80_;
				GtkStack* _tmp81_;
				IPage* _tmp82_;
				IPage* _tmp83_;
				GtkRadioButton* _tmp84_;
				GtkRadioButton* _tmp85_;
				gboolean _tmp86_;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->self = g_object_ref (self);
				if (!_tmp65_) {
					gint _tmp66_;
					_tmp66_ = i;
					i = _tmp66_ + 1;
				}
				_tmp65_ = FALSE;
				_tmp67_ = i;
				_tmp68_ = self->priv->pages;
				_tmp68__length1 = self->priv->pages_length1;
				if (!(_tmp67_ < _tmp68__length1)) {
					block2_data_unref (_data2_);
					_data2_ = NULL;
					break;
				}
				_tmp69_ = self->priv->pages;
				_tmp69__length1 = self->priv->pages_length1;
				_tmp70_ = i;
				_tmp71_ = _tmp69_[_tmp70_];
				_tmp72_ = _g_object_ref0 (_tmp71_);
				_data2_->page = _tmp72_;
				_tmp73_ = _data2_->page;
				_tmp74_ = parent;
				ipage_set_window (_tmp73_, _tmp74_);
				_tmp75_ = _data2_->page;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, CB_TYPE_MESSAGE_RECEIVER)) {
					Account* _tmp76_;
					CbUserStream* _tmp77_;
					IPage* _tmp78_;
					_tmp76_ = account;
					_tmp77_ = _tmp76_->user_stream;
					_tmp78_ = _data2_->page;
					cb_user_stream_register (_tmp77_, G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, CB_TYPE_MESSAGE_RECEIVER, CbMessageReceiver));
				}
				_tmp79_ = _data2_->page;
				_tmp80_ = self->priv->dummy_button;
				ipage_create_radio_button (_tmp79_, _tmp80_);
				_tmp81_ = self->priv->stack;
				_tmp82_ = _data2_->page;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, gtk_widget_get_type (), GtkWidget));
				_tmp83_ = _data2_->page;
				_tmp84_ = ipage_get_radio_button (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = _tmp85_ != NULL;
				_g_object_unref0 (_tmp85_);
				if (_tmp86_) {
					GtkBox* _tmp87_;
					IPage* _tmp88_;
					GtkRadioButton* _tmp89_;
					GtkRadioButton* _tmp90_;
					IPage* _tmp91_;
					GtkRadioButton* _tmp92_;
					GtkRadioButton* _tmp93_;
					_tmp87_ = self->priv->top_box;
					_tmp88_ = _data2_->page;
					_tmp89_ = ipage_get_radio_button (_tmp88_);
					_tmp90_ = _tmp89_;
					gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (_tmp90_);
					_tmp91_ = _data2_->page;
					_tmp92_ = ipage_get_radio_button (_tmp91_);
					_tmp93_ = _tmp92_;
					g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _______lambda172__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_g_object_unref0 (_tmp93_);
				}
				block2_data_unref (_data2_);
				_data2_ = NULL;
			}
		}
	}
	_tmp94_ = settings_get ();
	_tmp95_ = _tmp94_;
	_tmp96_ = self->priv->topbar_revealer;
	g_settings_bind (_tmp95_, "sidebar-visible", G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, G_TYPE_OBJECT, GObject), "reveal-child", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp95_);
	return self;
}


MainWidget* main_widget_new (Account* account, MainWindow* parent, Corebird* app) {
	return main_widget_construct (TYPE_MAIN_WIDGET, account, parent, app);
}


/**
   * Switches the window's main notebook to the given page.
   *
   * @param page_id The id of the page to switch to.
   *                See the Page.* constants.
   *
   */
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args) {
	gint _tmp0_;
	CbBundleHistory* _tmp1_;
	gint _tmp2_;
	gboolean push = FALSE;
	gboolean _tmp21_ = FALSE;
	gint _tmp22_;
	gint current_page = 0;
	CbBundleHistory* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint _tmp49_;
	gint _tmp50_;
	gint _tmp63_;
	gboolean _tmp67_;
	IPage* page = NULL;
	IPage** _tmp71_;
	gint _tmp71__length1;
	gint _tmp72_;
	IPage* _tmp73_;
	IPage* _tmp74_;
	GtkToggleButton* button = NULL;
	IPage* _tmp75_;
	GtkRadioButton* _tmp76_;
	GtkToggleButton* _tmp77_;
	IPage* _tmp80_;
	gint _tmp81_;
	CbBundle* _tmp82_;
	GtkStack* _tmp83_;
	IPage** _tmp84_;
	gint _tmp84__length1;
	gint _tmp85_;
	IPage* _tmp86_;
	GtkContainer* _tmp87_;
	GtkContainer* _tmp88_;
	IPage* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	GtkStack* _tmp92_;
	GtkStackTransitionType _tmp93_;
	GtkStackTransitionType _tmp94_;
	GtkContainer* _tmp95_;
	GtkContainer* _tmp96_;
	GtkButton* _tmp97_;
	CbBundleHistory* _tmp98_;
	gboolean _tmp99_;
	g_return_if_fail (IS_MAIN_WIDGET (self));
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	_tmp0_ = page_id;
	_tmp1_ = self->priv->history;
	_tmp2_ = cb_bundle_history_get_current (_tmp1_);
	if (_tmp0_ == _tmp2_) {
		IPage** _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		IPage* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		CbBundleHistory* _tmp12_;
		CbBundle* _tmp13_;
		_tmp3_ = self->priv->pages;
		_tmp3__length1 = self->priv->pages_length1;
		_tmp4_ = page_id;
		_tmp5_ = _tmp3_[_tmp4_];
		_tmp6_ = ipage_handles_double_open (_tmp5_);
		if (_tmp6_) {
			IPage** _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			IPage* _tmp9_;
			_tmp7_ = self->priv->pages;
			_tmp7__length1 = self->priv->pages_length1;
			_tmp8_ = page_id;
			_tmp9_ = _tmp7_[_tmp8_];
			ipage_double_open (_tmp9_);
		}
		_tmp12_ = self->priv->history;
		_tmp13_ = cb_bundle_history_get_current_bundle (_tmp12_);
		if (_tmp13_ != NULL) {
			CbBundleHistory* _tmp14_;
			CbBundle* _tmp15_;
			CbBundle* _tmp16_;
			gboolean _tmp17_;
			_tmp14_ = self->priv->history;
			_tmp15_ = cb_bundle_history_get_current_bundle (_tmp14_);
			_tmp16_ = args;
			_tmp17_ = cb_bundle_equals (_tmp15_, _tmp16_);
			_tmp11_ = _tmp17_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			CbBundleHistory* _tmp18_;
			CbBundle* _tmp19_;
			CbBundle* _tmp20_;
			_tmp18_ = self->priv->history;
			_tmp19_ = cb_bundle_history_get_current_bundle (_tmp18_);
			_tmp20_ = args;
			_tmp10_ = _tmp19_ == _tmp20_;
		}
		if (_tmp10_) {
			return;
		}
	}
	push = TRUE;
	_tmp22_ = page_id;
	if (_tmp22_ == ((gint) PAGE_PREVIOUS)) {
		_tmp21_ = TRUE;
	} else {
		gint _tmp23_;
		CbBundleHistory* _tmp24_;
		gint _tmp25_;
		_tmp23_ = page_id;
		_tmp24_ = self->priv->history;
		_tmp25_ = cb_bundle_history_get_current (_tmp24_);
		_tmp21_ = _tmp23_ < _tmp25_;
	}
	if (_tmp21_) {
		GtkStack* _tmp26_;
		_tmp26_ = self->priv->stack;
		gtk_stack_set_transition_type (_tmp26_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
	} else {
		gboolean _tmp27_ = FALSE;
		gint _tmp28_;
		_tmp28_ = page_id;
		if (_tmp28_ == ((gint) PAGE_NEXT)) {
			_tmp27_ = TRUE;
		} else {
			gint _tmp29_;
			CbBundleHistory* _tmp30_;
			gint _tmp31_;
			_tmp29_ = page_id;
			_tmp30_ = self->priv->history;
			_tmp31_ = cb_bundle_history_get_current (_tmp30_);
			_tmp27_ = _tmp29_ > _tmp31_;
		}
		if (_tmp27_) {
			GtkStack* _tmp32_;
			_tmp32_ = self->priv->stack;
			gtk_stack_set_transition_type (_tmp32_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
		}
	}
	_tmp33_ = self->priv->history;
	_tmp34_ = cb_bundle_history_get_current (_tmp33_);
	current_page = _tmp34_;
	_tmp35_ = page_id;
	if (_tmp35_ == ((gint) PAGE_PREVIOUS)) {
		CbBundleHistory* _tmp36_;
		gboolean _tmp37_;
		CbBundleHistory* _tmp38_;
		gint _tmp39_;
		CbBundleHistory* _tmp40_;
		CbBundle* _tmp41_;
		_tmp36_ = self->priv->history;
		_tmp37_ = cb_bundle_history_at_start (_tmp36_);
		if (_tmp37_) {
			return;
		}
		push = FALSE;
		_tmp38_ = self->priv->history;
		_tmp39_ = cb_bundle_history_back (_tmp38_);
		page_id = _tmp39_;
		_tmp40_ = self->priv->history;
		_tmp41_ = cb_bundle_history_get_current_bundle (_tmp40_);
		args = _tmp41_;
	} else {
		gint _tmp42_;
		_tmp42_ = page_id;
		if (_tmp42_ == ((gint) PAGE_NEXT)) {
			CbBundleHistory* _tmp43_;
			gboolean _tmp44_;
			CbBundleHistory* _tmp45_;
			gint _tmp46_;
			CbBundleHistory* _tmp47_;
			CbBundle* _tmp48_;
			_tmp43_ = self->priv->history;
			_tmp44_ = cb_bundle_history_at_end (_tmp43_);
			if (_tmp44_) {
				return;
			}
			push = FALSE;
			_tmp45_ = self->priv->history;
			_tmp46_ = cb_bundle_history_forward (_tmp45_);
			page_id = _tmp46_;
			_tmp47_ = self->priv->history;
			_tmp48_ = cb_bundle_history_get_current_bundle (_tmp47_);
			args = _tmp48_;
		}
	}
	_tmp49_ = page_id;
	_tmp50_ = current_page;
	if (_tmp49_ == _tmp50_) {
		ImpostorWidget* _tmp51_;
		IPage** _tmp52_;
		gint _tmp52__length1;
		gint _tmp53_;
		IPage* _tmp54_;
		GtkStackTransitionType transition_type = 0;
		GtkStack* _tmp55_;
		GtkStackTransitionType _tmp56_;
		GtkStackTransitionType _tmp57_;
		GtkStack* _tmp58_;
		GtkStack* _tmp59_;
		ImpostorWidget* _tmp60_;
		GtkStack* _tmp61_;
		GtkStackTransitionType _tmp62_;
		_tmp51_ = self->priv->stack_impostor;
		_tmp52_ = self->priv->pages;
		_tmp52__length1 = self->priv->pages_length1;
		_tmp53_ = page_id;
		_tmp54_ = _tmp52_[_tmp53_];
		impostor_widget_clone (_tmp51_, G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget));
		_tmp55_ = self->priv->stack;
		_tmp56_ = gtk_stack_get_transition_type (_tmp55_);
		_tmp57_ = _tmp56_;
		transition_type = _tmp57_;
		_tmp58_ = self->priv->stack;
		gtk_stack_set_transition_type (_tmp58_, GTK_STACK_TRANSITION_TYPE_NONE);
		_tmp59_ = self->priv->stack;
		_tmp60_ = self->priv->stack_impostor;
		gtk_stack_set_visible_child (_tmp59_, G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget));
		_tmp61_ = self->priv->stack;
		_tmp62_ = transition_type;
		gtk_stack_set_transition_type (_tmp61_, _tmp62_);
	}
	_tmp63_ = current_page;
	if (_tmp63_ != -1) {
		IPage** _tmp64_;
		gint _tmp64__length1;
		gint _tmp65_;
		IPage* _tmp66_;
		_tmp64_ = self->priv->pages;
		_tmp64__length1 = self->priv->pages_length1;
		_tmp65_ = current_page;
		_tmp66_ = _tmp64_[_tmp65_];
		ipage_on_leave (_tmp66_);
	}
	_tmp67_ = push;
	if (_tmp67_) {
		CbBundleHistory* _tmp68_;
		gint _tmp69_;
		CbBundle* _tmp70_;
		_tmp68_ = self->priv->history;
		_tmp69_ = page_id;
		_tmp70_ = args;
		cb_bundle_history_push (_tmp68_, _tmp69_, _tmp70_);
	}
	_tmp71_ = self->priv->pages;
	_tmp71__length1 = self->priv->pages_length1;
	_tmp72_ = page_id;
	_tmp73_ = _tmp71_[_tmp72_];
	_tmp74_ = _g_object_ref0 (_tmp73_);
	page = _tmp74_;
	_tmp75_ = page;
	_tmp76_ = ipage_get_radio_button (_tmp75_);
	button = G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, gtk_toggle_button_get_type (), GtkToggleButton);
	self->priv->page_switch_lock = TRUE;
	_tmp77_ = button;
	if (_tmp77_ != NULL) {
		GtkToggleButton* _tmp78_;
		_tmp78_ = button;
		gtk_toggle_button_set_active (_tmp78_, TRUE);
	} else {
		GtkRadioButton* _tmp79_;
		_tmp79_ = self->priv->dummy_button;
		gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	}
	_tmp80_ = page;
	_tmp81_ = page_id;
	_tmp82_ = args;
	ipage_on_join (_tmp80_, _tmp81_, _tmp82_);
	_tmp83_ = self->priv->stack;
	_tmp84_ = self->priv->pages;
	_tmp84__length1 = self->priv->pages_length1;
	_tmp85_ = page_id;
	_tmp86_ = _tmp84_[_tmp85_];
	gtk_stack_set_visible_child (_tmp83_, G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, gtk_widget_get_type (), GtkWidget));
	_tmp87_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp88_ = _tmp87_;
	_tmp89_ = page;
	_tmp90_ = ipage_get_title (_tmp89_);
	_tmp91_ = _tmp90_;
	_tmp92_ = self->priv->stack;
	_tmp93_ = gtk_stack_get_transition_type (_tmp92_);
	_tmp94_ = _tmp93_;
	main_window_set_window_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, TYPE_MAIN_WINDOW, MainWindow), _tmp91_, _tmp94_);
	_g_free0 (_tmp91_);
	self->priv->page_switch_lock = FALSE;
	_tmp95_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp96_ = _tmp95_;
	_tmp97_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, TYPE_MAIN_WINDOW, MainWindow)->back_button;
	_tmp98_ = self->priv->history;
	_tmp99_ = cb_bundle_history_at_start (_tmp98_);
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, gtk_widget_get_type (), GtkWidget), !_tmp99_);
	_g_object_unref0 (button);
	_g_object_unref0 (page);
}


void main_widget_remove_current_page (MainWidget* self) {
	CbBundleHistory* _tmp0_;
	g_return_if_fail (IS_MAIN_WIDGET (self));
	_tmp0_ = self->priv->history;
	cb_bundle_history_remove_current (_tmp0_);
	main_widget_switch_page (self, (gint) PAGE_PREVIOUS, NULL);
}


IPage* main_widget_get_page (MainWidget* self, gint page_id) {
	IPage* result = NULL;
	IPage** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	IPage* _tmp2_;
	IPage* _tmp3_;
	g_return_val_if_fail (IS_MAIN_WIDGET (self), NULL);
	_tmp0_ = self->priv->pages;
	_tmp0__length1 = self->priv->pages_length1;
	_tmp1_ = page_id;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


void main_widget_stop (MainWidget* self) {
	GApplication* _tmp12_;
	Account* _tmp13_;
	g_return_if_fail (IS_MAIN_WIDGET (self));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				IPage** _tmp3_;
				gint _tmp3__length1;
				IPage* page = NULL;
				IPage** _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				IPage* _tmp6_;
				IPage* _tmp7_;
				IPage* _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->pages;
				_tmp3__length1 = self->priv->pages_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = self->priv->pages;
				_tmp4__length1 = self->priv->pages_length1;
				_tmp5_ = i;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _g_object_ref0 (_tmp6_);
				page = _tmp7_;
				_tmp8_ = page;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, CB_TYPE_MESSAGE_RECEIVER)) {
					Account* _tmp9_;
					CbUserStream* _tmp10_;
					IPage* _tmp11_;
					_tmp9_ = self->priv->account;
					_tmp10_ = _tmp9_->user_stream;
					_tmp11_ = page;
					cb_user_stream_unregister (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, CB_TYPE_MESSAGE_RECEIVER, CbMessageReceiver));
				}
				_g_object_unref0 (page);
			}
		}
	}
	_tmp12_ = g_application_get_default ();
	_tmp13_ = self->priv->account;
	corebird_stop_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_COREBIRD, Corebird), _tmp13_);
}


gint main_widget_get_cur_page_id (MainWidget* self) {
	gint result;
	CbBundleHistory* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (IS_MAIN_WIDGET (self), 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = cb_bundle_history_get_current (_tmp0_);
	result = _tmp1_;
	return result;
}


static void main_widget_class_init (MainWidgetClass * klass) {
	main_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_main_widget_get_property;
	G_OBJECT_CLASS (klass)->finalize = main_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WIDGET_CUR_PAGE_ID, g_param_spec_int ("cur-page-id", "cur-page-id", "cur-page-id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void main_widget_instance_init (MainWidget * self) {
	GtkRadioButton* _tmp0_;
	CbBundleHistory* _tmp1_;
	ImpostorWidget* _tmp2_;
	self->priv = MAIN_WIDGET_GET_PRIVATE (self);
	_tmp0_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp0_);
	self->priv->dummy_button = _tmp0_;
	_tmp1_ = cb_bundle_history_new ();
	self->priv->history = _tmp1_;
	self->priv->page_switch_lock = FALSE;
	_tmp2_ = impostor_widget_new ();
	g_object_ref_sink (_tmp2_);
	self->priv->stack_impostor = _tmp2_;
}


static void main_widget_finalize (GObject * obj) {
	MainWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WIDGET, MainWidget);
	_g_object_unref0 (self->priv->dummy_button);
	self->priv->pages = (_vala_array_free (self->priv->pages, self->priv->pages_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->stack_impostor);
	_g_object_unref0 (self->priv->top_box);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->topbar_revealer);
	G_OBJECT_CLASS (main_widget_parent_class)->finalize (obj);
}


GType main_widget_get_type (void) {
	static volatile gsize main_widget_type_id__volatile = 0;
	if (g_once_init_enter (&main_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWidget), 0, (GInstanceInitFunc) main_widget_instance_init, NULL };
		GType main_widget_type_id;
		main_widget_type_id = g_type_register_static (gtk_box_get_type (), "MainWidget", &g_define_type_info, 0);
		g_once_init_leave (&main_widget_type_id__volatile, main_widget_type_id);
	}
	return main_widget_type_id__volatile;
}


static void _vala_main_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MainWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WIDGET, MainWidget);
	switch (property_id) {
		case MAIN_WIDGET_CUR_PAGE_ID:
		g_value_set_int (value, main_widget_get_cur_page_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



