/* SearchPage.c generated by valac 0.34.6, the Vala compiler
 * generated from SearchPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "CbTweet.h"
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_SEARCH_PAGE (search_page_get_type ())
#define SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_PAGE, SearchPage))
#define SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_PAGE, SearchPageClass))
#define IS_SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_PAGE))
#define IS_SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_PAGE))
#define SEARCH_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_PAGE, SearchPageClass))

typedef struct _SearchPage SearchPage;
typedef struct _SearchPageClass SearchPageClass;
typedef struct _SearchPagePrivate SearchPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_LOAD_MORE_ENTRY (load_more_entry_get_type ())
#define LOAD_MORE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOAD_MORE_ENTRY, LoadMoreEntry))
#define LOAD_MORE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOAD_MORE_ENTRY, LoadMoreEntryClass))
#define IS_LOAD_MORE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOAD_MORE_ENTRY))
#define IS_LOAD_MORE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOAD_MORE_ENTRY))
#define LOAD_MORE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOAD_MORE_ENTRY, LoadMoreEntryClass))

typedef struct _LoadMoreEntry LoadMoreEntry;
typedef struct _LoadMoreEntryClass LoadMoreEntryClass;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_USER_LIST_ENTRY (user_list_entry_get_type ())
#define USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_ENTRY, UserListEntry))
#define USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_ENTRY, UserListEntryClass))
#define IS_USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_ENTRY))
#define IS_USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_ENTRY))
#define USER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_ENTRY, UserListEntryClass))

typedef struct _UserListEntry UserListEntry;
typedef struct _UserListEntryClass UserListEntryClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;
typedef struct _LoadMoreEntryPrivate LoadMoreEntryPrivate;

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _SearchPage {
	GtkBox parent_instance;
	SearchPagePrivate * priv;
	Account* account;
	DeltaUpdater* delta_updater;
};

struct _SearchPageClass {
	GtkBoxClass parent_class;
};

struct _SearchPagePrivate {
	gint _id;
	MainWindow* main_window;
	GtkSearchEntry* search_entry;
	GtkButton* search_button;
	TweetListBox* tweet_list;
	GtkLabel* users_header;
	GtkLabel* tweets_header;
	ScrollWidget* scroll_widget;
	GtkRadioButton* radio_button;
	GCancellable* cancellable;
	LoadMoreEntry* load_more_entry;
	gchar* search_query;
	gint user_page;
	gint64 lowest_tweet_id;
	GtkWidget* last_focus_widget;
	gint n_results;
	Collect* collect_obj;
	guint remove_content_timeout;
	gchar* last_search_query;
	gboolean loading_tweets;
	gboolean loading_users;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	SearchPage* self;
	GDateTime* now;
};

struct _LoadMoreEntry {
	GtkListBoxRow parent_instance;
	LoadMoreEntryPrivate * priv;
};

struct _LoadMoreEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _LoadMoreEntryPrivate {
	GtkButton* load_more_button;
};


static gpointer search_page_parent_class = NULL;
static IPageIface* search_page_ipage_parent_iface = NULL;
static gpointer load_more_entry_parent_class = NULL;
static ITwitterItemIface* load_more_entry_itwitter_item_parent_iface = NULL;

GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType search_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType load_more_entry_get_type (void) G_GNUC_CONST;
GType collect_get_type (void) G_GNUC_CONST;
#define SEARCH_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_PAGE, SearchPagePrivate))
enum  {
	SEARCH_PAGE_DUMMY_PROPERTY,
	SEARCH_PAGE_UNREAD_COUNT,
	SEARCH_PAGE_ID,
	SEARCH_PAGE_WINDOW
};
LoadMoreEntry* load_more_entry_new (void);
LoadMoreEntry* load_more_entry_construct (GType object_type);
#define SEARCH_PAGE_USER_COUNT 3
SearchPage* search_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
SearchPage* search_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
void ipage_set_id (IPage* self, gint value);
static void search_page_header_func (SearchPage* self, GtkListBoxRow* row, GtkListBoxRow* before);
static void _search_page_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
gint itwitter_item_sort_func (GtkListBoxRow* a, GtkListBoxRow* b);
static gint _itwitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void search_page_row_activated_cb (SearchPage* self, GtkListBoxRow* row);
static void _search_page_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void search_page_retry_button_clicked_cb (SearchPage* self);
static void _search_page_retry_button_clicked_cb_tweet_list_box_retry_button_clicked (TweetListBox* _sender, gpointer self);
static void __lambda155_ (SearchPage* self);
void search_page_search_for (SearchPage* self, const gchar* search_term, gboolean set_text);
static void ___lambda155__gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkButton* load_more_entry_get_button (LoadMoreEntry* self);
static void __lambda156_ (SearchPage* self);
static void search_page_load_users (SearchPage* self);
static void ___lambda156__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_page_load_tweets (SearchPage* self);
static void _search_page_load_tweets_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
GtkStack* tweet_list_box_get_placeholder (TweetListBox* self);
static void search_page_search_entry_activate_cb (SearchPage* self);
static void _search_page_search_entry_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void search_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gchar* bundle_get_string (Bundle* self, const gchar* key);
static void search_page_real_on_leave (IPage* base);
static gboolean __lambda157_ (SearchPage* self);
void tweet_list_box_remove_all (TweetListBox* self);
static gboolean ___lambda157__gsource_func (gpointer self);
void tweet_list_box_set_unempty (TweetListBox* self);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void search_page_show_entries (SearchPage* self, GError* e);
static void _search_page_show_entries_collect_finished (Collect* _sender, GError* _error_, gpointer self);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
GType user_list_entry_get_type (void) G_GNUC_CONST;
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
gint64 user_list_entry_get_user_id (UserListEntry* self);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
gchar* user_list_entry_get_screen_name (UserListEntry* self);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define TWEET_INFO_PAGE_BY_INSTANCE 1
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType itwitter_item_get_type (void) G_GNUC_CONST;
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void tweet_utils_load_threaded (RestProxyCall* call, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void __lambda153_ (SearchPage* self, GObject* _, GAsyncResult* res);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
gboolean collect_get_done (Collect* self);
void collect_emit (Collect* self, GError* _error_);
void tweet_list_box_set_empty (TweetListBox* self);
static void __lambda154_ (SearchPage* self, JsonArray* array, guint index, JsonNode* node);
UserListEntry* user_list_entry_new (void);
UserListEntry* user_list_entry_construct (GType object_type);
void user_list_entry_set_user_id (UserListEntry* self, gint64 value);
void user_list_entry_set_screen_name (UserListEntry* self, const gchar* sn);
void user_list_entry_set_name (UserListEntry* self, const gchar* value);
void user_list_entry_set_avatar_url (UserListEntry* self, const gchar* value);
void user_list_entry_set_verified (UserListEntry* self, gboolean value);
void user_list_entry_set_show_settings (UserListEntry* self, gboolean value);
static void ___lambda154__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda153__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda151_ (SearchPage* self, GObject* _, GAsyncResult* res);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda152_ (Block7Data* _data7_, JsonArray* array, guint index, JsonNode* node);
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry);
static void ___lambda152__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda151__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda150_ (SearchPage* self, GtkWidget* w);
static void ___lambda150__gtk_callback (GtkWidget* widget, gpointer self);
static void search_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
GType badge_radio_button_get_type (void) G_GNUC_CONST;
static GtkRadioButton* search_page_real_get_radio_button (IPage* base);
static gchar* search_page_real_get_title (IPage* base);
static gboolean search_page_real_handles_double_open (IPage* base);
gint search_page_get_unread_count (SearchPage* self);
static void search_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_search_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_search_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define LOAD_MORE_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LOAD_MORE_ENTRY, LoadMoreEntryPrivate))
enum  {
	LOAD_MORE_ENTRY_DUMMY_PROPERTY,
	LOAD_MORE_ENTRY_SORT_FACTOR,
	LOAD_MORE_ENTRY_SEEN
};
static gint load_more_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now);
gboolean load_more_entry_get_seen (LoadMoreEntry* self);
void load_more_entry_set_seen (LoadMoreEntry* self, gboolean value);
static void load_more_entry_finalize (GObject* obj);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
static void _vala_load_more_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_load_more_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _search_page_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	search_page_header_func ((SearchPage*) self, row, before);
}


static gint _itwitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = itwitter_item_sort_func (row1, row2);
	return result;
}


static void _search_page_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	search_page_row_activated_cb ((SearchPage*) self, row);
}


static void _search_page_retry_button_clicked_cb_tweet_list_box_retry_button_clicked (TweetListBox* _sender, gpointer self) {
	search_page_retry_button_clicked_cb ((SearchPage*) self);
}


static void __lambda155_ (SearchPage* self) {
	GtkSearchEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
	search_page_search_for (self, _tmp1_, FALSE);
}


static void ___lambda155__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda155_ ((SearchPage*) self);
}


static void __lambda156_ (SearchPage* self) {
	gint _tmp0_ = 0;
	_tmp0_ = self->priv->user_page;
	self->priv->user_page = _tmp0_ + 1;
	search_page_load_users (self);
}


static void ___lambda156__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda156_ ((SearchPage*) self);
}


static void _search_page_load_tweets_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	search_page_load_tweets ((SearchPage*) self);
}


SearchPage* search_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater) {
	SearchPage * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	DeltaUpdater* _tmp2_ = NULL;
	DeltaUpdater* _tmp3_ = NULL;
	TweetListBox* _tmp4_ = NULL;
	TweetListBox* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	TweetListBox* _tmp7_ = NULL;
	TweetListBox* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	LoadMoreEntry* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	ScrollWidget* _tmp13_ = NULL;
	TweetListBox* _tmp14_ = NULL;
	GtkStack* _tmp15_ = NULL;
	GtkStack* _tmp16_ = NULL;
	TweetListBox* _tmp17_ = NULL;
	ScrollWidget* _tmp18_ = NULL;
	GtkAdjustment* _tmp19_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	g_return_val_if_fail (IS_DELTA_UPDATER (delta_updater), NULL);
	self = (SearchPage*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = delta_updater;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->delta_updater);
	self->delta_updater = _tmp3_;
	_tmp4_ = self->priv->tweet_list;
	gtk_list_box_bind_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_box_get_type (), GtkListBox), NULL, NULL, NULL, NULL);
	_tmp5_ = self->priv->tweet_list;
	gtk_list_box_set_header_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_list_box_get_type (), GtkListBox), _search_page_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp6_ = self->priv->tweet_list;
	gtk_list_box_set_sort_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_get_type (), GtkListBox), _itwitter_item_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp7_ = self->priv->tweet_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) _search_page_row_activated_cb_gtk_list_box_row_activated, self, 0);
	_tmp8_ = self->priv->tweet_list;
	g_signal_connect_object (_tmp8_, "retry-button-clicked", (GCallback) _search_page_retry_button_clicked_cb_tweet_list_box_retry_button_clicked, self, 0);
	_tmp9_ = self->priv->search_button;
	g_signal_connect_object (_tmp9_, "clicked", (GCallback) ___lambda155__gtk_button_clicked, self, 0);
	_tmp10_ = self->priv->load_more_entry;
	_tmp11_ = load_more_entry_get_button (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_connect_object (_tmp12_, "clicked", (GCallback) ___lambda156__gtk_button_clicked, self, 0);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->scroll_widget;
	g_signal_connect_object (_tmp13_, "scrolled-to-end", (GCallback) _search_page_load_tweets_scroll_widget_scrolled_to_end, self, 0);
	_tmp14_ = self->priv->tweet_list;
	_tmp15_ = tweet_list_box_get_placeholder (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp16_);
	_tmp17_ = self->priv->tweet_list;
	_tmp18_ = self->priv->scroll_widget;
	_tmp19_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	gtk_list_box_set_adjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_list_box_get_type (), GtkListBox), _tmp19_);
	return self;
}


SearchPage* search_page_new (gint id, Account* account, DeltaUpdater* delta_updater) {
	return search_page_construct (TYPE_SEARCH_PAGE, id, account, delta_updater);
}


static void search_page_search_entry_activate_cb (SearchPage* self) {
	GtkSearchEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
	search_page_search_for (self, _tmp1_, FALSE);
}


static void _search_page_search_entry_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_page_search_entry_activate_cb ((SearchPage*) self);
}


static void search_page_retry_button_clicked_cb (SearchPage* self) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->last_search_query;
	search_page_search_for (self, _tmp0_, FALSE);
}


/**
   * see IPage#onJoin
   */
static void search_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	SearchPage * self;
	gchar* _tmp0_ = NULL;
	Bundle* _tmp1_ = NULL;
	gchar* term = NULL;
	gchar* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp15_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp1_ = args;
	if (_tmp1_ != NULL) {
		Bundle* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = args;
		_tmp3_ = bundle_get_string (_tmp2_, "query");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	_tmp4_ = g_strdup (_tmp0_);
	term = _tmp4_;
	_tmp5_ = self->priv->remove_content_timeout;
	if (_tmp5_ != ((guint) 0)) {
		guint _tmp6_ = 0U;
		_tmp6_ = self->priv->remove_content_timeout;
		g_source_remove (_tmp6_);
		self->priv->remove_content_timeout = (guint) 0;
	}
	_tmp7_ = term;
	if (_tmp7_ == NULL) {
		gboolean _tmp8_ = FALSE;
		GtkWidget* _tmp9_ = NULL;
		_tmp9_ = self->priv->last_focus_widget;
		if (_tmp9_ != NULL) {
			GtkWidget* _tmp10_ = NULL;
			GtkContainer* _tmp11_ = NULL;
			GtkContainer* _tmp12_ = NULL;
			_tmp10_ = self->priv->last_focus_widget;
			_tmp11_ = gtk_widget_get_parent (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp8_ = _tmp12_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GtkWidget* _tmp13_ = NULL;
			_tmp13_ = self->priv->last_focus_widget;
			gtk_widget_grab_focus (_tmp13_);
		} else {
			GtkSearchEntry* _tmp14_ = NULL;
			_tmp14_ = self->priv->search_entry;
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
		}
		_g_free0 (term);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp15_ = term;
	search_page_search_for (self, _tmp15_, TRUE);
	_g_free0 (term);
	_g_free0 (_tmp0_);
}


static gboolean __lambda157_ (SearchPage* self) {
	gboolean result = FALSE;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkStack* _tmp3_ = NULL;
	_tmp0_ = self->priv->tweet_list;
	tweet_list_box_remove_all (_tmp0_);
	_tmp1_ = self->priv->tweet_list;
	_tmp2_ = tweet_list_box_get_placeholder (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (self->priv->last_focus_widget);
	self->priv->last_focus_widget = NULL;
	self->priv->remove_content_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda157__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda157_ ((SearchPage*) self);
	return result;
}


static void search_page_real_on_leave (IPage* base) {
	SearchPage * self;
	guint _tmp0_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((3 * 1000) * 60), ___lambda157__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->remove_content_timeout = _tmp0_;
}


static void _search_page_show_entries_collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	search_page_show_entries ((SearchPage*) self, _error_);
}


void search_page_search_for (SearchPage* self, const gchar* search_term, gboolean set_text) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp7_ = NULL;
	gchar* q = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	TweetListBox* _tmp10_ = NULL;
	TweetListBox* _tmp11_ = NULL;
	TweetListBox* _tmp12_ = NULL;
	GtkStack* _tmp13_ = NULL;
	GtkStack* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	Collect* _tmp22_ = NULL;
	Collect* _tmp23_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_return_if_fail (search_term != NULL);
	_tmp0_ = search_term;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = search_term;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->last_search_query);
	self->priv->last_search_query = _tmp4_;
	_tmp5_ = self->priv->cancellable;
	if (_tmp5_ != NULL) {
		GCancellable* _tmp6_ = NULL;
		g_debug ("SearchPage.vala:143: Cancelling earlier search...");
		_tmp6_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp6_);
	}
	_tmp7_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp7_;
	self->priv->n_results = 0;
	_tmp8_ = search_term;
	_tmp9_ = g_strdup (_tmp8_);
	q = _tmp9_;
	_tmp10_ = self->priv->tweet_list;
	tweet_list_box_remove_all (_tmp10_);
	_tmp11_ = self->priv->tweet_list;
	tweet_list_box_set_unempty (_tmp11_);
	_tmp12_ = self->priv->tweet_list;
	_tmp13_ = tweet_list_box_get_placeholder (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp14_);
	_tmp15_ = set_text;
	if (_tmp15_) {
		GtkSearchEntry* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = self->priv->search_entry;
		_tmp17_ = search_term;
		gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_entry_get_type (), GtkEntry), _tmp17_);
	}
	_tmp18_ = q;
	_tmp19_ = g_strconcat (_tmp18_, " -rt", NULL);
	_g_free0 (q);
	q = _tmp19_;
	_tmp20_ = q;
	_tmp21_ = g_uri_escape_string (_tmp20_, NULL, TRUE);
	_g_free0 (self->priv->search_query);
	self->priv->search_query = _tmp21_;
	self->priv->user_page = 1;
	self->priv->lowest_tweet_id = G_MAXINT64 - 1;
	_tmp22_ = collect_new (2);
	_g_object_unref0 (self->priv->collect_obj);
	self->priv->collect_obj = _tmp22_;
	_tmp23_ = self->priv->collect_obj;
	g_signal_connect_object (_tmp23_, "finished", (GCallback) _search_page_show_entries_collect_finished, self, 0);
	search_page_load_tweets (self);
	search_page_load_users (self);
	_g_free0 (q);
}


static void search_page_row_activated_cb (SearchPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->last_focus_widget);
	self->priv->last_focus_widget = _tmp1_;
	_tmp2_ = bundle_new ();
	bundle = _tmp2_;
	_tmp3_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_USER_LIST_ENTRY)) {
		Bundle* _tmp4_ = NULL;
		GtkListBoxRow* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
		Bundle* _tmp8_ = NULL;
		GtkListBoxRow* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		MainWindow* _tmp13_ = NULL;
		MainWidget* _tmp14_ = NULL;
		Bundle* _tmp15_ = NULL;
		_tmp4_ = bundle;
		_tmp5_ = row;
		_tmp6_ = user_list_entry_get_user_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_USER_LIST_ENTRY, UserListEntry));
		_tmp7_ = _tmp6_;
		bundle_put_int64 (_tmp4_, "user_id", _tmp7_);
		_tmp8_ = bundle;
		_tmp9_ = row;
		_tmp10_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_USER_LIST_ENTRY, UserListEntry));
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		bundle_put_string (_tmp8_, "screen_name", _tmp12_);
		_g_free0 (_tmp12_);
		_tmp13_ = self->priv->main_window;
		_tmp14_ = _tmp13_->main_widget;
		_tmp15_ = bundle;
		main_widget_switch_page (_tmp14_, (gint) PAGE_PROFILE, _tmp15_);
	} else {
		GtkListBoxRow* _tmp16_ = NULL;
		_tmp16_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_TWEET_LIST_ENTRY)) {
			Bundle* _tmp17_ = NULL;
			Bundle* _tmp18_ = NULL;
			GtkListBoxRow* _tmp19_ = NULL;
			CbTweet* _tmp20_ = NULL;
			MainWindow* _tmp21_ = NULL;
			MainWidget* _tmp22_ = NULL;
			Bundle* _tmp23_ = NULL;
			_tmp17_ = bundle;
			bundle_put_int (_tmp17_, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
			_tmp18_ = bundle;
			_tmp19_ = row;
			_tmp20_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
			bundle_put_object (_tmp18_, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, G_TYPE_OBJECT, GObject));
			_tmp21_ = self->priv->main_window;
			_tmp22_ = _tmp21_->main_widget;
			_tmp23_ = bundle;
			main_widget_switch_page (_tmp22_, (gint) PAGE_TWEET_INFO, _tmp23_);
		}
	}
	_g_object_unref0 (bundle);
}


static void search_page_header_func (SearchPage* self, GtkListBoxRow* row, GtkListBoxRow* before) {
	GtkWidget* header = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkListBoxRow* _tmp5_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	g_return_if_fail ((before == NULL) || GTK_IS_LIST_BOX_ROW (before));
	_tmp0_ = row;
	_tmp1_ = gtk_list_box_row_get_header (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	header = _tmp2_;
	_tmp3_ = header;
	if (_tmp3_ != NULL) {
		_g_object_unref0 (header);
		return;
	}
	_tmp5_ = before;
	if (_tmp5_ == NULL) {
		GtkListBoxRow* _tmp6_ = NULL;
		_tmp6_ = row;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_USER_LIST_ENTRY);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkListBoxRow* _tmp7_ = NULL;
		GtkLabel* _tmp8_ = NULL;
		_tmp7_ = row;
		_tmp8_ = self->priv->users_header;
		gtk_list_box_row_set_header (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GtkListBoxRow* _tmp11_ = NULL;
		_tmp11_ = before;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_USER_LIST_ENTRY)) {
			_tmp10_ = TRUE;
		} else {
			GtkListBoxRow* _tmp12_ = NULL;
			_tmp12_ = before;
			_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_LOAD_MORE_ENTRY);
		}
		if (_tmp10_) {
			GtkListBoxRow* _tmp13_ = NULL;
			_tmp13_ = row;
			_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_TWEET_LIST_ENTRY);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkListBoxRow* _tmp14_ = NULL;
			GtkLabel* _tmp15_ = NULL;
			_tmp14_ = row;
			_tmp15_ = self->priv->tweets_header;
			gtk_list_box_row_set_header (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
		}
	}
	_g_object_unref0 (header);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda154_ (SearchPage* self, JsonArray* array, guint index, JsonNode* node) {
	guint _tmp0_ = 0U;
	JsonObject* user_obj = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	UserListEntry* entry = NULL;
	UserListEntry* _tmp4_ = NULL;
	gchar* avatar_url = NULL;
	JsonObject* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	UserListEntry* _tmp11_ = NULL;
	JsonObject* _tmp12_ = NULL;
	gint64 _tmp13_ = 0LL;
	UserListEntry* _tmp14_ = NULL;
	JsonObject* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	UserListEntry* _tmp19_ = NULL;
	JsonObject* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	UserListEntry* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	UserListEntry* _tmp26_ = NULL;
	JsonObject* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	UserListEntry* _tmp29_ = NULL;
	Collect* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	TweetListBox* _tmp34_ = NULL;
	UserListEntry* _tmp35_ = NULL;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = index;
	if (_tmp0_ > ((guint) (SEARCH_PAGE_USER_COUNT - 1))) {
		return;
	}
	_tmp1_ = node;
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	user_obj = _tmp3_;
	_tmp4_ = user_list_entry_new ();
	g_object_ref_sink (_tmp4_);
	entry = _tmp4_;
	_tmp5_ = user_obj;
	_tmp6_ = json_object_get_string_member (_tmp5_, "profile_image_url");
	_tmp7_ = g_strdup (_tmp6_);
	avatar_url = _tmp7_;
	_tmp8_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp8_ == 2) {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = avatar_url;
		_tmp10_ = string_replace (_tmp9_, "_normal", "_bigger");
		_g_free0 (avatar_url);
		avatar_url = _tmp10_;
	}
	_tmp11_ = entry;
	_tmp12_ = user_obj;
	_tmp13_ = json_object_get_int_member (_tmp12_, "id");
	user_list_entry_set_user_id (_tmp11_, _tmp13_);
	_tmp14_ = entry;
	_tmp15_ = user_obj;
	_tmp16_ = json_object_get_string_member (_tmp15_, "screen_name");
	_tmp17_ = g_strconcat ("@", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	user_list_entry_set_screen_name (_tmp14_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = entry;
	_tmp20_ = user_obj;
	_tmp21_ = json_object_get_string_member (_tmp20_, "name");
	_tmp22_ = string_strip (_tmp21_);
	_tmp23_ = _tmp22_;
	user_list_entry_set_name (_tmp19_, _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = entry;
	_tmp25_ = avatar_url;
	user_list_entry_set_avatar_url (_tmp24_, _tmp25_);
	_tmp26_ = entry;
	_tmp27_ = user_obj;
	_tmp28_ = json_object_get_boolean_member (_tmp27_, "verified");
	user_list_entry_set_verified (_tmp26_, _tmp28_);
	_tmp29_ = entry;
	user_list_entry_set_show_settings (_tmp29_, FALSE);
	_tmp30_ = self->priv->collect_obj;
	_tmp31_ = collect_get_done (_tmp30_);
	_tmp32_ = _tmp31_;
	if (!_tmp32_) {
		UserListEntry* _tmp33_ = NULL;
		_tmp33_ = entry;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_tmp34_ = self->priv->tweet_list;
	_tmp35_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget));
	_g_free0 (avatar_url);
	_g_object_unref0 (entry);
	_json_object_unref0 (user_obj);
}


static void ___lambda154__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda154_ ((SearchPage*) self, array, index_, element_node);
}


static void __lambda153_ (SearchPage* self, GObject* _, GAsyncResult* res) {
	JsonNode* root = NULL;
	JsonNode* _tmp13_ = NULL;
	JsonArray* users = NULL;
	JsonNode* _tmp18_ = NULL;
	JsonArray* _tmp19_ = NULL;
	JsonArray* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	JsonArray* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	gint _tmp28_ = 0;
	JsonArray* _tmp30_ = NULL;
	JsonArray* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	Collect* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		JsonNode* _tmp2_ = NULL;
		JsonNode* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		TweetListBox* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		Collect* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("SearchPage.vala:217: %s", _tmp5_);
		_tmp6_ = self->priv->tweet_list;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		tweet_list_box_set_error (_tmp6_, _tmp8_);
		_tmp9_ = self->priv->collect_obj;
		_tmp10_ = collect_get_done (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			Collect* _tmp12_ = NULL;
			_tmp12_ = self->priv->collect_obj;
			collect_emit (_tmp12_, NULL);
		}
		self->priv->loading_users = FALSE;
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		return;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = root;
	if (_tmp13_ == NULL) {
		Collect* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		self->priv->loading_users = FALSE;
		g_debug ("SearchPage.vala:229: load_users: root is null");
		_tmp14_ = self->priv->collect_obj;
		_tmp15_ = collect_get_done (_tmp14_);
		_tmp16_ = _tmp15_;
		if (!_tmp16_) {
			Collect* _tmp17_ = NULL;
			_tmp17_ = self->priv->collect_obj;
			collect_emit (_tmp17_, NULL);
		}
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp18_ = root;
	_tmp19_ = json_node_get_array (_tmp18_);
	_tmp20_ = _json_array_ref0 (_tmp19_);
	users = _tmp20_;
	_tmp22_ = users;
	_tmp23_ = json_array_get_length (_tmp22_);
	if (_tmp23_ == ((guint) 0)) {
		gint _tmp24_ = 0;
		_tmp24_ = self->priv->n_results;
		_tmp21_ = _tmp24_ <= 0;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		self->priv->n_results = -1;
	} else {
		gint _tmp25_ = 0;
		JsonArray* _tmp26_ = NULL;
		guint _tmp27_ = 0U;
		_tmp25_ = self->priv->n_results;
		_tmp26_ = users;
		_tmp27_ = json_array_get_length (_tmp26_);
		self->priv->n_results = _tmp25_ + ((gint) _tmp27_);
	}
	_tmp28_ = self->priv->n_results;
	if (_tmp28_ <= 0) {
		TweetListBox* _tmp29_ = NULL;
		_tmp29_ = self->priv->tweet_list;
		tweet_list_box_set_empty (_tmp29_);
	}
	_tmp30_ = users;
	json_array_foreach_element (_tmp30_, ___lambda154__json_array_foreach, self);
	_tmp31_ = users;
	_tmp32_ = json_array_get_length (_tmp31_);
	if (_tmp32_ > ((guint) SEARCH_PAGE_USER_COUNT)) {
		LoadMoreEntry* _tmp33_ = NULL;
		GtkContainer* _tmp34_ = NULL;
		GtkContainer* _tmp35_ = NULL;
		_tmp33_ = self->priv->load_more_entry;
		_tmp34_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget));
		_tmp35_ = _tmp34_;
		if (_tmp35_ == NULL) {
			LoadMoreEntry* _tmp36_ = NULL;
			TweetListBox* _tmp37_ = NULL;
			LoadMoreEntry* _tmp38_ = NULL;
			_tmp36_ = self->priv->load_more_entry;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp37_ = self->priv->tweet_list;
			_tmp38_ = self->priv->load_more_entry;
			gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
		}
	} else {
		LoadMoreEntry* _tmp39_ = NULL;
		_tmp39_ = self->priv->load_more_entry;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp40_ = self->priv->collect_obj;
	_tmp41_ = collect_get_done (_tmp40_);
	_tmp42_ = _tmp41_;
	if (!_tmp42_) {
		Collect* _tmp43_ = NULL;
		_tmp43_ = self->priv->collect_obj;
		collect_emit (_tmp43_, NULL);
	}
	self->priv->loading_users = FALSE;
	_json_array_unref0 (users);
	__vala_JsonNode_free0 (root);
}


static void ___lambda153__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda153_ ((SearchPage*) self, source_object, res);
	g_object_unref (self);
}


static void search_page_load_users (SearchPage* self) {
	gboolean _tmp0_ = FALSE;
	RestProxyCall* user_call = NULL;
	Account* _tmp1_ = NULL;
	OAuthProxy* _tmp2_ = NULL;
	RestProxyCall* _tmp3_ = NULL;
	RestProxyCall* _tmp4_ = NULL;
	RestProxyCall* _tmp5_ = NULL;
	RestProxyCall* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RestProxyCall* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	RestProxyCall* _tmp11_ = NULL;
	RestProxyCall* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	RestProxyCall* _tmp16_ = NULL;
	GCancellable* _tmp17_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->loading_users;
	if (_tmp0_) {
		return;
	}
	self->priv->loading_users = TRUE;
	_tmp1_ = self->account;
	_tmp2_ = _tmp1_->proxy;
	_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, rest_proxy_get_type (), RestProxy));
	user_call = _tmp3_;
	_tmp4_ = user_call;
	rest_proxy_call_set_method (_tmp4_, "GET");
	_tmp5_ = user_call;
	rest_proxy_call_set_function (_tmp5_, "1.1/users/search.json");
	_tmp6_ = user_call;
	_tmp7_ = self->priv->search_query;
	rest_proxy_call_add_param (_tmp6_, "q", _tmp7_);
	_tmp8_ = user_call;
	_tmp9_ = g_strdup_printf ("%i", SEARCH_PAGE_USER_COUNT + 1);
	_tmp10_ = _tmp9_;
	rest_proxy_call_add_param (_tmp8_, "count", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = user_call;
	rest_proxy_call_add_param (_tmp11_, "include_entities", "false");
	_tmp12_ = user_call;
	_tmp13_ = self->priv->user_page;
	_tmp14_ = g_strdup_printf ("%i", _tmp13_);
	_tmp15_ = _tmp14_;
	rest_proxy_call_add_param (_tmp12_, "page", _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = user_call;
	_tmp17_ = self->priv->cancellable;
	tweet_utils_load_threaded (_tmp16_, _tmp17_, ___lambda153__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (user_call);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SearchPage* self;
		self = _data7_->self;
		_g_date_time_unref0 (_data7_->now);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda152_ (Block7Data* _data7_, JsonArray* array, guint index, JsonNode* node) {
	SearchPage* self;
	CbTweet* tweet = NULL;
	CbTweet* _tmp0_ = NULL;
	CbTweet* _tmp1_ = NULL;
	JsonNode* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	GDateTime* _tmp5_ = NULL;
	CbTweet* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	TweetListEntry* entry = NULL;
	CbTweet* _tmp11_ = NULL;
	MainWindow* _tmp12_ = NULL;
	Account* _tmp13_ = NULL;
	TweetListEntry* _tmp14_ = NULL;
	DeltaUpdater* _tmp15_ = NULL;
	TweetListEntry* _tmp16_ = NULL;
	Collect* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	TweetListBox* _tmp22_ = NULL;
	TweetListEntry* _tmp23_ = NULL;
	self = _data7_->self;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = cb_tweet_new ();
	tweet = _tmp0_;
	_tmp1_ = tweet;
	_tmp2_ = node;
	_tmp3_ = self->account;
	_tmp4_ = _tmp3_->id;
	_tmp5_ = _data7_->now;
	cb_tweet_load_from_json (_tmp1_, _tmp2_, _tmp4_, _tmp5_);
	_tmp6_ = tweet;
	_tmp7_ = _tmp6_->id;
	_tmp8_ = self->priv->lowest_tweet_id;
	if (_tmp7_ < _tmp8_) {
		CbTweet* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		_tmp9_ = tweet;
		_tmp10_ = _tmp9_->id;
		self->priv->lowest_tweet_id = _tmp10_;
	}
	_tmp11_ = tweet;
	_tmp12_ = self->priv->main_window;
	_tmp13_ = self->account;
	_tmp14_ = tweet_list_entry_new (_tmp11_, _tmp12_, _tmp13_, FALSE);
	g_object_ref_sink (_tmp14_);
	entry = _tmp14_;
	_tmp15_ = self->delta_updater;
	_tmp16_ = entry;
	delta_updater_add (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp17_ = self->priv->collect_obj;
	_tmp18_ = collect_get_done (_tmp17_);
	_tmp19_ = _tmp18_;
	if (!_tmp19_) {
		TweetListEntry* _tmp20_ = NULL;
		_tmp20_ = entry;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), FALSE);
	} else {
		TweetListEntry* _tmp21_ = NULL;
		_tmp21_ = entry;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp22_ = self->priv->tweet_list;
	_tmp23_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_g_object_unref0 (tweet);
}


static void ___lambda152__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda152_ (self, array, index_, element_node);
}


static void __lambda151_ (SearchPage* self, GObject* _, GAsyncResult* res) {
	Block7Data* _data7_;
	JsonNode* root = NULL;
	JsonNode* _tmp13_ = NULL;
	GDateTime* _tmp18_ = NULL;
	JsonArray* statuses = NULL;
	JsonNode* _tmp19_ = NULL;
	JsonObject* _tmp20_ = NULL;
	JsonArray* _tmp21_ = NULL;
	JsonArray* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	JsonArray* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	gint _tmp30_ = 0;
	JsonArray* _tmp32_ = NULL;
	Collect* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		JsonNode* _tmp2_ = NULL;
		JsonNode* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		TweetListBox* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		Collect* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("SearchPage.vala:301: %s", _tmp5_);
		_tmp6_ = self->priv->tweet_list;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		tweet_list_box_set_error (_tmp6_, _tmp8_);
		_tmp9_ = self->priv->collect_obj;
		_tmp10_ = collect_get_done (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			Collect* _tmp12_ = NULL;
			_tmp12_ = self->priv->collect_obj;
			collect_emit (_tmp12_, NULL);
		}
		self->priv->loading_tweets = FALSE;
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = root;
	if (_tmp13_ == NULL) {
		Collect* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		g_debug ("SearchPage.vala:311: load tweets: root is null");
		self->priv->loading_tweets = FALSE;
		_tmp14_ = self->priv->collect_obj;
		_tmp15_ = collect_get_done (_tmp14_);
		_tmp16_ = _tmp15_;
		if (!_tmp16_) {
			Collect* _tmp17_ = NULL;
			_tmp17_ = self->priv->collect_obj;
			collect_emit (_tmp17_, NULL);
		}
		__vala_JsonNode_free0 (root);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp18_ = g_date_time_new_now_local ();
	_data7_->now = _tmp18_;
	_tmp19_ = root;
	_tmp20_ = json_node_get_object (_tmp19_);
	_tmp21_ = json_object_get_array_member (_tmp20_, "statuses");
	_tmp22_ = _json_array_ref0 (_tmp21_);
	statuses = _tmp22_;
	_tmp24_ = statuses;
	_tmp25_ = json_array_get_length (_tmp24_);
	if (_tmp25_ == ((guint) 0)) {
		gint _tmp26_ = 0;
		_tmp26_ = self->priv->n_results;
		_tmp23_ = _tmp26_ <= 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		self->priv->n_results = -1;
	} else {
		gint _tmp27_ = 0;
		JsonArray* _tmp28_ = NULL;
		guint _tmp29_ = 0U;
		_tmp27_ = self->priv->n_results;
		_tmp28_ = statuses;
		_tmp29_ = json_array_get_length (_tmp28_);
		self->priv->n_results = _tmp27_ + ((gint) _tmp29_);
	}
	_tmp30_ = self->priv->n_results;
	if (_tmp30_ <= 0) {
		TweetListBox* _tmp31_ = NULL;
		_tmp31_ = self->priv->tweet_list;
		tweet_list_box_set_empty (_tmp31_);
	}
	_tmp32_ = statuses;
	json_array_foreach_element (_tmp32_, ___lambda152__json_array_foreach, _data7_);
	_tmp33_ = self->priv->collect_obj;
	_tmp34_ = collect_get_done (_tmp33_);
	_tmp35_ = _tmp34_;
	if (!_tmp35_) {
		Collect* _tmp36_ = NULL;
		_tmp36_ = self->priv->collect_obj;
		collect_emit (_tmp36_, NULL);
	}
	self->priv->loading_tweets = FALSE;
	_json_array_unref0 (statuses);
	__vala_JsonNode_free0 (root);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static void ___lambda151__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda151_ ((SearchPage*) self, source_object, res);
	g_object_unref (self);
}


static void search_page_load_tweets (SearchPage* self) {
	gboolean _tmp0_ = FALSE;
	RestProxyCall* call = NULL;
	Account* _tmp1_ = NULL;
	OAuthProxy* _tmp2_ = NULL;
	RestProxyCall* _tmp3_ = NULL;
	RestProxyCall* _tmp4_ = NULL;
	RestProxyCall* _tmp5_ = NULL;
	RestProxyCall* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RestProxyCall* _tmp8_ = NULL;
	RestProxyCall* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	RestProxyCall* _tmp13_ = NULL;
	RestProxyCall* _tmp14_ = NULL;
	GCancellable* _tmp15_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->loading_tweets;
	if (_tmp0_) {
		return;
	}
	self->priv->loading_tweets = TRUE;
	_tmp1_ = self->account;
	_tmp2_ = _tmp1_->proxy;
	_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, rest_proxy_get_type (), RestProxy));
	call = _tmp3_;
	_tmp4_ = call;
	rest_proxy_call_set_function (_tmp4_, "1.1/search/tweets.json");
	_tmp5_ = call;
	rest_proxy_call_set_method (_tmp5_, "GET");
	_tmp6_ = call;
	_tmp7_ = self->priv->search_query;
	rest_proxy_call_add_param (_tmp6_, "q", _tmp7_);
	_tmp8_ = call;
	rest_proxy_call_add_param (_tmp8_, "tweet_mode", "extended");
	_tmp9_ = call;
	_tmp10_ = self->priv->lowest_tweet_id;
	_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_ - 1);
	_tmp12_ = _tmp11_;
	rest_proxy_call_add_param (_tmp9_, "max_id", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = call;
	rest_proxy_call_add_param (_tmp13_, "count", "35");
	_tmp14_ = call;
	_tmp15_ = self->priv->cancellable;
	tweet_utils_load_threaded (_tmp14_, _tmp15_, ___lambda151__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (call);
}


static void __lambda150_ (SearchPage* self, GtkWidget* w) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_widget_show (_tmp0_);
}


static void ___lambda150__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda150_ ((SearchPage*) self, widget);
}


static void search_page_show_entries (SearchPage* self, GError* e) {
	GError* _tmp0_ = NULL;
	TweetListBox* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = e;
	if (_tmp0_ != NULL) {
		TweetListBox* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		TweetListBox* _tmp4_ = NULL;
		_tmp1_ = self->priv->tweet_list;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		tweet_list_box_set_error (_tmp1_, _tmp3_);
		_tmp4_ = self->priv->tweet_list;
		tweet_list_box_set_empty (_tmp4_);
		self->priv->loading_tweets = FALSE;
		self->priv->loading_users = FALSE;
		return;
	}
	_tmp5_ = self->priv->tweet_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), ___lambda150__gtk_callback, self);
	self->priv->loading_tweets = FALSE;
	self->priv->loading_users = FALSE;
	_tmp6_ = self->priv->tweet_list;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
}


static void search_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	SearchPage * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Search");
	_tmp2_ = badge_radio_button_new (_tmp0_, "edit-find-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->radio_button);
	self->priv->radio_button = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_radio_button_get_type (), GtkRadioButton);
}


static GtkRadioButton* search_page_real_get_radio_button (IPage* base) {
	SearchPage * self;
	GtkRadioButton* result = NULL;
	GtkRadioButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->radio_button;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* search_page_real_get_title (IPage* base) {
	SearchPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = _ ("Search");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean search_page_real_handles_double_open (IPage* base) {
	SearchPage * self;
	gboolean result = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	result = TRUE;
	return result;
}


gint search_page_get_unread_count (SearchPage* self) {
	gint result;
	g_return_val_if_fail (IS_SEARCH_PAGE (self), 0);
	result = 0;
	return result;
}


static gint search_page_real_get_id (IPage* base) {
	gint result;
	SearchPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void search_page_real_set_id (IPage* base, gint value) {
	SearchPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void search_page_real_set_window (IPage* base, MainWindow* value) {
	SearchPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


static void search_page_class_init (SearchPageClass * klass) {
	gint SearchPage_private_offset;
	search_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SearchPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_search_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_search_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = search_page_finalize;
	/** The unread count here is always zero */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	SearchPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/search-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_button", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, search_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_list", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "users_header", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, users_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweets_header", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, tweets_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scroll_widget", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, scroll_widget));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "search_entry_activate_cb", G_CALLBACK(_search_page_search_entry_activate_cb_gtk_entry_activate));
}


static void search_page_ipage_interface_init (IPageIface * iface) {
	search_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) search_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) search_page_real_on_leave;
	iface->create_radio_button = (void (*)(IPage*, GtkRadioButton*)) search_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*)(IPage*)) search_page_real_get_radio_button;
	iface->get_title = (gchar* (*)(IPage*)) search_page_real_get_title;
	iface->handles_double_open = (gboolean (*)(IPage*)) search_page_real_handles_double_open;
	iface->get_id = search_page_real_get_id;
	iface->set_id = search_page_real_set_id;
	iface->set_window = search_page_real_set_window;
}


static void search_page_instance_init (SearchPage * self) {
	LoadMoreEntry* _tmp0_ = NULL;
	self->priv = SEARCH_PAGE_GET_PRIVATE (self);
	self->priv->cancellable = NULL;
	_tmp0_ = load_more_entry_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->load_more_entry = _tmp0_;
	self->priv->user_page = 1;
	self->priv->lowest_tweet_id = G_MAXINT64 - 1;
	self->priv->n_results = 0;
	self->priv->remove_content_timeout = (guint) 0;
	self->priv->loading_tweets = FALSE;
	self->priv->loading_users = FALSE;
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_SCROLL_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void search_page_finalize (GObject* obj) {
	SearchPage * self;
	guint _tmp0_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->remove_content_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->remove_content_timeout;
		g_source_remove (_tmp1_);
		self->priv->remove_content_timeout = (guint) 0;
	}
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->search_button);
	_g_object_unref0 (self->priv->tweet_list);
	_g_object_unref0 (self->priv->users_header);
	_g_object_unref0 (self->priv->tweets_header);
	_g_object_unref0 (self->priv->scroll_widget);
	_g_object_unref0 (self->priv->radio_button);
	_g_object_unref0 (self->delta_updater);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->load_more_entry);
	_g_free0 (self->priv->search_query);
	_g_object_unref0 (self->priv->last_focus_widget);
	_g_object_unref0 (self->priv->collect_obj);
	_g_free0 (self->priv->last_search_query);
	G_OBJECT_CLASS (search_page_parent_class)->finalize (obj);
}


GType search_page_get_type (void) {
	static volatile gsize search_page_type_id__volatile = 0;
	if (g_once_init_enter (&search_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchPage), 0, (GInstanceInitFunc) search_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) search_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType search_page_type_id;
		search_page_type_id = g_type_register_static (gtk_box_get_type (), "SearchPage", &g_define_type_info, 0);
		g_type_add_interface_static (search_page_type_id, TYPE_IPAGE, &ipage_info);
		g_once_init_leave (&search_page_type_id__volatile, search_page_type_id);
	}
	return search_page_type_id__volatile;
}


static void _vala_search_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SearchPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SEARCH_PAGE, SearchPage);
	switch (property_id) {
		case SEARCH_PAGE_UNREAD_COUNT:
		g_value_set_int (value, search_page_get_unread_count (self));
		break;
		case SEARCH_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_search_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SearchPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SEARCH_PAGE, SearchPage);
	switch (property_id) {
		case SEARCH_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case SEARCH_PAGE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


LoadMoreEntry* load_more_entry_construct (GType object_type) {
	LoadMoreEntry * self = NULL;
	self = (LoadMoreEntry*) g_object_new (object_type, NULL);
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	return self;
}


LoadMoreEntry* load_more_entry_new (void) {
	return load_more_entry_construct (TYPE_LOAD_MORE_ENTRY);
}


GtkButton* load_more_entry_get_button (LoadMoreEntry* self) {
	GtkButton* result = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	g_return_val_if_fail (IS_LOAD_MORE_ENTRY (self), NULL);
	_tmp0_ = self->priv->load_more_button;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint load_more_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now) {
	LoadMoreEntry * self;
	gint result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	result = 0;
	return result;
}


static gint64 load_more_entry_real_get_sort_factor (ITwitterItem* base) {
	gint64 result;
	LoadMoreEntry* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	result = G_MAXINT64 - 2;
	return result;
}


gboolean load_more_entry_get_seen (LoadMoreEntry* self) {
	gboolean result;
	g_return_val_if_fail (IS_LOAD_MORE_ENTRY (self), FALSE);
	result = TRUE;
	return result;
}


void load_more_entry_set_seen (LoadMoreEntry* self, gboolean value) {
	g_return_if_fail (IS_LOAD_MORE_ENTRY (self));
	g_object_notify ((GObject *) self, "seen");
}


static void load_more_entry_class_init (LoadMoreEntryClass * klass) {
	gint LoadMoreEntry_private_offset;
	load_more_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LoadMoreEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_load_more_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_load_more_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = load_more_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LOAD_MORE_ENTRY_SORT_FACTOR, g_param_spec_int64 ("sort-factor", "sort-factor", "sort-factor", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LOAD_MORE_ENTRY_SEEN, g_param_spec_boolean ("seen", "seen", "seen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	LoadMoreEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/load-more-entry.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "load_more_button", FALSE, LoadMoreEntry_private_offset + G_STRUCT_OFFSET (LoadMoreEntryPrivate, load_more_button));
}


static void load_more_entry_itwitter_item_interface_init (ITwitterItemIface * iface) {
	load_more_entry_itwitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*)(ITwitterItem*, GDateTime*)) load_more_entry_real_update_time_delta;
	iface->get_sort_factor = load_more_entry_real_get_sort_factor;
}


static void load_more_entry_instance_init (LoadMoreEntry * self) {
	self->priv = LOAD_MORE_ENTRY_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void load_more_entry_finalize (GObject* obj) {
	LoadMoreEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	_g_object_unref0 (self->priv->load_more_button);
	G_OBJECT_CLASS (load_more_entry_parent_class)->finalize (obj);
}


GType load_more_entry_get_type (void) {
	static volatile gsize load_more_entry_type_id__volatile = 0;
	if (g_once_init_enter (&load_more_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LoadMoreEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) load_more_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LoadMoreEntry), 0, (GInstanceInitFunc) load_more_entry_instance_init, NULL };
		static const GInterfaceInfo itwitter_item_info = { (GInterfaceInitFunc) load_more_entry_itwitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType load_more_entry_type_id;
		load_more_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "LoadMoreEntry", &g_define_type_info, 0);
		g_type_add_interface_static (load_more_entry_type_id, TYPE_ITWITTER_ITEM, &itwitter_item_info);
		g_once_init_leave (&load_more_entry_type_id__volatile, load_more_entry_type_id);
	}
	return load_more_entry_type_id__volatile;
}


static void _vala_load_more_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	LoadMoreEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	switch (property_id) {
		case LOAD_MORE_ENTRY_SORT_FACTOR:
		g_value_set_int64 (value, itwitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		case LOAD_MORE_ENTRY_SEEN:
		g_value_set_boolean (value, load_more_entry_get_seen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_load_more_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	LoadMoreEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	switch (property_id) {
		case LOAD_MORE_ENTRY_SEEN:
		load_more_entry_set_seen (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



