/* NotificationManager.c generated by valac 0.34.6, the Vala compiler
 * generated from NotificationManager.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"


#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _NotificationManagerPrivate NotificationManagerPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _NotificationManager {
	GObject parent_instance;
	NotificationManagerPrivate * priv;
};

struct _NotificationManagerClass {
	GObjectClass parent_class;
};

struct _NotificationManagerPrivate {
	Account* account;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer notification_manager_parent_class = NULL;

GType notification_manager_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define NOTIFICATION_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFICATION_MANAGER, NotificationManagerPrivate))
enum  {
	NOTIFICATION_MANAGER_DUMMY_PROPERTY
};
NotificationManager* notification_manager_new (Account* account);
NotificationManager* notification_manager_construct (GType object_type, Account* account);
void notification_manager_withdraw (NotificationManager* self, const gchar* id);
gchar* notification_manager_send (NotificationManager* self, const gchar* summary, const gchar* body, const gchar* id_suffix);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
static GVariant* _variant_new4 (gint64 value);
gchar* notification_manager_send_dm (NotificationManager* self, gint64 sender_id, const gchar* existing_id, const gchar* summary, const gchar* text);
static void notification_manager_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


NotificationManager* notification_manager_construct (GType object_type, Account* account) {
	NotificationManager * self = NULL;
	Account* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (NotificationManager*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	return self;
}


NotificationManager* notification_manager_new (Account* account) {
	return notification_manager_construct (TYPE_NOTIFICATION_MANAGER, account);
}


void notification_manager_withdraw (NotificationManager* self, const gchar* id) {
	GApplication* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_NOTIFICATION_MANAGER (self));
	g_return_if_fail (id != NULL);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = id;
	g_application_withdraw_notification (_tmp0_, _tmp1_);
}


static GVariant* _variant_new4 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


gchar* notification_manager_send (NotificationManager* self, const gchar* summary, const gchar* body, const gchar* id_suffix) {
	gchar* result = NULL;
	GNotification* n = NULL;
	const gchar* _tmp0_ = NULL;
	GNotification* _tmp1_ = NULL;
	GNotification* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* id = NULL;
	Account* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GNotification* _tmp12_ = NULL;
	Account* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	GVariant* _tmp15_ = NULL;
	GApplication* _tmp16_ = NULL;
	GNotification* _tmp17_ = NULL;
	g_return_val_if_fail (IS_NOTIFICATION_MANAGER (self), NULL);
	g_return_val_if_fail (summary != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	_tmp0_ = summary;
	_tmp1_ = g_notification_new (_tmp0_);
	n = _tmp1_;
	_tmp2_ = n;
	_tmp3_ = body;
	g_notification_set_body (_tmp2_, _tmp3_);
	_tmp5_ = id_suffix;
	_tmp4_ = _tmp5_;
	if (_tmp4_ == NULL) {
		_tmp4_ = "";
	}
	_tmp6_ = self->priv->account;
	_tmp7_ = _tmp6_->id;
	_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%s-%s", _tmp9_, _tmp4_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	id = _tmp11_;
	_tmp12_ = n;
	_tmp13_ = self->priv->account;
	_tmp14_ = _tmp13_->id;
	_tmp15_ = _variant_new4 (_tmp14_);
	g_notification_set_default_action_and_target_value (_tmp12_, "app.show-window", _tmp15_);
	_g_variant_unref0 (_tmp15_);
	_tmp16_ = g_application_get_default ();
	_tmp17_ = n;
	g_application_send_notification (_tmp16_, id, _tmp17_);
	result = id;
	_g_object_unref0 (n);
	return result;
}


gchar* notification_manager_send_dm (NotificationManager* self, gint64 sender_id, const gchar* existing_id, const gchar* summary, const gchar* text) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* new_id = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GNotification* n = NULL;
	const gchar* _tmp7_ = NULL;
	GNotification* _tmp8_ = NULL;
	GVariant* value = NULL;
	Account* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	GVariant* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	GVariant* _tmp13_ = NULL;
	GVariant** _tmp14_ = NULL;
	GVariant** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GApplication* _tmp19_ = NULL;
	g_return_val_if_fail (IS_NOTIFICATION_MANAGER (self), NULL);
	g_return_val_if_fail (summary != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = existing_id;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = existing_id;
		notification_manager_withdraw (self, _tmp1_);
	}
	_tmp2_ = sender_id;
	_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("new-dm-%s", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	new_id = _tmp6_;
	_tmp7_ = summary;
	_tmp8_ = g_notification_new (_tmp7_);
	n = _tmp8_;
	_tmp9_ = self->priv->account;
	_tmp10_ = _tmp9_->id;
	_tmp11_ = g_variant_new_int64 (_tmp10_);
	g_variant_ref_sink (_tmp11_);
	_tmp12_ = sender_id;
	_tmp13_ = g_variant_new_int64 (_tmp12_);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = g_new0 (GVariant*, 2 + 1);
	_tmp14_[0] = _tmp11_;
	_tmp14_[1] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	_tmp16_ = g_variant_new_tuple (_tmp15_, 2);
	g_variant_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_variant_unref), NULL);
	value = _tmp17_;
	g_notification_set_default_action_and_target_value (n, "app.show-dm-thread", value);
	_tmp18_ = text;
	g_notification_set_body (n, _tmp18_);
	_tmp19_ = g_application_get_default ();
	g_application_send_notification (_tmp19_, new_id, n);
	result = new_id;
	_g_variant_unref0 (value);
	_g_object_unref0 (n);
	return result;
}


static void notification_manager_class_init (NotificationManagerClass * klass) {
	notification_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NotificationManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = notification_manager_finalize;
}


static void notification_manager_instance_init (NotificationManager * self) {
	self->priv = NOTIFICATION_MANAGER_GET_PRIVATE (self);
}


static void notification_manager_finalize (GObject* obj) {
	NotificationManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFICATION_MANAGER, NotificationManager);
	G_OBJECT_CLASS (notification_manager_parent_class)->finalize (obj);
}


GType notification_manager_get_type (void) {
	static volatile gsize notification_manager_type_id__volatile = 0;
	if (g_once_init_enter (&notification_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotificationManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notification_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationManager), 0, (GInstanceInitFunc) notification_manager_instance_init, NULL };
		GType notification_manager_type_id;
		notification_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationManager", &g_define_type_info, 0);
		g_once_init_leave (&notification_manager_type_id__volatile, notification_manager_type_id);
	}
	return notification_manager_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



