; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -disable-output -passes='print<scalar-evolution>' %s 2>&1 | FileCheck %s

; Check that assumes/guards guarding the backedge are taken into account
; when inferring no-wrap flags.

declare void @llvm.experimental.guard(i1, ...)
declare void @llvm.assume(i1)

define void @s_0(i32 %n, ptr %cond) {
; CHECK-LABEL: 's_0'
; CHECK-NEXT:  Classifying expressions for: @s_0
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.sext = sext i32 %iv to i64
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,-9223372036854775808) S: [0,-9223372036854775808) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @s_0
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 1
  %iv.sext = sext i32 %iv to i64
  %cmp = icmp slt i32 %iv, %n
  call void(i1, ...) @llvm.experimental.guard(i1 %cmp) [ "deopt"() ]
  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %leave

leave:
  ret void
}

define void @s_1(ptr %cond) {
; CHECK-LABEL: 's_1'
; CHECK-NEXT:  Classifying expressions for: @s_1
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, 3
; CHECK-NEXT:    --> {3,+,3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.sext = sext i32 %iv to i64
; CHECK-NEXT:    --> {0,+,3}<nuw><nsw><%loop> U: [0,-9223372036854775808) S: [0,-9223372036854775808) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @s_1
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 3
  %iv.sext = sext i32 %iv to i64
  %cmp = icmp slt i32 %iv, 10000
  call void(i1, ...) @llvm.experimental.guard(i1 %cmp) [ "deopt"() ]
  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %leave

leave:
  ret void
}

define void @s_2(ptr %cond) {
; CHECK-LABEL: 's_2'
; CHECK-NEXT:  Classifying expressions for: @s_2
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, 3
; CHECK-NEXT:    --> {3,+,3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.sext = sext i32 %iv to i64
; CHECK-NEXT:    --> {0,+,3}<nuw><nsw><%loop> U: [0,-9223372036854775808) S: [0,-9223372036854775808) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @s_2
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 3
  %iv.sext = sext i32 %iv to i64
  %cmp = icmp slt i32 %iv, 10000
  call void @llvm.assume(i1 %cmp)
  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %leave

leave:
  ret void
}

define void @s_3(i32 %start, ptr %cond) {
; CHECK-LABEL: 's_3'
; CHECK-NEXT:  Classifying expressions for: @s_3
; CHECK-NEXT:    %iv = phi i32 [ %start, %entry ], [ %iv.inc, %be ]
; CHECK-NEXT:    --> {%start,+,3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, 3
; CHECK-NEXT:    --> {(3 + %start),+,3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc.sext = sext i32 %iv.inc to i64
; CHECK-NEXT:    --> {(sext i32 (3 + %start) to i64),+,3}<nsw><%loop> U: [-2147483648,4294977296) S: [-2147483648,4294977296) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @s_3
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ((((-1 * (1 umin ((-1 * %start) + (10000 smax %start))))<nuw><nsw> + (-1 * %start) + (10000 smax %start)) /u 3) + (1 umin ((-1 * %start) + (10000 smax %start))))
; CHECK-NEXT:    exit count for be: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 715831216
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((((-1 * (1 umin ((-1 * %start) + (10000 smax %start))))<nuw><nsw> + (-1 * %start) + (10000 smax %start)) /u 3) + (1 umin ((-1 * %start) + (10000 smax %start))))
; CHECK-NEXT:    symbolic max exit count for loop: ((((-1 * (1 umin ((-1 * %start) + (10000 smax %start))))<nuw><nsw> + (-1 * %start) + (10000 smax %start)) /u 3) + (1 umin ((-1 * %start) + (10000 smax %start))))
; CHECK-NEXT:    symbolic max exit count for be: ***COULDNOTCOMPUTE***
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %start, %entry ], [ %iv.inc, %be ]
  %cmp = icmp slt i32 %iv, 10000
  br i1 %cmp, label %be, label %leave

be:
  %iv.inc = add i32 %iv, 3
  %iv.inc.sext = sext i32 %iv.inc to i64
  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %leave

leave:
  ret void
}

define void @s_4(i32 %start, ptr %cond) {
; CHECK-LABEL: 's_4'
; CHECK-NEXT:  Classifying expressions for: @s_4
; CHECK-NEXT:    %iv = phi i32 [ %start, %entry ], [ %iv.inc, %be ]
; CHECK-NEXT:    --> {%start,+,-3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, -3
; CHECK-NEXT:    --> {(-3 + %start),+,-3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc.sext = sext i32 %iv.inc to i64
; CHECK-NEXT:    --> {(sext i32 (-3 + %start) to i64),+,-3}<nsw><%loop> U: [-4294968296,2147483648) S: [-4294968296,2147483648) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @s_4
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ((2 + (-1 * (-1000 smin %start)) + %start) /u 3)
; CHECK-NEXT:    exit count for be: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 715828216
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((2 + (-1 * (-1000 smin %start)) + %start) /u 3)
; CHECK-NEXT:    symbolic max exit count for loop: ((2 + (-1 * (-1000 smin %start)) + %start) /u 3)
; CHECK-NEXT:    symbolic max exit count for be: ***COULDNOTCOMPUTE***
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %start, %entry ], [ %iv.inc, %be ]
  %cmp = icmp sgt i32 %iv, -1000
  br i1 %cmp, label %be, label %leave

be:
  %iv.inc = add i32 %iv, -3
  %iv.inc.sext = sext i32 %iv.inc to i64
  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %leave

leave:
  ret void
}

define void @u_0(i32 %n, ptr %cond) {
; CHECK-LABEL: 'u_0'
; CHECK-NEXT:  Classifying expressions for: @u_0
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.zext = zext i32 %iv to i64
; CHECK-NEXT:    --> {0,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @u_0
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 1
  %iv.zext = zext i32 %iv to i64
  %cmp = icmp ult i32 %iv, %n
  call void(i1, ...) @llvm.experimental.guard(i1 %cmp) [ "deopt"() ]
  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %leave

leave:
  ret void
}

define void @u_1(ptr %cond) {
; CHECK-LABEL: 'u_1'
; CHECK-NEXT:  Classifying expressions for: @u_1
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, 3
; CHECK-NEXT:    --> {3,+,3}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.zext = zext i32 %iv to i64
; CHECK-NEXT:    --> {0,+,3}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @u_1
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 3
  %iv.zext = zext i32 %iv to i64
  %cmp = icmp ult i32 %iv, 10000
  call void(i1, ...) @llvm.experimental.guard(i1 %cmp) [ "deopt"() ]
  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %leave

leave:
  ret void
}

define void @u_2(ptr %cond) {
; CHECK-LABEL: 'u_2'
; CHECK-NEXT:  Classifying expressions for: @u_2
; CHECK-NEXT:    %iv = phi i32 [ 30000, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {30000,+,-2}<%loop> U: [0,-1) S: [-2147483648,2147483647) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, -2
; CHECK-NEXT:    --> {29998,+,-2}<%loop> U: [0,-1) S: [-2147483648,2147483647) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.zext = zext i32 %iv to i64
; CHECK-NEXT:    --> {30000,+,-2}<nw><%loop> U: [0,-1) S: [-9223372036854775808,9223372036854775807) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @u_2
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 30000, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, -2
  %iv.zext = zext i32 %iv to i64
  %cmp = icmp ugt i32 %iv.inc, -10000
  call void @llvm.assume(i1 %cmp)
  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %leave

leave:
  ret void
}

define void @u_3(i32 %start, ptr %cond) {
; CHECK-LABEL: 'u_3'
; CHECK-NEXT:  Classifying expressions for: @u_3
; CHECK-NEXT:    %iv = phi i32 [ %start, %entry ], [ %iv.inc, %be ]
; CHECK-NEXT:    --> {%start,+,3}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, 3
; CHECK-NEXT:    --> {(3 + %start),+,3}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc.zext = zext i32 %iv.inc to i64
; CHECK-NEXT:    --> {(zext i32 (3 + %start) to i64),+,3}<nuw><%loop> U: [0,4294977298) S: [0,4294977298) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @u_3
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ((((-1 * (1 umin ((-1 * %start) + (10000 umax %start))))<nuw><nsw> + (-1 * %start) + (10000 umax %start)) /u 3) + (1 umin ((-1 * %start) + (10000 umax %start))))
; CHECK-NEXT:    exit count for be: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 3334
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((((-1 * (1 umin ((-1 * %start) + (10000 umax %start))))<nuw><nsw> + (-1 * %start) + (10000 umax %start)) /u 3) + (1 umin ((-1 * %start) + (10000 umax %start))))
; CHECK-NEXT:    symbolic max exit count for loop: ((((-1 * (1 umin ((-1 * %start) + (10000 umax %start))))<nuw><nsw> + (-1 * %start) + (10000 umax %start)) /u 3) + (1 umin ((-1 * %start) + (10000 umax %start))))
; CHECK-NEXT:    symbolic max exit count for be: ***COULDNOTCOMPUTE***
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %start, %entry ], [ %iv.inc, %be ]
  %cmp = icmp ult i32 %iv, 10000
  br i1 %cmp, label %be, label %leave

be:
  %iv.inc = add i32 %iv, 3
  %iv.inc.zext = zext i32 %iv.inc to i64
  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %leave

leave:
  ret void
}
