/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-goto.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-goto
 * @title: IAnjutaEditorGoto
 * @short_description: Text editor navigation interface
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-goto.h
 *
 */

#include "ianjuta-editor-goto.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_goto_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-goto-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_goto_end_block:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Moves cursor to the end of the current block
 */
void
ianjuta_editor_goto_end_block (IAnjutaEditorGoto *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_GOTO(obj));
	IANJUTA_EDITOR_GOTO_GET_IFACE (obj)->end_block (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_goto_end_block_default (IAnjutaEditorGoto *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_goto_matching_brace:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Moves cursor to matching brace
 */
void
ianjuta_editor_goto_matching_brace (IAnjutaEditorGoto *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_GOTO(obj));
	IANJUTA_EDITOR_GOTO_GET_IFACE (obj)->matching_brace (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_goto_matching_brace_default (IAnjutaEditorGoto *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_goto_start_block:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Moves cursor to the start of the current block
 */
void
ianjuta_editor_goto_start_block (IAnjutaEditorGoto *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_GOTO(obj));
	IANJUTA_EDITOR_GOTO_GET_IFACE (obj)->start_block (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_goto_start_block_default (IAnjutaEditorGoto *obj, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_editor_goto_base_init (IAnjutaEditorGotoIface* klass)
{
	static gboolean initialized = FALSE;

	klass->end_block = ianjuta_editor_goto_end_block_default;
	klass->matching_brace = ianjuta_editor_goto_matching_brace_default;
	klass->start_block = ianjuta_editor_goto_start_block_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_goto_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorGotoIface),
			(GBaseInitFunc) ianjuta_editor_goto_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorGoto", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
