"""
certifi.py
~~~~~~~~~~

This module returns the installation location of cacert.pem or its contents.
"""

# The RPM-packaged certifi always uses the system certificates
def where() -> str:
    return '/etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem'


def contents() -> str:
    with open(where(), encoding='utf=8') as data:
        return data.read()
