/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class DoubleDeserializer
implements Deserializer<Double> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Double deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 8) {
            throw new SerializationException("Size of data received by Deserializer is not 8");
        }
        long value = 0L;
        for (byte b : data) {
            value <<= 8;
            value |= (long)(b & 0xFF);
        }
        return Double.longBitsToDouble(value);
    }

    @Override
    public void close() {
    }
}

