/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.tomitribe.swizzle.stream.FilteredInputStream;
import org.tomitribe.swizzle.stream.ScanBuffer;

public class FixedTokenWatchInputStream
extends FilteredInputStream {
    private final Consumer<String> handler;
    private final String token;
    private final boolean caseSensitive;
    private Strategy strategy;

    public FixedTokenWatchInputStream(InputStream in, String token, Consumer<String> handler) {
        this(in, token, true, handler);
    }

    public FixedTokenWatchInputStream(InputStream in, String token, boolean caseSensitive, Consumer<String> handler) {
        super(in);
        this.token = token;
        this.caseSensitive = caseSensitive;
        this.handler = handler;
        this.strategy = new Find();
    }

    public FixedTokenWatchInputStream(InputStream in, String token, Runnable handler) {
        this(in, token, (String s) -> handler.run());
    }

    public FixedTokenWatchInputStream(InputStream in, String token, boolean caseSensitive, Runnable handler) {
        this(in, token, caseSensitive, (String s) -> handler.run());
    }

    @Override
    public int read() throws IOException {
        return this.strategy.read();
    }

    private int superRead() throws IOException {
        return super.read();
    }

    private int done() {
        this.strategy = () -> -1;
        return -1;
    }

    private class Find
    implements Strategy {
        final ScanBuffer tokenBuffer;

        private Find() {
            this.tokenBuffer = new ScanBuffer(FixedTokenWatchInputStream.this.token, FixedTokenWatchInputStream.this.caseSensitive);
        }

        @Override
        public int read() throws IOException {
            int stream = FixedTokenWatchInputStream.this.superRead();
            if (stream == -1) {
                FixedTokenWatchInputStream.this.done();
            }
            this.tokenBuffer.append(stream);
            if (this.tokenBuffer.match()) {
                FixedTokenWatchInputStream.this.strategy = new Find();
                FixedTokenWatchInputStream.this.handler.accept(this.tokenBuffer.getScanString());
            }
            return stream;
        }
    }

    private static interface Strategy {
        public int read() throws IOException;
    }
}

