/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq.jms2;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.TransactionSupport;
import org.apache.activemq.ra.ActiveMQConnectionFactory;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.activemq.ra.ActiveMQManagedConnectionFactory;
import org.apache.openejb.resource.activemq.jms2.JMS2;
import org.apache.openejb.resource.activemq.jms2.JMSContextImpl;

public class TomEERAConnectionFactory
extends ActiveMQConnectionFactory {
    private static final long serialVersionUID = 1L;
    private TransactionSupport.TransactionSupportLevel transactionSupportLevel = TransactionSupport.TransactionSupportLevel.XATransaction;

    public TomEERAConnectionFactory(ActiveMQManagedConnectionFactory factory, ConnectionManager manager, ActiveMQConnectionRequestInfo connectionRequestInfo) {
        super(factory, manager, connectionRequestInfo);
    }

    public JMSContext createContext() {
        int mode;
        return new JMSContextImpl((ConnectionFactory)this, mode, null, null, switch (this.transactionSupportLevel) {
            case TransactionSupport.TransactionSupportLevel.XATransaction -> {
                if (JMS2.inTx()) {
                    mode = -1;
                    yield true;
                }
            }
            case TransactionSupport.TransactionSupportLevel.NoTransaction -> {
                mode = 1;
                yield false;
            }
            case TransactionSupport.TransactionSupportLevel.LocalTransaction -> {
                mode = 0;
                yield false;
            }
            default -> throw new IllegalStateException("transactionSupportLevel mode not supported:" + this.transactionSupportLevel);
        });
    }

    public JMSContext createContext(int sessionMode) {
        int mode;
        return new JMSContextImpl((ConnectionFactory)this, mode, null, null, switch (this.transactionSupportLevel) {
            case TransactionSupport.TransactionSupportLevel.XATransaction -> {
                if (JMS2.inTx()) {
                    mode = -1;
                    yield true;
                }
            }
            case TransactionSupport.TransactionSupportLevel.NoTransaction -> {
                mode = sessionMode;
                yield false;
            }
            case TransactionSupport.TransactionSupportLevel.LocalTransaction -> {
                mode = 0;
                yield false;
            }
            default -> throw new IllegalStateException("transactionSupportLevel mode not supported:" + this.transactionSupportLevel);
        });
    }

    public JMSContext createContext(String userName, String password) {
        int mode;
        return new JMSContextImpl((ConnectionFactory)this, mode, userName, password, switch (this.transactionSupportLevel) {
            case TransactionSupport.TransactionSupportLevel.XATransaction -> {
                if (JMS2.inTx()) {
                    mode = -1;
                    yield true;
                }
            }
            case TransactionSupport.TransactionSupportLevel.NoTransaction -> {
                mode = 1;
                yield false;
            }
            case TransactionSupport.TransactionSupportLevel.LocalTransaction -> {
                mode = 0;
                yield false;
            }
            default -> throw new IllegalStateException("transactionSupportLevel mode not supported:" + this.transactionSupportLevel);
        });
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        int mode;
        return new JMSContextImpl((ConnectionFactory)this, mode, userName, password, switch (this.transactionSupportLevel) {
            case TransactionSupport.TransactionSupportLevel.XATransaction -> {
                if (JMS2.inTx()) {
                    mode = -1;
                    yield true;
                }
            }
            case TransactionSupport.TransactionSupportLevel.NoTransaction -> {
                mode = sessionMode;
                yield false;
            }
            case TransactionSupport.TransactionSupportLevel.LocalTransaction -> {
                mode = 0;
                yield false;
            }
            default -> throw new IllegalStateException("transactionSupportLevel mode not supported:" + this.transactionSupportLevel);
        });
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        return this.transactionSupportLevel;
    }

    public void setTransactionSupport(TransactionSupport.TransactionSupportLevel transactionSupportLevel) {
        if (transactionSupportLevel == null) {
            throw new IllegalArgumentException("transactionSupportLevel cannot be null");
        }
        this.transactionSupportLevel = transactionSupportLevel;
    }
}

