/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.jba.cmp;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://jboss.org}description" minOccurs="0"/&gt;
 *         &lt;element ref="{http://jboss.org}load-group-name"/&gt;
 *         &lt;element ref="{http://jboss.org}field-name" maxOccurs="unbounded"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "description",
    "loadGroupName",
    "fieldName"
})
@XmlRootElement(name = "load-group")
public class LoadGroup {

    protected Description description;
    @XmlElement(name = "load-group-name", required = true)
    protected LoadGroupName loadGroupName;
    @XmlElement(name = "field-name", required = true)
    protected List<FieldName> fieldName;

    /**
     * Gets the value of the description property.
     *
     * @return possible object is
     * {@link Description }
     */
    public Description getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     *
     * @param value allowed object is
     *              {@link Description }
     */
    public void setDescription(final Description value) {
        this.description = value;
    }

    /**
     * Gets the value of the loadGroupName property.
     *
     * @return possible object is
     * {@link LoadGroupName }
     */
    public LoadGroupName getLoadGroupName() {
        return loadGroupName;
    }

    /**
     * Sets the value of the loadGroupName property.
     *
     * @param value allowed object is
     *              {@link LoadGroupName }
     */
    public void setLoadGroupName(final LoadGroupName value) {
        this.loadGroupName = value;
    }

    /**
     * Gets the value of the fieldName property.
     *
     *
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fieldName property.
     *
     *
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFieldName().add(newItem);
     * </pre>
     *
     *
     *
     * Objects of the following type(s) are allowed in the list
     * {@link FieldName }
     */
    public List<FieldName> getFieldName() {
        if (fieldName == null) {
            fieldName = new ArrayList<FieldName>();
        }
        return this.fieldName;
    }

}
