/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.DateTimeExtractPart;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.meta.ClassMetaData;

public class ExtractDateTimePart
extends AbstractVal {
    private static final long serialVersionUID = 1L;
    private final Val _val;
    private final DateTimeExtractPart _part;
    private ClassMetaData _meta = null;

    public ExtractDateTimePart(Val val, DateTimeExtractPart part) {
        this._val = val;
        this._part = part;
    }

    public Val getVal() {
        return this._val;
    }

    @Override
    public ClassMetaData getMetaData() {
        return this._meta;
    }

    @Override
    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    @Override
    public Class getType() {
        if (this._part == DateTimeExtractPart.TIME) {
            return Time.class;
        }
        if (this._part == DateTimeExtractPart.DATE) {
            return Date.class;
        }
        throw new IllegalStateException();
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        ExpState valueState = this._val.initialize(sel, ctx, 0);
        return new ExtractDateTimePartExpState(valueState.joins, valueState);
    }

    @Override
    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.select(this.newSQLBuffer(sel, ctx, state), (Object)this);
    }

    @Override
    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        ExtractDateTimePartExpState edtstate = (ExtractDateTimePartExpState)state;
        this._val.selectColumns(sel, ctx, edtstate.valueState, true);
    }

    @Override
    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        sel.groupBy(this.newSQLBuffer(sel, ctx, state));
    }

    @Override
    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.newSQLBuffer(sel, ctx, state), asc, false, this.getSelectAs());
    }

    private SQLBuffer newSQLBuffer(Select sel, ExpContext ctx, ExpState state) {
        this.calculateValue(sel, ctx, state, null, null);
        SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
        this.appendTo(sel, ctx, state, buf, 0);
        return buf;
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return Filters.convert(res.getObject(this, 1012, null), this.getType());
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        ExtractDateTimePartExpState edtstate = (ExtractDateTimePartExpState)state;
        this._val.calculateValue(sel, ctx, edtstate.valueState, null, null);
    }

    @Override
    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        ExtractDateTimePartExpState edtstate = (ExtractDateTimePartExpState)state;
        sql2.append("CAST( ");
        this._val.appendTo(sel, ctx, edtstate.valueState, sql2, 0);
        sql2.append(" AS ");
        sql2.append(this._part == DateTimeExtractPart.DATE ? "DATE)" : "TIME)");
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val.acceptVisit(visitor);
        visitor.exit(this);
    }

    @Override
    public int getId() {
        return 25;
    }

    private static class ExtractDateTimePartExpState
    extends ExpState {
        public final ExpState valueState;

        public ExtractDateTimePartExpState(Joins joins, ExpState valueState) {
            super(joins);
            this.valueState = valueState;
        }
    }
}

