/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.exception.helper;

public class ViolationMessageBuilder {
    private StringBuilder violationMessage;

    public static ViolationMessageBuilder newViolation() {
        return new ViolationMessageBuilder();
    }

    public static ViolationMessageBuilder newViolation(String ... text) {
        return new ViolationMessageBuilder().append(text);
    }

    public ViolationMessageBuilder append(String ... text) {
        this.appendText(text, false);
        return this;
    }

    public ViolationMessageBuilder addLine(String ... text) {
        if (text == null) {
            return this;
        }
        this.appendText(text, true);
        return this;
    }

    private void appendText(String[] text, boolean appendLineSeparator) {
        if (this.violationMessage == null) {
            this.violationMessage = new StringBuilder();
        } else if (appendLineSeparator) {
            this.violationMessage.append(System.lineSeparator());
        }
        for (String t : text) {
            this.violationMessage.append(t);
        }
    }

    public boolean containsViolation() {
        return this.violationMessage != null;
    }

    public String toString() {
        return this.containsViolation() ? this.violationMessage.toString() : "no violation recorded";
    }
}

