/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.RowAVLDisk;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.Type;

public class RowDiskDataChange
extends RowAVLDisk {
    public static final int COL_POS_ROW_NUM = 0;
    public static final int COL_POS_ROW_ID = 1;
    public static final int COL_POS_TABLE_ID = 2;
    public static final int COL_POS_SCHEMA_NAME = 3;
    public static final int COL_POS_TABLE_NAME = 4;
    public static final int COL_POS_IS_UPDATE = 5;
    static final Type[] arrayType = new Type[]{new ArrayType(Type.SQL_INTEGER, Integer.MAX_VALUE)};
    Table targetTable;
    Object[] updateData;
    int[] updateColMap;

    public RowDiskDataChange(TableBase tableBase, Object[] objectArray, PersistentStore persistentStore, Table table) {
        super(tableBase, objectArray, persistentStore);
        this.targetTable = table;
    }

    public RowDiskDataChange(Session session, PersistentStore persistentStore, RowInputInterface rowInputInterface) {
        super(persistentStore, rowInputInterface);
        this.targetTable = persistentStore.getTable().database.schemaManager.findTable(session, (String)this.rowData[4], (String)this.rowData[3], null);
        if (((Boolean)this.rowData[5]).booleanValue()) {
            this.updateData = rowInputInterface.readData(this.targetTable.colTypes);
            RowInputBinary rowInputBinary = (RowInputBinary)rowInputInterface;
            this.updateColMap = (int[])(rowInputBinary.readNull() ? null : rowInputBinary.readIntArray());
        } else {
            this.updateData = null;
            this.updateColMap = null;
        }
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.writeNodes(rowOutputInterface);
        if (this.hasDataChanged) {
            rowOutputInterface.writeData(this, this.table.colTypes);
            if (this.updateData != null) {
                Type[] typeArray = this.targetTable.colTypes;
                rowOutputInterface.writeData(typeArray.length, typeArray, this.updateData, null, null);
                RowOutputBinary rowOutputBinary = (RowOutputBinary)rowOutputInterface;
                if (this.updateColMap == null) {
                    rowOutputBinary.writeNull(Type.SQL_ARRAY_ALL_TYPES);
                } else {
                    rowOutputBinary.writeArray(this.updateColMap);
                }
            }
            rowOutputInterface.writeEnd();
            this.hasDataChanged = false;
        }
    }

    public Object[] getUpdateData() {
        return this.updateData;
    }

    public int[] getUpdateColumnMap() {
        return this.updateColMap;
    }

    public void setTargetTable(Table table) {
        this.targetTable = table;
    }

    public void setUpdateData(Object[] objectArray) {
        this.updateData = objectArray;
    }

    public void setUpdateColumnMap(int[] nArray) {
        this.updateColMap = nArray;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        RowOutputBinary rowOutputBinary = (RowOutputBinary)rowOutputInterface;
        int n = rowOutputInterface.getSize(this);
        if (this.updateData != null) {
            n += rowOutputBinary.getSize(this.updateData, this.targetTable.getColumnCount(), this.targetTable.getColumnTypes());
            if (this.updateColMap != null) {
                n += rowOutputBinary.getSize(this.updateColMap);
            }
        }
        return n;
    }
}

