/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup.config;

import io.smallrye.metrics.setup.config.PropertyArrayConfiguration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HistogramBucketConfiguration
extends PropertyArrayConfiguration<Double> {
    private static final String CLASS_NAME = HistogramBucketConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public HistogramBucketConfiguration(String metricName, Double[] values) {
        super(metricName, values);
    }

    public static Collection<HistogramBucketConfiguration> parse(String input) {
        String[] metricValuePairs;
        ArrayDeque<HistogramBucketConfiguration> metricBucketConfiCollection = new ArrayDeque<HistogramBucketConfiguration>();
        if (input == null || input.length() == 0) {
            return null;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            HistogramBucketConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length == 1) continue;
            Object[] bucketValues = (Double[])Arrays.asList(keyValueSplit[1].split(",")).stream().map(s -> {
                if (s.matches("[0-9]+[.]*[0-9]*")) {
                    return Double.parseDouble(s);
                }
                LOGGER.logp(Level.WARNING, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer and decimal values are accepted.", new Object[]{s, "mp.metrics.distribution.histogram.buckets"});
                return null;
            }).filter(x -> x != null).toArray(Double[]::new);
            Arrays.sort(bucketValues);
            metricBucketConfiguration = new HistogramBucketConfiguration(metricName, (Double[])bucketValues);
            metricBucketConfiCollection.addFirst(metricBucketConfiguration);
        }
        return metricBucketConfiCollection;
    }
}

