/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.messaging;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.CapturedMessageHeadersUtil;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.List;
import javax.annotation.Nullable;

public final class MessagingAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    static final String TEMP_DESTINATION_NAME = "(temporary)";
    private final MessagingAttributesGetter<REQUEST, RESPONSE> getter;
    private final MessageOperation operation;
    private final List<String> capturedHeaders;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return MessagingAttributesExtractor.builder(getter, operation).build();
    }

    public static <REQUEST, RESPONSE> MessagingAttributesExtractorBuilder<REQUEST, RESPONSE> builder(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return new MessagingAttributesExtractorBuilder<REQUEST, RESPONSE>(getter, operation);
    }

    MessagingAttributesExtractor(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation, List<String> capturedHeaders) {
        this.getter = getter;
        this.operation = operation;
        this.capturedHeaders = CapturedMessageHeadersUtil.lowercase(capturedHeaders);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_SYSTEM, (Object)this.getter.getSystem(request));
        boolean isTemporaryDestination = this.getter.isTemporaryDestination(request);
        if (isTemporaryDestination) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_DESTINATION_TEMPORARY, (Object)true);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)TEMP_DESTINATION_NAME);
        } else {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)this.getter.getDestination(request));
        }
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_MESSAGE_CONVERSATION_ID, (Object)this.getter.getConversationId(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES, (Object)this.getter.getMessagePayloadSize(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES, (Object)this.getter.getMessagePayloadCompressedSize(request));
        if (this.operation != null) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_OPERATION, (Object)this.operation.operationName());
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.MESSAGING_MESSAGE_ID, (Object)this.getter.getMessageId(request, response));
        for (String name : this.capturedHeaders) {
            List<String> values = this.getter.getMessageHeader(request, name);
            if (values.isEmpty()) continue;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CapturedMessageHeadersUtil.attributeKey(name), values);
        }
    }

    public SpanKey internalGetSpanKey() {
        if (this.operation == null) {
            return null;
        }
        switch (this.operation) {
            case PUBLISH: {
                return SpanKey.PRODUCER;
            }
            case RECEIVE: {
                return SpanKey.CONSUMER_RECEIVE;
            }
            case PROCESS: {
                return SpanKey.CONSUMER_PROCESS;
            }
        }
        throw new IllegalStateException("Can't possibly happen");
    }
}

