/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller;

import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.apache.batchee.container.ExecutionElementController;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.impl.controller.PartitionedStepBuilder;
import org.apache.batchee.container.impl.jobinstance.RuntimeFlowInSplitExecution;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.BatchKernelService;
import org.apache.batchee.container.status.ExecutionStatus;
import org.apache.batchee.container.status.ExtendedBatchStatus;
import org.apache.batchee.container.status.SplitExecutionStatus;
import org.apache.batchee.container.util.BatchFlowInSplitWorkUnit;
import org.apache.batchee.container.util.BatchParallelWorkUnit;
import org.apache.batchee.container.util.FlowInSplitBuilderConfig;
import org.apache.batchee.jaxb.Flow;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.Split;

public class SplitController
implements ExecutionElementController {
    private static final Logger logger = Logger.getLogger(SplitController.class.getName());
    private final RuntimeJobExecution jobExecution;
    private volatile List<BatchFlowInSplitWorkUnit> parallelBatchWorkUnits;
    private final BatchKernelService batchKernel;
    private final JobContextImpl jobContext;
    private final BlockingQueue<BatchFlowInSplitWorkUnit> completedWorkQueue = new LinkedBlockingQueue<BatchFlowInSplitWorkUnit>();
    private final long rootJobExecutionId;
    private final List<JSLJob> subJobs = new ArrayList<JSLJob>();
    protected Split split;

    public SplitController(RuntimeJobExecution jobExecution, Split split, long rootJobExecutionId, BatchKernelService kernelService) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.rootJobExecutionId = rootJobExecutionId;
        this.split = split;
        this.batchKernel = kernelService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelBatchWorkUnits != null) {
                for (BatchParallelWorkUnit batchParallelWorkUnit : this.parallelBatchWorkUnits) {
                    try {
                        this.batchKernel.stopJob(batchParallelWorkUnit.getJobExecutionImpl().getExecutionId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    @Override
    public SplitExecutionStatus execute() throws JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        this.buildSubJobBatchWorkUnits();
        this.executeWorkUnits();
        return this.waitForCompletionAndAggregateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSubJobBatchWorkUnits() {
        List<Flow> flows = this.split.getFlows();
        this.parallelBatchWorkUnits = new ArrayList<BatchFlowInSplitWorkUnit>();
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            for (Flow flow : flows) {
                this.subJobs.add(PartitionedStepBuilder.buildFlowInSplitSubJob(this.jobExecution.getExecutionId(), this.jobContext, this.split, flow));
            }
            for (JSLJob job : this.subJobs) {
                int count = this.batchKernel.getJobInstanceCount(job.getId());
                FlowInSplitBuilderConfig config = new FlowInSplitBuilderConfig(job, this.completedWorkQueue, this.rootJobExecutionId);
                if (count == 0) {
                    this.parallelBatchWorkUnits.add(this.batchKernel.buildNewFlowInSplitWorkUnit(config, this.jobExecution.getJobContext()));
                    continue;
                }
                if (count == 1) {
                    this.parallelBatchWorkUnits.add(this.batchKernel.buildOnRestartFlowInSplitWorkUnit(config, this.jobExecution.getJobContext()));
                    continue;
                }
                throw new IllegalStateException("There is an inconsistency somewhere in the internal subjob creation");
            }
        }
    }

    private void executeWorkUnits() {
        for (BatchParallelWorkUnit batchParallelWorkUnit : this.parallelBatchWorkUnits) {
            int count = this.batchKernel.getJobInstanceCount(batchParallelWorkUnit.getJobExecutionImpl().getJobInstance().getJobName());
            assert (count <= 1);
            if (count == 1) {
                this.batchKernel.startGeneratedJob(batchParallelWorkUnit);
                continue;
            }
            if (count > 1) {
                this.batchKernel.restartGeneratedJob(batchParallelWorkUnit);
                continue;
            }
            throw new IllegalStateException("There is an inconsistency somewhere in the internal subjob creation");
        }
    }

    private SplitExecutionStatus waitForCompletionAndAggregateStatus() {
        SplitExecutionStatus splitStatus = new SplitExecutionStatus();
        for (JSLJob ignored : this.subJobs) {
            BatchFlowInSplitWorkUnit batchWork;
            try {
                batchWork = this.completedWorkQueue.take();
            }
            catch (InterruptedException e) {
                throw new BatchContainerRuntimeException(e);
            }
            RuntimeFlowInSplitExecution flowExecution = batchWork.getJobExecutionImpl();
            ExecutionStatus flowStatus = flowExecution.getFlowStatus();
            this.aggregateTerminatingStatusFromSingleFlow(null, flowStatus, splitStatus);
        }
        splitStatus.setExtendedBatchStatus(ExtendedBatchStatus.NORMAL_COMPLETION);
        return splitStatus;
    }

    private ExtendedBatchStatus aggregateTerminatingStatusFromSingleFlow(ExtendedBatchStatus aggregateStatus, ExecutionStatus flowStatus, SplitExecutionStatus splitStatus) {
        String exitStatus = flowStatus.getExitStatus();
        String restartOn = flowStatus.getRestartOn();
        ExtendedBatchStatus flowBatchStatus = flowStatus.getExtendedBatchStatus();
        if (flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_END) || flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_STOP) || flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || flowBatchStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
            if (aggregateStatus == null) {
                this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                return flowBatchStatus;
            }
            splitStatus.setCouldMoreThanOneFlowHaveTerminatedJob(true);
            if (aggregateStatus.equals((Object)ExtendedBatchStatus.JSL_END)) {
                logger.warning("Current flow's batch and exit status will take precedence over and override earlier one from <end> transition element. Overriding, setting exit status if non-null and preparing to end job.");
                this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                return flowBatchStatus;
            }
            if (aggregateStatus.equals((Object)ExtendedBatchStatus.JSL_STOP)) {
                if (!flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_END)) {
                    logger.warning("Current flow's batch and exit status will take precedence over and override earlier one from <stop> transition element. Overriding, setting exit status if non-null and preparing to end job.");
                    this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                    return flowBatchStatus;
                }
            } else if ((aggregateStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || aggregateStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) && (flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || flowBatchStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN))) {
                logger.warning("Current flow's batch and exit status will take precedence over and override earlier one from <fail> transition element  or exception thrown. Overriding, setting exit status if non-null and preparing to end job.");
                this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                return flowBatchStatus;
            }
        }
        return null;
    }

    private void setInJobContext(ExtendedBatchStatus flowBatchStatus, String exitStatus, String restartOn) {
        if (exitStatus != null) {
            this.jobContext.setExitStatus(exitStatus);
        }
        if (ExtendedBatchStatus.JSL_STOP.equals((Object)flowBatchStatus) && restartOn != null) {
            this.jobContext.setRestartOn(restartOn);
        }
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        ArrayList<Long> stepExecIdList = new ArrayList<Long>();
        for (BatchFlowInSplitWorkUnit workUnit : this.parallelBatchWorkUnits) {
            List<Long> stepExecIds = workUnit.getController().getLastRunStepExecutions();
            stepExecIdList.addAll(stepExecIds);
        }
        return stepExecIdList;
    }
}

