/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.internal.BeforeRetryMethod;
import io.smallrye.faulttolerance.internal.FallbackMethodCandidates;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Singleton
public class StrategyCache {
    private final Map<InterceptionPoint, FaultToleranceStrategy<?>> strategies = new ConcurrentHashMap();
    private final Map<InterceptionPoint, FallbackMethodCandidates> fallbackMethods = new ConcurrentHashMap<InterceptionPoint, FallbackMethodCandidates>();
    private final Map<InterceptionPoint, BeforeRetryMethod> beforeRetryMethods = new ConcurrentHashMap<InterceptionPoint, BeforeRetryMethod>();
    private final SpecCompatibility specCompatibility;

    @Inject
    public StrategyCache(SpecCompatibility specCompatibility) {
        this.specCompatibility = specCompatibility;
    }

    public <V> FaultToleranceStrategy<V> getStrategy(InterceptionPoint point, Supplier<FaultToleranceStrategy<V>> producer) {
        return this.strategies.computeIfAbsent(point, ignored -> (FaultToleranceStrategy)producer.get());
    }

    public FallbackMethodCandidates getFallbackMethodCandidates(InterceptionPoint point, String fallbackMethodName) {
        return this.fallbackMethods.computeIfAbsent(point, ignored -> FallbackMethodCandidates.create(point, fallbackMethodName, this.specCompatibility.allowFallbackMethodExceptionParameter()));
    }

    public BeforeRetryMethod getBeforeRetryMethod(InterceptionPoint point, String fallbackMethodName) {
        return this.beforeRetryMethods.computeIfAbsent(point, ignored -> BeforeRetryMethod.find(point, fallbackMethodName));
    }
}

