/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.Context;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.ivm.naming.JaxWsServiceReference;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.cxf.CxfCatalogUtils;
import org.apache.openejb.server.cxf.CxfWsContainer;
import org.apache.openejb.server.cxf.client.SaajInterceptor;
import org.apache.openejb.server.cxf.client.WebServiceInjectionConfigurator;
import org.apache.openejb.server.cxf.ejb.EjbWsContainer;
import org.apache.openejb.server.cxf.event.ServerCreated;
import org.apache.openejb.server.cxf.event.ServerDestroyed;
import org.apache.openejb.server.cxf.pojo.PojoWsContainer;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.webservices.WsService;
import org.apache.openejb.util.AppFinder;

public class CxfService
extends WsService {
    public static final String OPENEJB_JAXWS_CXF_FEATURES = "features";
    private final Map<String, CxfWsContainer> wsContainers = new TreeMap<String, CxfWsContainer>();
    private SoapTransportFactory transportFactory;
    private boolean factoryByListener;

    public String getName() {
        return "cxf";
    }

    public void init(Properties props) throws Exception {
        super.init(props);
        CxfUtil.configureBus();
        SaajInterceptor.registerInterceptors();
        this.factoryByListener = "true".equalsIgnoreCase(props.getProperty("openejb.cxf.factoryByListener", "false"));
        this.transportFactory = new SoapTransportFactory();
        if (SystemInstance.get().getComponent(JaxWsServiceReference.WebServiceClientCustomizer.class) == null) {
            SystemInstance.get().setComponent(JaxWsServiceReference.WebServiceClientCustomizer.class, (Object)new WebServiceInjectionConfigurator());
        }
    }

    public void stop() throws ServiceException {
        super.stop();
        CxfUtil.release();
    }

    protected void setWsdl(HttpListener listener, String wsdl) {
        if (CxfWsContainer.class.isInstance(listener)) {
            ((CxfWsContainer)CxfWsContainer.class.cast(listener)).setWsldUrl(wsdl);
        }
    }

    private SoapTransportFactory newTransportFactory() {
        return !this.factoryByListener ? this.transportFactory : new SoapTransportFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpListener createEjbWsContainer(URL moduleBaseUrl, PortData port, BeanContext beanContext, ServiceConfiguration config) {
        Bus bus = CxfUtil.getBus();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            CxfCatalogUtils.loadOASISCatalog(bus, moduleBaseUrl, "META-INF/jax-ws-catalog.xml");
            EjbWsContainer container = new EjbWsContainer(bus, (DestinationFactory)this.newTransportFactory(), port, beanContext, config);
            container.start();
            this.wsContainers.put(beanContext.getDeploymentID().toString(), container);
            SystemInstance.get().fireEvent((Object)new ServerCreated((Server)container.getEndpoint().getServer(), beanContext.getModuleContext().getAppContext()));
            EjbWsContainer ejbWsContainer = container;
            return ejbWsContainer;
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpListener createPojoWsContainer(ClassLoader loader, URL moduleBaseUrl, PortData port, String serviceId, Class target, Context context, String contextRoot, Map<String, Object> bdgs, ServiceConfiguration services) {
        if (this.wsContainers.get(serviceId) != null) {
            return this.wsContainers.get(serviceId);
        }
        Bus bus = CxfUtil.getBus();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            CxfCatalogUtils.loadOASISCatalog(bus, moduleBaseUrl, "META-INF/jax-ws-catalog.xml");
            PojoWsContainer container = new PojoWsContainer(loader, (DestinationFactory)this.newTransportFactory(), bus, port, context, target, bdgs, services);
            container.start();
            this.wsContainers.put(serviceId, container);
            SystemInstance.get().fireEvent((Object)new ServerCreated((Server)container.getEndpoint().getServer(), (AppContext)AppFinder.findAppContextOrWeb((ClassLoader)loader, (AppFinder.Transformer)AppFinder.AppContextTransformer.INSTANCE)));
            PojoWsContainer pojoWsContainer = container;
            return pojoWsContainer;
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    protected void destroyPojoWsContainer(String serviceId) {
        this.destroyWsContainer(serviceId);
    }

    protected void destroyEjbWsContainer(String deploymentId) {
        this.destroyWsContainer(deploymentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyWsContainer(String serviceId) {
        CxfWsContainer container = this.wsContainers.remove(serviceId);
        if (container != null) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
            try {
                container.destroy();
                SystemInstance.get().fireEvent((Object)new ServerDestroyed((Server)container.getEndpoint().getServer()));
            }
            finally {
                if (oldLoader != null) {
                    CxfUtil.clearBusLoader((ClassLoader)oldLoader);
                }
            }
        }
    }
}

