/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import jakarta.resource.ResourceException;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;

public class ConnectionHandleInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;

    public ConnectionHandleInterceptor(ConnectionInterceptor next) {
        this.next = next;
    }

    @Override
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.next.getConnection(connectionInfo);
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        if (connectionInfo.getConnectionHandle() == null) {
            connectionInfo.setConnectionHandle(mci.getManagedConnection().getConnection(mci.getSubject(), mci.getConnectionRequestInfo()));
            mci.addConnectionHandle(connectionInfo);
        } else if (!mci.hasConnectionInfo(connectionInfo)) {
            mci.getManagedConnection().associateConnection(connectionInfo.getConnectionHandle());
            mci.addConnectionHandle(connectionInfo);
        }
        connectionInfo.setTrace();
    }

    @Override
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionInfo.getConnectionHandle() != null) {
            connectionInfo.getManagedConnectionInfo().removeConnectionHandle(connectionInfo);
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    @Override
    public void destroy() {
        this.next.destroy();
    }

    @Override
    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("\n");
        if (this.next == null) {
            s.append("<end>");
        } else {
            this.next.info(s);
        }
    }
}

