/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards;

import org.apache.sling.ide.eclipse.core.ISlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.SlingLaunchpadConfigurationDefaults;
import org.apache.sling.ide.eclipse.ui.internal.SlingLaunchpadCombo;
import org.apache.sling.ide.eclipse.ui.wizards.AbstractNewSlingApplicationWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class SetupServerWizardPage
extends WizardPage {
    private static final String RUNTIME_TYPE_LAUNCHPAD = "org.apache.sling.ide.launchpadRuntimeType";
    private static final String SERVER_TYPE_LAUNCHPAD = "org.apache.sling.ide.launchpadServer";
    private static final int HORIZONTAL_INDENT = 10;
    private Button useExistingServer;
    private SlingLaunchpadCombo existingServerCombo;
    private Button setupNewServer;
    private Text newServerName;
    private Text newServerHostnameName;
    private Text newServerPort;
    private Text newServerUsername;
    private Text newServerPassword;
    private Text newServerDebugPort;
    private IServer server;
    private Button startExistingServerButton;
    private Button skipServerConfiguration;
    private ISlingLaunchpadConfiguration config;

    public SetupServerWizardPage(AbstractNewSlingApplicationWizard parent) {
        super("chooseArchetypePage");
        this.setTitle("Select or Create Server");
        this.setDescription("This step defines which server to use with the new project.");
        this.setImageDescriptor(parent.getLogo());
        this.config = parent.getDefaultConfig();
    }

    public AbstractNewSlingApplicationWizard getWizard() {
        return (AbstractNewSlingApplicationWizard)super.getWizard();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.marginBottom = 10;
        GridDataFactory singleRowGridDataFactory = GridDataFactory.swtDefaults().align(16384, 0x1000000).span(layout.numColumns, 1);
        this.useExistingServer = new Button(container, 16);
        this.useExistingServer.setText("Add to existing server");
        singleRowGridDataFactory.applyTo((Control)this.useExistingServer);
        Label existingServerLabel = new Label(container, 0);
        GridData locationLabelData = new GridData();
        locationLabelData.horizontalIndent = 10;
        existingServerLabel.setLayoutData((Object)locationLabelData);
        existingServerLabel.setText("Location:");
        existingServerLabel.setEnabled(true);
        this.existingServerCombo = new SlingLaunchpadCombo(container, null);
        this.existingServerCombo.getWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SetupServerWizardPage.this.dialogChanged();
            }
        });
        this.existingServerCombo.refreshRepositoryList((IProgressMonitor)new NullProgressMonitor());
        this.existingServerCombo.getWidget().setEnabled(true);
        this.startExistingServerButton = new Button(container, 32);
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        gd.horizontalIndent = 10;
        this.startExistingServerButton.setLayoutData((Object)gd);
        this.startExistingServerButton.setText("Start server after project creation (if server not yet started).");
        this.startExistingServerButton.setSelection(true);
        this.skipServerConfiguration = new Button(container, 16);
        this.skipServerConfiguration.setText("Don't deploy on a server");
        singleRowGridDataFactory.applyTo((Control)this.skipServerConfiguration);
        this.setupNewServer = new Button(container, 16);
        this.setupNewServer.setText("Setup new server");
        singleRowGridDataFactory.applyTo((Control)this.setupNewServer);
        this.newLabel(container, "Server name:");
        this.newServerName = this.newText(container);
        this.newLabel(container, "Host name:");
        this.newServerHostnameName = this.newText(container);
        this.newServerHostnameName.setText("localhost");
        this.newLabel(container, "Port:");
        this.newServerPort = this.newText(container);
        this.newServerPort.setText(Integer.toString(this.config.getPort()));
        this.newLabel(container, "Username:");
        this.newServerUsername = this.newText(container);
        this.newServerUsername.setText(this.config.getUsername());
        this.newLabel(container, "Password:");
        this.newServerPassword = this.newText(container);
        this.newServerPassword.setText(this.config.getPassword());
        this.newLabel(container, "Debug Port:");
        this.newServerDebugPort = this.newText(container);
        this.newServerDebugPort.setText(Integer.toString(this.config.getDebugPort()));
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupServerWizardPage.this.updateEnablements();
                SetupServerWizardPage.this.dialogChanged();
            }
        };
        this.useExistingServer.addSelectionListener((SelectionListener)radioListener);
        this.setupNewServer.addSelectionListener((SelectionListener)radioListener);
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SetupServerWizardPage.this.dialogChanged();
            }
        };
        KeyListener kl = new KeyListener(){

            public void keyReleased(KeyEvent e) {
                SetupServerWizardPage.this.dialogChanged();
            }

            public void keyPressed(KeyEvent e) {
                SetupServerWizardPage.this.dialogChanged();
            }
        };
        this.newServerName.addModifyListener(ml);
        this.newServerName.addKeyListener(kl);
        this.newServerHostnameName.addModifyListener(ml);
        this.newServerHostnameName.addKeyListener(kl);
        this.newServerPort.addModifyListener(ml);
        this.newServerPort.addKeyListener(kl);
        this.newServerDebugPort.addModifyListener(ml);
        this.newServerDebugPort.addKeyListener(kl);
        this.useExistingServer.setSelection(this.existingServerCombo.hasServers());
        this.existingServerCombo.getWidget().setEnabled(this.existingServerCombo.hasServers());
        this.startExistingServerButton.setEnabled(this.existingServerCombo.hasServers());
        this.setupNewServer.setSelection(!this.existingServerCombo.hasServers());
        this.updateEnablements();
        this.setPageComplete(false);
        this.setControl((Control)container);
        if (this.useExistingServer.getSelection() && this.existingServerCombo.getErrorMessage(SlingLaunchpadCombo.ValidationFlag.SKIP_SERVER_STARTED) == null) {
            this.updateStatus(null);
        }
    }

    private Label newLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        GridData newServerPortLabelData = new GridData();
        newServerPortLabelData.horizontalIndent = 10;
        label.setLayoutData((Object)newServerPortLabelData);
        label.setEnabled(true);
        label.setText(text);
        return label;
    }

    private Text newText(Composite container) {
        Text text = new Text(container, 2048);
        text.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        return text;
    }

    private void dialogChanged() {
        if (this.getControl() == null) {
            return;
        }
        if (this.useExistingServer.getSelection()) {
            if (this.existingServerCombo.getErrorMessage(SlingLaunchpadCombo.ValidationFlag.SKIP_SERVER_STARTED) != null) {
                this.updateStatus(this.existingServerCombo.getErrorMessage(new SlingLaunchpadCombo.ValidationFlag[0]));
                return;
            }
        } else if (this.setupNewServer.getSelection() && (this.newServerName.getText().length() == 0 || this.getHostname().length() == 0 || this.newServerPort.getText().length() == 0 || this.newServerDebugPort.getText().length() == 0 || this.newServerUsername.getText().length() == 0 || this.newServerPassword.getText().length() == 0)) {
            this.updateStatus("Enter values for new server");
            return;
        }
        this.updateStatus(null);
    }

    private void updateEnablements() {
        this.existingServerCombo.getWidget().setEnabled(this.useExistingServer.getSelection());
        this.startExistingServerButton.setEnabled(this.useExistingServer.getSelection());
        this.newServerName.setEnabled(this.setupNewServer.getSelection());
        this.newServerHostnameName.setEnabled(this.setupNewServer.getSelection());
        this.newServerPort.setEnabled(this.setupNewServer.getSelection());
        this.newServerDebugPort.setEnabled(this.setupNewServer.getSelection());
        this.newServerUsername.setEnabled(this.setupNewServer.getSelection());
        this.newServerPassword.setEnabled(this.setupNewServer.getSelection());
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public boolean getStartServer() {
        if (!this.useExistingServer.getSelection()) {
            return true;
        }
        return this.startExistingServerButton.getSelection();
    }

    public IServer getOrCreateServer(IProgressMonitor monitor) throws CoreException {
        if (this.skipServerConfiguration.getSelection()) {
            return null;
        }
        if (this.server != null) {
            return this.server;
        }
        if (this.useExistingServer.getSelection()) {
            return this.existingServerCombo.getServer();
        }
        IServerType serverType = ServerCore.findServerType((String)SERVER_TYPE_LAUNCHPAD);
        IRuntime slingRuntime = this.getOrCreateSlingRuntime(monitor);
        try {
            IServerWorkingCopy wc = serverType.createServer(null, null, slingRuntime, monitor);
            wc.setHost(this.getHostname());
            wc.setName(this.newServerName.getText());
            wc.setAttribute("launchpad.port", this.getPort());
            wc.setAttribute("launchpad.debugPort", Integer.parseInt(this.newServerDebugPort.getText()));
            wc.setAttribute("launchpad.username", this.newServerUsername.getText());
            wc.setAttribute("launchpad.password", this.newServerPassword.getText());
            SlingLaunchpadConfigurationDefaults.applyDefaultValues((IServerWorkingCopy)wc);
            wc.setRuntime(slingRuntime);
            this.server = wc.save(true, monitor);
            return this.server;
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed creating the new server instance", (Throwable)e));
        }
    }

    private IRuntime getOrCreateSlingRuntime(IProgressMonitor monitor) throws CoreException {
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.getRuntimeType().getId().equals(RUNTIME_TYPE_LAUNCHPAD)) {
                return runtime;
            }
            ++n2;
        }
        IRuntimeType serverRuntime = ServerCore.findRuntimeType((String)RUNTIME_TYPE_LAUNCHPAD);
        return serverRuntime.createRuntime(null, monitor).createWorkingCopy().save(true, monitor);
    }

    private int getPort() {
        return Integer.parseInt(this.newServerPort.getText());
    }

    private String getHostname() {
        return this.newServerHostnameName.getText();
    }
}

